#include <linux/kernel.h>
#include <linux/amlogic/hdmi_tx/hdmi_common.h>

static struct hdmi_format_para fmt_para_1920x1080p60_16x9 = {
    .vic = HDMI_1920x1080p60_16x9,
    .name = "1920x1080p60hz",
    .pixel_repetition_factor = 0,
    .progress_mode = 1,
    .scrambler_en = 0,
    .tmds_clk_div40 = 0,
    .tmds_clk = 148500,
    .timing = {
        .pixel_freq = 148500,
        .h_freq = 67500,
        .v_freq = 60000,
        .vsync_polarity = 1,
        .hsync_polarity = 1,
        .h_active = 1920,
        .h_total = 2200,
        .h_blank = 280,
        .h_front = 88,
        .h_sync = 44,
        .h_back = 148,
        .v_active = 1080,
        .v_total = 1125,
        .v_blank = 45,
        .v_front = 4,
        .v_sync = 5,
        .v_back = 36,
        .v_sync_ln = 1,
    },
};

static struct hdmi_format_para fmt_para_1920x1080p50_16x9 = {
    .vic = HDMI_1920x1080p50_16x9,
    .name = "1920x1080p50hz",
    .pixel_repetition_factor = 0,
    .progress_mode = 1,
    .scrambler_en = 0,
    .tmds_clk_div40 = 0,
    .tmds_clk = 148500,
    .timing = {
        .pixel_freq = 148500,
        .h_freq = 56250,
        .v_freq = 50000,
        .vsync_polarity = 1,
        .hsync_polarity = 1,
        .h_active = 1920,
        .h_total = 2640,
        .h_blank = 720,
        .h_front = 528,
        .h_sync = 44,
        .h_back = 148,
        .v_active = 1080,
        .v_total = 1125,
        .v_blank = 45,
        .v_front = 4,
        .v_sync = 5,
        .v_back = 36,
        .v_sync_ln = 1,
    },
};

static struct hdmi_format_para fmt_para_1920x1080p24_16x9 = {
    .vic = HDMI_1920x1080p24_16x9,
    .name = "1920x1080p24hz",
    .pixel_repetition_factor = 0,
    .progress_mode = 1,
    .scrambler_en = 0,
    .tmds_clk_div40 = 0,
    .tmds_clk = 74250,
    .timing = {
        .pixel_freq = 74250,
        .h_freq = 27000,
        .v_freq = 24000,
        .vsync_polarity = 1,
        .hsync_polarity = 1,
        .h_active = 1920,
        .h_total = 2750,
        .h_blank = 830,
        .h_front = 638,
        .h_sync = 44,
        .h_back = 148,
        .v_active = 1080,
        .v_total = 1125,
        .v_blank = 45,
        .v_front = 4,
        .v_sync = 5,
        .v_back = 36,
        .v_sync_ln = 1,
    },
};

static struct hdmi_format_para fmt_para_3840x2160p30_16x9 = {
    .vic = HDMI_3840x2160p30_16x9,
    .name = "3840x2160p30hz",
    .pixel_repetition_factor = 0,
    .progress_mode = 1,
    .scrambler_en = 0,
    .tmds_clk_div40 = 0,
    .tmds_clk = 297000,
    .timing = {
        .pixel_freq = 297000,
        .h_freq = 67500,
        .v_freq = 30000,
        .vsync_polarity = 1,
        .hsync_polarity = 1,
        .h_active = 3840,
        .h_total = 4400,
        .h_blank = 560,
        .h_front = 176,
        .h_sync = 88,
        .h_back = 296,
        .v_active = 2160,
        .v_total = 2250,
        .v_blank = 90,
        .v_front = 8,
        .v_sync = 10,
        .v_back = 72,
        .v_sync_ln = 1,
    },
};

static struct hdmi_format_para fmt_para_3840x2160p60_16x9 = {
    .vic = HDMI_3840x2160p60_16x9,
    .name = "3840x2160p60hz",
    .pixel_repetition_factor = 0,
    .progress_mode = 1,
    .scrambler_en = 1,
    .tmds_clk_div40 = 1,
    .tmds_clk = 594000,
    .timing = {
        .pixel_freq = 594000,
        .h_freq = 135000,
        .v_freq = 60000,
        .vsync_polarity = 1,
        .hsync_polarity = 1,
        .h_active = 3840,
        .h_total = 4400,
        .h_blank = 560,
        .h_front = 176,
        .h_sync = 88,
        .h_back = 296,
        .v_active = 2160,
        .v_total = 2250,
        .v_blank = 90,
        .v_front = 8,
        .v_sync = 10,
        .v_back = 72,
        .v_sync_ln = 1,
    },
};

static struct hdmi_format_para fmt_para_3840x2160p50_16x9 = {
    .vic = HDMI_3840x2160p50_16x9,
    .name = "3840x2160p50hz",
    .pixel_repetition_factor = 0,
    .progress_mode = 1,
    .scrambler_en = 1,
    .tmds_clk_div40 = 1,
    .tmds_clk = 594000,
    .timing = {
        .pixel_freq = 594000,
        .h_freq = 112500,
        .v_freq = 50000,
        .vsync_polarity = 1,
        .hsync_polarity = 1,
        .h_active = 3840,
        .h_total = 5280,
        .h_blank = 1440,
        .h_front = 1056,
        .h_sync = 88,
        .h_back = 296,
        .v_active = 2160,
        .v_total = 2250,
        .v_blank = 90,
        .v_front = 8,
        .v_sync = 10,
        .v_back = 72,
        .v_sync_ln = 1,
    },
};

static struct hdmi_format_para fmt_para_3840x2160p25_16x9 = {
    .vic = HDMI_3840x2160p25_16x9,
    .name = "3840x2160p25hz",
    .pixel_repetition_factor = 0,
    .progress_mode = 1,
    .scrambler_en = 0,
    .tmds_clk_div40 = 0,
    .tmds_clk = 297000,
    .timing = {
        .pixel_freq = 297000,
        .h_freq = 56250,
        .v_freq = 25000,
        .vsync_polarity = 1,
        .hsync_polarity = 1,
        .h_active = 3840,
        .h_total = 5280,
        .h_blank = 1440,
        .h_front = 1056,
        .h_sync = 88,
        .h_back = 296,
        .v_active = 2160,
        .v_total = 2250,
        .v_blank = 90,
        .v_front = 8,
        .v_sync = 10,
        .v_back = 72,
        .v_sync_ln = 1,
    },
};

static struct hdmi_format_para fmt_para_3840x2160p24_16x9 = {
    .vic = HDMI_3840x2160p24_16x9,
    .name = "3840x2160p24hz",
    .pixel_repetition_factor = 0,
    .progress_mode = 1,
    .scrambler_en = 0,
    .tmds_clk_div40 = 0,
    .tmds_clk = 297000,
    .timing = {
        .pixel_freq = 297000,
        .h_freq = 54000,
        .v_freq = 24000,
        .vsync_polarity = 1,
        .hsync_polarity = 1,
        .h_active = 3840,
        .h_total = 5500,
        .h_blank = 1660,
        .h_front = 1276,
        .h_sync = 88,
        .h_back = 296,
        .v_active = 2160,
        .v_total = 2250,
        .v_blank = 90,
        .v_front = 8,
        .v_sync = 10,
        .v_back = 72,
        .v_sync_ln = 1,
    },
};

static struct hdmi_format_para fmt_para_4096x2160p24_256x135 = {
    .vic = HDMI_4096x2160p24_256x135,
    .name = "4096x2160p24hz",
    .pixel_repetition_factor = 0,
    .progress_mode = 1,
    .scrambler_en = 0,
    .tmds_clk_div40 = 0,
    .tmds_clk = 297000,
    .timing = {
        .pixel_freq = 297000,
        .h_freq = 54000,
        .v_freq = 24000,
        .vsync_polarity = 1,
        .hsync_polarity = 1,
        .h_active = 4096,
        .h_total = 5500,
        .h_blank = 1404,
        .h_front = 1020,
        .h_sync = 88,
        .h_back = 296,
        .v_active = 2160,
        .v_total = 2250,
        .v_blank = 90,
        .v_front = 8,
        .v_sync = 10,
        .v_back = 72,
        .v_sync_ln = 1,
    },
};

static struct hdmi_format_para fmt_para_1920x1080i60_16x9 = {
    .vic = HDMI_1920x1080i60_16x9,
    .name = "1920x1080i60hz",
    .pixel_repetition_factor = 0,
    .progress_mode = 0,
    .scrambler_en = 0,
    .tmds_clk_div40 = 0,
    .tmds_clk = 74250,
    .timing = {
        .pixel_freq = 74250,
        .h_freq = 33750,
        .v_freq = 60000,
        .vsync_polarity = 1,
        .hsync_polarity = 1,
        .h_active = 1920,
        .h_total = 2200,
        .h_blank = 280,
        .h_front = 88,
        .h_sync = 44,
        .h_back = 148,
        .v_active = 1080/2,
        .v_total = 1125,
        .v_blank = 45/2,
        .v_front = 2,
        .v_sync = 5,
        .v_back = 15,
        .v_sync_ln = 1,
    },
};

static struct hdmi_format_para fmt_para_1920x1080i50_16x9 = {
    .vic = HDMI_1920x1080i50_16x9,
    .name = "1920x1080i50hz",
    .pixel_repetition_factor = 0,
    .progress_mode = 0,
    .scrambler_en = 0,
    .tmds_clk_div40 = 0,
    .tmds_clk = 74250,
    .timing = {
        .pixel_freq = 74250,
        .h_freq = 28125,
        .v_freq = 50000,
        .vsync_polarity = 1,
        .hsync_polarity = 1,
        .h_active = 1920,
        .h_total = 2640,
        .h_blank = 720,
        .h_front = 528,
        .h_sync = 44,
        .h_back = 148,
        .v_active = 1080/2,
        .v_total = 1125,
        .v_blank = 45/2,
        .v_front = 2,
        .v_sync = 5,
        .v_back = 15,
        .v_sync_ln = 1,
    },
};

static struct hdmi_format_para fmt_para_1280x720p60_16x9 = {
    .vic = HDMI_1280x720p60_16x9,
    .name = "1280x720p60hz",
    .pixel_repetition_factor = 0,
    .progress_mode = 1,
    .scrambler_en = 0,
    .tmds_clk_div40 = 0,
    .tmds_clk = 74250,
    .timing = {
        .pixel_freq = 74250,
        .h_freq = 45000,
        .v_freq = 60000,
        .vsync_polarity = 1,
        .hsync_polarity = 1,
        .h_active = 1280,
        .h_total = 1650,
        .h_blank = 370,
        .h_front = 110,
        .h_sync = 40,
        .h_back = 220,
        .v_active = 720,
        .v_total = 750,
        .v_blank = 30,
        .v_front = 5,
        .v_sync = 5,
        .v_back = 20,
        .v_sync_ln = 1,
    },
};

static struct hdmi_format_para fmt_para_1280x720p50_16x9 = {
    .vic = HDMI_1280x720p50_16x9,
    .name = "1280x720p50hz",
    .pixel_repetition_factor = 0,
    .progress_mode = 1,
    .scrambler_en = 0,
    .tmds_clk_div40 = 0,
    .tmds_clk = 74250,
    .timing = {
        .pixel_freq = 74250,
        .h_freq = 37500,
        .v_freq = 50000,
        .vsync_polarity = 1,
        .hsync_polarity = 1,
        .h_active = 1280,
        .h_total = 1980,
        .h_blank = 700,
        .h_front = 440,
        .h_sync = 40,
        .h_back = 220,
        .v_active = 720,
        .v_total = 750,
        .v_blank = 30,
        .v_front = 5,
        .v_sync = 5,
        .v_back = 20,
        .v_sync_ln = 1,
    },
};

static struct hdmi_format_para fmt_para_720x480p60_16x9 = {
    .vic = HDMI_720x480p60_16x9,
    .name = "720x480p60hz",
    .pixel_repetition_factor = 0,
    .progress_mode = 1,
    .scrambler_en = 0,
    .tmds_clk_div40 = 0,
    .tmds_clk = 27000,
    .timing = {
        .pixel_freq = 27000,
        .h_freq = 31469,
        .v_freq = 59940,
        .vsync_polarity = 0,
        .hsync_polarity = 0,
        .h_active = 720,
        .h_total = 858,
        .h_blank = 138,
        .h_front = 16,
        .h_sync = 62,
        .h_back = 60,
        .v_active = 480,
        .v_total = 525,
        .v_blank = 45,
        .v_front = 9,
        .v_sync = 6,
        .v_back = 30,
        .v_sync_ln = 7,
    },
};

static struct hdmi_format_para fmt_para_720x480i60_16x9 = {
    .vic = HDMI_720x480i60_16x9,
    .name = "720x480i60hz",
    .pixel_repetition_factor = 1,
    .progress_mode = 0,
    .scrambler_en = 0,
    .tmds_clk_div40 = 0,
    .tmds_clk = 27000,
    .timing = {
        .pixel_freq = 27000,
        .h_freq = 15734,
        .v_freq = 59940,
        .vsync_polarity = 0,
        .hsync_polarity = 0,
        .h_active = 1440,
        .h_total = 1716,
        .h_blank = 276,
        .h_front = 38,
        .h_sync = 124,
        .h_back = 114,
        .v_active = 480/2,
        .v_total = 525,
        .v_blank = 45/2,
        .v_front = 4,
        .v_sync = 3,
        .v_back = 15,
        .v_sync_ln = 4,
    },
};

static struct hdmi_format_para fmt_para_720x576p50_16x9 = {
    .vic = HDMI_720x576p50_16x9,
    .name = "720x576p50hz",
    .pixel_repetition_factor = 0,
    .progress_mode = 1,
    .scrambler_en = 0,
    .tmds_clk_div40 = 0,
    .tmds_clk = 27000,
    .timing = {
        .pixel_freq = 27000,
        .h_freq = 31250,
        .v_freq = 50000,
        .vsync_polarity = 0,
        .hsync_polarity = 0,
        .h_active = 720,
        .h_total = 864,
        .h_blank = 144,
        .h_front = 12,
        .h_sync = 64,
        .h_back = 68,
        .v_active = 576,
        .v_total = 625,
        .v_blank = 49,
        .v_front = 5,
        .v_sync = 5,
        .v_back = 39,
        .v_sync_ln = 1,
    },
};

static struct hdmi_format_para fmt_para_720x576i50_16x9 = {
    .vic = HDMI_720x576i50_16x9,
    .name = "720x576i50hz",
    .pixel_repetition_factor = 1,
    .progress_mode = 0,
    .scrambler_en = 0,
    .tmds_clk_div40 = 0,
    .tmds_clk = 27000,
    .timing = {
        .pixel_freq = 27000,
        .h_freq = 15625,
        .v_freq = 50000,
        .vsync_polarity = 0,
        .hsync_polarity = 0,
        .h_active = 1440,
        .h_total = 1728,
        .h_blank = 288,
        .h_front = 24,
        .h_sync = 126,
        .h_back = 138,
        .v_active = 576/2,
        .v_total = 625,
        .v_blank = 49/2,
        .v_front = 2,
        .v_sync = 3,
        .v_back = 19,
        .v_sync_ln = 1,
    },
};

static struct hdmi_format_para fmt_para_3840x1080p120_16x9 = {
    .vic = HDMI_3840x1080p120hz,
    .name = "3840x1080p120hz",
    .pixel_repetition_factor = 0,
    .progress_mode = 1,
    .scrambler_en = 1,
    .tmds_clk_div40 = 1,
    .tmds_clk = 594000,
    .timing = {
        .pixel_freq = 594000,
        .h_freq = 135000,
        .v_freq = 120000,
        .vsync_polarity = 1,
        .hsync_polarity = 1,
        .h_active = 3840,
        .h_total = 4400,
        .h_blank = 560,
        .h_front = 176,
        .h_sync = 88,
        .h_back = 296,
        .v_active = 1080,
        .v_total = 1125,
        .v_blank = 45,
        .v_front = 4,
        .v_sync = 5,
        .v_back = 36,
        .v_sync_ln = 1,
    },
};

static struct hdmi_format_para fmt_para_3840x1080p100_16x9 = {
    .vic = HDMI_3840x1080p100hz,
    .name = "3840x1080p100hz",
    .pixel_repetition_factor = 0,
    .progress_mode = 1,
    .scrambler_en = 1,
    .tmds_clk_div40 = 1,
    .tmds_clk = 594000,
    .timing = {
        .pixel_freq = 594000,
        .h_freq = 112500,
        .v_freq = 50000,
        .vsync_polarity = 1,
        .hsync_polarity = 1,
        .h_active = 3840,
        .h_total = 5280,
        .h_blank = 1440,
        .h_front = 1056,
        .h_sync = 88,
        .h_back = 296,
        .v_active = 1080,
        .v_total = 1125,
        .v_blank = 45,
        .v_front = 4,
        .v_sync = 5,
        .v_back = 36,
        .v_sync_ln = 1,
    },
};

static struct hdmi_format_para fmt_para_3840x540p240_16x9 = {
    .vic = HDMI_3840x540p240hz,
    .name = "3840x540p240hz",
    .pixel_repetition_factor = 0,
    .progress_mode = 1,
    .scrambler_en = 1,
    .tmds_clk_div40 = 1,
    .tmds_clk = 594000,
    .timing = {
        .pixel_freq = 594000,
        .h_freq = 135000,
        .v_freq = 120000,
        .vsync_polarity = 1,
        .hsync_polarity = 1,
        .h_active = 3840,
        .h_total = 4400,
        .h_blank = 560,
        .h_front = 176,
        .h_sync = 88,
        .h_back = 296,
        .v_active = 540,
        .v_total = 562,
        .v_blank = 22,
        .v_front = 2,
        .v_sync = 2,
        .v_back = 18,
        .v_sync_ln = 1,
    },
};

static struct hdmi_format_para fmt_para_3840x540p200_16x9 = {
    .vic = HDMI_3840x1080p100hz,
    .name = "3840x1080p200hz",
    .pixel_repetition_factor = 0,
    .progress_mode = 1,
    .scrambler_en = 1,
    .tmds_clk_div40 = 1,
    .tmds_clk = 594000,
    .timing = {
        .pixel_freq = 594000,
        .h_freq = 112500,
        .v_freq = 50000,
        .vsync_polarity = 1,
        .hsync_polarity = 1,
        .h_active = 3840,
        .h_total = 5280,
        .h_blank = 1440,
        .h_front = 1056,
        .h_sync = 88,
        .h_back = 296,
        .v_active = 540,
        .v_total = 562,
        .v_blank = 22,
        .v_front = 2,
        .v_sync = 2,
        .v_back = 18,
        .v_sync_ln = 1,
    },
};

static struct hdmi_format_para *all_fmt_paras[] = {
    &fmt_para_3840x2160p60_16x9,
    &fmt_para_3840x2160p50_16x9,
    &fmt_para_3840x2160p30_16x9,
    &fmt_para_3840x2160p25_16x9,
    &fmt_para_3840x2160p24_16x9,
    &fmt_para_4096x2160p24_256x135,
    &fmt_para_1920x1080p50_16x9,
    &fmt_para_1920x1080p60_16x9,
    &fmt_para_1920x1080p24_16x9,
    &fmt_para_1920x1080i60_16x9,
    &fmt_para_1920x1080i50_16x9,
    &fmt_para_1280x720p60_16x9,
    &fmt_para_1280x720p50_16x9,
    &fmt_para_720x480p60_16x9,
    &fmt_para_720x480i60_16x9,
    &fmt_para_720x576p50_16x9,
    &fmt_para_720x576i50_16x9,
    &fmt_para_3840x1080p100_16x9,
    &fmt_para_3840x1080p120_16x9,
    &fmt_para_3840x540p200_16x9,
    &fmt_para_3840x540p240_16x9,
};

struct hdmi_format_para * hdmi_get_fmt_paras(HDMI_Video_Codes_t vic)
{
    int i;
    for(i = 0; i < sizeof(all_fmt_paras) / sizeof(struct hdmi_format_para*); i++) {
        if(vic == all_fmt_paras[i]->vic)
            return all_fmt_paras[i];
    }
    return NULL;
}

// For check all format parameters only
void check_detail_fmt(void)
{
    int i;
    struct hdmi_format_para * p;
    struct hdmi_cea_timing * t;
    printk("VIC Hactive Vactive I/P Htotal Hblank Vtotal Vblank Hfreq Vfreq Pfreq\n");
    for(i = 0; i < sizeof(all_fmt_paras) / sizeof(struct hdmi_format_para*); i++) {
        p = all_fmt_paras[i];
        t = &p->timing;
        printk("%s[%d] %d %d %c %d %d %d %d %d %d %d\n", all_fmt_paras[i]->name, all_fmt_paras[i]->vic,
                t->h_active, t->v_active, (p->progress_mode) ? 'P' : 'I',
                t->h_total, t->h_blank, t->v_total, t->v_blank,
                t->h_freq, t->v_freq, t->pixel_freq);
    }

    printk("\nVIC Hfront Hsync Hback Hpol Vfront Vsync Vback Vpol Ln\n");
    for(i = 0; i < sizeof(all_fmt_paras) / sizeof(struct hdmi_format_para*); i++) {
        p = all_fmt_paras[i];
        t = &p->timing;
        printk("%s[%d] %d %d %d %c %d %d %d %c %d\n", all_fmt_paras[i]->name, all_fmt_paras[i]->vic,
                t->h_front, t->h_sync, t->h_back, (t->hsync_polarity) ? 'P' : 'N',
                t->v_front, t->v_sync, t->v_back, (t->vsync_polarity) ? 'P' : 'N',
                t->v_sync_ln);
    }

    printk("\nCheck Horizon parameter\n");
    for(i = 0; i < sizeof(all_fmt_paras) / sizeof(struct hdmi_format_para*); i++) {
        p = all_fmt_paras[i];
        t = &p->timing;
        if(t->h_total != (t->h_active + t->h_blank))
            printk("VIC[%d] Ht[%d] != (Ha[%d] + Hb[%d])\n", all_fmt_paras[i]->vic,
                   t->h_total, t->h_active, t->h_blank);
        if(t->h_blank != (t->h_front + t->h_sync + t->h_back))
            printk("VIC[%d] Hb[%d] != (Hf[%d] + Hs[%d] + Hb[%d])\n", all_fmt_paras[i]->vic, t->h_blank,
                    t->h_front, t->h_sync, t->h_back);
    }

    printk("\nCheck Vertical parameter\n");
    for(i = 0; i < sizeof(all_fmt_paras) / sizeof(struct hdmi_format_para*); i++) {
        p = all_fmt_paras[i];
        t = &p->timing;
        if(t->v_total != (t->v_active + t->v_blank))
            printk("VIC[%d] Vt[%d] != (Va[%d] + Vb[%d]\n", all_fmt_paras[i]->vic,
                   t->v_total, t->v_active, t->v_blank);
        if((t->v_blank != (t->v_front + t->v_sync + t->v_back)) & (p->progress_mode == 1))
            printk("VIC[%d] Vb[%d] != (Vf[%d] + Vs[%d] + Vb[%d])\n", all_fmt_paras[i]->vic, t->v_blank,
                    t->v_front, t->v_sync, t->v_back);
        if((t->v_blank/2 != (t->v_front + t->v_sync + t->v_back)) & (p->progress_mode == 0))
            printk("VIC[%d] Vb[%d] != (Vf[%d] + Vs[%d] + Vb[%d])\n", all_fmt_paras[i]->vic, t->v_blank,
                    t->v_front, t->v_sync, t->v_back);
    }
}

struct hdmi_audio_fs_fmt_n_cts aud_32k_para = {
    .array[0] = {
        .tmds_clk = 25174,
        .n = 4576,
        .cts = 28125,
    },
    .array[1] = {
        .tmds_clk = 74176,
        .n = 11648,
        .cts = 210937,
    },
    .array[2] = {
        .tmds_clk = 148352,
        .n = 11648,
        .cts = 421875,
    },
    .array[3] = {
        .tmds_clk = 296703,
        .n = 5824,
        .cts = 421875,
    },
    .array[4] = {
        .tmds_clk = 297000,
        .n = 3072,
        .cts = 222750,
    },
    .def_n = 4096,
};

static struct hdmi_audio_fs_fmt_n_cts *all_aud_paras [] = {
    NULL,
    &aud_32k_para,
};

unsigned int hdmi_get_aud_n_paras(audio_fs_t fs, unsigned int tmds_clk)
{
    struct hdmi_audio_fs_fmt_n_cts *p = NULL;
    unsigned int i;

    p = all_aud_paras[fs];
    for(i = 0; i < AUDIO_PARA_MAX_NUM; i++) {
        if(tmds_clk == p->array[i].tmds_clk)
            break;
    }

    if((i < AUDIO_PARA_MAX_NUM) && (p->array[i].n))
        return p->array[i].n;
    else
        return p->def_n;
}
