/*
 * Silicon labs amlogic Atvdemod Device Driver
 *
 * Author: dezhi kong <dezhi.kong@amlogic.com>
 *
 *
 * Copyright (C) 2014 Amlogic Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */
#include <mach/am_regs.h>

/* Standard Liniux Headers */
#include <linux/module.h>
#include <linux/i2c.h>
#include <linux/delay.h>
#include <linux/timer.h>
#include <linux/mutex.h>
#include <linux/interrupt.h>
#include <linux/time.h>

#include "atvdemod_func.h"

static int broad_std = AML_ATV_DEMOD_VIDEO_MODE_PROP_NTSC;
module_param(broad_std, int, 0644);
MODULE_PARM_DESC(broad_std, "\n broad_std\n");

static unsigned int if_freq = 4250000;//PAL-DK:3250000;NTSC-M:4250000
module_param(if_freq, uint, 0644);
MODULE_PARM_DESC(if_freq, "\n if_freq\n");

static int if_inv = 0;
module_param(if_inv, int, 0644);
MODULE_PARM_DESC(if_inv, "\n if_inv\n");

static int gde_curve = 0;
module_param(gde_curve, int, 0644);
MODULE_PARM_DESC(gde_curve, "\n gde_curve\n");

static int sound_format = 0;
module_param(sound_format, int, 0644);
MODULE_PARM_DESC(sound_format, "\n sound_format\n");

static unsigned int freq_hz_cvrt = AML_ATV_DEMOD_FREQ_60HZ_VERT;
module_param(freq_hz_cvrt, int, 0644);
MODULE_PARM_DESC(freq_hz_cvrt, "\n freq_hz\n");

int atvdemod_debug_en = 0;
module_param(atvdemod_debug_en, int, 0644);
MODULE_PARM_DESC(atvdemod_debug_en, "\n atvdemod_debug_en\n");

/*1:gpio mode output low;2:pwm mode*/
static unsigned int atvdemod_agc_pinmux = 2;
module_param(atvdemod_agc_pinmux, int, 0644);
MODULE_PARM_DESC(atvdemod_agc_pinmux, "\n atvdemod_agc_pinmux\n");

static unsigned int atvdemod_afc_range = 5;
module_param(atvdemod_afc_range, uint, 0644);
MODULE_PARM_DESC(atvdemod_afc_range, "\n atvdemod_afc_range\n");

static unsigned int atvdemod_afc_offset = 500;
module_param( atvdemod_afc_offset, uint, 0644) ; 
MODULE_PARM_DESC( atvdemod_afc_offset, "\n atvdemod_afc_offset\n");

static unsigned int atvdemod_timer_en = 1;
module_param( atvdemod_timer_en, uint, 0644);
MODULE_PARM_DESC( atvdemod_afc_offset, "\n atvdemod_afc_offset\n");

static unsigned int mix1_freq = 0;
static unsigned int timer_init_flag = 0;
extern struct amlatvdemod_device_s *amlatvdemod_devp;

void atv_dmd_wr_reg(unsigned long addr, unsigned long data)
{
    //unsigned long data_tmp;
    *((volatile unsigned long *) (ATV_DMD_APB_BASE_ADDR+(addr<<2))) = data;
}

unsigned long atv_dmd_rd_reg(unsigned long addr)
{
    unsigned long data;
    data = *((volatile unsigned long *) (ATV_DMD_APB_BASE_ADDR+(addr<<2)));
    return (data);
}

unsigned long atv_dmd_rd_byte(unsigned long block_addr, unsigned long reg_addr)
{
	unsigned long data;
	data = atv_dmd_rd_long(block_addr, reg_addr);//R_APB_REG((((block_addr & 0xff) <<6) + ((reg_addr & 0xff) >>2)) << 2);//*((volatile unsigned long *) (ATV_DMD_APB_BASE_ADDR+((((block_addr & 0xff) <<6) + ((reg_addr & 0xff) >>2)) << 2)));
	if ((reg_addr & 0x3) == 0)
		data = data >> 24;
	else if ((reg_addr & 0x3) == 1)
		data = (data >> 16 & 0xff);
	else if ((reg_addr & 0x3) == 2)
		data = (data >> 8 & 0xff);
	else if ((reg_addr & 0x3) == 3)
		data = (data >> 0 & 0xff);
	return (data);
}

unsigned long atv_dmd_rd_word(unsigned long block_addr, unsigned long reg_addr)
{
    unsigned long data;
    data = atv_dmd_rd_long(block_addr, reg_addr);//R_APB_REG((((block_addr & 0xff) <<6) + ((reg_addr & 0xff) >>2)) << 2);//*((volatile unsigned long *) (ATV_DMD_APB_BASE_ADDR+((((block_addr & 0xff) <<6) + ((reg_addr & 0xff) >>2)) << 2)));
    if ((reg_addr & 0x3) == 0)
        data = data >> 16;
    else if ((reg_addr & 0x3) == 1)
        data = (data >> 8 & 0xffff);
    else if ((reg_addr & 0x3) == 2)
        data = (data >> 0 & 0xffff);
    else if ((reg_addr & 0x3) == 3)
        data = (((data & 0xff) << 8) |  ((data >> 24) & 0xff));
    return (data);
}

unsigned long atv_dmd_rd_long(unsigned long block_addr, unsigned long reg_addr)
{
    unsigned long data;
    //data = *((volatile unsigned long *) (ATV_DMD_APB_BASE_ADDR+((((block_addr & 0xff) <<6) + ((reg_addr & 0xff) >>2)) << 2)));
    data = R_APB_REG(((((block_addr & 0xff) <<6) + ((reg_addr & 0xff) >>2))+0x2000)<<2);

	return (data);
}

void atv_dmd_wr_long(unsigned long block_addr, unsigned long reg_addr, unsigned long data)
{
	W_APB_REG(((((block_addr & 0xff) <<6) + ((reg_addr & 0xff) >>2))+0x2000)<<2, data);
	//printk("block_addr:0x%x,reg_addr:0x%x;data:0x%x\n",(unsigned int)block_addr,(unsigned int)reg_addr,(unsigned int)data);
    //*((volatile unsigned long *) (ATV_DMD_APB_BASE_ADDR+((((block_addr & 0xff) <<6) + ((reg_addr & 0xff) >>2)) << 2))) = data;

}

void atv_dmd_wr_word(unsigned long block_addr, unsigned long reg_addr, unsigned long data)
{
	unsigned long data_tmp;
	data_tmp = atv_dmd_rd_long(block_addr, reg_addr);
	data = data & 0xffff;
	if ((reg_addr & 0x3) == 0)
		data = (data << 16 | (data_tmp & 0xffff));
	else if ((reg_addr & 0x3) == 1)
		data = ((data_tmp & 0xff000000) | (data << 8) | (data_tmp & 0xff));
	else if ((reg_addr & 0x3) == 2)
		data = (data | (data_tmp & 0xffff0000));
	else if ((reg_addr & 0x3) == 3)
		data = (((data & 0xff) << 24) | ((data_tmp & 0xffff0000) >> 8) | ((data & 0xff00) >> 8));

    //*((volatile unsigned long *) (ATV_DMD_APB_BASE_ADDR+((((block_addr & 0xff) <<6) + ((reg_addr & 0xff) >>2)) << 2))) = data;
    atv_dmd_wr_long(block_addr, reg_addr, data);//W_APB_REG(((((block_addr & 0xff) <<6) + ((reg_addr & 0xff) >>2)) << 2), data);

}

void atv_dmd_wr_byte(unsigned long block_addr, unsigned long reg_addr, unsigned long data)
{
    unsigned long data_tmp;
    data_tmp = atv_dmd_rd_long(block_addr, reg_addr);

	//pr_info("atv demod wr byte, read block addr %lx\n",block_addr);
	//pr_info("atv demod wr byte, read reg addr %lx\n", reg_addr);
	//pr_info("atv demod wr byte, wr data %lx\n",data);
	//pr_info("atv demod wr byte, read data out %lx\n",data_tmp);

    data = data & 0xff;
	//pr_info("atv demod wr byte, data & 0xff %lx\n",data);
    if ((reg_addr & 0x3) == 0) {
        data = (data << 24 | (data_tmp & 0xffffff));
		//pr_info("atv demod wr byte, reg_addr & 0x3 == 0, wr data %lx\n",data);
	}
    else if ((reg_addr & 0x3) == 1)
        data = ((data_tmp & 0xff000000) | (data << 16) | (data_tmp & 0xffff));
    else if ((reg_addr & 0x3) == 2)
        data = ((data_tmp & 0xffff0000) | (data << 8) | (data_tmp & 0xff));
    else if ((reg_addr & 0x3) == 3)
        data = ((data_tmp & 0xffffff00) | (data & 0xff));

	//pr_info("atv demod wr byte, wr data %lx\n",data);

    //*((volatile unsigned long *) (ATV_DMD_APB_BASE_ADDR+((((block_addr & 0xff) <<6) + ((reg_addr & 0xff) >>2)) << 2))) = data;
    atv_dmd_wr_long(block_addr, reg_addr, data);//W_APB_REG(((((block_addr & 0xff) <<6) + ((reg_addr & 0xff) >>2)) << 2), data);
}

void atv_dmd_soft_reset(void)
{
	atv_dmd_wr_byte(APB_BLOCK_ADDR_SYSTEM_MGT,0x0,0x0);
	atv_dmd_wr_byte(APB_BLOCK_ADDR_SYSTEM_MGT,0x0,0x1);
}

void atv_dmd_input_clk_32m(void)
{
	atv_dmd_wr_byte(APB_BLOCK_ADDR_ADC_MGR,0x2,0x1);
}
void read_version_register(void)
{
  unsigned long data, Byte1, Byte2, Word;

  pr_info("ATV-DMD read version register\n");
  Byte1 = atv_dmd_rd_byte(APB_BLOCK_ADDR_VERS_REGISTER,0x0);
  Byte2 = atv_dmd_rd_byte(APB_BLOCK_ADDR_VERS_REGISTER,0x1);
  Word = atv_dmd_rd_word(APB_BLOCK_ADDR_VERS_REGISTER,0x2);
  data = atv_dmd_rd_long(APB_BLOCK_ADDR_VERS_REGISTER,0x0);

	pr_info("atv demod read version register data out %lx\n",data);

  if ((data!=0x516EAB13) || (((Byte1 << 24) | (Byte2  << 16)  | Word)!=0x516EAB13))
	pr_info("atv demod read version reg failed\n");
}

void check_communication_interface(void)
{
	unsigned long data_tmp;

	pr_info("ATV-DMD check communication intf\n");
	atv_dmd_wr_long(APB_BLOCK_ADDR_VERS_REGISTER,0x0,0xA1B2C3D4);
    atv_dmd_wr_byte(APB_BLOCK_ADDR_VERS_REGISTER,0x1,0x34);
    atv_dmd_wr_word(APB_BLOCK_ADDR_VERS_REGISTER,0x2,0xBCDE);
	data_tmp = atv_dmd_rd_long(APB_BLOCK_ADDR_VERS_REGISTER,0x0);
	pr_info("atv demod check communication intf data out %lx\n",data_tmp);

	if (data_tmp != 0xa134bcde)
		pr_info("atv demod check communication intf failed\n");
    atv_dmd_wr_long(APB_BLOCK_ADDR_VERS_REGISTER,0x0,0x516EAB13);
}

void power_on_receiver(void)
{
	atv_dmd_wr_byte(APB_BLOCK_ADDR_ADC_MGR,0x2,0x11);
}

void atv_dmd_misc(void)
{
    atv_dmd_wr_byte(0x18,0x08,0x38);//zhuangwei
    //cpu.write_byte(8'h1A,8'h0E,8'h06);//zhuangwei
    //cpu.write_byte(8'h19,8'h01,8'h7f);//zhuangwei
    atv_dmd_wr_byte(0x0f,0x45,0x90);//zhuangwei

    atv_dmd_wr_long(0x0f,0x44,0x5c8808c1);//zhuangwei
    atv_dmd_wr_long(0x0f,0x3c,0x88188832);//zhuangwei
    atv_dmd_wr_long(0x18,0x08,0x46170200);//zhuangwei
    atv_dmd_wr_long(0x0c,0x04,0xc8fa0000);//zhuangwei//0xdafa0000
    atv_dmd_wr_long(0x0c,0x00,0x554000);//zhuangwei
    atv_dmd_wr_long(0x19,0x04,0xdafa0000);//zhuangwei
    atv_dmd_wr_long(0x19,0x00,0x4a4000);//zhuangwei
    //atv_dmd_wr_byte(0x0c,0x01,0x28);//pwd-out gain
    //atv_dmd_wr_byte(0x0c,0x04,0xc0);//pwd-out offset
}
//Broadcast_Standard
//			0: NTSC
//			1: NTSC-J
//			2: PAL-M,
//			3: PAL-BG
//			4: DTV
//			5: SECAM- DK2
//			6: SECAM -DK3
//			7: PAL-BG, NICAM
//			8: PAL-DK-CHINA
//			9: SECAM-L / SECAM-DK3
//			10: PAL-I
//			11: PAL-DK1
//GDE_Curve
//			0: CURVE-M
//			1: CURVE-A
//			2: CURVE-B
//			3: CURVE-CHINA
//			4: BYPASS
//sound format 0: MONO;1:NICAM
void configure_receiver(int Broadcast_Standard, unsigned int Tuner_IF_Frequency, int Tuner_Input_IF_inverted, int GDE_Curve, int sound_format)
{
	int tmp_int;
	int mixer1 = 0;
	int mixer3 = 0;
	int mixer3_bypass = 0;
	int cv = 0;
	//int if_freq = 0;

	int i = 0;
	int super_coef0 = 0;
	int super_coef1 = 0;
	int super_coef2 = 0;
	int gp_coeff_1[37];
	int gp_coeff_2[37];
	int gp_cv_g1 = 0;
	int gp_cv_g2 = 0;
	int crvy_reg_1 = 0;
	int crvy_reg_2 = 0;
	int sif_co_mx = 0;
	int sif_fi_mx = 0;
	int sif_ic_bw = 0;
	int sif_bb_bw = 0;
	int sif_deemp = 0;
	int sif_cfg_demod = 0;
	int sif_fm_gain = 0;
	int gd_coeff[6];
	int gd_bypass;

	pr_info("ATV-DMD configure receiver register\n");

 	if ((Broadcast_Standard==0) | (Broadcast_Standard==1) | (Broadcast_Standard==2)){
		gp_coeff_1[          0] = 0x57777;
		gp_coeff_1[          1] = 0xdd777;
		gp_coeff_1[          2] = 0x7d777;
		gp_coeff_1[          3] = 0x75777;
		gp_coeff_1[          4] = 0x75777;
		gp_coeff_1[          5] = 0x7c777;
		gp_coeff_1[          6] = 0x5c777;
		gp_coeff_1[          7] = 0x44777;
		gp_coeff_1[          8] = 0x54777;
		gp_coeff_1[          9] = 0x47d77;
		gp_coeff_1[         10] = 0x55d77;
		gp_coeff_1[         11] = 0x55577;
		gp_coeff_1[         12] = 0x77577;
		gp_coeff_1[         13] = 0xc4c77;
		gp_coeff_1[         14] = 0xd7d77;
		gp_coeff_1[         15] = 0x75477;
		gp_coeff_1[         16] = 0xcc477;
		gp_coeff_1[         17] = 0x575d7;
		gp_coeff_1[         18] = 0xc4c77;
		gp_coeff_1[         19] = 0xdd757;
		gp_coeff_1[         20] = 0xdd477;
		gp_coeff_1[         21] = 0x77dd7;
		gp_coeff_1[         22] = 0x5dc77;
		gp_coeff_1[         23] = 0x47c47;
		gp_coeff_1[         24] = 0x57477;
		gp_coeff_1[         25] = 0x5c7c7;
		gp_coeff_1[         26] = 0xccc77;
		gp_coeff_1[         27] = 0x5ddd5;
		gp_coeff_1[         28] = 0x54477;
		gp_coeff_1[         29] = 0x7757d;
		gp_coeff_1[         30] = 0x755d7;
		gp_coeff_1[         31] = 0x47cc4;
		gp_coeff_1[         32] = 0x57d57;
		gp_coeff_1[         33] = 0x554cc;
		gp_coeff_1[         34] = 0x755d7;
		gp_coeff_1[         35] = 0x7d3b2;
		gp_coeff_1[         36] = 0x73a91;
		gp_coeff_2[          0] = 0xd5777;
		gp_coeff_2[          1] = 0x77777;
		gp_coeff_2[          2] = 0x7c777;
		gp_coeff_2[          3] = 0xcc777;
		gp_coeff_2[          4] = 0xc7777;
		gp_coeff_2[          5] = 0xdd777;
		gp_coeff_2[          6] = 0x44c77;
		gp_coeff_2[          7] = 0x54c77;
		gp_coeff_2[          8] = 0xdd777;
		gp_coeff_2[          9] = 0x7c777;
		gp_coeff_2[         10] = 0xc7c77;
		gp_coeff_2[         11] = 0x75c77;
		gp_coeff_2[         12] = 0xdd577;
		gp_coeff_2[         13] = 0x44777;
		gp_coeff_2[         14] = 0xd5c77;
		gp_coeff_2[         15] = 0xdc777;
		gp_coeff_2[         16] = 0xd7757;
		gp_coeff_2[         17] = 0x4c757;
		gp_coeff_2[         18] = 0x7d777;
		gp_coeff_2[         19] = 0x75477;
		gp_coeff_2[         20] = 0x57547;
		gp_coeff_2[         21] = 0xdc747;
		gp_coeff_2[         22] = 0x74777;
		gp_coeff_2[         23] = 0x75757;
		gp_coeff_2[         24] = 0x4cc75;
		gp_coeff_2[         25] = 0xd4747;
		gp_coeff_2[         26] = 0x7d7d7;
		gp_coeff_2[         27] = 0xd5577;
		gp_coeff_2[         28] = 0xc4c75;
		gp_coeff_2[         29] = 0xcc477;
		gp_coeff_2[         30] = 0xdd54c;
		gp_coeff_2[         31] = 0x7547d;
		gp_coeff_2[         32] = 0x55547;
		gp_coeff_2[         33] = 0x5575c;
		gp_coeff_2[         34] = 0xd543a;
		gp_coeff_2[         35] = 0x57b3a;
		gp_coeff_2[         36] = 0x77777;
		gp_cv_g1 = 0x2b062d;
		gp_cv_g2 = 0x40fa2d;
}
else if ((Broadcast_Standard==3) | (Broadcast_Standard==5) | (Broadcast_Standard==6) | (Broadcast_Standard==7)) {
		gp_coeff_1[          0] = 0x75777;
		gp_coeff_1[          1] = 0x57777;
		gp_coeff_1[          2] = 0x7d777;
		gp_coeff_1[          3] = 0x75777;
		gp_coeff_1[          4] = 0x75777;
		gp_coeff_1[          5] = 0x7c777;
		gp_coeff_1[          6] = 0x47777;
		gp_coeff_1[          7] = 0x74777;
		gp_coeff_1[          8] = 0xd5d77;
		gp_coeff_1[          9] = 0xc7777;
		gp_coeff_1[         10] = 0x77577;
		gp_coeff_1[         11] = 0xd7d77;
		gp_coeff_1[         12] = 0x75d77;
		gp_coeff_1[         13] = 0xdd477;
		gp_coeff_1[         14] = 0x77d77;
		gp_coeff_1[         15] = 0x75c77;
		gp_coeff_1[         16] = 0xc4477;
		gp_coeff_1[         17] = 0x4c777;
		gp_coeff_1[         18] = 0x5d5d7;
		gp_coeff_1[         19] = 0xd7d57;
		gp_coeff_1[         20] = 0x47577;
		gp_coeff_1[         21] = 0xd7dd7;
		gp_coeff_1[         22] = 0xd7d57;
		gp_coeff_1[         23] = 0xdd757;
		gp_coeff_1[         24] = 0xc75c7;
		gp_coeff_1[         25] = 0x7d477;
		gp_coeff_1[         26] = 0x5d747;
		gp_coeff_1[         27] = 0x7ddc7;
		gp_coeff_1[         28] = 0xc4c77;
		gp_coeff_1[         29] = 0xd4c75;
		gp_coeff_1[         30] = 0xc755d;
		gp_coeff_1[         31] = 0x47cc7;
		gp_coeff_1[         32] = 0xdd7d4;
		gp_coeff_1[         33] = 0x4c75d;
		gp_coeff_1[         34] = 0xc7dcc;
		gp_coeff_1[         35] = 0xd52a2;
		gp_coeff_1[         36] = 0x555a1;
		gp_coeff_2[          0] = 0x5d777;
		gp_coeff_2[          1] = 0x47777;
		gp_coeff_2[          2] = 0x7d777;
		gp_coeff_2[          3] = 0xcc777;
		gp_coeff_2[          4] = 0xd7777;
		gp_coeff_2[          5] = 0x7c777;
		gp_coeff_2[          6] = 0x7dd77;
		gp_coeff_2[          7] = 0xdd777;
		gp_coeff_2[          8] = 0x7c777;
		gp_coeff_2[          9] = 0x57c77;
		gp_coeff_2[         10] = 0x7c777;
		gp_coeff_2[         11] = 0xd5777;
		gp_coeff_2[         12] = 0xd7c77;
		gp_coeff_2[         13] = 0xdd777;
		gp_coeff_2[         14] = 0x77477;
		gp_coeff_2[         15] = 0xc7d77;
		gp_coeff_2[         16] = 0xc4777;
		gp_coeff_2[         17] = 0x57557;
		gp_coeff_2[         18] = 0xd5577;
		gp_coeff_2[         19] = 0xd5577;
		gp_coeff_2[         20] = 0x7d547;
		gp_coeff_2[         21] = 0x74757;
		gp_coeff_2[         22] = 0xc7577;
		gp_coeff_2[         23] = 0xcc7d5;
		gp_coeff_2[         24] = 0x4c747;
		gp_coeff_2[         25] = 0xddc77;
		gp_coeff_2[         26] = 0x54447;
		gp_coeff_2[         27] = 0xcc447;
		gp_coeff_2[         28] = 0x5755d;
		gp_coeff_2[         29] = 0x5dd57;
		gp_coeff_2[         30] = 0x54747;
		gp_coeff_2[         31] = 0x5747c;
		gp_coeff_2[         32] = 0xc77dd;
		gp_coeff_2[         33] = 0x47557;
		gp_coeff_2[         34] = 0x7a22a;
		gp_coeff_2[         35] = 0xc73aa;
		gp_coeff_2[         36] = 0x77777;
		gp_cv_g1 = 0x2b2834;
		gp_cv_g2 = 0x3f6c2e;
}
 	 else if ((Broadcast_Standard==8) | (Broadcast_Standard==6))
{
		gp_coeff_1[          0] = 0x47777;
		gp_coeff_1[          1] = 0x77777;
		gp_coeff_1[          2] = 0x5d777;
		gp_coeff_1[          3] = 0x47777;
		gp_coeff_1[          4] = 0x75777;
		gp_coeff_1[          5] = 0x5c777;
		gp_coeff_1[          6] = 0x57777;
		gp_coeff_1[          7] = 0x44777;
		gp_coeff_1[          8] = 0x55d77;
		gp_coeff_1[          9] = 0x7d777;
		gp_coeff_1[         10] = 0x55577;
		gp_coeff_1[         11] = 0xd5d77;
		gp_coeff_1[         12] = 0xd7d77;
		gp_coeff_1[         13] = 0x47477;
		gp_coeff_1[         14] = 0xdc777;
		gp_coeff_1[         15] = 0x4cc77;
		gp_coeff_1[         16] = 0x77d57;
		gp_coeff_1[         17] = 0xc4777;
		gp_coeff_1[         18] = 0xdd7d7;
		gp_coeff_1[         19] = 0x7c757;
		gp_coeff_1[         20] = 0xd4477;
		gp_coeff_1[         21] = 0x755c7;
		gp_coeff_1[         22] = 0x47d57;
		gp_coeff_1[         23] = 0xd7c47;
		gp_coeff_1[         24] = 0xd4cc7;
		gp_coeff_1[         25] = 0x47577;
		gp_coeff_1[         26] = 0x5c7d5;
		gp_coeff_1[         27] = 0x4c75d;
		gp_coeff_1[         28] = 0xd57d7;
		gp_coeff_1[         29] = 0x44755;
		gp_coeff_1[         30] = 0x7557d;
		gp_coeff_1[         31] = 0xc477d;
		gp_coeff_1[         32] = 0xd5d44;
		gp_coeff_1[         33] = 0xdd77d;
		gp_coeff_1[         34] = 0x5d75b;
		gp_coeff_1[         35] = 0x74332;
		gp_coeff_1[         36] = 0xd4311;
		gp_coeff_2[          0] = 0xd7777;
		gp_coeff_2[          1] = 0x77777;
		gp_coeff_2[          2] = 0xdd777;
		gp_coeff_2[          3] = 0xdc777;
		gp_coeff_2[          4] = 0xc7777;
		gp_coeff_2[          5] = 0xdd777;
		gp_coeff_2[          6] = 0x77d77;
		gp_coeff_2[          7] = 0x77777;
		gp_coeff_2[          8] = 0x55777;
		gp_coeff_2[          9] = 0xc7d77;
		gp_coeff_2[         10] = 0xd4777;
		gp_coeff_2[         11] = 0xc7477;
		gp_coeff_2[         12] = 0x7c777;
		gp_coeff_2[         13] = 0xd5577;
		gp_coeff_2[         14] = 0xdd557;
		gp_coeff_2[         15] = 0x47577;
		gp_coeff_2[         16] = 0xd7477;
		gp_coeff_2[         17] = 0x55747;
		gp_coeff_2[         18] = 0xdd757;
		gp_coeff_2[         19] = 0xd7477;
		gp_coeff_2[         20] = 0x7d7d5;
		gp_coeff_2[         21] = 0xddd47;
		gp_coeff_2[         22] = 0xdd777;
		gp_coeff_2[         23] = 0x575d5;
		gp_coeff_2[         24] = 0x47547;
		gp_coeff_2[         25] = 0x555c7;
		gp_coeff_2[         26] = 0x7d447;
		gp_coeff_2[         27] = 0xd7447;
		gp_coeff_2[         28] = 0x757dd;
		gp_coeff_2[         29] = 0x7dc77;
		gp_coeff_2[         30] = 0x54747;
		gp_coeff_2[         31] = 0xc743b;
		gp_coeff_2[         32] = 0xd7c7c;
		gp_coeff_2[         33] = 0xd7557;
		gp_coeff_2[         34] = 0x55c7a;
		gp_coeff_2[         35] = 0x4cc29;
		gp_coeff_2[         36] = 0x77777;
		gp_cv_g1 = 0x20682b;
		gp_cv_g2 = 0x29322f;
}
else if (Broadcast_Standard==10)
{
		gp_coeff_1[          0] = 0x77777;
		gp_coeff_1[          1] = 0x75777;
		gp_coeff_1[          2] = 0x7d777;
		gp_coeff_1[          3] = 0xd7777;
		gp_coeff_1[          4] = 0x74777;
		gp_coeff_1[          5] = 0xcc777;
		gp_coeff_1[          6] = 0x57777;
		gp_coeff_1[          7] = 0x5d577;
		gp_coeff_1[          8] = 0x5dd77;
		gp_coeff_1[          9] = 0x74777;
		gp_coeff_1[         10] = 0x77577;
		gp_coeff_1[         11] = 0x77c77;
		gp_coeff_1[         12] = 0xdc477;
		gp_coeff_1[         13] = 0x5d577;
		gp_coeff_1[         14] = 0x575d7;
		gp_coeff_1[         15] = 0xc7d57;
		gp_coeff_1[         16] = 0x77777;
		gp_coeff_1[         17] = 0x557d7;
		gp_coeff_1[         18] = 0xc7557;
		gp_coeff_1[         19] = 0x75c77;
		gp_coeff_1[         20] = 0x477d7;
		gp_coeff_1[         21] = 0xcc747;
		gp_coeff_1[         22] = 0x47dd7;
		gp_coeff_1[         23] = 0x775d7;
		gp_coeff_1[         24] = 0x47447;
		gp_coeff_1[         25] = 0x75cc7;
		gp_coeff_1[         26] = 0xc7777;
		gp_coeff_1[         27] = 0xc75d5;
		gp_coeff_1[         28] = 0x44c7d;
		gp_coeff_1[         29] = 0x74c47;
		gp_coeff_1[         30] = 0x47d75;
		gp_coeff_1[         31] = 0x7d57c;
		gp_coeff_1[         32] = 0xd5dc4;
		gp_coeff_1[         33] = 0xdd575;
		gp_coeff_1[         34] = 0xdb3bb;
		gp_coeff_1[         35] = 0x5c752;
		gp_coeff_1[         36] = 0x90880;
		gp_coeff_2[          0] = 0x5d777;
		gp_coeff_2[          1] = 0xd7777;
		gp_coeff_2[          2] = 0x77777;
		gp_coeff_2[          3] = 0xd5d77;
		gp_coeff_2[          4] = 0xc7777;
		gp_coeff_2[          5] = 0xd7777;
		gp_coeff_2[          6] = 0xddd77;
		gp_coeff_2[          7] = 0x55777;
		gp_coeff_2[          8] = 0x57777;
		gp_coeff_2[          9] = 0x54c77;
		gp_coeff_2[         10] = 0x4c477;
		gp_coeff_2[         11] = 0x74777;
		gp_coeff_2[         12] = 0xd5d77;
		gp_coeff_2[         13] = 0x47757;
		gp_coeff_2[         14] = 0x75577;
		gp_coeff_2[         15] = 0xc7577;
		gp_coeff_2[         16] = 0x4c747;
		gp_coeff_2[         17] = 0x7d477;
		gp_coeff_2[         18] = 0x7c757;
		gp_coeff_2[         19] = 0x55dd5;
		gp_coeff_2[         20] = 0x57577;
		gp_coeff_2[         21] = 0x44c47;
		gp_coeff_2[         22] = 0x5cc75;
		gp_coeff_2[         23] = 0x4cc77;
		gp_coeff_2[         24] = 0x47547;
		gp_coeff_2[         25] = 0x777d5;
		gp_coeff_2[         26] = 0xcccc7;
		gp_coeff_2[         27] = 0x57447;
		gp_coeff_2[         28] = 0xdc757;
		gp_coeff_2[         29] = 0x5755c;
		gp_coeff_2[         30] = 0x44747;
		gp_coeff_2[         31] = 0x5d5dd;
		gp_coeff_2[         32] = 0x5747b;
		gp_coeff_2[         33] = 0x77557;
		gp_coeff_2[         34] = 0xdcb2a;
		gp_coeff_2[         35] = 0xd5779;
		gp_coeff_2[         36] = 0x77777;
		gp_cv_g1 = 0x72242f;
		gp_cv_g2 = 0x28822a;
		}

 	if ((Broadcast_Standard == 0)  | (Broadcast_Standard == 1))
  		{
  		   sif_co_mx=0xb8; //184
  		   sif_fi_mx=0x0;
  		   sif_ic_bw=0x1;
  		   sif_bb_bw=0x1;
  		   sif_deemp=0x1;
  		   sif_cfg_demod=(sound_format==0)?0x0:0x2;
  		   sif_fm_gain=0x4;
  		}
  	else if (Broadcast_Standard == 3)
		{
  		   sif_co_mx=0xa6;
  		   sif_fi_mx=0x10;
  		   sif_ic_bw=0x2;
  		   sif_bb_bw=0x0;
  		   sif_deemp=0x2;
  		   sif_cfg_demod=(sound_format==0)?0x0:0x2;
  		   sif_fm_gain=0x3;
  		}
  		else if (Broadcast_Standard == 11)
		{
  		   sif_co_mx=154;
  		   sif_fi_mx=240;
  		   sif_ic_bw=2;
  		   sif_bb_bw=0;
  		   sif_deemp=2;
  		   sif_cfg_demod=(sound_format==0)?0:2;
  		   sif_fm_gain=3;
  		}
  		else if (Broadcast_Standard == 5)
		{
  		   sif_co_mx=150;
  		   sif_fi_mx=16;
  		   sif_ic_bw=2;
  		   sif_bb_bw=0;
  		   sif_deemp=2;
  		   sif_cfg_demod=(sound_format==0)?0:2;
  		   sif_fm_gain=3;
  		}
  		else if (Broadcast_Standard == 6)
		{
  		   sif_co_mx=158;
  		   sif_fi_mx=208;
  		   sif_ic_bw=3;
  		   sif_bb_bw=0;
  		   sif_deemp=2;
  		   sif_cfg_demod=(sound_format==0)?0:2;
  		   sif_fm_gain=3;
  		}
  		else if (Broadcast_Standard == 10)
		{
  		   sif_co_mx=153;
  		   sif_fi_mx=56;
  		   sif_ic_bw=3;
  		   sif_bb_bw=0;
  		   sif_deemp=2;
  		   sif_cfg_demod=(sound_format==0)?0:2;
  		   sif_fm_gain=3;
  		}
  		else if (Broadcast_Standard == 7)
		{
  		   sif_co_mx=163;
  		   sif_fi_mx=40;
  		   sif_ic_bw=0;
  		   sif_bb_bw=0;
  		   sif_deemp=2;
  		   sif_cfg_demod=(sound_format==0)?0:2;
  		   sif_fm_gain=3;
  		}
  		else if (Broadcast_Standard == 9)
		{
  		   sif_co_mx=159;
  		   sif_fi_mx=200;
  		   sif_ic_bw=3;
  		   sif_bb_bw=0;
  		   sif_deemp=0;
  		   sif_cfg_demod=(sound_format==0)?1:2;
  		   sif_fm_gain=5;
  		}
  		else if (Broadcast_Standard == 8)
		{
  		   sif_co_mx=159;
  		   sif_fi_mx=200;
  		   sif_ic_bw=3;
  		   sif_bb_bw=0;
  		   sif_deemp=2;
  		   sif_cfg_demod=(sound_format==0)?0:2;
  		   sif_fm_gain=3;
  		}
  		else if (Broadcast_Standard == 2)
		{
  		   sif_co_mx=182;
  		   sif_fi_mx=16;
  		   sif_ic_bw=1;
  		   sif_bb_bw=0;
  		   sif_deemp=1;
  		   sif_cfg_demod=(sound_format==0)?0:2;
  		   sif_fm_gain=3;
  		}
		sif_fm_gain -= 2;//avoid sound overflow@guanzhong
 	//FE PATH
	pr_info("ATV-DMD configure mixer\n");
 	   	if (Broadcast_Standard==4) {
 	     	tmp_int = (Tuner_IF_Frequency/125000);

 	     	if (Tuner_Input_IF_inverted==0x0) {
 	     		mixer1 = -tmp_int;
			}
 	     	else {
 	     		mixer1 = tmp_int;
			}

 	     	mixer3 = 0;
 	     	mixer3_bypass = 0;
 	    }
 	   	else
 	    {
 	       	tmp_int = (Tuner_IF_Frequency/125000);
			pr_info("ATV-DMD configure mixer 1\n");

 	     	if (Tuner_Input_IF_inverted==0x0) {
 	     		mixer1 = 0xe8 -tmp_int;
			}
 	     	else {
 	     		mixer1 = tmp_int - 0x18;
			}

			pr_info("ATV-DMD configure mixer 2\n");
 	     	mixer3 = 0x30;
 	     	mixer3_bypass = 0x1;
 	     }

		pr_info("ATV-DMD configure mixer 3\n");
 	   	atv_dmd_wr_byte(APB_BLOCK_ADDR_MIXER_1,0x0,mixer1);
 	   	atv_dmd_wr_word(APB_BLOCK_ADDR_MIXER_3,0x0,(((mixer3 & 0xff) << 8) | (mixer3_bypass & 0xff)));


 		if (Broadcast_Standard==9) {
 	   		atv_dmd_wr_long(APB_BLOCK_ADDR_ADC_SE,0x0,0x03180e0f);
		}
 		else {
 			atv_dmd_wr_long(APB_BLOCK_ADDR_ADC_SE,0x0,0x03150e0f);
 	  	}
		if(amlatvdemod_devp->parm.tuner_id == AM_TUNER_R840){
			/*config pwm for tuner r840*/
			atv_dmd_wr_byte(APB_BLOCK_ADDR_ADC_SE,1,0xf);//Kd = 0xf
		}


 	//GP Filter
	pr_info("ATV-DMD configure GP_filter\n");
 	if (Broadcast_Standard==4)
 	  {
 	    cv = gp_cv_g1;
 	  	atv_dmd_wr_long(APB_BLOCK_ADDR_GP_VD_FLT,0x0,(0x08000000 |  (cv & 0x7fffff)));
 	  	atv_dmd_wr_byte(APB_BLOCK_ADDR_GP_VD_FLT,0x4,0x04);
 	  	for (i =0; i< 9; i=i+1)
 	  	 	{
 	  	 	   //super_coef = {gp_coeff_1[i*4],gp_coeff_1[i*4+1],gp_coeff_1[i*4+2],gp_coeff_1[i*4+3]};
			   super_coef0 = (((gp_coeff_1[i*4+2] & 0xfff) << 20) | (gp_coeff_1[i*4+3] & 0xfffff));
			   super_coef1 = (((gp_coeff_1[i*4] & 0xf) << 28) | ((gp_coeff_1[i*4+1] & 0xfffff) << 8) | ((gp_coeff_1[i*4+2] >> 12) & 0xff));
			   super_coef2 = ((gp_coeff_1[i*4] >> 4) & 0xffff);

 	  	 	   //atv_dmd_wr_long(APB_BLOCK_ADDR_GP_VD_FLT,0x8,super_coef[79:48]);
 	  	 	   //atv_dmd_wr_long(APB_BLOCK_ADDR_GP_VD_FLT,0xC,super_coef[47:16]);
 	  	 	   //atv_dmd_wr_word(APB_BLOCK_ADDR_GP_VD_FLT,0x10,super_coef[15:0]);
 	  	 	   atv_dmd_wr_long(APB_BLOCK_ADDR_GP_VD_FLT,0x8, (((super_coef2 & 0xffff) << 16) | ((super_coef1 & 0xffff0000) >> 16)));
 	  	 	   atv_dmd_wr_long(APB_BLOCK_ADDR_GP_VD_FLT,0xC, (((super_coef1 & 0xffff) << 16) | ((super_coef0 & 0xffff0000) >> 16)));
 	  	 	   atv_dmd_wr_word(APB_BLOCK_ADDR_GP_VD_FLT,0x10,(super_coef0 & 0xffff));
 	  	 	   atv_dmd_wr_byte(APB_BLOCK_ADDR_GP_VD_FLT,0x05,i);
 	  	 	}
 	  	//atv_dmd_wr_long(APB_BLOCK_ADDR_GP_VD_FLT,0x8,{gp_coeff_1[36],12'd0});
 	  	atv_dmd_wr_long(APB_BLOCK_ADDR_GP_VD_FLT,0x8,((gp_coeff_1[36] & 0xfffff) << 12));
 	  	atv_dmd_wr_byte(APB_BLOCK_ADDR_GP_VD_FLT,0x05,0x09);

 	 }
 	 else
 	 {
 	    cv = gp_cv_g1-gp_cv_g2;
 	  	atv_dmd_wr_long(APB_BLOCK_ADDR_GP_VD_FLT,0x0,cv & 0x7fffff);
 	  	atv_dmd_wr_byte(APB_BLOCK_ADDR_GP_VD_FLT,0x4,0x00);
 	  	for (i =0; i< 9; i=i+1)
 	  	 	{
 	  	       //super_coef = {gp_coeff_1[i*4],gp_coeff_1[i*4+1],gp_coeff_1[i*4+2],gp_coeff_1[i*4+3]};
               super_coef0 = (((gp_coeff_1[i*4+2] & 0xfff) << 20) | (gp_coeff_1[i*4+3] & 0xfffff));
               super_coef1 = (((gp_coeff_1[i*4] & 0xf) << 28) | ((gp_coeff_1[i*4+1] & 0xfffff) << 8) | ((gp_coeff_1[i*4+2] >> 12) & 0xff));
               super_coef2 = ((gp_coeff_1[i*4] >> 4) & 0xffff);

               //atv_dmd_wr_long(APB_BLOCK_ADDR_GP_VD_FLT,0x8,super_coef[79:48]);
               //atv_dmd_wr_long(APB_BLOCK_ADDR_GP_VD_FLT,0xC,super_coef[47:16]);
               //atv_dmd_wr_word(APB_BLOCK_ADDR_GP_VD_FLT,0x10,super_coef[15:0]);
               atv_dmd_wr_long(APB_BLOCK_ADDR_GP_VD_FLT,0x8, (((super_coef2 & 0xffff) << 16) | ((super_coef1 & 0xffff0000) >> 16)));
               atv_dmd_wr_long(APB_BLOCK_ADDR_GP_VD_FLT,0xC, (((super_coef1 & 0xffff) << 16) | ((super_coef0 & 0xffff0000) >> 16)));
 	  	 	   atv_dmd_wr_word(APB_BLOCK_ADDR_GP_VD_FLT,0x10,(super_coef0 & 0xffff));
 	  	 	   atv_dmd_wr_byte(APB_BLOCK_ADDR_GP_VD_FLT,0x05,i);

			   //atv_dmd_wr_long(APB_BLOCK_ADDR_GP_VD_FLT,0x8,{gp_coeff_1[36],12'd0});
 	   	    }
               atv_dmd_wr_long(APB_BLOCK_ADDR_GP_VD_FLT,0x8,((gp_coeff_1[36] & 0xfffff) << 12));
               atv_dmd_wr_byte(APB_BLOCK_ADDR_GP_VD_FLT,0x05,9);
 	  		   atv_dmd_wr_byte(APB_BLOCK_ADDR_GP_VD_FLT,0x4,0x01);

 	  	for (i =0; i< 9; i=i+1)
 	  	 	{
 	  	 	   //super_coef = {gp_coeff_2[i*4],gp_coeff_2[i*4+1],gp_coeff_2[i*4+2],gp_coeff_2[i*4+3]};
               super_coef0 = (((gp_coeff_2[i*4+2] & 0xfff) << 20) | (gp_coeff_2[i*4+3] & 0xfffff));
               super_coef1 = (((gp_coeff_2[i*4] & 0xf) << 28) | ((gp_coeff_2[i*4+1] & 0xfffff) << 8) | ((gp_coeff_2[i*4+2] >> 12) & 0xff));
               super_coef2 = ((gp_coeff_2[i*4] >> 4) & 0xffff);

			   atv_dmd_wr_long(APB_BLOCK_ADDR_GP_VD_FLT,0x8, (((super_coef2 & 0xffff) << 16) | ((super_coef1 & 0xffff0000) >> 16)));
               atv_dmd_wr_long(APB_BLOCK_ADDR_GP_VD_FLT,0xC, (((super_coef1 & 0xffff) << 16) | ((super_coef0 & 0xffff0000) >> 16)));
               atv_dmd_wr_word(APB_BLOCK_ADDR_GP_VD_FLT,0x10,(super_coef0 & 0xffff));
               atv_dmd_wr_byte(APB_BLOCK_ADDR_GP_VD_FLT,0x05,i);
 	  	 	}

 	  	atv_dmd_wr_long(APB_BLOCK_ADDR_GP_VD_FLT,0x8,((gp_coeff_2[36] & 0xfffff) << 12));
 	  	atv_dmd_wr_byte(APB_BLOCK_ADDR_GP_VD_FLT,0x05,0x09);
 	 }

 	//CRVY
	pr_info("ATV-DMD configure CRVY\n");
 	   if (Broadcast_Standard==4)
 	     {
 	       crvy_reg_1=0xFF;
 	       crvy_reg_2=0x00;
 	     }
 	   else
 	     {
 	       crvy_reg_1=0x04;
 	       crvy_reg_2=0x01;
 	     }

 	   atv_dmd_wr_byte(APB_BLOCK_ADDR_CARR_RCVY,0x29,crvy_reg_1);
	   pr_info("ATV-DMD configure rcvy 2\n");
	   pr_info("ATV-DMD configure rcvy, crvy_reg_2 = %x \n", crvy_reg_2);
 	   atv_dmd_wr_byte(APB_BLOCK_ADDR_CARR_RCVY,0x20,crvy_reg_2);

 	//SOUND SUPPRESS
	pr_info("ATV-DMD configure sound suppress\n");

 	   if ((Broadcast_Standard==4) | (sound_format== 0))
 			atv_dmd_wr_byte(APB_BLOCK_ADDR_SIF_VD_IF,0x02,0x01);
 		else
 	  		atv_dmd_wr_byte(APB_BLOCK_ADDR_SIF_VD_IF,0x02,0x00);

 	//SIF
	pr_info("ATV-DMD configure sif\n");
 	 	if (!(Broadcast_Standard==4))
 	 	  {
 	 		atv_dmd_wr_byte(APB_BLOCK_ADDR_SIF_IC_STD,0x03,sif_ic_bw);
			atv_dmd_wr_byte(APB_BLOCK_ADDR_SIF_IC_STD,0x01,sif_fi_mx);
 	 	  	atv_dmd_wr_byte(APB_BLOCK_ADDR_SIF_IC_STD,0x02,sif_co_mx);

  	 		atv_dmd_wr_long(APB_BLOCK_ADDR_SIF_STG_2,0x00,(((sif_bb_bw & 0xff) << 24) | ((sif_deemp & 0xff) << 16) | 0x0500 | sif_fm_gain));
 	 		atv_dmd_wr_byte(APB_BLOCK_ADDR_SIF_STG_2,0x06,sif_cfg_demod);
 	 	  }

 	 	if (Broadcast_Standard==4)
 	 	  {}
 	 	else if (sound_format==0)
 	 	  {
 	 		tmp_int = 0;
 	 		atv_dmd_wr_long(APB_BLOCK_ADDR_SIF_STG_3,0x00, (0x01000000 | (tmp_int & 0xffffff)));
 	 	  }
 	 	else
 	 	  {
 	 		tmp_int = (256 - sif_co_mx)<<13;
 	 		atv_dmd_wr_long(APB_BLOCK_ADDR_SIF_STG_3,0x00, (tmp_int & 0xffffff));
 	 	   }

 	 	if (Broadcast_Standard==4)
 	 	  {
 	 	  	atv_dmd_wr_long(APB_BLOCK_ADDR_IC_AGC,0x00,0x02040E0A);
			atv_dmd_wr_word(APB_BLOCK_ADDR_IC_AGC,0x04,0x0F0D);
 	 	  }
 	 	else if (sound_format==0)
 	 	  {
 	 	  	atv_dmd_wr_byte(APB_BLOCK_ADDR_IC_AGC,0x00,0x04);
 	 	  }
 	 	else if (Broadcast_Standard==9)
 	 	  {
 	 	  	atv_dmd_wr_long(APB_BLOCK_ADDR_IC_AGC,0x00,0x0003140A);
 	 	  	atv_dmd_wr_word(APB_BLOCK_ADDR_IC_AGC,0x04,0x1244); //we lower target agc to avoid saturation
 	 	  }
 	 	else
 	 	  {
 	 	  	atv_dmd_wr_long(APB_BLOCK_ADDR_IC_AGC,0x00,0x00040E0A);
 	 	  	atv_dmd_wr_word(APB_BLOCK_ADDR_IC_AGC,0x04,0x0D68);
 	 	  }

 	 //VAGC
	pr_info("ATV-DMD configure vagc\n");
 	 	atv_dmd_wr_long(APB_BLOCK_ADDR_VDAGC,0x48,0x9B6F2C00); //bw select mode
 	 	atv_dmd_wr_byte(APB_BLOCK_ADDR_VDAGC,0x37,0x1C); //disable prefilter

 	 	if (Broadcast_Standard==9)
 	 	  {
 	 		atv_dmd_wr_word(APB_BLOCK_ADDR_VDAGC,0x44,0x4450);
 	 		atv_dmd_wr_byte(APB_BLOCK_ADDR_VDAGC,0x46,0x44);
 	 		atv_dmd_wr_long(APB_BLOCK_ADDR_VDAGC,0x4,0x3E04FC);
 	 		atv_dmd_wr_word(APB_BLOCK_ADDR_VDAGC,0x3C,0x4848);
 	 	   	atv_dmd_wr_byte(APB_BLOCK_ADDR_VDAGC,0x3E,0x48);
 	 	  }
 	 	else
 	      {
 	 		atv_dmd_wr_word(APB_BLOCK_ADDR_VDAGC,0x44,0xB800);
 	 		atv_dmd_wr_byte(APB_BLOCK_ADDR_VDAGC,0x46,0x08);
 	 		atv_dmd_wr_long(APB_BLOCK_ADDR_VDAGC,0x4,0x3C04FC);
 	 		atv_dmd_wr_word(APB_BLOCK_ADDR_VDAGC,0x3C,0x1818);
 	 	   	atv_dmd_wr_byte(APB_BLOCK_ADDR_VDAGC,0x3E,0x10);
 	 	  }

 	 	 //tmp_real = $itor(Hz_Freq)/0.23841858; //TODO
 	 	 //tmp_int = $rtoi(tmp_real); //TODO
 	 	 //tmp_int = Hz_Freq/0.23841858; //TODO
 	 	 //tmp_int_2 = ((unsigned long)15625)*10000/23841858;
 	 	 //tmp_int_2 = ((unsigned long)Hz_Freq)*10000/23841858;
 	 	 atv_dmd_wr_word(APB_BLOCK_ADDR_VDAGC,0x10,(freq_hz_cvrt >> 8) & 0xffff);
 	 	 atv_dmd_wr_byte(APB_BLOCK_ADDR_VDAGC,0x12,(freq_hz_cvrt & 0xff));

 	 //OUTPUT STAGE
	pr_info("ATV-DMD configure output stage\n");
 	   	 if (Broadcast_Standard==4)
 	   	   {
 	 	   }
 	 	 else
 	 	   {
 	 	    atv_dmd_wr_byte(APB_BLOCK_ADDR_DAC_UPS,0x0,0x00);
 	 	    atv_dmd_wr_byte(APB_BLOCK_ADDR_DAC_UPS,0x1,0x40);
 	 	    atv_dmd_wr_byte(APB_BLOCK_ADDR_DAC_UPS,0x2,0x40);
 	 	    atv_dmd_wr_byte(APB_BLOCK_ADDR_DAC_UPS,0x4,0xFA);
 	 	    atv_dmd_wr_byte(APB_BLOCK_ADDR_DAC_UPS,0x5,0xFA); //TODO
 	 	   }

 	 //GDE FILTER
	pr_info("ATV-DMD configure gde filter\n");
  		 if (GDE_Curve == 0)
  					{
  					  gd_coeff[0]= 0x020; //12'sd32;
  					  gd_coeff[1]= 0xf5f; //-12'sd161;
  					  gd_coeff[2]= 0x1fe; //12'sd510;
  					  gd_coeff[3]= 0xc0b; //-12'sd1013;
  					  gd_coeff[4]= 0x536; //12'sd1334;
  					  gd_coeff[5]= 0xb34; //-12'sd1228;
  					  gd_bypass = 0x1;
  					 }
  		 else if (GDE_Curve == 1)
  					{
  					  gd_coeff[0]= 0x8;   //12'sd8;
  					  gd_coeff[1]= 0xfd5; //-12'sd43;
  					  gd_coeff[2]= 0x8d;  //12'sd141;
  					  gd_coeff[3]= 0xe69; //-12'sd407;
  					  gd_coeff[4]= 0x1f1; //12'sd497;
  					  gd_coeff[5]= 0xe7e; //-12'sd386;
  					  gd_bypass = 0x1;
  					 }
  	   	 else if (GDE_Curve == 2)
  					{
  					  gd_coeff[0]= 0x35;  //12'sd53;
  					  gd_coeff[1]= 0xf41; //-12'sd191;
  					  gd_coeff[2]= 0x68;  //12'sd104;
  					  gd_coeff[3]= 0xea5; //-12'sd347;
  					  gd_coeff[4]= 0x322; //12'sd802;
  					  gd_coeff[5]= 0x1bb; //12'sd443;
  					  gd_bypass = 0x1;
  					}
  		 else if (GDE_Curve == 3)
  					{
  					  gd_coeff[0]= 0xf;   //12'sd15;
  					  gd_coeff[1]= 0xfb5; //-12'sd75;
  					  gd_coeff[2]= 0xcc;  //12'sd204;
  					  gd_coeff[3]= 0x1af; //-12'sd431;
  					  gd_coeff[4]= 0x226; //12'sd550;
  					  gd_coeff[5]= 0xd00; //-12'sd766;
  					  gd_bypass = 0x1;
  					}
  		 else
  					  gd_bypass = 0x0;

 	 	if (gd_bypass==0x0)
 	 	  	atv_dmd_wr_byte(APB_BLOCK_ADDR_GDE_EQUAL,0x0D,gd_bypass);
 	 	else
 	 	  {
 	 	  	for (i =0; i< 6; i=i+1)
 	 	  	  atv_dmd_wr_word(APB_BLOCK_ADDR_GDE_EQUAL,i<<1,gd_coeff[i]);
 	 	  	atv_dmd_wr_byte(APB_BLOCK_ADDR_GDE_EQUAL,0x0C,0x01);
 	 	  	atv_dmd_wr_byte(APB_BLOCK_ADDR_GDE_EQUAL,0x0D,gd_bypass);
 	 	  }

 	  //PWM
		pr_info("ATV-DMD configure pwm\n");
 	  atv_dmd_wr_long(APB_BLOCK_ADDR_AGC_PWM,0x00,0x1f40);  //4KHz
  	  atv_dmd_wr_long(APB_BLOCK_ADDR_AGC_PWM,0x04,0xc8);  //26 dB dynamic range
  	  atv_dmd_wr_byte(APB_BLOCK_ADDR_AGC_PWM,0x09,0xa);
	  if(amlatvdemod_devp->parm.tuner_id == AM_TUNER_R840){
		/*config pwm for tuner r840*/
		atv_dmd_wr_long(APB_BLOCK_ADDR_AGC_PWM,0,0xc80);//pwm freq = 10khz
		//atv_dmd_wr_byte(APB_BLOCK_ADDR_ADC_SE,1,0xf);//Kd = 0xf
	}
}
struct timer_list atvdemod_timer;
#define ATVDEMOD_INTERVAL		(HZ/100)   //10ms, #define HZ 100

void retrieve_adc_power(int *adc_level)
{
	*adc_level = atv_dmd_rd_long(APB_BLOCK_ADDR_ADC_SE,0x0c);
	//adc_level = adc_level/32768*100;
	*adc_level = (*adc_level)*100/32768;
}
void retrieve_vpll_carrier_lock(int *lock)
{
	unsigned int data;
	data = atv_dmd_rd_byte(APB_BLOCK_ADDR_CARR_RCVY,0x43);
	*lock = data&0x1;
}
int retrieve_vpll_carrier_afc(void)
{
	int data_ret,pll_lock,field_lock,line_lock,line_lock_strong;
	unsigned int data_h,data_l,data_exg = 0;
	pll_lock = atv_dmd_rd_byte(APB_BLOCK_ADDR_CARR_RCVY,0x43)&0x1;
	field_lock = atv_dmd_rd_byte(APB_BLOCK_ADDR_VDAGC,0x4f)&0x4;
	line_lock = atv_dmd_rd_byte(APB_BLOCK_ADDR_VDAGC,0x4f)&0x10;
	line_lock_strong = atv_dmd_rd_byte(APB_BLOCK_ADDR_VDAGC,0x4f)&0x8;
	//if((atv_dmd_rd_byte(APB_BLOCK_ADDR_CARR_RCVY,0x43)&0x1) == 1){
	if((pll_lock == 1)||(line_lock == 0x10)){
		/*if pll unlock, afc is invalid*/
		data_ret = 200;
		return data_ret;
	}
	data_h = atv_dmd_rd_byte(APB_BLOCK_ADDR_CARR_RCVY,0x40);
	data_l = atv_dmd_rd_byte(APB_BLOCK_ADDR_CARR_RCVY,0x41);
	data_exg = ((data_h&0x7) << 8) | data_l;
	if(data_h&0x8){
		data_ret = (((~data_exg)&0x7ff) - 1);
		data_ret = data_ret*488*(-1)/1000;
	}
	else{
		data_ret = data_exg;
		data_ret = data_ret*488/1000;
	}
	if ((abs(data_ret) < 50) && (line_lock_strong == 0x8) && (field_lock == 0x4)) {
		data_ret = 100;
		return data_ret;
	}
	return data_ret;
}
void set_pll_lpf(unsigned int lock)
{
	atv_dmd_wr_byte(APB_BLOCK_ADDR_CARR_RCVY,0x24,lock);
}
void retrieve_frequency_offset(int *freq_offset)
{
	/*unsigned int data;
	data = atv_dmd_rd_word(APB_BLOCK_ADDR_CARR_RCVY,0x40);
	*freq_offset = (int)data;*/
	unsigned int data_h,data_l,data_exg;
	int data_ret;
	data_h = atv_dmd_rd_byte( APB_BLOCK_ADDR_CARR_RCVY,0x40) ;
	data_l = atv_dmd_rd_byte( APB_BLOCK_ADDR_CARR_RCVY,0x41) ;
	data_exg = ((data_h&0x7)<<8) | data_l;
	if(data_h&0x8){ 
		data_ret = (((~data_exg) &0x7ff)  - 1);
		data_ret = data_ret*(-1);
		//data_ret = data_ret*488*(-1) /1000;
	} 
	else{ 
		data_ret = data_exg;
		//data_ret = data_ret*488/100;
	}
	*freq_offset = data_ret;
}
void retrieve_video_lock(int *lock)
{
	unsigned int data,wlock,slock;
	data = atv_dmd_rd_byte(APB_BLOCK_ADDR_VDAGC,0x4f);
	wlock = data&0x10;
	slock = data&0x80;
	*lock = wlock&slock;
}
void retrieve_fh_frequency(int *fh)
{
	unsigned long data1,data2;
	data1 = atv_dmd_rd_word(APB_BLOCK_ADDR_VDAGC,0x58);
	data2 = atv_dmd_rd_long(APB_BLOCK_ADDR_VDAGC,0x10);
	data1 = data1 >> 11;
	data2 = data2 >> 3;
	*fh = data1 + data2;
}
void atvdemod_timer_hander(unsigned long arg)
{
	//int adc_level,lock,freq_offset,fh;
	int freq_offset,lock,mix1_freq_cur,delta_mix1_freq;
	atvdemod_timer.expires = jiffies + ATVDEMOD_INTERVAL*10;//100ms timer
	add_timer(&atvdemod_timer);
	//retrieve_adc_power(&adc_level);
	//pr_info("adc_level: 0x%x\n",adc_level);
	retrieve_vpll_carrier_lock(&lock);
	mix1_freq_cur = atv_dmd_rd_byte(APB_BLOCK_ADDR_MIXER_1,0x0);
	delta_mix1_freq = abs(mix1_freq_cur - mix1_freq);
	/*if((lock&0x1)==0)
		pr_info("visual carrier lock:locked\n");
	else
		pr_info("visual carrier lock:unlocked\n");*/
	//set_pll_lpf(lock);
	retrieve_frequency_offset(&freq_offset);
	freq_offset = freq_offset*488/1000;
	//pr_info("visual carrier offset:%d Hz\n",freq_offset*48828125/100000);
	//retrieve_video_lock(&lock);
	if((lock&0x1)==1) {
		if(delta_mix1_freq == atvdemod_afc_range){
			atv_dmd_wr_byte(APB_BLOCK_ADDR_MIXER_1,0x0,mix1_freq);
		}
		else if((freq_offset >= atvdemod_afc_offset)&&(delta_mix1_freq < atvdemod_afc_range)){ 
			atv_dmd_wr_byte(APB_BLOCK_ADDR_MIXER_1,0x0,mix1_freq_cur-1);
		} 
		else if((freq_offset <= (-1)*atvdemod_afc_offset) &&(delta_mix1_freq < atvdemod_afc_range-1)){ 
			atv_dmd_wr_byte(APB_BLOCK_ADDR_MIXER_1,0x0,mix1_freq_cur+1);
		}
		//pr_info("video lock:locked\n");
	}
	else{
		//pr_info("video lock:unlocked\n");
	} 
	//retrieve_fh_frequency(&fh);
	//pr_info("horizontal frequency:%d Hz\n",fh*190735/100000);
}
int atvdemod_init(void)
{
	//unsigned long data32;
	if (atvdemod_timer_en == 1) {
		if (timer_init_flag == 1) {
			del_timer_sync(&atvdemod_timer);
			timer_init_flag = 0;
		}
	}
	//clocks_set_hdtv ();
	//1.set system clock
	WRITE_CBUS_REG(HHI_ADC_PLL_CNTL3,0xca2a2110);//0xce7a2110;0x8a2a2110
	WRITE_CBUS_REG(HHI_ADC_PLL_CNTL4,0x2933800);
	WRITE_CBUS_REG(HHI_ADC_PLL_CNTL,0xe0644220);//0x0484680;0xe0484680
	WRITE_CBUS_REG(HHI_ADC_PLL_CNTL2,0x34e0bf84);
	WRITE_CBUS_REG(HHI_ADC_PLL_CNTL3,0x4a2a2110);//reset clcok 0x4e7a2110;0x0a2a2110
	WRITE_CBUS_REG(HHI_ATV_DMD_SYS_CLK_CNTL,0x80);
	//TVFE reset
	WRITE_CBUS_REG_BITS(RESET1_REGISTER, 1, 7, 1);

	read_version_register();

	//2.set atv demod top page control register
	atv_dmd_input_clk_32m();
	atv_dmd_wr_long(APB_BLOCK_ADDR_TOP,ATV_DMD_TOP_CTRL,0x1037);
	atv_dmd_wr_long(APB_BLOCK_ADDR_TOP,(ATV_DMD_TOP_CTRL1 << 2),0x1f);

	//3.configure atv demod
	check_communication_interface();
	power_on_receiver();
	configure_receiver(broad_std, if_freq, if_inv, gde_curve, sound_format);
	atv_dmd_misc();
	//4.software reset
	atv_dmd_soft_reset();
	atv_dmd_soft_reset();
	atv_dmd_soft_reset();
	atv_dmd_soft_reset();

	/* ?????
	while (!all_lock) {
		data32 = atv_dmd_rd_long(APB_BLOCK_ADDR_VDAGC,0x13<<2);
		if ((data32 & 0x1c) == 0x0) {
			all_lock = 1;
		}
		delay_us(400);
	}*/
	#if 1//temp mark
	if (atvdemod_timer_en == 1) {
		/*atvdemod timer hander*/
		init_timer(&atvdemod_timer);
		//atvdemod_timer.data = (ulong) devp;
		atvdemod_timer.function = atvdemod_timer_hander;
		atvdemod_timer.expires = jiffies + ATVDEMOD_INTERVAL*300;//after 3s enable demod auto detect
		add_timer(&atvdemod_timer);
		mix1_freq = atv_dmd_rd_byte(APB_BLOCK_ADDR_MIXER_1,0x0);
		timer_init_flag = 1;
	}
	#endif
	pr_info("delay done\n");
	return(0);
}

void atv_dmd_set_std(void)
{
	v4l2_std_id ptstd = amlatvdemod_devp->parm.std;
	/* set broad standard of tuner*/
	if (ptstd & V4L2_STD_PAL_BG) {
		amlatvdemod_devp->fre_offset = 2250000;
		freq_hz_cvrt = AML_ATV_DEMOD_FREQ_50HZ_VERT;
		broad_std = AML_ATV_DEMOD_VIDEO_MODE_PROP_PAL_BG;
		if_freq = 3250000;
	} else if (ptstd & V4L2_STD_PAL_DK) {
		amlatvdemod_devp->fre_offset = 2250000;
		freq_hz_cvrt = AML_ATV_DEMOD_FREQ_50HZ_VERT;
		if_freq = 3250000;
		broad_std = AML_ATV_DEMOD_VIDEO_MODE_PROP_PAL_DK;
	} else if (ptstd & V4L2_STD_PAL_M) {
		amlatvdemod_devp->fre_offset = 2250000;
		freq_hz_cvrt = AML_ATV_DEMOD_FREQ_60HZ_VERT;
		broad_std = AML_ATV_DEMOD_VIDEO_MODE_PROP_PAL_M;
		if_freq = 4250000;
	} else if (ptstd & V4L2_STD_NTSC_M) {
		amlatvdemod_devp->fre_offset = 1750000;
		freq_hz_cvrt = AML_ATV_DEMOD_FREQ_60HZ_VERT;
		if_freq = 4250000;
		broad_std = AML_ATV_DEMOD_VIDEO_MODE_PROP_NTSC;
	} else if (ptstd & V4L2_STD_NTSC_M_JP) {
		amlatvdemod_devp->fre_offset = 1750000;
		freq_hz_cvrt = AML_ATV_DEMOD_FREQ_50HZ_VERT;
		broad_std = AML_ATV_DEMOD_VIDEO_MODE_PROP_NTSC_J;
		if_freq = 4250000;
	} else if (ptstd & V4L2_STD_PAL_I) {
		amlatvdemod_devp->fre_offset = 2750000;
		freq_hz_cvrt = AML_ATV_DEMOD_FREQ_50HZ_VERT;
		broad_std = AML_ATV_DEMOD_VIDEO_MODE_PROP_PAL_I;
		if_freq = 3250000;
	} else if (ptstd & (V4L2_STD_SECAM_L | V4L2_STD_SECAM_LC)) {
		amlatvdemod_devp->fre_offset = 2750000;
		freq_hz_cvrt = AML_ATV_DEMOD_FREQ_50HZ_VERT;
		broad_std = AML_ATV_DEMOD_VIDEO_MODE_PROP_SECAM_L;
	}
	if (amlatvdemod_devp->parm.tuner_id == AM_TUNER_R840) {
		if_freq = amlatvdemod_devp->parm.if_freq;
		if_inv = amlatvdemod_devp->parm.if_inv;
		if(atvdemod_agc_pinmux == 1){
			//Disable ATV_AGC PINMUX
			WRITE_CBUS_REG_BITS(PERIPHS_PIN_MUX_8,0,13,1);//DTV_IF_AGC
			WRITE_CBUS_REG_BITS(PERIPHS_PIN_MUX_8,0,12,1);//DTV_RF_AGC
			WRITE_CBUS_REG_BITS(PERIPHS_PIN_MUX_11,0,17,1);//ATV_AGC
			WRITE_CBUS_REG_BITS(PERIPHS_PIN_MUX_7,0,21,1);//PWM_VS
			WRITE_CBUS_REG_BITS(PERIPHS_PIN_MUX_9,0,21,1);//PWM_D
			//GPIOW_3 OUTPUT 0
			WRITE_CBUS_REG_BITS(PREG_PAD_GPIO0_EN_N,0,3,1);
			WRITE_CBUS_REG_BITS(PREG_PAD_GPIO0_O,0,3,1);
		}
		else if(atvdemod_agc_pinmux == 2){
			//Disable ATV_AGC PINMUX
			WRITE_CBUS_REG_BITS(PERIPHS_PIN_MUX_8,0,13,1);//DTV_IF_AGC
			WRITE_CBUS_REG_BITS(PERIPHS_PIN_MUX_8,0,12,1);//DTV_RF_AGC
			WRITE_CBUS_REG_BITS(PERIPHS_PIN_MUX_11,1,17,1);//ATV_AGC
			WRITE_CBUS_REG_BITS(PERIPHS_PIN_MUX_7,0,21,1);//PWM_VS
			WRITE_CBUS_REG_BITS(PERIPHS_PIN_MUX_9,0,21,1);//PWM_D
			//GPIOW_3 set as INPUT
			WRITE_CBUS_REG_BITS(PREG_PAD_GPIO0_EN_N,1,3,1);
		}
	}
        pr_info("[atvdemod..]%s: broad_std %d,freq_hz_cvrt:0x%x,fre_offset:%d.\n",
		__func__, broad_std, freq_hz_cvrt,amlatvdemod_devp->fre_offset);
        if(atvdemod_init())
                pr_info("[si2177..]%s: atv restart error.\n", __func__);
}


