/*
 * AMLOGIC lcd external driver.
 *
 * Communication protocol:
 * MIPI 
 *
 */

#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/module.h>
#include <linux/platform_device.h>
#include <linux/slab.h>
#include <linux/jiffies.h> 
#include <linux/i2c.h>
#include <linux/i2c-aml.h>
#include <linux/miscdevice.h>
#include <linux/mutex.h>
#include <linux/mm.h>
#include <linux/device.h>
#include <linux/fs.h>
#include <linux/delay.h>
#include <linux/sysctl.h>
#include <asm/uaccess.h>
#include <mach/pinmux.h>
#include <mach/gpio.h>
#include <linux/amlogic/vout/aml_lcd_extern.h>

static struct lcd_extern_config_t *lcd_extern_config = NULL;

//#define LCD_EXT_DEBUG_INFO
#ifdef LCD_EXT_DEBUG_INFO
#define DBG_PRINT(...)		printk(__VA_ARGS__)
#else
#define DBG_PRINT(...)
#endif

#define LCD_EXTERN_NAME			"lcd_mipi_KD080D13"

//******************** mipi command ********************//
//format:  data_type, num, data....
//special: data_type=0xff, num<0xff means delay ms, num=0xff means ending.
//******************************************************//
static unsigned char mipi_init_on_table[] = {
    0x39,3,0xf0,0x5a,0x5a,
    0x39,3,0xf1,0x5a,0x5a,
    0x39,3,0xfc,0xa5,0xa5,
    0x39,3,0xd0,0x00,0x10,
    0x15,2,0xb1,0x10,
    0x39,5,0xb2,0x14,0x22,0x2f,0x04,
    0x39,6,0xf2,0x02,0x08,0x08,0x40,0x10,
    0x15,2,0xb0,0x03,
    0x39,3,0xfd,0x23,0x09,
    0x39,11,0xf3,0x01,0x93,0x20,0x22,0x80,0x05,0x25,0x3c,0x26,0x00,
    0x39,46,0xf4,0x00,0x02,0x03,0x26,0x03,0x02,0x09,0x00,0x07,0x16,0x16,0x03,0x00,0x08,0x08,0x03,0x0E,0x0F,0x12,0x1C,0x1D,0x1E,0x0C,0x09,0x01,0x04,0x02,0x61,0x74,0x75,0x72,0x83,0x80,0x80,0xB0,0x00,0x01,0x01,0x28,0x04,0x03,0x28,0x01,0xD1,0x32,
    0x39,27,0xf5,0x84,0x2F,0x2F,0x5F,0xAB,0x98,0x52,0x0F,0x33,0x43,0x04,0x59,0x54,0x52,0x05,0x40,0x60,0x4E,0x60,0x40,0x27,0x26,0x52,0x25,0x6D,0x18,
    0x39,9,0xee,0x25,0x00,0x25,0x00,0x25,0x00,0x25,0x00,
    0x39,9,0xef,0x34,0x12,0x98,0xBA,0x20,0x00,0x24,0x80,
    0x39,33,0xf7,0x0E,0x0E,0x0A,0x0A,0x0F,0x0F,0x0B,0x0B,0x05,0x07,0x01,0x01,0x01,0x01,0x01,0x01,0x0C,0x0C,0x08,0x08,0x0D,0x0D,0x09,0x09,0x04,0x06,0x01,0x01,0x01,0x01,0x01,0x01,
    0x39,4,0xbc,0x01,0x4e,0x0a,
    0x39,6,0xe1,0x03,0x10,0x1c,0xa0,0x10,
    0x39,7,0xf6,0x60,0x21,0xA6,0x00,0x00,0x00,
    0x39,7,0xfe,0x00,0x0D,0x03,0x21,0x80,0x48,
    0x15,2,0xb0,0x22,
    0x39,18,0xfa,0x02,0x34,0x09,0x13,0x0B,0x0F,0x16,0x16,0x17,0x1E,0x1D,0x1C,0x1E,0x1D,0x1D,0x1F,0x24,
    0x15,2,0xb0,0x22,
    0x39,18,0xfb,0x00,0x34,0x07,0x11,0x09,0x0D,0x14,0x14,0x15,0x1C,0x1F,0x1C,0x1D,0x1D,0x1D,0x20,0x26,
    0x15,2,0xb0,0x11,
    0x39,18,0xfa,0x20,0x34,0x24,0x27,0x19,0x1B,0x1F,0x1E,0x1B,0x1F,0x21,0x1F,0x1E,0x20,0x1E,0x1E,0x21,
    0x15,2,0xb0,0x11,
    0x39,18,0xfb,0x1E,0x34,0x22,0x25,0x17,0x19,0x1D,0x1A,0x19,0x20,0x1F,0x1E,0x20,0x1E,0x1E,0x1F,0x22,
    0x39,18,0xfa,0x1C,0x34,0x1C,0x1F,0x13,0x17,0x1A,0x18,0x18,0x1E,0x20,0x21,0x21,0x21,0x23,0x22,0x2A,
    0x39,18,0xfb,0x1A,0x34,0x1A,0x1D,0x11,0x15,0x18,0x16,0x16,0x1C,0x20,0x20,0x20,0x1F,0x23,0x23,0x2B,

    0x05,1,0x11,
    0xff,20,
    0x39,4,0xc3,0x40,0x00,0x28,
    0xff,200,
    0x15,2,0x35,0x00,
    0x05,1,0x29,
    0xff,30,     //delay 30ms
    0xff,0xff,   //ending flag
};

static unsigned char mipi_init_off_table[] = {
    0x05,1,0x28, //display off
    0xff,30,     //delay 30ms
    0x05,1,0x10, //sleep in
    0xff,30,     //delay 30ms
    0x39,4,0xc3,0x40,0x00,0x20,
    0xff,10,
    0xff,0xff,   //ending flag
};

static int get_lcd_extern_config(struct device_node* of_node, struct lcd_extern_config_t *lcd_ext_cfg)
{
    int ret = 0;
    struct aml_lcd_extern_driver_t* lcd_ext;

    ret = get_lcd_extern_dt_data(of_node, lcd_ext_cfg);
    if (ret) {
        printk("[error] %s: failed to get dt data\n", LCD_EXTERN_NAME);
        return ret;
    }

    //lcd extern driver update
    lcd_ext = aml_lcd_extern_get_driver();
    if (lcd_ext) {
        lcd_ext->type      = lcd_ext_cfg->type;
        lcd_ext->name      = lcd_ext_cfg->name;
        lcd_ext->init_on_cmd_8  = &mipi_init_on_table[0];
        lcd_ext->init_off_cmd_8 = &mipi_init_off_table[0];
    }
    else {
        printk("[error] %s get lcd_extern_driver failed\n", lcd_ext_cfg->name);
        ret = -1;
    }

    return ret;
}

static int aml_KD080D13_probe(struct platform_device *pdev)
{
    int ret = 0;

    if (lcd_extern_driver_check()) {
        return -1;
    }
    if (lcd_extern_config == NULL)
        lcd_extern_config = kzalloc(sizeof(*lcd_extern_config), GFP_KERNEL);
    if (lcd_extern_config == NULL) {
        printk("[error] %s probe: failed to alloc data\n", LCD_EXTERN_NAME);
        return -1;
    }

    pdev->dev.platform_data = lcd_extern_config;

    ret = get_lcd_extern_config(pdev->dev.of_node, lcd_extern_config);
    if (ret) {
        goto lcd_extern_probe_failed;
    }

    printk("%s probe ok\n", LCD_EXTERN_NAME);
    return ret;

lcd_extern_probe_failed:
    if (lcd_extern_config) {
        kfree(lcd_extern_config);
        lcd_extern_config = NULL;
    }
    return -1;
}

static int aml_KD080D13_remove(struct platform_device *pdev)
{
    if (pdev->dev.platform_data)
        kfree (pdev->dev.platform_data);
    return 0;
}

#ifdef CONFIG_USE_OF
static const struct of_device_id aml_KD080D13_dt_match[]={
    {
        .compatible = "amlogic,lcd_mipi_KD080D13",
    },
    {},
};
#else
#define aml_KD080D13_dt_match NULL
#endif

static struct platform_driver aml_KD080D13_driver = {
    .probe  = aml_KD080D13_probe,
    .remove = aml_KD080D13_remove,
    .driver = {
        .name  = LCD_EXTERN_NAME,
        .owner = THIS_MODULE,
#ifdef CONFIG_USE_OF
        .of_match_table = aml_KD080D13_dt_match,
#endif
    },
};

static int __init aml_KD080D13_init(void)
{
    int ret;
    DBG_PRINT("%s\n", __FUNCTION__);

    ret = platform_driver_register(&aml_KD080D13_driver);
    if (ret) {
        printk("[error] %s failed to register lcd extern driver module\n", __FUNCTION__);
        return -ENODEV;
    }

    return ret;
}

static void __exit aml_KD080D13_exit(void)
{
    platform_driver_unregister(&aml_KD080D13_driver);
}

//late_initcall(aml_KD080D13_init);
module_init(aml_KD080D13_init);
module_exit(aml_KD080D13_exit);

MODULE_AUTHOR("AMLOGIC");
MODULE_DESCRIPTION("LCD Extern driver for KD080D13");
MODULE_LICENSE("GPL");
