#ifndef OV5645_FIRMWARE_H
#define OV5645_FIRMWARE_H

#define CMD_MAIN	0x3024
#define CMD_ACK		0x3025
#define CMD_PARA0	0x5082
#define CMD_PARA1	0x5083
#define CMD_PARA2	0x5084
#define CMD_PARA3	0x5085
#define CMD_PARA4	0x3026
#define FW_STATUS	0x3027
#define OV5645_FW_ADDR    (0x8000)

static u8 OV5645AF_addr_data_pair1[254] =
{
	//0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f
        //0x8000
	0x80,
	0x00,
	0x02, 0x15, 0x5c, 0x02, 0x12, 0x01, 0xc2, 0x01, 0x22, 0x00, 0x00, 0x02, 0x15, 0x18, 0x78, 0xc3, //0x8000,
	0xe6, 0x18, 0xf6, 0xe5, 0x30, 0xc3, 0x13, 0xfc, 0xe5, 0x31, 0x13, 0xfd, 0xe5, 0x2e, 0xc3, 0x13, //0x8010,
	0xfe, 0xe5, 0x2f, 0x13, 0x2d, 0x78, 0x9b, 0xf6, 0xee, 0x3c, 0x18, 0xf6, 0x78, 0xc3, 0xa6, 0x4f, //0x8020,
	0xe5, 0x1e, 0x70, 0x6b, 0xe6, 0x12, 0x0f, 0x25, 0xff, 0x33, 0x95, 0xe0, 0xfe, 0x74, 0x9d, 0x2f, //0x8030,
	0xf5, 0x82, 0x74, 0x0e, 0x3e, 0xf5, 0x83, 0xe4, 0x93, 0x78, 0xc1, 0xf6, 0x75, 0x4e, 0x02, 0x12, //0x8040,
	0x0f, 0x31, 0x78, 0x56, 0x12, 0x0f, 0x2c, 0x78, 0x96, 0x12, 0x0f, 0x2c, 0x12, 0x0f, 0x91, 0x78, //0x8050,
	0xc3, 0xe6, 0x78, 0x9e, 0xf6, 0x78, 0xc3, 0xe6, 0x78, 0xbe, 0xf6, 0x78, 0xc3, 0xe6, 0x78, 0xbf, //0x8060,
	0xf6, 0x08, 0x76, 0x02, 0x78, 0xc5, 0x76, 0x01, 0x08, 0x76, 0x01, 0x08, 0x76, 0x01, 0xe6, 0x78, //0x8070,
	0xc9, 0xf6, 0xe6, 0x78, 0xcb, 0xf6, 0x78, 0xc9, 0xe6, 0x78, 0xcc, 0xf6, 0xe4, 0x08, 0xf6, 0x08, //0x8080,
	0xf6, 0x08, 0x76, 0x40, 0x78, 0xc3, 0xe6, 0x78, 0xd0, 0xf6, 0xe4, 0x08, 0xf6, 0xc2, 0x38, 0xe5, //0x8090,
	0x1e, 0x64, 0x06, 0x70, 0x2e, 0xd3, 0x78, 0xc0, 0xe6, 0x64, 0x80, 0x94, 0x80, 0x40, 0x02, 0x16, //0x80a0,
	0x22, 0xa2, 0x38, 0xe4, 0x33, 0xf5, 0x41, 0x90, 0x30, 0x28, 0xf0, 0xe4, 0xf5, 0x1e, 0xc2, 0x01, //0x80b0,
	0x75, 0x1d, 0x10, 0xd2, 0x36, 0x78, 0x52, 0xa6, 0x2e, 0x08, 0xa6, 0x2f, 0x08, 0xa6, 0x30, 0x08, //0x80c0,
	0xa6, 0x31, 0x22, 0x79, 0xc3, 0xe7, 0x78, 0xc1, 0x26, 0x78, 0xc4, 0xf6, 0xc3, 0x78, 0xce, 0xe6, //0x80d0,
	0x64, 0x80, 0xf8, 0x09, 0xe7, 0x64, 0x80, 0x98, 0x50, 0x06, 0x78, 0xce, 0xe6, 0x78, 0xc4, 0xf6, //0x80e0,
	0xd3, 0x78, 0xcf, 0xe6, 0x64, 0x80, 0xf8, 0x79, 0xc4, 0xe7, 0x64, 0x80, //0x80f0
};

static u8 OV5645AF_addr_data_pair2[255] =
{
	//0x80fc
	0x80,
	0xfc,
	0x98, 0x40, 0x06, 0x78,
	0xcf, 0xe6, 0x78, 0xc4, 0xf6, 0x78, 0xc4, 0xe6, 0xf5, 0x4f, 0x12, 0x12, 0xaf, 0x78, 0xc1, 0xe6, //0x8100,
	0xff, 0x33, 0x95, 0xe0, 0xfe, 0x12, 0x15, 0x2e, 0x8f, 0x0a, 0xd3, 0xe5, 0x0a, 0x64, 0x80, 0x94, //0x8110,
	0x86, 0x40, 0x05, 0x75, 0x1e, 0x01, 0x80, 0x1f, 0xd3, 0xe5, 0x0a, 0x64, 0x80, 0x94, 0x83, 0x40, //0x8120,
	0x05, 0x75, 0x1e, 0x02, 0x80, 0x11, 0xd3, 0xe5, 0x0a, 0x64, 0x80, 0x94, 0x81, 0x40, 0x05, 0x75, //0x8130,
	0x1e, 0x03, 0x80, 0x03, 0x75, 0x1e, 0x04, 0xd3, 0x78, 0xc0, 0xe6, 0x64, 0x80, 0x94, 0x80, 0x40, //0x8140,
	0x02, 0x16, 0x22, 0x78, 0xc6, 0xe6, 0x18, 0xf6, 0x08, 0x06, 0x78, 0xc2, 0xe6, 0xff, 0x12, 0x0f, //0x8150,
	0x99, 0x12, 0x0f, 0x2f, 0x78, 0xc5, 0xe6, 0x25, 0xe0, 0x24, 0x56, 0xf8, 0xa6, 0x06, 0x08, 0xa6, //0x8160,
	0x07, 0x79, 0xc5, 0xe7, 0x78, 0xc7, 0x66, 0x70, 0x05, 0xe6, 0x78, 0xc9, 0xf6, 0x22, 0x78, 0xc5, //0x8170,
	0xe6, 0x78, 0x99, 0x12, 0x0e, 0xfa, 0x40, 0x0d, 0x78, 0xc5, 0xe6, 0x12, 0x0e, 0xdf, 0xfe, 0x08, //0x8180,
	0xe6, 0xff, 0x12, 0x0f, 0x91, 0x78, 0xc5, 0xe6, 0x25, 0xe0, 0x24, 0x57, 0xf9, 0xc3, 0xe7, 0x78, //0x8190,
	0x97, 0x96, 0x19, 0xe7, 0x18, 0x96, 0x50, 0x11, 0x78, 0xc5, 0xe6, 0x12, 0x0e, 0xdf, 0xfe, 0x08, //0x81a0,
	0xe6, 0xff, 0x78, 0x96, 0xa6, 0x06, 0x08, 0xa6, 0x07, 0x78, 0xc5, 0xe6, 0x25, 0xe0, 0x24, 0x57, //0x81b0,
	0xf9, 0x78, 0xc9, 0xe6, 0x12, 0x0e, 0xdf, 0xfe, 0x08, 0xe6, 0xc3, 0x97, 0xee, 0x19, 0x97, 0x50, //0x81c0,
	0x06, 0x78, 0xc5, 0xe6, 0x78, 0xc9, 0xf6, 0x78, 0xc5, 0xe6, 0x24, 0x9e, 0x78, 0xbe, 0x12, 0x0f, //0x81d0,
	0x09, 0x40, 0x07, 0x12, 0x0f, 0x99, 0xe6, 0x78, 0xbe, 0xf6, 0x78, 0xc5, 0xe6, 0x24, 0x9e, 0x78, //0x81e0,
	0xbf, 0x12, 0x0e, 0xe8, 0x50, 0x07, 0x12, 0x0f, 0x99, //0x81f0,
};

static u8 OV5645AF_addr_data_pair3[255] =
{
	//0x81f9
	0x81,
	0xf9,
	0xe6, 0x78, 0xbf, 0xf6, 0x78, 0xc5, 0xe6,
	0x78, 0xc8, 0xf6, 0x12, 0x10, 0x7f, 0x12, 0x0c, 0x86, 0x12, 0x14, 0xdd, 0x78, 0xcd, 0xa6, 0x07, //0x8200,
	0xe6, 0x24, 0x02, 0x70, 0x03, 0x02, 0x02, 0x9e, 0x14, 0x70, 0x03, 0x02, 0x02, 0x9e, 0x24, 0xfe, //0x8210,
	0x60, 0x03, 0x02, 0x03, 0xb1, 0xd2, 0x38, 0x12, 0x0f, 0x16, 0x40, 0x16, 0x78, 0xc9, 0xe6, 0x24, //0x8220,
	0x9d, 0x12, 0x0e, 0xe6, 0x50, 0x20, 0x78, 0xc9, 0xe6, 0x24, 0x9d, 0xf8, 0xe6, 0x78, 0xce, 0xf6, //0x8230,
	0x80, 0x14, 0x78, 0xc9, 0xe6, 0x24, 0x9d, 0x12, 0x0f, 0x07, 0x40, 0x0a, 0x78, 0xc9, 0xe6, 0x24, //0x8240,
	0x9d, 0xf8, 0xe6, 0x78, 0xcf, 0xf6, 0x78, 0xca, 0x12, 0x0f, 0x52, 0x79, 0xc2, 0xe7, 0x78, 0xc3, //0x8250,
	0x66, 0x60, 0x03, 0x02, 0x04, 0x9f, 0x78, 0xd1, 0x06, 0xe5, 0x1e, 0xb4, 0x01, 0x07, 0x12, 0x0f, //0x8260,
	0x1f, 0xf6, 0x09, 0x80, 0x1e, 0xe5, 0x1e, 0xb4, 0x02, 0x08, 0x12, 0x0f, 0x1f, 0xf6, 0x79, 0xc3, //0x8270,
	0x80, 0x11, 0xe5, 0x1e, 0xb4, 0x03, 0x14, 0x78, 0xc1, 0xe6, 0xf4, 0x04, 0xff, 0xa2, 0xe7, 0x13, //0x8280,
	0xf6, 0x79, 0xc3, 0xe7, 0x26, 0x78, 0xc4, 0xf6, 0x02, 0x04, 0x8a, 0x02, 0x04, 0x1c, 0xd2, 0x38, //0x8290,
	0x78, 0xd1, 0x06, 0xc3, 0x12, 0x0f, 0x17, 0x50, 0x25, 0x79, 0xc9, 0xe7, 0x78, 0xc5, 0x66, 0x78, //0x82a0,
	0xc9, 0x60, 0x05, 0xe6, 0x04, 0xff, 0x80, 0x02, 0xe6, 0xff, 0x8f, 0x0a, 0x74, 0x9e, 0x2f, 0x12, //0x82b0,
	0x0e, 0xe6, 0x50, 0x2d, 0x74, 0x9e, 0x2f, 0xf8, 0xe6, 0x78, 0xce, 0xf6, 0x80, 0x23, 0x79, 0xc9, //0x82c0,
	0xe7, 0x78, 0xc5, 0x66, 0x78, 0xc9, 0x60, 0x05, 0xe6, 0x04, 0xff, 0x80, 0x02, 0xe6, 0xff, 0x8f, //0x82d0,
	0x0a, 0x74, 0x9e, 0x2f, 0x12, 0x0f, 0x07, 0x40, 0x08, 0x74, 0x9e, 0x2f, 0xf8, 0xe6, 0x78, 0xcf, //0x82e0,
	0xf6, 0x12, 0x0f, 0x50, 0x78, 0xc1, //0x82f0,
};

static u8 OV5645AF_addr_data_pair4[255] =
{
	//0x82f6
	0x82,
	0xf6,
	0xe6, 0xff, 0x33, 0x95, 0xe0, 0xfe, 0xef, 0x78, 0x02, 0xc3,
	0x33, 0xce, 0x33, 0xce, 0xd8, 0xf9, 0xff, 0x12, 0x15, 0x2e, 0x78, 0xce, 0xe6, 0xfd, 0x33, 0x95, //0x8300,
	0xe0, 0xfc, 0x08, 0xe6, 0xfb, 0x33, 0x95, 0xe0, 0xfa, 0xc3, 0xeb, 0x9d, 0xfd, 0xea, 0x9c, 0xfc, //0x8310,
	0xd3, 0xed, 0x9f, 0xee, 0x64, 0x80, 0xf8, 0xec, 0x64, 0x80, 0x98, 0x40, 0x02, 0x80, 0x01, 0xd3, //0x8320,
	0x92, 0x3a, 0xe5, 0x1e, 0x64, 0x01, 0x70, 0x21, 0x12, 0x0f, 0x72, 0x30, 0x3a, 0x05, 0xe6, 0xa2, //0x8330,
	0xe7, 0x13, 0xf6, 0x12, 0x0f, 0x16, 0x40, 0x06, 0x78, 0xce, 0xe6, 0xff, 0x80, 0x04, 0x78, 0xcf, //0x8340,
	0xe6, 0xff, 0x78, 0xc4, 0xa6, 0x07, 0x02, 0x04, 0x8a, 0xe5, 0x1e, 0x64, 0x02, 0x70, 0x21, 0x12, //0x8350,
	0x0f, 0x72, 0x30, 0x3a, 0x05, 0xe6, 0xa2, 0xe7, 0x13, 0xf6, 0x12, 0x0f, 0x16, 0x40, 0x06, 0x78, //0x8360,
	0xce, 0xe6, 0xff, 0x80, 0x04, 0x78, 0xcf, 0xe6, 0xff, 0x78, 0xc4, 0xa6, 0x07, 0x02, 0x04, 0x8a, //0x8370,
	0xe5, 0x1e, 0x64, 0x03, 0x70, 0x21, 0x12, 0x0f, 0x72, 0x30, 0x3a, 0x05, 0xe6, 0xa2, 0xe7, 0x13, //0x8380,
	0xf6, 0x12, 0x0f, 0x16, 0x40, 0x06, 0x78, 0xce, 0xe6, 0xff, 0x80, 0x04, 0x78, 0xcf, 0xe6, 0xff, //0x8390,
	0x78, 0xc4, 0xa6, 0x07, 0x02, 0x04, 0x8a, 0x78, 0xc0, 0x76, 0x01, 0x12, 0x0f, 0xa0, 0x02, 0x04, //0x83a0,
	0x9c, 0x79, 0xc2, 0xe7, 0x78, 0xc3, 0x66, 0x60, 0x03, 0x02, 0x04, 0x9f, 0x78, 0xd1, 0x06, 0xc3, //0x83b0,
	0x12, 0x0f, 0x17, 0x50, 0x16, 0x78, 0xc9, 0xe6, 0x24, 0x9f, 0x12, 0x0e, 0xe6, 0x50, 0x20, 0x78, //0x83c0,
	0xc9, 0xe6, 0x24, 0x9f, 0xf8, 0xe6, 0x78, 0xce, 0xf6, 0x80, 0x14, 0x78, 0xc9, 0xe6, 0x24, 0x9f, //0x83d0,
	0x12, 0x0f, 0x07, 0x40, 0x0a, 0x78, 0xc9, 0xe6, 0x24, 0x9f, 0xf8, 0xe6, 0x78, 0xcf, 0xf6, 0x12, //0x83e0,
	0x0f, 0x50, 0x20, //0x83f0,
};

static u8 OV5645AF_addr_data_pair5[255] =
{
	//0x83f3
	0x83,
	0xf3,
	0x38, 0x2e, 0xc3, 0x08, 0xe6, 0x64, 0x80, 0x94, 0x82, 0x50, 0x1b, 0x12, 0x0f,
	0x72, 0xe6, 0x64, 0x80, 0x94, 0x80, 0x40, 0x06, 0x78, 0xce, 0xe6, 0xff, 0x80, 0x04, 0x78, 0xcf, //0x8400,
	0xe6, 0xff, 0x78, 0xc4, 0xa6, 0x07, 0x02, 0x04, 0x8a, 0x12, 0x0f, 0xa0, 0x78, 0xc0, 0x76, 0x01, //0x8410,
	0x02, 0x04, 0x9c, 0xe5, 0x1e, 0x64, 0x01, 0x70, 0x1d, 0x78, 0xc1, 0xe6, 0xf4, 0x04, 0x12, 0x0f, //0x8420,
	0x25, 0x12, 0x0f, 0x81, 0x40, 0x06, 0x78, 0xce, 0xe6, 0xff, 0x80, 0x04, 0x78, 0xcf, 0xe6, 0xff, //0x8430,
	0x78, 0xc4, 0xa6, 0x07, 0x80, 0x44, 0xe5, 0x1e, 0x64, 0x02, 0x70, 0x1d, 0x78, 0xc1, 0xe6, 0xf4, //0x8440,
	0x04, 0x12, 0x0f, 0x25, 0x12, 0x0f, 0x81, 0x40, 0x06, 0x78, 0xce, 0xe6, 0xff, 0x80, 0x04, 0x78, //0x8450,
	0xcf, 0xe6, 0xff, 0x78, 0xc4, 0xa6, 0x07, 0x80, 0x21, 0xe5, 0x1e, 0x64, 0x03, 0x70, 0x26, 0x78, //0x8460,
	0xc1, 0xe6, 0xf4, 0x04, 0xa2, 0xe7, 0x13, 0x12, 0x0f, 0x81, 0x40, 0x06, 0x78, 0xce, 0xe6, 0xff, //0x8470,
	0x80, 0x04, 0x78, 0xcf, 0xe6, 0xff, 0x78, 0xc4, 0xa6, 0x07, 0x78, 0xc6, 0xe6, 0x08, 0xf6, 0x78, //0x8480,
	0xc0, 0x76, 0x01, 0x80, 0x0a, 0x12, 0x0f, 0xa0, 0x78, 0xc0, 0x76, 0x01, 0x75, 0x1e, 0x06, 0x78, //0x8490,
	0xc4, 0xe6, 0xf5, 0x4f, 0x12, 0x12, 0xaf, 0x22, 0x30, 0x01, 0x03, 0x02, 0x08, 0x5f, 0x30, 0x02, //0x84a0,
	0x03, 0x02, 0x08, 0x5f, 0xe5, 0x1e, 0x60, 0x03, 0x02, 0x05, 0x3b, 0x75, 0x1d, 0x20, 0xd2, 0x36, //0x84b0,
	0xd3, 0x78, 0x53, 0xe6, 0x94, 0x00, 0x18, 0xe6, 0x94, 0x00, 0x40, 0x07, 0xe6, 0xfe, 0x08, 0xe6, //0x84c0,
	0xff, 0x80, 0x0e, 0x90, 0x0e, 0x8d, 0xe4, 0x93, 0x25, 0xe0, 0x25, 0xe0, 0x24, 0x2a, 0x12, 0x11, //0x84d0,
	0x8e, 0x78, 0x52, 0xa6, 0x06, 0x08, 0xa6, 0x07, 0xd3, 0x78, 0x55, 0xe6, 0x94, 0x00, 0x18, 0xe6, //0x84e0,
};

static u8 OV5645AF_addr_data_pair6[255] =
{
	//0x84f0
	0x84,
	0xf0,
	0x94, 0x00, 0x40, 0x07, 0xe6, 0xfe, 0x08, 0xe6, 0xff, 0x80, 0x08, 0x90, 0x0e, 0x8d, 0xe4, 0x93, //0x84f0,
	0x12, 0x11, 0x88, 0x78, 0x54, 0xa6, 0x06, 0x08, 0xa6, 0x07, 0x12, 0x11, 0xd8, 0x12, 0x11, 0xa9, //0x8500,
	0x78, 0x5a, 0x12, 0x11, 0x82, 0x78, 0x5c, 0xa6, 0x06, 0x08, 0xa6, 0x07, 0x12, 0x11, 0xd8, 0x78, //0x8510,
	0xad, 0xa6, 0x33, 0x08, 0xa6, 0x33, 0x08, 0xa6, 0x35, 0x78, 0xb3, 0xa6, 0x33, 0x08, 0xa6, 0x33, //0x8520,
	0x08, 0xa6, 0x35, 0x75, 0x1e, 0x01, 0x78, 0xaa, 0x76, 0x01, 0x22, 0xe5, 0x1e, 0xb4, 0x05, 0x10, //0x8530,
	0xd2, 0x01, 0xc2, 0x02, 0xe4, 0xf5, 0x1e, 0xf5, 0x1d, 0xd2, 0x36, 0xd2, 0x34, 0xd2, 0x37, 0x22, //0x8540,
	0x12, 0x11, 0xc7, 0x24, 0xb3, 0x12, 0x11, 0xc4, 0x24, 0xb4, 0x12, 0x11, 0xc4, 0x24, 0xb5, 0xf8, //0x8550,
	0xa6, 0x35, 0x12, 0x11, 0xa9, 0x12, 0x11, 0xbc, 0x24, 0x5a, 0xf8, 0x12, 0x11, 0x82, 0x12, 0x11, //0x8560,
	0xbc, 0x24, 0x5c, 0xf8, 0xa6, 0x06, 0x08, 0xa6, 0x07, 0x12, 0x11, 0xbc, 0x24, 0x5e, 0xf8, 0xa6, //0x8570,
	0x2a, 0x08, 0xa6, 0x2b, 0x12, 0x11, 0xbc, 0x24, 0x60, 0xf8, 0xa6, 0x2c, 0x08, 0xa6, 0x2d, 0x90, //0x8580,
	0x0e, 0x99, 0xe4, 0x93, 0x24, 0xff, 0xff, 0xe4, 0x34, 0xff, 0xfe, 0x78, 0xaa, 0xe6, 0x24, 0x01, //0x8590,
	0xfd, 0xe4, 0x33, 0xfc, 0xd3, 0xed, 0x9f, 0xee, 0x64, 0x80, 0xf8, 0xec, 0x64, 0x80, 0x98, 0x40, //0x85a0,
	0x04, 0x7f, 0x00, 0x80, 0x05, 0x78, 0xaa, 0xe6, 0x04, 0xff, 0x78, 0xaa, 0xa6, 0x07, 0xe5, 0x1e, //0x85b0,
	0xb4, 0x01, 0x07, 0xe6, 0x70, 0x04, 0x75, 0x1e, 0x02, 0x22, 0xe4, 0x78, 0xab, 0xf6, 0x08, 0xf6, //0x85c0,
	0xf5, 0x0b, 0x12, 0x11, 0xcf, 0xf5, 0x14, 0x08, 0xe6, 0xf5, 0x15, 0x12, 0x11, 0xcf, 0xf5, 0x16, //0x85d0,
	0x08, 0xe6, 0xf5, 0x17, 0x12, 0x11, 0xcf, 0xfe, 0x08, 0xe6, 0xff, 0x12, 0x11, //0x85e0,
};

static u8 OV5645AF_addr_data_pair7[255] =
{
	//0x85ed
	0x85,
	0xed,
	0xf0, 0x75, 0x0a,
	0x01, 0x90, 0x0e, 0x99, 0xe4, 0x93, 0xfb, 0xe5, 0x0a, 0xc3, 0x9b, 0x50, 0x67, 0x12, 0x11, 0x73, //0x85f0,
	0xf8, 0xe6, 0xfe, 0x08, 0xe6, 0xff, 0xe4, 0xfc, 0xfd, 0xe5, 0x0f, 0x2f, 0xf5, 0x0f, 0xe5, 0x0e, //0x8600,
	0x3e, 0xf5, 0x0e, 0xed, 0x35, 0x0d, 0xf5, 0x0d, 0xec, 0x35, 0x0c, 0xf5, 0x0c, 0xe5, 0x0a, 0x75, //0x8610,
	0xf0, 0x08, 0xa4, 0x24, 0x5b, 0x12, 0x11, 0x7b, 0xf9, 0xc3, 0xe5, 0x15, 0x97, 0xe5, 0x14, 0x19, //0x8620,
	0x97, 0x50, 0x0b, 0x12, 0x11, 0x73, 0xf8, 0xe6, 0xf5, 0x14, 0x08, 0xe6, 0xf5, 0x15, 0xe5, 0x0a, //0x8630,
	0x75, 0xf0, 0x08, 0xa4, 0x24, 0x5b, 0x12, 0x11, 0x7b, 0xf9, 0xd3, 0xe5, 0x17, 0x97, 0xe5, 0x16, //0x8640,
	0x19, 0x97, 0x40, 0x0b, 0x12, 0x11, 0x73, 0xf8, 0xe6, 0xf5, 0x16, 0x08, 0xe6, 0xf5, 0x17, 0x05, //0x8650,
	0x0a, 0x02, 0x05, 0xf1, 0xe4, 0xfa, 0xf9, 0xf8, 0xaf, 0x0f, 0xae, 0x0e, 0xad, 0x0d, 0xac, 0x0c, //0x8660,
	0x12, 0x0b, 0x7b, 0x8e, 0x18, 0x8f, 0x19, 0xc3, 0xe5, 0x15, 0x95, 0x17, 0xff, 0xe5, 0x14, 0x95, //0x8670,
	0x16, 0xfe, 0xe5, 0x0b, 0x25, 0xe0, 0x24, 0x53, 0xf9, 0xd3, 0xe5, 0x15, 0x97, 0xe5, 0x14, 0x19, //0x8680,
	0x97, 0xe5, 0x0b, 0x40, 0x11, 0x25, 0xe0, 0x24, 0x53, 0xf8, 0xc3, 0xe5, 0x15, 0x96, 0xfd, 0xe5, //0x8690,
	0x14, 0x18, 0x96, 0xfc, 0x80, 0x0f, 0x25, 0xe0, 0x24, 0x53, 0xf8, 0xc3, 0xe6, 0x95, 0x15, 0xfd, //0x86a0,
	0x18, 0xe6, 0x95, 0x14, 0xfc, 0x8c, 0x1a, 0x8d, 0x1b, 0x12, 0x11, 0xf0, 0x12, 0x11, 0x6a, 0x90, //0x86b0,
	0x0e, 0x8e, 0x12, 0x11, 0x95, 0xe4, 0x85, 0x15, 0x13, 0x85, 0x14, 0x12, 0xf5, 0x11, 0xf5, 0x10, //0x86c0,
	0xaf, 0x13, 0xae, 0x12, 0x7b, 0x04, 0x12, 0x11, 0x58, 0xc3, 0x12, 0x0c, 0x0d, 0x50, 0x11, 0xaf, //0x86d0,
	0x0b, 0x74, 0x01, 0xa8, 0x07, 0x08, 0x80, 0x02, 0xc3, 0x33, //0x86e0,
};

static u8 OV5645AF_addr_data_pair8[255] =
{
	//0x86ea
	0x86,
	0xea,
	0xd8, 0xfc, 0x78, 0xab, 0x26, 0xf6,
	0xe4, 0x85, 0x1b, 0x0f, 0x85, 0x1a, 0x0e, 0xf5, 0x0d, 0xf5, 0x0c, 0x12, 0x11, 0x6a, 0x90, 0x0e, //0x86f0,
	0x92, 0x12, 0x11, 0x95, 0xe5, 0x0b, 0x25, 0xe0, 0x24, 0x53, 0xf9, 0xd3, 0xe5, 0x19, 0x97, 0xe5, //0x8700,
	0x18, 0x19, 0x97, 0x40, 0x0e, 0xe5, 0x0b, 0x25, 0xe0, 0x24, 0x52, 0xf8, 0xe6, 0xfe, 0x08, 0xe6, //0x8710,
	0xff, 0x80, 0x04, 0xae, 0x18, 0xaf, 0x19, 0xe4, 0x8f, 0x13, 0x8e, 0x12, 0xf5, 0x11, 0xf5, 0x10, //0x8720,
	0x7b, 0x10, 0x12, 0x11, 0x58, 0xd3, 0x12, 0x0c, 0x0d, 0x40, 0x11, 0xaf, 0x0b, 0x74, 0x01, 0xa8, //0x8730,
	0x07, 0x08, 0x80, 0x02, 0xc3, 0x33, 0xd8, 0xfc, 0x78, 0xac, 0x26, 0xf6, 0x05, 0x0b, 0xe5, 0x0b, //0x8740,
	0x64, 0x04, 0x60, 0x03, 0x02, 0x05, 0xd2, 0xe4, 0xf5, 0x0b, 0x12, 0x11, 0xfa, 0xfb, 0x12, 0x11, //0x8750,
	0xfa, 0xfa, 0x12, 0x11, 0xfa, 0x75, 0x18, 0x00, 0xf5, 0x19, 0x75, 0x0a, 0x01, 0x90, 0x0e, 0x99, //0x8760,
	0xe4, 0x93, 0xff, 0xe5, 0x0a, 0xc3, 0x9f, 0x50, 0x2a, 0x12, 0x11, 0x4b, 0x25, 0x19, 0xf5, 0x19, //0x8770,
	0xe4, 0x35, 0x18, 0xf5, 0x18, 0x12, 0x11, 0x4b, 0xfe, 0xeb, 0xc3, 0x9e, 0x50, 0x04, 0x12, 0x11, //0x8780,
	0x4b, 0xfb, 0x12, 0x11, 0x4b, 0xfe, 0xea, 0xd3, 0x9e, 0x40, 0x04, 0x12, 0x11, 0x4b, 0xfa, 0x05, //0x8790,
	0x0a, 0x80, 0xca, 0xef, 0xfd, 0x7c, 0x00, 0xae, 0x18, 0xaf, 0x19, 0x12, 0x0a, 0x9b, 0xc3, 0xeb, //0x87a0,
	0x9a, 0xfe, 0x74, 0xad, 0x25, 0x0b, 0xf8, 0xe6, 0xfd, 0xef, 0xd3, 0x9d, 0x74, 0xad, 0x40, 0x0b, //0x87b0,
	0x25, 0x0b, 0xf8, 0xe6, 0xfd, 0xc3, 0xef, 0x9d, 0xff, 0x80, 0x07, 0x25, 0x0b, 0xf8, 0xc3, 0xe6, //0x87c0,
	0x9f, 0xff, 0x8f, 0x1c, 0x90, 0x0e, 0x96, 0xe4, 0x93, 0xff, 0xee, 0xc3, 0x9f, 0x50, 0x0d, 0x12, //0x87d0,
	0x11, 0xe5, 0x80, 0x02, 0xc3, 0x33, 0xd8, //0x87e0,
};

static u8 OV5645AF_addr_data_pair9[255] =
{
	//0x87e7
	0x87,
	0xe7,
	0xfc, 0x78, 0xab, 0x26, 0xf6, 0x90, 0x0e, 0x97, 0xe4,
	0x93, 0xff, 0xe5, 0x1c, 0xd3, 0x9f, 0x40, 0x0d, 0x12, 0x11, 0xe5, 0x80, 0x02, 0xc3, 0x33, 0xd8, //0x87f0,
	0xfc, 0x78, 0xac, 0x26, 0xf6, 0x74, 0xb0, 0x25, 0x0b, 0xf8, 0xa6, 0x1c, 0x05, 0x0b, 0xe5, 0x0b, //0x8800,
	0x64, 0x03, 0x60, 0x03, 0x02, 0x07, 0x5a, 0x78, 0xb1, 0xe6, 0xff, 0x18, 0xe6, 0x2f, 0xff, 0xe4, //0x8810,
	0x33, 0xfe, 0x78, 0xb2, 0xe6, 0x7c, 0x00, 0x2f, 0xf5, 0x1b, 0xec, 0x3e, 0xf5, 0x1a, 0x90, 0x0e, //0x8820,
	0x98, 0xe4, 0x93, 0xff, 0xd3, 0xe5, 0x1b, 0x9f, 0xe5, 0x1a, 0x94, 0x00, 0x40, 0x06, 0x78, 0xac, //0x8830,
	0x74, 0x80, 0x26, 0xf6, 0x78, 0xac, 0xe6, 0x79, 0xab, 0x57, 0xf6, 0xe5, 0x1e, 0xb4, 0x02, 0x0f, //0x8840,
	0x18, 0xe6, 0xb4, 0x7f, 0x0a, 0x08, 0xe6, 0xd3, 0x94, 0x00, 0x40, 0x03, 0x75, 0x1e, 0x05, 0x22, //0x8850,
	0x90, 0x0e, 0x89, 0x12, 0x0c, 0x44, 0x8f, 0x4d, 0x8e, 0x4c, 0x8d, 0x4b, 0x8c, 0x4a, 0x90, 0x38, //0x8860,
	0x04, 0x12, 0x14, 0xa8, 0xfb, 0xaa, 0x06, 0x90, 0x38, 0x00, 0x12, 0x14, 0xa8, 0xff, 0xc3, 0xeb, //0x8870,
	0x9f, 0xfb, 0xea, 0x9e, 0xfa, 0x90, 0x38, 0x10, 0xe0, 0xa3, 0xe0, 0x75, 0xf0, 0x02, 0xa4, 0xff, //0x8880,
	0xc3, 0xeb, 0x9f, 0xfb, 0xea, 0x95, 0xf0, 0xfa, 0x90, 0x38, 0x06, 0xe0, 0xfe, 0xa3, 0xe0, 0xfd, //0x8890,
	0xee, 0xf5, 0x0c, 0xed, 0xf5, 0x0d, 0x90, 0x38, 0x02, 0x12, 0x14, 0xa8, 0xff, 0x12, 0x14, 0x91, //0x88a0,
	0x90, 0x38, 0x12, 0xe0, 0xa3, 0xe0, 0x75, 0xf0, 0x02, 0xa4, 0xff, 0xae, 0xf0, 0x12, 0x14, 0x91, //0x88b0,
	0xa3, 0xe0, 0xb4, 0x31, 0x07, 0xea, 0xc3, 0x13, 0xfa, 0xeb, 0x13, 0xfb, 0x90, 0x38, 0x14, 0xe0, //0x88c0,
	0xb4, 0x71, 0x0f, 0xeb, 0xae, 0x02, 0x78, 0x02, 0xce, 0xc3, 0x13, 0xce, 0x13, 0xd8, 0xf9, 0xfb, //0x88d0,
	0xaa, 0x06, 0x90, 0x38, //0x88e0,
};

static u8 OV5645AF_addr_data_pair10[255] =
{
	//0x88e4,
	0x88,
	0xe4,
	0x15, 0xe0, 0xb4, 0x31, 0x0b, 0xe5, 0x0c, 0xc3, 0x13, 0xf5, 0x0c, 0xe5,
	0x0d, 0x13, 0xf5, 0x0d, 0x90, 0x38, 0x15, 0xe0, 0xb4, 0x71, 0x11, 0xe5, 0x0d, 0xae, 0x0c, 0x78, //0x88f0,
	0x02, 0xce, 0xc3, 0x13, 0xce, 0x13, 0xd8, 0xf9, 0xf5, 0x0d, 0x8e, 0x0c, 0xea, 0xc4, 0xf8, 0x54, //0x8900,
	0xf0, 0xc8, 0x68, 0xfa, 0xeb, 0xc4, 0x54, 0x0f, 0x48, 0xfb, 0xe5, 0x0c, 0xc4, 0xf8, 0x54, 0xf0, //0x8910,
	0xc8, 0x68, 0xf5, 0x0c, 0xe5, 0x0d, 0xc4, 0x54, 0x0f, 0x48, 0xf5, 0x0d, 0xe5, 0x41, 0x54, 0x10, //0x8920,
	0xd3, 0x94, 0x00, 0x40, 0x08, 0x85, 0x42, 0x4a, 0x85, 0x43, 0x4b, 0x80, 0x0b, 0x30, 0x39, 0x04, //0x8930,
	0x7f, 0x16, 0x80, 0x02, 0x7f, 0x1e, 0x8f, 0x4b, 0xaf, 0x4a, 0x12, 0x14, 0x76, 0xaf, 0x4b, 0x7e, //0x8940,
	0x00, 0xac, 0x0c, 0xad, 0x0d, 0x12, 0x14, 0x84, 0xfd, 0x7c, 0x00, 0xae, 0x0e, 0xaf, 0x0f, 0x12, //0x8950,
	0x0a, 0x9b, 0x8f, 0x4a, 0xae, 0x10, 0xaf, 0x11, 0x7c, 0x00, 0x30, 0x39, 0x04, 0x7d, 0x2d, 0x80, //0x8960,
	0x02, 0x7d, 0x3c, 0x12, 0x0a, 0x9b, 0x8f, 0x4b, 0x8b, 0x49, 0x85, 0x0d, 0x48, 0xaf, 0x4c, 0x12, //0x8970,
	0x14, 0x76, 0xaf, 0x4d, 0x7e, 0x00, 0x12, 0x14, 0x84, 0xfb, 0xae, 0x0e, 0xaf, 0x0f, 0xfd, 0x7c, //0x8980,
	0x00, 0x12, 0x0a, 0x9b, 0x8f, 0x4c, 0xae, 0x10, 0xaf, 0x11, 0xad, 0x03, 0x7c, 0x00, 0x12, 0x0a, //0x8990,
	0x9b, 0x8f, 0x4d, 0xe5, 0x4c, 0x75, 0xf0, 0x02, 0xa4, 0xad, 0x49, 0x7c, 0x00, 0xd3, 0x9d, 0x74, //0x89a0,
	0x80, 0xf8, 0x65, 0xf0, 0x98, 0x40, 0x05, 0xe5, 0x49, 0x13, 0xf5, 0x4c, 0xe5, 0x4d, 0x75, 0xf0, //0x89b0,
	0x02, 0xa4, 0xd3, 0x95, 0x48, 0x74, 0x80, 0xf8, 0x65, 0xf0, 0x98, 0x40, 0x05, 0xe5, 0x48, 0x13, //0x89c0,
	0xf5, 0x4d, 0xe5, 0x4a, 0xc3, 0x95, 0x4c, 0x50, 0x03, 0x85, 0x4c, 0x4a, 0xe5, 0x4b, 0xc3, 0x95, //0x89d0,
	0x4d, //0x89e0,
};

static u8 OV5645AF_addr_data_pair11[255] =
{
	//0x89e1
	0x89,
	0xe1,
	0x50, 0x03, 0x85, 0x4d, 0x4b, 0xe5, 0x4a, 0x25, 0x4c, 0xff, 0xe4, 0x33, 0xfe, 0xd3, 0xef,
	0x9d, 0xec, 0x64, 0x80, 0xf8, 0xee, 0x64, 0x80, 0x98, 0x40, 0x06, 0xe5, 0x49, 0x95, 0x4c, 0xf5, //0x89f0,
	0x4a, 0xe5, 0x4b, 0x25, 0x4d, 0xff, 0xe4, 0x33, 0xfe, 0xd3, 0xef, 0x95, 0x48, 0x74, 0x80, 0xf8, //0x8a00,
	0x6e, 0x98, 0x40, 0x06, 0xe5, 0x48, 0x95, 0x4d, 0xf5, 0x4b, 0xc3, 0xe5, 0x4a, 0x95, 0x4c, 0xf5, //0x8a10,
	0x0a, 0xc3, 0xe5, 0x4b, 0x95, 0x4d, 0xf5, 0x0b, 0xe5, 0x4a, 0x25, 0x4c, 0xf9, 0xe5, 0x4b, 0x25, //0x8a20,
	0x4d, 0xfd, 0x90, 0x60, 0x01, 0xe4, 0xf0, 0xa3, 0xf0, 0xa3, 0xe5, 0x49, 0xf0, 0xa3, 0xe5, 0x48, //0x8a30,
	0xf0, 0x7c, 0x01, 0xec, 0x75, 0xf0, 0x04, 0xa4, 0xff, 0x24, 0x01, 0x12, 0x14, 0x9d, 0xe5, 0x0a, //0x8a40,
	0xf0, 0xef, 0x24, 0x02, 0xff, 0xee, 0x34, 0x60, 0x8f, 0x82, 0xf5, 0x83, 0xe5, 0x0b, 0xf0, 0xec, //0x8a50,
	0x75, 0xf0, 0x04, 0xa4, 0xff, 0x24, 0x03, 0x12, 0x14, 0x9d, 0xe9, 0xf0, 0xef, 0x24, 0x04, 0xff, //0x8a60,
	0xee, 0x34, 0x60, 0x8f, 0x82, 0xf5, 0x83, 0xed, 0xf0, 0x0c, 0xbc, 0x05, 0xc6, 0x90, 0x30, 0x01, //0x8a70,
	0xe0, 0x44, 0x40, 0xf0, 0xe0, 0x54, 0xbf, 0xf0, 0x22, 0xef, 0x8d, 0xf0, 0xa4, 0xa8, 0xf0, 0xcf, //0x8a80,
	0x8c, 0xf0, 0xa4, 0x28, 0xce, 0x8d, 0xf0, 0xa4, 0x2e, 0xfe, 0x22, 0xbc, 0x00, 0x0b, 0xbe, 0x00, //0x8a90,
	0x29, 0xef, 0x8d, 0xf0, 0x84, 0xff, 0xad, 0xf0, 0x22, 0xe4, 0xcc, 0xf8, 0x75, 0xf0, 0x08, 0xef, //0x8aa0,
	0x2f, 0xff, 0xee, 0x33, 0xfe, 0xec, 0x33, 0xfc, 0xee, 0x9d, 0xec, 0x98, 0x40, 0x05, 0xfc, 0xee, //0x8ab0,
	0x9d, 0xfe, 0x0f, 0xd5, 0xf0, 0xe9, 0xe4, 0xce, 0xfd, 0x22, 0xed, 0xf8, 0xf5, 0xf0, 0xee, 0x84, //0x8ac0,
	0x20, 0xd2, 0x1c, 0xfe, 0xad, 0xf0, 0x75, 0xf0, 0x08, 0xef, 0x2f, 0xff, 0xed, 0x33, //0x8ad0,
};

static u8 OV5645AF_addr_data_pair12[255] =
{
	//0x8ade
	0x8a,
	0xde,
	0xfd, 0x40,
	0x07, 0x98, 0x50, 0x06, 0xd5, 0xf0, 0xf2, 0x22, 0xc3, 0x98, 0xfd, 0x0f, 0xd5, 0xf0, 0xea, 0x22, //0x8ae0,
	0xe8, 0x8f, 0xf0, 0xa4, 0xcc, 0x8b, 0xf0, 0xa4, 0x2c, 0xfc, 0xe9, 0x8e, 0xf0, 0xa4, 0x2c, 0xfc, //0x8af0,
	0x8a, 0xf0, 0xed, 0xa4, 0x2c, 0xfc, 0xea, 0x8e, 0xf0, 0xa4, 0xcd, 0xa8, 0xf0, 0x8b, 0xf0, 0xa4, //0x8b00,
	0x2d, 0xcc, 0x38, 0x25, 0xf0, 0xfd, 0xe9, 0x8f, 0xf0, 0xa4, 0x2c, 0xcd, 0x35, 0xf0, 0xfc, 0xeb, //0x8b10,
	0x8e, 0xf0, 0xa4, 0xfe, 0xa9, 0xf0, 0xeb, 0x8f, 0xf0, 0xa4, 0xcf, 0xc5, 0xf0, 0x2e, 0xcd, 0x39, //0x8b20,
	0xfe, 0xe4, 0x3c, 0xfc, 0xea, 0xa4, 0x2d, 0xce, 0x35, 0xf0, 0xfd, 0xe4, 0x3c, 0xfc, 0x22, 0x75, //0x8b30,
	0xf0, 0x08, 0x75, 0x82, 0x00, 0xef, 0x2f, 0xff, 0xee, 0x33, 0xfe, 0xcd, 0x33, 0xcd, 0xcc, 0x33, //0x8b40,
	0xcc, 0xc5, 0x82, 0x33, 0xc5, 0x82, 0x9b, 0xed, 0x9a, 0xec, 0x99, 0xe5, 0x82, 0x98, 0x40, 0x0c, //0x8b50,
	0xf5, 0x82, 0xee, 0x9b, 0xfe, 0xed, 0x9a, 0xfd, 0xec, 0x99, 0xfc, 0x0f, 0xd5, 0xf0, 0xd6, 0xe4, //0x8b60,
	0xce, 0xfb, 0xe4, 0xcd, 0xfa, 0xe4, 0xcc, 0xf9, 0xa8, 0x82, 0x22, 0xb8, 0x00, 0xc1, 0xb9, 0x00, //0x8b70,
	0x59, 0xba, 0x00, 0x2d, 0xec, 0x8b, 0xf0, 0x84, 0xcf, 0xce, 0xcd, 0xfc, 0xe5, 0xf0, 0xcb, 0xf9, //0x8b80,
	0x78, 0x18, 0xef, 0x2f, 0xff, 0xee, 0x33, 0xfe, 0xed, 0x33, 0xfd, 0xec, 0x33, 0xfc, 0xeb, 0x33, //0x8b90,
	0xfb, 0x10, 0xd7, 0x03, 0x99, 0x40, 0x04, 0xeb, 0x99, 0xfb, 0x0f, 0xd8, 0xe5, 0xe4, 0xf9, 0xfa, //0x8ba0,
	0x22, 0x78, 0x18, 0xef, 0x2f, 0xff, 0xee, 0x33, 0xfe, 0xed, 0x33, 0xfd, 0xec, 0x33, 0xfc, 0xc9, //0x8bb0,
	0x33, 0xc9, 0x10, 0xd7, 0x05, 0x9b, 0xe9, 0x9a, 0x40, 0x07, 0xec, 0x9b, 0xfc, 0xe9, 0x9a, 0xf9, //0x8bc0,
	0x0f, 0xd8, 0xe0, 0xe4, 0xc9, 0xfa, 0xe4, 0xcc, 0xfb, 0x22, 0x75, //0x8bd0,
};

static u8 OV5645AF_addr_data_pair13[255] =
{
	//0x8bdb
	0x8b,
	0xdb,
	0xf0, 0x10, 0xef, 0x2f, 0xff,
	0xee, 0x33, 0xfe, 0xed, 0x33, 0xfd, 0xcc, 0x33, 0xcc, 0xc8, 0x33, 0xc8, 0x10, 0xd7, 0x07, 0x9b, //0x8be0,
	0xec, 0x9a, 0xe8, 0x99, 0x40, 0x0a, 0xed, 0x9b, 0xfd, 0xec, 0x9a, 0xfc, 0xe8, 0x99, 0xf8, 0x0f, //0x8bf0,
	0xd5, 0xf0, 0xda, 0xe4, 0xcd, 0xfb, 0xe4, 0xcc, 0xfa, 0xe4, 0xc8, 0xf9, 0x22, 0xeb, 0x9f, 0xf5, //0x8c00,
	0xf0, 0xea, 0x9e, 0x42, 0xf0, 0xe9, 0x9d, 0x42, 0xf0, 0xe8, 0x9c, 0x45, 0xf0, 0x22, 0xe8, 0x60, //0x8c10,
	0x0f, 0xec, 0xc3, 0x13, 0xfc, 0xed, 0x13, 0xfd, 0xee, 0x13, 0xfe, 0xef, 0x13, 0xff, 0xd8, 0xf1, //0x8c20,
	0x22, 0xe8, 0x60, 0x0f, 0xef, 0xc3, 0x33, 0xff, 0xee, 0x33, 0xfe, 0xed, 0x33, 0xfd, 0xec, 0x33, //0x8c30,
	0xfc, 0xd8, 0xf1, 0x22, 0xe4, 0x93, 0xfc, 0x74, 0x01, 0x93, 0xfd, 0x74, 0x02, 0x93, 0xfe, 0x74, //0x8c40,
	0x03, 0x93, 0xff, 0x22, 0xa4, 0x25, 0x82, 0xf5, 0x82, 0xe5, 0xf0, 0x35, 0x83, 0xf5, 0x83, 0x22, //0x8c50,
	0xd0, 0x83, 0xd0, 0x82, 0xf8, 0xe4, 0x93, 0x70, 0x12, 0x74, 0x01, 0x93, 0x70, 0x0d, 0xa3, 0xa3, //0x8c60,
	0x93, 0xf8, 0x74, 0x01, 0x93, 0xf5, 0x82, 0x88, 0x83, 0xe4, 0x73, 0x74, 0x02, 0x93, 0x68, 0x60, //0x8c70,
	0xef, 0xa3, 0xa3, 0xa3, 0x80, 0xdf, 0x90, 0x0e, 0x9a, 0x12, 0x0f, 0x65, 0x78, 0x98, 0xe6, 0xf5, //0x8c80,
	0x0f, 0x08, 0xe6, 0xf5, 0x10, 0xe4, 0xfd, 0xed, 0xc3, 0x94, 0x08, 0x50, 0x18, 0xe5, 0x10, 0x94, //0x8c90,
	0x00, 0xe5, 0x0f, 0x94, 0x78, 0x50, 0x0e, 0xe5, 0x10, 0x25, 0xe0, 0xf5, 0x10, 0xe5, 0x0f, 0x33, //0x8ca0,
	0xf5, 0x0f, 0x1d, 0x80, 0xe2, 0xc3, 0x74, 0x07, 0x9d, 0xfd, 0xc3, 0x94, 0x00, 0x50, 0x02, 0xe4, //0x8cb0,
	0xfd, 0x12, 0x0e, 0xca, 0xed, 0x90, 0x0d, 0xd5, 0x12, 0x0f, 0x8a, 0x12, 0x0a, 0xf0, 0x12, 0x0e, //0x8cc0,
	0xc2, 0xc0, 0x00, 0x78, 0xd0, 0xe6, 0x12, 0x0f, //0x8cd0,
};

static u8 OV5645AF_addr_data_pair14[255] =
{
	//0x8cd8
	0x8c,
	0xd8,
	0x25, 0xff, 0x33, 0x95, 0xe0, 0xfe, 0x74, 0xc4,
	0x2f, 0xf5, 0x82, 0x74, 0x0d, 0x12, 0x0f, 0x39, 0xd0, 0x00, 0x12, 0x0a, 0xf0, 0x12, 0x0e, 0xc2, //0x8ce0,
	0xc0, 0x00, 0xc0, 0x01, 0xc3, 0x79, 0xbf, 0xe7, 0x78, 0xbe, 0x96, 0x12, 0x0f, 0x25, 0xff, 0x33, //0x8cf0,
	0x95, 0xe0, 0xfe, 0x74, 0xb3, 0x2f, 0xf5, 0x82, 0x74, 0x0d, 0x12, 0x0f, 0x39, 0xd0, 0x01, 0xd0, //0x8d00,
	0x00, 0x12, 0x0e, 0xb2, 0x90, 0x0d, 0xee, 0x12, 0x0f, 0x89, 0x12, 0x0e, 0xb2, 0xc0, 0x00, 0xc0, //0x8d10,
	0x01, 0xc3, 0x79, 0xcf, 0xe7, 0x78, 0xce, 0x96, 0x12, 0x0f, 0x25, 0xff, 0x33, 0x95, 0xe0, 0xfe, //0x8d20,
	0x74, 0xdd, 0x2f, 0xf5, 0x82, 0x74, 0x0d, 0x12, 0x0f, 0x39, 0xd0, 0x01, 0xd0, 0x00, 0x12, 0x0f, //0x8d30,
	0x44, 0x78, 0x0e, 0x12, 0x0e, 0xbf, 0xc0, 0x00, 0x78, 0x98, 0xe6, 0xfe, 0x08, 0xe6, 0xff, 0xe4, //0x8d40,
	0xfc, 0xfd, 0xd0, 0x00, 0x12, 0x0f, 0x44, 0x78, 0x0e, 0x12, 0x0c, 0x1e, 0x12, 0x0f, 0x47, 0x90, //0x8d50,
	0x0e, 0x9b, 0x12, 0x0f, 0x89, 0x12, 0x0e, 0xca, 0xc3, 0x12, 0x0c, 0x0d, 0x50, 0x06, 0x90, 0x0e, //0x8d60,
	0x9b, 0x12, 0x0f, 0x65, 0x78, 0xc9, 0xe6, 0x12, 0x0e, 0xdf, 0xfe, 0x08, 0xe6, 0xff, 0xe4, 0xfc, //0x8d70,
	0xfd, 0x12, 0x0e, 0xca, 0xd3, 0x12, 0x0c, 0x0d, 0x40, 0x07, 0xe4, 0xf5, 0x0f, 0xf5, 0x10, 0x80, //0x8d80,
	0x1a, 0x85, 0x0d, 0x0f, 0x85, 0x0e, 0x10, 0x78, 0xc9, 0xe6, 0x25, 0xe0, 0x24, 0x57, 0xf8, 0xc3, //0x8d90,
	0xe6, 0x95, 0x10, 0xf5, 0x10, 0x18, 0xe6, 0x95, 0x0f, 0xf5, 0x0f, 0x78, 0x9c, 0xa6, 0x0f, 0x08, //0x8da0,
	0xa6, 0x10, 0x22, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, //0x8db0,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, //0x8dc0,
	0x80, 0x80, 0x80, 0x80, 0x80, //0x8dd0,
};

static u8 OV5645AF_addr_data_pair15[255] =
{
	//0x8dd5,
	0x8d,
	0xd5,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x10, 0x18, 0x20,
	0x28, 0x30, 0x38, 0x40, 0x48, 0x50, 0x58, 0x60, 0x68, 0x70, 0x78, 0x80, 0x80, 0x80, 0x80, 0x80, //0x8de0,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //0x8df0,
	0x13, 0x04, 0x26, 0x15, 0x01, 0x36, 0x4f, 0x56, 0x54, 0x20, 0x20, 0x20, 0x20, 0x20, 0x43, 0x01, //0x8e00,
	0x10, 0x00, 0x56, 0x45, 0x1a, 0x30, 0x29, 0x7e, 0x00, 0x30, 0x04, 0x20, 0xdf, 0x30, 0x05, 0x40, //0x8e10,
	0xbf, 0x50, 0x03, 0x00, 0xfd, 0x50, 0x27, 0x01, 0xfe, 0x60, 0x00, 0x13, 0x00, 0x36, 0x06, 0x07, //0x8e20,
	0x00, 0x3f, 0x05, 0x30, 0x00, 0x3f, 0x06, 0x22, 0x00, 0x3f, 0x08, 0x00, 0x00, 0x3f, 0x09, 0x00, //0x8e30,
	0x00, 0x3f, 0x0a, 0x00, 0x00, 0x3f, 0x0b, 0x0f, 0x00, 0x3f, 0x01, 0x2a, 0x00, 0x3f, 0x02, 0x00, //0x8e40,
	0x00, 0x30, 0x01, 0x40, 0xbf, 0x30, 0x01, 0x00, 0xbf, 0x30, 0x29, 0x70, 0x00, 0x3a, 0x00, 0x00, //0x8e50,
	0xff, 0x3a, 0x00, 0x00, 0xff, 0x36, 0x03, 0x36, 0x02, 0x41, 0x44, 0x58, 0x20, 0x18, 0x10, 0x0a, //0x8e60,
	0x04, 0x04, 0x00, 0x03, 0xff, 0x64, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, //0x8e70,
	0x04, 0x06, 0x06, 0x00, 0x02, 0x64, 0x00, 0xcc, 0x50, 0x28, 0x1e, 0x08, 0x08, 0x01, 0x1e, 0x1e, //0x8e80,8e84
	0x1e, 0x1e, 0x68, 0x68, 0x68, 0x68, 0x03, 0x05, 0x0a, 0x08, 0x10, 0x01, 0x0a, 0x06, 0x06, 0x05, //0x8e90,98/98 9/5
	0x05, 0x05, 0x05, 0x04, 0x04, 0x04, 0x04, 0x04, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0x00, 0xa5, //0x8ea0,
	0x5a, 0x00, 0x12, 0x0a, 0xf0, 0x8f, 0x0e, 0x8e, 0x0d, 0x8d, 0x0c, 0x8c, 0x0b, 0x78, 0x07, 0x12, //0x8eb0,
	0x0c, 0x1e, 0x8f, 0x0e, 0x8e, 0x0d, 0x8d, 0x0c, 0x8c, 0x0b, 0xab, 0x0e, 0xaa, 0x0d, 0xa9, 0x0c, //0x8ec0,
	0xa8, 0x0b, //0x8ed0,
};

static u8 OV5645AF_addr_data_pair16[255] =
{
	//0x8ed2
	0x8e,
	0xd2,
	0x22, 0xef, 0x25, 0xe0, 0x24, 0x56, 0xf8, 0xe6, 0xfc, 0x08, 0xe6, 0xfd, 0xee, 0x25,
	0xe0, 0x24, 0x56, 0xf8, 0xe6, 0x22, 0x78, 0xce, 0xf9, 0xc3, 0xe7, 0x64, 0x80, 0xf5, 0xf0, 0xe6, //0x8ee0,
	0x64, 0x80, 0x95, 0xf0, 0x22, 0x78, 0xcb, 0xe6, 0x78, 0x9d, 0x25, 0xe0, 0x24, 0x57, 0xf9, 0xd3, //0x8ef0,
	0xe7, 0x96, 0x19, 0xe7, 0x18, 0x96, 0x22, 0x78, 0xcf, 0xf9, 0xd3, 0xe7, 0x64, 0x80, 0xf5, 0xf0, //0x8f00,
	0xe6, 0x64, 0x80, 0x95, 0xf0, 0x22, 0xd3, 0x78, 0xc1, 0xe6, 0x64, 0x80, 0x94, 0x80, 0x22, 0x78, //0x8f10,
	0xc1, 0xe6, 0xf4, 0x04, 0xff, 0xa2, 0xe7, 0x13, 0xa2, 0xe7, 0x13, 0x22, 0xa6, 0x06, 0x08, 0xa6, //0x8f20,
	0x07, 0x78, 0x9a, 0xe6, 0xfe, 0x08, 0xe6, 0xff, 0x22, 0x3e, 0xf5, 0x83, 0xe4, 0x93, 0xff, 0xe4, //0x8f30,
	0xfc, 0xfd, 0xfe, 0x22, 0x12, 0x0a, 0xf0, 0x8f, 0x0e, 0x8e, 0x0d, 0x8d, 0x0c, 0x8c, 0x0b, 0x22, //0x8f40,
	0x78, 0xc9, 0xe6, 0x24, 0x9e, 0xf8, 0xe6, 0x78, 0xd0, 0xf6, 0x22, 0xc3, 0xe6, 0x64, 0x80, 0xf8, //0x8f50,
	0xef, 0x64, 0x80, 0x98, 0x22, 0xe4, 0x93, 0xff, 0xe4, 0x8f, 0x0e, 0xf5, 0x0d, 0xf5, 0x0c, 0xf5, //0x8f60,
	0x0b, 0x22, 0x78, 0xc1, 0xe6, 0xf4, 0x04, 0xf6, 0x22, 0xfa, 0x08, 0xe6, 0xc3, 0x9d, 0xea, 0x9c, //0x8f70,
	0x22, 0xf6, 0xd3, 0xe6, 0x64, 0x80, 0x94, 0x80, 0x22, 0xe4, 0x93, 0xff, 0xe4, 0xfc, 0xfd, 0xfe, //0x8f80,
	0x22, 0x78, 0x98, 0xa6, 0x06, 0x08, 0xa6, 0x07, 0x22, 0x78, 0xc5, 0xe6, 0x24, 0x9e, 0xf8, 0x22, //0x8f90,
	0x78, 0xd0, 0xe6, 0x78, 0xc4, 0xf6, 0x22, 0x85, 0x28, 0x46, 0x90, 0x30, 0x24, 0xe0, 0xf5, 0x42, //0x8fa0,
	0xa3, 0xe0, 0xf5, 0x43, 0xa3, 0xe0, 0xf5, 0x44, 0xa3, 0xe0, 0xf5, 0x45, 0xa3, 0xe0, 0xf5, 0x41, //0x8fb0,
	0xd2, 0x35, 0xe5, 0x46, 0x12, 0x0c, 0x60, 0x0f, 0xf2, 0x03, 0x0f, 0xff, 0x04, 0x10, 0x10, //0x8fc0,
};

static u8 OV5645AF_addr_data_pair17[255] =
{
	//0x8fcf,
	0x8f,
	0xcf,
	0x05,
	0x10, 0x13, 0x06, 0x10, 0x63, 0x07, 0x10, 0x1c, 0x08, 0x10, 0x31, 0x12, 0x10, 0x40, 0x1a, 0x10, //0x8fd0,
	0x4b, 0x1b, 0x10, 0x31, 0x80, 0x10, 0x2c, 0x81, 0x10, 0x63, 0xdc, 0x10, 0x53, 0xec, 0x00, 0x00, //0x8fe0,
	0x10, 0x7e, 0x12, 0x15, 0x4e, 0xd2, 0x37, 0xd2, 0x01, 0xc2, 0x02, 0x12, 0x15, 0x53, 0x22, 0xd2, //0x8ff0,
	0x34, 0xd2, 0x37, 0xe5, 0x42, 0xd3, 0x94, 0x00, 0x40, 0x03, 0x12, 0x15, 0x4e, 0xd2, 0x03, 0x22, //0x9000,
	0xd2, 0x03, 0x22, 0xc2, 0x03, 0x20, 0x01, 0x66, 0x30, 0x02, 0x48, 0x22, 0xc2, 0x01, 0xc2, 0x02, //0x9010,
	0xc2, 0x03, 0x12, 0x13, 0xc5, 0x75, 0x1d, 0x70, 0xd2, 0x36, 0x80, 0x37, 0x43, 0x41, 0x10, 0x80, //0x9020,
	0x0a, 0xe5, 0x41, 0x70, 0x03, 0xc3, 0x80, 0x01, 0xd3, 0x92, 0x39, 0x12, 0x08, 0x60, 0x80, 0x23, //0x9030,
	0x85, 0x45, 0x4e, 0x85, 0x41, 0x4f, 0x12, 0x12, 0xaf, 0x80, 0x18, 0x85, 0x4e, 0x45, 0x85, 0x4f, //0x9040,
	0x41, 0x80, 0x10, 0xc2, 0xaf, 0x85, 0x2a, 0x42, 0x85, 0x2b, 0x43, 0x85, 0x2c, 0x44, 0x85, 0x2d, //0x9050,
	0x45, 0xd2, 0xaf, 0x90, 0x30, 0x24, 0xe5, 0x42, 0xf0, 0xa3, 0xe5, 0x43, 0xf0, 0xa3, 0xe5, 0x44, //0x9060,
	0xf0, 0xa3, 0xe5, 0x45, 0xf0, 0xa3, 0xe5, 0x41, 0xf0, 0x90, 0x30, 0x23, 0xe4, 0xf0, 0x22, 0x78, //0x9070,
	0xc8, 0xe6, 0xf5, 0x0b, 0x18, 0xe6, 0xf5, 0x0c, 0xe4, 0xf5, 0x0d, 0xf5, 0x0e, 0xf5, 0x0f, 0xf9, //0x9080,
	0x78, 0xc9, 0xe6, 0x08, 0xf6, 0x78, 0xc7, 0xe6, 0xff, 0x04, 0xfe, 0x78, 0xc8, 0x12, 0x0f, 0x5b, //0x9090,
	0x50, 0x54, 0x12, 0x0e, 0xd3, 0xfa, 0x08, 0xe6, 0xd3, 0x9d, 0xea, 0x9c, 0x40, 0x14, 0x05, 0x0f, //0x90a0,
	0xd3, 0xe5, 0x0e, 0x64, 0x80, 0xf8, 0xe9, 0x64, 0x80, 0x98, 0x40, 0x02, 0x89, 0x0e, 0xe4, 0xf9, //0x90b0,
	0x80, 0x1b, 0x12, 0x0e, 0xd3, 0x12, 0x0f, 0x79, 0x50, 0x13, 0x09, 0xe5, //0x90c0,
};

static u8 OV5645AF_addr_data_pair18[255] =
{
	//0x90cc,
	0x90,
	0xcc,
	0x0d, 0x64, 0x80, 0xf8,
	0xe5, 0x0f, 0x64, 0x80, 0x98, 0x40, 0x03, 0x85, 0x0f, 0x0d, 0xe4, 0xf5, 0x0f, 0x78, 0xc9, 0xe6, //0x90d0,
	0x12, 0x0e, 0xd4, 0xfa, 0x08, 0xe6, 0xb5, 0x05, 0x08, 0xea, 0xb5, 0x04, 0x04, 0x78, 0xca, 0xa6, //0x90e0,
	0x06, 0x0f, 0x0e, 0x02, 0x10, 0x9b, 0x78, 0xc7, 0xe6, 0xf5, 0x0c, 0xe6, 0x04, 0xff, 0x78, 0xc9, //0x90f0,
	0x12, 0x0f, 0x5b, 0x50, 0x17, 0xe5, 0x0c, 0x12, 0x0e, 0xdf, 0xfc, 0x08, 0xe6, 0xfd, 0xef, 0x12, //0x9100,
	0x0e, 0xdf, 0x12, 0x0f, 0x79, 0x50, 0x02, 0x8f, 0x0c, 0x0f, 0x80, 0xe2, 0x78, 0xc8, 0xe6, 0xf5, //0x9110,
	0x0b, 0xe6, 0x14, 0xff, 0x78, 0xca, 0xd3, 0x12, 0x0f, 0x5c, 0x40, 0x17, 0xe5, 0x0b, 0x12, 0x0e, //0x9120,
	0xdf, 0xfc, 0x08, 0xe6, 0xfd, 0xef, 0x12, 0x0e, 0xdf, 0x12, 0x0f, 0x79, 0x50, 0x02, 0x8f, 0x0b, //0x9130,
	0x1f, 0x80, 0xe1, 0x78, 0xcb, 0xa6, 0x0c, 0x08, 0xa6, 0x0b, 0x22, 0xe5, 0x0a, 0x75, 0xf0, 0x03, //0x9140,
	0xa4, 0x24, 0xb3, 0x25, 0x0b, 0xf8, 0xe6, 0x22, 0xad, 0x11, 0xac, 0x10, 0xfa, 0xf9, 0xf8, 0x12, //0x9150,
	0x0a, 0xf0, 0x8f, 0x13, 0x8e, 0x12, 0x8d, 0x11, 0x8c, 0x10, 0xab, 0x0f, 0xaa, 0x0e, 0xa9, 0x0d, //0x9160,
	0xa8, 0x0c, 0x22, 0xe5, 0x0a, 0x75, 0xf0, 0x08, 0xa4, 0x24, 0x5a, 0xf8, 0xe5, 0x0b, 0x25, 0xe0, //0x9170,
	0x28, 0x22, 0xa6, 0x04, 0x08, 0xa6, 0x05, 0xef, 0x25, 0xe0, 0x25, 0xe0, 0x24, 0x2c, 0xf8, 0xe6, //0x9180,
	0xfe, 0x08, 0xe6, 0xff, 0x22, 0xe5, 0x0b, 0x93, 0xff, 0xe4, 0xfc, 0xfd, 0xfe, 0x12, 0x0a, 0xf0, //0x9190,
	0x8f, 0x0f, 0x8e, 0x0e, 0x8d, 0x0d, 0x8c, 0x0c, 0x22, 0x90, 0x0e, 0x8d, 0xe4, 0x93, 0xff, 0x25, //0x91a0,
	0xe0, 0x25, 0xe0, 0x24, 0x2a, 0xf8, 0xe6, 0xfc, 0x08, 0xe6, 0xfd, 0x22, 0x78, 0xaa, 0xe6, 0x75, //0x91b0,
	0xf0, 0x08, 0xa4, 0x22, 0xf8, 0xa6, 0x33, 0x78, 0xaa, //0x91c0,
};

static u8 OV5645AF_addr_data_pair19[255] =
{
	//0x91c9
	0x91,
	0xc9,
	0xe6, 0x75, 0xf0, 0x03, 0xa4, 0x22, 0xe5,
	0x0b, 0x25, 0xe0, 0x24, 0x5a, 0xf8, 0xe6, 0x22, 0x08, 0xa6, 0x2a, 0x08, 0xa6, 0x2b, 0x08, 0xa6, //0x91d0,
	0x2c, 0x08, 0xa6, 0x2d, 0x22, 0xe5, 0x0b, 0x24, 0x04, 0xff, 0x74, 0x01, 0xa8, 0x07, 0x08, 0x22, //0x91e0,
	0xe4, 0x8f, 0x0f, 0x8e, 0x0e, 0xf5, 0x0d, 0xf5, 0x0c, 0x22, 0x74, 0xb3, 0x25, 0x0b, 0xf8, 0xe6, //0x91f0,
	0x22, 0xc0, 0xe0, 0xc0, 0x83, 0xc0, 0x82, 0xc0, 0xd0, 0x90, 0x3f, 0x0c, 0xe0, 0xf5, 0x08, 0xe5, //0x9200,
	0x08, 0x30, 0xe3, 0x60, 0x30, 0x37, 0x52, 0x90, 0x60, 0x19, 0xe0, 0xf5, 0x2a, 0xa3, 0xe0, 0xf5, //0x9210,
	0x2b, 0x90, 0x60, 0x1d, 0xe0, 0xf5, 0x2c, 0xa3, 0xe0, 0xf5, 0x2d, 0x90, 0x60, 0x21, 0xe0, 0xf5, //0x9220,
	0x2e, 0xa3, 0xe0, 0xf5, 0x2f, 0x90, 0x60, 0x25, 0xe0, 0xf5, 0x30, 0xa3, 0xe0, 0xf5, 0x31, 0x30, //0x9230,
	0x01, 0x06, 0x30, 0x34, 0x03, 0xd3, 0x80, 0x01, 0xc3, 0x92, 0x09, 0x30, 0x02, 0x06, 0x30, 0x34, //0x9240,
	0x03, 0xd3, 0x80, 0x01, 0xc3, 0x92, 0x0a, 0x30, 0x34, 0x0c, 0x30, 0x03, 0x09, 0x20, 0x02, 0x06, //0x9250,
	0x20, 0x01, 0x03, 0xd3, 0x80, 0x01, 0xc3, 0x92, 0x0b, 0x90, 0x30, 0x01, 0xe0, 0x44, 0x40, 0xf0, //0x9260,
	0xe0, 0x54, 0xbf, 0xf0, 0xe5, 0x08, 0x30, 0xe1, 0x14, 0x30, 0x35, 0x11, 0x90, 0x30, 0x22, 0xe0, //0x9270,
	0xf5, 0x28, 0xe4, 0xf0, 0x30, 0x00, 0x03, 0xd3, 0x80, 0x01, 0xc3, 0x92, 0x08, 0xe5, 0x08, 0x30, //0x9280,
	0xe2, 0x0e, 0x90, 0x51, 0xa5, 0xe0, 0xf5, 0x33, 0xa3, 0xe0, 0xf5, 0x34, 0xa3, 0xe0, 0xf5, 0x35, //0x9290,
	0x90, 0x3f, 0x0c, 0xe5, 0x08, 0xf0, 0xd0, 0xd0, 0xd0, 0x82, 0xd0, 0x83, 0xd0, 0xe0, 0x32, 0xe5, //0x92a0,
	0x4f, 0xd3, 0x94, 0x40, 0x40, 0x04, 0x7f, 0x40, 0x80, 0x02, 0xaf, 0x4f, 0x8f, 0x4f, 0x90, 0x0e, //0x92b0,
	0x86, 0xe4, 0x93, 0xfe, 0x74, 0x01, //0x92c0,
};

static u8 OV5645AF_addr_data_pair20[255] =
{
	//0x92c6,
	0x92,
	0xc6,
	0x93, 0xff, 0xc3, 0x90, 0x0e, 0x84, 0x74, 0x01, 0x93, 0x9f,
	0xff, 0xe4, 0x93, 0x9e, 0xfe, 0xe4, 0x8f, 0x12, 0x8e, 0x11, 0xf5, 0x10, 0xf5, 0x0f, 0xab, 0x12, //0x92d0,
	0xaa, 0x11, 0xa9, 0x10, 0xa8, 0x0f, 0xaf, 0x4f, 0xfc, 0xfd, 0xfe, 0x12, 0x0a, 0xf0, 0x12, 0x14, //0x92e0,
	0xfd, 0xe4, 0x7b, 0x40, 0xfa, 0xf9, 0xf8, 0x12, 0x0b, 0x7b, 0x12, 0x14, 0xfd, 0x90, 0x0e, 0x71, //0x92f0,
	0xe4, 0x12, 0x15, 0x12, 0x12, 0x14, 0xfd, 0xe4, 0x85, 0x4e, 0x0e, 0xf5, 0x0d, 0xf5, 0x0c, 0xf5, //0x9300,
	0x0b, 0xaf, 0x0e, 0xae, 0x0d, 0xad, 0x0c, 0xac, 0x0b, 0xa3, 0x12, 0x15, 0x12, 0x8f, 0x0e, 0x8e, //0x9310,
	0x0d, 0x8d, 0x0c, 0x8c, 0x0b, 0xe5, 0x12, 0x45, 0x0e, 0xf5, 0x12, 0xe5, 0x11, 0x45, 0x0d, 0xf5, //0x9320,
	0x11, 0xe5, 0x10, 0x45, 0x0c, 0xf5, 0x10, 0xe5, 0x0f, 0x45, 0x0b, 0xf5, 0x0f, 0xe4, 0xf5, 0x22, //0x9330,
	0xf5, 0x23, 0x85, 0x12, 0x40, 0x85, 0x11, 0x3f, 0x85, 0x10, 0x3e, 0x85, 0x0f, 0x3d, 0x02, 0x14, //0x9340,
	0xaf, 0x75, 0x89, 0x03, 0x75, 0xa8, 0x01, 0x75, 0xb8, 0x04, 0x75, 0x0a, 0xff, 0x75, 0x0b, 0x0e, //0x9350,
	0x75, 0x0c, 0x15, 0x75, 0x0d, 0x0f, 0x12, 0x14, 0x36, 0x12, 0x08, 0x60, 0xc2, 0x39, 0x12, 0x00, //0x9360,
	0x06, 0xd2, 0x00, 0xd2, 0x35, 0xd2, 0xaf, 0x75, 0x0a, 0xff, 0x75, 0x0b, 0x0e, 0x75, 0x0c, 0x51, //0x9370,
	0x75, 0x0d, 0x03, 0x12, 0x14, 0x36, 0x30, 0x08, 0x09, 0xc2, 0x35, 0x12, 0x0f, 0xa7, 0xc2, 0x08, //0x9380,
	0xd2, 0x35, 0x30, 0x0b, 0x09, 0xc2, 0x37, 0x12, 0x04, 0xa8, 0xc2, 0x0b, 0xd2, 0x37, 0x30, 0x09, //0x9390,
	0x09, 0xc2, 0x37, 0x12, 0x00, 0x0e, 0xc2, 0x09, 0xd2, 0x37, 0x30, 0x0e, 0x03, 0x12, 0x08, 0x60, //0x93a0,
	0x30, 0x36, 0xd3, 0x90, 0x30, 0x29, 0xe5, 0x1d, 0xf0, 0xb4, 0x10, 0x05, 0x90, 0x30, 0x23, 0xe4, //0x93b0,
	0xf0, 0xc2, 0x36, //0x93c0,
};

static u8 OV5645AF_addr_data_pair21[255] =
{
	//0x93c3
	0x93,
	0xc3,
	0x80, 0xc1, 0xe4, 0xf5, 0x4f, 0x90, 0x0e, 0x82, 0x93, 0xff, 0xe4, 0x8f, 0x0d,
	0xf5, 0x0c, 0xf5, 0x0b, 0xf5, 0x0a, 0xaf, 0x0d, 0xae, 0x0c, 0xad, 0x0b, 0xac, 0x0a, 0x90, 0x0e, //0x93d0,
	0x72, 0x12, 0x15, 0x12, 0x8f, 0x0d, 0x8e, 0x0c, 0x8d, 0x0b, 0x8c, 0x0a, 0x90, 0x0e, 0x7a, 0x12, //0x93e0,
	0x0c, 0x44, 0xef, 0x45, 0x0d, 0xf5, 0x0d, 0xee, 0x45, 0x0c, 0xf5, 0x0c, 0xed, 0x45, 0x0b, 0xf5, //0x93f0,
	0x0b, 0xec, 0x45, 0x0a, 0xf5, 0x0a, 0xe4, 0xf5, 0x22, 0xf5, 0x23, 0x85, 0x0d, 0x40, 0x85, 0x0c, //0x9400,
	0x3f, 0x85, 0x0b, 0x3e, 0x85, 0x0a, 0x3d, 0x12, 0x14, 0xaf, 0xe4, 0xf5, 0x22, 0xf5, 0x23, 0x90, //0x9410,
	0x0e, 0x7a, 0x12, 0x15, 0x06, 0x12, 0x14, 0xaf, 0xe4, 0xf5, 0x22, 0xf5, 0x23, 0x90, 0x0e, 0x76, //0x9420,
	0x12, 0x15, 0x06, 0x02, 0x14, 0xaf, 0xae, 0x0b, 0xaf, 0x0c, 0xe4, 0xfd, 0xed, 0xc3, 0x95, 0x0d, //0x9430,
	0x50, 0x33, 0x12, 0x15, 0x68, 0xe4, 0x93, 0xf5, 0x0e, 0x74, 0x01, 0x93, 0xf5, 0x0f, 0x45, 0x0e, //0x9440,
	0x60, 0x23, 0x85, 0x0f, 0x82, 0x85, 0x0e, 0x83, 0xe0, 0xfc, 0x12, 0x15, 0x68, 0x74, 0x03, 0x93, //0x9450,
	0x52, 0x04, 0x12, 0x15, 0x68, 0x74, 0x02, 0x93, 0x42, 0x04, 0x85, 0x0f, 0x82, 0x85, 0x0e, 0x83, //0x9460,
	0xec, 0xf0, 0x0d, 0x80, 0xc7, 0x22, 0x7e, 0x00, 0xad, 0x03, 0xac, 0x02, 0x12, 0x0a, 0x89, 0x8e, //0x9470,
	0x0e, 0x8f, 0x0f, 0x22, 0x12, 0x0a, 0x89, 0x8e, 0x10, 0x8f, 0x11, 0x90, 0x0e, 0x88, 0xe4, 0x93, //0x9480,
	0x22, 0xc3, 0xe5, 0x0d, 0x9f, 0xf5, 0x0d, 0xe5, 0x0c, 0x9e, 0xf5, 0x0c, 0x22, 0xae, 0xf0, 0xfb, //0x9490,
	0xee, 0x34, 0x60, 0x8b, 0x82, 0xf5, 0x83, 0x22, 0xe0, 0xfe, 0xa3, 0xe0, 0xfd, 0xed, 0x22, 0xa2, //0x94a0,
	0xaf, 0x92, 0x33, 0xc2, 0xaf, 0xe5, 0x23, 0x45, 0x22, 0x90, 0x0e, 0x65, 0x60, 0x0e, 0x12, 0x15, //0x94b0,
};

static u8 OV5645AF_addr_data_pair22[181] =
{
	//0x94c0,
	0x94,
	0xc0,
	0x43, 0xe0, 0xf5, 0x3b, 0x12, 0x15, 0x40, 0xe0, 0xf5, 0x3c, 0x80, 0x0c, 0x12, 0x15, 0x43, 0xe5, //0x94c0,
	0x3f, 0xf0, 0x12, 0x15, 0x40, 0xe5, 0x40, 0xf0, 0xa2, 0x33, 0x92, 0xaf, 0x22, 0x78, 0xcc, 0x12, //0x94d0,
	0x0e, 0xf7, 0x40, 0x0d, 0x12, 0x0e, 0xf5, 0x40, 0x04, 0xe4, 0xff, 0x80, 0x0f, 0x7f, 0x01, 0x80, //0x94e0,
	0x0b, 0x12, 0x0e, 0xf5, 0x40, 0x04, 0x7f, 0xff, 0x80, 0x02, 0x7f, 0xfe, 0x22, 0x8f, 0x12, 0x8e, //0x94f0,
	0x11, 0x8d, 0x10, 0x8c, 0x0f, 0x22, 0x12, 0x0c, 0x44, 0x8f, 0x40, 0x8e, 0x3f, 0x8d, 0x3e, 0x8c, //0x9500,
	0x3d, 0x22, 0x93, 0xf9, 0xf8, 0x02, 0x0c, 0x31, 0xc0, 0xe0, 0xc0, 0x83, 0xc0, 0x82, 0x90, 0x3f, //0x9510,
	0x0d, 0xe0, 0xf5, 0x09, 0xe5, 0x09, 0xf0, 0xd0, 0x82, 0xd0, 0x83, 0xd0, 0xe0, 0x32, 0xc3, 0xee, //0x9520,
	0x64, 0x80, 0x94, 0x80, 0x40, 0x02, 0x80, 0x07, 0xc3, 0xe4, 0x9f, 0xff, 0xe4, 0x9e, 0xfe, 0x22, //0x9530,
	0x90, 0x0e, 0x67, 0xe4, 0x93, 0xfe, 0x74, 0x01, 0x93, 0xf5, 0x82, 0x8e, 0x83, 0x22, 0xd2, 0x01, //0x9540,
	0xc2, 0x02, 0xe4, 0xf5, 0x1e, 0xf5, 0x1d, 0xd2, 0x36, 0xd2, 0x34, 0x22, 0x78, 0x7f, 0xe4, 0xf6, //0x9550,
	0xd8, 0xfd, 0x75, 0x81, 0xd1, 0x02, 0x13, 0x51, 0x8f, 0x82, 0x8e, 0x83, 0x75, 0xf0, 0x04, 0xed, //0x9560,
	0x02, 0x0c, 0x54, 
};

static u8 OV5645_FW_data_pair_size[] = {
	254,
	255,
	255,
	255,
	255,
	255,
	255,
	255,
	255,
	255,
	255,
	255,
	255,
	255,
	255,
	255,
	255,
	255,
	255,
	255,
	255,
	181,
};
static u8 * OV5645_AF_firmware[] = {
	OV5645AF_addr_data_pair1,
	OV5645AF_addr_data_pair2,
	OV5645AF_addr_data_pair3,
	OV5645AF_addr_data_pair4,
	OV5645AF_addr_data_pair5,
	OV5645AF_addr_data_pair6,
	OV5645AF_addr_data_pair7,
	OV5645AF_addr_data_pair8,
	OV5645AF_addr_data_pair9,
	OV5645AF_addr_data_pair10,
	OV5645AF_addr_data_pair11,
	OV5645AF_addr_data_pair12,
	OV5645AF_addr_data_pair13,
	OV5645AF_addr_data_pair14,
	OV5645AF_addr_data_pair15,
	OV5645AF_addr_data_pair16,
	OV5645AF_addr_data_pair17,
	OV5645AF_addr_data_pair18,
	OV5645AF_addr_data_pair19,
	OV5645AF_addr_data_pair20,
	OV5645AF_addr_data_pair21,
	OV5645AF_addr_data_pair22,

};
#endif /* OV5645_FIRMWARE_H */
