// ----------------------------------------------------------------------
// This file is automatically generated from the script:
// 
// ./create_headers_from_register_map_h.pl
// 
// and was applied to the file
// 
// ./register_map.h
// 
// DO NOT EDIT!!!!!
// ----------------------------------------------------------------------
// 
#ifdef REGISTER_H
#else
#define REGISTER_H


#include "dos_register.h"
#define Wr(addr, data) *(volatile unsigned long *)(addr)=(data)
#define Rd(addr) *(volatile unsigned long *)(addr)
#define Wr_reg_bits(reg, val, start, len) \
  Wr(reg, ((Rd(reg) & ~(((1L<<(len))-1)<<(start))) | ((unsigned int)(val) << (start))))

//
// Reading file:  ./register_map.h
//
// synopsys translate_off
// synopsys translate_on
//
// Reading file:  stb_define.h
//
// synopsys translate_off
// synopsys translate_on
// -----------------------------------------------
// CBUS_BASE:  STB_CBUS_BASE = 0x16
// -----------------------------------------------
// There are two instantiations under one CBUS slave.  Each CBUS slave can support
// 256 registers.  Each demux is allocated 128 registers so set the offset in
// the middle
// Copy this define but don't add a base address
#define SECOND_DEMUX_OFFSET_0  0x50
#define THIRD_DEMUX_OFFSET_0   0xa0
//========================================================================
//  STB TOP Registers				    (8'hf0 - 8'hf7)
//========================================================================
// bit 30:28 -- ciplus_o_sel
// bit 27:26 -- ciplus_i_sel
// bit 25 -- use FAIL fro TS2
// bit 24 -- use FAIL fro TS1
// bit 23 -- use FAIL fro TS0
// bit 22 -- invert fec_error for S2P1
// bit 21 -- invert fec_data for S2P1
// bit 20 -- invert fec_sync for S2P1
// bit 19 -- invert fec_valid for S2P1
// bit 18 -- invert fec_clk for S2P1
// bit 17:16 -- fec_s_sel for S2P1  00 - select TS0, 01 -- select TS1, 10 -- select TS2, 11 - reserved
// Bit 15 -- enable_des_pl_clk
// Bit 14:13 -- reserved
// Bit 12:10 -- ts_out_select, 0-TS0, 1-TS1, 2-TS2, 3,4-Reserved, 5-S2P1, 6-S2P0, 7-File
// bit 9:8 -- des_i_sel 00 -- select_fec_0, 01 -- select_fec_1, 10 -- select_fec_2, 11 - reserved
// bit 7 -- enable_des_pl
// bit 6 -- invert fec_error for S2P0
// bit 5 -- invert fec_data for S2P0
// bit 4 -- invert fec_sync for S2P0
// bit 3 -- invert fec_valid for S2P0
// bit 2 -- invert fec_clk for S2P0
// bit 1:0 -- fec_s_sel for S2P0  00 - select TS0, 01 -- select TS1, 10 -- select TS2, 11 - reserved
#define STB_TOP_CONFIG                             ((0x16f0  << 2) + 0xc1100000)
// 31:28 - s2p1_clk_div
// 27:24 - s2p0_clk_div
// 23    - s2p1_disable
// 22    - s2p0_disable
// 21    - Reserved
// 20 -- TS_OUT_error_INVERT
// 19 -- TS_OUT_data_INVERT
// 18 -- TS_OUT_sync_INVERT
// 17 -- TS_OUT_valid_INVERT
// 16 -- TS_OUT_clk_INVERT
// 15:8 -- TS_package_length_sub_1 (default : 187)
//  7:0 -- fec_sync_byte (default : 0x47)
#define TS_TOP_CONFIG                              ((0x16f1  << 2) + 0xc1100000)
// Bit 23:16 -- file_m2ts_skip_bytes
// Bit 15:8 -- des_out_dly
// Bit 7:6 -- transport_scrambling_control_odd // should be 3
// Bit 5 -- ts_hiu_enable
// Bit 4:0 -- fec_clk_div
#define TS_FILE_CONFIG                             ((0x16f2  << 2) + 0xc1100000)
// Bit 13:8 -- des ts pl state   -- Read Only
// Bit 3:0 PID index to 8 PID to get key-set
// auto increse after TS_PL_PID_DATA read/write
#define TS_PL_PID_INDEX                            ((0x16f3  << 2) + 0xc1100000)
// Bit 13 -- PID match disble
// Bit 12:0 -- PID
#define TS_PL_PID_DATA                             ((0x16f4  << 2) + 0xc1100000)
#define COMM_DESC_KEY0                             ((0x16f5  << 2) + 0xc1100000)
#define COMM_DESC_KEY1                             ((0x16f6  << 2) + 0xc1100000)
#define COMM_DESC_KEY_RW                           ((0x16f7  << 2) + 0xc1100000)
// CI+ Register defines
// Bits[31:0] of the key
#define CIPLUS_KEY0                                ((0x16f8  << 2) + 0xc1100000)
// Bits[63:32] of the key
#define CIPLUS_KEY1                                ((0x16f9  << 2) + 0xc1100000)
// Bits[95:64] of the key
#define CIPLUS_KEY2                                ((0x16fa  << 2) + 0xc1100000)
// Bits[127:96] of the key
#define CIPLUS_KEY3                                ((0x16fb  << 2) + 0xc1100000)
// bit[5] write AES IV B value
// bit[4] write AES IV A value
// bit[3] write AES B key
// bit[2] write AES A key
// bit[1] write DES B key
// bit[0] write DES A key
#define CIPLUS_KEY_WR                              ((0x16fc  << 2) + 0xc1100000)
// [15:8]   TS out delay.  This controls the rate at which the CIplus module drives TS out
// [3]      General enable for the ciplus module
// [2]      AES CBC disable (default should be 0 to enable AES CBC)
// [1]      AES Enable
// [0]      DES Eanble
#define CIPLUS_CONFIG                              ((0x16fd  << 2) + 0xc1100000)
// bit[31:28] AES IV endian
// bit[27:24] AES message out endian
// bit[23:20] AES message in endian
// bit[19:16] AES key endian
// bit[15:11]  unused
// bit[10:8]  DES message out endian
// bit[6:4]   DES message in endian
// bit[2:0]   DES key endian
#define CIPLUS_ENDIAN                              ((0x16fe  << 2) + 0xc1100000)
//
// NOTE:  Don't process the demux registers using the standard create_headers.... perl script.
//        Instead, since the demux has multiple instances (and many registers) use a separate
//        script to create a separate stb_define.h for C-code.  
//========================================================================
//  STB Registers				    (8'h00 - 8'h4f)
//
//========================================================================
// STB registers are 8'h0x
// Bit 15:0 -- version number : 0x0002  (v0.01)
// Bit 15 -- fec_core_select 1 - select descramble output
// Bit 14:12 -  fec_select 0-TS0, 1-TS1, 2-TS2, 3,4-Reserved, 5-S2P1, 6-S2P0, 7-File 
// Bit 11 -- FEC_CLK
// Bit 10 -- SOP
// Bit 9 -- D_VALID
// Bit 8 -- D_FAIL
// Bit 7:0 -- D_DATA 7:0
// bit 31 -- enable_free_clk_fec_data_valid
// bit 30 -- enable_free_clk_stb_reg
// bit 29 -- reserved
// bit 28 -- disable_pre_incomplete_section_fix
// bit 27 -- pointer_field_multi_pre_en
// bit 26 -- ignore_pre_incomplete_section
// bit 25 -- video2_enable
// bit 24:22 -- video2_type
// bit 21 -- do_not_trust_pes_package_length
// bit 20 (bit 4) -- Bypass use recoder path
// bit 19 (bit 3) -- clear_PID_continuity_counter_valid
// bit 18 (bit 2) -- Disable Splicing
// bit 17 (bit 1) -- Insert PES_STRONG_SYNC in Audio PES
// bit 16 (bit 0) -- Insert PES_STRONG_SYNC in Video PES
// Bit 15 - do not trust section length
// Bit 14 - om cmd push even zero
// Bit 13 - reserved
// Bit 12 - SUB, OTHER PES interrupt at beginning of PES
// Bit 11 - discard_av_package -- for ts_recorder use only 
// Bit 10 - ts_recorder_select  0:after PID filter 1:before PID filter
// Bit 9 - ts_recorder_enable
// Bit 8 - (table_id == 0xff) means section_end
// Bit 7 - do not send uncomplete section
// Bit 6 - do not discard duplicate package
// Bit 5 - search SOP when trasport_error_indicator
// Bit 4 - stb demux enable
// Bit 3 - do not reset state machine on SOP
// Bit 2 - search SOP when error happened ( when ignore_fail_n_sop, will have this case)
// Bit 1 - do not use SOP input ( check FEC sync byte instead )
// Bit 0 - ignore fec_error bit when non sop ( check error on SOP only)
// bit 15:8 demux package length - 1 ( default : 187 )
// bit 7:0 default is 0x47
// bit 31:16 -- filter memory write data hi[31:16]
// bit 15:0 -- filter memory write data low [15:0]
// bit 31:24 -- advanced setting hi
// bit 23:16 -- advanced setting low
// bit 15 -- filter memory write data request
// bit 7:0 -- filter memory write addr
// bit 13:8 demux state  -- read only
// bit 7:4 -- maxnum section filter compare address
// bit 3:0 -- maxnum PID filter compare address
// bit 15 - transport_error_indicator
// bit 14 - payload_unit_start_indicator
// bit 13 - transport_priority
// bit 12:0 - PID
// bit 7:6 transport_scrambling_control
// bit 5:4 adaptation_field_control
// bit 3:0 continuity_counter
// bit 15:12 -- om_cmd_count (read only)
// bit  11:9 -- overflow_count // bit  11:9 -- om_cmd_wr_ptr (read only)
// bit   8:6 -- om_overwrite_count // bit   8:6 -- om_cmd_rd_ptr (read only)
// bit   5:3 -- type_stb_om_w_rd (read only)
// bit     2 -- unit_start_stb_om_w_rd (read only)
// bit     1 -- om_cmd_overflow (read only)
// bit     0 -- om_cmd_pending (read) 
// bit     0 -- om_cmd_read_finished (write)
// bit 15:9 // bit 14:8 -- count_stb_om_w_rd  (read only)
// bit 8:0  // bit  7:0 -- start_stb_om_wa_rd (read only)
// bit 11:0 -- offset for section data
// bit 31:16 -- base address for section buffer group 0 (*0x400 to get real address)
// bit 15:0 -- base address for section buffer group 1 (*0x400 to get real address)
// bit 31:16 -- ba2e address for section buffer group 2 (*0x400 to get real address)
// bit 15:0 -- base address for section buffer group 3 (*0x400 to get real address)
// bit 3:0 -- section buffer size for group 0 (bit used,  for example, 10 means 1K)
// bit 7:4 -- section buffer size for group 1
// bit 11:8 -- section buffer size for group 2
// bit 15:12 -- section buffer size for group 3
// section buffer busy status for buff 31:0 ( Read Only )
// section buffer write status for buff 31:0 -- Read
// clear buffer status ( buff READY and BUSY ) -- write
// bit 4:0 -- SEC_BUFFER_INDEX   RW
// bit 12:8 -- SEC_BUFFER_NUMBER for the INDEX buffer  Read_Only
// bit 14 -- output_section_buffer_valid
// bit 15 -- section_reset_busy (Read Only)
// bit 9:5 -- BYPASS PID number
// bit 4:0 -- PCR PID number
// bit 15:0 -- stream_id filter bit enable
// bit 7:0 -- stream_id filter target
// bit 12 -- PCR_EN
// bit 11:0 -- PCR90K_DIV
// bit 15:0 -- PCR[31:0] R/W
// bit 15:0 -- VPTS[31:0] R/W
// bit 15:0 -- VDTS[31:0] R/W
// bit 15:0 -- APTS[31:0] R/W
// bit 15:0 -- SPTS[31:0] R/W
// read -- status, write 1 clear status
// bit 15 -- SUB_PTS[32]
// bit 14 -- AUDIO_PTS[32]
// bit 13 -- VIDEO_DTS[32]
// bit 12 -- VIDEO_PTS[32]
// bit 3 -- sub_pts_ready
// bit 2 -- audio_pts_ready
// bit 1 -- video_dts_ready
// bit 0 -- video_pts_ready
// bit 3:0 --
//  0 -- adaptation_field_length[7:0], adaption_field_byte_1[7:0] 
//  1 -- stream_id[7:0], pes_header_bytes_left[7:0]
//  2 -- pes_package_bytes_left[15:0]
//  3 -- pes_ctr_byte[7:0], pes_flag_byte[7:0]
// 
// read only
// default : 0x807f
// bit 15:9  -- MAX OM DMA COUNT  (default: 0x40) 
// bit 8:0   -- LAST ADDR OF OM ADDR (default: 127)
// 15:0  WRITE 1 CLEAR to clear interrupt source
// 9 -- splicing_point
// 8 -- other_PES_int
// 7 -- sub_PES_int 
// 6 -- discontinuity
// 5 -- duplicated_pack_found
// 4 -- New PDTS ready
// 3 -- om_cmd_buffer ready for access
// 2 -- section buffer ready 
// 1 -- transport_error_indicator
// 0 -- TS ERROR PIN 
// Bit 5:3 - demux om write endian control for bypass
// Bit 2:0 - demux om write endian control for section
// When Bit 31 - 1 write will indicate all type use sepertate endian (Write Only)
// Bit 23:21 - demux om write endian control for OTHER_PES_PACKET
// Bit 20:18 - demux om write endian control for SCR_ONLY_PACKET
// Bit 17:15 - demux om write endian control for SUB_PACKET
// Bit 14:12 - demux om write endian control for AUDIO_PACKET
// Bit 11:9  - demux om write endian control for VIDEO_PACKET
// 
// When Bit 31 - 0 write will indicate all type else use Bit 8:6
// Bit 8:6 - demux om write endian control for else
// Bit 15:8 -- last_burst_threshold
// Bit 7 -- use hi_bsf interface
// Bit 6:2 - fec_clk_div
// Bit 1 ts_source_sel 
// Bit 0 - Hiu TS generate enable 
// bit 15:0 -- base address for section buffer start (*0x10000 to get real base)
// bit 11 -- mask bit for OTHER_PES_AHB_DMA_EN
// bit 10 -- mask bit for SUB_AHB_DMA_EN
// bit 9 -- mask bit for BYPASS_AHB_DMA_EN
// bit 8 -- mask bit for SECTION_AHB_DMA_EN
// bit 7 -- mask bit for recoder stream
// bit 6:0 -- mask bit for each type
// bit 31:0 -- vb_wr_ptr for video PDTS 
// bit 31:0 -- ab_wr_ptr for audio PDTS
// bit 20:0 -- SB_WRITE_PTR (sb_wr_ptr << 3 == byte write position)
// bit 19:0 -- SB_START (sb_start << 12 == byte address);  
// bit 20:0 -- SB_SIZE (sb_size << 3 == byte size, 16M maximun) 
// bit 31:0 -- sb_wr_ptr for sub PES
// bit 31:16 -- ob_wr_ptr for other PES
// bit 20:0 -- OB_WRITE_PTR (ob_wr_ptr << 3 == byte write position)
// bit 19:0 -- OB_START (ob_start << 12 == byte address);  
// bit 20:0 -- OB_SIZE (ob_size << 3 == byte size, 16M maximun) 
// bit 31:0 -- ob_wr_ptr for sub PES
// 15:0  DEMUX interrupt MASK
// 9 -- splicing_point
// 8 -- other_PES_int
// 7 -- sub_PES_int 
// 6 -- discontinuity
// 5 -- duplicated_pack_found
// 4 -- New PDTS ready
// 3 -- om_cmd_buffer ready for access
// 2 -- section buffer ready 
// 1 -- transport_error_indicator
// 0 -- TS ERROR PIN 
// 31:16 VIDEO PID filter data
//15 -- splicing VIDEO PID change enable 
//14:10 -- VIDEO PID FILTER ADDRESS
// 9 -- PES splicing active (Read Only) 
// 8 -- splicing active (Read Only)
// 7:0  splicing countdown (Read Only)
// 31:16 AUDIO PID filter data
//15 -- splicing AUDIO PID change enable 
//14:10 -- AUDIO PID FILTER ADDRESS
// 9 -- PES splicing active (Read Only) 
// 8 -- splicing active (Read Only)
// 7:0  splicing countdown (Read Only)
// 23:16 M2TS_SKIP_BYTES
// 15:8 LAST TS PACKAGE BYTE COUNT (Read Only)
// 7:0  PACKAGE BYTE COUNT (Read Only)
// 15:0 2 bytes strong sync add to PES
// bit 15 -- stb_om_ren
// bit 14:11 -- reserved
// bit  10:0 -- OM_DATA_RD_ADDR
// bit 15:0 -- OM_DATA_RD
// AUTO STOP SETTING for 32 channels
// 4-nbits per channel
// when write
// bit 3 -- set section active
// bit 2:0 -- auto stop after count (0 means never stop)
// when read
// bit 3 -- current active status (1 - active, 0 - stopped )
// bit 2:0 -- count down to auto stop
// section 31:24
// section 23:16
// section 15:8
// section 7:0
// bit 31:0 reset channel status - each bit reset each channel 
// read -- 32 channel status 
// bit 4 -- video_stamp_use_dts
// bit 3 -- audio_stamp_sync_1_en 
// bit 2 -- audio_stamp_insert_en 
// bit 1 -- video_stamp_sync_1_en 
// bit 0 -- video_stamp_insert_en 
// Write : Bit[4:0] secter filter number for reset
// Read  : select according to output_section_buffer_valid : 
//         per bit per section buffer valid status
//         or section_buffer_ignore
// synopsys translate_off
// synopsys translate_on
//
// Closing file:  stb_define.h
//
//
// Reading file:  periphs_reg.h
//
// $periphs/rtl/periphs_core register defines for the 
// APB bus
// -------------------------------------------------------------------
// PSEL Group #0:  0x000 ~ 0xFF
// -------------------------------------------------------------------
// -----------------------------------------------
// CBUS_BASE:  PERIPHS0_CBUS_BASE = 0x20
// -----------------------------------------------
// The following are handled by $periphs/rtl/periphs_reg.v
#define PREG_CTLREG0_ADDR                          ((0x2000  << 2) + 0xc1100000)
// ----------------------------
#define PREG_PAD_GPIO6_EN_N                        ((0x2008  << 2) + 0xc1100000)
#define PREG_PAD_GPIO6_O                           ((0x2009  << 2) + 0xc1100000)
#define PREG_PAD_GPIO6_I                           ((0x200a  << 2) + 0xc1100000)
// ----------------------------
// ----------------------------
#define PREG_JTAG_GPIO_ADDR                        ((0x200b  << 2) + 0xc1100000)
// ----------------------------
// Pre-defined GPIO addresses
// ----------------------------
#define PREG_PAD_GPIO0_EN_N                        ((0x200c  << 2) + 0xc1100000)
#define PREG_PAD_GPIO0_O                           ((0x200d  << 2) + 0xc1100000)
#define PREG_PAD_GPIO0_I                           ((0x200e  << 2) + 0xc1100000)
// ----------------------------
#define PREG_PAD_GPIO1_EN_N                        ((0x200f  << 2) + 0xc1100000)
#define PREG_PAD_GPIO1_O                           ((0x2010  << 2) + 0xc1100000)
#define PREG_PAD_GPIO1_I                           ((0x2011  << 2) + 0xc1100000)
// ----------------------------
#define PREG_PAD_GPIO2_EN_N                        ((0x2012  << 2) + 0xc1100000)
#define PREG_PAD_GPIO2_O                           ((0x2013  << 2) + 0xc1100000)
#define PREG_PAD_GPIO2_I                           ((0x2014  << 2) + 0xc1100000)
// ----------------------------
#define PREG_PAD_GPIO3_EN_N                        ((0x2015  << 2) + 0xc1100000)
#define PREG_PAD_GPIO3_O                           ((0x2016  << 2) + 0xc1100000)
#define PREG_PAD_GPIO3_I                           ((0x2017  << 2) + 0xc1100000)
// ----------------------------
#define PREG_PAD_GPIO4_EN_N                        ((0x2018  << 2) + 0xc1100000)
#define PREG_PAD_GPIO4_O                           ((0x2019  << 2) + 0xc1100000)
#define PREG_PAD_GPIO4_I                           ((0x201a  << 2) + 0xc1100000)
// ----------------------------
#define PREG_PAD_GPIO5_EN_N                        ((0x201b  << 2) + 0xc1100000)
#define PREG_PAD_GPIO5_O                           ((0x201c  << 2) + 0xc1100000)
#define PREG_PAD_GPIO5_I                           ((0x201d  << 2) + 0xc1100000)
// ----------------------------
// A9 and L2 cache
// ----------------------------
#define A9_STATUS1                                 ((0x201f  << 2) + 0xc1100000)
#define A9_CFG0                                    ((0x2020  << 2) + 0xc1100000)
#define A9_CFG1                                    ((0x2021  << 2) + 0xc1100000)
#define A9_CFG2                                    ((0x2022  << 2) + 0xc1100000)
#define A9_PERIPH_BASE                             ((0x2023  << 2) + 0xc1100000)
#define A9_L2_REG_BASE                             ((0x2024  << 2) + 0xc1100000)
#define A9_L2_STATUS                               ((0x2025  << 2) + 0xc1100000)
#define A9_POR_CFG                                 ((0x2026  << 2) + 0xc1100000)
#define A9_STATUS2                                 ((0x2027  << 2) + 0xc1100000)
#define AXI_REG_EN                                 ((0x2028  << 2) + 0xc1100000)
#define A9_CFG3                                    ((0x2029  << 2) + 0xc1100000)
#define A9_CFG4                                    ((0x202a  << 2) + 0xc1100000)
#define A9_STATUS3                                 ((0x202b  << 2) + 0xc1100000)
// ----------------------------
// Pin Mux  (9)
// ----------------------------
#define PERIPHS_PIN_MUX_0                          ((0x202c  << 2) + 0xc1100000)
#define PERIPHS_PIN_MUX_1                          ((0x202d  << 2) + 0xc1100000)
#define PERIPHS_PIN_MUX_2                          ((0x202e  << 2) + 0xc1100000)
#define PERIPHS_PIN_MUX_3                          ((0x202f  << 2) + 0xc1100000)
#define PERIPHS_PIN_MUX_4                          ((0x2030  << 2) + 0xc1100000)
#define PERIPHS_PIN_MUX_5                          ((0x2031  << 2) + 0xc1100000)
#define PERIPHS_PIN_MUX_6                          ((0x2032  << 2) + 0xc1100000)
#define PERIPHS_PIN_MUX_7                          ((0x2033  << 2) + 0xc1100000)
#define PERIPHS_PIN_MUX_8                          ((0x2034  << 2) + 0xc1100000)
#define PERIPHS_PIN_MUX_9                          ((0x2035  << 2) + 0xc1100000)
#define PERIPHS_PIN_MUX_10                         ((0x2036  << 2) + 0xc1100000)
#define PERIPHS_PIN_MUX_11                         ((0x2037  << 2) + 0xc1100000)
#define PERIPHS_PIN_MUX_12                         ((0x2038  << 2) + 0xc1100000)
// ----------------------------
// Pad conntrols
// ----------------------------
#define PAD_PULL_UP_REG6                           ((0x2039  << 2) + 0xc1100000)
#define PAD_PULL_UP_REG0                           ((0x203a  << 2) + 0xc1100000)
#define PAD_PULL_UP_REG1                           ((0x203b  << 2) + 0xc1100000)
#define PAD_PULL_UP_REG2                           ((0x203c  << 2) + 0xc1100000)
#define PAD_PULL_UP_REG3                           ((0x203d  << 2) + 0xc1100000)
#define PAD_PULL_UP_REG4                           ((0x203e  << 2) + 0xc1100000)
#define PAD_PULL_UP_REG5                           ((0x203f  << 2) + 0xc1100000)
// ----------------------------
// Random (2)
// ----------------------------
#define RAND64_ADDR0                               ((0x2040  << 2) + 0xc1100000)
#define RAND64_ADDR1                               ((0x2041  << 2) + 0xc1100000)
// ---------------------------
// Ethernet (1)
// ----------------------------
#define PREG_ETHERNET_ADDR0                        ((0x2042  << 2) + 0xc1100000)
// ---------------------------
// AM_ANALOG_TOP
// ----------------------------
#define PREG_AM_ANALOG_ADDR                        ((0x2043  << 2) + 0xc1100000)
// ---------------------------
// Mali55 (1)
// ----------------------------
#define PREG_MALI_BYTE_CNTL                        ((0x2044  << 2) + 0xc1100000)
// ---------------------------
// WIFI (1)
// ----------------------------
#define PREG_WIFI_CNTL                             ((0x2045  << 2) + 0xc1100000)
#define PAD_PULL_UP_EN_REG0                        ((0x2048  << 2) + 0xc1100000)
#define PAD_PULL_UP_EN_REG1                        ((0x2049  << 2) + 0xc1100000)
#define PAD_PULL_UP_EN_REG2                        ((0x204a  << 2) + 0xc1100000)
#define PAD_PULL_UP_EN_REG3                        ((0x204b  << 2) + 0xc1100000)
#define PAD_PULL_UP_EN_REG4                        ((0x204c  << 2) + 0xc1100000)
#define PAD_PULL_UP_EN_REG5                        ((0x204d  << 2) + 0xc1100000)
#define PAD_PULL_UP_EN_REG6                        ((0x204e  << 2) + 0xc1100000)
// ---------------------------
// SATA 
// ----------------------------
#define PREG_ETH_REG0                              ((0x2050  << 2) + 0xc1100000)
#define PREG_ETH_REG1                              ((0x2051  << 2) + 0xc1100000)
// `define PREG_SATA_REG2                      8'h52
// `define PREG_SATA_REG3                      8'h53
// `define PREG_SATA_REG4                      8'h54
// `define PREG_SATA_REG5                      8'h55
// ---------------------------
// Generic production test
// ----------------------------
#define PROD_TEST_REG0                             ((0x2060  << 2) + 0xc1100000)
#define PROD_TEST_REG1                             ((0x2061  << 2) + 0xc1100000)
#define PROD_TEST_REG2                             ((0x2062  << 2) + 0xc1100000)
#define PROD_TEST_REG3                             ((0x2063  << 2) + 0xc1100000)
// ---------------------------
// am_analog_top
// ----------------------------
#define METAL_REVISION                             ((0x206a  << 2) + 0xc1100000)
#define ADC_TOP_MISC                               ((0x206b  << 2) + 0xc1100000)
#define DPLL_TOP_MISC                              ((0x206c  << 2) + 0xc1100000)
#define ANALOG_TOP_MISC                            ((0x206d  << 2) + 0xc1100000)
#define AM_ANALOG_TOP_REG0                         ((0x206e  << 2) + 0xc1100000)
#define AM_ANALOG_TOP_REG1                         ((0x206f  << 2) + 0xc1100000)
// ---------------------------
// Sticky regs
// ----------------------------
#define PREG_STICKY_REG0                           ((0x207c  << 2) + 0xc1100000)
#define PREG_STICKY_REG1                           ((0x207d  << 2) + 0xc1100000)
#define PREG_WRITE_ONCE_REG                        ((0x207e  << 2) + 0xc1100000)
// ---------------------------
// AM Ring Oscillator 
// ----------------------------
#define AM_RING_OSC_REG0                           ((0x207f  << 2) + 0xc1100000)
// Control whether to provide random number to HDMITX20
#define HDMITX20_RNDNUM                            ((0x2080  << 2) + 0xc1100000)
// -------------------------------------------------------------------
// PSEL Group #1:  0x400 ~ 0x7FF
// -------------------------------------------------------------------
// -----------------------------------------------
// CBUS_BASE:  PERIPHS1_CBUS_BASE = 0x21
// -----------------------------------------------
// ----------------------------
// $usb/rtl/usb_reg.v   (8)
// ----------------------------
// Moved to base 8'h22
// `define USB_ADDR0                      8'h00
// `define USB_ADDR1                      8'h01
// `define USB_ADDR2                      8'h02
// `define USB_ADDR3                      8'h03
// `define USB_ADDR4                      8'h04
// `define USB_ADDR5                      8'h05
// `define USB_ADDR6                      8'h06
// `define USB_ADDR7                      8'h07
// `define USB_ADDR8                      8'h08
// `define USB_ADDR9                      8'h09
// `define USB_ADDR10                     8'h0a
// `define USB_ADDR11                     8'h0b
// `define USB_ADDR12                     8'h0c
// `define USB_ADDR13                     8'h0d
// `define USB_ADDR14                     8'h0e
// `define USB_ADDR15                     8'h0f
// ----------------------------
// Smart Card (8)
// ----------------------------
#define SMARTCARD_REG0                             ((0x2110  << 2) + 0xc1100000)
#define SMARTCARD_REG1                             ((0x2111  << 2) + 0xc1100000)
#define SMARTCARD_REG2                             ((0x2112  << 2) + 0xc1100000)
#define SMARTCARD_STATUS                           ((0x2113  << 2) + 0xc1100000)
#define SMARTCARD_INTR                             ((0x2114  << 2) + 0xc1100000)
#define SMARTCARD_REG5                             ((0x2115  << 2) + 0xc1100000)
#define SMARTCARD_REG6                             ((0x2116  << 2) + 0xc1100000)
#define SMARTCARD_FIFO                             ((0x2117  << 2) + 0xc1100000)
#define SMARTCARD_REG8                             ((0x2118  << 2) + 0xc1100000)
// ----------------------------
// IR Remote (8)
// ----------------------------
#define IR_DEC_LDR_ACTIVE                          ((0x2120  << 2) + 0xc1100000)
#define IR_DEC_LDR_IDLE                            ((0x2121  << 2) + 0xc1100000)
#define IR_DEC_LDR_REPEAT                          ((0x2122  << 2) + 0xc1100000)
#define IR_DEC_BIT_0                               ((0x2123  << 2) + 0xc1100000)
#define IR_DEC_REG0                                ((0x2124  << 2) + 0xc1100000)
#define IR_DEC_FRAME                               ((0x2125  << 2) + 0xc1100000)
#define IR_DEC_STATUS                              ((0x2126  << 2) + 0xc1100000)
#define IR_DEC_REG1                                ((0x2127  << 2) + 0xc1100000)
// ----------------------------
// Demod Sampling
// ----------------------------
#define DEMOD_ADC_SAMPLING                         ((0x212d  << 2) + 0xc1100000)
// ----------------------------
// WIFI
// ----------------------------
// `define WIFI_ADC_SAMPLING               8'h2e
// `define WIFI_ADC_READBACK               8'h2f
// ----------------------------
// UART0
// ----------------------------
#define UART0_WFIFO                                ((0x2130  << 2) + 0xc1100000)
#define UART0_RFIFO                                ((0x2131  << 2) + 0xc1100000)
#define UART0_CONTROL                              ((0x2132  << 2) + 0xc1100000)
#define UART0_STATUS                               ((0x2133  << 2) + 0xc1100000)
#define UART0_MISC                                 ((0x2134  << 2) + 0xc1100000)
#define UART0_REG5                                 ((0x2135  << 2) + 0xc1100000)
// ----------------------------
// UART1
// ----------------------------
#define UART1_WFIFO                                ((0x2137  << 2) + 0xc1100000)
#define UART1_RFIFO                                ((0x2138  << 2) + 0xc1100000)
#define UART1_CONTROL                              ((0x2139  << 2) + 0xc1100000)
#define UART1_STATUS                               ((0x213a  << 2) + 0xc1100000)
#define UART1_MISC                                 ((0x213b  << 2) + 0xc1100000)
#define UART1_REG5                                 ((0x213c  << 2) + 0xc1100000)
// ----------------------------
// I2C Master (8)
// ----------------------------
#define I2C_M_0_CONTROL_REG                        ((0x2140  << 2) + 0xc1100000)
    #define     I2C_M_MANUAL_SDA_I        26
    #define     I2C_M_MANUAL_SCL_I        25
    #define     I2C_M_MANUAL_SDA_O        24
    #define     I2C_M_MANUAL_SCL_O        23
    #define     I2C_M_MANUAL_EN           22
    #define     I2C_M_DELAY_MSB           21
    #define     I2C_M_DELAY_LSB           12
    #define     I2C_M_DATA_CNT_MSB        11
    #define     I2C_M_DATA_CNT_LSB        8
    #define     I2C_M_CURR_TOKEN_MSB      7
    #define     I2C_M_CURR_TOKEN_LSB      4
    #define     I2C_M_ERROR               3
    #define     I2C_M_STATUS              2
    #define     I2C_M_ACK_IGNORE          1
    #define     I2C_M_START               0
#define I2C_M_0_SLAVE_ADDR                         ((0x2141  << 2) + 0xc1100000)
#define I2C_M_0_TOKEN_LIST0                        ((0x2142  << 2) + 0xc1100000)
#define I2C_M_0_TOKEN_LIST1                        ((0x2143  << 2) + 0xc1100000)
#define I2C_M_0_WDATA_REG0                         ((0x2144  << 2) + 0xc1100000)
#define I2C_M_0_WDATA_REG1                         ((0x2145  << 2) + 0xc1100000)
#define I2C_M_0_RDATA_REG0                         ((0x2146  << 2) + 0xc1100000)
#define I2C_M_0_RDATA_REG1                         ((0x2147  << 2) + 0xc1100000)
// ----------------------------
// I2C Slave (3)
// ----------------------------
#define I2C_S_CONTROL_REG                          ((0x2150  << 2) + 0xc1100000)
#define I2C_S_SEND_REG                             ((0x2151  << 2) + 0xc1100000)
#define I2C_S_RECV_REG                             ((0x2152  << 2) + 0xc1100000)
#define I2C_S_CNTL1_REG                            ((0x2153  << 2) + 0xc1100000)
// ----------------------------
// PWM / DS A/B
// ----------------------------
#define PWM_PWM_A                                  ((0x2154  << 2) + 0xc1100000)
#define PWM_PWM_B                                  ((0x2155  << 2) + 0xc1100000)
#define PWM_MISC_REG_AB                            ((0x2156  << 2) + 0xc1100000)
#define PWM_DELTA_SIGMA_AB                         ((0x2157  << 2) + 0xc1100000)
// ---------------------------
// EFUSE (4)
// ----------------------------
// Moved to the Secure APB3 bus
// `define EFUSE_CNTL0                     8'h58
// `define EFUSE_CNTL1                     8'h59
// `define EFUSE_CNTL2                     8'h5a
// `define EFUSE_CNTL3                     8'h5b
// `define EFUSE_CNTL4                     8'h5c
// ---------------------------------------------
// Separate APB slave that shares the CBUS/APB
// register space of the static registers
// ---------------------------------------------
#define ATAPI_IDEREG0                              ((0x2160  << 2) + 0xc1100000)
   #define IDE_UDMA_PIO_STATE         15
   #define IDE_BUSY                   14
   #define IDE_ERROR_BIT              13
   #define IDE_DMARQ_BIT              12
   #define IDE_IORDY_BIT              11
   #define IDE_IORDY_EN_BIT           10
   #define IDE_DIS_CSEL_BIT            9
   #define IDE_CSEL_BIT                8
   #define IDE_IRQ14                   2
   #define IDE_ATAPI_GPIO_EN           3
   #define IDE_DMARQ_FULL              1
   #define IDE_ENABLE                  0
#define ATAPI_IDEREG1                              ((0x2161  << 2) + 0xc1100000)
#define ATAPI_IDEREG2                              ((0x2162  << 2) + 0xc1100000)
    #define IDE_XFER_CNT_MSB_BIT      18
    #define IDE_XFER_CNT_LSB_BIT       0
#define ATAPI_CYCTIME                              ((0x2163  << 2) + 0xc1100000)
#define ATAPI_IDETIME                              ((0x2164  << 2) + 0xc1100000)
#define ATAPI_PIO_TIMING                           ((0x2165  << 2) + 0xc1100000)
#define ATAPI_TABLE_ADD_REG                        ((0x2166  << 2) + 0xc1100000)
#define ATAPI_IDEREG3                              ((0x2167  << 2) + 0xc1100000)
#define ATAPI_UDMA_REG0                            ((0x2168  << 2) + 0xc1100000)
#define ATAPI_UDMA_REG1                            ((0x2169  << 2) + 0xc1100000)
// Room for registers here
#define TRANS_PWMA_REG0                            ((0x2170  << 2) + 0xc1100000)
#define TRANS_PWMA_REG1                            ((0x2171  << 2) + 0xc1100000)
#define TRANS_PWMA_MUX0                            ((0x2172  << 2) + 0xc1100000)
#define TRANS_PWMA_MUX1                            ((0x2173  << 2) + 0xc1100000)
#define TRANS_PWMA_MUX2                            ((0x2174  << 2) + 0xc1100000)
#define TRANS_PWMA_MUX3                            ((0x2175  << 2) + 0xc1100000)
#define TRANS_PWMA_MUX4                            ((0x2176  << 2) + 0xc1100000)
#define TRANS_PWMA_MUX5                            ((0x2177  << 2) + 0xc1100000)
#define TRANS_PWMB_REG0                            ((0x2178  << 2) + 0xc1100000)
#define TRANS_PWMB_REG1                            ((0x2179  << 2) + 0xc1100000)
#define TRANS_PWMB_MUX0                            ((0x217a  << 2) + 0xc1100000)
#define TRANS_PWMB_MUX1                            ((0x217b  << 2) + 0xc1100000)
#define TRANS_PWMB_MUX2                            ((0x217c  << 2) + 0xc1100000)
#define TRANS_PWMB_MUX3                            ((0x217d  << 2) + 0xc1100000)
#define TRANS_PWMB_MUX4                            ((0x217e  << 2) + 0xc1100000)
#define TRANS_PWMB_MUX5                            ((0x217f  << 2) + 0xc1100000)
// ----------------------------
// NAND (21)
// ----------------------------
#define NAND_START                                 ((0x2180  << 2) + 0xc1100000)
#define NAND_ADR_CMD                               ((0x218a  << 2) + 0xc1100000)
#define NAND_ADR_STS                               ((0x218b  << 2) + 0xc1100000)
#define NAND_END                                   ((0x218f  << 2) + 0xc1100000)
// ----------------------------
// PWM / DS C/D
// ----------------------------
#define PWM_PWM_C                                  ((0x2194  << 2) + 0xc1100000)
#define PWM_PWM_D                                  ((0x2195  << 2) + 0xc1100000)
#define PWM_MISC_REG_CD                            ((0x2196  << 2) + 0xc1100000)
#define PWM_DELTA_SIGMA_CD                         ((0x2197  << 2) + 0xc1100000)
// ----------------------------
// ISP_FLASH_LED_CTRL
// ----------------------------
//bit 31, reg_led_en //rising pulse start, falling pulse stop for torch mode
//bit 30, reg_inc_i_st_lat //for as3685, dynamic increase current during st_latch
//bit 29:28, reg_inv_en_pol //bit[29], invert en1, bit [28], invert en2
//bit 27, reg_switch_en1en2  //switch output en1 and en2. For IS3231: en1 is EN, en2 is mode. 
//bit 26, reg_force_off_mode //1: reset state machine at the falling edge no matter which state it is in
//bit 25, reg_hold_nonstd_off_mode //hold the non-std led_off signal input before state "OFF"
//bit 24, reg_flash_mode_timeout_en  //force to exit the Tlat state when time out, for flash mode protection
//bit 23, reg_en1_st_ini_level //en1 level during state ST_INI
//bit 22, reg_en2_st_set_mp_level //en2 level during state ST_SET_MP_HI, ST_SET_MP_LO
//bit 21, reg_en1_st_off_level //en1 level during state ST_OFF
//bit 20, reg_en2_st_off_level //en2 level during state ST_OFF
//bit 19:12, reg_en1_mp_num  //en1 multi pulse number, up to 256 step current control
//bit 10:0, reg_t_st_ini //Max: 85.2 us under 24M clock input
#define ISP_LED_CTRL                               ((0x2198  << 2) + 0xc1100000)
//bit 31:21, reg_t_en1_inc_i_st_lat_cnt //Max: 85.2us under 24M. for as3685, dynamic increase current during st_latch
//bit 20:10, reg_t_en2_lo_st_ini //Max: 85.2 us under 24M clock input
//bit 9:0, reg_t_en2_hi1_st_lat_cnt //42.62us @24M, EN2 can output hi-lo-hi during ST_LATCH, this is the first lo -duration
#define ISP_LED_TIMING1                            ((0x2199  << 2) + 0xc1100000)
//bit 31:21, reg_t_en1_mp_hi_cnt //Max: 85.2 us under 24M clock input, mp means multi pulse
//bit 20:10, reg_t_en1_mp_lo_cnt //Max: 85.2 us under 24M clock input, mp means multi pulse
//bit 9:0, reg_t_en2_lo1_st_lat_cnt //42.62us @24M, EN2 can output hi-lo-hi during ST_LATCH, this is the first lo -duration
#define ISP_LED_TIMING2                            ((0x219a  << 2) + 0xc1100000)
//bit 30:28, RO state
//bit 25:0, reg_flash_mode_timeout_cnt //up to 2.79s at 24Mhz clk input
#define ISP_LED_TIMING3                            ((0x219b  << 2) + 0xc1100000)
//bit 25:0, reg_t_st_lat_cnt //up to 2.79s, keep the led on if it's 26'h3ffffff under torch mode
#define ISP_LED_TIMING4                            ((0x219c  << 2) + 0xc1100000)
//bit 31:26, reg_t_st_off_cnt[5:0] //up to 85.2us OFF state.
//bit 25:0, reg_t_en2_hi2_st_lat_cnt //EN2 can output hi-lo-hi during ST_LATCH, this is the second hi -duration
#define ISP_LED_TIMING5                            ((0x219d  << 2) + 0xc1100000)
//bit 30:26, reg_t_st_off_cnt[10:6] //up to 85.2us OFF state.
//bit 25:0, reg_t_en1_st_lat_hold_cnt //to make sure Tlat to meat it's minimum request 500us (since non-std led_off signal may comes in anytime)
#define ISP_LED_TIMING6                            ((0x219e  << 2) + 0xc1100000)
// ----------------------------
// SAR ADC (16)
// ----------------------------
#define SAR_ADC_REG0                               ((0x21a0  << 2) + 0xc1100000)
#define SAR_ADC_CHAN_LIST                          ((0x21a1  << 2) + 0xc1100000)
#define SAR_ADC_AVG_CNTL                           ((0x21a2  << 2) + 0xc1100000)
#define SAR_ADC_REG3                               ((0x21a3  << 2) + 0xc1100000)
#define SAR_ADC_DELAY                              ((0x21a4  << 2) + 0xc1100000)
#define SAR_ADC_LAST_RD                            ((0x21a5  << 2) + 0xc1100000)
#define SAR_ADC_FIFO_RD                            ((0x21a6  << 2) + 0xc1100000)
#define SAR_ADC_AUX_SW                             ((0x21a7  << 2) + 0xc1100000)
#define SAR_ADC_CHAN_10_SW                         ((0x21a8  << 2) + 0xc1100000)
#define SAR_ADC_DETECT_IDLE_SW                     ((0x21a9  << 2) + 0xc1100000)
#define SAR_ADC_DELTA_10                           ((0x21aa  << 2) + 0xc1100000)
// ----------------------------
// CTouch (16)
// ----------------------------
#define PWM_PWM_E                                  ((0x21b0  << 2) + 0xc1100000)
#define PWM_PWM_F                                  ((0x21b1  << 2) + 0xc1100000)
#define PWM_MISC_REG_EF                            ((0x21b2  << 2) + 0xc1100000)
#define PWM_DELTA_SIGMA_EF                         ((0x21b3  << 2) + 0xc1100000)
// ----------------------------
// UART2
// ----------------------------
#define UART2_WFIFO                                ((0x21c0  << 2) + 0xc1100000)
#define UART2_RFIFO                                ((0x21c1  << 2) + 0xc1100000)
#define UART2_CONTROL                              ((0x21c2  << 2) + 0xc1100000)
#define UART2_STATUS                               ((0x21c3  << 2) + 0xc1100000)
#define UART2_MISC                                 ((0x21c4  << 2) + 0xc1100000)
#define UART2_REG5                                 ((0x21c5  << 2) + 0xc1100000)
// ----------------------------
// UART3
// ----------------------------
#define UART3_WFIFO                                ((0x21c8  << 2) + 0xc1100000)
#define UART3_RFIFO                                ((0x21c9  << 2) + 0xc1100000)
#define UART3_CONTROL                              ((0x21ca  << 2) + 0xc1100000)
#define UART3_STATUS                               ((0x21cb  << 2) + 0xc1100000)
#define UART3_MISC                                 ((0x21cc  << 2) + 0xc1100000)
#define UART3_REG5                                 ((0x21cd  << 2) + 0xc1100000)
// ---------------------------
// RTC (4)
// ---------------------------
#define RTC_ADDR0                                  ((0x21d0  << 2) + 0xc1100000)
#define RTC_ADDR1                                  ((0x21d1  << 2) + 0xc1100000)
#define RTC_ADDR2                                  ((0x21d2  << 2) + 0xc1100000)
#define RTC_ADDR3                                  ((0x21d3  << 2) + 0xc1100000)
#define RTC_ADDR4                                  ((0x21d4  << 2) + 0xc1100000)
// ----------------------------
// clock measure (4)
// ----------------------------
#define MSR_CLK_DUTY                               ((0x21d6  << 2) + 0xc1100000)
#define MSR_CLK_REG0                               ((0x21d7  << 2) + 0xc1100000)
#define MSR_CLK_REG1                               ((0x21d8  << 2) + 0xc1100000)
#define MSR_CLK_REG2                               ((0x21d9  << 2) + 0xc1100000)
#define MSR_CLK_REG3                               ((0x21da  << 2) + 0xc1100000)
#define MSR_CLK_REG4                               ((0x21db  << 2) + 0xc1100000)
#define MSR_CLK_REG5                               ((0x21de  << 2) + 0xc1100000)
// ----------------------------
// LED PWM
// ----------------------------
// `define LED_PWM_REG0                    8'hda
// `define LED_PWM_REG1                    8'hdb
// `define LED_PWM_REG2                    8'hdc
// `define LED_PWM_REG3                    8'hdd
// `define LED_PWM_REG4                    8'hde
// `define LED_PWM_REG5                    8'hdf
// `define LED_PWM_REG6                    8'he0
// ----------------------------
// VGHL PWM
// ----------------------------
// `define VGHL_PWM_REG0                   8'he1
// `define VGHL_PWM_REG1                   8'he2
// `define VGHL_PWM_REG2                   8'he3
// `define VGHL_PWM_REG3                   8'he4
// `define VGHL_PWM_REG4                   8'he5
// `define VGHL_PWM_REG5                   8'he6
// `define VGHL_PWM_REG6                   8'he7
// ----------------------------
// I2C Master
// ----------------------------
#define I2C_M_1_CONTROL_REG                        ((0x21f0  << 2) + 0xc1100000)
#define I2C_M_1_SLAVE_ADDR                         ((0x21f1  << 2) + 0xc1100000)
#define I2C_M_1_TOKEN_LIST0                        ((0x21f2  << 2) + 0xc1100000)
#define I2C_M_1_TOKEN_LIST1                        ((0x21f3  << 2) + 0xc1100000)
#define I2C_M_1_WDATA_REG0                         ((0x21f4  << 2) + 0xc1100000)
#define I2C_M_1_WDATA_REG1                         ((0x21f5  << 2) + 0xc1100000)
#define I2C_M_1_RDATA_REG0                         ((0x21f6  << 2) + 0xc1100000)
#define I2C_M_1_RDATA_REG1                         ((0x21f7  << 2) + 0xc1100000)
// ----------------------------
// I2C Master
// ----------------------------
#define I2C_M_2_CONTROL_REG                        ((0x21f8  << 2) + 0xc1100000)
#define I2C_M_2_SLAVE_ADDR                         ((0x21f9  << 2) + 0xc1100000)
#define I2C_M_2_TOKEN_LIST0                        ((0x21fa  << 2) + 0xc1100000)
#define I2C_M_2_TOKEN_LIST1                        ((0x21fb  << 2) + 0xc1100000)
#define I2C_M_2_WDATA_REG0                         ((0x21fc  << 2) + 0xc1100000)
#define I2C_M_2_WDATA_REG1                         ((0x21fd  << 2) + 0xc1100000)
#define I2C_M_2_RDATA_REG0                         ((0x21fe  << 2) + 0xc1100000)
#define I2C_M_2_RDATA_REG1                         ((0x21ff  << 2) + 0xc1100000)
// -------------------------------------------------------------------
// PSEL Group #2:  0x800 ~ 0xbFF
// -------------------------------------------------------------------
// -----------------------------------------------
// CBUS_BASE:  PERIPHS2_CBUS_BASE = 0x22
// -----------------------------------------------
#define USB_ADDR0                                  ((0x2200  << 2) + 0xc1100000)
#define USB_ADDR1                                  ((0x2201  << 2) + 0xc1100000)
#define USB_ADDR2                                  ((0x2202  << 2) + 0xc1100000)
#define USB_ADDR3                                  ((0x2203  << 2) + 0xc1100000)
#define USB_ADDR4                                  ((0x2204  << 2) + 0xc1100000)
#define USB_ADDR5                                  ((0x2205  << 2) + 0xc1100000)
#define USB_ADDR6                                  ((0x2206  << 2) + 0xc1100000)
#define USB_ADDR7                                  ((0x2207  << 2) + 0xc1100000)
#define USB_ADDR8                                  ((0x2208  << 2) + 0xc1100000)
#define USB_ADDR9                                  ((0x2209  << 2) + 0xc1100000)
#define USB_ADDR10                                 ((0x220a  << 2) + 0xc1100000)
#define USB_ADDR11                                 ((0x220b  << 2) + 0xc1100000)
#define USB_ADDR12                                 ((0x220c  << 2) + 0xc1100000)
#define USB_ADDR13                                 ((0x220d  << 2) + 0xc1100000)
#define USB_ADDR14                                 ((0x220e  << 2) + 0xc1100000)
#define USB_ADDR15                                 ((0x220f  << 2) + 0xc1100000)
#define USB_ADDR16                                 ((0x2210  << 2) + 0xc1100000)
#define USB_ADDR17                                 ((0x2211  << 2) + 0xc1100000)
#define USB_ADDR18                                 ((0x2212  << 2) + 0xc1100000)
#define USB_ADDR19                                 ((0x2213  << 2) + 0xc1100000)
#define USB_ADDR20                                 ((0x2214  << 2) + 0xc1100000)
#define USB_ADDR21                                 ((0x2215  << 2) + 0xc1100000)
#define USB_ADDR22                                 ((0x2216  << 2) + 0xc1100000)
#define USB_ADDR23                                 ((0x2217  << 2) + 0xc1100000)
#define USB_ADDR24                                 ((0x2218  << 2) + 0xc1100000)
#define USB_ADDR25                                 ((0x2219  << 2) + 0xc1100000)
#define USB_ADDR26                                 ((0x221a  << 2) + 0xc1100000)
#define USB_ADDR27                                 ((0x221b  << 2) + 0xc1100000)
#define USB_ADDR28                                 ((0x221c  << 2) + 0xc1100000)
#define USB_ADDR29                                 ((0x221d  << 2) + 0xc1100000)
#define USB_ADDR30                                 ((0x221e  << 2) + 0xc1100000)
#define USB_ADDR31                                 ((0x221f  << 2) + 0xc1100000)
// ----------------------------
// SANA (Stream Analyzer)
// ----------------------------
// [31:16] - ddr_setting
// [15]    - disable_stream_clock_gating
// [14:13] - mem_pd_ctl_sana
// [6:4]   - stream_fetch_endian 
// [3]     - use_parser_vbuf_wp
// [2]     - use_parser_vbuf2_wp
// [1]     - stream_fetch_busy - Read Only
// [0]     - stream_fetch_enable
#define SANA_STREAM_CONTROL                        ((0x2220  << 2) + 0xc1100000)
#define SANA_STREAM_START_ADDR                     ((0x2221  << 2) + 0xc1100000)
#define SANA_STREAM_END_ADDR                       ((0x2222  << 2) + 0xc1100000)
// SW stream_buffer_wr_ptr
#define SANA_STREAM_WR_PTR                         ((0x2223  << 2) + 0xc1100000)
#define SANA_STREAM_RD_PTR                         ((0x2224  << 2) + 0xc1100000)
//[31:0] stream_buffer_level - read only
#define SANA_STREAM_LEVEL                          ((0x2225  << 2) + 0xc1100000)
// [31:29] stream_buffer_hole 256*(4^0) bytes
// [28:23] stream_fifo_hole 
// [22:16] stream_fifo_level
// [15]    stream_fifo_wr_ptr_update_en
// [14:8]  stream_fifo_wr_ptr 
// [7]     stream_fifo_rd_ptr_update_en
// [6:0]   stream_fifo_rd_ptr 
#define SANA_STREAM_FIFO_CTL                       ((0x2226  << 2) + 0xc1100000)
// [31:18] - Reserved
// [17]    - sana_int_enable
// [16]    - sana_int_level (default : 0(pulse))
// [15]    - disable_shift_clock_gating
// [14]    - startcode_protect -- TODO
// [8:6]   - sft_valid_wr_position (default : 3 (at least 24 bits available))
// [5:4]   - emulate_code_length_sub_1(Default : 2)
// [3]     - emulation_auto_on_startcode(Default : 0)
// [2:1]   - start_code_length_sub_1(Default : 2)
// [0]     - stream_shift_enable(Default : 0)
#define SANA_SHIFT_CONTROL                         ((0x2227  << 2) + 0xc1100000)
// [31:0]  - max 4-bytes start code (Default : 0x00000100)
#define SANA_SHIFT_STARTCODE                       ((0x2228  << 2) + 0xc1100000)
// [31:0]  - max 4-bytes emulate code (Default : 0x00000300)
#define SANA_SHIFT_EMULATECODE                     ((0x2229  << 2) + 0xc1100000)
// [3]     - sana_int
// [2]     - startcode_searching
// [1]     - emulation_check_on
// [0]     - startcode_check_on
#define SANA_SHIFT_STATUS                          ((0x222a  << 2) + 0xc1100000)
// [31:0] sana_shifted_data - read only
#define SANA_SHIFTED_DATA                          ((0x222b  << 2) + 0xc1100000)
// [31:0] shift_byte_count[31:0]
#define SANA_SHIFT_BYTE_COUNT                      ((0x222c  << 2) + 0xc1100000)
// [31:28] - shift_byte_count[35:32]
// [27:20] - element_read_data[31:24]
// [10]    - bytealign
// [9]     - signed_element
// [8]     - start_element_read
// [7]     - shift_busy
// [6:0]   - shift_bits
#define SANA_SHIFT_COMMAND                         ((0x222d  << 2) + 0xc1100000)
// 31:8    - element_read_data[23:0]
//  7:2    - element_read_length
//  1:0    - element_read_state
#define SANA_ELEMENT_RESULT                        ((0x222e  << 2) + 0xc1100000)
// support up to 8 masters, one bit per master
// 23:16   - lock_release (Write 1 to release)
// 15:8    - lock_req (write 1 to request)
//  7:0    - lock_result (Read Only)
#define ATOM_LOCK                                  ((0x222f  << 2) + 0xc1100000)
// ----------------------------
// BLKMV (9)
// ----------------------------
#define NDMA_CNTL_REG0                             ((0x2270  << 2) + 0xc1100000)
    #define NDMA_STATUS                 26
    #define NDMA_PERIODIC_INT_DLY_MSB   25
    #define NDMA_PERIODIC_INT_DLY_LSB   16
    #define NDMA_PERIODIC_INT_EN        15
    #define NDMA_ENABLE                 14
    #define NDMA_AHB_DELAY_MSB          13
    #define NDMA_AHB_DELAY_LSB          0
#define NDMA_TABLE_ADD_REG                         ((0x2272  << 2) + 0xc1100000)
#define NDMA_TDES_KEY_LO                           ((0x2273  << 2) + 0xc1100000)
#define NDMA_TDES_KEY_HI                           ((0x2274  << 2) + 0xc1100000)
#define NDMA_TDES_CONTROL                          ((0x2275  << 2) + 0xc1100000)
#define NDMA_RIJNDAEL_CONTROL                      ((0x2276  << 2) + 0xc1100000)
#define NDMA_RIJNDAEL_RK_FIFO                      ((0x2277  << 2) + 0xc1100000)
#define NDMA_CRC_OUT                               ((0x2278  << 2) + 0xc1100000)
#define NDMA_THREAD_REG                            ((0x2279  << 2) + 0xc1100000)
#define NDMA_THREAD_TABLE_START0                   ((0x2280  << 2) + 0xc1100000)
#define NDMA_THREAD_TABLE_CURR0                    ((0x2281  << 2) + 0xc1100000)
#define NDMA_THREAD_TABLE_END0                     ((0x2282  << 2) + 0xc1100000)
#define NDMA_THREAD_TABLE_START1                   ((0x2283  << 2) + 0xc1100000)
#define NDMA_THREAD_TABLE_CURR1                    ((0x2284  << 2) + 0xc1100000)
#define NDMA_THREAD_TABLE_END1                     ((0x2285  << 2) + 0xc1100000)
#define NDMA_THREAD_TABLE_START2                   ((0x2286  << 2) + 0xc1100000)
#define NDMA_THREAD_TABLE_CURR2                    ((0x2287  << 2) + 0xc1100000)
#define NDMA_THREAD_TABLE_END2                     ((0x2288  << 2) + 0xc1100000)
#define NDMA_THREAD_TABLE_START3                   ((0x2289  << 2) + 0xc1100000)
#define NDMA_THREAD_TABLE_CURR3                    ((0x228a  << 2) + 0xc1100000)
#define NDMA_THREAD_TABLE_END3                     ((0x228b  << 2) + 0xc1100000)
#define NDMA_CNTL_REG1                             ((0x228c  << 2) + 0xc1100000)
#define NDMA_AES_KEY_0                             ((0x2290  << 2) + 0xc1100000)
#define NDMA_AES_KEY_1                             ((0x2291  << 2) + 0xc1100000)
#define NDMA_AES_KEY_2                             ((0x2292  << 2) + 0xc1100000)
#define NDMA_AES_KEY_3                             ((0x2293  << 2) + 0xc1100000)
#define NDMA_AES_KEY_4                             ((0x2294  << 2) + 0xc1100000)
#define NDMA_AES_KEY_5                             ((0x2295  << 2) + 0xc1100000)
#define NDMA_AES_KEY_6                             ((0x2296  << 2) + 0xc1100000)
#define NDMA_AES_KEY_7                             ((0x2297  << 2) + 0xc1100000)
#define NDMA_AES_IV_0                              ((0x2298  << 2) + 0xc1100000)
#define NDMA_AES_IV_1                              ((0x2299  << 2) + 0xc1100000)
#define NDMA_AES_IV_2                              ((0x229a  << 2) + 0xc1100000)
#define NDMA_AES_IV_3                              ((0x229b  << 2) + 0xc1100000)
#define NDMA_AES_REG0                              ((0x229c  << 2) + 0xc1100000)
// -------------------------------------------------------------------
// PSEL Group #3:  0xc00 ~ 0xFFF
// -------------------------------------------------------------------
// -----------------------------------------------
// CBUS_BASE:  PERIPHS3_CBUS_BASE = 0x23
// -----------------------------------------------
// ---------------------------
// STREAM (8)
// ---------------------------
// bit 31:24 -- event_length
// bit 23:22 -- bus_1st_sel_1  //00-gpio, 01-reserved, 10-addr, 11-data 
// bit 21:20 -- bus_2nd_sel_1
// bit 19:18 -- bus_1st_sel_0
// bit 17:16 -- bus_2nd_sel_0
// bit 15:0 -- set output value (output 1 will read according to external input) 
#define STREAM_EVENT_INFO                          ((0x2300  << 2) + 0xc1100000)
// bit 31    -- force_parity_1
// bit 30    -- LSB_first
// bit 31:20 -- reserved
// bit 19:16 -- toggle point index
// bit 15:8  -- output togle point1
// bit 7:0   -- output togle point0 (0xff means input) 
#define STREAM_OUTPUT_CONFIG                       ((0x2301  << 2) + 0xc1100000)
// bit 31:24 -- clock_divide_ext
// bit 23:20 -- s_bus_start ( sclk, sdataout, sdatain)  // 0 means no s_bus used
// bit 19    -- no_sclk_on_pin // will use internal write clock and read clock (like RS232) 
// bit 18    -- invert_sclk_in
// bit 17    -- sdata_send_busy  // indicate one data is sending -- read only
// bit 16    -- one_sdata_received // set when one sdata is received, can write 0 to clear 
// bit 15    -- sdata_parity  // (write -- 0-even, 1-odd) (read -- received parity check)
// bit 14    -- sdata_send_type  // 0 -- 8 bits  1 -- 32 bits ( for fujitsu only )
// bit 13    -- sdata_receive_type // 0 -- 8 bits only  1 -- 8/32 bits 
// bit 12    -- invert_request_out
// bit 11:8  -- request_out_sel  // 0 means disable output
// bit 7:0   --  stop_request_count 
#define C_D_BUS_CONTROL                            ((0x2302  << 2) + 0xc1100000)
// bit 31:0  -- serial data (write: output one data, read: input data)
#define C_DATA                                     ((0x2303  << 2) + 0xc1100000)
// bit 31:28 bus_width_1
// bit 27:24 bus_start_pin_1
// bit 23:16 bus_sel_chang_point_1 
// bit 15:12 bus_width_0
// bit 11:08 bus_start_pin_0
// bit 07:00 bus_sel_chang_point_0 
#define STREAM_BUS_CONFIG                          ((0x2304  << 2) + 0xc1100000)
// bit 31:24 clock_divide
// bit 23:20 clock_output_sel  -- 0 means disable clock output
// bit 19 -- inc_event_addr
// bit 18 -- async_fifo_endian
// bit 17 -- send_to_async_fifo
// bit 16 -- data_in_serial_lsb
// bit 15 -- invert_no_wait_condition_0
// bit 14 -- invert_no_wait_condition_1
// bit 13 -- invert_no_wait_condition_2
// bit 12 -- invert_data_bus
// bit 11 -- invert_clock_in
// bit 10 -- event_wait_clk_en
// bit 9 -- data_in_serial
// bit 8 -- invert_data_in_clk 
// bit 7:4  -- data_in_begin
// bit 3:0  -- data_in_clk_sel
#define STREAM_DATA_IN_CONFIG                      ((0x2305  << 2) + 0xc1100000)
// wait condition and irq should not be connected to 0, 0 means disable)
// bit 31:28 -- no_wait_condition_0   (0 means disable this condition)
// bit 27:24 -- no_wait_condition_1   (0 means disable this condition)
// bit 23:20 -- no_wait_condition_2   (0 means disable this condition)
// bit 19:16 -- irq_input_sel         (0 means disable this interrupt)
// bit 15:13 -- interrupt_status (read) clear status (write) (ext 0, ext 1, transfer end)
// bit 12 -- enable_sdata_irq
// bit 11 -- invert_irq_0
// bit 10 -- invert_irq_1
// bit  9 -- enable_transfer_end_irq
// bit  8 -- enable_second_ext_irq
// bit 7:0 -- no_wait_condition_check_point (0xff means no check)
#define STREAM_WAIT_IRQ_CONFIG                     ((0x2306  << 2) + 0xc1100000)
// bit 31:24 -- event address
// bit 23:16 -- event data
// bit 15:1 -- event repeat times  (0 means one time event)
// bit 0  -- Start Event (write) event_busy (read)
#define STREAM_EVENT_CTL                           ((0x2307  << 2) + 0xc1100000)
// ---------------------------
// SDIO (8)
// ---------------------------
// `define C_SDIO_HIGH16                   8'h00 
// bit 31:0 -- cmd_argument/MS_SHORT_DATA_WRITE
#define CMD_ARGUMENT                               ((0x2308  << 2) + 0xc1100000)
// bit 31:24 -- repeat_package_times/MS_SHORT_DATA_WRITE_NUMBER
// bit 21   -- use_int_window
// bit 20   -- cmd_send_data/MS_HAVE_LONG_DATA_WRITE
// bit 19   -- check_busy_on_dat0 (used for R1b response)
// bit 18   -- response_crc7_from_8
// bit 17   -- response_have_data/MS_HAVE_LONG_DATA_READ
// bit 16   -- response_do_not_have_crc7/MS_SHORT_DATA_DO_NOT_HAVE_CRC16
// bit 15:8 -- cmd_response_bits (00 means no response) /MS_SHORT_DATA_READ_NUMBER
// bit 7:0 -- cmd_command/MS_TPC
#define CMD_SEND                                   ((0x2309  << 2) + 0xc1100000)
// bit 31:29 -- sdio_write_CRC_ok_status
// bit 28:23 -- sdio_write_Nwr
// bit 22:21 -- m_endian
// bit 20    -- bus_width
// bit 19    -- data_latch_at_negedge (normally at posedge)
// bit 18    -- do_not_delay_data (normally delay one clock)
// bit 17:12 -- cmd_argument_bits (before CRC, normally : 39) 
// bit 11 -- cmd_out_at_posedge (normally at negedge)
// bit 10 -- cmd_disable_CRC
// bit 9:0 -- cmd_clk_divide
#define SDIO_CONFIG                                ((0x230a  << 2) + 0xc1100000)
// bit 31:19 -- sdio_timing_out_count
// bit 18 -- arc_timing_out_int_en
// bit 17 -- amrisc_timing_out_int_en
// bit 16 -- sdio_timig_out_int   -- write 1 clear this int bit
// bit 15:12 -- sdio_status_info  -- used for change infor between ARC and Amrisc
// bit 11 -- sdio_set_soft_int -- write 1 to this bit will set sdio_soft_int , read out is m_req_sdio
// bit 10 -- sdio_soft_int   -- write 1 clear this int bit
// bit 9 -- sdio_cmd_int   -- write 1 clear this int bit
// bit 8 -- sdio_if_int   -- write 1 clear this int bit
// bit 7 -- sdio_data_write_crc16_ok -- Read-Only
// bit 6 -- sdio_data_read_crc16_ok  -- Read-Only
// bit 5 -- sdio_response_crc7_ok    -- Read-Only
// bit 4 -- sdio_cmd_busy            -- Read-Only
// bit 3:0 -- sdio_status            -- Read-Only
#define SDIO_STATUS_IRQ                            ((0x230b  << 2) + 0xc1100000)
// bit 31 -- halt_hole 0 -- 8 bits 1 -- 16 bits
// bit 30 -- force_halt
// bit 29:24 -- sdio_force_data_read (read_only)
// bit 23:22 -- disable_mem_halt (write and read)
// bit 21:16 -- sdio_force_output_en 
// bit 15 -- soft_reset
// bit 14 -- sdio_force_enable
// bit 13:8 -- sdio_force_data/sdio_read_data
// bit 7:6 -- sdio_if_int_config 
// bit 5 -- arc_soft_int_en
// bit 4 -- arc_cmd_int_en
// bit 3 -- arc_if_int_en
// bit 2 -- amrisc_soft_int_en
// bit 1 -- amrisc_cmd_int_en
// bit 0 -- amrisc_if_int_en
#define SDIO_IRQ_CONFIG                            ((0x230c  << 2) + 0xc1100000)
// bit 27:16 -- data_catch_finish_point
// (
// bit 15:12 -- response_read_index  
// bit 9 -- data_catch_readout_en
// bit 8 -- write_read_out_index
// ) this bits only write when write_read_out_index = 1
// bit 11 -- sdio_1_data_swap01 
// bit 10 -- sdio_0_data_on_1 
// bit 7:6 -- data_catch_level 
// bit 5 -- stream_8_bits_mode
// bit 4 -- stream_enable
// bit 3 -- ms_sclk_always
// bit 2 -- ms_enable
// bit 1:0 -- SDIO_port_sel //00-sdio1, 01-sdio2, 02-sdio3
#define SDIO_MULT_CONFIG                           ((0x230d  << 2) + 0xc1100000)
// bit 31:0 -- m_addr_sdio
#define SDIO_M_ADDR                                ((0x230e  << 2) + 0xc1100000)
// bit 31    -- CRC_status_4line
// bit 30    -- data_rw_do_not_have_crc16/MS_LONG_DATA_DO_NOT_HAVE_CRC16
// bit 29:16 -- data_rw_number/MS_LONG_DATA_NUMBER 
// bit 15:0 -- cmd_argument_ext/MS_SHORT_DATA_EXTENSION
#define SDIO_EXTENSION                             ((0x230f  << 2) + 0xc1100000)
// ----------------------------
// ASYNC FIFO (4)
// ----------------------------
#define ASYNC_FIFO_REG0                            ((0x2310  << 2) + 0xc1100000)
#define ASYNC_FIFO_REG1                            ((0x2311  << 2) + 0xc1100000)
    #define ASYNC_FIFO_FLUSH_STATUS     31
    #define ASYNC_FIFO_ERR              30
    #define ASYNC_FIFO_FIFO_EMPTY       29
    #define ASYNC_FIFO_TO_HIU           24
    #define ASYNC_FIFO_FLUSH            23
    #define ASYNC_FIFO_RESET            22
    #define ASYNC_FIFO_WRAP_EN          21
    #define ASYNC_FIFO_FLUSH_EN         20
    #define ASYNC_FIFO_RESIDUAL_MSB     19
    #define ASYNC_FIFO_RESIDUAL_LSB     15
    #define ASYNC_FIFO_FLUSH_CNT_MSB    14
    #define ASYNC_FIFO_FLUSH_CNT_LSB    0
#define ASYNC_FIFO_REG2                            ((0x2312  << 2) + 0xc1100000)
    #define ASYNC_FIFO_FIFO_FULL        26
    #define ASYNC_FIFO_FILL_STATUS      25
    #define ASYNC_FIFO_SOURCE_MSB       24
    #define ASYNC_FIFO_SOURCE_LSB       23
    #define ASYNC_FIFO_ENDIAN_MSB       22
    #define ASYNC_FIFO_ENDIAN_LSB       21
    #define ASYNC_FIFO_FILL_EN          20
    #define ASYNC_FIFO_FILL_CNT_MSB     19
    #define ASYNC_FIFO_FILL_CNT_LSB     0
#define ASYNC_FIFO_REG3                            ((0x2313  << 2) + 0xc1100000)
    #define ASYNC_FLUSH_SIZE_IRQ_MSB    15
    #define ASYNC_FLUSH_SIZE_IRQ_LSB    0
// ----------------------------
// ASYNC FIFO (4)
// ----------------------------
#define ASYNC_FIFO2_REG0                           ((0x2314  << 2) + 0xc1100000)
#define ASYNC_FIFO2_REG1                           ((0x2315  << 2) + 0xc1100000)
#define ASYNC_FIFO2_REG2                           ((0x2316  << 2) + 0xc1100000)
#define ASYNC_FIFO2_REG3                           ((0x2317  << 2) + 0xc1100000)
// ----------------------------
// SDIO_AHB_CBUS (2)
// ----------------------------
// bit   17    -- arc_ahb_cbus_int_en
// bit   16    -- amrisc_ahb_cbus_int_en
// bit 15:8    -- SDIO_FIFO_count
// bit  7:4    -- m_req_count
// bit    3    -- reserved
// bit    2    -- m_write_cbus
// bit    1    -- m_req_cbus
// bit    0    -- sdio_ahb_cbus_enable
#define SDIO_AHB_CBUS_CTRL                         ((0x2318  << 2) + 0xc1100000)
// m_rd_data[31:0] when (m_write_cbus == 0)  CBUS write
// m_wr_data[31:0] when (m_write_cbus == 1)  CBUS read
#define SDIO_AHB_CBUS_M_DATA                       ((0x2319  << 2) + 0xc1100000)
// ----------------------------
// SPI 
// ----------------------------
#define SPI_FLASH_CMD                              ((0x2320  << 2) + 0xc1100000)
    #define SPI_FLASH_READ    31
    #define SPI_FLASH_WREN    30
    #define SPI_FLASH_WRDI    29
    #define SPI_FLASH_RDID    28
    #define SPI_FLASH_RDSR    27
    #define SPI_FLASH_WRSR    26
    #define SPI_FLASH_PP      25
    #define SPI_FLASH_SE      24
    #define SPI_FLASH_BE      23
    #define SPI_FLASH_CE      22
    #define SPI_FLASH_DP      21
    #define SPI_FLASH_RES     20
    #define SPI_HPM           19
    #define SPI_FLASH_USR     18
    #define SPI_FLASH_USR_ADDR 15
    #define SPI_FLASH_USR_DUMMY 14
    #define SPI_FLASH_USR_DIN   13
    #define SPI_FLASH_USR_DOUT   12
    #define SPI_FLASH_USR_DUMMY_BLEN   10
    #define SPI_FLASH_USR_CMD     0
#define SPI_FLASH_ADDR                             ((0x2321  << 2) + 0xc1100000)
    #define SPI_FLASH_BYTES_LEN 24
    #define SPI_FLASH_ADDR_START 0
#define SPI_FLASH_CTRL                             ((0x2322  << 2) + 0xc1100000)
    #define SPI_ENABLE_AHB    17
    #define SPI_SST_AAI       16
    #define SPI_RES_RID       15
    #define SPI_FREAD_DUAL    14
    #define SPI_READ_READ_EN  13
    #define SPI_CLK_DIV0      12
    #define SPI_CLKCNT_N      8
    #define SPI_CLKCNT_H      4
    #define SPI_CLKCNT_L      0
#define SPI_FLASH_CTRL1                            ((0x2323  << 2) + 0xc1100000)
#define SPI_FLASH_STATUS                           ((0x2324  << 2) + 0xc1100000)
#define SPI_FLASH_CTRL2                            ((0x2325  << 2) + 0xc1100000)
#define SPI_FLASH_CLOCK                            ((0x2326  << 2) + 0xc1100000)
#define SPI_FLASH_USER                             ((0x2327  << 2) + 0xc1100000)
#define SPI_FLASH_USER1                            ((0x2328  << 2) + 0xc1100000)
#define SPI_FLASH_USER2                            ((0x2329  << 2) + 0xc1100000)
#define SPI_FLASH_USER3                            ((0x232a  << 2) + 0xc1100000)
#define SPI_FLASH_USER4                            ((0x232b  << 2) + 0xc1100000)
#define SPI_FLASH_SLAVE                            ((0x232c  << 2) + 0xc1100000)
#define SPI_FLASH_SLAVE1                           ((0x232d  << 2) + 0xc1100000)
#define SPI_FLASH_SLAVE2                           ((0x232e  << 2) + 0xc1100000)
#define SPI_FLASH_SLAVE3                           ((0x232f  << 2) + 0xc1100000)
#define SPI_FLASH_C0                               ((0x2330  << 2) + 0xc1100000)
#define SPI_FLASH_C1                               ((0x2331  << 2) + 0xc1100000)
#define SPI_FLASH_C2                               ((0x2332  << 2) + 0xc1100000)
#define SPI_FLASH_C3                               ((0x2333  << 2) + 0xc1100000)
#define SPI_FLASH_C4                               ((0x2334  << 2) + 0xc1100000)
#define SPI_FLASH_C5                               ((0x2335  << 2) + 0xc1100000)
#define SPI_FLASH_C6                               ((0x2336  << 2) + 0xc1100000)
#define SPI_FLASH_C7                               ((0x2337  << 2) + 0xc1100000)
#define SPI_FLASH_B8                               ((0x2338  << 2) + 0xc1100000)
#define SPI_FLASH_B9                               ((0x2339  << 2) + 0xc1100000)
#define SPI_FLASH_B10                              ((0x233a  << 2) + 0xc1100000)
#define SPI_FLASH_B11                              ((0x233b  << 2) + 0xc1100000)
#define SPI_FLASH_B12                              ((0x233c  << 2) + 0xc1100000)
#define SPI_FLASH_B13                              ((0x233d  << 2) + 0xc1100000)
#define SPI_FLASH_B14                              ((0x233e  << 2) + 0xc1100000)
#define SPI_FLASH_B15                              ((0x233f  << 2) + 0xc1100000)
// ----------------------------
// I2C Master
// ----------------------------
#define I2C_M_3_CONTROL_REG                        ((0x2348  << 2) + 0xc1100000)
#define I2C_M_3_SLAVE_ADDR                         ((0x2349  << 2) + 0xc1100000)
#define I2C_M_3_TOKEN_LIST0                        ((0x234a  << 2) + 0xc1100000)
#define I2C_M_3_TOKEN_LIST1                        ((0x234b  << 2) + 0xc1100000)
#define I2C_M_3_WDATA_REG0                         ((0x234c  << 2) + 0xc1100000)
#define I2C_M_3_WDATA_REG1                         ((0x234d  << 2) + 0xc1100000)
#define I2C_M_3_RDATA_REG0                         ((0x234e  << 2) + 0xc1100000)
#define I2C_M_3_RDATA_REG1                         ((0x234f  << 2) + 0xc1100000)
// ----------------------------
// SPICC
// ----------------------------
#define SPICC_RXDATA                               ((0x2360  << 2) + 0xc1100000)
#define SPICC_TXDATA                               ((0x2361  << 2) + 0xc1100000)
#define SPICC_CONREG                               ((0x2362  << 2) + 0xc1100000)
#define SPICC_INTREG                               ((0x2363  << 2) + 0xc1100000)
#define SPICC_DMAREG                               ((0x2364  << 2) + 0xc1100000)
#define SPICC_STATREG                              ((0x2365  << 2) + 0xc1100000)
#define SPICC_PERIODREG                            ((0x2366  << 2) + 0xc1100000)
#define SPICC_TESTREG                              ((0x2367  << 2) + 0xc1100000)
#define SPICC_DRADDR                               ((0x2368  << 2) + 0xc1100000)
#define SPICC_DWADDR                               ((0x2369  << 2) + 0xc1100000)
// ----------------------------
// SDHC (SDIO #2)
// ----------------------------
#define SD_REG0_ARGU                               ((0x2380  << 2) + 0xc1100000)
#define SD_REG1_SEND                               ((0x2381  << 2) + 0xc1100000)
#define SD_REG2_CNTL                               ((0x2382  << 2) + 0xc1100000)
#define SD_REG3_STAT                               ((0x2383  << 2) + 0xc1100000)
#define SD_REG4_CLKC                               ((0x2384  << 2) + 0xc1100000)
#define SD_REG5_ADDR                               ((0x2385  << 2) + 0xc1100000)
#define SD_REG6_PDMA                               ((0x2386  << 2) + 0xc1100000)
#define SD_REG7_MISC                               ((0x2387  << 2) + 0xc1100000)
#define SD_REG8_DATA                               ((0x2388  << 2) + 0xc1100000)
#define SD_REG9_ICTL                               ((0x2389  << 2) + 0xc1100000)
#define SD_REGA_ISTA                               ((0x238a  << 2) + 0xc1100000)
#define SD_REGB_SRST                               ((0x238b  << 2) + 0xc1100000)
#define SD_REGC_ESTA                               ((0x238c  << 2) + 0xc1100000)
#define SD_REGD_ENHC                               ((0x238d  << 2) + 0xc1100000)
#define SD_REGE_CLK2                               ((0x238e  << 2) + 0xc1100000)
//
// Closing file:  periphs_reg.h
//
//
// Reading file:  isa_reg.h
//
// $isa/rtl/isa_core register defines for the APB bus
// CBUS base slave address
// -----------------------------------------------
// CBUS_BASE:  ISA_CBUS_BASE = 0x26
// -----------------------------------------------
// Up to 256 registers for this base
#define ISA_DEBUG_REG0                             ((0x2600  << 2) + 0xc1100000)
#define ISA_DEBUG_REG1                             ((0x2601  << 2) + 0xc1100000)
#define ISA_DEBUG_REG2                             ((0x2602  << 2) + 0xc1100000)
#define ISA_DEBUG_REG3                             ((0x2603  << 2) + 0xc1100000)
#define ISA_PLL_CLK_SIM0                           ((0x2608  << 2) + 0xc1100000)
#define ISA_CNTL_REG0                              ((0x2609  << 2) + 0xc1100000)
// -----------------------------------------------------------
#define AO_CPU_IRQ_IN0_INTR_STAT                   ((0x2610  << 2) + 0xc1100000)
#define AO_CPU_IRQ_IN0_INTR_STAT_CLR               ((0x2611  << 2) + 0xc1100000)
#define AO_CPU_IRQ_IN0_INTR_MASK                   ((0x2612  << 2) + 0xc1100000)
#define AO_CPU_IRQ_IN0_INTR_FIRQ_SEL               ((0x2613  << 2) + 0xc1100000)
// define MEDIA_CPU_IRQ_IN1_INTR_STAT           8'h14
// define MEDIA_CPU_IRQ_IN1_INTR_STAT_CLR       8'h15
// define MEDIA_CPU_IRQ_IN1_INTR_MASK           8'h16
// define MEDIA_CPU_IRQ_IN1_INTR_FIRQ_SEL       8'h17
// 
// define MEDIA_CPU_IRQ_IN2_INTR_STAT              8'h18
// define MEDIA_CPU_IRQ_IN2_INTR_STAT_CLR          8'h19
// define MEDIA_CPU_IRQ_IN2_INTR_MASK              8'h1a
// define MEDIA_CPU_IRQ_IN2_INTR_FIRQ_SEL          8'h1b
// 
// define MEDIA_CPU_IRQ_IN3_INTR_STAT            8'h1c
// define MEDIA_CPU_IRQ_IN3_INTR_STAT_CLR        8'h1d
// define MEDIA_CPU_IRQ_IN3_INTR_MASK            8'h1e
// define MEDIA_CPU_IRQ_IN3_INTR_FIRQ_SEL        8'h1f
#define GPIO_INTR_EDGE_POL                         ((0x2620  << 2) + 0xc1100000)
#define GPIO_INTR_GPIO_SEL0                        ((0x2621  << 2) + 0xc1100000)
#define GPIO_INTR_GPIO_SEL1                        ((0x2622  << 2) + 0xc1100000)
#define GPIO_INTR_FILTER_SEL0                      ((0x2623  << 2) + 0xc1100000)
// `define GLOBAL_INTR_DISABLE                 8'h24    never used
#define MEDIA_CPU_INTR_STAT                        ((0x2628  << 2) + 0xc1100000)
#define MEDIA_CPU_INTR_STAT_CLR                    ((0x2629  << 2) + 0xc1100000)
#define MEDIA_CPU_INTR_MASK                        ((0x262a  << 2) + 0xc1100000)
#define MEDIA_CPU_INTR_FIRQ_SEL                    ((0x262b  << 2) + 0xc1100000)
// -----------------------------------------------------------
#define ISA_BIST_REG0                              ((0x2630  << 2) + 0xc1100000)
#define ISA_BIST_REG1                              ((0x2631  << 2) + 0xc1100000)
// -----------------------------------------------------------
#define WATCHDOG_TC                                ((0x2640  << 2) + 0xc1100000)
#define WATCHDOG_RESET                             ((0x2641  << 2) + 0xc1100000)
// -----------------------------------------------------------
#define AHB_ARBITER_REG                            ((0x2642  << 2) + 0xc1100000)
#define AHB_ARBDEC_REG                             ((0x2643  << 2) + 0xc1100000)
#define AHB_ARBITER2_REG                           ((0x264a  << 2) + 0xc1100000)
#define DEVICE_MMCP_CNTL                           ((0x264b  << 2) + 0xc1100000)
#define AUDIO_MMCP_CNTL                            ((0x264c  << 2) + 0xc1100000)
// -----------------------------------------------------------
#define ISA_TIMER_MUX                              ((0x2650  << 2) + 0xc1100000)
#define ISA_TIMERA                                 ((0x2651  << 2) + 0xc1100000)
#define ISA_TIMERB                                 ((0x2652  << 2) + 0xc1100000)
#define ISA_TIMERC                                 ((0x2653  << 2) + 0xc1100000)
#define ISA_TIMERD                                 ((0x2654  << 2) + 0xc1100000)
#define ISA_TIMERE                                 ((0x2655  << 2) + 0xc1100000)
#define FBUF_ADDR                                  ((0x2656  << 2) + 0xc1100000)
    #define VIDEO_FRM_BUF_MSB_BIT      23 
    #define VIDEO_FRM_BUF_LSB_BIT       2 
#define SDRAM_CTL0                                 ((0x2657  << 2) + 0xc1100000)
#define SDRAM_CTL2                                 ((0x2658  << 2) + 0xc1100000)
//`define AO_CPU_CTL                          8'h59
#define SDRAM_CTL4                                 ((0x265a  << 2) + 0xc1100000)
#define SDRAM_CTL5                                 ((0x265b  << 2) + 0xc1100000)
#define SDRAM_CTL6                                 ((0x265c  << 2) + 0xc1100000)
#define SDRAM_CTL7                                 ((0x265d  << 2) + 0xc1100000)
#define SDRAM_CTL8                                 ((0x265e  << 2) + 0xc1100000)
#define AHB_MP4_MC_CTL                             ((0x265f  << 2) + 0xc1100000)
#define MEDIA_CPU_PCR                              ((0x2660  << 2) + 0xc1100000)
#define MEDIA_CPU_CTL                              ((0x2661  << 2) + 0xc1100000)
#define ISA_TIMER_MUX1                             ((0x2664  << 2) + 0xc1100000)
#define ISA_TIMERF                                 ((0x2665  << 2) + 0xc1100000)
#define ISA_TIMERG                                 ((0x2666  << 2) + 0xc1100000)
#define ISA_TIMERH                                 ((0x2667  << 2) + 0xc1100000)
#define ISA_TIMERI                                 ((0x2668  << 2) + 0xc1100000)
// ---------------------------------------------
#define ABUF_WR_CTL0                               ((0x2670  << 2) + 0xc1100000)
    #define ABUF_WR_INT_EN	    31
    #define ABUF_WR_INT_POS_MSB      30 
    #define ABUF_WR_INT_POS_LSB      16 
    #define ABUF_WR_BLK_SIZE_MSB     14 
    #define ABUF_WR_BLK_SIZE_LSB      0
#define ABUF_WR_CTL1                               ((0x2671  << 2) + 0xc1100000)
    #define ABUF_WR_INT_EN	    31
    #define ABUF_WR_INT_POS_MSB      30 
    #define ABUF_WR_INT_POS_LSB      16 
    #define ABUF_WR_BLK_SIZE_MSB     14 
    #define ABUF_WR_BLK_SIZE_LSB      0
#define ABUF_WR_CTL2                               ((0x2672  << 2) + 0xc1100000)
    #define ABUF_WR_CUR_FF_CNT_MSB   21
    #define ABUF_WR_CUR_FF_CNT_LSB   16
    #define ABUF_WR_CUR_BLK_MSB      14
    #define ABUF_WR_CUR_BLK_LSB       0   
#define ABUF_WR_CTL3                               ((0x2673  << 2) + 0xc1100000)
    #define ABUF_WR_AHB_RST_PLS       3
    #define ABUF_WR_FF_CLR_PLS        2
    #define ABUF_WR_PLY_RPT_LVL	     1
    #define ABUF_WR_FF_PAUSE_LVL      0
#define ABUF_RD_CTL0                               ((0x2674  << 2) + 0xc1100000)
#define ABUF_RD_CTL1                               ((0x2675  << 2) + 0xc1100000)
    #define ABUF_RD_INT_EN	    31
    #define ABUF_RD_INT_POS_MSB      30 
    #define ABUF_RD_INT_POS_LSB      16 
    #define ABUF_RD_BLK_SIZE_MSB     14 
    #define ABUF_RD_BLK_SIZE_LSB      0   
#define ABUF_RD_CTL2                               ((0x2676  << 2) + 0xc1100000)
    #define ABUF_RD_CUR_FF_CNT_MSB   21
    #define ABUF_RD_CUR_FF_CNT_LSB   16
    #define ABUF_RD_CUR_BLK_MSB      14
    #define ABUF_RD_CUR_BLK_LSB       0   
#define ABUF_RD_CTL3                               ((0x2677  << 2) + 0xc1100000)
    #define ABUF_RD_PLY_ONCE_PLS      4
    #define ABUF_RD_AHB_RST_PLS       3
    #define ABUF_RD_FF_CLR_PLS        2
    #define ABUF_RD_PLY_RPT_LVL	     1
    #define ABUF_RD_FF_PAUSE_LVL      0
#define ABUF_ARB_CTL0                              ((0x2678  << 2) + 0xc1100000)
#define ABUF_FIFO_CTL0                             ((0x2679  << 2) + 0xc1100000)
    #define AIUout_FIFO_THRESHOLD_MSB 11
    #define AIUout_FIFO_THRESHOLD_LSB 6 
    #define AIUin_FIFO_THRESHOLD_MSB  5
    #define AIUin_FIFO_THRESHOLD_LSB  0
// ---------------------------------------------
#define AHB_BRIDGE_CNTL_WR                         ((0x2680  << 2) + 0xc1100000)
#define AHB_BRIDGE_REMAP0                          ((0x2681  << 2) + 0xc1100000)
#define AHB_BRIDGE_REMAP1                          ((0x2682  << 2) + 0xc1100000)
#define AHB_BRIDGE_REMAP2                          ((0x2683  << 2) + 0xc1100000)
#define AHB_BRIDGE_REMAP3                          ((0x2684  << 2) + 0xc1100000)
#define AHB_BRIDGE_CNTL_REG1                       ((0x2685  << 2) + 0xc1100000)
#define AHB_BRIDGE_CNTL_REG2                       ((0x2686  << 2) + 0xc1100000)
// ---------------------------------------------
// ----------------------------------------------
// `define SYS_CPU_0_IRQ_IN0_INTR_STAT         8'h90
// `define SYS_CPU_0_IRQ_IN0_INTR_STAT_CLR     8'h91
// `define SYS_CPU_0_IRQ_IN0_INTR_MASK         8'h92
// `define SYS_CPU_0_IRQ_IN0_INTR_FIRQ_SEL     8'h93
// `define SYS_CPU_0_IRQ_IN1_INTR_STAT         8'h94
// `define SYS_CPU_0_IRQ_IN1_INTR_STAT_CLR     8'h95
// `define SYS_CPU_0_IRQ_IN1_INTR_MASK         8'h96
// `define SYS_CPU_0_IRQ_IN1_INTR_FIRQ_SEL     8'h97
// `define SYS_CPU_0_IRQ_IN2_INTR_STAT         8'h98
// `define SYS_CPU_0_IRQ_IN2_INTR_STAT_CLR     8'h99
// `define SYS_CPU_0_IRQ_IN2_INTR_MASK         8'h9a
// `define SYS_CPU_0_IRQ_IN2_INTR_FIRQ_SEL     8'h9b
// `define SYS_CPU_0_IRQ_IN3_INTR_STAT         8'h9c
// `define SYS_CPU_0_IRQ_IN3_INTR_STAT_CLR     8'h9d
// `define SYS_CPU_0_IRQ_IN3_INTR_MASK         8'h9e
// `define SYS_CPU_0_IRQ_IN3_INTR_FIRQ_SEL     8'h9f
// ----------------------------------------------
// `define SYS_CPU_1_IRQ_IN0_INTR_STAT         8'ha0
// `define SYS_CPU_1_IRQ_IN0_INTR_STAT_CLR     8'ha1
// `define SYS_CPU_1_IRQ_IN0_INTR_MASK         8'ha2
// `define SYS_CPU_1_IRQ_IN0_INTR_FIRQ_SEL     8'ha3
//  
// `define SYS_CPU_1_IRQ_IN1_INTR_STAT         8'ha4
// `define SYS_CPU_1_IRQ_IN1_INTR_STAT_CLR     8'ha5
// `define SYS_CPU_1_IRQ_IN1_INTR_MASK         8'ha6
// `define SYS_CPU_1_IRQ_IN1_INTR_FIRQ_SEL     8'ha7
//  
// `define SYS_CPU_1_IRQ_IN2_INTR_STAT         8'ha8
// `define SYS_CPU_1_IRQ_IN2_INTR_STAT_CLR     8'ha9
// `define SYS_CPU_1_IRQ_IN2_INTR_MASK         8'haa
// `define SYS_CPU_1_IRQ_IN2_INTR_FIRQ_SEL     8'hab
//  
// `define SYS_CPU_1_IRQ_IN3_INTR_STAT         8'hac
// `define SYS_CPU_1_IRQ_IN3_INTR_STAT_CLR     8'had
// `define SYS_CPU_1_IRQ_IN3_INTR_MASK         8'hae
// `define SYS_CPU_1_IRQ_IN3_INTR_FIRQ_SEL     8'haf
// ----------------------------------------------
// `define MEDIA_CPU_IRQ_IN4_INTR_STAT         8'hb0
// `define MEDIA_CPU_IRQ_IN4_INTR_STAT_CLR     8'hb1
// `define MEDIA_CPU_IRQ_IN4_INTR_MASK         8'hb2
// `define MEDIA_CPU_IRQ_IN4_INTR_FIRQ_SEL     8'hb3
// `define SYS_CPU_0_IRQ_IN4_INTR_STAT         8'hb4
// `define SYS_CPU_0_IRQ_IN4_INTR_STAT_CLR     8'hb5
// `define SYS_CPU_0_IRQ_IN4_INTR_MASK         8'hb6
// `define SYS_CPU_0_IRQ_IN4_INTR_FIRQ_SEL     8'hb7
// `define SYS_CPU_1_IRQ_IN4_INTR_STAT         8'hb8
// `define SYS_CPU_1_IRQ_IN4_INTR_STAT_CLR     8'hb9
// `define SYS_CPU_1_IRQ_IN4_INTR_MASK         8'hba
// `define SYS_CPU_1_IRQ_IN4_INTR_FIRQ_SEL     8'hbb
// `define SYS_CPU_2_IRQ_IN4_INTR_STAT         8'hbc
// `define SYS_CPU_2_IRQ_IN4_INTR_STAT_CLR     8'hbd
// `define SYS_CPU_2_IRQ_IN4_INTR_MASK         8'hbe
// `define SYS_CPU_2_IRQ_IN4_INTR_FIRQ_SEL     8'hbf
// ----------------------------------------------
// `define SYS_CPU_2_IRQ_IN0_INTR_STAT         8'hc0
// `define SYS_CPU_2_IRQ_IN0_INTR_STAT_CLR     8'hc1
// `define SYS_CPU_2_IRQ_IN0_INTR_MASK         8'hc2
// `define SYS_CPU_2_IRQ_IN0_INTR_FIRQ_SEL     8'hc3
// `define SYS_CPU_2_IRQ_IN1_INTR_STAT         8'hc4
// `define SYS_CPU_2_IRQ_IN1_INTR_STAT_CLR     8'hc5
// `define SYS_CPU_2_IRQ_IN1_INTR_MASK         8'hc6
// `define SYS_CPU_2_IRQ_IN1_INTR_FIRQ_SEL     8'hc7
// `define SYS_CPU_2_IRQ_IN2_INTR_STAT         8'hc8
// `define SYS_CPU_2_IRQ_IN2_INTR_STAT_CLR     8'hc9
// `define SYS_CPU_2_IRQ_IN2_INTR_MASK         8'hca
// `define SYS_CPU_2_IRQ_IN2_INTR_FIRQ_SEL     8'hcb
// `define SYS_CPU_2_IRQ_IN3_INTR_STAT         8'hcc
// `define SYS_CPU_2_IRQ_IN3_INTR_STAT_CLR     8'hcd
// `define SYS_CPU_2_IRQ_IN3_INTR_MASK         8'hce
// `define SYS_CPU_2_IRQ_IN3_INTR_FIRQ_SEL     8'hcf
// ----------------------------------------------
// `define SYS_CPU_3_IRQ_IN0_INTR_STAT         8'hd0
// `define SYS_CPU_3_IRQ_IN0_INTR_STAT_CLR     8'hd1
// `define SYS_CPU_3_IRQ_IN0_INTR_MASK         8'hd2
// `define SYS_CPU_3_IRQ_IN0_INTR_FIRQ_SEL     8'hd3
// `define SYS_CPU_3_IRQ_IN1_INTR_STAT         8'hd4
// `define SYS_CPU_3_IRQ_IN1_INTR_STAT_CLR     8'hd5
// `define SYS_CPU_3_IRQ_IN1_INTR_MASK         8'hd6
// `define SYS_CPU_3_IRQ_IN1_INTR_FIRQ_SEL     8'hd7
// `define SYS_CPU_3_IRQ_IN2_INTR_STAT         8'hd8
// `define SYS_CPU_3_IRQ_IN2_INTR_STAT_CLR     8'hd9
// `define SYS_CPU_3_IRQ_IN2_INTR_MASK         8'hda
// `define SYS_CPU_3_IRQ_IN2_INTR_FIRQ_SEL     8'hdb
// `define SYS_CPU_3_IRQ_IN3_INTR_STAT         8'hdc
// `define SYS_CPU_3_IRQ_IN3_INTR_STAT_CLR     8'hdd
// `define SYS_CPU_3_IRQ_IN3_INTR_MASK         8'hde
// `define SYS_CPU_3_IRQ_IN3_INTR_FIRQ_SEL     8'hdf
// ----------------------------------------------
// `define SYS_CPU_3_IRQ_IN4_INTR_STAT         8'he0
// `define SYS_CPU_3_IRQ_IN4_INTR_STAT_CLR     8'he1
// `define SYS_CPU_3_IRQ_IN4_INTR_MASK         8'he2
// `define SYS_CPU_3_IRQ_IN4_INTR_FIRQ_SEL     8'he3
// `define MEDIA_CPU_IRQ_IN5_INTR_STAT         8'he4
// `define MEDIA_CPU_IRQ_IN5_INTR_STAT_CLR     8'he5
// `define MEDIA_CPU_IRQ_IN5_INTR_MASK         8'he6
// `define MEDIA_CPU_IRQ_IN5_INTR_FIRQ_SEL     8'he7
// `define SYS_CPU_0_IRQ_IN5_INTR_STAT         8'he8
// `define SYS_CPU_0_IRQ_IN5_INTR_STAT_CLR     8'he9
// `define SYS_CPU_0_IRQ_IN5_INTR_MASK         8'hea
// `define SYS_CPU_0_IRQ_IN5_INTR_FIRQ_SEL     8'heb
//
// Closing file:  isa_reg.h
//
//
// Reading file:  bt656_reg.h
//
// synopsys translate_off
// synopsys translate_on
// ----------------------------
// BT656 0x2d  
// ----------------------------
// -----------------------------------------------
// CBUS_BASE:  BT656_CBUS_BASE = 0x13
// -----------------------------------------------
#define BT_CTRL                                    ((0x1340  << 2) + 0xc1100000)
    #define BT_SOFT_RESET           31      // Soft reset
    #define BT_JPEG_START           30  
    #define BT_JPEG_IGNORE_BYTES    18     //20:18
    #define BT_JPEG_IGNORE_LAST     17
    #define BT_UPDATE_ST_SEL        16 
    #define BT_COLOR_REPEAT         15
    #define BT_VIDEO_MODE           13     // 14:13
    #define BT_AUTO_FMT             12   
    #define BT_PROG_MODE            11
    #define BT_JPEG_MODE            10
    #define BT_XCLK27_EN_BIT        9      // 1 : xclk27 is input.     0 : xclk27 is output.
    #define BT_FID_EN_BIT           8       // 1 : enable use FID port.
    #define BT_CLK27_SEL_BIT        7       // 1 : external xclk27      0 : internal clk27.
    #define BT_CLK27_PHASE_BIT      6       // 1 : no inverted          0 : inverted.
    #define BT_ACE_MODE_BIT         5       // 1 : auto cover error by hardware.
    #define BT_SLICE_MODE_BIT       4       // 1 : no ancillay flag     0 : with ancillay flag.
    #define BT_FMT_MODE_BIT         3       // 1 : ntsc                 0 : pal.
    #define BT_REF_MODE_BIT         2       // 1 : from bit stream.     0 : from ports.
    #define BT_MODE_BIT             1       // 1 : BT656 model          0 : SAA7118 mode.
    #define BT_EN_BIT               0       // 1 : enable.
#define BT_VBISTART                                ((0x1341  << 2) + 0xc1100000)
#define BT_VBIEND                                  ((0x1342  << 2) + 0xc1100000)
#define BT_FIELDSADR                               ((0x1343  << 2) + 0xc1100000)
#define BT_LINECTRL                                ((0x1344  << 2) + 0xc1100000)
#define BT_VIDEOSTART                              ((0x1345  << 2) + 0xc1100000)
#define BT_VIDEOEND                                ((0x1346  << 2) + 0xc1100000)
#define BT_SLICELINE0                              ((0x1347  << 2) + 0xc1100000)
#define BT_SLICELINE1                              ((0x1348  << 2) + 0xc1100000)
#define BT_PORT_CTRL                               ((0x1349  << 2) + 0xc1100000)
  #define BT_HSYNC_PHASE      0
  #define BT_VSYNC_PHASE      1
  #define BT_HSYNC_PULSE      2
  #define BT_VSYNC_PULSE      3
  #define BT_FID_PHASE        4
  #define BT_FID_HSVS         5
  #define BT_IDQ_EN           6
  #define BT_IDQ_PHASE        7
  #define BT_D8B              8
  #define BT_10BTO8B          9
  #define BT_FID_DELAY       10    //12:10
  #define BT_VSYNC_DELAY     13    //
  #define BT_HSYNC_DELAY     16
#define BT_SWAP_CTRL                               ((0x134a  << 2) + 0xc1100000)
#define BT_ANCISADR                                ((0x134b  << 2) + 0xc1100000)
#define BT_ANCIEADR                                ((0x134c  << 2) + 0xc1100000)
#define BT_AFIFO_CTRL                              ((0x134d  << 2) + 0xc1100000)
#define BT_601_CTRL0                               ((0x134e  << 2) + 0xc1100000)
#define BT_601_CTRL1                               ((0x134f  << 2) + 0xc1100000)
#define BT_601_CTRL2                               ((0x1350  << 2) + 0xc1100000)
#define BT_601_CTRL3                               ((0x1351  << 2) + 0xc1100000)
#define BT_FIELD_LUMA                              ((0x1352  << 2) + 0xc1100000)
#define BT_RAW_CTRL                                ((0x1353  << 2) + 0xc1100000)
#define BT_STATUS                                  ((0x1354  << 2) + 0xc1100000)
#define BT_INT_CTRL                                ((0x1355  << 2) + 0xc1100000)
#define BT_ANCI_STATUS                             ((0x1356  << 2) + 0xc1100000)
#define BT_VLINE_STATUS                            ((0x1357  << 2) + 0xc1100000)
#define BT_AFIFO_PTR                               ((0x1358  << 2) + 0xc1100000)
#define BT_JPEGBYTENUM                             ((0x1359  << 2) + 0xc1100000)
#define BT_ERR_CNT                                 ((0x135a  << 2) + 0xc1100000)
#define BT_JPEG_STATUS0                            ((0x135b  << 2) + 0xc1100000)
#define BT_JPEG_STATUS1                            ((0x135c  << 2) + 0xc1100000)
#define BT_LCNT_STATUS                             ((0x135d  << 2) + 0xc1100000)
#define BT_PCNT_STATUS                             ((0x135e  << 2) + 0xc1100000)
#define BT656_ADDR_END                             ((0x135f  << 2) + 0xc1100000)
// synopsys translate_off
// synopsys translate_on
//
// Closing file:  bt656_reg.h
//
// TEMP DEFINES
// -----------------------------------------------
// CBUS_BASE:  PERIPHS4_CBUS_BASE = 0x24
// -----------------------------------------------
// -----------------------------------------------
// CBUS_BASE:  PERIPHS5_CBUS_BASE = 0x25
// -----------------------------------------------
// For iq_om_width change for RealVideo
#define IQ_OM_WIDTH                                ((0x2510  << 2) + 0xc1100000)
//`define IQ_OM_WIDTH_12
#define DBG_ADDR_START                             ((0x2ff0  << 2) + 0xc1100000)
#define DBG_ADDR_END                               ((0x2fff  << 2) + 0xc1100000)
#define DBG_CTRL                                   ((0x2ff1  << 2) + 0xc1100000)
#define DBG_LED                                    ((0x2ff2  << 2) + 0xc1100000)
#define DBG_SWITCH                                 ((0x2ff3  << 2) + 0xc1100000)
#define DBG_VERSION                                ((0x2ff4  << 2) + 0xc1100000)
//========================================================================
//  Global Control Registers			    (12'h000 - 12'h0ff)
//
//========================================================================
// -----------------------------------------------
// CBUS_BASE:  RESET_CBUS_BASE = 0x11
// -----------------------------------------------
#define VERSION_CTRL                               ((0x1100  << 2) + 0xc1100000)
#define RESET0_REGISTER                            ((0x1101  << 2) + 0xc1100000)
#define RESET1_REGISTER                            ((0x1102  << 2) + 0xc1100000)
#define RESET2_REGISTER                            ((0x1103  << 2) + 0xc1100000)
#define RESET3_REGISTER                            ((0x1104  << 2) + 0xc1100000)
#define RESET4_REGISTER                            ((0x1105  << 2) + 0xc1100000)
#define RESET5_REGISTER                            ((0x1106  << 2) + 0xc1100000)
#define RESET6_REGISTER                            ((0x1107  << 2) + 0xc1100000)
#define RESET7_REGISTER                            ((0x1108  << 2) + 0xc1100000)
#define RESET0_MASK                                ((0x1110  << 2) + 0xc1100000)
#define RESET1_MASK                                ((0x1111  << 2) + 0xc1100000)
#define RESET2_MASK                                ((0x1112  << 2) + 0xc1100000)
#define RESET3_MASK                                ((0x1113  << 2) + 0xc1100000)
#define RESET4_MASK                                ((0x1114  << 2) + 0xc1100000)
#define RESET5_MASK                                ((0x1115  << 2) + 0xc1100000)
#define RESET6_MASK                                ((0x1116  << 2) + 0xc1100000)
#define CRT_MASK                                   ((0x1117  << 2) + 0xc1100000)
#define RESET7_MASK                                ((0x1118  << 2) + 0xc1100000)
#define RESET0_LEVEL                               ((0x1120  << 2) + 0xc1100000)
#define RESET1_LEVEL                               ((0x1121  << 2) + 0xc1100000)
#define RESET2_LEVEL                               ((0x1122  << 2) + 0xc1100000)
#define RESET3_LEVEL                               ((0x1123  << 2) + 0xc1100000)
#define RESET4_LEVEL                               ((0x1124  << 2) + 0xc1100000)
#define RESET5_LEVEL                               ((0x1125  << 2) + 0xc1100000)
#define RESET6_LEVEL                               ((0x1126  << 2) + 0xc1100000)
#define RESET7_LEVEL                               ((0x1127  << 2) + 0xc1100000)
//======================================
//  Reset Register Bits	
//
//======================================
    #define HIU_RESET	    0x0001
    #define VLD_RESET	    0x0002
    #define IQIDCT_RESET	0x0004
    #define MC_RESET	    0x0008
    #define DCU_RESET	    0x0010
    #define VIU_RESET	    0x0020
    #define AIU_RESET	    0x0040
    #define CPU_RESET	    0x0080
    #define AC3_RESET	    0x0100
    #define MPEG_RESET	    0x0200
//========================================================================
//  Host uP Interface				    (12'h100 - 12'h2ff)
//
//========================================================================
// -----------------------------------------------
// CBUS_BASE:  HIU_CBUS_BASE = 0x10
// -----------------------------------------------
#define SCR_HIU                                    ((0x100b  << 2) + 0xc1100000)
#define HPG_TIMER                                  ((0x100f  << 2) + 0xc1100000)
#define HHI_GP0_PLL_CNTL                           ((0x1010  << 2) + 0xc1100000)
#define HHI_GP0_PLL_CNTL2                          ((0x1011  << 2) + 0xc1100000)
#define HHI_GP0_PLL_CNTL3                          ((0x1012  << 2) + 0xc1100000)
#define HHI_GP0_PLL_CNTL4                          ((0x1013  << 2) + 0xc1100000)
#define HHI_GP0_PLL_CNTL5                          ((0x1014  << 2) + 0xc1100000)
#define HHI_GP1_PLL_CNTL                           ((0x1016  << 2) + 0xc1100000)
#define HHI_GP1_PLL_CNTL2                          ((0x1017  << 2) + 0xc1100000)
#define HHI_GP1_PLL_CNTL3                          ((0x1018  << 2) + 0xc1100000)
#define HHI_GP1_PLL_CNTL4                          ((0x1019  << 2) + 0xc1100000)
#define HHI_GP1_PLL_CNTL5                          ((0x101a  << 2) + 0xc1100000)
#define HHI_CADC_CNTL                              ((0x1020  << 2) + 0xc1100000)
#define HHI_CADC_CNTL2                             ((0x1021  << 2) + 0xc1100000)
#define HHI_CADC_CNTL3                             ((0x1022  << 2) + 0xc1100000)
#define HHI_CADC_CNTL4                             ((0x1023  << 2) + 0xc1100000)
#define HHI_CADC_CNTL5                             ((0x1024  << 2) + 0xc1100000)
#define HHI_CADC_CNTL6                             ((0x1025  << 2) + 0xc1100000)
#define HHI_DADC_CNTL                              ((0x1027  << 2) + 0xc1100000)
#define HHI_DADC_CNTL2                             ((0x1028  << 2) + 0xc1100000)
#define HHI_DADC_RDBK0_I                           ((0x1029  << 2) + 0xc1100000)
#define HHI_DADC_CNTL3                             ((0x102a  << 2) + 0xc1100000)
#define HHI_DADC_CNTL4                             ((0x102b  << 2) + 0xc1100000)
#define HARM_ASB_MB0                               ((0x1030  << 2) + 0xc1100000)
#define HARM_ASB_MB1                               ((0x1031  << 2) + 0xc1100000)
#define HARM_ASB_MB2                               ((0x1032  << 2) + 0xc1100000)
#define HARM_ASB_MB3                               ((0x1033  << 2) + 0xc1100000)
#define HASB_ARM_MB0                               ((0x1034  << 2) + 0xc1100000)
#define HASB_ARM_MB1                               ((0x1035  << 2) + 0xc1100000)
#define HASB_ARM_MB2                               ((0x1036  << 2) + 0xc1100000)
#define HASB_ARM_MB3                               ((0x1037  << 2) + 0xc1100000)
#define HHI_TIMER90K                               ((0x103b  << 2) + 0xc1100000)
#define HHI_MEM_PD_REG0                            ((0x1040  << 2) + 0xc1100000)
//VIU1
//bit 29:28 mem_pd_vi_sharp,  2'b00: Sharpness line buffer memory power on, 2'b11: power down
//bit 29:28 mem_pd_vi_dipost, 2'b00: Deinterlace - di_post memory power on, 2'b11: power down
//bit 27:26 mem_pd_vi_dipre,  2'b00: Deinterlace - di_pre memory power on, 2'b11: power down
//bit 25:24 mem_pd_vi_prot3,  2'b00: picture rotation3 memory power on, 2'b11: power down
//bit 23:22 mem_pd_vi_prot2,  2'b00: picture rotation2 memory power on, 2'b11: power down
//bit 21:20 mem_pd_vi_prot1,  2'b00: picture rotation1 memory power on, 2'b11: power down
//bit 19:18 mem_pd_vi_vdin1,  2'b00: vdin1 memory power on, 2'b11: power down
//bit 17:16 mem_pd_vi_vdin0,  2'b00: vdin0 memory power on, 2'b11: power down
//bit 15:14 mem_pd_vi_osd_sc, 2'b00: osd_scaler memory power on, 2'b11: power down
//bit 13:12 mem_pd_vi_scale,  2'b00: scaler memory power on, 2'b11: power down
//bit 11:10 mem_pd_vi_ofifo,  2'b00: vpp output fifo memory power on, 2'b11: power down
//bit 9:8   mem_pd_vi_chroma, 2'b00: color management module memory power on, 2'b11: power down
//bit 7:6   mem_pd_vi_vd2,    2'b00: vd2 memory power on, 2'b11: power down
//bit 5:4   mem_pd_vi_vd1,    2'b00: vd1 memory power on, 2'b11: power down
//bit 3:2   mem_pd_vi_osd2,   2'b00: osd2 memory power on, 2'b11: power down
//bit 1:0   mem_pd_vi_osd1,   2'b00: osd1 memory power on, 2'b11: power down
#define HHI_VPU_MEM_PD_REG0                        ((0x1041  << 2) + 0xc1100000)
//bit 29:28 mem_pd_atv_dmd,   2'b00: ATV DMD memory power on, 2'b11: power down
//bit 29:28 mem_pd_cvd2,      2'b00: CVD2 memory power on, 2'b11: power down
//bit 27:26 mem_pd_isp,       2'b00: ISP memory power on, 2'b11: power down
//bit 25:24 mem_pd_venci_int, 2'b00: cvbs- enci interface memory power on, 2'b11: power down
//bit 23:22 mem_pd_venc_l_top,2'b00: panel - encl top memory power on, 2'b11: power down
//bit 21:20 mem_pd_vencp_int, 2'b00: hdmi - encp interface memory power on, 2'b11: power down
//bit 13:12 mem_pd_vi2_osd_sc,2'b00: viu2 OSD scaler memory power on, 2'b11: power down
//bit 11:10 mem_pd_vi2_scale, 2'b00: viu2 scaler memory power on, 2'b11: power down
//bit 9:8   mem_pd_vi2_ofifo, 2'b00: viu2 vpp output fifo memory power on, 2'b11: power down
//bit 7:6   mem_pd_vi2_chroma,2'b00: viu2 color management module memory power on, 2'b11: power down
//bit 5:4   mem_pd_vi2_vd1,   2'b00: viu2 vd1 memory power on, 2'b11: power down
//bit 3:2   mem_pd_vi2_osd2,  2'b00: viu2 osd2 memory power on, 2'b11: power down
//bit 1:0   mem_pd_vi2_osd1,  2'b00: viu2 osd1 memory power on, 2'b11: power down
#define HHI_VPU_MEM_PD_REG1                        ((0x1042  << 2) + 0xc1100000)
#define HHI_DEMOD_MEM_PD_REG                       ((0x1043  << 2) + 0xc1100000)
#define HHI_AUD_DAC_CTRL                           ((0x1044  << 2) + 0xc1100000)
// `define HHI_VIID_PLL_CNTL4      8'h46 // video PLL read back
// `define HHI_VIID_PLL_CNTL       8'h47 // Video PLL control, word 1
// `define HHI_VIID_PLL_CNTL2      8'h48 // Video PLL control, word 2
// `define HHI_VIID_PLL_CNTL3      8'h49 // Video PLL control, word 3
#define HHI_VIID_CLK_DIV                           ((0x104a  << 2) + 0xc1100000)
#define HHI_VIID_CLK_CNTL                          ((0x104b  << 2) + 0xc1100000)
#define HHI_VIID_DIVIDER_CNTL                      ((0x104c  << 2) + 0xc1100000)
// Gated clock enables.  There are 64 enables for the MPEG clocks and 32 enables for other clock domains
#define HHI_GCLK_MPEG0                             ((0x1050  << 2) + 0xc1100000)
#define HHI_GCLK_MPEG1                             ((0x1051  << 2) + 0xc1100000)
#define HHI_GCLK_MPEG2                             ((0x1052  << 2) + 0xc1100000)
#define HHI_GCLK_OTHER                             ((0x1054  << 2) + 0xc1100000)
#define HHI_GCLK_AO                                ((0x1055  << 2) + 0xc1100000)
#define HHI_SYS_CPU_CLK_CNTL1                      ((0x1057  << 2) + 0xc1100000)
// PLL Controls
#define HHI_VID_CLK_DIV                            ((0x1059  << 2) + 0xc1100000)
#define HHI_MPEG_CLK_CNTL                          ((0x105d  << 2) + 0xc1100000)
#define HHI_AUD_CLK_CNTL                           ((0x105e  << 2) + 0xc1100000)
#define HHI_VID_CLK_CNTL                           ((0x105f  << 2) + 0xc1100000)
#define HHI_WIFI_CLK_CNTL                          ((0x1060  << 2) + 0xc1100000)
#define HHI_WIFI_PLL_CNTL                          ((0x1061  << 2) + 0xc1100000)
#define HHI_WIFI_PLL_CNTL2                         ((0x1062  << 2) + 0xc1100000)
#define HHI_WIFI_PLL_CNTL3                         ((0x1063  << 2) + 0xc1100000)
#define HHI_AUD_CLK_CNTL2                          ((0x1064  << 2) + 0xc1100000)
#define HHI_VID_CLK_CNTL2                          ((0x1065  << 2) + 0xc1100000)
#define HHI_VID_DIVIDER_CNTL                       ((0x1066  << 2) + 0xc1100000)
#define HHI_SYS_CPU_CLK_CNTL                       ((0x1067  << 2) + 0xc1100000)
#define HHI_VID_PLL_CLK_DIV                        ((0x1068  << 2) + 0xc1100000)
// Moved to Martin's domain `define HHI_DDR_PLL_CNTL        8'h68 // DDR PLL control, word 1
// Moved to Martin's domain `define HHI_DDR_PLL_CNTL2       8'h69 // DDR PLL control, word 2
// Moved to Martin's domain `define HHI_DDR_PLL_CNTL3       8'h6a // DDR PLL control, word 3
// Moved to Martin's domain `define HHI_DDR_PLL_CNTL4       8'h6b // DDR PLL control, word 3
#define HHI_MALI_CLK_CNTL                          ((0x106c  << 2) + 0xc1100000)
#define HHI_MIPI_PHY_CLK_CNTL                      ((0x106e  << 2) + 0xc1100000)
#define HHI_VPU_CLK_CNTL                           ((0x106f  << 2) + 0xc1100000)
#define HHI_OTHER_PLL_CNTL                         ((0x1070  << 2) + 0xc1100000)
#define HHI_OTHER_PLL_CNTL2                        ((0x1071  << 2) + 0xc1100000)
#define HHI_OTHER_PLL_CNTL3                        ((0x1072  << 2) + 0xc1100000)
#define HHI_HDMI_CLK_CNTL                          ((0x1073  << 2) + 0xc1100000)
#define HHI_DEMOD_CLK_CNTL                         ((0x1074  << 2) + 0xc1100000)
#define HHI_SATA_CLK_CNTL                          ((0x1075  << 2) + 0xc1100000)
#define HHI_ETH_CLK_CNTL                           ((0x1076  << 2) + 0xc1100000)
#define HHI_CLK_DOUBLE_CNTL                        ((0x1077  << 2) + 0xc1100000)
#define HHI_VDEC_CLK_CNTL                          ((0x1078  << 2) + 0xc1100000)
#define HHI_VDEC2_CLK_CNTL                         ((0x1079  << 2) + 0xc1100000)
#define HHI_VDEC3_CLK_CNTL                         ((0x107a  << 2) + 0xc1100000)
#define HHI_VDEC4_CLK_CNTL                         ((0x107b  << 2) + 0xc1100000)
// `define HHI_SYS_CPU_AUTO_CLK0        8'h78   never used
// `define HHI_SYS_CPU_AUTO_CLK1        8'h79   never used
// `define HHI_MEDIA_CPU_AUTO_CLK0    8'h7a     never used
// `define HHI_MEDIA_CPU_AUTO_CLK1    8'h7b     never used
#define HHI_HDMI_AFC_CNTL                          ((0x107f  << 2) + 0xc1100000)
#define HHI_HDMIRX_CLK_CNTL                        ((0x1080  << 2) + 0xc1100000)
#define HHI_HDMIRX_AUD_CLK_CNTL                    ((0x1081  << 2) + 0xc1100000)
#define HHI_EDP_APB_CLK_CNTL                       ((0x1082  << 2) + 0xc1100000)
#define HHI_VID_PLL_MOD_CNTL0                      ((0x1084  << 2) + 0xc1100000)
#define HHI_VID_PLL_MOD_LOW_TCNT                   ((0x1085  << 2) + 0xc1100000)
#define HHI_VID_PLL_MOD_HIGH_TCNT                  ((0x1086  << 2) + 0xc1100000)
#define HHI_VID_PLL_MOD_NOM_TCNT                   ((0x1087  << 2) + 0xc1100000)
// Removed `define HHI_DDR_CLK_CNTL            8'h88 
#define HHI_32K_CLK_CNTL                           ((0x1089  << 2) + 0xc1100000)
#define HHI_GEN_CLK_CNTL                           ((0x108a  << 2) + 0xc1100000)
#define HHI_GEN_CLK_CNTL2                          ((0x108b  << 2) + 0xc1100000)
#define HHI_JTAG_CONFIG                            ((0x108e  << 2) + 0xc1100000)
#define HHI_VAFE_CLKXTALIN_CNTL                    ((0x108f  << 2) + 0xc1100000)
#define HHI_VAFE_CLKOSCIN_CNTL                     ((0x1090  << 2) + 0xc1100000)
#define HHI_VAFE_CLKIN_CNTL                        ((0x1091  << 2) + 0xc1100000)
#define HHI_TVFE_AUTOMODE_CLK_CNTL                 ((0x1092  << 2) + 0xc1100000)
#define HHI_VAFE_CLKPI_CNTL                        ((0x1093  << 2) + 0xc1100000)
#define HHI_VDIN_MEAS_CLK_CNTL                     ((0x1094  << 2) + 0xc1100000)
// `define HHI_PCM2_CLK_CNTL           8'h95
#define HHI_PCM_CLK_CNTL                           ((0x1096  << 2) + 0xc1100000)
#define HHI_NAND_CLK_CNTL                          ((0x1097  << 2) + 0xc1100000)
#define HHI_ISP_LED_CLK_CNTL                       ((0x1098  << 2) + 0xc1100000)
#define HHI_EDP_TX_PHY_CNTL0                       ((0x109c  << 2) + 0xc1100000)
#define HHI_EDP_TX_PHY_CNTL1                       ((0x109d  << 2) + 0xc1100000)
#define HHI_MPLL_CNTL                              ((0x10a0  << 2) + 0xc1100000)
#define HHI_MPLL_CNTL2                             ((0x10a1  << 2) + 0xc1100000)
#define HHI_MPLL_CNTL3                             ((0x10a2  << 2) + 0xc1100000)
#define HHI_MPLL_CNTL4                             ((0x10a3  << 2) + 0xc1100000)
#define HHI_MPLL_CNTL5                             ((0x10a4  << 2) + 0xc1100000)
#define HHI_MPLL_CNTL6                             ((0x10a5  << 2) + 0xc1100000)
#define HHI_MPLL_CNTL7                             ((0x10a6  << 2) + 0xc1100000)
#define HHI_MPLL_CNTL8                             ((0x10a7  << 2) + 0xc1100000)
#define HHI_MPLL_CNTL9                             ((0x10a8  << 2) + 0xc1100000)
#define HHI_MPLL_CNTL10                            ((0x10a9  << 2) + 0xc1100000)
#define HHI_ADC_PLL_CNTL                           ((0x10aa  << 2) + 0xc1100000)
#define HHI_ADC_PLL_CNTL2                          ((0x10ab  << 2) + 0xc1100000)
#define HHI_ADC_PLL_CNTL3                          ((0x10ac  << 2) + 0xc1100000)
#define HHI_ADC_PLL_CNTL4                          ((0x10ad  << 2) + 0xc1100000)
#define HHI_AUDCLK_PLL_CNTL                        ((0x10b0  << 2) + 0xc1100000)
#define HHI_AUDCLK_PLL_CNTL2                       ((0x10b1  << 2) + 0xc1100000)
#define HHI_AUDCLK_PLL_CNTL3                       ((0x10b2  << 2) + 0xc1100000)
#define HHI_AUDCLK_PLL_CNTL4                       ((0x10b3  << 2) + 0xc1100000)
#define HHI_AUDCLK_PLL_CNTL5                       ((0x10b4  << 2) + 0xc1100000)
#define HHI_AUDCLK_PLL_CNTL6                       ((0x10b5  << 2) + 0xc1100000)
#define HHI_L2_DDR_CLK_CNTL                        ((0x10b6  << 2) + 0xc1100000)
#define HHI_VDAC_CNTL0                             ((0x10bd  << 2) + 0xc1100000)
#define HHI_VDAC_CNTL1                             ((0x10be  << 2) + 0xc1100000)
#define HHI_SYS_PLL_CNTL                           ((0x10c0  << 2) + 0xc1100000)
#define HHI_SYS_PLL_CNTL2                          ((0x10c1  << 2) + 0xc1100000)
#define HHI_SYS_PLL_CNTL3                          ((0x10c2  << 2) + 0xc1100000)
#define HHI_SYS_PLL_CNTL4                          ((0x10c3  << 2) + 0xc1100000)
#define HHI_SYS_PLL_CNTL5                          ((0x10c4  << 2) + 0xc1100000)
#define HHI_DPLL_TOP_0                             ((0x10c6  << 2) + 0xc1100000)
#define HHI_DPLL_TOP_1                             ((0x10c7  << 2) + 0xc1100000)
#define HHI_HDMI_PLL_CNTL                          ((0x10c8  << 2) + 0xc1100000)
#define HHI_HDMI_PLL_CNTL2                         ((0x10c9  << 2) + 0xc1100000)
#define HHI_HDMI_PLL_CNTL3                         ((0x10ca  << 2) + 0xc1100000)
#define HHI_HDMI_PLL_CNTL4                         ((0x10cb  << 2) + 0xc1100000)
#define HHI_HDMI_PLL_CNTL5                         ((0x10cc  << 2) + 0xc1100000)
#define HHI_HDMI_PLL_CNTL6                         ((0x10cd  << 2) + 0xc1100000)
#define HHI_DSI_LVDS_EDP_CNTL0                     ((0x10d1  << 2) + 0xc1100000)
#define HHI_DSI_LVDS_EDP_CNTL1                     ((0x10d2  << 2) + 0xc1100000)
#define HHI_CSI_PHY_CNTL0                          ((0x10d3  << 2) + 0xc1100000)
#define HHI_CSI_PHY_CNTL1                          ((0x10d4  << 2) + 0xc1100000)
#define HHI_CSI_PHY_CNTL2                          ((0x10d5  << 2) + 0xc1100000)
#define HHI_CSI_PHY_CNTL3                          ((0x10d6  << 2) + 0xc1100000)
#define HHI_CSI_PHY_CNTL4                          ((0x10d7  << 2) + 0xc1100000)
#define HHI_DIF_CSI_PHY_CNTL0                      ((0x10d8  << 2) + 0xc1100000)
#define HHI_DIF_CSI_PHY_CNTL1                      ((0x10d9  << 2) + 0xc1100000)
#define HHI_DIF_CSI_PHY_CNTL2                      ((0x10da  << 2) + 0xc1100000)
#define HHI_DIF_CSI_PHY_CNTL3                      ((0x10db  << 2) + 0xc1100000)
#define HHI_DIF_CSI_PHY_CNTL4                      ((0x10dc  << 2) + 0xc1100000)
#define HHI_DIF_CSI_PHY_CNTL5                      ((0x10dd  << 2) + 0xc1100000)
#define HHI_LVDS_TX_PHY_CNTL0                      ((0x10de  << 2) + 0xc1100000)
#define HHI_LVDS_TX_PHY_CNTL1                      ((0x10df  << 2) + 0xc1100000)
#define HHI_VID2_PLL_CNTL                          ((0x10e0  << 2) + 0xc1100000)
#define HHI_VID2_PLL_CNTL2                         ((0x10e1  << 2) + 0xc1100000)
#define HHI_VID2_PLL_CNTL3                         ((0x10e2  << 2) + 0xc1100000)
#define HHI_VID2_PLL_CNTL4                         ((0x10e3  << 2) + 0xc1100000)
#define HHI_VID2_PLL_CNTL5                         ((0x10e4  << 2) + 0xc1100000)
#define HHI_VID2_PLL_CNTL6                         ((0x10e5  << 2) + 0xc1100000)
#define HHI_HDMI_PHY_CNTL0                         ((0x10e8  << 2) + 0xc1100000)
#define HHI_HDMI_PHY_CNTL1                         ((0x10e9  << 2) + 0xc1100000)
#define HHI_HDMI_PHY_CNTL2                         ((0x10ea  << 2) + 0xc1100000)
#define HHI_HDMI_PHY_CNTL3                         ((0x10eb  << 2) + 0xc1100000)
#define HHI_VID_LOCK_CLK_CNTL                      ((0x10f2  << 2) + 0xc1100000)
#define HHI_ATV_DMD_SYS_CLK_CNTL                   ((0x10f3  << 2) + 0xc1100000)
#define HHI_HDMIRX_AUD_PLL_CNTL                    ((0x10f8  << 2) + 0xc1100000)
#define HHI_HDMIRX_AUD_PLL_CNTL2                   ((0x10f9  << 2) + 0xc1100000)
#define HHI_HDMIRX_AUD_PLL_CNTL3                   ((0x10fa  << 2) + 0xc1100000)
#define HHI_HDMIRX_AUD_PLL_CNTL4                   ((0x10fb  << 2) + 0xc1100000)
#define HHI_HDMIRX_AUD_PLL_CNTL5                   ((0x10fc  << 2) + 0xc1100000)
#define HHI_HDMIRX_AUD_PLL_CNTL6                   ((0x10fd  << 2) + 0xc1100000)
//-----------------------------------------------------------
// PARSER 
//-----------------------------------------------------------
// -----------------------------------------------
// CBUS_BASE:  PARSER_CBUS_BASE = 0x29
// -----------------------------------------------
// bit 31:8 -- es_pack_size
// bit 7:6 -- es_type     00-Video, 01-Audio, 10-Subtitle
// bit 5 -- es_write
// bit 4 -- es_passthrough
// bit 3 -- insert_before_es_write
// bit 2 -- discard_cmd
// bit 1 -- search_cmd
// bit 0 -- Parser Busy
#define PARSER_CONTROL                             ((0x2960  << 2) + 0xc1100000)
// Write
//   bit 31:0 begin address for parser fetch
// Read
//   32 bit current fetch address
#define PARSER_FETCH_ADDR                          ((0x2961  << 2) + 0xc1100000)
// Write
//   bit 31 circle buffer indicator
//   bit 30 check_buffer_stop_addr
//   bit 29:27 fetch endian 
//   bit 26:0 buffer size ( Bytes )
// Special command:
//   when bit 26:0 == 27'h0
//     then bit 29    -- stream_passthrough_enable
//          bit 28:27 -- stream_passthrough_type
// Read
//   6:5 cmd_rd_ptr 
//   4:3 cmd_wr_ptr 
//   2:0 cmd_number 
#define PARSER_FETCH_CMD                           ((0x2962  << 2) + 0xc1100000)
// 31:0 stop_fetch_addr
#define PARSER_FETCH_STOP_ADDR                     ((0x2963  << 2) + 0xc1100000)
// 31:0 stop_fetch_addr - current_write_addr  // read only
#define PARSER_FETCH_LEVEL                         ((0x2964  << 2) + 0xc1100000)
// bit 31 - fetch_dma_urgent
// bit 30 - stream_dma_urgent
// bit 29 - force_pfifo_ren
// bit 28 - pfifo_peak_enable
// bit 27 - enable_free_clk_parser_reg
// bit 26 -
// bit 25:24 - parser_src_sel (00 - fetch, 01 - aux1, 10 - aux2 11 - aux3)
// bit 23:16 - pfifo_empty_count
// bit 15:12 - max_es_write_cycle (x16x64bits) 
// 11:10 - start code width ( 00-8bits, 01-16bits, 10-24bits, 11-32bits )  
// 9:8 - pfifo data access width ( 00-8bits, 01-16bits, 10-24bits, 11-32bits )  
// 7:0 - empty room for fetch data ( max_fetch_cycle ) x64 bits
#define PARSER_CONFIG                              ((0x2965  << 2) + 0xc1100000)
// bit 24:16 -- pfifo_level
// bit 9:0 -- point to byte address
#define PFIFO_WR_PTR                               ((0x2966  << 2) + 0xc1100000)
// bit 9:0 -- point to byte address
#define PFIFO_RD_PTR                               ((0x2967  << 2) + 0xc1100000)
// bit 31:0 -- 8/16/24/32 bits data acording to pfifo_data_width
#define PFIFO_DATA                                 ((0x2968  << 2) + 0xc1100000)
// bit 31:0 -- parser search pattern 
#define PARSER_SEARCH_PATTERN                      ((0x2969  << 2) + 0xc1100000)
// bit 31:0 -- parser search mask ( 0 - disable bit match test )
#define PARSER_SEARCH_MASK                         ((0x296a  << 2) + 0xc1100000)
// bit 31:16 -- parser_int_disable_count
// bit 15:8 -- Parser interrupt enable for host cpu 
// bit 7:0 -- Parser interrupt enable for Amrisc 
#define PARSER_INT_ENABLE                          ((0x296b  << 2) + 0xc1100000)
// Bit 7 -- fetch_cmd_finished
// Bit 6:5 -- reserved
// Bit 4 -- parse finished
// Bit 3 -- discard finished
// Bit 2 -- insert zero finished
// Bit 1 -- Action Finished Except Search Start Code
// Bit 0 -- Search match interrupt (StartCode found)
// Read 7:0 int status
// Write will clear (bit based) 
#define PARSER_INT_STATUS                          ((0x296c  << 2) + 0xc1100000)
// 15    - SCR_32_READ_OUT (Read Only)
// 14    - SCR_32_data_valid
// 13    - SCR_32_data
// 12    - SCR_count_en
// 11:0  - SCR90K_DIV
#define PARSER_SCR_CTL                             ((0x296d  << 2) + 0xc1100000)
// bit 31:0 SCR value
#define PARSER_SCR                                 ((0x296e  << 2) + 0xc1100000)
// bit 31:24 -- insert_loop_number
// bit 23:21 -- 
// bit 20:16 -- insert_byte_number 
// bit 15:0 -- discard number
#define PARSER_PARAMETER                           ((0x296f  << 2) + 0xc1100000)
// bit 31:0 -- insert data // write only
// write to PARSER_CONTROL will reset the write position
// continous write to this address can write upto 16 bytes 
#define PARSER_INSERT_DATA                         ((0x2970  << 2) + 0xc1100000)
// Bit 31:24 -- Reserved Stream_ID
// Bit 23:16 -- Sub Stream_ID
// Bit 15:8  -- Audio Stream_ID
// Bit 7:0   -- Video Stream_ID
#define VAS_STREAM_ID                              ((0x2971  << 2) + 0xc1100000)
// Bit 31:0 -- VIDEO_DTS
#define VIDEO_DTS                                  ((0x2972  << 2) + 0xc1100000)
// Bit 31:0 -- VIDEO_PTS
#define VIDEO_PTS                                  ((0x2973  << 2) + 0xc1100000)
// Bit 31:0 -- VIDEO_PTS_DTS_WR_PTR
#define VIDEO_PTS_DTS_WR_PTR                       ((0x2974  << 2) + 0xc1100000)
// Bit 31:0 -- AUDIO_PTS
#define AUDIO_PTS                                  ((0x2975  << 2) + 0xc1100000)
// Bit 31:0 -- AUDIO_PTS_WR_PTR
#define AUDIO_PTS_WR_PTR                           ((0x2976  << 2) + 0xc1100000)
// bit 31:20 -- stream_es_count ( Read Only)
// bit 19 -- req_pending ( parser ddr_A_fifo ) (Read Only)
// bit 18 -- stream_es_passthrough_enable
// bit 17:16 -- stream_es_passthrough_type
// bit 15:13 -- VIDEO2 Ees_write Endian
// bit 12 -- VIDEO2 using manual read point
// bit 11:9 -- SUB Ees_write Endian 
// bit 8 -- SUB using manual read point
// bit 7:5 -- AUDIO Ees_write Endian 
// bit 4 -- AUDIO using manual read point
// bit 3:1 -- VIDEO Ees_write Endian 
// bit 0 -- VIDEO using manual read point
#define PARSER_ES_CONTROL                          ((0x2977  << 2) + 0xc1100000)
// Bit 31:0 PFIFO_MONITOR
#define PFIFO_MONITOR                              ((0x2978  << 2) + 0xc1100000)
// --------------------------------------------
// PARSER_VIDEO DDR Interface
// --------------------------------------------
// The PARSER_VIDEO start pointer into DDR memory is a 32-bit number
// The Start pointer will automatically be truncated to land on 
// an 8-byte boundary.  That is, bits [2:0] = 0;
#define PARSER_VIDEO_START_PTR                     ((0x2980  << 2) + 0xc1100000)
#define PARSER_VIDEO_END_PTR                       ((0x2981  << 2) + 0xc1100000)
// --------------------------------------------
// PARSER_VIDEO Buffer Level Manager
// --------------------------------------------
#define PARSER_VIDEO_WP                            ((0x2982  << 2) + 0xc1100000)
#define PARSER_VIDEO_RP                            ((0x2983  << 2) + 0xc1100000)
#define PARSER_VIDEO_HOLE                          ((0x2984  << 2) + 0xc1100000)
// --------------------------------------------
// PARSER_AUDIO DDR Interface
// --------------------------------------------
// The PARSER_AUDIO start pointer into DDR memory is a 32-bit number
// The Start pointer will automatically be truncated to land on 
// an 8-byte boundary.  That is, bits [2:0] = 0;
#define PARSER_AUDIO_START_PTR                     ((0x2985  << 2) + 0xc1100000)
#define PARSER_AUDIO_END_PTR                       ((0x2986  << 2) + 0xc1100000)
// --------------------------------------------
// PARSER_AUDIO Buffer Level Manager
// --------------------------------------------
#define PARSER_AUDIO_WP                            ((0x2987  << 2) + 0xc1100000)
#define PARSER_AUDIO_RP                            ((0x2988  << 2) + 0xc1100000)
#define PARSER_AUDIO_HOLE                          ((0x2989  << 2) + 0xc1100000)
// --------------------------------------------
// PARSER_SUB DDR Interface
// --------------------------------------------
// The PARSER_SUB start pointer into DDR memory is a 32-bit number
// The Start pointer will automatically be truncated to land on 
// an 8-byte boundary.  That is, bits [2:0] = 0;
#define PARSER_SUB_START_PTR                       ((0x298a  << 2) + 0xc1100000)
#define PARSER_SUB_END_PTR                         ((0x298b  << 2) + 0xc1100000)
// --------------------------------------------
// PARSER_SUB Buffer Level Manager
// --------------------------------------------
#define PARSER_SUB_WP                              ((0x298c  << 2) + 0xc1100000)
#define PARSER_SUB_RP                              ((0x298d  << 2) + 0xc1100000)
#define PARSER_SUB_HOLE                            ((0x298e  << 2) + 0xc1100000)
// Bit[31] dma_busy
// Bit[30] cur_fetch_or_es_write
// Bit[29:28] reserved
// Bit[27:24] fetch_status
// Bit[23:0] buffer_cycles_left
#define PARSER_FETCH_INFO                          ((0x298f  << 2) + 0xc1100000)
// Bit[31:28] ctl_status
// Bit[27:24] insert_byte_offset
// Bit[23:0] es_pack_left_cycle
#define PARSER_STATUS                              ((0x2990  << 2) + 0xc1100000)
// Bit [31:16] AUDIO_wrap_count
// Bit  [15:0] VIDEO_wrap_count
#define PARSER_AV_WRAP_COUNT                       ((0x2991  << 2) + 0xc1100000)
// bit[29:24] A_brst_num_parser
// bit[21:16] A_id_parser
// bit[11:0] wrrsp_count_parser
#define WRRSP_PARSER                               ((0x2992  << 2) + 0xc1100000)
// `define CSS_cmd             12'h200   // address of css command and indirect register
// `define CSS_cntl            12'h201   // css control register
// `define CSS_data            12'h202   // indirect register
// `define CSS_id1_data  	    12'h203   // ID data for the first and second bytes
// `define CSS_id2_data  	    12'h204   // ID data for the third and fourth bytes
//CPPM registers
// `define CPPM_IFIFO_CTRL		12'h210	  //CPPM input FIFO control
// `define CPPM_C2BC_KEY		12'h211	  //CPPM C2 Block Cipher Key register
// `define CPPM_C2BC_DIN		12'h212	  //CPPM C2 Block Cipher data input register
// `define CPPM_C2BC_DOUT		12'h213   //CPPM C2 Block Cipher data result register
// `define CPPM_CMD			12'h214   //CPPM command and control register
// `define CPPM_CTRL_STATUS	12'h215   //CPPM control status, mainly for debug 
// `define CPPM_IFIFO_DATA		12'h216   //CPPM input FIFO data pop port, just for debug 
// --------------------------------------------
// PARSER_VIDEO2 DDR Interface
// --------------------------------------------
// The PARSER_VIDEO2 start pointer into DDR memory is a 32-bit number
// The Start pointer will automatically be truncated to land on 
// an 8-byte boundary.  That is, bits [2:0] = 0;
#define PARSER_VIDEO2_START_PTR                    ((0x2993  << 2) + 0xc1100000)
#define PARSER_VIDEO2_END_PTR                      ((0x2994  << 2) + 0xc1100000)
// --------------------------------------------
// PARSER_VIDEO2 Buffer Level Manager
// --------------------------------------------
#define PARSER_VIDEO2_WP                           ((0x2995  << 2) + 0xc1100000)
#define PARSER_VIDEO2_RP                           ((0x2996  << 2) + 0xc1100000)
#define PARSER_VIDEO2_HOLE                         ((0x2997  << 2) + 0xc1100000)
// Bit [31:16] AUDIO_wrap_count
// Bit  [15:0] VIDEO2_wrap_count
#define PARSER_AV2_WRAP_COUNT                      ((0x2998  << 2) + 0xc1100000)
// DDR registers
//`define USE_DDR2
//========================================================================
//  DVIN Registers				    (12'h2e0 - 12'h2ef)
//
//========================================================================
// -----------------------------------------------
// CBUS_BASE:  DVIN_CBUS_BASE = 0x12
// -----------------------------------------------
// Bit 31:12 Rsrv
// Bit 11:10 RW, vs_hs_tim_ctrl: Controls which edge of HS/VS the active pixel/line is related:
//                               bit[0]=0: start of active pixel is counted from the rising edge of HS;
//                               bit[0]=1: start of active pixel is counted from the falling edge of HS;
//                               bit[1]=0: start of active line is counted from the rising edge of VS;
//                               bit[1]=1: start of active line is counted from the falling edge of VS.
// Bit     9 RW, sample_clk_neg: 1=invert input dvin_clk
// Bit  8: 7 RW, mode_422to444: 0=No convertion; 1=Rsrv; 2=Convert 422 to 444, use previous C value; 3=Convert 422 to 444, use average C value.
// Bit  6: 5 RW, de_mode: 0x=ignore input DE signal, use internal detection to to determine active pixel;
//                        10=during active pixel, if DE is low, replace input data with the last good data before DE goes low;
//                        11=Active pixel is determined by DE, no internal detection.
// Bit     4 RW, ext_field_sel: 1=Select external input Field, 0=Use internal detected Field.
// Bit     3 RW, field_pol_inv: set to 1 if input Field is low active and ext_field_sel=1
// Bit     2 RW, de_pol_inv: set to 1 if input DE is low active
// Bit     1 RW, vs_pol_inv: set to 1 if input VS is low active
// Bit     0 RW, hs_pol_inv: set to 1 if input HS is low active
#define DVIN_FRONT_END_CTRL                        ((0x12e0  << 2) + 0xc1100000)
// Bit 31:28 Reserved
// Bit 27:16 RW, hs_lead_vs_odd_max: Criteria for HW detecting odd/even Field internally: max clock cycles allowed for HS
//                                   active edge to lead before VS active edge, in odd field. Failing it the field is even.
// Bit 15:12 Reserved
// Bit 11: 0 RW, hs_lead_vs_odd_min: Criteria for HW detecting odd/even Field internally -- min clock cycles allowed for HS
//                                   active edge to lead before VS active edge, in odd field. Failing it the field is even.
#define DVIN_HS_LEAD_VS_ODD                        ((0x12e1  << 2) + 0xc1100000)
// Bit 31:28 Reserved
// Bit 27:16 RW, active_start_pix_fo
// Bit 15:12 Reserved
// Bit 11: 0 RW, active_start_pix_fe
#define DVIN_ACTIVE_START_PIX                      ((0x12e2  << 2) + 0xc1100000)
// Bit 31:28 Reserved
// Bit 27:16 RW, active_start_line_fo
// Bit 15:12 Reserved
// Bit 11: 0 RW, active_start_line_fe
#define DVIN_ACTIVE_START_LINE                     ((0x12e3  << 2) + 0xc1100000)
// Bit 31:28 Reserved
// Bit 27:16 RW, field_height_m1
// Bit 15:12 Reserved
// Bit 11: 0 RW, line_width_m1
#define DVIN_DISPLAY_SIZE                          ((0x12e4  << 2) + 0xc1100000)
// Bit    31 Rsrv
// Bit    30 R,  vs_in_polarity: 0=active high; 1=active low.
// Bit    29 R,  hs_in_polarity: 0=active high; 1=active low.
// Bit    28 R,  field_odd
// Bit 27:16 R,  hs_lead_vs_cnt
// Bit 15: 4 Rsrv
// Bit  3: 1 RW, data_comp_map: Re-map input data to form YCbCr.
//                              0=YCbCr is {[29:20], [19:10], [ 9: 0]};
//                              1=YCbCr is {[29:20], [ 9: 0], [19:10]};
//                              2=YCbCr is {[ 9: 0], [29:20], [19:10]};
//                              3=YCbCr is {[19:10], [29:20], [ 9: 0]};
//                              4=YCbCr is {[19:10], [ 9: 0], [29:20]};
//                              5=YCbCr is {[ 9: 0], [19:10], [29:20]};
//                              6,7=Rsrv
// Bit     0 RW, dvin_enable
#define DVIN_CTRL_STAT                             ((0x12e5  << 2) + 0xc1100000)
//========================================================================
//  DOS registers				    APB allocation from 32'hd0050000
//
//========================================================================
//=======================================================================
// XIF module
// `include "xregs.h"
    #define X_INT_ADR           0x400
    #define GPIO_ADR            0x401
    #define GPIO_ADR_H8         0x402 
    #define WFIFO_DEPTH         8          
    #define WFIFO_PointerWidth  3
    #define WFIFO_WORDSIZE      32
// MAC module
// move them to cpu domain.
//`define CLR_ACC_MAC         12'h410   
//`define CLR_ACC_MAC2        12'h411   
//`define ACC_0               12'h412
//`define ACC_1               12'h413
//`define ACC_2               12'h414
//`define ACC_3               12'h415
//========================================================================
//  Audio Interface				    (12'h500 - 12'h5ff)
//
//========================================================================
//
// Reading file:  aregs.h
//
//========================================================================
//  Audio Interface                                 (8'h00 - 8'hff)
//  Modified : Xuyun Chen Jan 2001
//========================================================================
// Number of bytes expected per NON-PCM frame, including the header.
// 16 bits.  
// -----------------------------------------------
// CBUS_BASE:  AIU_CBUS_BASE = 0x15
// -----------------------------------------------
#define AIU_958_BPF                                ((0x1500  << 2) + 0xc1100000)
// Value of burst_info used in IEC958 preamble for a NON-PCM frame. See
// ATSC AC-3 spec Annex B. 16 bits.
#define AIU_958_BRST                               ((0x1501  << 2) + 0xc1100000)
// Value of length_code used in IEC958 preamble for an NON-PCM frame. See
// ATSC AC-3 spec Annex B. 16 bits.
#define AIU_958_LENGTH                             ((0x1502  << 2) + 0xc1100000)
// How many subframes to padd around the NON-PCM frame. This will 
// be set to 'd3072 if it is a AC-3 audio stream.
// 16 bits
#define AIU_958_PADDSIZE                           ((0x1503  << 2) + 0xc1100000)
// 16'd3072
// Misc. control settings for IEC958 interface
// Bit 15:14 pcm_sample_ctl, 00-pcm_no_sample, 01-pcm_sample_up, 10-pcm_sample_down, 11-pcm_sample_down_drop
// Bit 13: if true, force each audio data to left or right according to the bit attached with the audio data
//         This bit should be used with Register AIU_958_force_left(0x505) together
// Bit 12: if true, the U(user data) is from the stream otherwise it is filled by 
//                   zero while encoding iec958 frame
// Bit 11   : if true big endian(highword,lowword) otherwise little endian(lowword,highword)
//            for 32bit mode 
// Bit 10:8 : shift number for 32 bit mode
// Bit 7  : 32 bit mode turn on while This bit is true and Bit 1 is true 
// Bit 6:5 : Specifies output alignment for 16 bit pcm data.
//          00 : dout = {8'b0, din};
//          01 : dout = {4'b0, din, 4'b0};
//          10 : dout = {      din, 8'b0};
// Bit 4  : True if data should be sent out MSB first. LSB first is the
//          default in the spec.
// Bit 3  : True if msb should be extended (only used with 16 bit pcm data.)
// Bit 2  : True if msb of PCM data should be inverted.
// Bit 1  : True if PCM data is 16 bits wide. False if 24 bit or 32bit mode.
// Bit 0  : True if source data is non-PCM data. False if it is PCM data.
#define AIU_958_MISC                               ((0x1504  << 2) + 0xc1100000)
// 14'b0_0_0_000_0_0000001
// A write to this register specifies that the next pcm sample sent out
// of the iec958 interface should go into the _left_ channel.
#define AIU_958_FORCE_LEFT                         ((0x1505  << 2) + 0xc1100000)
//Read Only
//bit 6:0  how many data discarded in the last dma after one frame data finish transfering to AIU 
// should used together with register AIU_958_dcu_ff_ctrl
#define AIU_958_DISCARD_NUM                        ((0x1506  << 2) + 0xc1100000)
//bit 15:8  : A read from this register indicates the IEC958 FIFO count value 
//bit 7 :  ai_958_req_size if ture, set to 8 bits interface, used to handle odd frame continous read  
//bit 6 :  continue seeking and dont discard the rest data in one dma after frame end
//bit 5 :  if true, byte by byte seeking, otherwise word by word seeking
//bit 4 :  if true, the function for sync head seeking is enabled
//bit 3:2 :	IEC958 interrupt mode
// There are two conditions to generate interrupt. The First condition is that one frame data
// have been finished writing into FIFO. The second condition is at least some data of the current 
// frame have been read out(refer to Register AIU_958_ffrdout_thd)
//			00: interrupt is not generated
//			10:	interrupt is generated if the first condition is true 
//			01:	interrupt is generated if the second condition is true 
//			11:	interrupt is generated if both of the conditions are true 
//bit 1: fifo auto disable, High means after one frame data put into the FIFO, the FIFO
//					will automatically disabled
//bit 0: fifo enable
#define AIU_958_DCU_FF_CTRL                        ((0x1507  << 2) + 0xc1100000)
// 'b0_0_1_11_1_0
// channel status registers for Left channel
// chstat_l0[15:0] contains bits 15:0 of the channel status word. Note
// that bit zero of the channel status word is sent out first.
// chstat_l1[15:0] contains bits 31:16 of the channel status word.
#define AIU_958_CHSTAT_L0                          ((0x1508  << 2) + 0xc1100000)
#define AIU_958_CHSTAT_L1                          ((0x1509  << 2) + 0xc1100000)
// Control register for IEC958 interface
// Bit 9:8 what to do if there is a fifo underrun
//         00 => insert 24'h000000
//         01 => insert mute constant as defined below
//         10 => repeat last l/r samples
// Bit 7:5 mute constant
//         000 => 24'h000000
//         001 => 24'h800000
//         010 => 24'h080000
//         011 => 24'h008000
//         100 => 24'h000001
//         101 => 24'h000010
//         110 => 24'h000100
// Bit 4   mute left speaker
// Bit 3   mute right speaker
// Bit 2:1 swap channels
//         00 : L R => L R
//         01 : L R => L L
//         10 : L R => R R
//         11 : L R => R L
// Bit 0   Set this bit to hold iec958 interface after the current
//         subframe has been completely transmitted.
#define AIU_958_CTRL                               ((0x150a  << 2) + 0xc1100000)
// 10'b00_000_00_00_0
// A write operation to this register will cause one of the output samples
// to be repeated. This can be used to switch the left and the right
// channels.
#define AIU_958_RPT                                ((0x150b  << 2) + 0xc1100000)
// Channel swap and mute control register.
// Bit 15: Mute extra left channel
// Bit 14: Mute extra right channel
// Bit 13: Mute center
// Bit 12: Mute subwoofer
// Bit 11: Mute surround left
// Bit 10: Mute surround right
// Bit  9: Mute left
// Bit  8: Mute right
// Bit 7:6 Channel swap for xtra dac
// Bit 5:4 Channel swap for sub/center dac
// Bit 3:2 Channel swap for surround dac
// Bit 1:0 Channel swap for main l/r dac
// Channel swap possibilities:
// 00 : L R => L R
// 01 : L R => L L
// 10 : L R => R R
// 11 : L R => R L
#define AIU_I2S_MUTE_SWAP                          ((0x150c  << 2) + 0xc1100000)
// 16'b0
// Bit 0 : 0=> single two channel stream
//         1=> four two channel streams
#define AIU_I2S_SOURCE_DESC                        ((0x150d  << 2) + 0xc1100000)
// Median filter control register
// Bit 1:  0=> data is offset binary
//         1=> data is signed
// Bit 0:  enable median filter
#define AIU_I2S_MED_CTRL                           ((0x150e  << 2) + 0xc1100000)
// 2'b10
// Median filter threshold constant
// 16 bits
#define AIU_I2S_MED_THRESH                         ((0x150f  << 2) + 0xc1100000)
// 16'h8000
// Describes dac's connected to I2S interface
// Bit 7:  sign extend sample before downshift.
// Bit 6:4 payload downshift constant
// Bit 3:  mute constant
//         0 => 'h0000000
//         1 => 'h800000
// Bit 2:  send msb first
// Bit 1:0 Size of payload
//         Note that this parameter used to be called "size of dacs"
//         It is now called the payload size since a 24 bit payload can
//         actually be connected to any size of dac. The dac will simply
//         disregard the extra bits.
//         00 => 16 bit, alrclk = aoclk/32 
//         01 => 20 bit, alrclk = aoclk/40 
//         10 => 24 bit, alrclk = aoclk/48 
//		   11 => 24 bit, but alrclk = aoclk/64 
#define AIU_I2S_DAC_CFG                            ((0x1510  << 2) + 0xc1100000)
// 8'b0_000_1_1_10
// A write to this register will cause the interface to repeat the current
// sample. Can be used to regain synchronization.
// A read from this register indicates that the next sample to be sent
// out of the interface should go into the _left_ channel of the dac.
#define AIU_I2S_SYNC                               ((0x1511  << 2) + 0xc1100000)
// Misc regs
// Bit 4 if true, force each audio data to left or right according to the bit attached with the audio data
//         This bit should be used with Register AIU_i2s_sync(0x511) together
// Bit 3:  Same Audio source for IEC958 and I2s stream 0, both from i2s buffer 
// Bit 2:  Set this bit to put i2s interface in hold mode
// Bit 1:0 How to handle underruns
//         00 => send zeros
//         01 => send 'h800000
//         10 => repeat last samples
#define AIU_I2S_MISC                               ((0x1512  << 2) + 0xc1100000)
// 5'b0
// Bit 7:0 Audio output config.
//			2 bits for each dac, 7:6 for dac3, 5:4 for dac2,
//								 3:2 for dac1, 1:0 for dac0
//			For each 2bits: 00: connect channel0-1 to the dac
//							01: connect channel2-3 to the dac
//							10: connect channel4-5 to the dac
//							11: connect channel6-7 to the dac
#define AIU_I2S_OUT_CFG                            ((0x1513  << 2) + 0xc1100000)
// 8'b0_000000_0
#define AIU_I2S_FF_CTRL                            ((0x1514  << 2) + 0xc1100000)
// A write to this register resets the AIU
//Bit 3 reset slow domain iec958
//Bit 2 soft reset iec958 fast domain
//Bit 1 reset slow domain i2s
//Bit 0 soft reset i2s fast domain
#define AIU_RST_SOFT                               ((0x1515  << 2) + 0xc1100000)
// Clock generation control register
// Bit 15: enable_ddr_arb, set low to reset
// Bit 14:13 parser_A_addr_sel  00-A_addr_aififo2, 01-A_addr_iec958, 10-A_addr_aififo, 11-A_addr_i2s
// Bit 12: 958 divisor more, if true, divided by 2, 4, 6, 8
// Bit 11: amclk output divisor
//			0 => dont divide
//			1 => divide by 2		
// Bit 10: clock source selection
//        0 => aiclk from pin
//        1 => ai_pll_clk from pll
// Bit 9:8 alrclk skew
//         00 => alrclk transitions at the same time msb is sent
//         01 => alrclk transitions on the cycle before msb is sent
//         10 => alrclk transitions on the cycle after msb is sent
// Bit 7: invert alrclk
// Bit 6: invert aoclk
// Bit 5:4 958 divisor
//        00 => divide by 1
//        01 => divide by 2
//		  10 => divide by 3
//		  11 => divide by 4
// Bit 3:2 i2s divisor. NOTE: this value is ignored if AIU_clk_ctrl_more[5:0] != 0 
//         00 => divide by 1
//         01 => divide by 2
//         10 => divide by 4
//         11 => divide by 8
// Bit 1: enable 958 divider
// Bit 0: enable i2s divider
#define AIU_CLK_CTRL                               ((0x1516  << 2) + 0xc1100000)
// 13'b0_0_1_01_1_1_10_11_0_0
// Misc settings that determine the type of adc that is
// connected to the AIU. Reverb mode is deleted.
// Bit 12:  selects adc input
// Bit 11:10 adc size
//           00 => 16 bits
//           01 => 18 bits
//           10 => 20 bits
//           11 => 24 bits
// Bit 9:8   adc l/r swap mode
//           00 => stereo
//           01 => send the right adc input to both l and r speakers
//           01 => send the left adc input to both l and r speakers
//           11 => sum the left and right inputs and forward to
//                both speakers
// Bit 7:5 adata/lrclk skew mode
// Bit 4   1=>invert the adc's lrclk (This is the lrclk going _out_
//         of the chip.
// Bit 3   1=>Latch the data on the positive edge of the _internal_
//         aoclk.
// Bit 2   1=>adc data is in signed 2's complement mode
#define AIU_MIX_ADCCFG                             ((0x1517  << 2) + 0xc1100000)
// 12'b01_00_001_1_0_1_00
// Control register that can be changed dynamically. These control
// signals are synchronized internally.
// Bit 12:  if true, toggle each mixed audio data to left or right channel
// Bit 11:  abuf din left selection, if true, select bit 24 of the data from abuf
//		    otherwise select bit 25 of the data from abuf
// Bit 10:9  mix sync select, when music, mic and abuf are mixed togather, the main
//			 sync source can be selected
//     00: not sync source
//	   01: music data is the main sync source
//	   10: abuf input data is the main sync source
//	   11: music and abuf togather as the sync source
// Bit 8:  0=> data from abuf is offset binary
//         1=> data from abuf is signed
// Bit 7:6 the source for data from aiu to abuf 
//           00 => mic
//           01 => mic saled + abuf scaled 
//           10 => mic scaled + abuf scaled + music scaled
//			 11 => music
// Bit 5   channel from aiu to abuf is on
// Bit 4   channel from abuf to aiu is on
// Bit 3   mic is on
// Bit 2   music is on
// Bit 1   if true the mixed data are outputed to i2s dac channel,
//			otherwise the mixed data are outputed to IEC958 output 
// Bit 0   if true music source for mixing is from i2s buffer, 
//			otherwise music source is from iec958 buffer
#define AIU_MIX_CTRL                               ((0x1518  << 2) + 0xc1100000)
// 11'b01_1_01_0_0_0_1_1_1
// Bit    15 invert_audin_sclk.
// Bit    14 enable_adc_sclk.
// Bit 13: 8 divisor_adc_sclk.
// Bit     7 invert_acodec_adc_sclk.
// Bit     6 hdmitx_sel_aoclkx2: 0=Select cts_clk_i958 as AIU clk to hdmi_tx_audio_master_clk; 1=Select cts_aoclkx2_int as AIU clk to hdmi_tx_audio_master_clk;
// Bit  5: 0 More control on i2s divisor. For backward compatiblity, this value is ignored if is 0,
//           if non-zero, it takes effect over AIU_clk_ctrl[3:2].
//           0=i2s divisor will use the old value in AIU_clk_ctrl[3:2] (divide by 1/2/4/8)
//           1=divide by 2;
//           2=divide by 3;
//           3=divide by 4;
//           ... and so on ...
//           63=divide by 64.
#define AIU_CLK_CTRL_MORE                          ((0x1519  << 2) + 0xc1100000)
// A read from this register pops 16 bits of data off the 958
// fifo. A write has no effect.
#define AIU_958_POP                                ((0x151a  << 2) + 0xc1100000)
//gain register for mixing
// for each gain, 
//			 00000: x 0
//			 00001: x 1
//			 00010: x 2
//           00011: x 3
//			 00100: x 4
//			 00101: x 5
//			 00110: x 6
//			......
//           01110: x14
//           01111: x15
//           10000: x 0
//           10001: x 1/16
//           10010: x 2/16
//           10011: x 3/16
//           10100: x 4/16
//			......
//           11110: x 14/16
//           11111: x 15/16
//Bit 14:10 mic gain
//Bit 9:5 	abuf gain
//Bit 4:0 music gain
#define AIU_MIX_GAIN                               ((0x151b  << 2) + 0xc1100000)
// 15'b00001_00001_00001
//sync head seeking is supported. The  maxinium length of sync head is
//48-bit-wide.(in byte by byte seeking mode, the maximium is 44-bit-wide).
//It is consisted of 3 words (synword1_synword2_syncword3).
//You can configure the sync head pattern by using sync mask(mask1_mask2_mask3).  
//For example. AC-3 sync head is a 16-bit word(0b77), so syncword1 is set as 0b77, 
//mask1 is 0000(not set), mask2 and mask3 is all masked.
#define AIU_958_SYNWORD1                           ((0x151c  << 2) + 0xc1100000)
//16'h0b77  //ac-3 sync head
#define AIU_958_SYNWORD2                           ((0x151d  << 2) + 0xc1100000)
//16'h0000  
#define AIU_958_SYNWORD3                           ((0x151e  << 2) + 0xc1100000)
//16'h0000
#define AIU_958_SYNWORD1_MASK                      ((0x151f  << 2) + 0xc1100000)
//16'h0000 //16-bit ac-3 sync_head
#define AIU_958_SYNWORD2_MASK                      ((0x1520  << 2) + 0xc1100000)
//16'hffff
#define AIU_958_SYNWORD3_MASK                      ((0x1521  << 2) + 0xc1100000)
//16'hffff
//fifo read-out threshold, one condition to generate interrupt is met after fifo readout counter
//reach this value in a frame, please refer to register AIU_958_dcu_ff_ctrl
#define AIU_958_FFRDOUT_THD                        ((0x1522  << 2) + 0xc1100000)
//'h0004
//For pause burst sequence adding, one pause burst sequence is consist of a serious
// pause burst.
//This register defines the length of each pause burst in a pause burst sequence. The size of the
//preamble(Pa, Pb, Pc, Pd) is not counted, but the size of stuff data is counted.
#define AIU_958_LENGTH_PER_PAUSE                   ((0x1523  << 2) + 0xc1100000)
//'h0000
//This reigster defines the number of pause burst in a pause burst sequence.
//Bit 15  if true, one pause burst sequence will be added 
//Bit 14:0 the number of pause burst in a pause burst sequence
#define AIU_958_PAUSE_NUM                          ((0x1524  << 2) + 0xc1100000)
//'h0000
//The first 16-bit in the payload of pause burst sequence (gap_length)
#define AIU_958_PAUSE_PAYLOAD                      ((0x1525  << 2) + 0xc1100000)
//'h0000
//For auto pause function, when enabled, pause burst sequence will be automatically added if the data in
// 958 fifo is less than auto_pause threshold and if fifo is disabled.
//Bit 15   if true, auto pause function enable
//Bit 14   pause pack option, just for debugging and adding one option
//Bit 7:0  auto_pause threshold
#define AIU_958_AUTO_PAUSE                         ((0x1526  << 2) + 0xc1100000)
//'h0000
//pause burst sequence payload length( = AIU_958_pause_num * AIU_958_length_per_pause)
#define AIU_958_PAUSE_PD_LENGTH                    ((0x1527  << 2) + 0xc1100000)
//'h0000
// Bit 15:12 Rsrv.
// Bit 11: 0 dac_lrclk_div: Default is 48-1=47, which means lrclk is sclk divide by 48.
#define AIU_CODEC_DAC_LRCLK_CTRL                   ((0x1528  << 2) + 0xc1100000)
//'h002f
// Bit 15:14 Rsrv.
// Bit    13 inv_audin_lrclk: whether to invert lrclk before output to Audin
// Bit    12 inv_acodec_adc_lrclk: whether to invert lrclk before output to Audio Codec
// Bit 11: 0 adc_lrclk_div: Default is 48-1=47, which means lrclk is sclk divide by 48.
#define AIU_CODEC_ADC_LRCLK_CTRL                   ((0x1529  << 2) + 0xc1100000)
//'h002f
// Bit 15:6 Rsrv.
// Bit  5: 4 hdmi_data_sel: 00=output 0, disable hdmi data; 01=Select pcm data; 10=Select AIU I2S data; 11=Not allowed.
// Bit  3: 2 Rsrv.
// Bit  1: 0 hdmi_clk_sel: 00=Disable output hdmi clock; 01=Select pcm clock; 10=Select AIU clk; 11=Not allowed.
#define AIU_HDMI_CLK_DATA_CTRL                     ((0x152a  << 2) + 0xc1100000)
//'h0000
// Bit 15:6 Rsrv.
// Bit  5: 4 acodec_data_sel: 00=output 0, disable acodec_sdin; 01=Select pcm data; 10=Select AIU I2S data; 11=Not allowed.
// Bit  3: 2 Rsrv.
// Bit  1: 0 acodec_clk_sel: 00=Disable output acodec_sclk; 01=Select pcm clock; 10=Select AIU aoclk; 11=Not allowed.
#define AIU_CODEC_CLK_DATA_CTRL                    ((0x152b  << 2) + 0xc1100000)
//'h0000
// channel status registers for right channel
// chstat_r0[15:0] contains bits 15:0 of the channel status word. Note
// that bit zero of the channel status word is sent out first.
// chstat_r1[15:0] contains bits 31:16 of the channel status word.
#define AIU_958_CHSTAT_R0                          ((0x1530  << 2) + 0xc1100000)
#define AIU_958_CHSTAT_R1                          ((0x1531  << 2) + 0xc1100000)
//Bit 1 	if true, turn on Digital output Valid control
//Bit 0		0: output 0, 1: output 1 to the valid bit in audio digital output when Bit 1 is true
#define AIU_958_VALID_CTRL                         ((0x1532  << 2) + 0xc1100000)
//-----------------------------------------------------------------------------
// Audio Amplifier controls
//-----------------------------------------------------------------------------
#define AIU_AUDIO_AMP_REG0                         ((0x153c  << 2) + 0xc1100000)
#define AIU_AUDIO_AMP_REG1                         ((0x153d  << 2) + 0xc1100000)
#define AIU_AUDIO_AMP_REG2                         ((0x153e  << 2) + 0xc1100000)
#define AIU_AUDIO_AMP_REG3                         ((0x153f  << 2) + 0xc1100000)
//-----------------------------------------------------------------------------
//add for AIFIFO2 channel
//-----------------------------------------------------------------------------
//Bit 3 	CRC pop aififo2 enable
//Bit 2		writing to this bit to 1 causes CRC module reset
//Bit 1		unused
//Bit 0		writing to this bit to 1 causes AIFIFO2 soft reset
#define AIU_AIFIFO2_CTRL                           ((0x1540  << 2) + 0xc1100000)
//'h0000
//AIFIFO2 status register
//Bit 4:0		//how many bits left in the first pop register
#define AIU_AIFIFO2_STATUS                         ((0x1541  << 2) + 0xc1100000)
//Same fucntion as the AIGBIT of AIFIFO in CDROM module
//write to this register how many bits wanna pop, 
//and reading this register gets the corresponding bits data
#define AIU_AIFIFO2_GBIT                           ((0x1542  << 2) + 0xc1100000)
//Same function as the AICLB of AIFIFO in CDROM module
//return the leading zeros by reading this registers
#define AIU_AIFIFO2_CLB                            ((0x1543  << 2) + 0xc1100000)
//CRC control register, read/write
//Bit 0		CRC caculation start
//Bit 1		CRC core soft reset
//Bit 2		CRC input register clear
//Bit 3		CRC pop data from FIFO enable
//Bit 13:8	CRC polynomial equation order, between 1 to 32
#define AIU_CRC_CTRL                               ((0x1544  << 2) + 0xc1100000)
//16'h1000
//CRC status register, read only
//Bit 7:4	CRC internal shift register bit select, just for debug purpose
//Bit 3		CRC internal shift register data valid, just for debug purpose
//Bit 2		CRC input register data valid
//Bit 1		CRC result, 1: CRC not correct, 0: CRC correct
//Bit 0		CRC state,  1: CRC busy, 0: CRC idle
#define AIU_CRC_STATUS                             ((0x1545  << 2) + 0xc1100000)
//CRC internal shift register, read only, for debug purpose
#define AIU_CRC_SHIFT_REG                          ((0x1546  << 2) + 0xc1100000)
//CRC data input register, read/write
#define AIU_CRC_IREG                               ((0x1547  << 2) + 0xc1100000)
//16'h0000
//CRC calculation register high-bit part [31:16], read/write
#define AIU_CRC_CAL_REG1                           ((0x1548  << 2) + 0xc1100000)
//CRC calculation register low-bit part [15:0], read/write
#define AIU_CRC_CAL_REG0                           ((0x1549  << 2) + 0xc1100000)
//32'h00000000
//CRC polynomial coefficient high-bit part [31:16], read/write
#define AIU_CRC_POLY_COEF1                         ((0x154a  << 2) + 0xc1100000)
//CRC polynomial coefficient low-bit part [15:0], read/write
#define AIU_CRC_POLY_COEF0                         ((0x154b  << 2) + 0xc1100000)
//32'h80050000			default CRC-16
//CRC frame size, high-bit part [19:16], read/write
#define AIU_CRC_BIT_SIZE1                          ((0x154c  << 2) + 0xc1100000)
//CRC frame size, low-bit part [15:0],	 read/write
#define AIU_CRC_BIT_SIZE0                          ((0x154d  << 2) + 0xc1100000)
//20'hfffff
//how many bits have been processed right now in the current frame, read only
//high-bit part [19:16]
#define AIU_CRC_BIT_CNT1                           ((0x154e  << 2) + 0xc1100000)
//low-bit part [15:0]
#define AIU_CRC_BIT_CNT0                           ((0x154f  << 2) + 0xc1100000)
// -------------------------------------
// AMCLK Measurement
// -------------------------------------
// Used to measure the amclk frequency
#define AIU_AMCLK_GATE_HI                          ((0x1550  << 2) + 0xc1100000)
#define AIU_AMCLK_GATE_LO                          ((0x1551  << 2) + 0xc1100000)
#define AIU_AMCLK_MSR                              ((0x1552  << 2) + 0xc1100000)
#define AIU_AUDAC_CTRL0                            ((0x1553  << 2) + 0xc1100000)
// -------------------------------------
// Super Simple Delta Sigma DAC
// -------------------------------------
// bit 15   1 = invert the clock to the analog filter
// bit 14   1 = digital mute
// bit 13   1 = enable analog mute (in the analog block)
// bit 12   1 = enable Right channel 3 in the analog block
// bit 11   1 = enable Left  channel 3 in the analog block
// bit 10   1 = enable Right channel 2 in the analog block
// bit  9   1 = enable Left  channel 2 in the analog block
// bit  8   1 = enable Right channel 1 in the analog block
// bit  7   1 = enable Left  channel 1 in the analog block
// bit  6   1 = enable Right channel 0 in the analog block
// bit  5   1 = enable Left  channel 0 in the analog block
// bit  4:  bit select for serial input data
// bit  3:  invert alrclk used by the delta-sigma DAC
// bit  2:  1 = use serial I2S data.  0 = use parallel audio data
// bits 1:0 Which data to send to the delta-sigma DAC
//              11 = use channel 3 data
//              10 = use channel 2 data
//              01 = use channel 1 data
//              00 = use channel 0 data
#define AIU_DELTA_SIGMA0                           ((0x1555  << 2) + 0xc1100000)
// Delta Sigma MUTE Value
#define AIU_DELTA_SIGMA1                           ((0x1556  << 2) + 0xc1100000)
// Additional Audio filter controls
#define AIU_DELTA_SIGMA2                           ((0x1557  << 2) + 0xc1100000)
//Bit 14, left channel Delta Sigma modulator soft reset
//Bit 13, right channel Delta Sigma modulator soft reset
//Bit 12, left channel Delta Sigma modulator internal state clear enable when it is unstable
//Bit 11, right channel Delta Sigma modulator internal state clear enable when it is unstable
//Bit 10, left channel Delta Sigma detect unstable state enable
//Bit  9, right channel Delta Sigma detect unstable state enable
//Bit  8, dither high pass filter enable in the Delta Sigma loop
//Bit 7:6, reserved
//Bit 5:0, Delta Sigma input data gain  0/32 ~ 63/32
//default: 16'h3
#define AIU_DELTA_SIGMA3                           ((0x1558  << 2) + 0xc1100000)
//15:8, Added Delta Sigma DC level, range:+-1/2, minimium: +-1/128 (assume max is -1 ~ +1)
//7:0, max same sequence number, used for unstable detection
//default: 16'h0
#define AIU_DELTA_SIGMA4                           ((0x1559  << 2) + 0xc1100000)
//Bit 15:8, square wave divide num
//Bit 7:0, square wave amplitude, -1/4 ~ 1/4, minimium: +-1/1024
//default: 16'h0
#define AIU_DELTA_SIGMA5                           ((0x155a  << 2) + 0xc1100000)
//Bit 11:8, loop dither amplitude2, 0/32 ~ 15/32
//Bit 7:4,  loop dither amplitude1, 0/32 ~ 15/32
//Bit 3:0,  loop dither amplitude0, 0/32 ~ 15/32
//default: 16'h0
#define AIU_DELTA_SIGMA6                           ((0x155b  << 2) + 0xc1100000)
//Bit 15:8, loop dithering threshold1   0, 1/512, 2/512 ... 1/2
//Bit 7:0,  loop dithering threshold0   0, 1/512, 2/512 ... 1/2
//default: 16'h0
#define AIU_DELTA_SIGMA7                           ((0x155c  << 2) + 0xc1100000)
//read only
//Bit 15:8  left channel Delta Sigma clear counter number, how many times Delta Sigma has been reseted
//          It will saturate to 255, if more than 255 time
//Bit 7:0   left channel max same sequence number
#define AIU_DELTA_SIGMA_LCNTS                      ((0x155d  << 2) + 0xc1100000)
//read only
//Bit 15:8  right channel Delta Sigma clear counter number, how many times Delta Sigma has been reseted
//          It will saturate to 255, if more than 255 time
//Bit 7:0   right channel max same sequence number
#define AIU_DELTA_SIGMA_RCNTS                      ((0x155e  << 2) + 0xc1100000)
// --------------------------------------------
// I2S DDR Interface
// --------------------------------------------
// The I2S start pointer into DDR memory is a 32-bit number
#define AIU_MEM_I2S_START_PTR                      ((0x1560  << 2) + 0xc1100000)
#define AIU_MEM_I2S_RD_PTR                         ((0x1561  << 2) + 0xc1100000)
#define AIU_MEM_I2S_END_PTR                        ((0x1562  << 2) + 0xc1100000)
// There are two masks that control how data is read:
// [31:16] IRQ block.
// [15:8] chan_mem_mask.  Each bit indicates which channels exist in memory
// [7:0]  chan_rd_mask.   Each bit indicates which channels are READ from memory
#define AIU_MEM_I2S_MASKS                          ((0x1563  << 2) + 0xc1100000)
// I2S FIFO Control
// bits [11:10] Select which hardware pointer to use to control the buffer
//              level:
//                  00 = parser 
//                  01 = audin_fifo0_wrpt 
//                  1x = audin_fifo1_wrpt 
// bit  [9]     Use level control: 1 = use buffer level control
// bit  [8]     Read Only.  This bit is 1 when there is data available for reading
// bit  [7]     Read only.  This bit will be high when we're fetching data from the DDR memory
//              To reset this module, set cntl_enable = 0, and then wait for busy = 0. 
//              After that you can pulse cntl_init to start over
// bit  [6]     cntl_mode_16bit:Set to 1 for 16 bit storage format in DDR
// bits [5:3]   endian:  see $lib/rtl/ddr_endian.v
// bit  [2]     cntl_empty_en   Set to 1 to enable reading data from the FIFO
// bit  [1]     cntl_fill_en    Set to 1 to enable reading data from DDR memory
// bit  [0]     cntl_init:      After setting the read pointers, sizes, channel masks
//                              and read masks, set this bit to 1 and then to 0
#define AIU_MEM_I2S_CONTROL                        ((0x1564  << 2) + 0xc1100000)
// --------------------------------------------
// IEC958 DDR Interface
// --------------------------------------------
// The IEC958 start pointer into DDR memory is a 32-bit number
#define AIU_MEM_IEC958_START_PTR                   ((0x1565  << 2) + 0xc1100000)
#define AIU_MEM_IEC958_RD_PTR                      ((0x1566  << 2) + 0xc1100000)
#define AIU_MEM_IEC958_END_PTR                     ((0x1567  << 2) + 0xc1100000)
// There are two masks that control how data is read:
// [15:8] chan_mem_mask.  Each bit indicates which channels exist in memory
// [7:0]  chan_rd_mask.   Each bit indicates which channels are READ from memory
#define AIU_MEM_IEC958_MASKS                       ((0x1568  << 2) + 0xc1100000)
// IEC958 FIFO Control
// bit  [31]    A_urgent
// bit  [30]    ch_always_8
// bit  [29:24] rdata_rd_base_begin ( used for select from different channel ) 
// bit  [23:14] reserved
// bit  [13]    cntl_sim_en
// bit  [12]    cntl_use_level
// bit  [11]    Read only.      This bit will be set to 1 when there is data in the FIFO to process
// bit  [10]    Read only.  This bit will be high when we're fetching data from the DDR memory
//              To reset this module, set cntl_enable = 0, and then wait for busy = 0. 
//              After that you can pulse cntl_init to start over
// bit  [9]     cntl_endian_jic Just in case endian.  last minute byte swap of the data out of
//                              the FIFO to the rest of the IEC958 logic
// bit  [8]     mode_raw:       Set this bit to 1 to tell the IEC958 FIFO to read
//                              and process data linearly for raw data.  
// bit  [7]     cntl_mode_16bit:Set to 1 for 16 bit storage format in DDR.  Only valid when mode_raw = 0
// bit  [6]     cntl_rd_ddr     Set this bit to read if you want AIU_MEM_IEC958_RD_PTR and
//                              AIU_MEM_IEC958_RD_PTR_HIGH to refer to the pointer into DDR memory.
//                              Otherwise, the curr_ptr registers refer to the byte address of the data
//                              at the output of the FIFO to the rest of the IEC958 logic
// bits [5:3]   endian:         see $lib/rtl/ddr_endian.v
// bit  [2]     cntl_empty_en   Set to 1 to enable reading the DDR memory FIFO and filling the pipeline to get-bit
//                              Set cntl_empty_en = cntl_fill_en = 0 when pulsing cntl_init
// bit  [1]     cntl_fill_en    Set to 1 to enable reading data from DDR memory
// bit  [0]     cntl_init:      After setting the read pointers, sizes, channel masks
//                              and read masks, set this bit to 1 and then to 0
#define AIU_MEM_IEC958_CONTROL                     ((0x1569  << 2) + 0xc1100000)
// --------------------------------------------
// AIFIFO2 DDR Interface
// --------------------------------------------
// The AIFIFO2 start pointer into DDR memory is a 32-bit number
// The Start pointer will automatically be truncated to land on 
// an 8-byte boundary.  That is, bits [2:0] = 0;
#define AIU_MEM_AIFIFO2_START_PTR                  ((0x156a  << 2) + 0xc1100000)
// The current pointer points so some location between the START and END 
// pointers.  The current pointer is a BYTE pointer.  That is, you can 
// point to any BYTE address within the START/END range
#define AIU_MEM_AIFIFO2_CURR_PTR                   ((0x156b  << 2) + 0xc1100000)
#define AIU_MEM_AIFIFO2_END_PTR                    ((0x156c  << 2) + 0xc1100000)
#define AIU_MEM_AIFIFO2_BYTES_AVAIL                ((0x156d  << 2) + 0xc1100000)
// AIFIFO2 FIFO Control
// bit  [15:11] unused
// bit  [10]    use_level       Set this bit to 1 to enable filling of the FIFO controlled by the buffer
//                              level control.  If this bit is 0, then use bit[1] to control the enabling of filling
// bit  [9]     Data Ready.     This bit is set when data can be popped
// bit  [8]     fill busy       This bit will be high when we're fetching data from the DDR memory
//                              To reset this module, set cntl_enable = 0, and then wait for busy = 0. 
//                              After that you can pulse cntl_init to start over
// bit  [7]     cntl_endian_jic Just in case endian.  last minute byte swap of the data out of
//                              the FIFO to getbit
// bit  [6]     unused  
// bits [5:3]   endian:         see $lib/rtl/ddr_endian.v
// bit  [2]     cntl_empty_en   Set to 1 to enable reading the DDR memory FIFO and filling the pipeline to get-bit
//                              Set cntl_empty_en = cntl_fill_en = 0 when pulsing cntl_init
// bit  [1]     cntl_fill_en    Set to 1 to enable reading data from DDR memory
// bit  [0]     cntl_init:      After setting the read pointers, sizes, channel masks
//                              and read masks, set this bit to 1 and then to 0
//                              NOTE:  You don't need to pulse cntl_init if only the start address is
//                              being changed
#define AIU_MEM_AIFIFO2_CONTROL                    ((0x156e  << 2) + 0xc1100000)
// --------------------------------------------
// AIFIFO2 Buffer Level Manager
// --------------------------------------------
#define AIU_MEM_AIFIFO2_MAN_WP                     ((0x156f  << 2) + 0xc1100000)
#define AIU_MEM_AIFIFO2_MAN_RP                     ((0x1570  << 2) + 0xc1100000)
#define AIU_MEM_AIFIFO2_LEVEL                      ((0x1571  << 2) + 0xc1100000)
//
// bit  [1]     manual mode     Set to 1 for manual write pointer mode
// bit  [0]     Init            Set high then low after everything has been initialized
#define AIU_MEM_AIFIFO2_BUF_CNTL                   ((0x1572  << 2) + 0xc1100000)
// --------------------------------------------
// I2S Buffer Level Manager
// --------------------------------------------
#define AIU_MEM_I2S_MAN_WP                         ((0x1573  << 2) + 0xc1100000)
#define AIU_MEM_I2S_MAN_RP                         ((0x1574  << 2) + 0xc1100000)
#define AIU_MEM_I2S_LEVEL                          ((0x1575  << 2) + 0xc1100000)
//
// bit  [1]     mode            0 = parser (or audin_fifo0 or audin_fifo1), 
//                              1 for manual write pointer 
// bit  [0]     Init            Set high then low after everything has been initialized
#define AIU_MEM_I2S_BUF_CNTL                       ((0x1576  << 2) + 0xc1100000)
#define AIU_MEM_I2S_BUF_WRAP_COUNT                 ((0x1577  << 2) + 0xc1100000)
// bit 29:24 A_brst_num
// bit 21:16 A_id
// bit 15:0 level_hold 
#define AIU_MEM_I2S_MEM_CTL                        ((0x1578  << 2) + 0xc1100000)
//-----------------------------------------------------------------------------
// Additional IEC958 registers (new feature)
//-----------------------------------------------------------------------------
// bit 29:24 A_brst_num
// bit 21:16 A_id
// bit 15:0 level_hold 
#define AIU_MEM_IEC958_MEM_CTL                     ((0x1579  << 2) + 0xc1100000)
#define AIU_MEM_IEC958_WRAP_COUNT                  ((0x157a  << 2) + 0xc1100000)
#define AIU_MEM_IEC958_IRQ_LEVEL                   ((0x157b  << 2) + 0xc1100000)
#define AIU_MEM_IEC958_MAN_WP                      ((0x157c  << 2) + 0xc1100000)
#define AIU_MEM_IEC958_MAN_RP                      ((0x157d  << 2) + 0xc1100000)
#define AIU_MEM_IEC958_LEVEL                       ((0x157e  << 2) + 0xc1100000)
#define AIU_MEM_IEC958_BUF_CNTL                    ((0x157f  << 2) + 0xc1100000)
//-----------------------------------------------------------------------------
// add for AIFIFO channel (old $cdrom/rtl/cdr_top/getbit)
//-----------------------------------------------------------------------------
// Bit 3 	CRC pop aififo enable
// Bit 2		writing to this bit to 1 causes CRC module reset
// Bit 1		enable aififo
// Bit 0		writing to this bit to 1 causes aififo soft reset
#define AIU_AIFIFO_CTRL                            ((0x1580  << 2) + 0xc1100000)
//'h0000
// AIFIFO status register
// Bit 13		//aififo request to dcu status
// Bit 12		//dcu select status
// Bit 11:5		//aififo word counter number 
// Bit 4:0		//how many bits left in the first pop register
#define AIU_AIFIFO_STATUS                          ((0x1581  << 2) + 0xc1100000)
// Same fucntion as the AIGBIT of AIFIFO in CDROM module
// write to this register how many bits wanna pop, 
// and reading this register gets the corresponding bits data
#define AIU_AIFIFO_GBIT                            ((0x1582  << 2) + 0xc1100000)
// Same function as the AICLB of AIFIFO in CDROM module
// return the leading zeros by reading this registers
#define AIU_AIFIFO_CLB                             ((0x1583  << 2) + 0xc1100000)
// --------------------------------------------
// AIFIFO DDR Interface
// --------------------------------------------
// The AIFIFO start pointer into DDR memory is a 32-bit number
// The Start pointer will automatically be truncated to land on 
// an 8-byte boundary.  That is, bits [2:0] = 0;
#define AIU_MEM_AIFIFO_START_PTR                   ((0x1584  << 2) + 0xc1100000)
// The current pointer points so some location between the START and END 
// pointers.  The current pointer is a BYTE pointer.  That is, you can 
// point to any BYTE address within the START/END range
#define AIU_MEM_AIFIFO_CURR_PTR                    ((0x1585  << 2) + 0xc1100000)
#define AIU_MEM_AIFIFO_END_PTR                     ((0x1586  << 2) + 0xc1100000)
#define AIU_MEM_AIFIFO_BYTES_AVAIL                 ((0x1587  << 2) + 0xc1100000)
// AIFIFO FIFO Control
// bit  [15:11] unused
// bit  [10]    use_level       Set this bit to 1 to enable filling of the FIFO controlled by the buffer
//                              level control.  If this bit is 0, then use bit[1] to control the enabling of filling
// bit  [9]     Data Ready.     This bit is set when data can be popped
// bit  [8]     fill busy       This bit will be high when we're fetching data from the DDR memory
//                              To reset this module, set cntl_enable = 0, and then wait for busy = 0. 
//                              After that you can pulse cntl_init to start over
// bit  [7]     cntl_endian_jic Just in case endian.  last minute byte swap of the data out of
//                              the FIFO to getbit
// bit  [6]     unused  
// bits [5:3]   endian:         see $lib/rtl/ddr_endian.v
// bit  [2]     cntl_empty_en   Set to 1 to enable reading the DDR memory FIFO and filling the pipeline to get-bit
//                              Set cntl_empty_en = cntl_fill_en = 0 when pulsing cntl_init
// bit  [1]     cntl_fill_en    Set to 1 to enable reading data from DDR memory
// bit  [0]     cntl_init:      After setting the read pointers, sizes, channel masks
//                              and read masks, set this bit to 1 and then to 0
//                              NOTE:  You don't need to pulse cntl_init if only the start address is
//                              being changed
#define AIU_MEM_AIFIFO_CONTROL                     ((0x1588  << 2) + 0xc1100000)
// --------------------------------------------
// AIFIFO Buffer Level Manager
// --------------------------------------------
#define AIU_MEM_AIFIFO_MAN_WP                      ((0x1589  << 2) + 0xc1100000)
#define AIU_MEM_AIFIFO_MAN_RP                      ((0x158a  << 2) + 0xc1100000)
#define AIU_MEM_AIFIFO_LEVEL                       ((0x158b  << 2) + 0xc1100000)
//
// bit  [1]     manual mode     Set to 1 for manual write pointer mode
// bit  [0]     Init            Set high then low after everything has been initialized
#define AIU_MEM_AIFIFO_BUF_CNTL                    ((0x158c  << 2) + 0xc1100000)
#define AIU_MEM_AIFIFO_BUF_WRAP_COUNT              ((0x158d  << 2) + 0xc1100000)
#define AIU_MEM_AIFIFO2_BUF_WRAP_COUNT             ((0x158e  << 2) + 0xc1100000)
// bit 29:24 A_brst_num
// bit 21:16 A_id
// bit 15:0 level_hold 
#define AIU_MEM_AIFIFO_MEM_CTL                     ((0x158f  << 2) + 0xc1100000)
// bit 31:16 -- drop_bytes
// bit 15:14 -- drop_status (Read-Only)
// bit 13:12 -- sync_match_position (Read-Only)
// bit 11:6 -- reserved
// bit 5:4 -- TIME_STAMP_NUMBER, 0-32bits, 1-64bits, 2-96bits, 3-128bits 
// bit 3 -- stamp_soft_reset
// bit 2 -- TIME_STAMP_length_enable
// bit 1 -- TIME_STAMP_sync64_enable
// bit 0 -- TIME_STAMP_enable
#define AIFIFO_TIME_STAMP_CNTL                     ((0x1590  << 2) + 0xc1100000)
// bit 31:0 -- TIME_STAMP_SYNC_CODE_0
#define AIFIFO_TIME_STAMP_SYNC_0                   ((0x1591  << 2) + 0xc1100000)
// bit 31:0 -- TIME_STAMP_SYNC_CODE_1 
#define AIFIFO_TIME_STAMP_SYNC_1                   ((0x1592  << 2) + 0xc1100000)
// bit 31:0 TIME_STAMP_0
#define AIFIFO_TIME_STAMP_0                        ((0x1593  << 2) + 0xc1100000)
// bit 31:0 TIME_STAMP_1
#define AIFIFO_TIME_STAMP_1                        ((0x1594  << 2) + 0xc1100000)
// bit 31:0 TIME_STAMP_2
#define AIFIFO_TIME_STAMP_2                        ((0x1595  << 2) + 0xc1100000)
// bit 31:0 TIME_STAMP_3
#define AIFIFO_TIME_STAMP_3                        ((0x1596  << 2) + 0xc1100000)
// bit 31:0 TIME_STAMP_LENGTH
#define AIFIFO_TIME_STAMP_LENGTH                   ((0x1597  << 2) + 0xc1100000)
// bit 31:16 -- drop_bytes
// bit 15:14 -- drop_status (Read-Only)
// bit 13:12 -- sync_match_position (Read-Only)
// bit 11:6 -- reserved
// bit 5:4 -- TIME_STAMP_NUMBER, 0-32bits, 1-64bits, 2-96bits, 3-128bits 
// bit 3 -- stamp_soft_reset
// bit 2 -- TIME_STAMP_length_enable
// bit 1 -- TIME_STAMP_sync64_enable
// bit 0 -- TIME_STAMP_enable
#define AIFIFO2_TIME_STAMP_CNTL                    ((0x1598  << 2) + 0xc1100000)
// bit 31:0 -- TIME_STAMP_SYNC_CODE_0
#define AIFIFO2_TIME_STAMP_SYNC_0                  ((0x1599  << 2) + 0xc1100000)
// bit 31:0 -- TIME_STAMP_SYNC_CODE_1 
#define AIFIFO2_TIME_STAMP_SYNC_1                  ((0x159a  << 2) + 0xc1100000)
// bit 31:0 TIME_STAMP_0
#define AIFIFO2_TIME_STAMP_0                       ((0x159b  << 2) + 0xc1100000)
// bit 31:0 TIME_STAMP_1
#define AIFIFO2_TIME_STAMP_1                       ((0x159c  << 2) + 0xc1100000)
// bit 31:0 TIME_STAMP_2
#define AIFIFO2_TIME_STAMP_2                       ((0x159d  << 2) + 0xc1100000)
// bit 31:0 TIME_STAMP_3
#define AIFIFO2_TIME_STAMP_3                       ((0x159e  << 2) + 0xc1100000)
// bit 31:0 TIME_STAMP_LENGTH
#define AIFIFO2_TIME_STAMP_LENGTH                  ((0x159f  << 2) + 0xc1100000)
// bit 31:16 -- drop_bytes
// bit 15:14 -- drop_status (Read-Only)
// bit 13:12 -- sync_match_position (Read-Only)
// bit 11:6 -- reserved
// bit 5:4 -- TIME_STAMP_NUMBER, 0-32bits, 1-64bits, 2-96bits, 3-128bits 
// bit 3 -- stamp_soft_reset
// bit 2 -- TIME_STAMP_length_enable
// bit 1 -- TIME_STAMP_sync64_enable
// bit 0 -- TIME_STAMP_enable
#define IEC958_TIME_STAMP_CNTL                     ((0x15a0  << 2) + 0xc1100000)
// bit 31:0 -- TIME_STAMP_SYNC_CODE_0
#define IEC958_TIME_STAMP_SYNC_0                   ((0x15a1  << 2) + 0xc1100000)
// bit 31:0 -- TIME_STAMP_SYNC_CODE_1 
#define IEC958_TIME_STAMP_SYNC_1                   ((0x15a2  << 2) + 0xc1100000)
// bit 31:0 TIME_STAMP_0
#define IEC958_TIME_STAMP_0                        ((0x15a3  << 2) + 0xc1100000)
// bit 31:0 TIME_STAMP_1
#define IEC958_TIME_STAMP_1                        ((0x15a4  << 2) + 0xc1100000)
// bit 31:0 TIME_STAMP_2
#define IEC958_TIME_STAMP_2                        ((0x15a5  << 2) + 0xc1100000)
// bit 31:0 TIME_STAMP_3
#define IEC958_TIME_STAMP_3                        ((0x15a6  << 2) + 0xc1100000)
// bit 31:0 TIME_STAMP_LENGTH
#define IEC958_TIME_STAMP_LENGTH                   ((0x15a7  << 2) + 0xc1100000)
// bit 29:24 A_brst_num
// bit 21:16 A_id
// bit 15:0 level_hold 
#define AIU_MEM_AIFIFO2_MEM_CTL                    ((0x15a8  << 2) + 0xc1100000)
// --------------------------------------------
// CBUS_DDR interface for I2S_FAST
// --------------------------------------------
// bit[31:26] unused
// bit[25]      A_req       level
// bit[24]      data_req    If this bit is 1, then (a_req_cnt != 'h0)
// bit[23:16]   a_req_cnt   This value corresponds to the number of 32-bit words 
//                          requested by the i2s_fast() module
// bit[15:7]    unused
// bit[6]                   Set this bit to mux in the cbus_ddr_interface
// bit[5]                   Set this bit to allow back to back A_req's to be serviced
// bit[4]                   Set this bit to generate an IRQ on the first A_req
//                          If this bit is 0, then an IRQ is generated after all requests 
//                          are completed and how many 32-bit words to send is calculated.
// bit[3:1]                 Endian
// bit[0]                   Set this bit enable the cbus_ddr_interface
#define AIU_I2S_CBUS_DDR_CNTL                      ((0x15a9  << 2) + 0xc1100000)
// 32-bit data to write to the cbus_ddr interface
#define AIU_I2S_CBUS_DDR_WDATA                     ((0x15aa  << 2) + 0xc1100000)
// First address associated with the first request by the i2s_fast() to read DDR data
#define AIU_I2S_CBUS_DDR_ADDR                      ((0x15ab  << 2) + 0xc1100000)
//
// Closing file:  aregs.h
//
//========================================================================
//  CDROM Interface                                 (12'h600 - 12'h6ff)
//
//========================================================================
//========================================================================
//	registers for ge2d (12'h8a0 - 12'h8ff)
//========================================================================
//
// Reading file:  ge2d_regs.h
//
// synopsys translate_off
// synopsys translate_on
//===========================================================================
// GE2D Registers    0x8a0 - 0x8ff
//===========================================================================
// -----------------------------------------------
// CBUS_BASE:  GE2D_CBUS_BASE = 0x18
// -----------------------------------------------
//Bit 31, destination bytemask only if destination bitmask is enable
//Bit 30, destination bitmask enable
//Bit 29, source2 key  enable
//Bit 28, source2 key  mode, 0: mask data when match, 1: mask data when unmatch
//Bit 27, source1 key  enable
//Bit 26, source1 key  mode, 0: mask data when match, 1: mask data when unmatch
//Bit 25:24, dst1 8bit mode component selection, 
//            00: select Y(R), 01: Cb(G), 10: Cr(B), 11: Alpha
//Bit 23  dst clip mode, 0: write inside clip window, 1: write outside clip window
//Bit 22:17,  reserved
//Bit 16:15, src2 8bit mode component selection, 
//            00: select Y(R), 01: Cb(G), 10: Cr(B), 11: Alpha
//Bit 14     src2 fill mode, 0: repeat data, 1: fill default color
//Bit 13:12  src2 picture struct, 00: frame, 10: even, 11: odd
//Bit 11     src1 x direction yc ration, 0: 1:1, 1: 2:1
//Bit 10     src1 y direction yc ration, 0: 1:1, 1: 2:1
//Bit 9:7    reserved
//Bit 6:5,   src1  8bit mode component selection, 
//            00: select Y(R), 01: Cb(G), 10: Cr(B), 11: Alpha
//Bit 4      src1 fill mode, 0: repeat data, 1: fill default color
//Bit 3      src1 lookup table enable
//Bit 2:1    src1 picture struct, 00: frame, 10: even, 11: odd
//Bit 0      src1 separate buffer enable
#define GE2D_GEN_CTRL0                             ((0x18a0  << 2) + 0xc1100000)
//Bit 31, soft rst
//Bit 30, dst write response counter reset  
//Bit 29, disable adding dst write response count to busy bit 
//Bit 28:26, reserved
//bit 25:24, interrupt control, if bit[0] true, generate interrupt when one command done,
//                              if bit[1] true, generate interrupt when ge2d change from busy to not busy
//Bit 23:22 src2 burst size control
//Bit 21:16 src1 burst size control, 5:4, yfifo, 3:2, cbfifo, 1:0, crfifo
//          each 2bit, 00: 24 64bitword, 01: 32 64bitword, 10: 48 64bitwords, 11: 64 64bitwords  
//Bit 15:14, dst1 picture struct, 00: frame, 10:top, 11: bottom
//Bit 13:12, bit 13 if true, force read src1, bit 12 if true, force read src2
//Bit 11, dst2 request urgent enable
//Bit 10, src1 request urgent enable
//Bit 9,  src2 request urgent enable
//Bit 8,  dst1 request urgent enable
//Bit 7:0 src1 global alpha
#define GE2D_GEN_CTRL1                             ((0x18a1  << 2) + 0xc1100000)
//Bit31      alpha conversion mode in alu, 0: alpha_out = (alpha !=0) ? alpha +1 : 0; 
//                 otherwise, alpha_out = (alpha < 128) ? alpha: alpha + 1;
//Bit30      color conversion mode in alu, 0: color_out = (color != 0) ? color +1: 0;
//                 otherwise, color_out = (color < 128) ? color: color + 1;
//Bit29      src1_gb_alpha_en, As = src1_gb_alpha_en ? Asr * Ag: Asr
//Bit28      dst1_color_round_mode, 0: truncate, 1: + 0.5 rounding
//Bit27      src2_color_expand_mode, 0: add 0, 1: add MSBs 
//Bit26      src2_alpha_expand_mode, 0: add 0, 1: add MSBs 
//Bit25      src1_color_expand_mode, 0: add 0, 1: add MSBs 
//Bit24      src1_alpha_expand_mode, 0: add 0, 1: add MSBs 
//Bit 23     if true, dst little endian, otherwise big endian
//Bit 22:19 dst1 color_map
//        dst1_format=0                  : output 8-bit;
//        dst1_format=1, dst1_color_map=1: output 16-bit YCbCr  655;
//        dst1_format=1, dst1_color_map=2: output 16-bit YCbCr  844;
//        dst1_format=1, dst1_color_map=3: output 16-bit YCbCrA 6442;
//        dst1_format=1, dst1_color_map=4: output 16-bit YCbCrA 4444;
//        dst1_format=1, dst1_color_map=5: output 16-bit YCbCr  565;
//        dst1_format=1, dst1_color_map=6: output 16-bit AYCbCr 4444;
//        dst1_format=1, dst1_color_map=7: output 16-bit AYCbCr 1555;
//        dst1_format=1, dst1_color_map=8: output 16-bit YCbCrA 4642;
//        dst1_format=1, dst1_color_map=9: output 16-bit CbCr   88;
//        dst1_format=1, dst1_color_map=10:output 16-bit CrCb   88;
//        dst1_format=2, dst1_color_map=0: output 24-bit YCbCr  888;
//        dst1_format=2, dst1_color_map=1: output 24-bit YCbCrA 5658;
//        dst1_format=2, dst1_color_map=2: output 24-bit AYCbCr 8565;
//        dst1_format=2, dst1_color_map=3: output 24-bit YCbCrA 6666;
//        dst1_format=2, dst1_color_map=4: output 24-bit AYCbCr 6666;
//        dst1_format=2, dst1_color_map=5: output 24-bit CrCbY  888;
//        dst1_format=3, dst1_color_map=0: output 32-bit YCbCrA 8888;
//        dst1_format=3, dst1_color_map=1: output 32-bit AYCbCr 8888;
//        dst1_format=3, dst1_color_map=2: output 32-bit ACrCbY 8888;
//        dst1_format=3, dst1_color_map=3: output 32-bit CrCbYA 8888.
//Bit 17:16 dst1_format,  00: 8bit, 01:16bit, 10:24bit, 11: 32bit
//Bit 15    if true, src2 little endian, otherwise big endian
//Bit 14:11  src2 color_map
//        src2_format=0                 : output 8-bit;
//        src2_format=1, src2_color_map=1: output 16-bit YCbCr  655;
//        src2_format=1, src2_color_map=2: output 16-bit YCbCr  844;
//        src2_format=1, src2_color_map=3: output 16-bit YCbCrA 6442;
//        src2_format=1, src2_color_map=4: output 16-bit YCbCrA 4444;
//        src2_format=1, src2_color_map=5: output 16-bit YCbCr  565;
//        src2_format=1, src2_color_map=6: output 16-bit AYCbCr 4444;
//        src2_format=1, src2_color_map=7: output 16-bit AYCbCr 1555;
//        src2_format=1, src2_color_map=8: output 16-bit YCbCrA 4642;
//        src2_format=2, src2_color_map=0: output 24-bit YCbCr  888;
//        src2_format=2, src2_color_map=1: output 24-bit YCbCrA 5658;
//        src2_format=2, src2_color_map=2: output 24-bit AYCbCr 8565;
//        src2_format=2, src2_color_map=3: output 24-bit YCbCrA 6666;
//        src2_format=2, src2_color_map=4: output 24-bit AYCbCr 6666;
//        src2_format=2, src2_color_map=5: output 24-bit CrCbY  888;
//        src2_format=3, src2_color_map=0: output 32-bit YCbCrA 8888;
//        src2_format=3, src2_color_map=1: output 32-bit AYCbCr 8888;
//        src2_format=3, src2_color_map=2: output 32-bit ACrCbY 8888;
//        src2_format=3, src2_color_map=3: output 32-bit CrCbYA 8888.
//Bit 9:8 src2 format, 00: 8bit, 01:16bit, 10:24bit 11: 32bit
//Bit 7     if true, src1 little endian, otherwise big endian
//Bit 6:3   src1 color_map
//        src1_format=0                 : output 8-bit;
//        src1_format=1, src1_color_map=0: output 4:2:2  (Y0Cb0Y1Cr0);
//        src1_format=1, src1_color_map=1: output 16-bit YCbCr  655;
//        src1_format=1, src1_color_map=2: output 16-bit YCbCr  844;
//        src1_format=1, src1_color_map=3: output 16-bit YCbCrA 6442;
//        src1_format=1, src1_color_map=4: output 16-bit YCbCrA 4444;
//        src1_format=1, src1_color_map=5: output 16-bit YCbCr  565;
//        src1_format=1, src1_color_map=6: output 16-bit AYCbCr 4444;
//        src1_format=1, src1_color_map=7: output 16-bit AYCbCr 1555;
//        src1_format=1, src2_color_map=8: output 16-bit YCbCrA 4642;
//        src1_format=2, src1_color_map=0: output 24-bit YCbCr  888;
//        src1_format=2, src1_color_map=1: output 24-bit YCbCrA 5658;
//        src1_format=2, src1_color_map=2: output 24-bit AYCbCr 8565;
//        src1_format=2, src1_color_map=3: output 24-bit YCbCrA 6666;
//        src1_format=2, src1_color_map=4: output 24-bit AYCbCr 6666;
//        src1_format=2, src1_color_map=5: output 24-bit CrCbY  888;
//        src1_format=2, src1_color_map=14:output 8-bit Y and 16-bit CbCr;
//        src1_format=2, src1_color_map=15:output 8-bit Y and 16-bit CrCb;
//        src1_format=3, src1_color_map=0: output 32-bit YCbCrA 8888;
//        src1_format=3, src1_color_map=1: output 32-bit AYCbCr 8888;
//        src1_format=3, src1_color_map=2: output 32-bit ACrCbY 8888;
//        src1_format=3, src1_color_map=3: output 32-bit CrCbYA 8888.     
//Bit 1:0 src1 format, 00: 8bit, 01:16bit/4:2:2, 10:24bit 11: 32bit 
#define GE2D_GEN_CTRL2                             ((0x18a2  << 2) + 0xc1100000)
//Bit 9     if true, all src2 data use default color
//Bit 8     if true, all src1 data use default color
//Bit 7     if true, dst x/y swap 
//Bit 6     if true, dst x direction reversely read
//Bit 5     if true, dst y direction reversely read
//Bit 4     if true, src2 x direction reversely read
//Bit 3     if true, src2 y direction reversely read
//Bit 2     if true, src1 x direction reversely read
//Bit 1     if true, src1 y direction reversely read
//Bit 0     cmd write
#define GE2D_CMD_CTRL                              ((0x18a3  << 2) + 0xc1100000)
//Read only
//Bit 28:17 dst write response counter, for debug only
//Bit 16:7  ge2d_dp status, for debug only
//Bit 6     read src1 cmd ready
//Bit 5     read src2 cmd ready
//Bit 4     pre dpcmd ready
//Bit 3     ge2d dpcmd ready
//Bit 2     ge2d buffer command valid
//Bit 1     ge2d current command valid
//Bit 0     ge2d busy
#define GE2D_STATUS0                               ((0x18a4  << 2) + 0xc1100000)
//
//Read only
// Bit 29:16 ge2d_dst1_status, for debug only
// Bit    15 ge2d_rd_src2 core.fifo_empty
// Bit    14 ge2d_rd_src2 core.fifo_overflow
// Bit 13:12 ge2d_rd_src2 core.req_st
// Bit    11 ge2d_rd_src2 cmd_if.cmd_err, true if cmd_format=1
// Bit    10 ge2d_rd_src2 cmd_if.cmd_st, 0=IDLE state, 1=BUSY state
// Bit     9 ge2d_rd_src1 luma_core(chroma_core).fifo_empty
// Bit     8 ge2d_rd_src1 luma_core(chroma_core).fifo_overflow
// Bit  7: 6 ge2d_rd_src1 chroma_core.req_st_cr
// Bit  5: 4 ge2d_rd_src1 chroma_core.req_st_cb
// Bit  3: 2 ge2d_rd_src1 luma_core.req_st_y
// Bit     1 ge2d_rd_src1 cmd_if.stat_read_window_err, 1=reading/clipping window setting exceed limit
// Bit     0 ge2d_rd_src1 cmd_if.cmd_st, 0=IDLE state, 1=BUSY state
#define GE2D_STATUS1                               ((0x18a5  << 2) + 0xc1100000)
//SRC1 default clolor
//{Y,Cb,Cr,A}/{R,G,B,A}
#define GE2D_SRC1_DEF_COLOR                        ((0x18a6  << 2) + 0xc1100000)
//Bit 31, SRC1 clip x start extra, if true, one more data is read for chroma
//Bit 28:16, SRC1 clip x start
//Bit 15, SRC1 clip x end extra, if true, one more data is read for chroma
//Bit 12:0, SRC1 clip x end
#define GE2D_SRC1_CLIPX_START_END                  ((0x18a7  << 2) + 0xc1100000)
//Bit 31, SRC1 clip y start extra, if true, one more data is read for chroma
//Bit 28:16, SRC1 clip y start
//Bit 15, SRC1 clip y end extra, if true, one more data is read for chroma
//Bit 12:0, SRC1 clip y end
#define GE2D_SRC1_CLIPY_START_END                  ((0x18a8  << 2) + 0xc1100000)
//Bit 31:24, SRC1 canvas address0
//Bit 23:16, SRC1 canvas address1
//Bit 15:8, SRC1 canvas address2
#define GE2D_SRC1_CANVAS                           ((0x18a9  << 2) + 0xc1100000)
//Bit 31, SRC1 x start extra bit1, if true, one more chroma data is read for x even start chroma data when y/c ratio = 2
//             or x even/odd start chroma extra data when y/c ratio = 1
//Bit 30, SRC1 x start extra bit0, if true, one more chroma data is read for x odd start chroma data when y/c ratio = 2
//Bit 29:16, SRC1 x start, signed data
//Bit 15, SRC1 x end extra bit1, if true, one more chroma data is read for x odd end chroma data when y/c ratio = 2
//             or x even/odd end chroma extra data when y/c ratio = 1
//Bit 14, SRC1 x end extra bit0, if true, one more chroma data is read for x even end chroma data when y/c ratio = 2
//Bit 13:0, SRC1 x end, signed data
#define GE2D_SRC1_X_START_END                      ((0x18aa  << 2) + 0xc1100000)
//Bit 31, SRC1 y start extra, if true, one more chroma data is read for y even start chroma data when y/c ratio = 2
//             or y even/odd start chroma extra data when y/c ratio = 1
//Bit 30, SRC1 y start extra, if true, one more chroma data is read for x odd start chroma data when y/c ratio = 2
//Bit 28:16, SRC1 y start
//Bit 15, SRC1 y end extra bit1, if true, one more chroma data is read for y odd end chroma data when y/c ratio = 2
//             or y even/odd end chroma extra data when y/c ratio = 1
//Bit 14, SRC1 y end extra bit0, if true, one more chroma data is read for y even end chroma data when y/c ratio = 2
//Bit 12:0, SRC1 y end
#define GE2D_SRC1_Y_START_END                      ((0x18ab  << 2) + 0xc1100000)
// Bit 31: 9 Reserved
// Bit     8 RW, 0 = Write LUT, 1 = Read LUT
// Bit  7: 0 RW, lut_addr
#define GE2D_SRC1_LUT_ADDR                         ((0x18ac  << 2) + 0xc1100000)
// Bit 31:24 RW, Y or R
// Bit 23:16 RW, Cb or G
// Bit 15: 8 RW, Cr or B
// Bit  7: 0 RW, Alpha
#define GE2D_SRC1_LUT_DAT                          ((0x18ad  << 2) + 0xc1100000)
//Bit 19, if true, horizontal formatter using repeat to get the pixel, otherwise using interpolation
//Bit 18, horizontal formatter en
//Bit 17, if true, vertical formatter using repeat to get the pixel, otherwise using interpolation
//Bit 16, vertical formatter en
//Bit 15:8 X direction chroma phase,  
//          [7:4] for x direction even start/end chroma phase when y/c ratio = 2
//                or start/end even/odd chroma phase  when y/c ratio = 1 
//          [3:0] for x direction odd start/end chroma phase only when y/c ration = 2
//Bit 7:0  Y direction chroma phase, 
//          [7:4] for y direction even start/end chroma phase when y/c ratio = 2
//          or start/end even/odd chroma phase  when y/c ratio = 1 
//          [3:0] for y direction odd start/end chroma phase only when y/c ration = 2 
#define GE2D_SRC1_FMT_CTRL                         ((0x18ae  << 2) + 0xc1100000)
//SRC2 default clolor
//{Y,Cb,Cr,A}/{R,G,B,A}
#define GE2D_SRC2_DEF_COLOR                        ((0x18af  << 2) + 0xc1100000)
//Bit 28:16, SRC2 clip x start
//Bit 12:0, SRC2 clip x end
#define GE2D_SRC2_CLIPX_START_END                  ((0x18b0  << 2) + 0xc1100000)
//Bit 28:16, SRC2 clip y start
//Bit 12:0, SRC2 clip y end
#define GE2D_SRC2_CLIPY_START_END                  ((0x18b1  << 2) + 0xc1100000)
//Bit 28:16, SRC2 x start
//Bit 12:0, SRC2 x end
#define GE2D_SRC2_X_START_END                      ((0x18b2  << 2) + 0xc1100000)
//Bit 28:16, SRC2 y start
//Bit 12:0, SRC2 y end
#define GE2D_SRC2_Y_START_END                      ((0x18b3  << 2) + 0xc1100000)
//Bit 28:16, DST clip x start
//Bit 12:0, DST clip x end
#define GE2D_DST_CLIPX_START_END                   ((0x18b4  << 2) + 0xc1100000)
//
//Bit 28:16, DST clip y start
//Bit 12:0, DST clip y end
#define GE2D_DST_CLIPY_START_END                   ((0x18b5  << 2) + 0xc1100000)
//Bit 28:16, DST x start
//Bit 12:0, DST x end
#define GE2D_DST_X_START_END                       ((0x18b6  << 2) + 0xc1100000)
//
//Bit 28:16, DST x start
//Bit 12:0, DST x end
#define GE2D_DST_Y_START_END                       ((0x18b7  << 2) + 0xc1100000)
//Bit 23:16 DST2 canvas address
//Bit 15:8 SRC2 canvas address
//Bit 7:0 DST1 canvas address
#define GE2D_SRC2_DST_CANVAS                       ((0x18b8  << 2) + 0xc1100000)
//vertical scaler phase step
//Bit 28:0,  5.24 format
#define GE2D_VSC_START_PHASE_STEP                  ((0x18b9  << 2) + 0xc1100000)
//phase slope 
//Bit 24:0, bit 24 signed bit
#define GE2D_VSC_PHASE_SLOPE                       ((0x18ba  << 2) + 0xc1100000)
//Bit 30:29, vertical repeat line0 number 
//Bit 23:0, vertical scaler initial phase
#define GE2D_VSC_INI_CTRL                          ((0x18bb  << 2) + 0xc1100000)
//horizontal scaler phase step
//Bit 28:0,  5.24 format
#define GE2D_HSC_START_PHASE_STEP                  ((0x18bc  << 2) + 0xc1100000)
//phase slope 
//Bit 24:0, bit 24 signed bit
#define GE2D_HSC_PHASE_SLOPE                       ((0x18bd  << 2) + 0xc1100000)
//Bit 30:29, horizontal repeat line0 number 
//Bit 23:0, horizontal scaler initial phase
#define GE2D_HSC_INI_CTRL                          ((0x18be  << 2) + 0xc1100000)
//Bit 31:24, advance number in this round, if horizontal scaler is working on dividing mode
//Bit 23:0, horizontal scaler advance phase in this round, if horizontal scaler is working on dividing mode 
#define GE2D_HSC_ADV_CTRL                          ((0x18bf  << 2) + 0xc1100000)
//Bit 30, vertical nearest mode enable, must set vt_bank_length = 4
//Bit 29, horizontal nearest mode enable, must set hz_bank_length = 4 
//Bit 28, horizontal scaler dividing mode enable
//Bit 27:15, horizontal dividing length, if bit 28 is enable
//Bit 14, pre horizontal scaler enable 
//Bit 13, pre vertical scale enable
//Bit 12, vertical scale enable
//Bit 11, horizontal scaler enable
//Bit 9, if true, treat horizontal repeat line number(GE2D_HSC_INI_CTRL bit 30:29) as repeating line, 
//        otherwise using treat horizontal repeat line number as minus line number. 
//Bit 8, if true, treat vertical repeat line number(GE2D_VSC_INI_CTRL bit 30:29) as repeating line, 
//        otherwise using treat vertical repeat line number as minus line number. 
//Bit 7, if true, always use phase0 in vertical scaler
//Bit 6:4, vertical scaler bank length
//Bit 3, if true, always use phase0 in horizontal scaler
//Bit 2:0, horizontal scaler bank length
#define GE2D_SC_MISC_CTRL                          ((0x18c0  << 2) + 0xc1100000)
//Read only
//vertical scaler next round integer pixel pointer, signed data
//Bit 13:0
#define GE2D_VSC_NRND_POINT                        ((0x18c1  << 2) + 0xc1100000)
//Read only
//vertical scaler next round phase
//bit 23:0
#define GE2D_VSC_NRND_PHASE                        ((0x18c2  << 2) + 0xc1100000)
//Read only
//horizontal scaler next round integer pixel pointer, signed data
//Bit 13:0
#define GE2D_HSC_NRND_POINT                        ((0x18c3  << 2) + 0xc1100000)
//Read only
//horizontal scaler next round phase
//bit 23:0
#define GE2D_HSC_NRND_PHASE                        ((0x18c4  << 2) + 0xc1100000)
//
//Bit 28:20, pre_offset0
//Bit 18:10, pre_offset1 
//Bit 8:0,   pre_offset2
#define GE2D_MATRIX_PRE_OFFSET                     ((0x18c5  << 2) + 0xc1100000)
//Bit 28:16 coef00
//Bit 12:0  coef01
#define GE2D_MATRIX_COEF00_01                      ((0x18c6  << 2) + 0xc1100000)
//Bit 28:16 coef02
//Bit 12:0  coef10
#define GE2D_MATRIX_COEF02_10                      ((0x18c7  << 2) + 0xc1100000)
//Bit 28:16 coef11
//Bit 12:0  coef12
#define GE2D_MATRIX_COEF11_12                      ((0x18c8  << 2) + 0xc1100000)
//Bit 28:16 coef20
//Bit 12:0  coef21
#define GE2D_MATRIX_COEF20_21                      ((0x18c9  << 2) + 0xc1100000)
//Bit 28:16 coef22
//Bit 7    input y/cb/cr saturation enable
//Bit 0    conversion matrix enable
#define GE2D_MATRIX_COEF22_CTRL                    ((0x18ca  << 2) + 0xc1100000)
//Bit 28:20, offset0
//Bit 18:10, offset1 
//Bit 8:0,   offset2
#define GE2D_MATRIX_OFFSET                         ((0x18cb  << 2) + 0xc1100000)
//Bit 26:25, SRC1 color multiplier alpha selection
//           if 00, Cs = Csr
//           if 01, Cs = Csr * Asr * Ag (if source is not premultiplied)
//           if 10, Cs = Csr * Ag (if source is premultipied)
//Bit 24    SRC2 color multiplier alpha selection 
//          if 0, no multiplier, Cd = Cdr,  otherwise, Cd = Cdr * Ad.   
//Bit 22:12 ALU color operation
//          bit10:8 Blending Mode Parameter
//            3'b000: ADD               Cs*Fs + Cd*Fd
//            3'b001: SUBTRACT          Cs*Fs - Cd*Fd
//            3'b010: REVERSE SUBTRACT  Cd*Fd - Cs*Fs
//            3'b011: MIN               min(Cs*Fs, Cd*Fd)
//            3'b100: MAX               max(Cs*Fs, Cd*Fd)
//            3'b101: LOGIC OP          Cs op Cd
//          bit7:4 Source Color Blending Factor CFs
//            4'b0000: ZERO                        0
//            4'b0001: ONE                         1
//            4'b0010: SRC_COLOR                   Cs(RGBs)
//            4'b0011: ONE_MINUS_SRC_COLOR         1 - Cs(RGBs)
//            4'b0100: DST_COLOR                   Cd(RGBd)
//            4'b0101: ONE_MINUS_DST_COLOR         1 - Cd(RGBd)
//            4'b0110: SRC_ALPHA                   As
//            4'b0111: ONE_MINUS_SRC_ALPHA         1 - As
//            4'b1000: DST_ALPHA                   Ad
//            4'b1001: ONE_MINUS_DST_ALPHA         1 - Ad
//            4'b1010: CONST_COLOR                 Cc(RGBc)
//            4'b1011: ONE_MINUS_CONST_COLOR       1 - Cc(RGBc)
//            4'b1100: CONST_ALPHA                 Ac
//            4'b1101: ONE_MINUS_CONST_ALPHA       1 - Ac
//            4'b1110: SRC_ALPHA_SATURATE          min(As,1-Ad)
//          bit3:0 dest Color Blending Factor CFd, when bit10:8 != LOGIC OP
//            4'b0000: ZERO                        0
//            4'b0001: ONE                         1
//            4'b0010: SRC_COLOR                   Cs(RGBs)
//            4'b0011: ONE_MINUS_SRC_COLOR         1 - Cs(RGBs)
//            4'b0100: DST_COLOR                   Cd(RGBd)
//            4'b0101: ONE_MINUS_DST_COLOR         1 - Cd(RGBd)
//            4'b0110: SRC_ALPHA                   As
//            4'b0111: ONE_MINUS_SRC_ALPHA         1 - As
//            4'b1000: DST_ALPHA                   Ad
//            4'b1001: ONE_MINUS_DST_ALPHA         1 - Ad
//            4'b1010: CONST_COLOR                 Cc(RGBc)
//            4'b1011: ONE_MINUS_CONST_COLOR       1 - Cc(RGBc)
//            4'b1100: CONST_ALPHA                 Ac
//            4'b1101: ONE_MINUS_CONST_ALPHA       1 - Ac
//            4'b1110: SRC_ALPHA_SATURATE          min(As,1-Ad)
//          bit3:0 logic operations, when bit10:8 == LOGIC OP
//            4'b0000: CLEAR                       0
//            4'b0001: COPY                        s
//            4'b0010: NOOP                        d
//            4'b0011: SET                         1
//            4'b0100: COPY_INVERT                 ~s
//            4'b0101: INVERT                      ~d
//            4'b0110: AND_REVERSE                 s & ~d
//            4'b0111: OR_REVERSE                  s | ~d
//            4'b1000: AND                         s & d
//            4'b1001: OR                          s | d
//            4'b1010: NAND                        ~(s & d)
//            4'b1011: NOR                         ~(s | d)
//            4'b1100: XOR                         s ^ d
//            4'b1101: EQUIV                       ~(s ^ d)
//            4'b1110: AND_INVERTED                ~s & d
//            4'b1111: OR_INVERTED                 ~s | d
//Bit 10:0  ALU alpha operation
//            bit10:8 Blending Equation Math Operation
//              3'b000: ADD               As*Fs + Ad*Fd
//              3'b001: SUBTRACT          As*Fs - Ad*Fd
//              3'b010: REVERSE SUBTRACT  Ad*Fd - As*Fs
//              3'b011: MIN               min(As*Fs, Ad*Fd)
//              3'b100: MAX               max(As*Fs, Ad*Fd)
//              3'b101: LOGIC OP          As op Ad
//            bit7:4 Source alpha Blending Factor AFs
//              4'b0000                       0
//              4'b0001                       1
//              4'b0010                       As
//              4'b0011                       1 - As
//              4'b0100                       Ad
//              4'b0101                       1 - Ad
//              4'b0110                       Ac
//              4'b0111                       1 - Ac
//               ....                         reserved
//            bit3:0 Destination alpha Blending Factor AFd, when bit10:8 != LOGIC OP
//              4'b0000                       0
//              4'b0001                       1
//              4'b0010                       As
//              4'b0011                       1 - As
//              4'b0100                       Ad
//              4'b0101                       1 - Ad
//              4'b0110                       Ac
//              4'b0111                       1 - Ac
//               ....                         reserved
//            bit3:0 logic operations, when bit10:8 == LOGIC OP
//              4'b0000: CLEAR                       0
//              4'b0001: COPY                        s
//              4'b0010: NOOP                        d
//              4'b0011: SET                         1
//              4'b0100: COPY_INVERT                 ~s
//              4'b0101: INVERT                      ~d
//              4'b0110: AND_REVERSE                 s & ~d
//              4'b0111: OR_REVERSE                  s | ~d
//              4'b1000: AND                         s & d
//              4'b1001: OR                          s | d
//              4'b1010: NAND                        ~(s & d)
//              4'b1011: NOR                         ~(s | d)
//              4'b1100: XOR                         s ^ d
//              4'b1101: EQUIV                       ~(s ^ d)
//              4'b1110: AND_INVERTED                ~s & d
//              4'b1111: OR_INVERTED                 ~s | d
#define GE2D_ALU_OP_CTRL                           ((0x18cc  << 2) + 0xc1100000)
//bit 31:0 (RGBA,YCBCRA)
#define GE2D_ALU_CONST_COLOR                       ((0x18cd  << 2) + 0xc1100000)
//SRC1 Key
//31:0 
#define GE2D_SRC1_KEY                              ((0x18ce  << 2) + 0xc1100000)
//SRC1 Key Mask
//31:0 
#define GE2D_SRC1_KEY_MASK                         ((0x18cf  << 2) + 0xc1100000)
//SRC2 Key
//31:0 
#define GE2D_SRC2_KEY                              ((0x18d0  << 2) + 0xc1100000)
//SRC2 Key Mask
//31:0 
#define GE2D_SRC2_KEY_MASK                         ((0x18d1  << 2) + 0xc1100000)
//Destination Bit Mask
//31:0 
#define GE2D_DST_BITMASK                           ((0x18d2  << 2) + 0xc1100000)
//Bit 31    DP onoff mode, 0: on_counter means how many pixels will output before ge2d turns off
//                         1: on_counter means how many clocks will ge2d turn on before ge2d turns off
//Bit 30:16     DP on counter
//Bit 15        0: vd_format doesnt have onoff mode, 1: vd format has onoff mode
//Bit 14:0      DP off counter
#define GE2D_DP_ONOFF_CTRL                         ((0x18d3  << 2) + 0xc1100000)
//Because there are many coefficients used in the vertical filter and horizontal filters,
//indirect access the coefficients of vertical filter and horizontal filter is used.
//For vertical filter, there are 33x4 coefficients 
//For horizontal filter, there are 33x4 coefficients
//Bit 15	index increment, if bit9 == 1  then (0: index increase 1, 1: index increase 2) else (index increase 2)	
//Bit 14	1: read coef through cbus enable, just for debug purpose in case when we wanna check the coef in ram in correct or not
//Bit 9     if true, use 9bit resolution coef, other use 8bit resolution coef
//Bit 8	    type of index, 0: vertical coef
//						   1: horizontal coef
//Bit 6:0 	coef index
#define GE2D_SCALE_COEF_IDX                        ((0x18d4  << 2) + 0xc1100000)
//coefficients for vertical filter and horizontal filter
#define GE2D_SCALE_COEF                            ((0x18d5  << 2) + 0xc1100000)
//Bit 24    src2 alpha fill mode: together with GE2D_GEN_CTRL0[4](fill_mode), define what alpha values are used
//                                for the area outside the clipping window. As below:
//                                fill_mode=0, alpha_fill_mode=0 : use inner alpha, (or default_alpha if src data have no alpha values);
//                                fill_mode=0, alpha_fill_mode=1 : use outside_alpha;
//                                fill_mode=1, alpha_fill_mode=0 : use default_alpha;
//                                fill_mode=1, alpha_fill_mode=1 : use outside_alpha.
//Bit 23:16 src2 outside alpha
//Bit 8     src1 alpha fill mode, refer to src2 alpha fill mode above. 
//Bit 7:0   src1 outside alpha
#define GE2D_SRC_OUTSIDE_ALPHA                     ((0x18d6  << 2) + 0xc1100000)
//Bit 31       antiflick enable
//Bit 24       1: alpha value for the first line use repeated alpha, 0: use bit 23:16 as the first line alpha 
//Bit 23:16     register value for the first line alpha when bit 24 is 1 
//Bit 8        1: alpha value for the last line use repeated alpha, 0: use bit 7:0 as the last line alpha 
//Bit 7:0      register value for the last line alpha when bit 8 is 1 
#define GE2D_ANTIFLICK_CTRL0                       ((0x18d8  << 2) + 0xc1100000)
//Bit 25,    rgb_sel, 1: antiflick RGBA, 0: antiflick YCbCrA 
//Bit 24,    cbcr_en, 1: also filter cbcr in case of antiflicking YCbCrA, 0: no filter on cbcr in case of antiflicking YCbCrA
//Bit 23:16, R mult coef for converting RGB to Y
//Bit 15:8,  G mult coef for converting RGB to Y
//Bit 7:0,   B mult coef for converting RGB to Y
//Y = (R * y_r + G * y_g + B * y_b) / 256
#define GE2D_ANTIFLICK_CTRL1                       ((0x18d9  << 2) + 0xc1100000)
//Bit 31:24, Y threhold1, when   0<Y<=th1, use filter0;
//Bit 23:16, color antiflick filter0 n3
//Bit 15:8,  color antiflick filter0 n2
//Bit 7:0,   color antiflick filter0 n1
//Y = (line_up * n1 + line_center * n2 + line_dn * n3) / 128
#define GE2D_ANTIFLICK_COLOR_FILT0                 ((0x18da  << 2) + 0xc1100000)
//Bit 31:24, Y threhold2, when th1<Y<=th2, use filter1;
//Bit 23:16, color antiflick filter1 n3
//Bit 15:8,  color antiflick filter1 n2
//Bit 7:0,   color antiflick filter1 n1
#define GE2D_ANTIFLICK_COLOR_FILT1                 ((0x18db  << 2) + 0xc1100000)
//Bit 31:24, Y threhold3, when th2<Y<=th3, use filter2; Y>th3, use filter3
//Bit 23:16, color antiflick filter2 n3
//Bit 15:8,  color antiflick filter2 n2
//Bit 7:0,   color antiflick filter2 n1
#define GE2D_ANTIFLICK_COLOR_FILT2                 ((0x18dc  << 2) + 0xc1100000)
//Bit 23:16, color antiflick filter3 n3
//Bit 15:8,  color antiflick filter3 n2
//Bit 7:0,   color antiflick filter3 n1
#define GE2D_ANTIFLICK_COLOR_FILT3                 ((0x18dd  << 2) + 0xc1100000)
//Bit 31:24, Alpha threhold1, when   0<Alpha<=th1, use filter0;
//Bit 23:16, Alpha antiflick filter0 n3
//Bit 15:8,  Alpha antiflick filter0 n2
//Bit 7:0,   Alpha antiflick filter0 n1
//Alpha = (line_up * n1 + line_center * n2 + line_dn * n3) / 128
#define GE2D_ANTIFLICK_ALPHA_FILT0                 ((0x18de  << 2) + 0xc1100000)
//Bit 31:24, Alpha threhold2, when th1<Alpha<=th2, use filter1;
//Bit 23:16, Alpha antiflick filter1 n3
//Bit 15:8,  Alpha antiflick filter1 n2
//Bit 7:0,   Alpha antiflick filter1 n1
#define GE2D_ANTIFLICK_ALPHA_FILT1                 ((0x18df  << 2) + 0xc1100000)
//Bit 31:24, Alpha threhold3, when th2<Alpha<=th3, use filter2; Alpha>th3, use filter3
//Bit 23:16, Alpha antiflick filter2 n3
//Bit 15:8,  Alpha antiflick filter2 n2
//Bit 7:0,   Alpha antiflick filter2 n1
#define GE2D_ANTIFLICK_ALPHA_FILT2                 ((0x18e0  << 2) + 0xc1100000)
//Bit 23:16, Alpha antiflick filter3 n3
//Bit 15:8,  Alpha antiflick filter3 n2
//Bit 7:0,   Alpha antiflick filter3 n1
#define GE2D_ANTIFLICK_ALPHA_FILT3                 ((0x18e1  << 2) + 0xc1100000)
//dout = clipto_0_255(((din + din_offset) * map_coef + ((1 << (map_sr - 1))) >> map_sr + dout_offset) 
//Bit 30:22 din_offset (signed data)
//Bit 21:14 map_coef (unsigned data)
//Bit 13:10 map_sr (unsigned data)
//Bit 9:1   dout_offset (signed data)
//Bit 0     enable
#define GE2D_SRC1_RANGE_MAP_Y_CTRL                 ((0x18e3  << 2) + 0xc1100000)
//dout = clipto_0_255(((din + din_offset) * map_coef + ((1 << (map_sr - 1))) >> map_sr + dout_offset) 
//Bit 30:22 din_offset (signed data)
//Bit 21:14 map_coef (unsigned data)
//Bit 13:10 map_sr (unsigned data)
//Bit 9:1   dout_offset (signed data)
//Bit 0     enable
#define GE2D_SRC1_RANGE_MAP_CB_CTRL                ((0x18e4  << 2) + 0xc1100000)
//dout = clipto_0_255(((din + din_offset) * map_coef + ((1 << (map_sr - 1))) >> map_sr + dout_offset) 
//Bit 30:22 din_offset (signed data)
//Bit 21:14 map_coef (unsigned data)
//Bit 13:10 map_sr (unsigned data)
//Bit 9:1   dout_offset (signed data)
//Bit 0     enable
#define GE2D_SRC1_RANGE_MAP_CR_CTRL                ((0x18e5  << 2) + 0xc1100000)
//Bit 21:16     src1 prearbitor burst number
//Bit 13:8      src2 prearbitor burst number
//Bit 5:0       dst prearbitor burst number
#define GE2D_ARB_BURST_NUM                         ((0x18e6  << 2) + 0xc1100000)
//each 6bit ID, high 4bit are thread ID, low 2bits are the token
//Bit 21:16 src1 ID
//Bit 13:8 src2 ID
//Bit 5:0  dst ID
#define GE2D_TID_TOKEN                             ((0x18e7  << 2) + 0xc1100000)
//Bit 31:28 dst2_bytemask_val. 1-bit mask for each byte (8-bit). Applicable only if both dst_bitmask_en=1 and dst_bytemask_only=1.
//Bit 27:26, dst2 picture struct, 00: frame, 10:top, 11: bottom
//Bit 25:24, dst2 8bit mode component selection, 
//            00: select Y(R), 01: Cb(G), 10: Cr(B), 11: Alpha
//Bit 22:19 dst2 color_map
//        dst2_format=0                  : output 8-bit;
//        dst2_format=1, dst2_color_map=1: output 16-bit YCbCr  655;
//        dst2_format=1, dst2_color_map=2: output 16-bit YCbCr  844;
//        dst2_format=1, dst2_color_map=3: output 16-bit YCbCrA 6442;
//        dst2_format=1, dst2_color_map=4: output 16-bit YCbCrA 4444;
//        dst2_format=1, dst2_color_map=5: output 16-bit YCbCr  565;
//        dst2_format=1, dst2_color_map=6: output 16-bit AYCbCr 4444;
//        dst2_format=1, dst2_color_map=7: output 16-bit AYCbCr 1555;
//        dst2_format=1, dst2_color_map=8: output 16-bit YCbCrA 4642;
//        dst2_format=1, dst2_color_map=9: output 16-bit CbCr   88;
//        dst2_format=1, dst2_color_map=10:output 16-bit CrCb   88;
//        dst2_format=2, dst2_color_map=0: output 24-bit YCbCr  888;
//        dst2_format=2, dst2_color_map=1: output 24-bit YCbCrA 5658;
//        dst2_format=2, dst2_color_map=2: output 24-bit AYCbCr 8565;
//        dst2_format=2, dst2_color_map=3: output 24-bit YCbCrA 6666;
//        dst2_format=2, dst2_color_map=4: output 24-bit AYCbCr 6666;
//        dst2_format=2, dst2_color_map=5: output 24-bit CrCbY  888;
//        dst2_format=3, dst2_color_map=0: output 32-bit YCbCrA 8888;
//        dst2_format=3, dst2_color_map=1: output 32-bit AYCbCr 8888;
//        dst2_format=3, dst2_color_map=2: output 32-bit ACrCbY 8888;
//        dst2_format=3, dst2_color_map=3: output 32-bit CrCbYA 8888.
//Bit 17:16 dst2_format,  00: 8bit, 01:16bit, 10:24bit, 11: 32bit
//Bit 15     reserved
//Bit 14     dst2_color_round_mode, 0: truncate, 1: + 0.5 rounding
//Bit 13:12, dst2_x_discard_mode. 00: no discard; 10=discard even x; 11=discard odd x. Note: x is post reverse/rotation.
//Bit 11:10, dst2_y_discard_mode. 00: no discard; 10=discard even y; 11=discard odd y. Note: y is post reverse/rotation.
//Bit     9 reserved
//Bit     8, dst2_enable. 0: disable dst2 (default); 1=enable dst2.
//Bit  7: 6 reserved
//Bit  5: 4, dst1_x_discard_mode. 00: no discard; 10=discard even x; 11=discard odd x. Note: x is post reverse/rotation.
//Bit  3: 2, dst1_y_discard_mode. 00: no discard; 10=discard even y; 11=discard odd y. Note: y is post reverse/rotation.
//Bit     1 reserved
//Bit     0, dst1_enable. 0: disable dst1; 1=enable dst1 (default).
#define GE2D_GEN_CTRL3                             ((0x18e8  << 2) + 0xc1100000)
//Read only
// Bit 13:0 ge2d_dst2_status, for debug only
#define GE2D_STATUS2                               ((0x18e9  << 2) + 0xc1100000)
//bit 0, if true, disable bug fix about the dp_out_done/scale_out_done(test1823) hang issue when scaling down ratio is high.
#define GE2D_GEN_CTRL4                             ((0x18ea  << 2) + 0xc1100000)
// synopsys translate_off
// synopsys translate_on
//
// Closing file:  ge2d_regs.h
//
//========================================================================
//  DSP Co-Processor Registers			    ( 8'he00 - 12'hfff)
//
//========================================================================
// Duplicate Address:  When actually used
// please move to a different address
// `define AUDIO_COP_CTL1      12'hf00  // r & w; r-> 6'h00,bsmod[2:0],acmod[2:0],lfeon,nfchans[2:0]
#define AUDIO_COP_CTL2                             ((0x1f01  << 2) + 0xc1100000)
//  f02 -f0d are special regs , not in ac3_reg.h, but used by CPU for AC3 operations
#define OPERAND_M_CTL                              ((0x1f02  << 2) + 0xc1100000)
#define OPERAND1_ADDR                              ((0x1f03  << 2) + 0xc1100000)
#define OPERAND2_ADDR                              ((0x1f04  << 2) + 0xc1100000)
#define RESULT_M_CTL                               ((0x1f05  << 2) + 0xc1100000)
#define RESULT1_ADDR                               ((0x1f06  << 2) + 0xc1100000)
#define RESULT2_ADDR                               ((0x1f07  << 2) + 0xc1100000)
#define ADD_SHFT_CTL                               ((0x1f08  << 2) + 0xc1100000)
#define OPERAND_ONE_H                              ((0x1f09  << 2) + 0xc1100000)
#define OPERAND_ONE_L                              ((0x1f0a  << 2) + 0xc1100000)
#define OPERAND_TWO_H                              ((0x1f0b  << 2) + 0xc1100000)
#define OPERAND_TWO_L                              ((0x1f0c  << 2) + 0xc1100000)
#define RESULT_H                                   ((0x1f0d  << 2) + 0xc1100000)
#define RESULT_M                                   ((0x1f0e  << 2) + 0xc1100000)
// special reg 
#define RESULT_L                                   ((0x1f0f  << 2) + 0xc1100000)
// 
#define WMEM_R_PTR                                 ((0x1f10  << 2) + 0xc1100000)
#define WMEM_W_PTR                                 ((0x1f11  << 2) + 0xc1100000)
#define AUDIO_LAYER                                ((0x1f20  << 2) + 0xc1100000)
#define AC3_DECODING                               ((0x1f21  << 2) + 0xc1100000)
#define AC3_DYNAMIC                                ((0x1f22  << 2) + 0xc1100000)
#define AC3_MELODY                                 ((0x1f23  << 2) + 0xc1100000)
#define AC3_VOCAL                                  ((0x1f24  << 2) + 0xc1100000)
//======================================
//  CPU Assist module
//
//======================================
// -----------------------------------------------
// CBUS_BASE:  ASSIST_CBUS_BASE = 0x1f
// -----------------------------------------------
//`define ASSIST_AMR_MBOX1_INT          8'h4d
//`define ASSIST_AMR_MBOX2_INT          8'h4e
#define ASSIST_AMR_SCRATCH0                        ((0x1f4f  << 2) + 0xc1100000)
#define ASSIST_AMR_SCRATCH1                        ((0x1f50  << 2) + 0xc1100000)
#define ASSIST_AMR_SCRATCH2                        ((0x1f51  << 2) + 0xc1100000)
#define ASSIST_AMR_SCRATCH3                        ((0x1f52  << 2) + 0xc1100000)
#define ASSIST_HW_REV                              ((0x1f53  << 2) + 0xc1100000)
//`define ASSIST_CBUS_ARB               8'h54
#define ASSIST_POR_CONFIG                          ((0x1f55  << 2) + 0xc1100000)
#define ASSIST_SPARE16_REG1                        ((0x1f56  << 2) + 0xc1100000)
#define ASSIST_SPARE16_REG2                        ((0x1f57  << 2) + 0xc1100000)
#define ASSIST_SPARE8_REG1                         ((0x1f58  << 2) + 0xc1100000)
#define ASSIST_SPARE8_REG2                         ((0x1f59  << 2) + 0xc1100000)
// Duplicate Address...when used please move to a new address
// `define TO_AMRISC_REG                 8'h59 // for amrisc
#define ASSIST_SPARE8_REG3                         ((0x1f5a  << 2) + 0xc1100000)
// Duplicate Address...when used please move to a new address
// `define FROM_AMRISC_REG               8'h5a // for amrisc
// Duplicate Address...when used please move to a new address
// `define MPEG2_DECODER_CONTROL         8'h5b // for amrisc
#define AC3_CTRL_REG1                              ((0x1f5b  << 2) + 0xc1100000)
#define AC3_CTRL_REG2                              ((0x1f5c  << 2) + 0xc1100000)
#define AC3_CTRL_REG3                              ((0x1f5d  << 2) + 0xc1100000)
#define AC3_CTRL_REG4                              ((0x1f5e  << 2) + 0xc1100000)
//`define ASSIST_PMEM_SPLIT             8'h5f
#define ASSIST_GEN_CNTL                            ((0x1f68  << 2) + 0xc1100000)
#define EE_ASSIST_MBOX0_IRQ_REG                    ((0x1f70  << 2) + 0xc1100000)
#define EE_ASSIST_MBOX0_CLR_REG                    ((0x1f71  << 2) + 0xc1100000)
#define EE_ASSIST_MBOX0_MASK                       ((0x1f72  << 2) + 0xc1100000)
#define EE_ASSIST_MBOX0_FIQ_SEL                    ((0x1f73  << 2) + 0xc1100000)
#define EE_ASSIST_MBOX1_IRQ_REG                    ((0x1f74  << 2) + 0xc1100000)
#define EE_ASSIST_MBOX1_CLR_REG                    ((0x1f75  << 2) + 0xc1100000)
#define EE_ASSIST_MBOX1_MASK                       ((0x1f76  << 2) + 0xc1100000)
#define EE_ASSIST_MBOX1_FIQ_SEL                    ((0x1f77  << 2) + 0xc1100000)
#define EE_ASSIST_MBOX2_IRQ_REG                    ((0x1f78  << 2) + 0xc1100000)
#define EE_ASSIST_MBOX2_CLR_REG                    ((0x1f79  << 2) + 0xc1100000)
#define EE_ASSIST_MBOX2_MASK                       ((0x1f7a  << 2) + 0xc1100000)
#define EE_ASSIST_MBOX2_FIQ_SEL                    ((0x1f7b  << 2) + 0xc1100000)
#define EE_ASSIST_MBOX3_IRQ_REG                    ((0x1f7c  << 2) + 0xc1100000)
#define EE_ASSIST_MBOX3_CLR_REG                    ((0x1f7d  << 2) + 0xc1100000)
#define EE_ASSIST_MBOX3_MASK                       ((0x1f7e  << 2) + 0xc1100000)
#define EE_ASSIST_MBOX3_FIQ_SEL                    ((0x1f7f  << 2) + 0xc1100000)
// -----------------------------------------------
// CBUS_BASE:  AUD_CBUS_BASE = 0x28
// -----------------------------------------------
// ----------------------------
// AUDIN (64)
// ----------------------------
#define AUDIN_SPDIF_MODE                           ((0x2800  << 2) + 0xc1100000)
    #define SPDIF_EN                31
    #define SPDIF_INT_EN            30
    #define SPDIF_BURST_PRE_INT_EN  29
    #define SPDIF_TIE_0             24
    #define SPDIF_SAMPLE_SEL        23
    #define SPDIF_REVERSE_EN        22
    #define SPDIF_BIT_ORDER         20
    #define SPDIF_CHNL_ORDER        19
    #define SPDIF_DATA_TYPE_SEL     18
    #define SPDIF_XTDCLK_UPD_ITVL   14   //16:14
    #define SPDIF_CLKNUM_54U        0     //13:0 
#define AUDIN_SPDIF_FS_CLK_RLTN                    ((0x2801  << 2) + 0xc1100000)
    #define SPDIF_CLKNUM_192K  24     //29:24 
    #define SPDIF_CLKNUM_96K   18     //23:18 
    #define SPDIF_CLKNUM_48K   12     //17:12 
    #define SPDIF_CLKNUM_44K   6     // 11:6
    #define SPDIF_CLKNUM_32K   0     // 5:0
#define AUDIN_SPDIF_CHNL_STS_A                     ((0x2802  << 2) + 0xc1100000)
#define AUDIN_SPDIF_CHNL_STS_B                     ((0x2803  << 2) + 0xc1100000)
#define AUDIN_SPDIF_MISC                           ((0x2804  << 2) + 0xc1100000)
#define AUDIN_SPDIF_NPCM_PCPD                      ((0x2805  << 2) + 0xc1100000)
#define AUDIN_SPDIF_END                            ((0x280f  << 2) + 0xc1100000)
#define AUDIN_I2SIN_CTRL                           ((0x2810  << 2) + 0xc1100000)
    #define I2SIN_DIR       0    // I2S CLK and LRCLK direction. 0 : input 1 : output.
    #define I2SIN_CLK_SEL    1    // I2S clk selection : 0 : from pad input. 1 : from AIU.
    #define I2SIN_LRCLK_SEL 2
    #define I2SIN_POS_SYNC  3
    #define I2SIN_LRCLK_SKEW 4    // 6:4
    #define I2SIN_LRCLK_INVT 7
    #define I2SIN_SIZE       8    //9:8 : 0 16 bit. 1 : 18 bits 2 : 20 bits 3 : 24bits.
    #define I2SIN_CHAN_EN   10    //13:10. 
    #define I2SIN_EN        15
// Bit 31:15    Rsrv.
// Bit 14:12 RW HDMI-RX SPDIF channel status select to report on AUDIN_DECODE_CHANNEL_STATUS_A_*: 0=select channel 1; 1=channel 2; ...; 7=channel 8.
// Bit 11: 8 RW HDMI-RX SPDIF channel status extraction enable, 1-bit per channel pair. To enable, SPDIF input source also must select 1.
// Bit  7: 6    Rsrv.
// Bit  5: 4 RW SPDIF input source select. 0=Default, select chip external; 1=select HDMI RX output; 2/3=Rsrv.
// Bit  3: 2    Rsrv.
// Bit  1: 0 RW I2S input source select. 0=Default, select chip external; 1=select audio codec output; 2=select HDMI RX output; 3=Rsrv.
#define AUDIN_SOURCE_SEL                           ((0x2811  << 2) + 0xc1100000)
// The following registers control the new alternative decoder -- hdmi_tx_audio_decoder, in audin module
// Bit 31:25    Rsrv.
// Bit    24 RW SPDIF enable.
// Bit 23:22    Rsrv.
// Bit 21:20 RW i2s_block_start_src: 0=left channel 0 is approved as block start generator, ..., 3=left channel 3 is the block start generator.
// Bit 19:17    Rsrv.
// Bit    16 RW I2S enable.
// Bit 15: 8 RW audio_channel_alloc: Usage indication of up to 8 channels. If the correspoinding bit is 1, then this channel is used.
//                                   E.g.: In 2-channel audio, it is 00000011
// Bit     7 RW hdmi_tx_audio_decoder input sel: 0=SPDIF; 1=I2S.
// Bit     6 RW i2s_channel_config: 0=2-channel; 1=8-channel.
// Bit  5: 4 RW i2s_format_select: 0=left-justify; 1=right-justify; 2=I2S format; 3=DSP format.
// Bit  3: 2 RW i2s_bit_width: 0=16-bit; 1=18-bit; 2=20-bit; 3=24-bit.
// Bit     1 RW ws polarity: 0=0 is left, 1 is right; 1=1 is left, 0 is right.
// Bit     0 RW For SPDIF mode, 0=use channel status from input data; 1=use channel status from registers;
//              For I2S mode, 0=one-bit audio; 1=I2S.
#define AUDIN_DECODE_FORMAT                        ((0x2812  << 2) + 0xc1100000)
// Bit 31:25    Rsrv.
// Bit    24 R  channel_status stablility indicator.
// Bit 23:16 RW Valid bits for audio sample packet. [7] for valid_sp3_right, [6] for valid_sp3_left, ..., [1] for valid_sp0_right, [0] for valid_sp0_left.
// Bit 15: 8 RW User bits for audio sample packet. [7] for user_sp3_right, [6] for user_sp3_left, ..., [1] for user_sp0_right, [0] for user_sp0_left.
// Bit  7: 4 RW cntl_init_discard: Number of initial hdmi_tx_audio_decoder samples to discard from reset.
// Bit     3 RW cntl_invert_i2s_lrclk: Invert WS before input to hdmi_tx_audio_decoder.
// Bit     2 RW audio_valid_overwrite: Valid bit selection in audio packet. 0=use input data; 1=use
// Bit     1 RW audio_user_overwrite: User bit selection in audio packet. 0=use input data; 1=use
// Bit     0 RW audio_sample_valid: sample non-flat indication. 0=flat, non-valid; 1=non-flat, valid.
#define AUDIN_DECODE_CONTROL_STATUS                ((0x2813  << 2) + 0xc1100000)
// IEC958 192-bit channel status: muxed between 8 channels, channel selection by AUDIN_SOURCE_SEL[14:12]
#define AUDIN_DECODE_CHANNEL_STATUS_A_0            ((0x2814  << 2) + 0xc1100000)
#define AUDIN_DECODE_CHANNEL_STATUS_A_1            ((0x2815  << 2) + 0xc1100000)
#define AUDIN_DECODE_CHANNEL_STATUS_A_2            ((0x2816  << 2) + 0xc1100000)
#define AUDIN_DECODE_CHANNEL_STATUS_A_3            ((0x2817  << 2) + 0xc1100000)
#define AUDIN_DECODE_CHANNEL_STATUS_A_4            ((0x2818  << 2) + 0xc1100000)
#define AUDIN_DECODE_CHANNEL_STATUS_A_5            ((0x2819  << 2) + 0xc1100000)
#define AUDIN_FIFO0_START                          ((0x2820  << 2) + 0xc1100000)
#define AUDIN_FIFO0_END                            ((0x2821  << 2) + 0xc1100000)
#define AUDIN_FIFO0_PTR                            ((0x2822  << 2) + 0xc1100000)
#define AUDIN_FIFO0_INTR                           ((0x2823  << 2) + 0xc1100000)
#define AUDIN_FIFO0_RDPTR                          ((0x2824  << 2) + 0xc1100000)
#define AUDIN_FIFO0_CTRL                           ((0x2825  << 2) + 0xc1100000)
    #define AUDIN_FIFO0_EN       0
    #define AUDIN_FIFO0_RST      1
    #define AUDIN_FIFO0_LOAD     2    //write 1 to load address to AUDIN_FIFO0.
         
    #define AUDIN_FIFO0_DIN_SEL  3
            // 0     spdifIN
            // 1     i2Sin
            // 2     PCMIN
            // 3     HDMI in
            // 4     DEMODULATOR IN
    #define AUDIN_FIFO0_ENDIAN   8    //10:8   data endian control.
    #define AUDIN_FIFO0_CHAN     11    //14:11   channel number.  in M1 suppose there's only 1 channel and 2 channel.
    #define AUDIN_FIFO0_UG       15    // urgent request enable.
    #define AUDIN_FIFO0_HOLD0_EN  19  
    #define AUDIN_FIFO0_HOLD1_EN  20
    #define AUDIN_FIFO0_HOLD2_EN  21
    #define AUDIN_FIFO0_HOLD0_SEL 22   // 23:22
    #define AUDIN_FIFO0_HOLD1_SEL 24   // 25:24
    #define AUDIN_FIFO0_HOLD2_SEL 26   // 27:26
    #define AUDIN_FIFO0_HOLD_LVL  28   // 27:26


#define AUDIN_FIFO0_CTRL1                          ((0x2826  << 2) + 0xc1100000)
#define AUDIN_FIFO0_LVL0                           ((0x2827  << 2) + 0xc1100000)
#define AUDIN_FIFO0_LVL1                           ((0x2828  << 2) + 0xc1100000)
#define AUDIN_FIFO0_LVL2                           ((0x2829  << 2) + 0xc1100000)
#define AUDIN_FIFO0_REQID                          ((0x2830  << 2) + 0xc1100000)
#define AUDIN_FIFO0_WRAP                           ((0x2831  << 2) + 0xc1100000)
#define AUDIN_FIFO1_START                          ((0x2833  << 2) + 0xc1100000)
#define AUDIN_FIFO1_END                            ((0x2834  << 2) + 0xc1100000)
#define AUDIN_FIFO1_PTR                            ((0x2835  << 2) + 0xc1100000)
#define AUDIN_FIFO1_INTR                           ((0x2836  << 2) + 0xc1100000)
#define AUDIN_FIFO1_RDPTR                          ((0x2837  << 2) + 0xc1100000)
#define AUDIN_FIFO1_CTRL                           ((0x2838  << 2) + 0xc1100000)
    #define AUDIN_FIFO1_EN       0
    #define AUDIN_FIFO1_RST      1
    #define AUDIN_FIFO1_LOAD     2    //write 1 to load address to AUDIN_FIFO0.
         
    #define AUDIN_FIFO1_DIN_SEL  3
            // 0     spdifIN
            // 1     i2Sin
            // 2     PCMIN
            // 3     HDMI in
            // 4     DEMODULATOR IN
    #define AUDIN_FIFO1_ENDIAN   8    //10:8   data endian control.
    #define AUDIN_FIFO1_CHAN     11    //14:11   channel number.  in M1 suppose there's only 1 channel and 2 channel.
    #define AUDIN_FIFO1_UG       15    // urgent request enable.
    #define AUDIN_FIFO1_HOLD0_EN  19  
    #define AUDIN_FIFO1_HOLD1_EN  20
    #define AUDIN_FIFO1_HOLD2_EN  21
    #define AUDIN_FIFO1_HOLD0_SEL 22   // 23:22
    #define AUDIN_FIFO1_HOLD1_SEL 24   // 25:24
    #define AUDIN_FIFO1_HOLD2_SEL 26   // 27:26
    #define AUDIN_FIFO1_HOLD_LVL  28   // 27:26
#define AUDIN_FIFO1_CTRL1                          ((0x2839  << 2) + 0xc1100000)
#define AUDIN_FIFO1_LVL0                           ((0x2840  << 2) + 0xc1100000)
#define AUDIN_FIFO1_LVL1                           ((0x2841  << 2) + 0xc1100000)
#define AUDIN_FIFO1_LVL2                           ((0x2842  << 2) + 0xc1100000)
#define AUDIN_FIFO1_REQID                          ((0x2843  << 2) + 0xc1100000)
#define AUDIN_FIFO1_WRAP                           ((0x2844  << 2) + 0xc1100000)
#define AUDIN_FIFO2_START                          ((0x2845  << 2) + 0xc1100000)
#define AUDIN_FIFO2_END                            ((0x2846  << 2) + 0xc1100000)
#define AUDIN_FIFO2_PTR                            ((0x2847  << 2) + 0xc1100000)
#define AUDIN_FIFO2_INTR                           ((0x2848  << 2) + 0xc1100000)
#define AUDIN_FIFO2_RDPTR                          ((0x2849  << 2) + 0xc1100000)
#define AUDIN_FIFO2_CTRL                           ((0x284a  << 2) + 0xc1100000)
#define AUDIN_FIFO2_CTRL1                          ((0x284b  << 2) + 0xc1100000)
#define AUDIN_FIFO2_LVL0                           ((0x284c  << 2) + 0xc1100000)
#define AUDIN_FIFO2_LVL1                           ((0x284d  << 2) + 0xc1100000)
#define AUDIN_FIFO2_LVL2                           ((0x284e  << 2) + 0xc1100000)
#define AUDIN_FIFO2_REQID                          ((0x284f  << 2) + 0xc1100000)
#define AUDIN_FIFO2_WRAP                           ((0x2850  << 2) + 0xc1100000)
#define AUDIN_INT_CTRL                             ((0x2851  << 2) + 0xc1100000)
#define AUDIN_FIFO_INT                             ((0x2852  << 2) + 0xc1100000)
#define PCMIN_CTRL0                                ((0x2860  << 2) + 0xc1100000)
#define PCMIN_CTRL1                                ((0x2861  << 2) + 0xc1100000)
//`define PCMIN1_CTRL0                     8'h62 
//`define PCMIN1_CTRL1                     8'h63 
#define PCMOUT_CTRL0                               ((0x2870  << 2) + 0xc1100000)
#define PCMOUT_CTRL1                               ((0x2871  << 2) + 0xc1100000)
#define PCMOUT_CTRL2                               ((0x2872  << 2) + 0xc1100000)
#define PCMOUT_CTRL3                               ((0x2873  << 2) + 0xc1100000)
//`define PCMOUT1_CTRL0                    8'h74
//`define PCMOUT1_CTRL1                    8'h75
//`define PCMOUT1_CTRL2                    8'h76
//`define PCMOUT1_CTRL3                    8'h77
#define AUDOUT_CTRL                                ((0x2880  << 2) + 0xc1100000)
#define AUDOUT_CTRL1                               ((0x2881  << 2) + 0xc1100000)
#define AUDOUT_BUF0_STA                            ((0x2882  << 2) + 0xc1100000)
#define AUDOUT_BUF0_EDA                            ((0x2883  << 2) + 0xc1100000)
#define AUDOUT_BUF0_WPTR                           ((0x2884  << 2) + 0xc1100000)
#define AUDOUT_BUF1_STA                            ((0x2885  << 2) + 0xc1100000)
#define AUDOUT_BUF1_EDA                            ((0x2886  << 2) + 0xc1100000)
#define AUDOUT_BUF1_WPTR                           ((0x2887  << 2) + 0xc1100000)
#define AUDOUT_FIFO_RPTR                           ((0x2888  << 2) + 0xc1100000)
#define AUDOUT_INTR_PTR                            ((0x2889  << 2) + 0xc1100000)
#define AUDOUT_FIFO_STS                            ((0x288a  << 2) + 0xc1100000)
//`define AUDOUT1_CTRL                     8'h90
//`define AUDOUT1_CTRL1                    8'h91
//`define AUDOUT1_BUF0_STA                 8'h92
//`define AUDOUT1_BUF0_EDA                 8'h93
//`define AUDOUT1_BUF0_WPTR                8'h94
//`define AUDOUT1_BUF1_STA                 8'h95
//`define AUDOUT1_BUF1_EDA                 8'h96
//`define AUDOUT1_BUF1_WPTR                8'h97
//`define AUDOUT1_FIFO_RPTR                8'h98
//`define AUDOUT1_INTR_PTR                 8'h99
//`define AUDOUT1_FIFO_STS                 8'h9a
//// Bit 31: 0 RW cntl_mute_val: Use this value during mute, if cntl_mute_mode=2.
//`define AUDIN_MUTE_VAL                 8'h35
#define AUDIN_HDMI_MEAS_CTRL                       ((0x28a0  << 2) + 0xc1100000)
#define AUDIN_HDMI_MEAS_CYCLES_M1                  ((0x28a1  << 2) + 0xc1100000)
#define AUDIN_HDMI_MEAS_INTR_MASKN                 ((0x28a2  << 2) + 0xc1100000)
#define AUDIN_HDMI_MEAS_INTR_STAT                  ((0x28a3  << 2) + 0xc1100000)
#define AUDIN_HDMI_REF_CYCLES_STAT_0               ((0x28a4  << 2) + 0xc1100000)
#define AUDIN_HDMI_REF_CYCLES_STAT_1               ((0x28a5  << 2) + 0xc1100000)
#define AUDIN_HDMIRX_AFIFO_STAT                    ((0x28a6  << 2) + 0xc1100000)
#define AUDIN_FIFO0_PIO_STS                        ((0x28b0  << 2) + 0xc1100000)
#define AUDIN_FIFO0_PIO_RDL                        ((0x28b1  << 2) + 0xc1100000)
#define AUDIN_FIFO0_PIO_RDH                        ((0x28b2  << 2) + 0xc1100000)
#define AUDIN_FIFO1_PIO_STS                        ((0x28b3  << 2) + 0xc1100000)
#define AUDIN_FIFO1_PIO_RDL                        ((0x28b4  << 2) + 0xc1100000)
#define AUDIN_FIFO1_PIO_RDH                        ((0x28b5  << 2) + 0xc1100000)
#define AUDIN_FIFO2_PIO_STS                        ((0x28b6  << 2) + 0xc1100000)
#define AUDIN_FIFO2_PIO_RDL                        ((0x28b7  << 2) + 0xc1100000)
#define AUDIN_FIFO2_PIO_RDH                        ((0x28b8  << 2) + 0xc1100000)
#define AUDOUT_FIFO_PIO_STS                        ((0x28b9  << 2) + 0xc1100000)
#define AUDOUT_FIFO_PIO_WRL                        ((0x28ba  << 2) + 0xc1100000)
#define AUDOUT_FIFO_PIO_WRH                        ((0x28bb  << 2) + 0xc1100000)
//`define AUDOUT1_FIFO_PIO_STS		8'hbc
//`define AUDOUT1_FIFO_PIO_WRL        	8'hbd
//`define AUDOUT1_FIFO_PIO_WRH        	8'hbe
#define AUD_RESAMPLE_CTRL0                         ((0x28bf  << 2) + 0xc1100000)
#define AUD_RESAMPLE_CTRL1                         ((0x28c0  << 2) + 0xc1100000)
#define AUD_RESAMPLE_STATUS                        ((0x28c1  << 2) + 0xc1100000)
#define AUDIN_ADDR_END                             ((0x28c2  << 2) + 0xc1100000)
// synopsys translate_off
// synopsys translate_on
//
// Closing file:  ./register_map.h
//
//
// Reading file:  ./vcbus_regs.h
//
// synopsys translate_off
// synopsys translate_on
//===========================================================================
// VDIN   
//===========================================================================
// -----------------------------------------------
// CBUS_BASE:  VDIN_VCBUS_BASE = 0x12
// -----------------------------------------------
//VDIN0        8'h00 - 8'h6f
//VDIN1        8'h70 - 8'hdf
#define VDIN0_OFFSET            0x00
#define VDIN1_OFFSET            0x70

#define VDIN_SCALE_COEF_IDX                        ((0x1200  << 2) + 0xd0100000)
#define VDIN_SCALE_COEF                            ((0x1201  << 2) + 0xd0100000)
//bit 31,   mpeg_to_vdin_sel, 0: mpeg source to NR directly, 1: mpeg source pass through here
//bit 30,   mpeg_field info which can be written by software
//Bit 29,   force go_field, pulse signal
//Bit 28,   force go_line, pulse signal
//Bit 27,   enable mpeg_go_field input signal
//Bit 26:20, hold lines
//Bit 19,   delay go_field function enable
//Bit 18:12, delay go_field line number 
//Bit 11:10, component2 output switch, 00: select component0 in, 01: select component1 in, 10: select component2 in 
//Bit 9:8, component1 output switch, 00: select component0 in, 01: select component1 in, 10: select component2 in 
//Bit 7:6, component0 output switch, 00: select component0 in, 01: select component1 in, 10: select component2 in 
//Bit 5,   input window selection function enable
//Bit 4, enable VDIN common data input, otherwise there will be no video data input
//Bit 3:0 vdin selection, 1: mpeg_in from dram, 2: bt656 input, 3: component input, 4: tvdecoder input, 5: hdmi rx input, 6: digtial video input, 7: loopback from Viu1, 8: MIPI.
#define VDIN_COM_CTRL0                             ((0x1202  << 2) + 0xd0100000)
//Bit 28:16 active_max_pix_cnt, readonly
//Bit 12:0  active_max_pix_cnt_shadow, readonly
#define VDIN_ACTIVE_MAX_PIX_CNT_STATUS             ((0x1203  << 2) + 0xd0100000)
//Bit 28:16 go_line_cnt, readonly
//Bit 12:0  active_line_cnt, readonly
#define VDIN_LCNT_STATUS                           ((0x1204  << 2) + 0xd0100000)
//Readonly
//Bit [14:3] lfifo_buf_cnt
//Bit 2, vdin_direct_done status
//Bit 1, vdin_nr_done status
//Bit 0, field
#define VDIN_COM_STATUS0                           ((0x1205  << 2) + 0xd0100000)
//Readonly
//Bit 31, vdi4 fifo overflow
//Bit 29:24, vdi3_asfifo_cnt
//Bit 23, vdi3 fifo overflow
//Bit 21:16, vdi3_asfifo_cnt
//Bit 15, vdi2 fifo overflow
//Bit 13:8, vdi2_asfifo_cnt
//Bit 7, vdi1 fifo overflow
//Bit 5:0, vdi1_asfifo_cnt
#define VDIN_COM_STATUS1                           ((0x1206  << 2) + 0xd0100000)
//Bit 28:16 go_line_cnt_shadow, readonly
//Bit 12:0  active_line_cnt_shadow, readonly
#define VDIN_LCNT_SHADOW_STATUS                    ((0x1207  << 2) + 0xd0100000)
//each 8bit asfifo_ctrl is following:
//Bit 7, DE  enable 
//Bit 6, go field enable 
//Bit 5, go line enable 
//Bit 4, if true, negative active input vsync
//Bit 3, if true, negative active input hsync
//Bit 2, vsync soft reset fifo enable
//Bit 1, overflow status clear
//Bit 0 asfifo soft reset, level signal
//Bit 7:0 vdi1 asfifo_ctrl 
//Bit 23:16 vdi2 asfifo_ctrl 
#define VDIN_ASFIFO_CTRL0                          ((0x1208  << 2) + 0xd0100000)
//Bit 7:0 vdi3 asfifo_ctrl 
//Bit 23:16 vdi4 asfifo_ctrl 
#define VDIN_ASFIFO_CTRL1                          ((0x1209  << 2) + 0xd0100000)
//Bit 28:16 input width minus 1, after the window function
//Bit 12:0  output width minus 1
#define VDIN_WIDTHM1I_WIDTHM1O                     ((0x120a  << 2) + 0xd0100000)
//Bit 20:17 prehsc_mode, bit 3:2, prehsc odd line interp mode, bit 1:0, prehsc even line interp mode, 
//           each 2bit, 00: pix0+pix1/2, average, 01: pix1, 10: pix0
//Bit 16:15 sp422_mode, special mode for the component1 and component2, 00: normal case, 01: 32 64 32, 10: 0 64 64 0, 11: 16 96 16
//Bit 14:8, hsc_ini_pixi_ptr, signed data, only useful when short_lineo_en is true
//Bit 7, prehsc_en
//Bit 6, hsc_en,
//Bit 5, hsc_short_lineo_en, short line output enable
//Bit 4, hsc_nearest_en
//Bit 3, hsc_phase0_always_en
//Bit 2:0, hsc_bank_length
#define VDIN_SC_MISC_CTRL                          ((0x120b  << 2) + 0xd0100000)
//Bit 28:24, integer portion
//Bit 23:0, fraction portion
#define VDIN_HSC_PHASE_STEP                        ((0x120c  << 2) + 0xd0100000)
//Bit 30:29    hscale rpt_p0_num
//Bit 28:24    hscale ini_rcv_num
//Bit 23:0     hscale ini_phase
#define VDIN_HSC_INI_CTRL                          ((0x120d  << 2) + 0xd0100000)
//Read only
//Bit 23, vdi7 fifo overflow
//Bit 21:16, vdi7_asfifo_cnt
//Bit 15, vdi6 fifo overflow
//Bit 13:8, vdi6_asfifo_cnt
//Bit 7, vdi5 fifo overflow
//Bit 5:0, vdi5_asfifo_cnt
#define VDIN_COM_STATUS2                           ((0x120e  << 2) + 0xd0100000)
//Bit 25:16 asfifo decimate control
//Bit 25, if true, decimation counter sync with first valid DE in the field, 
//otherwise the decimation counter is not sync with external signal 
//Bit 24, decimation de enable
//Bit 23:20, decimation phase, which counter value use to decimate, 
//Bit 19:16, decimation number, 0: not decimation, 1: decimation 2, 2: decimation 3 .... 
//Bit 7:0 vdi5 asfifo_ctrl 
#define VDIN_ASFIFO_CTRL2                          ((0x120f  << 2) + 0xd0100000)
//Bit 7,  highlight_en
//Bit 6   probe_post, if true, probe pixel data after matrix, otherwise probe pixel data before matrix
//Bit 5:4  probe_sel, 00: select matrix 0, 01: select matrix 1,  otherwise select nothing 
//Bit 3:2, matrix coef idx selection, 00: select mat0, 01: select mat1, otherwise slect nothing 
//Bit 1   mat1 conversion matrix enable
//Bit 0   mat0 conversion matrix enable
#define VDIN_MATRIX_CTRL                           ((0x1210  << 2) + 0xd0100000)
//Bit 28:16 coef00
//Bit 12:0  coef01
#define VDIN_MATRIX_COEF00_01                      ((0x1211  << 2) + 0xd0100000)
//Bit 28:16 coef02 
//Bit 12:0  coef10 
#define VDIN_MATRIX_COEF02_10                      ((0x1212  << 2) + 0xd0100000)
//Bit 28:16 coef11
//Bit 12:0  coef12
#define VDIN_MATRIX_COEF11_12                      ((0x1213  << 2) + 0xd0100000)
//Bit 28:16 coef20
//Bit 12:0  coef21
#define VDIN_MATRIX_COEF20_21                      ((0x1214  << 2) + 0xd0100000)
#define VDIN_MATRIX_COEF22                         ((0x1215  << 2) + 0xd0100000)
//Bit 26:16 offset0
//Bit 10:0  offset1
#define VDIN_MATRIX_OFFSET0_1                      ((0x1216  << 2) + 0xd0100000)
//Bit 10:0  offset2
#define VDIN_MATRIX_OFFSET2                        ((0x1217  << 2) + 0xd0100000)
//Bit 26:16 pre_offset0
//Bit 10:0  pre_offset1
#define VDIN_MATRIX_PRE_OFFSET0_1                  ((0x1218  << 2) + 0xd0100000)
//Bit 10:0  pre_offset2
#define VDIN_MATRIX_PRE_OFFSET2                    ((0x1219  << 2) + 0xd0100000)
//12:0 lfifo_buf_size
#define VDIN_LFIFO_CTRL                            ((0x121a  << 2) + 0xd0100000)
#define VDIN_COM_GCLK_CTRL                         ((0x121b  << 2) + 0xd0100000)
//12:0 VDIN input interface width minus 1, before the window function, after the de decimation
#define VDIN_INTF_WIDTHM1                          ((0x121c  << 2) + 0xd0100000)
//Bit 15          //default== 0, urgent_ctrl_en
//Bit 14          //default== 0, urgent_wr, if true for write buffer
//Bit 13          //default== 0, out_inv_en
//Bit 12          //default == 0, urgent_ini_value
//Bit 11:6        //default == 0, up_th  up threshold
//Bit 5:0         //default == 0, dn_th  dn threshold
#define VDIN_LFIFO_URG_CTRL                        ((0x121e  << 2) + 0xd0100000)
//Bit 8, 1: discard data before line fifo, 0: normal mode
//Bit 7:0 Write chroma canvas address
#define VDIN_WR_CTRL2                              ((0x121f  << 2) + 0xd0100000)
//Bit 31:30 hconv_mode, Applicable only to bit[13:12]=0 or 2. 0: Output every even pixels' CbCr;
//                                                            1: Output every odd pixels' CbCr;
//                                                            2: Output an average value per even&odd pair of pixels;
//                                                            3: Output all CbCr. (This does NOT apply to bit[13:12]=0 -- 4:2:2 mode.)
//Bit 29 no_clk_gate: disable vid_wr_mif clock gating function.
//Bit 28 clear write response counter in the vdin write memory interface 
//Bit 27 eol_sel, 1: use eol as the line end indication, 0: use width as line end indication in the vdin write memory interface
//Bit 26 vcp_nr_en. Only used in VDIN0. NOT used in VDIN1.
//Bit 25 vcp_wr_en. Only used in VDIN0. NOT used in VDIN1.
//Bit 24 vcp_in_en. Only used in VDIN0. NOT used in VDIN1.
//Bit 23 vdin frame reset enble, if true, it will provide frame reset during go_field(vsync) to the modules after that 
//Bit 22 vdin line fifo soft reset enable, meaning, if true line fifo will reset during go_field (vsync)
//Bit 21 vdin direct write done status clear bit 
//Bit 20 vdin NR write done status clear bit 
//Bit 18 swap_cbcr. Applicable only to bit[13:12]=2. 0: Output CbCr (NV12); 1: Output CrCb (NV21).
//Bit 17:16 vconv_mode, Applicable only to bit[13:12]=2. 0: Output every even lines' CbCr;
//                                                       1: Output every odd lines' CbCr;
//                                                       2: Reserved;
//                                                       3: Output all CbCr.
//Bit 13:12 vdin write format, 0: 4:2:2 to luma canvas, 1: 4:4:4 to luma canvas,
//                             2: Y to luma canvas, CbCr to chroma canvas. For NV12/21, also define Bit 31:30, 17:16, and bit 18.
//Bit 11 vdin write canvas double buffer enable, means the canvas address will be latched by vsync before using 
//Bit 10 1: disable ctrl_reg write pulse which will reset internal counter. when bit 11 is 1, this bit should be 1.
//Bit 9 vdin write request urgent
//Bit 8 vdin write request enable
//Bit 7:0 Write luma canvas address
#define VDIN_WR_CTRL                               ((0x1220  << 2) + 0xd0100000)
//Bit 29, if true, horizontal reverse
//Bit 28:16 start
//Bit 12:0  end
#define VDIN_WR_H_START_END                        ((0x1221  << 2) + 0xd0100000)
//Bit 29, if true, vertical reverse
//Bit 28:16 start
//Bit 12:0  end
#define VDIN_WR_V_START_END                        ((0x1222  << 2) + 0xd0100000)
//Bit 24:20, integer portion
//Bit 19:0, fraction portion
#define VDIN_VSC_PHASE_STEP                        ((0x1223  << 2) + 0xd0100000)
//Bit 23, vsc_en, vertical scaler enable
//Bit 21 vsc_phase0_always_en, when scale up, you have to set it to 1
//Bit 20:16 ini skip_line_num
//Bit 15:0 vscaler ini_phase 
#define VDIN_VSC_INI_CTRL                          ((0x1224  << 2) + 0xd0100000)
//Bit 12:0, scaler input height minus 1
#define VDIN_SCIN_HEIGHTM1                         ((0x1225  << 2) + 0xd0100000)
//Bit 23:16, dummy component 0
//Bit 15:8, dummy component 1
//Bit 7:0, dummy component 2
#define VDIN_DUMMY_DATA                            ((0x1226  << 2) + 0xd0100000)
//Read only 
//Bit 29:20 component 0
//Bit 19:10 component 1
//Bit 9:0 component 2
#define VDIN_MATRIX_PROBE_COLOR                    ((0x1228  << 2) + 0xd0100000)
//Bit 23:16 component 0
//Bit 15:8  component 1
//Bit 7:0 component 2
#define VDIN_MATRIX_HL_COLOR                       ((0x1229  << 2) + 0xd0100000)
//28:16 probe x, postion
//12:0  probe y, position  
#define VDIN_MATRIX_PROBE_POS                      ((0x122a  << 2) + 0xd0100000)
#define VDIN_CHROMA_ADDR_PORT                      ((0x122b  << 2) + 0xd0100000)
#define VDIN_CHROMA_DATA_PORT                      ((0x122c  << 2) + 0xd0100000)
//
#define VDIN_CM_BRI_CON_CTRL                       ((0x122d  << 2) + 0xd0100000)
//Bit 17  clk_cyc_cnt_clr, if true, clear this register
//Bit 16 if true, use vpu clock to count one line, otherwise use actually hsync to count line_cnt 
//Bit 15:0   line width using vpu clk
#define VDIN_GO_LINE_CTRL                          ((0x122f  << 2) + 0xd0100000)
//Bit 10:9  ldim_stts_din_sel, 00: from matrix0 dout,  01: from vsc_dout, 10: from matrix1 dout, 11: form matrix1 din 
//Bit 8     ldim_stts_en
//Bit 6:5   hist_dnlp_low   the real pixels in each bins got by VDIN_DNLP_HISTXX should multiple with 2^(dnlp_low+3)
//Bit 3:2   hist_din_sel    the source used for hist statistics.  00: from matrix0 dout,  01: from vsc_dout, 10: from matrix1 dout, 11: form matrix1 din
//Bit 1     hist_win_en     1'b0: hist used for full picture; 1'b1: hist used for pixels within hist window
//Bit 0     hist_spl_en     1'b0: disable hist readback; 1'b1: enable hist readback
#define VDIN_HIST_CTRL                             ((0x1230  << 2) + 0xd0100000)
//Bit 28:16 hist_hstart  horizontal start value to define hist window
//Bit 12:0  hist_hend    horizontal end value to define hist window
#define VDIN_HIST_H_START_END                      ((0x1231  << 2) + 0xd0100000)
//Bit 28:16 hist_vstart  vertical start value to define hist window
//Bit 12:0  hist_vend    vertical end value to define hist window
#define VDIN_HIST_V_START_END                      ((0x1232  << 2) + 0xd0100000)
//Bit 15:8  hist_max    maximum value 
//Bit 7:0   hist_min    minimum value 
//read only
#define VDIN_HIST_MAX_MIN                          ((0x1233  << 2) + 0xd0100000)
//Bit 31:0  hist_spl_rd
//counts for the total luma value 
//read only
#define VDIN_HIST_SPL_VAL                          ((0x1234  << 2) + 0xd0100000)
//Bit 21:0  hist_spl_pixel_count
//counts for the total calculated pixels
//read only
#define VDIN_HIST_SPL_PIX_CNT                      ((0x1235  << 2) + 0xd0100000)
//Bit 31:0  hist_chroma_sum
//counts for the total chroma value 
//read only
#define VDIN_HIST_CHROMA_SUM                       ((0x1236  << 2) + 0xd0100000)
//Bit 31:16 higher hist bin
//Bit 15:0  lower hist bin
//0-255 are splited to 64 bins evenly, and VDIN_DNLP_HISTXX
//are the statistic number of pixels that within each bin.
//VDIN_DNLP_HIST00[15:0]  counts for the first  bin
//VDIN_DNLP_HIST00[31:16] counts for the second bin
//VDIN_DNLP_HIST01[15:0]  counts for the third  bin
//VDIN_DNLP_HIST01[31:16] counts for the fourth bin
//etc...
//read only
#define VDIN_DNLP_HIST00                           ((0x1237  << 2) + 0xd0100000)
#define VDIN_DNLP_HIST01                           ((0x1238  << 2) + 0xd0100000)
#define VDIN_DNLP_HIST02                           ((0x1239  << 2) + 0xd0100000)
#define VDIN_DNLP_HIST03                           ((0x123a  << 2) + 0xd0100000)
#define VDIN_DNLP_HIST04                           ((0x123b  << 2) + 0xd0100000)
#define VDIN_DNLP_HIST05                           ((0x123c  << 2) + 0xd0100000)
#define VDIN_DNLP_HIST06                           ((0x123d  << 2) + 0xd0100000)
#define VDIN_DNLP_HIST07                           ((0x123e  << 2) + 0xd0100000)
#define VDIN_DNLP_HIST08                           ((0x123f  << 2) + 0xd0100000)
#define VDIN_DNLP_HIST09                           ((0x1240  << 2) + 0xd0100000)
#define VDIN_DNLP_HIST10                           ((0x1241  << 2) + 0xd0100000)
#define VDIN_DNLP_HIST11                           ((0x1242  << 2) + 0xd0100000)
#define VDIN_DNLP_HIST12                           ((0x1243  << 2) + 0xd0100000)
#define VDIN_DNLP_HIST13                           ((0x1244  << 2) + 0xd0100000)
#define VDIN_DNLP_HIST14                           ((0x1245  << 2) + 0xd0100000)
#define VDIN_DNLP_HIST15                           ((0x1246  << 2) + 0xd0100000)
#define VDIN_DNLP_HIST16                           ((0x1247  << 2) + 0xd0100000)
#define VDIN_DNLP_HIST17                           ((0x1248  << 2) + 0xd0100000)
#define VDIN_DNLP_HIST18                           ((0x1249  << 2) + 0xd0100000)
#define VDIN_DNLP_HIST19                           ((0x124a  << 2) + 0xd0100000)
#define VDIN_DNLP_HIST20                           ((0x124b  << 2) + 0xd0100000)
#define VDIN_DNLP_HIST21                           ((0x124c  << 2) + 0xd0100000)
#define VDIN_DNLP_HIST22                           ((0x124d  << 2) + 0xd0100000)
#define VDIN_DNLP_HIST23                           ((0x124e  << 2) + 0xd0100000)
#define VDIN_DNLP_HIST24                           ((0x124f  << 2) + 0xd0100000)
#define VDIN_DNLP_HIST25                           ((0x1250  << 2) + 0xd0100000)
#define VDIN_DNLP_HIST26                           ((0x1251  << 2) + 0xd0100000)
#define VDIN_DNLP_HIST27                           ((0x1252  << 2) + 0xd0100000)
#define VDIN_DNLP_HIST28                           ((0x1253  << 2) + 0xd0100000)
#define VDIN_DNLP_HIST29                           ((0x1254  << 2) + 0xd0100000)
#define VDIN_DNLP_HIST30                           ((0x1255  << 2) + 0xd0100000)
#define VDIN_DNLP_HIST31                           ((0x1256  << 2) + 0xd0100000)
//Bit 31, local dimming statistic enable
//Bit 28, eol enable
//Bit 27:25, vertical line overlap number for max finding
//Bit 24:22, horizontal pixel overlap number, 0: 17 pix, 1: 9 pix, 2: 5 pix, 3: 3 pix, 4: 0 pix
//Bit 20, 1,2,1 low pass filter enable before max/hist statistic
//Bit 19:16, region H/V position index, refer to VDIN_LDIM_STTS_HIST_SET_REGION
//Bit 15, 1: region read index auto increase per read to VDIN_LDIM_STTS_HIST_READ_REGION 
//Bit 6:0, region read index
#define VDIN_LDIM_STTS_HIST_REGION_IDX             ((0x1257  << 2) + 0xd0100000)
//Bit 28:0, if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h0: read/write hvstart0
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h1: read/write hend01
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h2: read/write vend01
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h3: read/write hend23
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h4: read/write vend23
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h5: read/write hend45
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h6: read/write vend45
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'd7: read/write hend67
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h8: read/write vend67
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h9: read/write hend89
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'ha: read/write vend89
//hvstart0, Bit 28:16 row0 vstart, Bit 12:0 col0 hstart
//hend01, Bit 28:16 col1 hend, Bit 12:0 col0 hend
//vend01, Bit 28:16 row1 vend, Bit 12:0 row0 vend
//hend23, Bit 28:16 col3 hend, Bit 12:0 col2 hend
//vend23, Bit 28:16 row3 vend, Bit 12:0 row2 vend
//hend45, Bit 28:16 col5 hend, Bit 12:0 col4 hend
//vend45, Bit 28:16 row5 vend, Bit 12:0 row4 vend
//hend67, Bit 28:16 col7 hend, Bit 12:0 col6 hend
//vend67, Bit 28:16 row7 vend, Bit 12:0 row6 vend
//hend89, Bit 28:16 col9 hend, Bit 12:0 col8 hend
//vend89, Bit 28:16 row9 vend, Bit 12:0 row8 vend
#define VDIN_LDIM_STTS_HIST_SET_REGION             ((0x1258  << 2) + 0xd0100000)
//REGION STATISTIC DATA READ OUT PORT, bit 29:20 max_comp2, bit 19:10 max_comp1, bit 9:0 max_comp0
#define VDIN_LDIM_STTS_HIST_READ_REGION            ((0x1259  << 2) + 0xd0100000)
//Bit 18, reset bit, high active
//Bit 17, if true, widen hs/vs pulse
//Bit 16  vsync total counter always accumulating enable
//Bit 14:12, select hs/vs of video input channel to measure, 0: no selection, 1: vdi1, 2: vid2, 3: vid3, 4:vid4, 5:vdi5, 6:vid6, 7:vdi7, 8: vdi8
//Bit 11:4, vsync_span, define how many vsync span need to measure 
//Bit 2:0  meas_hs_index, index to select which HS counter/range
#define VDIN_MEAS_CTRL0                            ((0x125a  << 2) + 0xd0100000)
//Read only
//19:16     meas_ind_total_count_n, every number of sync_span vsyncs, this count add 1
//15:0      high bit portion of vsync total counter
#define VDIN_MEAS_VS_COUNT_HI                      ((0x125b  << 2) + 0xd0100000)
//Read only
//31:0, low bit portion of vsync total counter 
#define VDIN_MEAS_VS_COUNT_LO                      ((0x125c  << 2) + 0xd0100000)
//according to the meas_hs_index in register VDIN_MEAS_CTRL0
//meas_hs_index == 0, first hs range
//meas_hs_index == 1, second hs range
//meas_hs_index == 2, third hs range
//meas_hs_index == 3, fourth hs range 
//bit 28:16 count_start
//bit 12:0 count_end
#define VDIN_MEAS_HS_RANGE                         ((0x125d  << 2) + 0xd0100000)
//Read only
//according to the meas_hs_index in register VDIN_MEAS_CTRL0,
//meas_hs_index == 0, first range hs counter,
//meas_hs_index == 1, second range hs coutner
//meas_hs_index == 2, third range hs coutner
//meas_hs_index == 3, fourth range hs coutner
//23:0
#define VDIN_MEAS_HS_COUNT                         ((0x125e  << 2) + 0xd0100000)
//Bit 8      white_enable
//Bit 7:0    blkbar_white_level
#define VDIN_BLKBAR_CTRL1                          ((0x125f  << 2) + 0xd0100000)
// Bit 31:24 blkbar_black_level    threshold to judge a black point
// Bit 23:21 Reserved
// Bit 20:8  blkbar_hwidth         left and right region width
// Bit 7:5   blkbar_comp_sel       select yin or uin or vin to be the valid input
// Bit 4     blkbar_sw_statistic_en enable software statistic of each block black points number
// Bit 3     blkbar_det_en       
// Bit 2:1   blkbar_din_sel        
// bit blkbar_det_top_en
#define VDIN_BLKBAR_CTRL0                          ((0x1260  << 2) + 0xd0100000)
// Bit 31:29 Reserved
// Bit 28:16 blkbar_hstart.        Left region start
// Bit 15:13 Reserved
// Bit 12:0  blkbar_hend.          Right region end
#define VDIN_BLKBAR_H_START_END                    ((0x1261  << 2) + 0xd0100000)
// Bit 31:29 Reserved
// Bit 28:16 blkbar_vstart        
// Bit 15:13 Reserved
// Bit 12:0  blkbar_vend
#define VDIN_BLKBAR_V_START_END                    ((0x1262  << 2) + 0xd0100000)
// Bit 31:20 Reserved
// Bit 19:0  blkbar_cnt_threshold. threshold to judge whether a block is totally black  
#define VDIN_BLKBAR_CNT_THRESHOLD                  ((0x1263  << 2) + 0xd0100000)
// Bit 31:29 Reserved
// Bit 28:16 blkbar_row_th1.       //threshold of the top blackbar
// Bit 15:13 Reserved
// bit 12:0  blkbar_row_th2        //threshold of the bottom blackbar
#define VDIN_BLKBAR_ROW_TH1_TH2                    ((0x1264  << 2) + 0xd0100000)
//Readonly
// Bit 31:29 Reserved
// Bit 28:16 blkbar_ind_left_start. horizontal start of the left region in the current searching
// Bit 15:13 Reserved
// Bit 12:0  blkbar_ind_left_end.   horizontal end of the left region in the current searching
#define VDIN_BLKBAR_IND_LEFT_START_END             ((0x1265  << 2) + 0xd0100000)
//Readonly
// Bit 31:29 Reserved
// Bit 28:16 blkbar_ind_right_start.horizontal start of the right region in the current searching
// Bit 15:13 Reserved
// Bit 12:0  blkbar_ind_right_end.  horizontal end of the right region in the current searching
#define VDIN_BLKBAR_IND_RIGHT_START_END            ((0x1266  << 2) + 0xd0100000)
//Readonly
// Bit 31:20 Reserved
// Bit 19:0  blkbar_ind_left1_cnt.  Black pixel counter. left part of the left region
#define VDIN_BLKBAR_IND_LEFT1_CNT                  ((0x1267  << 2) + 0xd0100000)
//Readonly
// Bit 31:20 Reserved
// Bit 19:0  blkbar_ind_left2_cnt.  Black pixel counter. right part of the left region
#define VDIN_BLKBAR_IND_LEFT2_CNT                  ((0x1268  << 2) + 0xd0100000)
//Readonly
// Bit 31:20 Reserved
// Bit 19:0  blkbar_ind_right1_cnt. Black pixel counter. left part of the right region
#define VDIN_BLKBAR_IND_RIGHT1_CNT                 ((0x1269  << 2) + 0xd0100000)
//Readonly
// Bit 31:20 Reserved
// Bit 19:0  blkbar_ind_right2_cnt. Black pixel counter. right part of the right region
#define VDIN_BLKBAR_IND_RIGHT2_CNT                 ((0x126a  << 2) + 0xd0100000)
//Readonly
// Bit 31:30 Resersed
// Bit 29    blkbar_ind_black_det_done. LEFT/RIGHT Black detection done
// Bit 28:16 blkbar_top_pos.            Top black bar position
// Bit 15:13 Reserved.
// Bit 12:0  blkbar_bot_pos.            Bottom black bar position
#define VDIN_BLKBAR_STATUS0                        ((0x126b  << 2) + 0xd0100000)
//Readonly
// Bit 31:29 Reserved
// Bit 28:16 blkbar_left_pos.       Left black bar posiont
// Bit 15:13 Reserved
// Bit 12:0  blkbar_right_pos.      Right black bar position
#define VDIN_BLKBAR_STATUS1                        ((0x126c  << 2) + 0xd0100000)
//Bit 28:16 input window H start
//Bit 12:0  input window H end
#define VDIN_WIN_H_START_END                       ((0x126d  << 2) + 0xd0100000)
//Bit 28:16 input window H start
//Bit 12:0  input window V start
#define VDIN_WIN_V_START_END                       ((0x126e  << 2) + 0xd0100000)
//Bit 23:16 vdi8 asfifo_ctrl 
//Bit 15:8 vdi7 asfifo_ctrl 
//Bit 7:0 vdi6 asfifo_ctrl 
#define VDIN_ASFIFO_CTRL3                          ((0x126f  << 2) + 0xd0100000)

//VDIN0        8'h00 - 8'h7f
#define VDIN0_SCALE_COEF_IDX                    ((VDIN0_OFFSET << 2) + VDIN_SCALE_COEF_IDX               )
#define VDIN0_SCALE_COEF                        ((VDIN0_OFFSET << 2) + VDIN_SCALE_COEF                   )
#define VDIN0_COM_CTRL0                         ((VDIN0_OFFSET << 2) + VDIN_COM_CTRL0                    )
#define VDIN0_ACTIVE_MAX_PIX_CNT_STATUS         ((VDIN0_OFFSET << 2) + VDIN_ACTIVE_MAX_PIX_CNT_STATUS    )
#define VDIN0_LCNT_STATUS                       ((VDIN0_OFFSET << 2) + VDIN_LCNT_STATUS                  )
#define VDIN0_COM_STATUS0                       ((VDIN0_OFFSET << 2) + VDIN_COM_STATUS0                  )
#define VDIN0_COM_STATUS1                       ((VDIN0_OFFSET << 2) + VDIN_COM_STATUS1                  )
#define VDIN0_LCNT_SHADOW_STATUS                ((VDIN0_OFFSET << 2) + VDIN_LCNT_SHADOW_STATUS           )
#define VDIN0_ASFIFO_CTRL0                      ((VDIN0_OFFSET << 2) + VDIN_ASFIFO_CTRL0                 )
#define VDIN0_ASFIFO_CTRL1                      ((VDIN0_OFFSET << 2) + VDIN_ASFIFO_CTRL1                 )
#define VDIN0_WIDTHM1I_WIDTHM1O                 ((VDIN0_OFFSET << 2) + VDIN_WIDTHM1I_WIDTHM1O            )
#define VDIN0_SC_MISC_CTRL                      ((VDIN0_OFFSET << 2) + VDIN_SC_MISC_CTRL                 )
#define VDIN0_HSC_PHASE_STEP                    ((VDIN0_OFFSET << 2) + VDIN_HSC_PHASE_STEP               )
#define VDIN0_HSC_INI_CTRL                      ((VDIN0_OFFSET << 2) + VDIN_HSC_INI_CTRL                 )
#define VDIN0_COM_STATUS2                       ((VDIN0_OFFSET << 2) + VDIN_COM_STATUS2                  )
#define VDIN0_ASFIFO_CTRL2                      ((VDIN0_OFFSET << 2) + VDIN_ASFIFO_CTRL2                 )
#define VDIN0_MATRIX_CTRL                       ((VDIN0_OFFSET << 2) + VDIN_MATRIX_CTRL                  )
#define VDIN0_MATRIX_COEF00_01                  ((VDIN0_OFFSET << 2) + VDIN_MATRIX_COEF00_01             )
#define VDIN0_MATRIX_COEF02_10                  ((VDIN0_OFFSET << 2) + VDIN_MATRIX_COEF02_10             )
#define VDIN0_MATRIX_COEF11_12                  ((VDIN0_OFFSET << 2) + VDIN_MATRIX_COEF11_12             )
#define VDIN0_MATRIX_COEF20_21                  ((VDIN0_OFFSET << 2) + VDIN_MATRIX_COEF20_21             )
#define VDIN0_MATRIX_COEF22                     ((VDIN0_OFFSET << 2) + VDIN_MATRIX_COEF22                )
#define VDIN0_MATRIX_OFFSET0_1                  ((VDIN0_OFFSET << 2) + VDIN_MATRIX_OFFSET0_1             )
#define VDIN0_MATRIX_OFFSET2                    ((VDIN0_OFFSET << 2) + VDIN_MATRIX_OFFSET2               )
#define VDIN0_MATRIX_PRE_OFFSET0_1              ((VDIN0_OFFSET << 2) + VDIN_MATRIX_PRE_OFFSET0_1         )
#define VDIN0_MATRIX_PRE_OFFSET2                ((VDIN0_OFFSET << 2) + VDIN_MATRIX_PRE_OFFSET2           )
#define VDIN0_LFIFO_CTRL                        ((VDIN0_OFFSET << 2) + VDIN_LFIFO_CTRL                   )
#define VDIN0_COM_GCLK_CTRL                     ((VDIN0_OFFSET << 2) + VDIN_COM_GCLK_CTRL                )
#define VDIN0_INTF_WIDTHM1                      ((VDIN0_OFFSET << 2) + VDIN_INTF_WIDTHM1                 )
#define VDIN0_WR_CTRL2                          ((VDIN0_OFFSET << 2) + VDIN_WR_CTRL2                     )
#define VDIN0_WR_CTRL                           ((VDIN0_OFFSET << 2) + VDIN_WR_CTRL                      )
#define VDIN0_WR_H_START_END                    ((VDIN0_OFFSET << 2) + VDIN_WR_H_START_END               )
#define VDIN0_WR_V_START_END                    ((VDIN0_OFFSET << 2) + VDIN_WR_V_START_END               )
#define VDIN0_VSC_PHASE_STEP                    ((VDIN0_OFFSET << 2) + VDIN_VSC_PHASE_STEP               )
#define VDIN0_VSC_INI_CTRL                      ((VDIN0_OFFSET << 2) + VDIN_VSC_INI_CTRL                 )
#define VDIN0_SCIN_HEIGHTM1                     ((VDIN0_OFFSET << 2) + VDIN_SCIN_HEIGHTM1                )
#define VDIN0_DUMMY_DATA                        ((VDIN0_OFFSET << 2) + VDIN_DUMMY_DATA                   )
#define VDIN0_MATRIX_PROBE_COLOR                ((VDIN0_OFFSET << 2) + VDIN_MATRIX_PROBE_COLOR           )
#define VDIN0_MATRIX_HL_COLOR                   ((VDIN0_OFFSET << 2) + VDIN_MATRIX_HL_COLOR              )
#define VDIN0_MATRIX_PROBE_POS                  ((VDIN0_OFFSET << 2) + VDIN_MATRIX_PROBE_POS             )
#define VDIN0_CHROMA_ADDR_PORT                  ((VDIN0_OFFSET << 2) + VDIN_CHROMA_ADDR_PORT             )
#define VDIN0_CHROMA_DATA_PORT                  ((VDIN0_OFFSET << 2) + VDIN_CHROMA_DATA_PORT             )
#define VDIN0_CM_BRI_CON_CTRL                   ((VDIN0_OFFSET << 2) + VDIN_CM_BRI_CON_CTRL              )
#define VDIN0_HIST_CTRL                         ((VDIN0_OFFSET << 2) + VDIN_HIST_CTRL                    )
#define VDIN0_HIST_H_START_END                  ((VDIN0_OFFSET << 2) + VDIN_HIST_H_START_END             )
#define VDIN0_HIST_V_START_END                  ((VDIN0_OFFSET << 2) + VDIN_HIST_V_START_END             )
#define VDIN0_HIST_MAX_MIN                      ((VDIN0_OFFSET << 2) + VDIN_HIST_MAX_MIN                 )
#define VDIN0_HIST_SPL_VAL                      ((VDIN0_OFFSET << 2) + VDIN_HIST_SPL_VAL                 )
#define VDIN0_HIST_SPL_PIX_CNT                  ((VDIN0_OFFSET << 2) + VDIN_HIST_SPL_PIX_CNT             )
#define VDIN0_HIST_CHROMA_SUM                   ((VDIN0_OFFSET << 2) + VDIN_HIST_CHROMA_SUM              )
#define VDIN0_DNLP_HIST00                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST00                  )
#define VDIN0_DNLP_HIST01                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST01                  )
#define VDIN0_DNLP_HIST02                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST02                  )
#define VDIN0_DNLP_HIST03                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST03                  )
#define VDIN0_DNLP_HIST04                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST04                  )
#define VDIN0_DNLP_HIST05                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST05                  )
#define VDIN0_DNLP_HIST06                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST06                  )
#define VDIN0_DNLP_HIST07                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST07                  )
#define VDIN0_DNLP_HIST08                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST08                  )
#define VDIN0_DNLP_HIST09                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST09                  )
#define VDIN0_DNLP_HIST10                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST10                  )
#define VDIN0_DNLP_HIST11                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST11                  )
#define VDIN0_DNLP_HIST12                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST12                  )
#define VDIN0_DNLP_HIST13                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST13                  )
#define VDIN0_DNLP_HIST14                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST14                  )
#define VDIN0_DNLP_HIST15                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST15                  )
#define VDIN0_DNLP_HIST16                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST16                  )
#define VDIN0_DNLP_HIST17                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST17                  )
#define VDIN0_DNLP_HIST18                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST18                  )
#define VDIN0_DNLP_HIST19                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST19                  )
#define VDIN0_DNLP_HIST20                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST20                  )
#define VDIN0_DNLP_HIST21                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST21                  )
#define VDIN0_DNLP_HIST22                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST22                  )
#define VDIN0_DNLP_HIST23                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST23                  )
#define VDIN0_DNLP_HIST24                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST24                  )
#define VDIN0_DNLP_HIST25                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST25                  )
#define VDIN0_DNLP_HIST26                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST26                  )
#define VDIN0_DNLP_HIST27                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST27                  )
#define VDIN0_DNLP_HIST28                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST28                  )
#define VDIN0_DNLP_HIST29                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST29                  )
#define VDIN0_DNLP_HIST30                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST30                  )
#define VDIN0_DNLP_HIST31                       ((VDIN0_OFFSET << 2) + VDIN_DNLP_HIST31                  )
#define VDIN0_LDIM_STTS_HIST_REGION_IDX         ((VDIN0_OFFSET << 2) + VDIN_LDIM_STTS_HIST_REGION_IDX    )
#define VDIN0_LDIM_STTS_HIST_SET_REGION         ((VDIN0_OFFSET << 2) + VDIN_LDIM_STTS_HIST_SET_REGION    )
#define VDIN0_LDIM_STTS_HIST_READ_REGION        ((VDIN0_OFFSET << 2) + VDIN_LDIM_STTS_HIST_READ_REGION   )
#define VDIN0_MEAS_CTRL0                        ((VDIN0_OFFSET << 2) + VDIN_MEAS_CTRL0                   )
#define VDIN0_MEAS_VS_COUNT_HI                  ((VDIN0_OFFSET << 2) + VDIN_MEAS_VS_COUNT_HI             )
#define VDIN0_MEAS_VS_COUNT_LO                  ((VDIN0_OFFSET << 2) + VDIN_MEAS_VS_COUNT_LO             )
#define VDIN0_MEAS_HS_RANGE                     ((VDIN0_OFFSET << 2) + VDIN_MEAS_HS_RANGE                )
#define VDIN0_MEAS_HS_COUNT                     ((VDIN0_OFFSET << 2) + VDIN_MEAS_HS_COUNT                )
#define VDIN0_BLKBAR_CTRL1                      ((VDIN0_OFFSET << 2) + VDIN_BLKBAR_CTRL1                 )
#define VDIN0_BLKBAR_CTRL0                      ((VDIN0_OFFSET << 2) + VDIN_BLKBAR_CTRL0                 )
#define VDIN0_BLKBAR_H_START_END                ((VDIN0_OFFSET << 2) + VDIN_BLKBAR_H_START_END           )
#define VDIN0_BLKBAR_V_START_END                ((VDIN0_OFFSET << 2) + VDIN_BLKBAR_V_START_END           )
#define VDIN0_BLKBAR_CNT_THRESHOLD              ((VDIN0_OFFSET << 2) + VDIN_BLKBAR_CNT_THRESHOLD         )
#define VDIN0_BLKBAR_ROW_TH1_TH2                ((VDIN0_OFFSET << 2) + VDIN_BLKBAR_ROW_TH1_TH2           )
#define VDIN0_BLKBAR_IND_LEFT_START_END         ((VDIN0_OFFSET << 2) + VDIN_BLKBAR_IND_LEFT_START_END    )
#define VDIN0_BLKBAR_IND_RIGHT_START_END        ((VDIN0_OFFSET << 2) + VDIN_BLKBAR_IND_RIGHT_START_END   )
#define VDIN0_BLKBAR_IND_LEFT1_CNT              ((VDIN0_OFFSET << 2) + VDIN_BLKBAR_IND_LEFT1_CNT         )
#define VDIN0_BLKBAR_IND_LEFT2_CNT              ((VDIN0_OFFSET << 2) + VDIN_BLKBAR_IND_LEFT2_CNT         )
#define VDIN0_BLKBAR_IND_RIGHT1_CNT             ((VDIN0_OFFSET << 2) + VDIN_BLKBAR_IND_RIGHT1_CNT        )
#define VDIN0_BLKBAR_IND_RIGHT2_CNT             ((VDIN0_OFFSET << 2) + VDIN_BLKBAR_IND_RIGHT2_CNT        )
#define VDIN0_BLKBAR_STATUS0                    ((VDIN0_OFFSET << 2) + VDIN_BLKBAR_STATUS0               )
#define VDIN0_BLKBAR_STATUS1                    ((VDIN0_OFFSET << 2) + VDIN_BLKBAR_STATUS1               )
#define VDIN0_WIN_H_START_END                   ((VDIN0_OFFSET << 2) + VDIN_WIN_H_START_END              )
#define VDIN0_WIN_V_START_END                   ((VDIN0_OFFSET << 2) + VDIN_WIN_V_START_END              )
#define VDIN0_ASFIFO_CTRL3                      ((VDIN0_OFFSET << 2) + VDIN_ASFIFO_CTRL3                 )

//VDIN1        8'h70 - 8'hdf
#define VDIN1_SCALE_COEF_IDX                    ((VDIN1_OFFSET << 2) + VDIN_SCALE_COEF_IDX               )
#define VDIN1_SCALE_COEF                        ((VDIN1_OFFSET << 2) + VDIN_SCALE_COEF                   )
#define VDIN1_COM_CTRL0                         ((VDIN1_OFFSET << 2) + VDIN_COM_CTRL0                    )
#define VDIN1_ACTIVE_MAX_PIX_CNT_STATUS         ((VDIN1_OFFSET << 2) + VDIN_ACTIVE_MAX_PIX_CNT_STATUS    )
#define VDIN1_LCNT_STATUS                       ((VDIN1_OFFSET << 2) + VDIN_LCNT_STATUS                  )
#define VDIN1_COM_STATUS0                       ((VDIN1_OFFSET << 2) + VDIN_COM_STATUS0                  )
#define VDIN1_COM_STATUS1                       ((VDIN1_OFFSET << 2) + VDIN_COM_STATUS1                  )
#define VDIN1_LCNT_SHADOW_STATUS                ((VDIN1_OFFSET << 2) + VDIN_LCNT_SHADOW_STATUS           )
#define VDIN1_ASFIFO_CTRL0                      ((VDIN1_OFFSET << 2) + VDIN_ASFIFO_CTRL0                 )
#define VDIN1_ASFIFO_CTRL1                      ((VDIN1_OFFSET << 2) + VDIN_ASFIFO_CTRL1                 )
#define VDIN1_WIDTHM1I_WIDTHM1O                 ((VDIN1_OFFSET << 2) + VDIN_WIDTHM1I_WIDTHM1O            )
#define VDIN1_SC_MISC_CTRL                      ((VDIN1_OFFSET << 2) + VDIN_SC_MISC_CTRL                 )
#define VDIN1_HSC_PHASE_STEP                    ((VDIN1_OFFSET << 2) + VDIN_HSC_PHASE_STEP               )
#define VDIN1_HSC_INI_CTRL                      ((VDIN1_OFFSET << 2) + VDIN_HSC_INI_CTRL                 )
#define VDIN1_COM_STATUS2                       ((VDIN1_OFFSET << 2) + VDIN_COM_STATUS2                  )
#define VDIN1_ASFIFO_CTRL2                      ((VDIN1_OFFSET << 2) + VDIN_ASFIFO_CTRL2                 )
#define VDIN1_MATRIX_CTRL                       ((VDIN1_OFFSET << 2) + VDIN_MATRIX_CTRL                  )
#define VDIN1_MATRIX_COEF00_01                  ((VDIN1_OFFSET << 2) + VDIN_MATRIX_COEF00_01             )
#define VDIN1_MATRIX_COEF02_10                  ((VDIN1_OFFSET << 2) + VDIN_MATRIX_COEF02_10             )
#define VDIN1_MATRIX_COEF11_12                  ((VDIN1_OFFSET << 2) + VDIN_MATRIX_COEF11_12             )
#define VDIN1_MATRIX_COEF20_21                  ((VDIN1_OFFSET << 2) + VDIN_MATRIX_COEF20_21             )
#define VDIN1_MATRIX_COEF22                     ((VDIN1_OFFSET << 2) + VDIN_MATRIX_COEF22                )
#define VDIN1_MATRIX_OFFSET0_1                  ((VDIN1_OFFSET << 2) + VDIN_MATRIX_OFFSET0_1             )
#define VDIN1_MATRIX_OFFSET2                    ((VDIN1_OFFSET << 2) + VDIN_MATRIX_OFFSET2               )
#define VDIN1_MATRIX_PRE_OFFSET0_1              ((VDIN1_OFFSET << 2) + VDIN_MATRIX_PRE_OFFSET0_1         )
#define VDIN1_MATRIX_PRE_OFFSET2                ((VDIN1_OFFSET << 2) + VDIN_MATRIX_PRE_OFFSET2           )
#define VDIN1_LFIFO_CTRL                        ((VDIN1_OFFSET << 2) + VDIN_LFIFO_CTRL                   )
#define VDIN1_COM_GCLK_CTRL                     ((VDIN1_OFFSET << 2) + VDIN_COM_GCLK_CTRL                )
#define VDIN1_INTF_WIDTHM1                      ((VDIN1_OFFSET << 2) + VDIN_INTF_WIDTHM1                 )
#define VDIN1_WR_CTRL2                          ((VDIN1_OFFSET << 2) + VDIN_WR_CTRL2                     )
#define VDIN1_WR_CTRL                           ((VDIN1_OFFSET << 2) + VDIN_WR_CTRL                      )
#define VDIN1_WR_H_START_END                    ((VDIN1_OFFSET << 2) + VDIN_WR_H_START_END               )
#define VDIN1_WR_V_START_END                    ((VDIN1_OFFSET << 2) + VDIN_WR_V_START_END               )
#define VDIN1_VSC_PHASE_STEP                    ((VDIN1_OFFSET << 2) + VDIN_VSC_PHASE_STEP               )
#define VDIN1_VSC_INI_CTRL                      ((VDIN1_OFFSET << 2) + VDIN_VSC_INI_CTRL                 )
#define VDIN1_SCIN_HEIGHTM1                     ((VDIN1_OFFSET << 2) + VDIN_SCIN_HEIGHTM1                )
#define VDIN1_DUMMY_DATA                        ((VDIN1_OFFSET << 2) + VDIN_DUMMY_DATA                   )
#define VDIN1_MATRIX_PROBE_COLOR                ((VDIN1_OFFSET << 2) + VDIN_MATRIX_PROBE_COLOR           )
#define VDIN1_MATRIX_HL_COLOR                   ((VDIN1_OFFSET << 2) + VDIN_MATRIX_HL_COLOR              )
#define VDIN1_MATRIX_PROBE_POS                  ((VDIN1_OFFSET << 2) + VDIN_MATRIX_PROBE_POS             )
#define VDIN1_CHROMA_ADDR_PORT                  ((VDIN1_OFFSET << 2) + VDIN_CHROMA_ADDR_PORT             )
#define VDIN1_CHROMA_DATA_PORT                  ((VDIN1_OFFSET << 2) + VDIN_CHROMA_DATA_PORT             )
#define VDIN1_CM_BRI_CON_CTRL                   ((VDIN1_OFFSET << 2) + VDIN_CM_BRI_CON_CTRL              )
#define VDIN1_HIST_CTRL                         ((VDIN1_OFFSET << 2) + VDIN_HIST_CTRL                    )
#define VDIN1_HIST_H_START_END                  ((VDIN1_OFFSET << 2) + VDIN_HIST_H_START_END             )
#define VDIN1_HIST_V_START_END                  ((VDIN1_OFFSET << 2) + VDIN_HIST_V_START_END             )
#define VDIN1_HIST_MAX_MIN                      ((VDIN1_OFFSET << 2) + VDIN_HIST_MAX_MIN                 )
#define VDIN1_HIST_SPL_VAL                      ((VDIN1_OFFSET << 2) + VDIN_HIST_SPL_VAL                 )
#define VDIN1_HIST_SPL_PIX_CNT                  ((VDIN1_OFFSET << 2) + VDIN_HIST_SPL_PIX_CNT             )
#define VDIN1_HIST_CHROMA_SUM                   ((VDIN1_OFFSET << 2) + VDIN_HIST_CHROMA_SUM              )
#define VDIN1_DNLP_HIST00                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST00                  )
#define VDIN1_DNLP_HIST01                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST01                  )
#define VDIN1_DNLP_HIST02                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST02                  )
#define VDIN1_DNLP_HIST03                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST03                  )
#define VDIN1_DNLP_HIST04                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST04                  )
#define VDIN1_DNLP_HIST05                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST05                  )
#define VDIN1_DNLP_HIST06                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST06                  )
#define VDIN1_DNLP_HIST07                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST07                  )
#define VDIN1_DNLP_HIST08                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST08                  )
#define VDIN1_DNLP_HIST09                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST09                  )
#define VDIN1_DNLP_HIST10                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST10                  )
#define VDIN1_DNLP_HIST11                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST11                  )
#define VDIN1_DNLP_HIST12                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST12                  )
#define VDIN1_DNLP_HIST13                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST13                  )
#define VDIN1_DNLP_HIST14                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST14                  )
#define VDIN1_DNLP_HIST15                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST15                  )
#define VDIN1_DNLP_HIST16                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST16                  )
#define VDIN1_DNLP_HIST17                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST17                  )
#define VDIN1_DNLP_HIST18                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST18                  )
#define VDIN1_DNLP_HIST19                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST19                  )
#define VDIN1_DNLP_HIST20                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST20                  )
#define VDIN1_DNLP_HIST21                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST21                  )
#define VDIN1_DNLP_HIST22                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST22                  )
#define VDIN1_DNLP_HIST23                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST23                  )
#define VDIN1_DNLP_HIST24                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST24                  )
#define VDIN1_DNLP_HIST25                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST25                  )
#define VDIN1_DNLP_HIST26                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST26                  )
#define VDIN1_DNLP_HIST27                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST27                  )
#define VDIN1_DNLP_HIST28                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST28                  )
#define VDIN1_DNLP_HIST29                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST29                  )
#define VDIN1_DNLP_HIST30                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST30                  )
#define VDIN1_DNLP_HIST31                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST31                  )
#define VDIN1_LDIM_STTS_HIST_REGION_IDX         ((VDIN1_OFFSET << 2) + VDIN_LDIM_STTS_HIST_REGION_IDX    )
#define VDIN1_LDIM_STTS_HIST_SET_REGION         ((VDIN1_OFFSET << 2) + VDIN_LDIM_STTS_HIST_SET_REGION    )
#define VDIN1_LDIM_STTS_HIST_READ_REGION        ((VDIN1_OFFSET << 2) + VDIN_LDIM_STTS_HIST_READ_REGION   )
#define VDIN1_MEAS_CTRL0                        ((VDIN1_OFFSET << 2) + VDIN_MEAS_CTRL0                   )
#define VDIN1_MEAS_VS_COUNT_HI                  ((VDIN1_OFFSET << 2) + VDIN_MEAS_VS_COUNT_HI             )
#define VDIN1_MEAS_VS_COUNT_LO                  ((VDIN1_OFFSET << 2) + VDIN_MEAS_VS_COUNT_LO             )
#define VDIN1_MEAS_HS_RANGE                     ((VDIN1_OFFSET << 2) + VDIN_MEAS_HS_RANGE                )
#define VDIN1_MEAS_HS_COUNT                     ((VDIN1_OFFSET << 2) + VDIN_MEAS_HS_COUNT                )
#define VDIN1_BLKBAR_CTRL1                      ((VDIN1_OFFSET << 2) + VDIN_BLKBAR_CTRL1                 )
#define VDIN1_BLKBAR_CTRL0                      ((VDIN1_OFFSET << 2) + VDIN_BLKBAR_CTRL0                 )
#define VDIN1_BLKBAR_H_START_END                ((VDIN1_OFFSET << 2) + VDIN_BLKBAR_H_START_END           )
#define VDIN1_BLKBAR_V_START_END                ((VDIN1_OFFSET << 2) + VDIN_BLKBAR_V_START_END           )
#define VDIN1_BLKBAR_CNT_THRESHOLD              ((VDIN1_OFFSET << 2) + VDIN_BLKBAR_CNT_THRESHOLD         )
#define VDIN1_BLKBAR_ROW_TH1_TH2                ((VDIN1_OFFSET << 2) + VDIN_BLKBAR_ROW_TH1_TH2           )
#define VDIN1_BLKBAR_IND_LEFT_START_END         ((VDIN1_OFFSET << 2) + VDIN_BLKBAR_IND_LEFT_START_END    )
#define VDIN1_BLKBAR_IND_RIGHT_START_END        ((VDIN1_OFFSET << 2) + VDIN_BLKBAR_IND_RIGHT_START_END   )
#define VDIN1_BLKBAR_IND_LEFT1_CNT              ((VDIN1_OFFSET << 2) + VDIN_BLKBAR_IND_LEFT1_CNT         )
#define VDIN1_BLKBAR_IND_LEFT2_CNT              ((VDIN1_OFFSET << 2) + VDIN_BLKBAR_IND_LEFT2_CNT         )
#define VDIN1_BLKBAR_IND_RIGHT1_CNT             ((VDIN1_OFFSET << 2) + VDIN_BLKBAR_IND_RIGHT1_CNT        )
#define VDIN1_BLKBAR_IND_RIGHT2_CNT             ((VDIN1_OFFSET << 2) + VDIN_BLKBAR_IND_RIGHT2_CNT        )
#define VDIN1_BLKBAR_STATUS0                    ((VDIN1_OFFSET << 2) + VDIN_BLKBAR_STATUS0               )
#define VDIN1_BLKBAR_STATUS1                    ((VDIN1_OFFSET << 2) + VDIN_BLKBAR_STATUS1               )
#define VDIN1_WIN_H_START_END                   ((VDIN1_OFFSET << 2) + VDIN_WIN_H_START_END              )
#define VDIN1_WIN_V_START_END                   ((VDIN1_OFFSET << 2) + VDIN_WIN_V_START_END              )
#define VDIN1_ASFIFO_CTRL3                      ((VDIN1_OFFSET << 2) + VDIN_ASFIFO_CTRL3                 )

//`define LCD_VCBUS_BASE               8'h14
//
// Reading file:  lcd_regs.h
//
// -----------------------------------------------
// CBUS_BASE:  LCD_VCBUS_BASE = 0x14
// -----------------------------------------------
//========================================================================
//LCD DRV     12'h480~12'h4ef
//=======================================================================
#define L_GAMMA_CNTL_PORT                          ((0x1400  << 2) + 0xd0100000)
#define L_GAMMA_DATA_PORT                          ((0x1401  << 2) + 0xd0100000)
#define L_GAMMA_ADDR_PORT                          ((0x1402  << 2) + 0xd0100000)
#define L_GAMMA_VCOM_HSWITCH_ADDR                  ((0x1403  << 2) + 0xd0100000)
#define L_RGB_BASE_ADDR                            ((0x1405  << 2) + 0xd0100000)
#define L_RGB_COEFF_ADDR                           ((0x1406  << 2) + 0xd0100000)
#define L_POL_CNTL_ADDR                            ((0x1407  << 2) + 0xd0100000)
#define L_DITH_CNTL_ADDR                           ((0x1408  << 2) + 0xd0100000)
#define L_GAMMA_PROBE_CTRL                         ((0x1409  << 2) + 0xd0100000)
//read only
#define L_GAMMA_PROBE_COLOR_L                      ((0x140a  << 2) + 0xd0100000)
#define L_GAMMA_PROBE_COLOR_H                      ((0x140b  << 2) + 0xd0100000)
#define L_GAMMA_PROBE_HL_COLOR                     ((0x140c  << 2) + 0xd0100000)
#define L_GAMMA_PROBE_POS_X                        ((0x140d  << 2) + 0xd0100000)
#define L_GAMMA_PROBE_POS_Y                        ((0x140e  << 2) + 0xd0100000)
#define L_STH1_HS_ADDR                             ((0x1410  << 2) + 0xd0100000)
#define L_STH1_HE_ADDR                             ((0x1411  << 2) + 0xd0100000)
#define L_STH1_VS_ADDR                             ((0x1412  << 2) + 0xd0100000)
#define L_STH1_VE_ADDR                             ((0x1413  << 2) + 0xd0100000)
#define L_STH2_HS_ADDR                             ((0x1414  << 2) + 0xd0100000)
#define L_STH2_HE_ADDR                             ((0x1415  << 2) + 0xd0100000)
#define L_STH2_VS_ADDR                             ((0x1416  << 2) + 0xd0100000)
#define L_STH2_VE_ADDR                             ((0x1417  << 2) + 0xd0100000)
#define L_OEH_HS_ADDR                              ((0x1418  << 2) + 0xd0100000)
#define L_OEH_HE_ADDR                              ((0x1419  << 2) + 0xd0100000)
#define L_OEH_VS_ADDR                              ((0x141a  << 2) + 0xd0100000)
#define L_OEH_VE_ADDR                              ((0x141b  << 2) + 0xd0100000)
#define L_VCOM_HSWITCH_ADDR                        ((0x141c  << 2) + 0xd0100000)
#define L_VCOM_VS_ADDR                             ((0x141d  << 2) + 0xd0100000)
#define L_VCOM_VE_ADDR                             ((0x141e  << 2) + 0xd0100000)
#define L_CPV1_HS_ADDR                             ((0x141f  << 2) + 0xd0100000)
#define L_CPV1_HE_ADDR                             ((0x1420  << 2) + 0xd0100000)
#define L_CPV1_VS_ADDR                             ((0x1421  << 2) + 0xd0100000)
#define L_CPV1_VE_ADDR                             ((0x1422  << 2) + 0xd0100000)
#define L_CPV2_HS_ADDR                             ((0x1423  << 2) + 0xd0100000)
#define L_CPV2_HE_ADDR                             ((0x1424  << 2) + 0xd0100000)
#define L_CPV2_VS_ADDR                             ((0x1425  << 2) + 0xd0100000)
#define L_CPV2_VE_ADDR                             ((0x1426  << 2) + 0xd0100000)
#define L_STV1_HS_ADDR                             ((0x1427  << 2) + 0xd0100000)
#define L_STV1_HE_ADDR                             ((0x1428  << 2) + 0xd0100000)
#define L_STV1_VS_ADDR                             ((0x1429  << 2) + 0xd0100000)
#define L_STV1_VE_ADDR                             ((0x142a  << 2) + 0xd0100000)
#define L_STV2_HS_ADDR                             ((0x142b  << 2) + 0xd0100000)
#define L_STV2_HE_ADDR                             ((0x142c  << 2) + 0xd0100000)
#define L_STV2_VS_ADDR                             ((0x142d  << 2) + 0xd0100000)
#define L_STV2_VE_ADDR                             ((0x142e  << 2) + 0xd0100000)
#define L_OEV1_HS_ADDR                             ((0x142f  << 2) + 0xd0100000)
#define L_OEV1_HE_ADDR                             ((0x1430  << 2) + 0xd0100000)
#define L_OEV1_VS_ADDR                             ((0x1431  << 2) + 0xd0100000)
#define L_OEV1_VE_ADDR                             ((0x1432  << 2) + 0xd0100000)
#define L_OEV2_HS_ADDR                             ((0x1433  << 2) + 0xd0100000)
#define L_OEV2_HE_ADDR                             ((0x1434  << 2) + 0xd0100000)
#define L_OEV2_VS_ADDR                             ((0x1435  << 2) + 0xd0100000)
#define L_OEV2_VE_ADDR                             ((0x1436  << 2) + 0xd0100000)
#define L_OEV3_HS_ADDR                             ((0x1437  << 2) + 0xd0100000)
#define L_OEV3_HE_ADDR                             ((0x1438  << 2) + 0xd0100000)
#define L_OEV3_VS_ADDR                             ((0x1439  << 2) + 0xd0100000)
#define L_OEV3_VE_ADDR                             ((0x143a  << 2) + 0xd0100000)
#define L_LCD_PWR_ADDR                             ((0x143b  << 2) + 0xd0100000)
#define L_LCD_PWM0_LO_ADDR                         ((0x143c  << 2) + 0xd0100000)
#define L_LCD_PWM0_HI_ADDR                         ((0x143d  << 2) + 0xd0100000)
#define L_LCD_PWM1_LO_ADDR                         ((0x143e  << 2) + 0xd0100000)
#define L_LCD_PWM1_HI_ADDR                         ((0x143f  << 2) + 0xd0100000)
#define L_INV_CNT_ADDR                             ((0x1440  << 2) + 0xd0100000)
#define L_TCON_MISC_SEL_ADDR                       ((0x1441  << 2) + 0xd0100000)
#define L_DUAL_PORT_CNTL_ADDR                      ((0x1442  << 2) + 0xd0100000)
#define MLVDS_CLK_CTL1_HI                          ((0x1443  << 2) + 0xd0100000)
#define MLVDS_CLK_CTL1_LO                          ((0x1444  << 2) + 0xd0100000)
//  [31:30] enable mlvds clocks
//  [24]    mlvds_clk_half_delay       24 // Bit 0
//  [23:0]  mlvds_clk_pattern           0 // Bit 23:0
#define L_TCON_DOUBLE_CTL                          ((0x1449  << 2) + 0xd0100000)
#define L_TCON_PATTERN_HI                          ((0x144a  << 2) + 0xd0100000)
#define L_TCON_PATTERN_LO                          ((0x144b  << 2) + 0xd0100000)
#define LDIM_BL_ADDR_PORT                          ((0x144e  << 2) + 0xd0100000)
#define LDIM_BL_DATA_PORT                          ((0x144f  << 2) + 0xd0100000)
#define L_DE_HS_ADDR                               ((0x1451  << 2) + 0xd0100000)
#define L_DE_HE_ADDR                               ((0x1452  << 2) + 0xd0100000)
#define L_DE_VS_ADDR                               ((0x1453  << 2) + 0xd0100000)
#define L_DE_VE_ADDR                               ((0x1454  << 2) + 0xd0100000)
#define L_HSYNC_HS_ADDR                            ((0x1455  << 2) + 0xd0100000)
#define L_HSYNC_HE_ADDR                            ((0x1456  << 2) + 0xd0100000)
#define L_HSYNC_VS_ADDR                            ((0x1457  << 2) + 0xd0100000)
#define L_HSYNC_VE_ADDR                            ((0x1458  << 2) + 0xd0100000)
#define L_VSYNC_HS_ADDR                            ((0x1459  << 2) + 0xd0100000)
#define L_VSYNC_HE_ADDR                            ((0x145a  << 2) + 0xd0100000)
#define L_VSYNC_VS_ADDR                            ((0x145b  << 2) + 0xd0100000)
#define L_VSYNC_VE_ADDR                            ((0x145c  << 2) + 0xd0100000)
// bit 8 -- vfifo_mcu_enable
// bit 7 -- halt_vs_de
// bit 6 -- R8G8B8_format
// bit 5 -- R6G6B6_format (round to 6 bits)
// bit 4 -- R5G6B5_format
// bit 3 -- dac_dith_sel
// bit 2 -- lcd_mcu_enable_de     -- ReadOnly
// bit 1 -- lcd_mcu_enable_vsync  -- ReadOnly
// bit 0 -- lcd_mcu_enable
#define L_LCD_MCU_CTL                              ((0x145d  << 2) + 0xd0100000)
//**************************************************************************
//*  Dual port mLVDS registers
//**************************************************************************
// bit 3 - enable_u_dual_mlvds_dp_clk
// bit 2 - enable_u_map_mlvds_r_clk
// bit 1 - enable_u_map_mlvds_l_clk
// bit 0 - dual_mlvds_en
//`define DUAL_MLVDS_CTL                8'h60  
// bit[12:0] - dual_mlvds_line_start 
//`define DUAL_MLVDS_LINE_START         8'h61 
// bit[12:0] - dual_mlvds_line_end 
//`define DUAL_MLVDS_LINE_END           8'h62 
// bit[12:0] - dual_mlvds_w_pixel_start_l 
//`define DUAL_MLVDS_PIXEL_W_START_L    8'h63 
// bit[12:0] - dual_mlvds_w_pixel_end_l 
//`define DUAL_MLVDS_PIXEL_W_END_L      8'h64 
// bit[12:0] - dual_mlvds_w_pixel_start_r 
//`define DUAL_MLVDS_PIXEL_W_START_R    8'h65 
// bit[12:0] - dual_mlvds_w_pixel_end_r 
//`define DUAL_MLVDS_PIXEL_W_END_R      8'h66 
// bit[12:0] - dual_mlvds_r_pixel_start_l 
//`define DUAL_MLVDS_PIXEL_R_START_L    8'h67 
// bit[12:0] - dual_mlvds_r_pixel_cnt_l 
//`define DUAL_MLVDS_PIXEL_R_CNT_L      8'h68 
// bit[12:0] - dual_mlvds_r_pixel_start_r 
//`define DUAL_MLVDS_PIXEL_R_START_R    8'h69 
// bit[12:0] - dual_mlvds_r_pixel_cnt_r 
//`define DUAL_MLVDS_PIXEL_R_CNT_R      8'h6a
// bit[15]   - v_inversion_en
// bit[12:0] - v_inversion_pixel
//`define V_INVERSION_PIXEL             8'h70
// bit[15]   - v_inversion_sync_en
// bit[12:0] - v_inversion_line 
//`define V_INVERSION_LINE              8'h71
// bit[15:12]  - v_loop_r
// bit[11:10]  - v_pattern_1_r
// bit[9:8]    - v_pattern_0_r
// bit[7:4]    - v_loop_l
// bit[3:2]    - v_pattern_1_l
// bit[1:0]    - v_pattern_0_l
//`define V_INVERSION_CONTROL           8'h72
//`define MLVDS2_CONTROL           8'h74
   #define     mLVDS2_RESERVED  15    // 15
   #define     mLVDS2_double_pattern  14    // 14
   #define     mLVDS2_ins_reset  8    // 13:8  // each channel has one bit
   #define     mLVDS2_dual_gate  7
   #define     mLVDS2_bit_num    6    // 0-6Bits, 1-8Bits
   #define     mLVDS2_pair_num   5    // 0-3Pairs, 1-6Pairs
   #define     mLVDS2_msb_first  4
   #define     mLVDS2_PORT_SWAP  3
   #define     mLVDS2_MLSB_SWAP  2
   #define     mLVDS2_PN_SWAP    1
   #define     mLVDS2_en         0
//`define MLVDS2_CONFIG_HI         8'h75
//`define MLVDS2_CONFIG_LO         8'h76
   #define     mLVDS2_reset_offset         29 // Bit 31:29 
   #define     mLVDS2_reset_length         23 // Bit 28:23
   #define     mLVDS2_config_reserved      20 // Bit 22:20
   #define     mLVDS2_reset_start_bit12    19 // Bit 19
   #define     mLVDS2_data_write_toggle    18
   #define     mLVDS2_data_write_ini       17
   #define     mLVDS2_data_latch_1_toggle  16
   #define     mLVDS2_data_latch_1_ini     15
   #define     mLVDS2_data_latch_0_toggle  14
   #define     mLVDS2_data_latch_0_ini     13
   #define     mLVDS2_reset_1_select       12 // 0 - same as reset_0, 1 - 1 clock delay of reset_0
   #define     mLVDS2_reset_start           0 // Bit 11:0
#define MLVDS2_DUAL_GATE_WR_START                  ((0x1477  << 2) + 0xd0100000)
   #define     mlvds2_dual_gate_wr_start    0 // Bit 12:0
#define MLVDS2_DUAL_GATE_WR_END                    ((0x1478  << 2) + 0xd0100000)
   #define     mlvds2_dual_gate_wr_end      0 // Bit 12:0
#define MLVDS2_DUAL_GATE_RD_START                  ((0x1479  << 2) + 0xd0100000)
   #define     mlvds2_dual_gate_rd_start    0 // Bit 12:0
#define MLVDS2_DUAL_GATE_RD_END                    ((0x147a  << 2) + 0xd0100000)
   #define     mlvds2_dual_gate_rd_end      0 // Bit 12:0
#define MLVDS2_SECOND_RESET_CTL                    ((0x147b  << 2) + 0xd0100000)
   #define     mLVDS2_2nd_reset_start       0 // Bit 12:0
#define MLVDS2_DUAL_GATE_CTL_HI                    ((0x147c  << 2) + 0xd0100000)
#define MLVDS2_DUAL_GATE_CTL_LO                    ((0x147d  << 2) + 0xd0100000)
   #define     mlvds2_tcon_field_en        24 // Bit 7:0
   #define     mlvds2_dual_gate_reserved   21 // Bit 2:0
   #define     mlvds2_scan_mode_start_line_bit12 20 // Bit 0
   #define     mlvds2_scan_mode_odd        16 // Bit 3:0
   #define     mlvds2_scan_mode_even       12 // Bit 3:0
   #define     mlvds2_scan_mode_start_line  0 // Bit 11:0
#define MLVDS2_RESET_CONFIG_HI                     ((0x147e  << 2) + 0xd0100000)
#define MLVDS2_RESET_CONFIG_LO                     ((0x147f  << 2) + 0xd0100000)
   #define     mLVDS2_reset_range_enable   31 // Bit 0
   #define     mLVDS2_reset_range_inv      30 // Bit 0
   #define     mLVDS2_reset_config_res1    29 // Bit 0
   #define     mLVDS2_reset_range_line_0   16 // Bit 11:0
   #define     mLVDS2_reset_config_res3    13 // Bit 2:0
   #define     mLVDS2_reset_range_line_1    0 // Bit 11:0
//
//**************************************************************************
//*  Vbyone registers  (Note: no MinLVDS in G9tv, share the register)
//**************************************************************************
#define VBO_CTRL_L                                 ((0x1460  << 2) + 0xd0100000)
#define VBO_CTRL_H                                 ((0x1461  << 2) + 0xd0100000)
#define VBO_SOFT_RST                               ((0x1462  << 2) + 0xd0100000)
#define VBO_LANES                                  ((0x1463  << 2) + 0xd0100000)
#define VBO_VIN_CTRL                               ((0x1464  << 2) + 0xd0100000)
#define VBO_ACT_VSIZE                              ((0x1465  << 2) + 0xd0100000)
#define VBO_REGION_00                              ((0x1466  << 2) + 0xd0100000)
#define VBO_REGION_01                              ((0x1467  << 2) + 0xd0100000)
#define VBO_REGION_02                              ((0x1468  << 2) + 0xd0100000)
#define VBO_REGION_03                              ((0x1469  << 2) + 0xd0100000)
#define VBO_VBK_CTRL_0                             ((0x146a  << 2) + 0xd0100000)
#define VBO_VBK_CTRL_1                             ((0x146b  << 2) + 0xd0100000)
#define VBO_HBK_CTRL                               ((0x146c  << 2) + 0xd0100000)
#define VBO_PXL_CTRL                               ((0x146d  << 2) + 0xd0100000)
#define VBO_LANE_SKEW_L                            ((0x146e  << 2) + 0xd0100000)
#define VBO_LANE_SKEW_H                            ((0x146f  << 2) + 0xd0100000)
#define VBO_GCLK_LANE_L                            ((0x1470  << 2) + 0xd0100000)
#define VBO_GCLK_LANE_H                            ((0x1471  << 2) + 0xd0100000)
#define VBO_GCLK_MAIN                              ((0x1472  << 2) + 0xd0100000)
#define VBO_STATUS_L                               ((0x1473  << 2) + 0xd0100000)
#define VBO_STATUS_H                               ((0x1474  << 2) + 0xd0100000)
#define VBO_LANE_OUTPUT                            ((0x1475  << 2) + 0xd0100000)
#define LCD_PORT_SWAP                              ((0x1476  << 2) + 0xd0100000)
//**************************************************************************
//*  NOTE::    When Programming the Gamma, please turn off the IRQ service *
//**************************************************************************
#define GAMMA_CNTL_PORT                            ((0x1480  << 2) + 0xd0100000)
   #define  GAMMA_VCOM_POL    7     //RW
   #define  GAMMA_RVS_OUT     6     //RW
   #define  ADR_RDY           5     //Read Only
   #define  WR_RDY            4     //Read Only
   #define  RD_RDY            3     //Read Only
   #define  GAMMA_TR          2     //RW
   #define  GAMMA_SET         1     //RW
   #define  GAMMA_EN          0     //RW
#define GAMMA_DATA_PORT                            ((0x1481  << 2) + 0xd0100000)
#define GAMMA_ADDR_PORT                            ((0x1482  << 2) + 0xd0100000)
   #define  H_RD              12
   #define  H_AUTO_INC        11
   #define  H_SEL_R           10
   #define  H_SEL_G           9
   #define  H_SEL_B           8
   #define  HADR_MSB          7            //7:0
   #define  HADR              0            //7:0
#define GAMMA_VCOM_HSWITCH_ADDR                    ((0x1483  << 2) + 0xd0100000)
#define RGB_BASE_ADDR                              ((0x1485  << 2) + 0xd0100000)
#define RGB_COEFF_ADDR                             ((0x1486  << 2) + 0xd0100000)
#define POL_CNTL_ADDR                              ((0x1487  << 2) + 0xd0100000)
   #define   DCLK_SEL             14    //FOR DCLK OUTPUT
   #define   TCON_VSYNC_SEL_DVI   11    //FOR RGB format DVI output
   #define   TCON_HSYNC_SEL_DVI   10    //FOR RGB format DVI output
   #define   TCON_DE_SEL_DVI      9     //FOR RGB format DVI output
   #define   CPH3_POL         8
   #define   CPH2_POL         7
   #define   CPH1_POL         6
   #define   TCON_DE_SEL      5
   #define   TCON_VS_SEL      4
   #define   TCON_HS_SEL      3
   #define   DE_POL           2
   #define   VS_POL           1
   #define   HS_POL           0
#define DITH_CNTL_ADDR                             ((0x1488  << 2) + 0xd0100000)
   #define  DITH10_EN         10
   #define  DITH8_EN          9
   #define  DITH_MD           8
   #define  DITH10_CNTL_MSB   7          //7:4
   #define  DITH10_CNTL       4          //7:4
   #define  DITH8_CNTL_MSB    3          //3:0
   #define  DITH8_CNTL        0          //3:0
//Bit 1 highlight_en 
//Bit 0 probe_en
#define GAMMA_PROBE_CTRL                           ((0x1489  << 2) + 0xd0100000)
//read only
//Bit [15:0]  probe_color[15:0]
#define GAMMA_PROBE_COLOR_L                        ((0x148a  << 2) + 0xd0100000)
//Read only
//Bit 15: if true valid probed color
//Bit [13:0]  probe_color[29:16]
#define GAMMA_PROBE_COLOR_H                        ((0x148b  << 2) + 0xd0100000)
//bit 15:0, 5:6:5 color
#define GAMMA_PROBE_HL_COLOR                       ((0x148c  << 2) + 0xd0100000)
//12:0 pos_x
#define GAMMA_PROBE_POS_X                          ((0x148d  << 2) + 0xd0100000)
//12:0 pos_y
#define GAMMA_PROBE_POS_Y                          ((0x148e  << 2) + 0xd0100000)
#define STH1_HS_ADDR                               ((0x1490  << 2) + 0xd0100000)
#define STH1_HE_ADDR                               ((0x1491  << 2) + 0xd0100000)
#define STH1_VS_ADDR                               ((0x1492  << 2) + 0xd0100000)
#define STH1_VE_ADDR                               ((0x1493  << 2) + 0xd0100000)
#define STH2_HS_ADDR                               ((0x1494  << 2) + 0xd0100000)
#define STH2_HE_ADDR                               ((0x1495  << 2) + 0xd0100000)
#define STH2_VS_ADDR                               ((0x1496  << 2) + 0xd0100000)
#define STH2_VE_ADDR                               ((0x1497  << 2) + 0xd0100000)
#define OEH_HS_ADDR                                ((0x1498  << 2) + 0xd0100000)
#define OEH_HE_ADDR                                ((0x1499  << 2) + 0xd0100000)
#define OEH_VS_ADDR                                ((0x149a  << 2) + 0xd0100000)
#define OEH_VE_ADDR                                ((0x149b  << 2) + 0xd0100000)
#define VCOM_HSWITCH_ADDR                          ((0x149c  << 2) + 0xd0100000)
#define VCOM_VS_ADDR                               ((0x149d  << 2) + 0xd0100000)
#define VCOM_VE_ADDR                               ((0x149e  << 2) + 0xd0100000)
#define CPV1_HS_ADDR                               ((0x149f  << 2) + 0xd0100000)
#define CPV1_HE_ADDR                               ((0x14a0  << 2) + 0xd0100000)
#define CPV1_VS_ADDR                               ((0x14a1  << 2) + 0xd0100000)
#define CPV1_VE_ADDR                               ((0x14a2  << 2) + 0xd0100000)
#define CPV2_HS_ADDR                               ((0x14a3  << 2) + 0xd0100000)
#define CPV2_HE_ADDR                               ((0x14a4  << 2) + 0xd0100000)
#define CPV2_VS_ADDR                               ((0x14a5  << 2) + 0xd0100000)
#define CPV2_VE_ADDR                               ((0x14a6  << 2) + 0xd0100000)
#define STV1_HS_ADDR                               ((0x14a7  << 2) + 0xd0100000)
#define STV1_HE_ADDR                               ((0x14a8  << 2) + 0xd0100000)
#define STV1_VS_ADDR                               ((0x14a9  << 2) + 0xd0100000)
#define STV1_VE_ADDR                               ((0x14aa  << 2) + 0xd0100000)
#define STV2_HS_ADDR                               ((0x14ab  << 2) + 0xd0100000)
#define STV2_HE_ADDR                               ((0x14ac  << 2) + 0xd0100000)
#define STV2_VS_ADDR                               ((0x14ad  << 2) + 0xd0100000)
#define STV2_VE_ADDR                               ((0x14ae  << 2) + 0xd0100000)
#define OEV1_HS_ADDR                               ((0x14af  << 2) + 0xd0100000)
#define OEV1_HE_ADDR                               ((0x14b0  << 2) + 0xd0100000)
#define OEV1_VS_ADDR                               ((0x14b1  << 2) + 0xd0100000)
#define OEV1_VE_ADDR                               ((0x14b2  << 2) + 0xd0100000)
#define OEV2_HS_ADDR                               ((0x14b3  << 2) + 0xd0100000)
#define OEV2_HE_ADDR                               ((0x14b4  << 2) + 0xd0100000)
#define OEV2_VS_ADDR                               ((0x14b5  << 2) + 0xd0100000)
#define OEV2_VE_ADDR                               ((0x14b6  << 2) + 0xd0100000)
#define OEV3_HS_ADDR                               ((0x14b7  << 2) + 0xd0100000)
#define OEV3_HE_ADDR                               ((0x14b8  << 2) + 0xd0100000)
#define OEV3_VS_ADDR                               ((0x14b9  << 2) + 0xd0100000)
#define OEV3_VE_ADDR                               ((0x14ba  << 2) + 0xd0100000)
#define LCD_PWR_ADDR                               ((0x14bb  << 2) + 0xd0100000)
   #define      LCD_VDD        5
   #define      LCD_VBL        4
   #define      LCD_GPI_MSB    3
   #define      LCD_GPIO       0
#define LCD_PWM0_LO_ADDR                           ((0x14bc  << 2) + 0xd0100000)
#define LCD_PWM0_HI_ADDR                           ((0x14bd  << 2) + 0xd0100000)
#define LCD_PWM1_LO_ADDR                           ((0x14be  << 2) + 0xd0100000)
#define LCD_PWM1_HI_ADDR                           ((0x14bf  << 2) + 0xd0100000)
#define INV_CNT_ADDR                               ((0x14c0  << 2) + 0xd0100000)
   #define     INV_EN          4
   #define     INV_CNT_MSB     3
   #define     INV_CNT         0
#define TCON_MISC_SEL_ADDR                         ((0x14c1  << 2) + 0xd0100000)
   #define     STH2_SEL        12
   #define     STH1_SEL        11
   #define     OEH_SEL         10
   #define     VCOM_SEL         9
   #define     DB_LINE_SW       8
   #define     CPV2_SEL         7
   #define     CPV1_SEL         6
   #define     STV2_SEL         5
   #define     STV1_SEL         4
   #define     OEV_UNITE        3
   #define     OEV3_SEL         2
   #define     OEV2_SEL         1
   #define     OEV1_SEL         0
#define DUAL_PORT_CNTL_ADDR                        ((0x14c2  << 2) + 0xd0100000)
   #define     OUTPUT_YUV       15
   #define     DUAL_IDF         12   // 14:12
   #define     DUAL_ISF         9    // 11:9
   #define     LCD_ANALOG_SEL_CPH3   8
   #define     LCD_ANALOG_3PHI_CLK_SEL   7
   #define     LCD_LVDS_SEL54   6
   #define     LCD_LVDS_SEL27   5
   #define     LCD_TTL_SEL      4
   #define     DUAL_LVDC_EN     3
   #define     PORT_SWP         2
   #define     RGB_SWP          1
   #define     BIT_SWP          0
#define MLVDS_CONTROL                              ((0x14c3  << 2) + 0xd0100000)
   #define     mLVDS_RESERVED  15    // 15
   #define     mLVDS_double_pattern  14    // 14
   #define     mLVDS_ins_reset  8    // 13:8  // each channel has one bit
   #define     mLVDS_dual_gate  7
   #define     mLVDS_bit_num    6    // 0-6Bits, 1-8Bits
   #define     mLVDS_pair_num   5    // 0-3Pairs, 1-6Pairs
   #define     mLVDS_msb_first  4
   #define     mLVDS_PORT_SWAP  3
   #define     mLVDS_MLSB_SWAP  2
   #define     mLVDS_PN_SWAP    1
   #define     mLVDS_en         0
#define MLVDS_RESET_PATTERN_HI                     ((0x14c4  << 2) + 0xd0100000)
#define MLVDS_RESET_PATTERN_LO                     ((0x14c5  << 2) + 0xd0100000)
   #define     mLVDS_reset_pattern  0 // Bit 47:16
#define MLVDS_RESET_PATTERN_EXT                    ((0x14c6  << 2) + 0xd0100000)
   #define     mLVDS_reset_pattern_ext  0 // Bit 15:0
#define MLVDS_CONFIG_HI                            ((0x14c7  << 2) + 0xd0100000)
#define MLVDS_CONFIG_LO                            ((0x14c8  << 2) + 0xd0100000)
   #define     mLVDS_reset_offset         29 // Bit 31:29 
   #define     mLVDS_reset_length         23 // Bit 28:23
   #define     mLVDS_config_reserved      20 // Bit 22:20
   #define     mLVDS_reset_start_bit12    19 // Bit 19
   #define     mLVDS_data_write_toggle    18
   #define     mLVDS_data_write_ini       17
   #define     mLVDS_data_latch_1_toggle  16
   #define     mLVDS_data_latch_1_ini     15
   #define     mLVDS_data_latch_0_toggle  14
   #define     mLVDS_data_latch_0_ini     13
   #define     mLVDS_reset_1_select       12 // 0 - same as reset_0, 1 - 1 clock delay of reset_0
   #define     mLVDS_reset_start           0 // Bit 11:0
#define TCON_DOUBLE_CTL                            ((0x14c9  << 2) + 0xd0100000)
   #define     tcon_double_ini          8 // Bit 7:0
   #define     tcon_double_inv          0 // Bit 7:0
#define TCON_PATTERN_HI                            ((0x14ca  << 2) + 0xd0100000)
#define TCON_PATTERN_LO                            ((0x14cb  << 2) + 0xd0100000)
   #define     tcon_pattern_loop_data     16 // Bit 15:0
   #define     tcon_pattern_loop_start    12 // Bit 3:0
   #define     tcon_pattern_loop_end       8 // Bit 3:0
   #define     tcon_pattern_enable         0 // Bit 7:0
#define TCON_CONTROL_HI                            ((0x14cc  << 2) + 0xd0100000)
#define TCON_CONTROL_LO                            ((0x14cd  << 2) + 0xd0100000)
   #define     tcon_pclk_enable           26 // Bit 5:0 (enable pclk on TCON channel 7 to 2)
   #define     tcon_pclk_div              24 // Bit 1:0 (control phy clok divide 2,4,6,8)
   #define     tcon_delay                  0 // Bit 23:0 (3 bit for each channel)
#define LVDS_BLANK_DATA_HI                         ((0x14ce  << 2) + 0xd0100000)
#define LVDS_BLANK_DATA_LO                         ((0x14cf  << 2) + 0xd0100000)
   #define     LVDS_blank_data_reserved 30  // 31:30
   #define     LVDS_blank_data_r        20  // 29:20
   #define     LVDS_blank_data_g        10  // 19:10
   #define     LVDS_blank_data_b         0  //  9:0
#define LVDS_PACK_CNTL_ADDR                        ((0x14d0  << 2) + 0xd0100000)
   #define     LVDS_USE_TCON    7
   #define     LVDS_DUAL        6
   #define     PN_SWP           5
   #define     LSB_FIRST        4
   #define     LVDS_RESV        3
   #define     ODD_EVEN_SWP     2
   #define     LVDS_REPACK      0
// New from M3 :
// Bit 15:12 -- Enable OFFSET Double Generate(TOCN7-TCON4)
// Bit 11:0 -- de_hs(old tcon) second offset_hs (new tcon)
#define DE_HS_ADDR                                 ((0x14d1  << 2) + 0xd0100000)
// New from M3 :
// Bit 15:12 -- Enable OFFSET Double Generate(TOCN3-TCON0)
#define DE_HE_ADDR                                 ((0x14d2  << 2) + 0xd0100000)
#define DE_VS_ADDR                                 ((0x14d3  << 2) + 0xd0100000)
#define DE_VE_ADDR                                 ((0x14d4  << 2) + 0xd0100000)
#define HSYNC_HS_ADDR                              ((0x14d5  << 2) + 0xd0100000)
#define HSYNC_HE_ADDR                              ((0x14d6  << 2) + 0xd0100000)
#define HSYNC_VS_ADDR                              ((0x14d7  << 2) + 0xd0100000)
#define HSYNC_VE_ADDR                              ((0x14d8  << 2) + 0xd0100000)
#define VSYNC_HS_ADDR                              ((0x14d9  << 2) + 0xd0100000)
#define VSYNC_HE_ADDR                              ((0x14da  << 2) + 0xd0100000)
#define VSYNC_VS_ADDR                              ((0x14db  << 2) + 0xd0100000)
#define VSYNC_VE_ADDR                              ((0x14dc  << 2) + 0xd0100000)
// bit 8 -- vfifo_mcu_enable
// bit 7 -- halt_vs_de
// bit 6 -- R8G8B8_format
// bit 5 -- R6G6B6_format (round to 6 bits)
// bit 4 -- R5G6B5_format
// bit 3 -- dac_dith_sel
// bit 2 -- lcd_mcu_enable_de     -- ReadOnly
// bit 1 -- lcd_mcu_enable_vsync  -- ReadOnly
// bit 0 -- lcd_mcu_enable
#define LCD_MCU_CTL                                ((0x14dd  << 2) + 0xd0100000)
// ReadOnly 
//   R5G6B5 when R5G6B5_format
//   G8R8   when R8G8B8_format
//   G5R10  Other
#define LCD_MCU_DATA_0                             ((0x14de  << 2) + 0xd0100000)
// ReadOnly
//   G8B8   when R8G8B8_format
//   G5B10  Other
#define LCD_MCU_DATA_1                             ((0x14df  << 2) + 0xd0100000)
// LVDS
#define LVDS_GEN_CNTL                              ((0x14e0  << 2) + 0xd0100000)
#define LVDS_PHY_CNTL0                             ((0x14e1  << 2) + 0xd0100000)
#define LVDS_PHY_CNTL1                             ((0x14e2  << 2) + 0xd0100000)
#define LVDS_PHY_CNTL2                             ((0x14e3  << 2) + 0xd0100000)
#define LVDS_PHY_CNTL3                             ((0x14e4  << 2) + 0xd0100000)
#define LVDS_PHY_CNTL4                             ((0x14e5  << 2) + 0xd0100000)
#define LVDS_PHY_CNTL5                             ((0x14e6  << 2) + 0xd0100000)
#define LVDS_SRG_TEST                              ((0x14e8  << 2) + 0xd0100000)
#define LVDS_BIST_MUX0                             ((0x14e9  << 2) + 0xd0100000)
#define LVDS_BIST_MUX1                             ((0x14ea  << 2) + 0xd0100000)
#define LVDS_BIST_FIXED0                           ((0x14eb  << 2) + 0xd0100000)
#define LVDS_BIST_FIXED1                           ((0x14ec  << 2) + 0xd0100000)
#define LVDS_BIST_CNTL0                            ((0x14ed  << 2) + 0xd0100000)
#define LVDS_CLKB_CLKA                             ((0x14ee  << 2) + 0xd0100000)
#define LVDS_PHY_CLK_CNTL                          ((0x14ef  << 2) + 0xd0100000)
#define LVDS_SER_EN                                ((0x14f0  << 2) + 0xd0100000)
#define LVDS_PHY_CNTL6                             ((0x14f1  << 2) + 0xd0100000)
#define LVDS_PHY_CNTL7                             ((0x14f2  << 2) + 0xd0100000)
#define LVDS_PHY_CNTL8                             ((0x14f3  << 2) + 0xd0100000)
#define MLVDS_CLK_CTL0_HI                          ((0x14f4  << 2) + 0xd0100000)
#define MLVDS_CLK_CTL0_LO                          ((0x14f5  << 2) + 0xd0100000)
   #define     mlvds_clk_pattern_reserved 31 // Bit 31
   #define     mpclk_dly                  28 // Bit 2:0 
   #define     mpclk_div                  26 // Bit 1:0 (control phy clok divide 2,4,6,8)
   #define     use_mpclk                  25 // Bit 0
   #define     mlvds_clk_half_delay       24 // Bit 0
   #define     mlvds_clk_pattern           0 // Bit 23:0
#define MLVDS_DUAL_GATE_WR_START                   ((0x14f6  << 2) + 0xd0100000)
   #define     mlvds_dual_gate_wr_start    0 // Bit 12:0
#define MLVDS_DUAL_GATE_WR_END                     ((0x14f7  << 2) + 0xd0100000)
   #define     mlvds_dual_gate_wr_end      0 // Bit 12:0
#define MLVDS_DUAL_GATE_RD_START                   ((0x14f8  << 2) + 0xd0100000)
   #define     mlvds_dual_gate_rd_start    0 // Bit 12:0
#define MLVDS_DUAL_GATE_RD_END                     ((0x14f9  << 2) + 0xd0100000)
   #define     mlvds_dual_gate_rd_end      0 // Bit 12:0
#define MLVDS_SECOND_RESET_CTL                     ((0x14fa  << 2) + 0xd0100000)
   #define     mLVDS_2nd_reset_start       0 // Bit 12:0
#define MLVDS_DUAL_GATE_CTL_HI                     ((0x14fb  << 2) + 0xd0100000)
#define MLVDS_DUAL_GATE_CTL_LO                     ((0x14fc  << 2) + 0xd0100000)
   #define     mlvds_tcon_field_en        24 // Bit 7:0
   #define     mlvds_dual_gate_reserved   21 // Bit 2:0
   #define     mlvds_scan_mode_start_line_bit12 20 // Bit 0
   #define     mlvds_scan_mode_odd        16 // Bit 3:0
   #define     mlvds_scan_mode_even       12 // Bit 3:0
   #define     mlvds_scan_mode_start_line  0 // Bit 11:0
#define MLVDS_RESET_CONFIG_HI                      ((0x14fd  << 2) + 0xd0100000)
#define MLVDS_RESET_CONFIG_LO                      ((0x14fe  << 2) + 0xd0100000)
   #define     mLVDS_reset_range_enable   31 // Bit 0
   #define     mLVDS_reset_range_inv      30 // Bit 0
   #define     mLVDS_reset_config_res1    29 // Bit 0
   #define     mLVDS_reset_range_line_0   16 // Bit 11:0
   #define     mLVDS_reset_config_res3    13 // Bit 2:0
   #define     mLVDS_reset_range_line_1    0 // Bit 11:0
//===============================================================
//LCD DRIVER BASE   END
//===============================================================
//
// Closing file:  lcd_regs.h
//
//`define VPP2_VCBUS_BASE              8'h19
//
// Reading file:  vpp2_regs.h
//
// synopsys translate_off
// synopsys translate_on
// -----------------------------------------------
// CBUS_BASE:  VPP2_VCBUS_BASE = 0x19
// -----------------------------------------------
//===========================================================================
// Video postprocesing Registers 
//===========================================================================
// dummy data used in the VPP preblend and scaler
// Bit 23:16    
// Bit 15:8     CB
// Bit 7:0      CR 
#define VPP2_DUMMY_DATA                            ((0x1900  << 2) + 0xd0100000)
//input line length used in VPP
#define VPP2_LINE_IN_LENGTH                        ((0x1901  << 2) + 0xd0100000)
//input Picture height used in VPP
#define VPP2_PIC_IN_HEIGHT                         ((0x1902  << 2) + 0xd0100000)
//Because there are many coefficients used in the vertical filter and horizontal filters,
//indirect access the coefficients of vertical filter and horizontal filter is used.
//For vertical filter, there are 33x4 coefficients 
//For horizontal filter, there are 33x4 coefficients
//Bit 15    index increment, if bit9 == 1  then (0: index increase 1, 1: index increase 2) else (index increase 2)  
//Bit 14    1: read coef through cbus enable, just for debug purpose in case when we wanna check the coef in ram in correct or not
//Bit 13    if true, vertical separated coef enable
//Bit 9     if true, use 9bit resolution coef, other use 8bit resolution coef
//Bit 8:7   type of index, 00: vertical coef, 01: vertical chroma coef: 10: horizontal coef, 11: resevered 
//Bit 6:0   coef index
#define VPP2_SCALE_COEF_IDX                        ((0x1903  << 2) + 0xd0100000)
//coefficients for vertical filter and horizontal filter
#define VPP2_SCALE_COEF                            ((0x1904  << 2) + 0xd0100000)
//these following registers are the absolute line address pointer for output divided screen
//The output divided screen is shown in the following:
//
//  --------------------------   <------ line zero
//      . 
//      .
//      .           region0        <---------- nonlinear region or nonscaling region    
//      .
//  ---------------------------  
//  ---------------------------  <------ region1_startp 
//      .
//      .           region1         <---------- nonlinear region
//      .
//      .
//  ---------------------------  
//  ---------------------------  <------ region2_startp
//      .
//      .           region2         <---------- linear region
//      .
//      .
//  ---------------------------  
//  ---------------------------  <------ region3_startp
//      .
//      .           region3         <---------- nonlinear region
//      .
//      .
//  ---------------------------  
//  ---------------------------  <------ region4_startp
//      .
//      .           region4         <---------- nonlinear region or nonoscaling region
//      .
//      .
//  ---------------------------  <------ region4_endp
//Bit 28:16 region1 startp
//Bit 12:0 region2 startp
#define VPP2_VSC_REGION12_STARTP                   ((0x1905  << 2) + 0xd0100000)
//Bit 28:16 region3 startp
//Bit 12:0 region4 startp
#define VPP2_VSC_REGION34_STARTP                   ((0x1906  << 2) + 0xd0100000)
#define VPP2_VSC_REGION4_ENDP                      ((0x1907  << 2) + 0xd0100000)
//vertical start phase step, (source/dest)*(2^24)
//Bit 27:24 integer part 
//Bit 23:0  fraction part
#define VPP2_VSC_START_PHASE_STEP                  ((0x1908  << 2) + 0xd0100000)
//vertical scaler region0 phase slope, Bit24 signed bit
#define VPP2_VSC_REGION0_PHASE_SLOPE               ((0x1909  << 2) + 0xd0100000)
//vertical scaler region1 phase slope, Bit24 signed bit
#define VPP2_VSC_REGION1_PHASE_SLOPE               ((0x190a  << 2) + 0xd0100000)
//vertical scaler region3 phase slope, Bit24 signed bit
#define VPP2_VSC_REGION3_PHASE_SLOPE               ((0x190b  << 2) + 0xd0100000)
//vertical scaler region4 phase slope, Bit24 signed bit
#define VPP2_VSC_REGION4_PHASE_SLOPE               ((0x190c  << 2) + 0xd0100000)
//Bit 18:17     double line mode, input/output line width of vscaler becomes 2X, 
//           so only 2 line buffer in this case, use for 3D line by line interleave scaling
//           bit1 true, double the input width and half input height, bit0 true, change line buffer 2 lines instead of 4 lines
//Bit 16     0: progressive output, 1: interlace output
//Bit 15     vertical scaler output line0 in advance or not for bottom field
//Bit 14:13  vertical scaler initial repeat line0 number for bottom field
//Bit 11:8   vertical scaler initial receiving  number for bottom field   
//Bit 7      vertical scaler output line0 in advance or not for top field
//Bit 6:5    vertical scaler initial repeat line0 number for top field
//Bit 3:0    vertical scaler initial receiving  number for top field   
#define VPP2_VSC_PHASE_CTRL                        ((0x190d  << 2) + 0xd0100000)
//Bit 31:16  vertical scaler field initial phase for bottom field
//Bit 15:0  vertical scaler field initial phase for top field
#define VPP2_VSC_INI_PHASE                         ((0x190e  << 2) + 0xd0100000)
//Bit 28:16 region1 startp
//Bit 12:0 region2 startp
#define VPP2_HSC_REGION12_STARTP                   ((0x1910  << 2) + 0xd0100000)
//Bit 28:16 region3 startp
//Bit 12:0 region4 startp
#define VPP2_HSC_REGION34_STARTP                   ((0x1911  << 2) + 0xd0100000)
#define VPP2_HSC_REGION4_ENDP                      ((0x1912  << 2) + 0xd0100000)
//horizontal start phase step, (source/dest)*(2^24)
//Bit 27:24 integer part 
//Bit 23:0  fraction part
#define VPP2_HSC_START_PHASE_STEP                  ((0x1913  << 2) + 0xd0100000)
//horizontal scaler region0 phase slope, Bit24 signed bit
#define VPP2_HSC_REGION0_PHASE_SLOPE               ((0x1914  << 2) + 0xd0100000)
//horizontal scaler region1 phase slope, Bit24 signed bit
#define VPP2_HSC_REGION1_PHASE_SLOPE               ((0x1915  << 2) + 0xd0100000)
//horizontal scaler region3 phase slope, Bit24 signed bit
#define VPP2_HSC_REGION3_PHASE_SLOPE               ((0x1916  << 2) + 0xd0100000)
//horizontal scaler region4 phase slope, Bit24 signed bit
#define VPP2_HSC_REGION4_PHASE_SLOPE               ((0x1917  << 2) + 0xd0100000)
//Bit 22:21   horizontal scaler initial repeat pixel0 number
//Bit 19:16   horizontal scaler initial receiving number   
//Bit 15:0    horizontal scaler top field initial phase
#define VPP2_HSC_PHASE_CTRL                        ((0x1918  << 2) + 0xd0100000)
// Bit 22 if true, divide VSC line length 2 as the HSC input length, othwise VSC length length is the same as the VSC line length,
//                 just for special usage, more flexibility
// Bit 21 if true, prevsc uses lin buffer, otherwise prevsc does not use line buffer, it should be same as prevsc_en
// Bit 20 prehsc_en
// Bit 19 prevsc_en
// Bit 18 vsc_en
// Bit 17 hsc_en
// Bit 16 scale_top_en
// Bit 15 video1 scale out enable
// Bit 12 if true, region0,region4 are nonlinear regions, otherwise they are not scaling regions, for horizontal scaler 
// Bit 10:8 horizontal scaler bank length
// Bit 5, vertical scaler phase field mode, if true, disable the opposite parity line output, more bandwith needed if output 1080i
// Bit 4 if true, region0,region4 are nonlinear regions, otherwise they are not scaling regions, for vertical scaler 
// Bit 2:0 vertical scaler bank length
#define VPP2_SC_MISC                               ((0x1919  << 2) + 0xd0100000)
// preblend video1 horizontal start and end
//Bit 28:16 start
//Bit 12:0 end
#define VPP2_PREBLEND_VD1_H_START_END              ((0x191a  << 2) + 0xd0100000)
// preblend video1 vertical start and end
//Bit 28:16 start
//Bit 12:0 end
#define VPP2_PREBLEND_VD1_V_START_END              ((0x191b  << 2) + 0xd0100000)
// postblend video1 horizontal start and end
//Bit 28:16 start
//Bit 12:0 end
#define VPP2_POSTBLEND_VD1_H_START_END             ((0x191c  << 2) + 0xd0100000)
// postblend video1 vertical start and end
//Bit 28:16 start
//Bit 12:0 end
#define VPP2_POSTBLEND_VD1_V_START_END             ((0x191d  << 2) + 0xd0100000)
// preblend horizontal size
#define VPP2_PREBLEND_H_SIZE                       ((0x1920  << 2) + 0xd0100000)
// postblend horizontal size
#define VPP2_POSTBLEND_H_SIZE                      ((0x1921  << 2) + 0xd0100000)
//VPP hold lines
//Bit 29:24
//Bit 21:16
//Bit 15:8     preblend hold lines
//Bit 7:0      postblend hold lines
#define VPP2_HOLD_LINES                            ((0x1922  << 2) + 0xd0100000)
//Bit 25   if true, change screen to one color value for preblender
//Bit 24   if true, change screen to one color value for postblender
// Bit 23:16 one color Y
// Bit 15:8 one color Cb
// Bit  7:0 one color  Cr
#define VPP2_BLEND_ONECOLOR_CTRL                   ((0x1923  << 2) + 0xd0100000)
//Read Only, VPP preblend current_x, current_y
//Bit 28:16 current_x
//Bit 12:0 current_y
#define VPP2_PREBLEND_CURRENT_XY                   ((0x1924  << 2) + 0xd0100000)
//Read Only, VPP postblend current_x, current_y
//Bit 28:16 current_x
//Bit 12:0 current_y
#define VPP2_POSTBLEND_CURRENT_XY                  ((0x1925  << 2) + 0xd0100000)
// Bit 31  vd1_bgosd_exchange_en for preblend
// Bit 30  vd1_bgosd_exchange_en for postblend
// bit 28   color management enable
// Bit 27,  reserved 
// Bit 26:18, reserved
// Bit 17, osd2 enable for preblend
// Bit 16, osd1 enable for preblend
// Bit 15, reserved
// Bit 14, vd1 enable for preblend
// Bit 13, osd2 enable for postblend
// Bit 12, osd1 enable for postblend
// Bit 11, reserved
// Bit 10, vd1 enable for postblend
// Bit 9,  if true, osd1 is alpha premultipiled 
// Bit 8,  if true, osd2 is alpha premultipiled 
// Bit 7,  postblend module enable
// Bit 6,  preblend module enable
// Bit 5,  if true, osd2 foreground compared with osd1 in preblend
// Bit 4,  if true, osd2 foreground compared with osd1 in postblend
// Bit 3,  
// Bit 2,  if true, disable resetting async fifo every vsync, otherwise every vsync
//           the aync fifo will be reseted.
// Bit 1,     
// Bit 0    if true, the output result of VPP is saturated
#define VPP2_MISC                                  ((0x1926  << 2) + 0xd0100000)
//Bit 31:20 ofifo line length minus 1
//Bit 19  if true invert input vs
//Bit 18  if true invert input hs
//Bit 17  force top/bottom field, enable
//Bit 16  force top/bottom field, 0: top, 1: bottom
//Bit 15  force one go_field, one pluse, write only
//Bit 14  force one go_line, one pluse, write only
//Bit 12:0 ofifo size (actually only bit 10:1 is valid), always even number
#define VPP2_OFIFO_SIZE                            ((0x1927  << 2) + 0xd0100000)
//Read only
//Bit 28:17 current scale out fifo counter
//Bit 16:12 current afifo counter
//Bit 11:0 current ofifo counter
#define VPP2_FIFO_STATUS                           ((0x1928  << 2) + 0xd0100000)
// Bit 3 SMOKE2 postblend enable only when postblend osd2 is not enable 
// Bit 2 SMOKE2 preblend enable only when preblend osd2 is not enable 
// Bit 1 SMOKE1 postblend enable only when postblend osd1 is not enable 
// Bit 0 SMOKE1 preblend enable only when preblend osd1 is not enable 
#define VPP2_SMOKE_CTRL                            ((0x1929  << 2) + 0xd0100000)
//smoke can be used only when that blending is disable and then be used as smoke function
//smoke1 for OSD1 chanel
//smoke2 for OSD2 chanel
//31:24 Y
//23:16 Cb
//15:8 Cr
//7:0 Alpha
#define VPP2_SMOKE1_VAL                            ((0x192a  << 2) + 0xd0100000)
#define VPP2_SMOKE2_VAL                            ((0x192b  << 2) + 0xd0100000)
//Bit 28:16 start
//Bit 12:0 end
#define VPP2_SMOKE1_H_START_END                    ((0x192d  << 2) + 0xd0100000)
//Bit 28:16 start
//Bit 12:0 end
#define VPP2_SMOKE1_V_START_END                    ((0x192e  << 2) + 0xd0100000)
//Bit 28:16 start
//Bit 12:0 end
#define VPP2_SMOKE2_H_START_END                    ((0x192f  << 2) + 0xd0100000)
//Bit 28:16 start
//Bit 12:0 end
#define VPP2_SMOKE2_V_START_END                    ((0x1930  << 2) + 0xd0100000)
//Bit 27:16 scale out fifo line length minus 1
//Bit 12:0 scale out fifo size (actually only bit 11:1 is valid, 11:1, max 1024), always even number
#define VPP2_SCO_FIFO_CTRL                         ((0x1933  << 2) + 0xd0100000)
//for 3D quincunx sub-sampling and horizontal pixel by pixel 3D interleaving
//Bit 27:24, prehsc_mode, bit 3:2, prehsc odd line interp mode, bit 1:0, prehsc even line interp mode, 
//           each 2bit, 00: pix0+pix1/2, average, 01: pix1, 10: pix0
//Bit 23 horizontal scaler double pixel mode
//Bit 22:21   horizontal scaler initial repeat pixel0 number1
//Bit 19:16   horizontal scaler initial receiving number1   
//Bit 15:0    horizontal scaler top field initial phase1
#define VPP2_HSC_PHASE_CTRL1                       ((0x1934  << 2) + 0xd0100000)
//for 3D quincunx sub-sampling
//31:24  prehsc pattern, each patten 1 bit, from lsb -> msb
//22:20  prehsc pattern start
//18:16 prehsc pattern end
//15:8 pattern, each patten 1 bit, from lsb -> msb
//6:4  pattern start
//2:0  pattern end
#define VPP2_HSC_INI_PAT_CTRL                      ((0x1935  << 2) + 0xd0100000)
//Bit 3         minus black level enable for vadj2
//Bit 2         Video adjustment enable for vadj2
//Bit 1         minus black level enable for vadj1
//Bit 0         Video adjustment enable for vadj1
#define VPP2_VADJ_CTRL                             ((0x1940  << 2) + 0xd0100000)
//Bit 16:8  brightness, signed value
//Bit 7:0   contrast, unsigned value, contrast from  0 <= contrast <2
#define VPP2_VADJ1_Y                               ((0x1941  << 2) + 0xd0100000)
//cb' = cb*ma + cr*mb
//cr' = cb*mc + cr*md
//all are bit 9:0, signed value, -2 < ma/mb/mc/md < 2
#define VPP2_VADJ1_MA_MB                           ((0x1942  << 2) + 0xd0100000)
#define VPP2_VADJ1_MC_MD                           ((0x1943  << 2) + 0xd0100000)
//Bit 16:8  brightness, signed value
//Bit 7:0   contrast, unsigned value, contrast from  0 <= contrast <2
#define VPP2_VADJ2_Y                               ((0x1944  << 2) + 0xd0100000)
//cb' = cb*ma + cr*mb
//cr' = cb*mc + cr*md
//all are bit 9:0, signed value, -2 < ma/mb/mc/md < 2
#define VPP2_VADJ2_MA_MB                           ((0x1945  << 2) + 0xd0100000)
#define VPP2_VADJ2_MC_MD                           ((0x1946  << 2) + 0xd0100000)
//Read only 
//Bit 31, if it is true, it means this probe is valid in the last field/frame
//Bit 29:20 component 0
//Bit 19:10 component 1
//Bit 9:0 component 2
#define VPP2_MATRIX_PROBE_COLOR                    ((0x195c  << 2) + 0xd0100000)
//Bit 23:16 component 0
//Bit 15:8  component 1
//Bit 7:0 component 2
#define VPP2_MATRIX_HL_COLOR                       ((0x195d  << 2) + 0xd0100000)
//28:16 probe x, postion
//12:0  probe y, position  
#define VPP2_MATRIX_PROBE_POS                      ((0x195e  << 2) + 0xd0100000)
//Bit 16,  highlight_en
//Bit 15   probe_post, if true, probe pixel data after matrix, otherwise probe pixel data before matrix
//Bit 14:12 probe_sel, 000: select post matrix, 001: select vd1 matrix,
//Bit 9:8  matrix coef idx selection, 00: select post matrix, 01: select vd1 matrix
//Bit 5    vd1 conversion matrix enable
//Bit 4    reserved
//Bit 2    output y/cb/cr saturation enable, only for post matrix (y saturate to 16-235, cb/cr saturate to 16-240)
//Bit 1    input y/cb/cr saturation enable, only for post matrix (y saturate to 16-235, cb/cr saturate to 16-240)
//Bit 0    post conversion matrix enable
#define VPP2_MATRIX_CTRL                           ((0x195f  << 2) + 0xd0100000)
//Bit 28:16 coef00
//Bit 12:0  coef01
#define VPP2_MATRIX_COEF00_01                      ((0x1960  << 2) + 0xd0100000)
//Bit 28:16 coef02 
//Bit 12:0  coef10 
#define VPP2_MATRIX_COEF02_10                      ((0x1961  << 2) + 0xd0100000)
//Bit 28:16 coef11
//Bit 12:0  coef12
#define VPP2_MATRIX_COEF11_12                      ((0x1962  << 2) + 0xd0100000)
//Bit 28:16 coef20
//Bit 12:0  coef21
#define VPP2_MATRIX_COEF20_21                      ((0x1963  << 2) + 0xd0100000)
#define VPP2_MATRIX_COEF22                         ((0x1964  << 2) + 0xd0100000)
//Bit 26:16 offset0
//Bit 10:0  offset1
#define VPP2_MATRIX_OFFSET0_1                      ((0x1965  << 2) + 0xd0100000)
//Bit 10:0  offset2
#define VPP2_MATRIX_OFFSET2                        ((0x1966  << 2) + 0xd0100000)
//Bit 26:16 pre_offset0
//Bit 10:0  pre_offset1
#define VPP2_MATRIX_PRE_OFFSET0_1                  ((0x1967  << 2) + 0xd0100000)
//Bit 10:0  pre_offset2
#define VPP2_MATRIX_PRE_OFFSET2                    ((0x1968  << 2) + 0xd0100000)
// dummy data used in the VPP postblend
// Bit 23:16    Y
// Bit 15:8     CB
// Bit 7:0      CR 
#define VPP2_DUMMY_DATA1                           ((0x1969  << 2) + 0xd0100000)
//Bit 31 gainoff module enable
//Bit 26:16 gain0, 1.10 unsigned data
//Bit 10:0  gain1, 1.10 unsigned dat
#define VPP2_GAINOFF_CTRL0                         ((0x196a  << 2) + 0xd0100000)
//Bit 26:16 gain2, 1.10 unsigned data
//Bit 10:0, offset0, signed data
#define VPP2_GAINOFF_CTRL1                         ((0x196b  << 2) + 0xd0100000)
//Bit 26:16, offset1, signed data
//Bit 10:0, offset2, signed data
#define VPP2_GAINOFF_CTRL2                         ((0x196c  << 2) + 0xd0100000)
//Bit 26:16, pre_offset0, signed data 
//Bit 10:0, pre_offset1, signed data 
#define VPP2_GAINOFF_CTRL3                         ((0x196d  << 2) + 0xd0100000)
//Bit 10:0, pre_offset2, signed data 
#define VPP2_GAINOFF_CTRL4                         ((0x196e  << 2) + 0xd0100000)
//only two registers used in the color management, which are defined in the chroma_reg.h
#define VPP2_CHROMA_ADDR_PORT                      ((0x1970  << 2) + 0xd0100000)
#define VPP2_CHROMA_DATA_PORT                      ((0x1971  << 2) + 0xd0100000)
//`include "chroma_reg.h"       //defined inside is the indirect addressed registers
//(hsvsharp), (blue), gainoff, mat_vd1,mat_vd2, mat_post, prebld, postbld,(hsharp),sco_ff, vadj1, vadj2, ofifo, (chroma1), clk0(free_clk) vpp_reg
//each item 2bits, for each 2bits, if bit 2*i+1 == 1, free clk, else if bit 2*i == 1 no clk, else auto gated clock 
//bit1 is not used, because I can not turn off vpp_reg clk because I can not turn on again 
//because the register itself canot be set again without clk
//Bit 31:0
#define VPP2_GCLK_CTRL0                            ((0x1972  << 2) + 0xd0100000)
//Chroma2_filter, Chroma2, (Ccoring), (blackext), dnlp
//Bit 9:0
#define VPP2_GCLK_CTRL1                            ((0x1973  << 2) + 0xd0100000)
//prehsc_clk, line_buf, prevsc, vsc, hsc_clk, clk0(free_clk)
//Bit 11:0
#define VPP2_SC_GCLK_CTRL                          ((0x1974  << 2) + 0xd0100000)
//Bit 17:9 VD1 alpha for preblend
//Bit 8:0 VD1 alpha for postblend
#define VPP2_MISC1                                 ((0x1976  << 2) + 0xd0100000)
//Bit 31:24     bottom of region03 output value
//Bit 23:16     bottom of region02 output value
//Bit 15:8      bottom of region01 output value
//Bit 7:0       bottom of region00 output value
#define VPP2_DNLP_CTRL_00                          ((0x1981  << 2) + 0xd0100000)
//Bit 31:24     bottom of region07 output value
//Bit 23:16     bottom of region06 output value
//Bit 15:8      bottom of region05 output value
//Bit 7:0       bottom of region04 output value
#define VPP2_DNLP_CTRL_01                          ((0x1982  << 2) + 0xd0100000)
//Bit 31:24     bottom of region11 output value
//Bit 23:16     bottom of region10 output value
//Bit 15:8      bottom of region09 output value
//Bit 7:0       bottom of region08 output value
#define VPP2_DNLP_CTRL_02                          ((0x1983  << 2) + 0xd0100000)
//Bit 31:24     bottom of region15 output value
//Bit 23:16     bottom of region14 output value
//Bit 15:8      bottom of region13 output value
//Bit 7:0       bottom of region12 output value
#define VPP2_DNLP_CTRL_03                          ((0x1984  << 2) + 0xd0100000)
//Bit 31:24     bottom of region19 output value
//Bit 23:16     bottom of region18 output value
//Bit 15:8      bottom of region17 output value
//Bit 7:0       bottom of region16 output value
#define VPP2_DNLP_CTRL_04                          ((0x1985  << 2) + 0xd0100000)
//Bit 31:24     bottom of region23 output value
//Bit 23:16     bottom of region22 output value
//Bit 15:8      bottom of region21 output value
//Bit 7:0       bottom of region20 output value
#define VPP2_DNLP_CTRL_05                          ((0x1986  << 2) + 0xd0100000)
//Bit 31:24     bottom of region27 output value
//Bit 23:16     bottom of region26 output value
//Bit 15:8      bottom of region25 output value
//Bit 7:0       bottom of region24 output value
#define VPP2_DNLP_CTRL_06                          ((0x1987  << 2) + 0xd0100000)
//Bit 31:24     bottom of region31 output value
//Bit 23:16     bottom of region30 output value
//Bit 15:8      bottom of region29 output value
//Bit 7:0       bottom of region28 output value
#define VPP2_DNLP_CTRL_07                          ((0x1988  << 2) + 0xd0100000)
//Bit 31:24     bottom of region35 output value
//Bit 23:16     bottom of region34 output value
//Bit 15:8      bottom of region33 output value
//Bit 7:0       bottom of region32 output value
#define VPP2_DNLP_CTRL_08                          ((0x1989  << 2) + 0xd0100000)
//Bit 31:24     bottom of region39 output value
//Bit 23:16     bottom of region38 output value
//Bit 15:8      bottom of region37 output value
//Bit 7:0       bottom of region36 output value
#define VPP2_DNLP_CTRL_09                          ((0x198a  << 2) + 0xd0100000)
//Bit 31:24     bottom of region43 output value
//Bit 23:16     bottom of region42 output value
//Bit 15:8      bottom of region41 output value
//Bit 7:0       bottom of region40 output value
#define VPP2_DNLP_CTRL_10                          ((0x198b  << 2) + 0xd0100000)
//Bit 31:24     bottom of region47 output value
//Bit 23:16     bottom of region46 output value
//Bit 15:8      bottom of region45 output value
//Bit 7:0       bottom of region44 output value
#define VPP2_DNLP_CTRL_11                          ((0x198c  << 2) + 0xd0100000)
//Bit 31:24     bottom of region51 output value
//Bit 23:16     bottom of region50 output value
//Bit 15:8      bottom of region49 output value
//Bit 7:0       bottom of region48 output value
#define VPP2_DNLP_CTRL_12                          ((0x198d  << 2) + 0xd0100000)
//Bit 31:24     bottom of region55 output value
//Bit 23:16     bottom of region54 output value
//Bit 15:8      bottom of region53 output value
//Bit 7:0       bottom of region52 output value
#define VPP2_DNLP_CTRL_13                          ((0x198e  << 2) + 0xd0100000)
//Bit 31:24     bottom of region59 output value
//Bit 23:16     bottom of region58 output value
//Bit 15:8      bottom of region57 output value
//Bit 7:0       bottom of region56 output value
#define VPP2_DNLP_CTRL_14                          ((0x198f  << 2) + 0xd0100000)
//Bit 31:24     bottom of region63 output value
//Bit 23:16     bottom of region62 output value
//Bit 15:8      bottom of region61 output value
//Bit 7:0       bottom of region60 output value
#define VPP2_DNLP_CTRL_15                          ((0x1990  << 2) + 0xd0100000)
//Bit 20 reserved
//Bit 19 reserved
//Bit 18 demo dynamic nonlinear luma processing enable
//Bit 17 reserved
//Bit 16 reserved
//Bit 15:14, 2'b00: demo adjust on top, 2'b01: demo adjust on bottom, 2'b10: demo adjust on left, 2'b11: demo adjust on right
//Bit 4 reserved
//Bit 3 reserved
//Bit 2 dynamic nonlinear luma processing enable
//Bit 1 reserved
//Bit 0 reserved
#define VPP2_VE_ENABLE_CTRL                        ((0x19a1  << 2) + 0xd0100000)
//Bit 12:0, demo left or top screen width
#define VPP2_VE_DEMO_LEFT_TOP_SCREEN_WIDTH         ((0x19a2  << 2) + 0xd0100000)
#define VPP2_VE_DEMO_CENTER_BAR                    ((0x19a3  << 2) + 0xd0100000)
//28:16  ve_line_length
//12:0   ve_pic_height
#define VPP2_VE_H_V_SIZE                           ((0x19a4  << 2) + 0xd0100000)
//Bit 10   reset bit, high active
//Bit 9    0: measuring rising edge, 1: measuring falling edge
//Bit 8    if true, accumulate the counter number, otherwise not
//Bit 7:0  vsync_span, define how many vsync span need to measure 
#define VPP2_VDO_MEAS_CTRL                         ((0x19a8  << 2) + 0xd0100000)
//Read only
//19:16  ind_meas_count_n, every number of sync_span vsyncs, this counter add 1
//15:0, high bit portion of counter
#define VPP2_VDO_MEAS_VS_COUNT_HI                  ((0x19a9  << 2) + 0xd0100000)
//Read only
//31:0, low bit portion of counter
#define VPP2_VDO_MEAS_VS_COUNT_LO                  ((0x19aa  << 2) + 0xd0100000)
//vertical scaler phase step
//Bit 27:0,  4.24 format
#define VPP2_OSD_VSC_PHASE_STEP                    ((0x19c0  << 2) + 0xd0100000)
//Bit 31:16, botttom vertical scaler initial phase
//Bit 15:0, top vertical scaler initial phase
#define VPP2_OSD_VSC_INI_PHASE                     ((0x19c1  << 2) + 0xd0100000)
//Bit 24    osd vertical Scaler enable
//Bit 23    osd_prog_interlace 0: current field is progressive, 1: current field is interlace
//Bit 22:21 osd_vsc_double_line_mode, bit1, double input width and half input height, bit0, change line buffer becomes 2 lines
//Bit 20    osd_vsc_phase0_always_en
//Bit 19    osd_vsc_nearest_en
//Bit 17:16 osd_vsc_bot_rpt_l0_num
//Bit 14:11 osd_vsc_bot_ini_rcv_num
//Bit 9:8   osd_vsc_top_rpt_l0_num
//Bit 6:3   osd_vsc_top_ini_rcv_num
//Bit 2:0   osd_vsc_bank_length 
#define VPP2_OSD_VSC_CTRL0                         ((0x19c2  << 2) + 0xd0100000)
//horizontal scaler phase step
//Bit 27:0,  4.24 format
#define VPP2_OSD_HSC_PHASE_STEP                    ((0x19c3  << 2) + 0xd0100000)
//Bit 31:16, horizontal scaler initial phase1
//Bit 15:0, horizontal scaler initial phase0
#define VPP2_OSD_HSC_INI_PHASE                     ((0x19c4  << 2) + 0xd0100000)
//Bit 22   osd horizontal scaler enable
//Bit 21   osd_hsc_double_pix_mode
//Bit 20   osd_hsc_phase0_always_en
//Bit 19   osd_hsc_nearest_en
//Bit 17:16 osd_hsc_rpt_p0_num1
//Bit 14:11 osd_hsc_ini_rcv_num1
//Bit 9:8   osd_hsc_rpt_p0_num0
//Bit 6:3   osd_hsc_ini_rcv_num0
//Bit 2:0   osd_hsc_bank_length
#define VPP2_OSD_HSC_CTRL0                         ((0x19c5  << 2) + 0xd0100000)
//for 3D quincunx sub-sampling
//bit 15:8 pattern, each patten 1 bit, from lsb -> msb
//bit 6:4  pattern start
//bit 2:0  pattern end
#define VPP2_OSD_HSC_INI_PAT_CTRL                  ((0x19c6  << 2) + 0xd0100000)
//bit 31:24, componet 0
//bit 23:16, component 1
//bit 15:8, component 2
//bit 7:0 component 3, alpha
#define VPP2_OSD_SC_DUMMY_DATA                     ((0x19c7  << 2) + 0xd0100000)
//Bit 14 osc_sc_din_osd1_alpha_mode, 1: (alpha >= 128) ? alpha -1: alpha,  0: (alpha >=1) ? alpha - 1: alpha.
//Bit 13 osc_sc_din_osd2_alpha_mode, 1: (alpha >= 128) ? alpha -1: alpha,  0: (alpha >=1) ? alpha - 1: alpha.
//Bit 12 osc_sc_dout_alpha_mode, 1: (alpha >= 128) ? alpha + 1: alpha, 0: (alpha >=1) ? alpha + 1: alpha.
//Bit 12 osc_sc_alpha_mode, 1: (alpha >= 128) ? alpha + 1: alpha, 0: (alpha >=1) ? alpha + 1: alpha.
//Bit 11:4 default alpha for vd1 or vd2 if they are selected as the source
//Bit 3 osd scaler path enable 
//Bit 1:0 osd_sc_sel, 00: select osd1 input, 01: select osd2 input, 10: select vd1 input, 11: select vd2 input after matrix
#define VPP2_OSD_SC_CTRL0                          ((0x19c8  << 2) + 0xd0100000)
//Bit 28:16 OSD scaler input width minus 1
//Bit 12:0 OSD scaler input height minus 1
#define VPP2_OSD_SCI_WH_M1                         ((0x19c9  << 2) + 0xd0100000)
//Bit 28:16 OSD scaler output horizontal start
//Bit 12:0 OSD scaler output horizontal end
#define VPP2_OSD_SCO_H_START_END                   ((0x19ca  << 2) + 0xd0100000)
//Bit 28:16 OSD scaler output vertical start
//Bit 12:0 OSD scaler output vertical end
#define VPP2_OSD_SCO_V_START_END                   ((0x19cb  << 2) + 0xd0100000)
//Because there are many coefficients used in the vertical filter and horizontal filters,
//indirect access the coefficients of vertical filter and horizontal filter is used.
//For vertical filter, there are 33x4 coefficients 
//For horizontal filter, there are 33x4 coefficients
//Bit 15	index increment, if bit9 == 1  then (0: index increase 1, 1: index increase 2) else (index increase 2)	
//Bit 14	1: read coef through cbus enable, just for debug purpose in case when we wanna check the coef in ram in correct or not
//Bit 9     if true, use 9bit resolution coef, other use 8bit resolution coef
//Bit 8   type of index, 0: vertical coef,  1: horizontal coef
//Bit 6:0 	coef index
#define VPP2_OSD_SCALE_COEF_IDX                    ((0x19cc  << 2) + 0xd0100000)
//coefficients for vertical filter and horizontal filter
#define VPP2_OSD_SCALE_COEF                        ((0x19cd  << 2) + 0xd0100000)
//Bit 12:0 line number use to generate interrupt when line == this number
#define VPP2_INT_LINE_NUM                          ((0x19ce  << 2) + 0xd0100000)
// synopsys translate_off
// synopsys translate_on
//
// Closing file:  vpp2_regs.h
//
//`define VIU_VCBUS_BASE                8'h1a    
//
// Reading file:  vregs.h
//
//===========================================================================
// Video Interface Registers    0xa00 - 0xaff
//===========================================================================
// -----------------------------------------------
// CBUS_BASE:  VIU_VCBUS_BASE = 0x1a
// -----------------------------------------------
#define VIU_ADDR_START                             ((0x1a00  << 2) + 0xd0100000)
#define VIU_ADDR_END                               ((0x1aff  << 2) + 0xd0100000)
//`define TRACE_REG 8'ff
//------------------------------------------------------------------------------
// VIU top-level registers
//------------------------------------------------------------------------------
// Bit  0 RW, osd1_reset
// Bit  1 RW, osd2_reset
// Bit  2 RW, vd1_reset
// Bit  3 RW, vd1_fmt_reset
// Bit  4 RW, vd2_reset
// Bit  5 RW, vd2_fmt_reset
// Bit  6 RW, di_dsr1to2_reset
// Bit  7 RW, vpp_reset
// Bit  8 RW, di_if1_reset
// Bit  9 RW, di_if1_fmt_reset
// Bit 10 RW, di_inp_reset
// Bit 11 RW, di_inp_fmt_reset
// Bit 12 RW, di_mem_reset
// Bit 13 RW, di_mem_fmt_reset
// Bit 14 RW, di_nr_wr_mif_reset
// Bit 15 RW, dein_wr_mif_reset
// Bit 16 RW, di_chan2_mif_reset
// Bit 17 RW, di_mtn_wr_mif_reset
// Bit 18 RW, di_mtn_rd_mif_reset
// Bit 19 RW, di_mad_reset
// Bit 20 RW, vdin0_reset
// Bit 21 RW, vdin1_reset
// Bit 22 RW, nrin_mux_reset
// Bit 23 RW, vdin0_wr_reset
// Bit 24 RW, vdin1_wr_reset
// Bit 25 RW, reserved
// Bit 26 RW, d2d3_reset
// Bit 27 RW, di_cont_wr_mif_reset
// Bit 28 RW, di_cont_rd_mif_reset
#define VIU_SW_RESET                               ((0x1a01  << 2) + 0xd0100000)
#define VIU_SW_RESET0                              ((0x1a02  << 2) + 0xd0100000)
// Bit 0 RW, software reset for mcvecrd_mif
// Bit 1 RW, software reset for mcinfowr_mif
// Bit 2 RW, software reset for mcinford_mif
//7:0 fix_disable
#define VIU_MISC_CTRL0                             ((0x1a06  << 2) + 0xd0100000)
#define D2D3_INTF_LENGTH                           ((0x1a08  << 2) + 0xd0100000)
// Bit 31:30 vdin0 dout splitter, bit 0 turns on vdin0 to old path, bit 1 turns on vdin0 to d2d3_intf vdin0 input path        
// Bit 29:28 vdin1 dout splitter, bit 0 turns on vdin1 to old path, bit 1 turns on vdin1 to d2d3_intf vdin1 input path  
// Bit 27:26 NR write dout splitter, bit 0 turns on NR write to old path, bit 1 turns on NR WR to d2d3_intf NR WR input path  
// Bit 23 if true, turn on clk_d2d3_reg (register clock)
// Bit 22 if true, turn on clk_d2d3
// Bit 21 reg_v1_go_line
// Bit 20 reg_v1_go_field   
// Bit 19 reg_v0_go_field
// Bit 18:16 v1_gofld_sel, 000: display go_field/go_line, 001: DI pre_frame_rst/go_line, 010: vdin0 go_field/go_line, 
//011: vdin1 go_field/go_line, otherwise: force go_field by reg_v1_go_field(bit20), force go_line by reg_v1_go_line(bit21)
// Bit 15:13 v0_gofld_sel, 000: display go_field, 001: DI pre_frame_rst, 010: vdin0 go_field, 011: vdin1 go_field, otherwise: force go_field by
// reg_v0_go_field(bit19)
// Bit 12:6 hole_lines for d2d3 depth read interface
// Bit 5:4 d2d3_v1_sel, 2'b01: video display read interface(DI or vd1 fomart output), 2'b10: scale output, otherwise nothing as v1
// Bit 3 use_vdin_eol, if true, use vdin eol as the v0_eol, otherwise using length to get the v0_eol
// Bit 2:0  d2d3_v0_sel  001: vdin0, 010: vdin1, 011: NRW, 100: video display read interface(DI or vd1 fomart output), 101: vpp scale output
//
#define D2D3_INTF_CTRL0                            ((0x1a09  << 2) + 0xd0100000)
//------------------------------------------------------------------------------
// OSD1 registers
//------------------------------------------------------------------------------
// Bit    31 Reserved
// Bit    30 RW, enable_free_clk: 1=use free-running clock to drive logics;
//                                0=use gated clock for low power.
// Bit    29 R, test_rd_dsr
// Bit    28 R, osd_done
// Bit 27:24 R, osd_blk_mode
// Bit 23:22 R, osd_blk_ptr
// Bit    21 R, osd_enable
//
// Bit 20:12 RW, global_alpha
// Bit    11 RW, test_rd_en
// Bit 10: 9 Reserved for control signals
// Bit  8: 5 RW, ctrl_mtch_y
// Bit     4 RW, ctrl_422to444
// Bit  3: 0 RW, osd_blk_enable. Bit 0 to enable block 0: 1=enable, 0=disable;
//                               Bit 1 to enable block 1, and so on.
#define VIU_OSD1_CTRL_STAT                         ((0x1a10  << 2) + 0xd0100000)
// Bit 31:26 Reserved
// Bit 25:16 R, fifo_count
// Bit 15: 6 Reserved
// Bit  5: 4 RW, hold_fifo_lines[6:5]
// Bit     3 RW, rgb2yuv_full_range
// Bit     2 RW, alpha_9b_mode
// Bit     1 RW, reserved
// Bit     0 RW, color_expand_mode
#define VIU_OSD1_CTRL_STAT2                        ((0x1a2d  << 2) + 0xd0100000)
// Bit 31: 9 Reserved
// Bit     8 RW, 0 = Write LUT, 1 = Read LUT
// Bit  7: 0 RW, lut_addr
#define VIU_OSD1_COLOR_ADDR                        ((0x1a11  << 2) + 0xd0100000)
// Bit 31:24 RW, Y or R
// Bit 23:16 RW, Cb or G
// Bit 15: 8 RW, Cr or B
// Bit  7: 0 RW, Alpha
#define VIU_OSD1_COLOR                             ((0x1a12  << 2) + 0xd0100000)
// Bit 31:24 RW, Y or R
// Bit 23:16 RW, Cb or G
// Bit 15: 8 RW, Cr or B
// Bit  7: 0 RW, Alpha
#define VIU_OSD1_TCOLOR_AG0                        ((0x1a17  << 2) + 0xd0100000)
#define VIU_OSD1_TCOLOR_AG1                        ((0x1a18  << 2) + 0xd0100000)
#define VIU_OSD1_TCOLOR_AG2                        ((0x1a19  << 2) + 0xd0100000)
#define VIU_OSD1_TCOLOR_AG3                        ((0x1a1a  << 2) + 0xd0100000)
// Bit 31:30 Reserved
// Bit    29 RW, y_rev: 0=normal read, 1=reverse read in Y direction
// Bit    28 RW, x_rev: 0=normal read, 1=reverse read in X direction
// Bit 27:24 Reserved
// Bit 23:16 RW, tbl_addr
// Bit    15 RW, little_endian: 0=big endian, 1=little endian
// Bit    14 RW, rpt_y
// Bit 13:12 RW, interp_ctrl. 0x=No interpolation; 10=Interpolate with previous
//                            pixel; 11=Interpolate with the average value
//                            between previous and next pixel.
// Bit 11: 8 RW, osd_blk_mode
// Bit     7 RW, rgb_en
// Bit     6 RW, tc_alpha_en
// Bit  5: 2 RW, color_matrix
// Bit     1 RW, interlace_en
// Bit     0 RW, interlace_sel_odd
#define VIU_OSD1_BLK0_CFG_W0                       ((0x1a1b  << 2) + 0xd0100000)
#define VIU_OSD1_BLK1_CFG_W0                       ((0x1a1f  << 2) + 0xd0100000)
#define VIU_OSD1_BLK2_CFG_W0                       ((0x1a23  << 2) + 0xd0100000)
#define VIU_OSD1_BLK3_CFG_W0                       ((0x1a27  << 2) + 0xd0100000)
// Bit 31:29 Reserved
// Bit 28:16 RW, x_end
// Bit 15:13 Reserved
// Bit 12: 0 RW, x_start
#define VIU_OSD1_BLK0_CFG_W1                       ((0x1a1c  << 2) + 0xd0100000)
#define VIU_OSD1_BLK1_CFG_W1                       ((0x1a20  << 2) + 0xd0100000)
#define VIU_OSD1_BLK2_CFG_W1                       ((0x1a24  << 2) + 0xd0100000)
#define VIU_OSD1_BLK3_CFG_W1                       ((0x1a28  << 2) + 0xd0100000)
// Bit 31:29 Reserved
// Bit 28:16 RW, y_end
// Bit 15:13 Reserved
// Bit 12: 0 RW, y_start
#define VIU_OSD1_BLK0_CFG_W2                       ((0x1a1d  << 2) + 0xd0100000)
#define VIU_OSD1_BLK1_CFG_W2                       ((0x1a21  << 2) + 0xd0100000)
#define VIU_OSD1_BLK2_CFG_W2                       ((0x1a25  << 2) + 0xd0100000)
#define VIU_OSD1_BLK3_CFG_W2                       ((0x1a29  << 2) + 0xd0100000)
// Bit 31:28 Reserved
// Bit 27:16 RW, h_end
// Bit 15:12 Reserved
// Bit 11: 0 RW, h_start
#define VIU_OSD1_BLK0_CFG_W3                       ((0x1a1e  << 2) + 0xd0100000)
#define VIU_OSD1_BLK1_CFG_W3                       ((0x1a22  << 2) + 0xd0100000)
#define VIU_OSD1_BLK2_CFG_W3                       ((0x1a26  << 2) + 0xd0100000)
#define VIU_OSD1_BLK3_CFG_W3                       ((0x1a2a  << 2) + 0xd0100000)
// Bit 31:28 Reserved
// Bit 27:16 RW, v_end
// Bit 15:12 Reserved
// Bit 11: 0 RW, v_start
#define VIU_OSD1_BLK0_CFG_W4                       ((0x1a13  << 2) + 0xd0100000)
#define VIU_OSD1_BLK1_CFG_W4                       ((0x1a14  << 2) + 0xd0100000)
#define VIU_OSD1_BLK2_CFG_W4                       ((0x1a15  << 2) + 0xd0100000)
#define VIU_OSD1_BLK3_CFG_W4                       ((0x1a16  << 2) + 0xd0100000)
// Bit    31 RW, burst_len_sel[2] of [2:0]
// Bit    30 RW, byte_swap: In addition to endian control, further define
//               whether to swap upper and lower byte within a 16-bit mem word.
//               0=No swap; 1=Swap data[15:0] to be {data[7:0], data[15:8]}
// Bit 29:22 R,  Reserved
// Bit 21:20 R,  fifo_st. 0=IDLE, 1=FILL, 2=ABORT 
// Bit    19 R,  fifo_overflow
//
// Bit 18:12 RW, fifo_depth_val, max value=64: set actual fifo depth to fifo_depth_val*8.
// Bit 11:10 RW, burst_len_sel[1:0] of [2:0]. 0=24(default), 1=32, 2=48, 3=64, 4=96, 5=128.
// Bit  9: 5 RW, hold_fifo_lines[4:0]
// Bit     4 RW, clear_err: one pulse to clear fifo_overflow
// Bit     3 RW, fifo_sync_rst
// Bit  2: 1 RW, endian
// Bit     0 RW, urgent
#define VIU_OSD1_FIFO_CTRL_STAT                    ((0x1a2b  << 2) + 0xd0100000)
// Bit 31:24 R, Y or R
// Bit 23:16 R, Cb or G
// Bit 15: 8 R, Cr or B
// Bit  7: 0 R, Output Alpha[8:1]
#define VIU_OSD1_TEST_RDDATA                       ((0x1a2c  << 2) + 0xd0100000)
// Bit    15 RW, prot_en: 1=Borrow PROT's FIFO storage, either for rotate or non-rotate.
// Bit 12: 0 RW, effective FIFO size when prot_en=1.
#define VIU_OSD1_PROT_CTRL                         ((0x1a2e  << 2) + 0xd0100000)
//------------------------------------------------------------------------------
// OSD2 registers
//------------------------------------------------------------------------------
// Bit    31 Reserved
// Bit    30 RW, enable_free_clk: 1=use free-running clock to drive logics;
//                                0=use gated clock for low power.
// Bit    29 R, test_rd_dsr
// Bit    28 R, osd_done
// Bit 27:24 R, osd_blk_mode
// Bit 23:22 R, osd_blk_ptr
// Bit    21 R, osd_enable
//
// Bit 20:12 RW, global_alpha
// Bit    11 RW, test_rd_en
// Bit    10 RW, hl2_en
// Bit     9 RW, hl1_en
// Bit  8: 5 RW, ctrl_mtch_y
// Bit     4 RW, ctrl_422to444
// Bit  3: 0 RW, osd_blk_enable. Bit 0 to enable block 0: 1=enable, 0=disable;
//                               Bit 1 to enable block 1, and so on.
#define VIU_OSD2_CTRL_STAT                         ((0x1a30  << 2) + 0xd0100000)
// Bit 31:26 Reserved
// Bit 25:16 R, fifo_count
// Bit 15: 6 Reserved
// Bit  5: 4 RW, hold_fifo_lines[6:5]
// Bit     3 RW, rgb2yuv_full_range
// Bit     2 RW, alpha_9b_mode
// Bit     1 RW, reserved
// Bit     0 RW, color_expand_mode
#define VIU_OSD2_CTRL_STAT2                        ((0x1a4d  << 2) + 0xd0100000)
// Bit 31: 9 Reserved
// Bit     8 RW, 0 = Write LUT, 1 = Read LUT
// Bit  7: 0 RW, lut_addr
#define VIU_OSD2_COLOR_ADDR                        ((0x1a31  << 2) + 0xd0100000)
// Bit 31:24 RW, Y or R
// Bit 23:16 RW, Cb or G
// Bit 15: 8 RW, Cr or B
// Bit  7: 0 RW, Alpha
#define VIU_OSD2_COLOR                             ((0x1a32  << 2) + 0xd0100000)
// Bit 31:28 Reserved
// Bit 27:16 RW, hl[1-2]_h/v_start
// Bit 15:12 Reserved
// Bit 11: 0 RW, hl[1-2]_h/v_end
#define VIU_OSD2_HL1_H_START_END                   ((0x1a33  << 2) + 0xd0100000)
#define VIU_OSD2_HL1_V_START_END                   ((0x1a34  << 2) + 0xd0100000)
#define VIU_OSD2_HL2_H_START_END                   ((0x1a35  << 2) + 0xd0100000)
#define VIU_OSD2_HL2_V_START_END                   ((0x1a36  << 2) + 0xd0100000)
// Bit 31:24 RW, Y or R
// Bit 23:16 RW, Cb or G
// Bit 15: 8 RW, Cr or B
// Bit  7: 0 RW, Alpha
#define VIU_OSD2_TCOLOR_AG0                        ((0x1a37  << 2) + 0xd0100000)
#define VIU_OSD2_TCOLOR_AG1                        ((0x1a38  << 2) + 0xd0100000)
#define VIU_OSD2_TCOLOR_AG2                        ((0x1a39  << 2) + 0xd0100000)
#define VIU_OSD2_TCOLOR_AG3                        ((0x1a3a  << 2) + 0xd0100000)
// Bit 31:24 Reserved
// Bit 23:16 RW, tbl_addr
// Bit    15 RW, little_endian: 0=big endian, 1=little endian
// Bit    14 RW, rpt_y
// Bit 13:12 RW, interp_ctrl. 0x=No interpolation; 10=Interpolate with previous
//                            pixel; 11=Interpolate with the average value
//                            between previous and next pixel.
// Bit 11: 8 RW, osd_blk_mode
// Bit     7 RW, rgb_en
// Bit     6 RW, tc_alpha_en
// Bit  5: 2 RW, color_matrix
// Bit     1 RW, interlace_en
// Bit     0 RW, interlace_sel_odd
#define VIU_OSD2_BLK0_CFG_W0                       ((0x1a3b  << 2) + 0xd0100000)
#define VIU_OSD2_BLK1_CFG_W0                       ((0x1a3f  << 2) + 0xd0100000)
#define VIU_OSD2_BLK2_CFG_W0                       ((0x1a43  << 2) + 0xd0100000)
#define VIU_OSD2_BLK3_CFG_W0                       ((0x1a47  << 2) + 0xd0100000)
// Bit 31:29 Reserved
// Bit 28:16 RW, x_end
// Bit 15:13 Reserved
// Bit 12: 0 RW, x_start
#define VIU_OSD2_BLK0_CFG_W1                       ((0x1a3c  << 2) + 0xd0100000)
#define VIU_OSD2_BLK1_CFG_W1                       ((0x1a40  << 2) + 0xd0100000)
#define VIU_OSD2_BLK2_CFG_W1                       ((0x1a44  << 2) + 0xd0100000)
#define VIU_OSD2_BLK3_CFG_W1                       ((0x1a48  << 2) + 0xd0100000)
// Bit 31:29 Reserved
// Bit 28:16 RW, y_end
// Bit 15:13 Reserved
// Bit 12: 0 RW, y_start
#define VIU_OSD2_BLK0_CFG_W2                       ((0x1a3d  << 2) + 0xd0100000)
#define VIU_OSD2_BLK1_CFG_W2                       ((0x1a41  << 2) + 0xd0100000)
#define VIU_OSD2_BLK2_CFG_W2                       ((0x1a45  << 2) + 0xd0100000)
#define VIU_OSD2_BLK3_CFG_W2                       ((0x1a49  << 2) + 0xd0100000)
// Bit 31:28 Reserved
// Bit 27:16 RW, h_end
// Bit 15:12 Reserved
// Bit 11: 0 RW, h_start
#define VIU_OSD2_BLK0_CFG_W3                       ((0x1a3e  << 2) + 0xd0100000)
#define VIU_OSD2_BLK1_CFG_W3                       ((0x1a42  << 2) + 0xd0100000)
#define VIU_OSD2_BLK2_CFG_W3                       ((0x1a46  << 2) + 0xd0100000)
#define VIU_OSD2_BLK3_CFG_W3                       ((0x1a4a  << 2) + 0xd0100000)
// Bit 31:28 Reserved
// Bit 27:16 RW, v_end
// Bit 15:12 Reserved
// Bit 11: 0 RW, v_start
#define VIU_OSD2_BLK0_CFG_W4                       ((0x1a64  << 2) + 0xd0100000)
#define VIU_OSD2_BLK1_CFG_W4                       ((0x1a65  << 2) + 0xd0100000)
#define VIU_OSD2_BLK2_CFG_W4                       ((0x1a66  << 2) + 0xd0100000)
#define VIU_OSD2_BLK3_CFG_W4                       ((0x1a67  << 2) + 0xd0100000)
// Bit    31 RW, burst_len_sel[2] of [2:0]
// Bit    30 RW, byte_swap: In addition to endian control, further define
//               whether to swap upper and lower byte within a 16-bit mem word.
//               0=No swap; 1=Swap data[15:0] to be {data[7:0], data[15:8]}
// Bit 29:22 R,  Reserved
// Bit 21:20 R,  fifo_st. 0=IDLE, 1=FILL, 2=ABORT 
// Bit    19 R,  fifo_overflow
//
// Bit 18:12 RW, fifo_depth_val, max value=64: set actual fifo depth to fifo_depth_val*8.
// Bit 11:10 RW, burst_len_sel[1:0] of [2:0]. 0=24(default), 1=32, 2=48, 3=64, 4=96, 5=128.
// Bit  9: 5 RW, hold_fifo_lines[4:0]
// Bit     4 RW, clear_err: one pulse to clear fifo_overflow
// Bit     3 RW, fifo_sync_rst
// Bit  2: 1 RW, endian
// Bit     0 RW, urgent
#define VIU_OSD2_FIFO_CTRL_STAT                    ((0x1a4b  << 2) + 0xd0100000)
// Bit 31:24 R, Y or R
// Bit 23:16 R, Cb or G
// Bit 15: 8 R, Cr or B
// Bit  7: 0 R, Output Alpha[8:1]
#define VIU_OSD2_TEST_RDDATA                       ((0x1a4c  << 2) + 0xd0100000)
// Bit    15 RW, prot_en: 1=Borrow PROT's FIFO storage, either for rotate or non-rotate.
// Bit 12: 0 RW, effective FIFO size when prot_en=1.
#define VIU_OSD2_PROT_CTRL                         ((0x1a4e  << 2) + 0xd0100000)
//------------------------------------------------------------------------------
// VD1 path
//------------------------------------------------------------------------------
#define VD1_IF0_GEN_REG                            ((0x1a50  << 2) + 0xd0100000)
#define VD1_IF0_CANVAS0                            ((0x1a51  << 2) + 0xd0100000)
#define VD1_IF0_CANVAS1                            ((0x1a52  << 2) + 0xd0100000)
#define VD1_IF0_LUMA_X0                            ((0x1a53  << 2) + 0xd0100000)
#define VD1_IF0_LUMA_Y0                            ((0x1a54  << 2) + 0xd0100000)
#define VD1_IF0_CHROMA_X0                          ((0x1a55  << 2) + 0xd0100000)
#define VD1_IF0_CHROMA_Y0                          ((0x1a56  << 2) + 0xd0100000)
#define VD1_IF0_LUMA_X1                            ((0x1a57  << 2) + 0xd0100000)
#define VD1_IF0_LUMA_Y1                            ((0x1a58  << 2) + 0xd0100000)
#define VD1_IF0_CHROMA_X1                          ((0x1a59  << 2) + 0xd0100000)
#define VD1_IF0_CHROMA_Y1                          ((0x1a5a  << 2) + 0xd0100000)
#define VD1_IF0_RPT_LOOP                           ((0x1a5b  << 2) + 0xd0100000)
#define VD1_IF0_LUMA0_RPT_PAT                      ((0x1a5c  << 2) + 0xd0100000)
#define VD1_IF0_CHROMA0_RPT_PAT                    ((0x1a5d  << 2) + 0xd0100000)
#define VD1_IF0_LUMA1_RPT_PAT                      ((0x1a5e  << 2) + 0xd0100000)
#define VD1_IF0_CHROMA1_RPT_PAT                    ((0x1a5f  << 2) + 0xd0100000)
#define VD1_IF0_LUMA_PSEL                          ((0x1a60  << 2) + 0xd0100000)
#define VD1_IF0_CHROMA_PSEL                        ((0x1a61  << 2) + 0xd0100000)
#define VD1_IF0_DUMMY_PIXEL                        ((0x1a62  << 2) + 0xd0100000)
#define VD1_IF0_LUMA_FIFO_SIZE                     ((0x1a63  << 2) + 0xd0100000)
#define VD1_IF0_RANGE_MAP_Y                        ((0x1a6a  << 2) + 0xd0100000)
#define VD1_IF0_RANGE_MAP_CB                       ((0x1a6b  << 2) + 0xd0100000)
#define VD1_IF0_RANGE_MAP_CR                       ((0x1a6c  << 2) + 0xd0100000)
#define VD1_IF0_GEN_REG2                           ((0x1a6d  << 2) + 0xd0100000)
#define VD1_IF0_PROT_CNTL                          ((0x1a6e  << 2) + 0xd0100000)
#define VD1_IF0_URGENT_CTRL                        ((0x1a6f  << 2) + 0xd0100000)
//Bit 31    it true, disable clock, otherwise enable clock
//Bit 30    soft rst bit
//Bit 28    if true, horizontal formatter use repeating to generete pixel, otherwise use bilinear interpolation
//Bit 27:24 horizontal formatter initial phase
//Bit 23    horizontal formatter repeat pixel 0 enable
//Bit 22:21 horizontal Y/C ratio, 00: 1:1, 01: 2:1, 10: 4:1
//Bit 20    horizontal formatter enable
//Bit 19    if true, always use phase0 while vertical formater, meaning always
//          repeat data, no interpolation
//Bit 18    if true, disable vertical formatter chroma repeat last line
//Bit 17    veritcal formatter dont need repeat line on phase0, 1: enable, 0: disable
//Bit 16    veritcal formatter repeat line 0 enable
//Bit 15:12 vertical formatter skip line num at the beginning
//Bit 11:8  vertical formatter initial phase
//Bit 7:1   vertical formatter phase step (3.4)  
//Bit 0     vertical formatter enable
#define VIU_VD1_FMT_CTRL                           ((0x1a68  << 2) + 0xd0100000)
//Bit 27:16  horizontal formatter width
//Bit 11:0   vertical formatter width
#define VIU_VD1_FMT_W                              ((0x1a69  << 2) + 0xd0100000)
//------------------------------------------------------------------------------
// VD2 path
//------------------------------------------------------------------------------
#define VD2_IF0_GEN_REG                            ((0x1a70  << 2) + 0xd0100000)
#define VD2_IF0_CANVAS0                            ((0x1a71  << 2) + 0xd0100000)
#define VD2_IF0_CANVAS1                            ((0x1a72  << 2) + 0xd0100000)
#define VD2_IF0_LUMA_X0                            ((0x1a73  << 2) + 0xd0100000)
#define VD2_IF0_LUMA_Y0                            ((0x1a74  << 2) + 0xd0100000)
#define VD2_IF0_CHROMA_X0                          ((0x1a75  << 2) + 0xd0100000)
#define VD2_IF0_CHROMA_Y0                          ((0x1a76  << 2) + 0xd0100000)
#define VD2_IF0_LUMA_X1                            ((0x1a77  << 2) + 0xd0100000)
#define VD2_IF0_LUMA_Y1                            ((0x1a78  << 2) + 0xd0100000)
#define VD2_IF0_CHROMA_X1                          ((0x1a79  << 2) + 0xd0100000)
#define VD2_IF0_CHROMA_Y1                          ((0x1a7a  << 2) + 0xd0100000)
#define VD2_IF0_RPT_LOOP                           ((0x1a7b  << 2) + 0xd0100000)
#define VD2_IF0_LUMA0_RPT_PAT                      ((0x1a7c  << 2) + 0xd0100000)
#define VD2_IF0_CHROMA0_RPT_PAT                    ((0x1a7d  << 2) + 0xd0100000)
#define VD2_IF0_LUMA1_RPT_PAT                      ((0x1a7e  << 2) + 0xd0100000)
#define VD2_IF0_CHROMA1_RPT_PAT                    ((0x1a7f  << 2) + 0xd0100000)
#define VD2_IF0_LUMA_PSEL                          ((0x1a80  << 2) + 0xd0100000)
#define VD2_IF0_CHROMA_PSEL                        ((0x1a81  << 2) + 0xd0100000)
#define VD2_IF0_DUMMY_PIXEL                        ((0x1a82  << 2) + 0xd0100000)
#define VD2_IF0_LUMA_FIFO_SIZE                     ((0x1a83  << 2) + 0xd0100000)
#define VD2_IF0_RANGE_MAP_Y                        ((0x1a8a  << 2) + 0xd0100000)
#define VD2_IF0_RANGE_MAP_CB                       ((0x1a8b  << 2) + 0xd0100000)
#define VD2_IF0_RANGE_MAP_CR                       ((0x1a8c  << 2) + 0xd0100000)
#define VD2_IF0_GEN_REG2                           ((0x1a8d  << 2) + 0xd0100000)
#define VD2_IF0_PROT_CNTL                          ((0x1a8e  << 2) + 0xd0100000)
#define VD2_IF0_URGENT_CTRL                        ((0x1a8f  << 2) + 0xd0100000)
//Bit 31    it true, disable clock, otherwise enable clock
//Bit 30    soft rst bit
//Bit 28    if true, horizontal formatter use repeating to generete pixel, otherwise use bilinear interpolation
//Bit 27:24 horizontal formatter initial phase
//Bit 23    horizontal formatter repeat pixel 0 enable
//Bit 22:21 horizontal Y/C ratio, 00: 1:1, 01: 2:1, 10: 4:1
//Bit 20    horizontal formatter enable
//Bit 17    veritcal formatter dont need repeat line on phase0, 1: enable, 0: disable
//Bit 16    veritcal formatter repeat line 0 enable
//Bit 15:12 vertical formatter skip line num at the beginning
//Bit 11:8  vertical formatter initial phase
//Bit 7:1   vertical formatter phase step (3.4)  
//Bit 0     vertical formatter enable
#define VIU_VD2_FMT_CTRL                           ((0x1a88  << 2) + 0xd0100000)
//Bit 27:16  horizontal formatter width
//Bit 11:0   vertical formatter width
#define VIU_VD2_FMT_W                              ((0x1a89  << 2) + 0xd0100000)
//todo add comment
#define LDIM_STTS_GCLK_CTRL0                       ((0x1a90  << 2) + 0xd0100000)
#define LDIM_STTS_CTRL0                            ((0x1a91  << 2) + 0xd0100000)
#define LDIM_STTS_WIDTHM1_HEIGHTM1                 ((0x1a92  << 2) + 0xd0100000)
#define LDIM_STTS_MATRIX_COEF00_01                 ((0x1a93  << 2) + 0xd0100000)
#define LDIM_STTS_MATRIX_COEF02_10                 ((0x1a94  << 2) + 0xd0100000)
#define LDIM_STTS_MATRIX_COEF11_12                 ((0x1a95  << 2) + 0xd0100000)
#define LDIM_STTS_MATRIX_COEF20_21                 ((0x1a96  << 2) + 0xd0100000)
#define LDIM_STTS_MATRIX_COEF22                    ((0x1a97  << 2) + 0xd0100000)
#define LDIM_STTS_MATRIX_OFFSET0_1                 ((0x1a98  << 2) + 0xd0100000)
#define LDIM_STTS_MATRIX_OFFSET2                   ((0x1a99  << 2) + 0xd0100000)
#define LDIM_STTS_MATRIX_PRE_OFFSET0_1             ((0x1a9a  << 2) + 0xd0100000)
#define LDIM_STTS_MATRIX_PRE_OFFSET2               ((0x1a9b  << 2) + 0xd0100000)
#define LDIM_STTS_MATRIX_HL_COLOR                  ((0x1a9c  << 2) + 0xd0100000)
#define LDIM_STTS_MATRIX_PROBE_POS                 ((0x1a9d  << 2) + 0xd0100000)
//read only
#define LDIM_STTS_MATRIX_PROBE_COLOR               ((0x1a9e  << 2) + 0xd0100000)
//Bit 31, local dimming statistic enable
//Bit 29, 1: output region histogram 16bit 0:output region histogram 20bit 
//Bit 28, eol enable
//Bit 27:25, vertical line overlap number for max finding
//Bit 24:22, horizontal pixel overlap number, 0: 17 pix, 1: 9 pix, 2: 5 pix, 3: 3 pix, 4: 0 pix
//Bit 20, 1,2,1 low pass filter enable before max/hist statistic
//Bit 19:16, region H/V position index, refer to VDIN_LDIM_STTS_HIST_SET_REGION
//Bit 15:14, 1: region read index auto increase per block read finished to VDIN_LDIM_STTS_HIST_READ_REGION 
//			 2: region read index auto increase per read finished to VDIN_LDIM_STTS_HIST_READ_REGION
//			 0/3: disable read index self increase
//Bit 13:8, region read sub index, which mux the hist & max-finding result to cbus port, refer to LDIM_STTS_HIST_READ_REGION
//Bit 6:0, region read index
#define LDIM_STTS_HIST_REGION_IDX                  ((0x1aa0  << 2) + 0xd0100000)
//Bit 28:0, if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h0: read/write hvstart0
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h1: read/write hend01
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h2: read/write vend01
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h3: read/write hend23
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h4: read/write vend23
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h5: read/write hend45
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h6: read/write vend45
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'd7: read/write hend67
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h8: read/write vend67
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h9: read/write hend89
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'ha: read/write vend89
//hvstart0, Bit 28:16 row0 vstart, Bit 12:0 col0 hstart
//hend01, Bit 28:16 col1 hend, Bit 12:0 col0 hend
//vend01, Bit 28:16 row1 vend, Bit 12:0 row0 vend
//hend23, Bit 28:16 col3 hend, Bit 12:0 col2 hend
//vend23, Bit 28:16 row3 vend, Bit 12:0 row2 vend
//hend45, Bit 28:16 col5 hend, Bit 12:0 col4 hend
//vend45, Bit 28:16 row5 vend, Bit 12:0 row4 vend
//hend67, Bit 28:16 col7 hend, Bit 12:0 col6 hend
//vend67, Bit 28:16 row7 vend, Bit 12:0 row6 vend
//hend89, Bit 28:16 col9 hend, Bit 12:0 col8 hend
//vend89, Bit 28:16 row9 vend, Bit 12:0 row8 vend
#define LDIM_STTS_HIST_SET_REGION                  ((0x1aa1  << 2) + 0xd0100000)
//if LDIM_STTS_HIST_REGION_IDX[29] == 0, that is output hist with 20bit data. 
//if LDIM_STTS_HIST_REGION_IDX[21] == 0, that is output 16hist bins in comp 0. 
//output sequence as rd_sub_idx from 0~47: {max_comp2, comp0_hist0}, {max_comp1, comp0_hist1}, {max_comp0, comp0_hist2}, 
//										   comp0_hist3 ... comp2_hist16
//if LDIM_STTS_HIST_REGION_IDX[29] == 1, that is output hist with 16bit data. 
//if LDIM_STTS_HIST_REGION_IDX[21] == 0, that is output 16hist bins in comp 0. 
//output sequence as rd_sub_idx from 0~47: {max_comp2, max_comp1, max_comp0}, comp0_hist0, comp0_hist1, comp0_hist2
//										   comp0_hist3 ... comp2_hist16
//if LDIM_STTS_HIST_REGION_IDX[29] == 0, that is output hist with 20bit data. 
//if LDIM_STTS_HIST_REGION_IDX[21] == 1, that is output 32hist bins in comp 0. 
//output sequence as rd_sub_idx from 0~47: {max_comp2, max_comp1, max_comp0}, comp0_hist0, comp0_hist1, comp0_hist2
//										   comp0_hist3 ...comp0_hist31 ... comp1_hist16
#define LDIM_STTS_HIST_READ_REGION                 ((0x1aa2  << 2) + 0xd0100000)
//bit15, auto enable; bit14, canvas write mode ;7:4, high threshold ;3:0 , low threshold  for di if1 chroma path
//bit31, auto enable; bit30, canvas write mode ;23:20, high threshold ;19:16 , low threshold  for di if1 luma path
#define DI_IF1_URGENT_CTRL                         ((0x1aa3  << 2) + 0xd0100000)
//bit15, auto enable; bit14, canvas write mode ;7:4, high threshold ;3:0 , low threshold  for di inp chroma path
//bit31, auto enable; bit30, canvas write mode ;23:20, high threshold ;19:16 , low threshold  for di inp luma path
#define DI_INP_URGENT_CTRL                         ((0x1aa4  << 2) + 0xd0100000)
//bit15, auto enable; bit14, canvas write mode ;7:4, high threshold ;3:0 , low threshold  for di mem chroma path
//bit31, auto enable; bit30, canvas write mode ;23:20, high threshold ;19:16 , low threshold  for di mem luma path
#define DI_MEM_URGENT_CTRL                         ((0x1aa5  << 2) + 0xd0100000)
//bit15, auto enable; bit14, canvas write mode ;7:4, high threshold ;3:0 , low threshold  for di chan2 chroma path
//bit31, auto enable; bit30, canvas write mode ;23:20, high threshold ;19:16 , low threshold  for di chan2 luma path
#define DI_CHAN2_URGENT_CTRL                       ((0x1aa6  << 2) + 0xd0100000)
//DEINTERLACE module start from 8'h90 end to 8'hff
// -----------------------------------------------
// CBUS_BASE:  MAD_VCBUS_BASE = 0x17
// -----------------------------------------------
#define DI_PRE_CTRL                                ((0x1700  << 2) + 0xd0100000)
// bit 31,      cbus_pre_frame_rst
// bit 30,      cbus_pre_soft_rst
// bit 29,      pre_field_num 
// bit 27:26,   mode_444c422
// bit 25,      di_cont_read_en
// bit 24:23,   mode_422c444
// bit 22,      mtn_after_nr
// bit 21:16,   pre_hold_fifo_lines
// bit 15,      nr_wr_by
// bit 14,      use_vdin_go_line
// bit 13,      di_prevdin_en
// bit 12,      di_pre_viu_link
// bit 11,      di_pre_repeat
// bit 10,      di_pre_drop_1st
// bit  9,      di_buf2_en
// bit  8,      di_chan2_en
// bit  7,      prenr_hist_en
// bit  6,      chan2_hist_en
// bit  5,      hist_check_en
// bit  4,      check_after_nr
// bit  3,      check222p_en
// bit  2,      check322p_en
// bit  1,      mtn_en
// bit  0,      nr_en
#define DI_POST_CTRL                               ((0x1701  << 2) + 0xd0100000)
// bit 31,      cbus_post_frame_rst
// bit 30,      cbus_post_soft_rst
// bit 29,      post_field_num
// bit 21:16,   post_hold_fifo_lines
// bit 13,      prepost_link
// bit 12,      di_post_viu_link
// bit 11,      di_post_repeat
// bit 10,      di_post_drop_1st
// bit  9,      mif0_to_vpp_en
// bit  8,      di_vpp_out_en
// bit  7,      di_wr_bk_en
// bit  6,      di_mux_en
// bit  5,      di_blend_en
// bit  4,      di_mtnp_read_en
// bit  3,      di_mtn_buf_en
// bit  2,      di_ei_en
// bit  1,      di_buf1_en
// bit  0,      di_buf0_en
#define DI_POST_SIZE                               ((0x1702  << 2) + 0xd0100000)
//bit 28:16,    vsize1post
//bit 12:0,     hsize1post
#define DI_PRE_SIZE                                ((0x1703  << 2) + 0xd0100000)
//bit 28:16,    vsize1pre
//bit 12:0,     hsize1pre
#define DI_EI_CTRL0                                ((0x1704  << 2) + 0xd0100000)
//bit 23:16,    ei0_filter[2:+]  abs_diff_left>filter && ...right>filter && ...top>filter && ...bot>filter -> filter
//bit 15:8,     ei0_threshold[2:+] 
//bit 3,        ei0_vertical
//bit 2,        ei0_bpscf2
//bit 1,        ei0_bpsfar1
#define DI_EI_CTRL1                                ((0x1705  << 2) + 0xd0100000)
//bit 31:24,    ei0_diff
//bit 23:16,    ei0_angle45
//bit 15:8,     ei0_peak
//bit 7:0,      ei0_cross
#define DI_EI_CTRL2                                ((0x1706  << 2) + 0xd0100000)
//bit 31:24,    ei0_close2
//bit 23:16,    ei0_close1
//bit 15:8,     ei0_far2
//bit 7:0,      ei0_far1
#define DI_NR_CTRL0                                ((0x1707  << 2) + 0xd0100000)
//bit 26,       nr_cue_en
//bit 25,       nr2_en
#define DI_NR_CTRL1                                ((0x1708  << 2) + 0xd0100000)
//bit 31:30,    mot_p1txtcore_mode  
//bit 29:24,    mot_p1txtcore_clmt  
//bit 21:16,    mot_p1txtcore_ylmt  
//bit 15:8,     mot_p1txtcore_crate  
//bit 7:0,      mot_p1txtcore_yrate  
#define DI_NR_CTRL2                                ((0x1709  << 2) + 0xd0100000)
//bit 29:24,    mot_curtxtcore_clmt  
//bit 21:16,    mot_curtxtcore_ylmt  
//bit 15:8,     mot_curtxtcore_crate  
//bit 7:0,      mot_curtxtcore_yrate  
//`define DI_NR_CTRL3               8'h0a
//no use
//`define DI_MTN_CTRL               8'h0b
//no use
#define DI_MTN_CTRL1                               ((0x170c  << 2) + 0xd0100000)
//bit 13 ,      me enable
//bit 12 ,      me autoenable
//bit 11:8,		mtn_paramtnthd
//bit 7:0,      mtn_parafltthd
#define DI_BLEND_CTRL                              ((0x170d  << 2) + 0xd0100000)
//bit 31,      blend_1_en         
//bit 30,      blend_mtn_lpf      
//bit 28,      post_mb_en         
//bit 27,      blend_mtn3p_max    
//bit 26,      blend_mtn3p_min    
//bit 25,      blend_mtn3p_ave    
//bit 24,      blend_mtn3p_maxtb  
//bit 23,      blend_mtn_flt_en   
//bit 22,      blend_data_flt_en  
//bit 21:20,   blend_top_mode     
//bit 19,      blend_reg3_enable  
//bit 18,      blend_reg2_enable  
//bit 17,      blend_reg1_enable  
//bit 16,      blend_reg0_enable  
//bit 15:14,   blend_reg3_mode    
//bit 13:12,   blend_reg2_mode    
//bit 11:10,   blend_reg1_mode    
//bit 9:8,     blend_reg0_mode    
//bit 7:0,     kdeint             
//`define DI_BLEND_CTRL1            8'h0e
//no use
//`define DI_BLEND_CTRL2            8'h0f
//no use
#define DI_BLEND_REG0_X                            ((0x1710  << 2) + 0xd0100000)
//bit 27:16,   blend_reg0_startx
//bit 11:0,    blend_reg0_endx
#define DI_BLEND_REG0_Y                            ((0x1711  << 2) + 0xd0100000)
#define DI_BLEND_REG1_X                            ((0x1712  << 2) + 0xd0100000)
#define DI_BLEND_REG1_Y                            ((0x1713  << 2) + 0xd0100000)
#define DI_BLEND_REG2_X                            ((0x1714  << 2) + 0xd0100000)
#define DI_BLEND_REG2_Y                            ((0x1715  << 2) + 0xd0100000)
#define DI_BLEND_REG3_X                            ((0x1716  << 2) + 0xd0100000)
#define DI_BLEND_REG3_Y                            ((0x1717  << 2) + 0xd0100000)
#define DI_CLKG_CTRL                               ((0x1718  << 2) + 0xd0100000)
//bit 31:24,   pre_gclk_ctrl     no clk gate control. if ==1, module clk is not gated (always on). [3] for pulldown,[2] for mtn_1,[1] for mtn_0,[0] for nr
//bit 23:16,   post_gclk_ctrl    no clk gate control. [4] for ei_1, [3] for ei_0,[2] for ei_top, [1] for blend_1, [0] for blend_0
//bit 1,       di_gate_all       clk shut down. if ==1 , all di clock shut down
//bit 0,       di_no_clk_gate    no clk gate control.     if di_gated_all==0 and di_no_clk_gate ==1, all di clock is always working.                         
#define DI_EI_CTRL3                                ((0x1719  << 2) + 0xd0100000)
//bit 31,      reg_ei_1
//bit 30,      reg_demon_en
//bit 26:24,   reg_demon_mux
//bit 23:20,   reg_right_win
//bit 19:16,   reg_left_win
//bit 7:4,     reg_ei_sadm_quatize_margin
//bit 1:0,     reg_ei_sad_relative_mode
#define DI_EI_CTRL4                                ((0x171a  << 2) + 0xd0100000)
//bit 29,      reg_ei_caldrt_ambliike2_biasvertical
//bit 28:24,   reg_ei_caldrt_addxla2list_drtmax
//bit 22:20,   reg_ei_caldrt_addxla2list_signm0th
//bit 19,      reg_ei_caldrt_addxla2list_mode
//bit 18:16,   reg_ei_signm_sad_cor_rate
//bit 15:12,   reg_ei_signm_sadi_cor_rate
//bit 11:6,    reg_ei_signm_sadi_cor_ofst
//bit 5:0,     reg_ei_signm_sad_ofst
#define DI_EI_CTRL5                                ((0x171b  << 2) + 0xd0100000)
//bit 30:28,   reg_ei_caldrt_cnflcctchk_frcverthrd
//bit 26:24,   reg_ei_caldrt_cnflctchk_mg
//bit 23:22,   reg_ei_caldrt_cnflctchk_ws
//bit 21,      reg_ei_caldrt_cnflctchk_en
//bit 20,      reg_ei_caldrt_verfrc_final_en
//bit 19,      reg_ei_caldrt_verfrc_retimflt_en
//bit 18:16,   reg_ei_caldrt_verftc_eithratemth
//bit 15,      reg_ei_caldrt_verfrc_retiming_en
//bit 14:12,   reg_ei_caldrt_verfrc_bothratemth
//bit 11:9,    reg_ei_caldrt_ver_thrd
//bit 8:4,     reg_ei_caldrt_addxla2list_drtmin
//bit 3:0,     reg_ei_caldrt_addxla2list_drtlimit
#define DI_EI_CTRL6                                ((0x171c  << 2) + 0xd0100000)
//bit 31:24,   reg_ei_caldrt_abext_sad12thhig
//bit 23:16,   reg_ei_caldrt_abext_sad00thlow
//bit 15:8,    reg_ei_caldrt_abext_sad12thlow
//bit 6:4,     reg_ei_caldrt_abext_ratemth
//bit 2:0,     reg_ei_caldrt_abext_drtthrd
#define DI_EI_CTRL7                                ((0x171d  << 2) + 0xd0100000)
//bit 29,      reg_ei_caldrt_xlanopeak_codien
//bit 28:24,   reg_ei_caldrt_xlanopeak_drtmax
//bit 23,      reg_ei_caldrt_xlanopeak_en
//bit 28:24,   reg_ei_caldrt_abext_monotrnd_alpha
//bit 28:24,   reg_ei_caldrt_abext_mononum12_thrd
//bit 28:24,   reg_ei_caldrt_abext_mononum00_thrd
//bit 28:24,   reg_ei_caldrt_abext_sad00rate
//bit 28:24,   reg_ei_caldrt_abext_sad12rate
//bit 28:24,   reg_ei_caldrt_abext_sad00thhig          
#define DI_EI_CTRL8                                ((0x171e  << 2) + 0xd0100000)
//bit 30:28,   reg_ei_assign_headtail_magin
//bit 26:24,   reg_ei_retime_lastcurpncnfltchk_mode
//bit 22:21,   reg_ei_retime_lastcurpncnfltchk_drtth
//bit 20,      reg_ei_caldrt_histchk_cnfid
//bit 19:16,   reg_ei_caldrt_histchk_thrd
//bit 15,      reg_ei_caldrt_histchk_abext
//bit 14,      reg_ei_caldrt_histchk_npen
//bit 13:11,   reg_ei_caldrt_amblike2_drtmg
//bit 10:8,    reg_ei_caldrt_amblike2_valmg
//bit 7:4,     reg_ei_caldrt_amblike2_alpha
//bit 3:0,     reg_ei_caldrt_amblike2_drtth
#define DI_EI_CTRL9                                ((0x171f  << 2) + 0xd0100000)
//bit 31:28,   reg_ei_caldrt_hcnfcheck_frcvert_xla_th3
//bit 27,      reg_ei_caldrt_hcnfcheck_frcvert_xla_en
//bit 26:24,   reg_ei_caldrt_conf_drtth
//bit 23:20,   reg_ei_caldrt_conf_absdrtth
//bit 19:18,   reg_ei_caldrt_abcheck_mode1
//bit 17:16,   reg_ei_caldrt_abcheck_mode0
//bit 15:12,   reg_ei_caldrt_abcheck_drth1
//bit 11:8,    reg_ei_caldrt_abcheck_drth0
//bit 6:4,     reg_ei_caldrt_abpnchk1_th
//bit 1,       reg_ei_caldrt_abpnchk1_en
//bit 0,       reg_ei_caldrt_abpnchk0_en
#define DI_EI_CTRL10                               ((0x1793  << 2) + 0xd0100000)
//bit 31:28,   reg_ei_caldrt_hstrrgchk_drtth
//bit 27:24,   reg_ei_caldrt_hstrrgchk_frcverthrd
//bit 23:20,   reg_ei_caldrt_hstrrgchk_mg
//bit 19,      reg_ei_caldrt_hstrrgchk_1sidnul
//bit 18,      reg_ei_caldrt_hstrrgchk_excpcnf
//bit 17:16,   reg_ei_caldrt_hstrrgchk_ws
//bit 15,      reg_ei_caldrt_hstrrgchk_en
//bit 14:13,   reg_ei_caldrt_hpncheck_mode
//bit 12,      reg_ei_caldrt_hpncheck_mute
//bit 11:9,    reg_ei_caldrt_hcnfcheck_mg2
//bit 8:6,     reg_ei_caldrt_hcnfcheck_mg1
//bit 5:4,     reg_ei_caldrt_hcnfcheck_mode
//bit 3:0,     reg_ei_caldrt_hcnfcheck_mg2
#define DI_EI_CTRL11                               ((0x179e  << 2) + 0xd0100000)
//bit 30:29,   reg_ei_amb_detect_mode
//bit 28:24,   reg_ei_amb_detect_winth
//bit 23:21,   reg_ei_amb_decide_rppth
//bit 20:19,   reg_ei_retime_lastmappncnfltchk_drtth
//bit 18:16,   reg_ei_retime_lastmappncnfltchk_mode
//bit 15:14,   reg_ei_retime_lastmapvertfrcchk_mode
//bit 13:12,   reg_ei_retime_lastvertfrcchk_mode
//bit 11:8,    reg_ei_retime_lastpnchk_drtth
//bit 6,       reg_ei_retime_lastpnchk_en
//bit 5:4,     reg_ei_retime_mode
//bit 3,       reg_ei_retime_last_en
//bit 2,       reg_ei_retime_ab_en
//bit 1,       reg_ei_caldrt_hstrvertfrcchk_en
//bit 0,       reg_ei_caldrt_hstrrgchk_mode
#define DI_EI_CTRL12                               ((0x179f  << 2) + 0xd0100000)
//bit 31:28,   reg_ei_drtdelay2_lmt
//bit 27:26,   reg_ei_drtdelay2_notver_lrwin
//bit 25:24,   reg_ei_drtdelay_mode
//bit 23,      reg_ei_drtdelay2_mode
//bit 22:20,   reg_ei_assign_xla_signm0th
//bit 19,      reg_ei_assign_pkbiasvert_en
//bit 18,      reg_ei_assign_xla_en
//bit 17:16,   reg_ei_assign_xla_mode
//bit 15:12,   reg_ei_assign_nlfilter_magin
//bit 11:8,    reg_ei_localsearch_maxrange
//bit 7:4,     reg_ei_xla_drtth
//bit 3:0,     reg_ei_flatmsad_thrd
#define DI_EI_CTRL13                               ((0x17a8  << 2) + 0xd0100000)
//bit 27:24,   reg_ei_int_drt2x_chrdrt_limit
//bit 23:20,   reg_ei_int_drt16x_core
//bit 19:16,   reg_ei_int_drtdelay2_notver_cancv
//bit 15:8,    reg_ei_int_drtdelay2_notver_sadth
//bit 7:0,     reg_ei_int_drtdelay2_vlddrt_sadth
#define DI_EI_XWIN0                                ((0x1798  << 2) + 0xd0100000)
//bit 27:16,   ei_xend0
//bit 11:0,    ei_xstart0
#define DI_EI_XWIN1                                ((0x1799  << 2) + 0xd0100000)
// DEINTERLACE mode check.
#define DI_MC_REG0_X                               ((0x1720  << 2) + 0xd0100000)
//bit 27:16,   mc_reg0_start_x 
//bit 11:0,    mc_reg0_end_x 
#define DI_MC_REG0_Y                               ((0x1721  << 2) + 0xd0100000)
#define DI_MC_REG1_X                               ((0x1722  << 2) + 0xd0100000)
#define DI_MC_REG1_Y                               ((0x1723  << 2) + 0xd0100000)
#define DI_MC_REG2_X                               ((0x1724  << 2) + 0xd0100000)
#define DI_MC_REG2_Y                               ((0x1725  << 2) + 0xd0100000)
#define DI_MC_REG3_X                               ((0x1726  << 2) + 0xd0100000)
#define DI_MC_REG3_Y                               ((0x1727  << 2) + 0xd0100000)
#define DI_MC_REG4_X                               ((0x1728  << 2) + 0xd0100000)
#define DI_MC_REG4_Y                               ((0x1729  << 2) + 0xd0100000)
#define DI_MC_32LVL0                               ((0x172a  << 2) + 0xd0100000)
//bit 31:24,   mc_reg2_32lvl
//bit 23:16,   mc_reg1_32lvl
//bit 15:8,    mc_reg0_32lvl
//bit 7:0,     field_32lvl
#define DI_MC_32LVL1                               ((0x172b  << 2) + 0xd0100000)
//bit 15:8,    mc_reg3_32lvl
//bit 7:0,     mc_reg4_32lvl
#define DI_MC_22LVL0                               ((0x172c  << 2) + 0xd0100000)
//bit 31:16,   mc_reg0_22lvl
//bit 15:0,    field_22lvl
#define DI_MC_22LVL1                               ((0x172d  << 2) + 0xd0100000)
//bit 31:16,   mc_reg2_22lvl
//bit 15:0,    mc_reg1_22lvl
#define DI_MC_22LVL2                               ((0x172e  << 2) + 0xd0100000)
//bit 31:16,   mc_reg4_22lvl
//bit 15:0,    mc_reg3_22lvl
#define DI_MC_CTRL                                 ((0x172f  << 2) + 0xd0100000)
//bit 4,       mc_reg4_en 
//bit 3,       mc_reg3_en 
//bit 2,       mc_reg2_en 
//bit 1,       mc_reg1_en 
//bit 0,       mc_reg0_en 
#define DI_INTR_CTRL                               ((0x1730  << 2) + 0xd0100000)
#define DI_INFO_ADDR                               ((0x1731  << 2) + 0xd0100000)
#define DI_INFO_DATA                               ((0x1732  << 2) + 0xd0100000)
#define DI_PRE_HOLD                                ((0x1733  << 2) + 0xd0100000)
#define DI_MTN_1_CTRL1                             ((0x1740  << 2) + 0xd0100000)
//bit 31,      mtn_1_en
//bit 30,      mtn_init
//bit 29,      di2nr_txt_en
//bit 28,      di2nr_txt_mode
//bit 27:24,   mtn_def
//bit 23:16,   mtn_adp_yc
//bit 15:8,    mtn_adp_2c
//bit 7:0,     mtn_adp_2y
#define DI_MTN_1_CTRL2                             ((0x1741  << 2) + 0xd0100000)
//bit 31:24,   mtn_ykinter
//bit 23:16,   mtn_ckinter
//bit 15:8,    mtn_ykintra
//bit  7:0,    mtn_ckintra
#define DI_MTN_1_CTRL3                             ((0x1742  << 2) + 0xd0100000)
//bit 31:24,   mtn_tyrate 
//bit 23:16,   mtn_tcrate
//bit 15: 8,   mtn_mxcmby
//bit  7: 0,   mtn_mxcmbc
#define DI_MTN_1_CTRL4                             ((0x1743  << 2) + 0xd0100000)
//bit 31:24,   mtn_tcorey
//bit 23:16,   mtn_tcorec
//bit 15: 8,   mtn_minth
//bit  7: 0,   mtn_maxth
#define DI_MTN_1_CTRL5                             ((0x1744  << 2) + 0xd0100000)
//bit 31:28,   mtn_m1b_extnd
//bit 27:24,   mtn_m1b_errod
//bit 19:18,   mtn_replace_cbyy
//bit 17:16,   mtn_replace_ybyc
//bit 15: 8,   mtn_core_ykinter
//bit  7: 0,   mtn_core_ckinter
#define DI_MTN_1_CTRL6                             ((0x17a9  << 2) + 0xd0100000)
//bit 31:24,   mtn_m1b_extnd
//bit 23:16,   mtn_m1b_errod
//bit 15: 8,   mtn_core_ykinter
//bit  7: 0,   mtn_core_ckinter
#define DI_MTN_1_CTRL7                             ((0x17aa  << 2) + 0xd0100000)
//bit 31:24,   mtn_core_mxcmby
//bit 23:16,   mtn_core_mxcmbc
//bit 15: 8,   mtn_core_y     
//bit  7: 0,   mtn_core_c     
#define DI_MTN_1_CTRL8                             ((0x17ab  << 2) + 0xd0100000)
//bit 31:24,   mtn_fcore_ykinter
//bit 23:16,   mtn_fcore_ckinter
//bit 15: 8,   mtn_fcore_ykintra
//bit  7: 0,   mtn_fcore_ckintra
#define DI_MTN_1_CTRL9                             ((0x17ac  << 2) + 0xd0100000)
//bit 31:24,   mtn_fcore_2yrate 
//bit 23:16,   mtn_fcore_2crate
//bit 15: 8,   mtn_fcore_y     
//bit  7: 0,   mtn_fcore_c     
#define DI_MTN_1_CTRL10                            ((0x17ad  << 2) + 0xd0100000)
//bit 27:24,   mtn_motfld0 
//bit 19:16,   mtn_stlfld0  
//bit 11: 8,   mtn_motfld1  
//bit  3: 0,   mtn_stlfld1  
#define DI_MTN_1_CTRL11                            ((0x17ae  << 2) + 0xd0100000)
//bit 27:24,   mtn_smotevn
//bit 20:16,   mtn_smotodd
//bit 11: 8,   mtn_sstlevn
//bit  4: 0,   mtn_sstlodd
#define DI_MTN_1_CTRL12                            ((0x17af  << 2) + 0xd0100000)
//bit 31:24,   mtn_mgain
//bit 17:16,   mtn_mmode
//bit 15: 8,   mtn_sthrd
//bit  4: 0,   mtn_sgain
//// DET 3D REG DEFINE BEGIN ////
//// 8'h34~8'h3f
#define DET3D_MOTN_CFG                             ((0x1734  << 2) + 0xd0100000)
//Bit 16,	reg_det3d_intr_en	        Det3d interrupt enable
//Bit 9:8,	reg_Det3D_Motion_Mode	    U2  Different mode for Motion Calculation of Luma and Chroma: 
//                                      0: MotY, 1: (2*MotY + (MotU + MotV))/4; 2: Max(MotY, MotU,MotV); 3:Max(MotY, (MotU+MotV)/2)
//Bit 7:4,	reg_Det3D_Motion_Core_Rate	U4  K Rate to Edge (HV) details for coring of Motion Calculations, normalized to 32
//Bit 3:0,	reg_Det3D_Motion_Core_Thrd	U4  2X: static coring value for Motion Detection.
#define DET3D_CB_CFG                               ((0x1735  << 2) + 0xd0100000)
//Bit 7:4,	reg_Det3D_ChessBd_NHV_ofst	U4,  Noise immune offset for NON-Horizotnal or vertical combing detection.  
//Bit 3:0,	reg_Det3D_ChessBd_HV_ofst	U4,  Noise immune offset for Horizotnal or vertical combing detection.  
#define DET3D_SPLT_CFG                             ((0x1736  << 2) + 0xd0100000)
//Bit 7:4,	reg_Det3D_SplitValid_ratio	U4,  Ratio between max_value and the avg_value of the edge mapping for split line valid detection. 
//                                      The smaller of this value, the easier of the split line detected. 
//Bit 3:0,	reg_Det3D_AvgIdx_ratio	    U4,  Ratio to the avg_value of the edge mapping for split line position estimation. 
//                                      The smaller of this value, the more samples will be added to the estimation.
#define DET3D_HV_MUTE                              ((0x1737  << 2) + 0xd0100000)
//Bit 23:20, reg_Det3D_Edge_Ver_Mute	U4  X2: Horizontal pixels to be mute from H/V Edge calculation Top and Bottom border part. 
//Bit 19:16, reg_Det3D_Edge_Hor_Mute	U4  X2: Horizontal pixels to be mute from H/V Edge calculation Left and right border part. 
//Bit 15:12, reg_Det3D_ChessBd_Ver_Mute	U4  X2: Horizontal pixels to be mute from ChessBoard statistics calculation in middle part 
//Bit 11:8,	 reg_Det3D_ChessBd_Hor_Mute	U4  X2: Horizontal pixels to be mute from ChessBoard statistics calculation in middle part 
//Bit 7:4,	 reg_Det3D_STA8X8_Ver_Mute	U4  1X: Vertical pixels to be mute from 8x8 statistics calculation in each block. 
//Bit 3:0,	 reg_Det3D_STA8X8_Hor_Mute	U4  1X: Horizontal pixels to be mute from 8x8 statistics calculation in each block. 
#define DET3D_MAT_STA_P1M1                         ((0x1738  << 2) + 0xd0100000)
//Bit 31:24, reg_Det3D_STA8X8_P1_K0_R8	U8  SAD to SAI ratio to decide P1, normalized to 256 (0.8)
//Bit 23:16, reg_Det3D_STA8X8_P1_K1_R7	U8  SAD to ENG ratio to decide P1, normalized to 128 (0.5)
//Bit 15:8,	 reg_Det3D_STA8X8_M1_K0_R6	U8  SAD to SAI ratio to decide M1, normalized to 64  (1.1)
//Bit 7:0,	 reg_Det3D_STA8X8_M1_K1_R6	U8  SAD to ENG ratio to decide M1, normalized to 64  (0.8)
#define DET3D_MAT_STA_P1TH                         ((0x1739  << 2) + 0xd0100000)
//Bit 23:16, reg_Det3D_STAYUV_P1_TH_L4	U8  SAD to ENG Thrd offset to decide P1, X16         (100)   
//Bit 15:8,	 reg_Det3D_STAEDG_P1_TH_L4	U8  SAD to ENG Thrd offset to decide P1, X16         (80)
//Bit 7:0,	 reg_Det3D_STAMOT_P1_TH_L4	U8  SAD to ENG Thrd offset to decide P1, X16         (48)
#define DET3D_MAT_STA_M1TH                         ((0x173a  << 2) + 0xd0100000)
//Bit 23:16, reg_Det3D_STAYUV_M1_TH_L4	U8  SAD to ENG Thrd offset to decide M1, X16         (100)
//Bit 15:8,	 reg_Det3D_STAEDG_M1_TH_L4	U8  SAD to ENG Thrd offset to decide M1, X16         (80)
//Bit 7:0,	 reg_Det3D_STAMOT_M1_TH_L4	U8  SAD to ENG Thrd offset to decide M1, X16         (64)
#define DET3D_MAT_STA_RSFT                         ((0x173b  << 2) + 0xd0100000)
//Bit 5:4,	 reg_Det3D_STAYUV_RSHFT	    U2  YUV statistics SAD and SAI calculation result right shift bits to accommodate the 12bits clipping: 
//                                      0: mainly for images <=720x480: 1: mainly for images <=1366x768: 2: mainly for images <=1920X1080: 2; 3: other higher resolutions
//Bit 3:2,	 reg_Det3D_STAEDG_RSHFT	    U2  Horizontal and Vertical Edge Statistics SAD and SAI calculation result right shift bits to accommodate the 12bits clipping: 
//                                      0: mainly for images <=720x480: 1: mainly for images <=1366x768: 2: mainly for images <=1920X1080: 2; 3: other higher resolutions
//Bit 1:0,	 reg_Det3D_STAMOT_RSHFT	    U2  Motion SAD and SAI calculation result right shift bits to accommodate the 12bits clipping: 
//                                      0: mainly for images <=720x480: 1: mainly for images <=1366x768: 2: mainly for images <=1920X1080: 2; 3: other higher resolutions
#define DET3D_MAT_SYMTC_TH                         ((0x173c  << 2) + 0xd0100000)
//Bit 31:24, reg_Det3D_STALUM_symtc_Th	  U8  threshold to decide if the Luma statistics is TB or LR symmetric. 
//Bit 23:16, reg_Det3D_STACHR_symtc_Th	  U8  threshold to decide if the Chroma (UV) statistics is TB or LR symmetric. 
//Bit 15:8,	 reg_Det3D_STAEDG_symtc_Th	  U8  threshold to decide if the Horizontal and Vertical Edge statistics is TB or LR symmetric. 
//Bit 7:0,	 reg_Det3D_STAMOT_symtc_Th	  U8  threshold to decide if the Motion statistics is TB or LR symmetric. 
#define DET3D_RO_DET_CB_HOR                        ((0x173d  << 2) + 0xd0100000)
//Bit 31:16, RO_Det3D_ChessBd_NHor_value    U16  X64: number of Pixels of Horizontally Surely NOT matching Chessboard pattern.
//Bit 15:0,	 RO_Det3D_ChessBd_Hor_value	    U16  X64: number of Pixels of Horizontally Surely matching Chessboard pattern.
#define DET3D_RO_DET_CB_VER                        ((0x173e  << 2) + 0xd0100000)
//Bit 31:16, RO_Det3D_ChessBd_NVer_value	U16  X64: number of Pixels of Vertically Surely NOT matching Chessboard pattern.
//Bit 15:0,	 RO_Det3D_ChessBd_Ver_value	    U16  X64: number of Pixels of Vertically Surely matching Chessboard pattern.
#define DET3D_RO_SPLT_HT                           ((0x173f  << 2) + 0xd0100000)
//Bit 24,	 RO_Det3D_Split_HT_valid	U1  horizontal LR split border detected valid signal for top half picture
//Bit 20:16, RO_Det3D_Split_HT_pxnum	U5  number of pixels included for the LR split position estimation for top half picture
//Bit 9:0,	 RO_Det3D_Split_HT_idxX4	S10  X4: horizontal pixel shifts of LR split position to the (ColMax/2) for top half picture
//// DET 3D REG DEFINE END ////
//// NR2 REG DEFINE BEGIN////
#define NR2_MET_NM_CTRL                            ((0x1745  << 2) + 0xd0100000)
//Bit 28,	   reg_NM_reset	          Reset to the status of the Loop filter.
//Bit 27:24,   reg_NM_calc_length	  Length mode of the Noise measurement sample number for statistics.
//                                    0:  256 samples;    1: 512 samples;    2: 1024 samples;   ¡­X: 2^(8+x) samples
//Bit 23:20,   reg_NM_inc_step	      Loop filter input gain increase step. 
//Bit 19:16,   reg_NM_dec_step	      Loop filter input gain decrease step. 
//Bit 15:8,	   reg_NM_YHPmot_thrd	  Luma channel HP portion motion for condition of pixels included in Luma Noise measurement. 
//Bit 7:0,	   reg_NM_CHPmot_thrd	  Chroma channel HP portion motion for condition of pixels included in Chroma Noise measurement. 
#define NR2_MET_NM_YCTRL                           ((0x1746  << 2) + 0xd0100000)
//Bit 31:28,   reg_NM_YPLL_target	      Target rate of NM_Ynoise_thrd to mean of the Luma Noise 
//Bit 27:24,   reg_NM_YLPmot_thrd	      Luma channel LP portion motion for condition of pixels included in Luma Noise measurement. 
//Bit 23:16,   reg_NM_YHPmot_thrd_min	  Minimum threshold for Luma channel HP portion motion to decide whether the pixel will be included in Luma noise measurement. 
//Bit 15:8,	   reg_NM_YHPmot_thrd_max	  Maximum threshold for Luma channel HP portion motion to decide whether the pixel will be included in Luma noise measurement. 
//Bit 7:0,	   reg_NM_Ylock_rate	      Rate to decide whether the Luma noise measurement is lock or not.
#define NR2_MET_NM_CCTRL                           ((0x1747  << 2) + 0xd0100000)
//Bit 31:28,	reg_NM_CPLL_target	     Target rate of NM_Cnoise_thrd to mean of the Chroma Noise 
//Bit 27:24,	reg_NM_CLPmot_thrd	     Chroma channel LP portion motion for condition of pixels included in Chroma Noise measurement. 
//Bit 23:16,	reg_NM_CHPmot_thrd_min	 Minimum threshold for Chroma channel HP portion motion to decide whether the pixel will be included in Chroma noise measurement. 
//Bit 15:8,	    reg_NM_CHPmot_thrd_max	 Maximum threshold for Chroma channel HP portion motion to decide whether the pixel will be included in Chroma noise measurement. 
//Bit 7:0,	    reg_NM_Clock_rate	     Rate to decide whether the Chroma noise measurement is lock or not;
#define NR2_MET_NM_TNR                             ((0x1748  << 2) + 0xd0100000)
//Bit 25,	    ro_NM_TNR_Ylock	         Read-only register to tell ifLuma channel noise measurement is locked or not. 
//Bit 24,	    ro_NM_TNR_Clock	         Read-only register to tell if Chroma channel noise measurement is locked or not. 
//Bit 23:12,	ro_NM_TNR_Ylevel	     Read-only register to give Luma channel noise level. It was 16x of pixel difference in 8 bits of YHPmot. 
//Bit 11:0,	ro_NM_TNR_Clevel	         Read-only register to give Chroma channel noise level. It was 16x of pixel difference in 8 bits of CHPmot. 
#define NR2_MET_NMFRM_TNR_YLEV                     ((0x1749  << 2) + 0xd0100000)
//Bit 28:0,	ro_NMFrm_TNR_Ylevel	         Frame based Read-only register to give Luma channel noise level within one frame/field. 
#define NR2_MET_NMFRM_TNR_YCNT                     ((0x174a  << 2) + 0xd0100000)
//Bit 23:0,	ro_NMFrm_TNR_Ycount	         Number ofLuma channel pixels included in Frame/Field based noise level measurement.
#define NR2_MET_NMFRM_TNR_CLEV                     ((0x174b  << 2) + 0xd0100000)
//Bit 28:0,	ro_NMFrm_TNR_Clevel	         Frame based Read-only register to give Chroma channel noise level within one frame/field.
#define NR2_MET_NMFRM_TNR_CCNT                     ((0x174c  << 2) + 0xd0100000)
//Bit 23:0,	ro_NMFrm_TNR_Ccount	         Number of Chroma channel pixels included in Frame/Field based noise level measurement. 
#define NR2_3DEN_MODE                              ((0x174d  << 2) + 0xd0100000)
//Bit 6:4,	Blend_3dnr_en_r	
//Bit 2:0,	Blend_3dnr_en_l	
#define NR2_IIR_CTRL                               ((0x174e  << 2) + 0xd0100000)
//Bit 15:14, reg_LP_IIR_8bit_mode	LP IIR membitwidth mode:0: 10bits will be store in memory;1: 9bits will be store in memory;
//                                  2: 8bits will be store in memory;3: 7bits will be store in memory;
//Bit 13:12, reg_LP_IIR_mute_mode	Mode for the LP IIR mute,
//Bit 11:8,	 reg_LP_IIR_mute_thrd	Threshold of LP IIR mute to avoid ghost:
//Bit 7:6,	 reg_HP_IIR_8bit_mode	IIR membitwidth mode:0: 10bits will be store in memory;1: 9bits will be store in memory;
//                                  2: 8bits will be store in memory;3: 7bits will be store in memory;
//Bit 5:4,	reg_HP_IIR_mute_mode	Mode for theLP IIR mute
//Bit 3:0,	reg_HP_IIR_mute_thrd	Threshold of HP IIR mute to avoid ghost
//
#define NR2_SW_EN                                  ((0x174f  << 2) + 0xd0100000)
//Bit 17:8,	Clk_gate_ctrl	
//Bit 7,	Cfr_enable	
//Bit 5,	Det3d_en	
//Bit 4,	Nr2_proc_en	
//Bit 0,	Nr2_sw_en	
#define NR2_FRM_SIZE                               ((0x1750  << 2) + 0xd0100000)
//Bit 27:16,  Frm_heigh	Frame/field height
//Bit 11: 0,  Frm_width	Frame/field width
#define NR2_SNR_SAD_CFG                            ((0x1751  << 2) + 0xd0100000)
//Bit 12,	reg_MATNR_SNR_SAD_CenRPL	U1, Enable signal for Current pixel position SAD to be replaced by SAD_min.0: do not replace Current pixel position SAD by SAD_min;1: do replacements
//Bit 11:8,	reg_MATNR_SNR_SAD_coring	Coring value of the intra-frame SAD. sum = (sum - reg_MATNR_SNR_SAD_coring);sum = (sum<0) ? 0: (sum>255)? 255: sum;
//Bit 6:5,	reg_MATNR_SNR_SAD_WinMod	Unsigned, Intra-frame SAD matching window mode:0: 1x1; 1: [1 1 1] 2: [1 2 1]; 3: [1 2 2 2 1];
//Bit 4:0,	Sad_coef_num	            Sad coeffient
#define NR2_MATNR_SNR_OS                           ((0x1752  << 2) + 0xd0100000)
//Bit 7:4,	reg_MATNR_SNR_COS	    SNR Filter overshoot control margin for UV channel (X2 to u10 scale)
//Bit 3:0,	reg_MATNR_SNR_YOS	    SNR Filter overshoot control margin for luma channel (X2 to u10 scale)
#define NR2_MATNR_SNR_NRM_CFG                      ((0x1753  << 2) + 0xd0100000)
//Bit 23:16,	reg_MATNR_SNR_NRM_ofst	Edge based SNR boosting normalization offset to SAD_max ;
//Bit 15:8,	    reg_MATNR_SNR_NRM_max	Edge based SNR boosting normalization Max value
//Bit 7:0,	    reg_MATNR_SNR_NRM_min	Edge based SNR boosting normalization Min value
#define NR2_MATNR_SNR_NRM_GAIN                     ((0x1754  << 2) + 0xd0100000)
//Bit 15:8,	reg_MATNR_SNR_NRM_Cgain	Edge based SNR boosting normalization Gain for Chrm channel (norm 32 as 1)
//Bit 7:0,	reg_MATNR_SNR_NRM_Ygain	Edge based SNR boosting normalization Gain for Luma channel (norm 32 as 1)
#define NR2_MATNR_SNR_LPF_CFG                      ((0x1755  << 2) + 0xd0100000)
//Bit 23:16,reg_MATNR_SNRLPF_SADmaxTH	U8,  Threshold to SADmax to use TNRLPF to replace SNRLPF. i.e.if (SAD_max<reg_MATNR_SNRLPF_SADmaxTH) SNRLPF_yuv[k] = TNRLPF_yuv[k];
//Bit 13:11,reg_MATNR_SNRLPF_Cmode	    LPF based SNR filtering mode on CHRM channel:
//                                      0: gradient LPF [1 1]/2, 1: gradient LPF [2 1 1]/4; 2: gradient LPF [3 3 2]/8; 3: gradient LPF [5 4 4 3]/16;  
//                                      4: TNRLPF;  5 : CurLPF3x3_yuv[];  6: CurLPF3o3_yuv[]  7: CurLPF3x5_yuv[]
//Bit 10:8,	reg_MATNR_SNRLPF_Ymode	    LPF based SNR filtering mode on LUMA channel:
//                                      0: gradient LPF //Bit [1 1]/2, 1: gradient LPF [2 1 1]/4; 2: gradient LPF [3 3 2]/8;3: gradient LPF [5 4 4 3]/16;      
//                                      4: TNRLPF;               5 : CurLPF3x3_yuv[];       6: CurLPF3o3_yuv[]         7: CurLPF3x5_yuv[]
//Bit 7:4,	reg_MATNR_SNRLPF_SADmin3TH	Offset threshold to SAD_min to Discard SAD_min3 corresponding pixel in LPF SNR filtering. (X8 to u8 scale) 
//Bit 3:0,	reg_MATNR_SNRLPF_SADmin2TH	Offset threshold to SAD_min to Discard SAD_min2 corresponding pixel in LPF SNR filtering. (X8 to u8 scale) 
#define NR2_MATNR_SNR_USF_GAIN                     ((0x1756  << 2) + 0xd0100000)
//Bit 15:8,	reg_MATNR_SNR_USF_Cgain	    Un-sharp (HP) compensate back Chrm portion gain, (norm 64 as 1)
//Bit 7:0,	reg_MATNR_SNR_USF_Ygain	    Un-sharp (HP) compensate back Luma portion gain, (norm 64 as 1)
#define NR2_MATNR_SNR_EDGE2B                       ((0x1757  << 2) + 0xd0100000)
//Bit 15:8,	reg_MATNR_SNR_Edge2Beta_ofst	U8,  Offset for Beta based on Edge.
//Bit 7:0,	reg_MATNR_SNR_Edge2Beta_gain	U8.  Gain to SAD_min for Beta based on Edge. (norm 16 as 1) 
#define NR2_MATNR_BETA_EGAIN                       ((0x1758  << 2) + 0xd0100000)
//Bit 15:8,	reg_MATNR_CBeta_Egain	U8,  Gain to Edge based Beta for Chrm channel. (normalized to 32 as 1)
//Bit 7:0,	reg_MATNR_YBeta_Egain	U8,  Gain to Edge based Beta for Luma channel. (normalized to 32 as 1)
#define NR2_MATNR_BETA_BRT                         ((0x1759  << 2) + 0xd0100000)
//Bit 31:28,	reg_MATNR_beta_BRT_limt_hi	U4,  Beta adjustment based on Brightness high side Limit. (X16 to u8 scale)
//Bit 27:24,	reg_MATNR_beta_BRT_slop_hi	U4,  Beta adjustment based on Brightness high side slope. Normalized to 16 as 1
//Bit 23:16,	reg_MATNR_beta_BRT_thrd_hi	U8,  Beta adjustment based on Brightness high threshold.(u8 scale)
//Bit 15:12,	reg_MATNR_beta_BRT_limt_lo	U4,  Beta adjustment based on Brightness low side Limit. (X16 to u8 scale)
//Bit 11:8,	    reg_MATNR_beta_BRT_slop_lo	U4,  Beta adjustment based on Brightness low side slope. Normalized to 16 as 1
//Bit 7:0,	    reg_MATNR_beta_BRT_thrd_lo	U8,  Beta adjustment based on Brightness low threshold.(u8 scale)
#define NR2_MATNR_XBETA_CFG                        ((0x175a  << 2) + 0xd0100000)
//Bit 19:18,	reg_MATNR_CBeta_use_mode	U2,  Beta options (mux) from beta_motion and beta_edge for Chrm channel;  
//Bit 17:16,	reg_MATNR_YBeta_use_mode	U2,  Beta options (mux) from beta_motion and beta_edge for Luma channel;
//Bit 15: 8,	reg_MATNR_CBeta_Ofst	    U8,  Offset to Beta for Chrm channel.(after beta_edge and beta_motion mux)
//Bit  7: 0,	reg_MATNR_YBeta_Ofst	    U8,  Offset to Beta for Luma channel.(after beta_edge and beta_motion mux)
#define NR2_MATNR_YBETA_SCL                        ((0x175b  << 2) + 0xd0100000)
//Bit 31:24,	reg_MATNR_YBeta_scale_min	U8,  Final step Beta scale low limit for Luma channel;
//Bit 23:16,	reg_MATNR_YBeta_scale_max	U8,  Final step Beta scale high limit for Luma channe;
//Bit 15: 8,	reg_MATNR_YBeta_scale_gain	U8,  Final step Beta scale Gain for Luma channel (normalized 32 to 1);
//Bit 7 : 0,	reg_MATNR_YBeta_scale_ofst	S8,  Final step Beta scale offset for Luma channel ;
#define NR2_MATNR_CBETA_SCL                        ((0x175c  << 2) + 0xd0100000)
//Bit 31:24,	reg_MATNR_CBeta_scale_min	Final step Beta scale low limit for Chrm channel.Similar to Y
//Bit 23:16,	reg_MATNR_CBeta_scale_max	U8,  Final step Beta scale high limit for Chrm channel.Similar to Y
//Bit 15: 8,	reg_MATNR_CBeta_scale_gain	U8,  Final step Beta scale Gain for Chrm channel Similar to Y
//Bit  7: 0,	reg_MATNR_CBeta_scale_ofst	S8,  Final step Beta scale offset for Chrm channel Similar to Y
#define NR2_SNR_MASK                               ((0x175d  << 2) + 0xd0100000)
//Bit 20:0, 	SAD_MSK	                    Valid signal in the 3x7 SAD surface
#define NR2_SAD2NORM_LUT0                          ((0x175e  << 2) + 0xd0100000)
//Bit 31:24,	reg_MATNR_SAD2Norm_LUT_3	SAD convert normal LUT node 3
//Bit 23:16,	reg_MATNR_SAD2Norm_LUT_2	SAD convert normal LUT node 2
//Bit 15: 8,	reg_MATNR_SAD2Norm_LUT_1	SAD convert normal LUT node 1
//Bit  7: 0,	reg_MATNR_SAD2Norm_LUT_0	SAD convert normal LUT node 0
#define NR2_SAD2NORM_LUT1                          ((0x175f  << 2) + 0xd0100000)
//Bit 31:24,	reg_MATNR_SAD2Norm_LUT_7	SAD convert normal LUT node 7
//Bit 23:16,	reg_MATNR_SAD2Norm_LUT_6	SAD convert normal LUT node 6
//Bit 15: 8,	reg_MATNR_SAD2Norm_LUT_5	SAD convert normal LUT node 5
//Bit  7: 0,	reg_MATNR_SAD2Norm_LUT_4	SAD convert normal LUT node 4
#define NR2_SAD2NORM_LUT2                          ((0x1760  << 2) + 0xd0100000)
//Bit 31:24,	reg_MATNR_SAD2Norm_LUT_11	SAD convert normal LUT node 11
//Bit 23:16,	reg_MATNR_SAD2Norm_LUT_10	SAD convert normal LUT node 10
//Bit 15: 8,	reg_MATNR_SAD2Norm_LUT_9	SAD convert normal LUT node 9
//Bit  7: 0,	reg_MATNR_SAD2Norm_LUT_8	SAD convert normal LUT node 8
#define NR2_SAD2NORM_LUT3                          ((0x1761  << 2) + 0xd0100000)
//Bit 31:24,	reg_MATNR_SAD2Norm_LUT_15	SAD convert normal LUT node 15
//Bit 23:16,	reg_MATNR_SAD2Norm_LUT_14	SAD convert normal LUT node 14
//Bit 15:8,	reg_MATNR_SAD2Norm_LUT_13	SAD convert normal LUT node 13
//Bit 7:0,	reg_MATNR_SAD2Norm_LUT_12	SAD convert normal LUT node 12
#define NR2_EDGE2BETA_LUT0                         ((0x1762  << 2) + 0xd0100000)
//Bit 31:24,	reg_MATNR_Edge2Beta_LUT_3	Edge convert beta LUT node 3
//Bit 23:16,	reg_MATNR_Edge2Beta_LUT_2	Edge convert beta LUT node 2
//Bit 15: 8,	reg_MATNR_Edge2Beta_LUT_1	Edge convert beta LUT node 1
//Bit  7: 0,	reg_MATNR_Edge2Beta_LUT_0	Edge convert beta LUT node 0
#define NR2_EDGE2BETA_LUT1                         ((0x1763  << 2) + 0xd0100000)
//Bit 31:24,	reg_MATNR_Edge2Beta_LUT_7	Edge convert beta LUT node 7
//Bit 23:16,	reg_MATNR_Edge2Beta_LUT_6	Edge convert beta LUT node 6
//Bit 15: 8,	reg_MATNR_Edge2Beta_LUT_5	Edge convert beta LUT node 5
//Bit  7: 0,	reg_MATNR_Edge2Beta_LUT_4	Edge convert beta LUT node 4
#define NR2_EDGE2BETA_LUT2                         ((0x1764  << 2) + 0xd0100000)
//Bit 31:24,	reg_MATNR_Edge2Beta_LUT_11	Edge convert beta LUT node 11
//Bit 23:16,	reg_MATNR_Edge2Beta_LUT_10	Edge convert beta LUT node 10
//Bit 15: 8,	reg_MATNR_Edge2Beta_LUT_9	Edge convert beta LUT node 9
//Bit  7: 0,	reg_MATNR_Edge2Beta_LUT_8	Edge convert beta LUT node 8
#define NR2_EDGE2BETA_LUT3                         ((0x1765  << 2) + 0xd0100000)
//Bit 31:24,	reg_MATNR_Edge2Beta_LUT_15	Edge convert beta LUT node 15
//Bit 23:16,	reg_MATNR_Edge2Beta_LUT_14	Edge convert beta LUT node 14
//Bit 15: 8,	reg_MATNR_Edge2Beta_LUT_13	Edge convert beta LUT node 13
//Bit  7: 0,	reg_MATNR_Edge2Beta_LUT_12	Edge convert beta LUT node 12
#define NR2_MOTION2BETA_LUT0                       ((0x1766  << 2) + 0xd0100000)
//Bit 31:24,	reg_MATNR_Mot2Beta_LUT_3	Motion convert beta LUT node 3
//Bit 23:16,	reg_MATNR_Mot2Beta_LUT_2	Motion convert beta LUT node 2
//Bit 15: 8,	reg_MATNR_Mot2Beta_LUT_1	Motion convert beta LUT node 1
//Bit  7: 0,	reg_MATNR_Mot2Beta_LUT_0	Motion convert beta LUT node 0
#define NR2_MOTION2BETA_LUT1                       ((0x1767  << 2) + 0xd0100000)
//Bit 31:24,	reg_MATNR_Mot2Beta_LUT_7	Motion convert beta LUT node 7
//Bit 23:16,	reg_MATNR_Mot2Beta_LUT_6	Motion convert beta LUT node 6
//Bit 15: 8,	reg_MATNR_Mot2Beta_LUT_5	Motion convert beta LUT node 5
//Bit  7: 0,	reg_MATNR_Mot2Beta_LUT_4	Motion convert beta LUT node 4
#define NR2_MOTION2BETA_LUT2                       ((0x1768  << 2) + 0xd0100000)
//Bit 31:24,	reg_MATNR_Mot2Beta_LUT_11	Motion convert beta LUT node 11
//Bit 23:16,	reg_MATNR_Mot2Beta_LUT_10	Motion convert beta LUT node 10
//Bit 15: 8,	reg_MATNR_Mot2Beta_LUT_9	Motion convert beta LUT node 9
//Bit  7: 0,	reg_MATNR_Mot2Beta_LUT_8	Motion convert beta LUT node 8
#define NR2_MOTION2BETA_LUT3                       ((0x1769  << 2) + 0xd0100000)
//Bit 31:24,	reg_MATNR_Mot2Beta_LUT_15	Motion convert beta LUT node 15
//Bit 23:16,	reg_MATNR_Mot2Beta_LUT_14	Motion convert beta LUT node 14
//Bit 15: 8,	reg_MATNR_Mot2Beta_LUT_13	Motion convert beta LUT node 13
//Bit  7: 0,	reg_MATNR_Mot2Beta_LUT_12	Motion convert beta LUT node 12
#define NR2_MATNR_MTN_CRTL                         ((0x176a  << 2) + 0xd0100000)
//Bit 25:24,	reg_MATNR_Vmtn_use_mode	    Motion_yuvV channel motion selection mode:0: Vmot;1:Ymot/2 + (Umot+Vmot)/4; 2:Ymot/2 + max(Umot,Vmot)/2; 3: max(Ymot,Umot, Vmot)  
//Bit 21:20,	reg_MATNR_Umtn_use_mode	    Motion_yuvU channel motion selection mode:0:Umot;1:Ymot/2 + (Umot+Vmot)/4; 2:Ymot/2 + max(Umot,Vmot)/2; 3: max(Ymot,Umot, Vmot)  
//Bit 17:16,	reg_MATNR_Ymtn_use_mode	    Motion_yuvLuma channel motion selection mode:0:  Ymot, 1: Ymot/2 + (Umot+Vmot)/4; 2: Ymot/2 + max(Umot,Vmot)/2; 3:  max(Ymot,Umot, Vmot)   
//Bit 13:12,	reg_MATNR_mtn_txt_mode	    Texture detection mode for adaptive coring of HP motion
//Bit  9: 8,	reg_MATNR_mtn_cor_mode	    Coring selection mode based on texture detection;
//Bit  6: 4,	reg_MATNR_mtn_hpf_mode	    video mode of current and previous frame/field for MotHPF_yuv[k] calculation:
//Bit  2: 0,	reg_MATNR_mtn_lpf_mode	    LPF video mode of current and previous frame/field for MotLPF_yuv[k] calculation:
#define NR2_MATNR_MTN_CRTL2                        ((0x176b  << 2) + 0xd0100000)
//Bit 18:16,	reg_MATNR_iir_BS_Ymode	    IIR TNR filter Band split filter mode for Luma LPF result generation (Cur and Prev);
//Bit 15: 8,	reg_MATNR_mtnb_alpLP_Cgain	Scale of motion_brthp_uv to motion_brtlp_uv, normalized to 32 as 1
//Bit  7: 0,	reg_MATNR_mtnb_alpLP_Ygain	Scale of motion_brthp_y to motion_brtlp_y, normalized to 32 as 1
#define NR2_MATNR_MTN_COR                          ((0x176c  << 2) + 0xd0100000)
//Bit 15:12,	reg_MATNR_mtn_cor_Cofst	    Coring Offset for Chroma Motion.
//Bit 11: 8,	reg_MATNR_mtn_cor_Cgain	    Gain to texture based coring for Chroma Motion. Normalized to 16 as 1
//Bit  7: 4,	reg_MATNR_mtn_cor_Yofst	    Coring Offset for Luma Motion.
//Bit  3: 0,	reg_MATNR_mtn_cor_Ygain	    Gain to texture based coring for Luma Motion. Normalized to 16 as 1
#define NR2_MATNR_MTN_GAIN                         ((0x176d  << 2) + 0xd0100000)
//Bit 31:24,	reg_MATNR_mtn_hp_Cgain	Gain to MotHPF_yuv[k] Chrm channel for motion calculation, normalized to 64 as 1
//Bit 23:16,	reg_MATNR_mtn_hp_Ygain	Gain to MotHPF_yuv[k] Luma channel for motion calculation, normalized to 64 as 1
//Bit 15: 8,	reg_MATNR_mtn_lp_Cgain	Gain to MotLPF_yuv[k] Chrm channel for motion calculation, normalized to 32 as 1
//Bit  7: 0,	reg_MATNR_mtn_lp_Ygain	Gain to MotLPF_yuv[k] Luma channel for motion calculation, normalized to 32 as 1
#define NR2_MATNR_DEGHOST                          ((0x176e  << 2) + 0xd0100000)
//Bit 8,	reg_MATNR_DeGhost_En	Enable signal for DeGhost function:0: disable; 1: enable  
//Bit 7:4,	reg_MATNR_DeGhost_COS	DeGhost Overshoot margin for UV channel, (X2 to u10 scale)
//Bit 3:0,	reg_MATNR_DeGhost_YOS	DeGhost Overshoot margin for Luma channel, (X2 to u10 scale)
#define NR2_MATNR_ALPHALP_LUT0                     ((0x176f  << 2) + 0xd0100000)
//Bit 31:24,	reg_MATNR_AlphaLP_LUT_3	    Matnr low-pass filter alpha LUT node 3
//Bit 23:16,	reg_MATNR_AlphaLP_LUT_2	    Matnr low-pass filter alpha LUT node 2
//Bit 15: 8,	reg_MATNR_AlphaLP_LUT_1	    Matnr low-pass filter alpha LUT node 1
//Bit  7: 0,	reg_MATNR_AlphaLP_LUT_0	    Matnr low-pass filter alpha LUT node 0
#define NR2_MATNR_ALPHALP_LUT1                     ((0x1770  << 2) + 0xd0100000)
//Bit 31:24,	reg_MATNR_AlphaLP_LUT_7	    Matnr low-pass filter alpha LUT node 7
//Bit 23:16,	reg_MATNR_AlphaLP_LUT_6	    Matnr low-pass filter alpha LUT node 6
//Bit 15: 8,	reg_MATNR_AlphaLP_LUT_5	    Matnr low-pass filter alpha LUT node 5
//Bit  7: 0,	reg_MATNR_AlphaLP_LUT_4	    Matnr low-pass filter alpha LUT node 4
#define NR2_MATNR_ALPHALP_LUT2                     ((0x1771  << 2) + 0xd0100000)
//Bit 31:24,	reg_MATNR_AlphaLP_LUT_11	Matnr low-pass filter alpha LUT node 11
//Bit 23:16,	reg_MATNR_AlphaLP_LUT_10	Matnr low-pass filter alpha LUT node 10
//Bit 15: 8,	reg_MATNR_AlphaLP_LUT_9	    Matnr low-pass filter alpha LUT node 9
//Bit  7: 0,	reg_MATNR_AlphaLP_LUT_8	    Matnr low-pass filter alpha LUT node 8
#define NR2_MATNR_ALPHALP_LUT3                     ((0x1772  << 2) + 0xd0100000)
//Bit 31:24,	reg_MATNR_AlphaLP_LUT_15	Matnr low-pass filter alpha LUT node 15
//Bit 23:16,	reg_MATNR_AlphaLP_LUT_14	Matnr low-pass filter alpha LUT node 14
//Bit 15: 8,	reg_MATNR_AlphaLP_LUT_13	Matnr low-pass filter alpha LUT node 13
//Bit  7: 0,	reg_MATNR_AlphaLP_LUT_12	Matnr low-pass filter alpha LUT node 12
#define NR2_MATNR_ALPHAHP_LUT0                     ((0x1773  << 2) + 0xd0100000)
//Bit 31:24,	reg_MATNR_AlphaHP_LUT_3	    Matnr high-pass filter alpha LUT node 3
//Bit 23:16,	reg_MATNR_AlphaHP_LUT_2	    Matnr high-pass filter alpha LUT node 2
//Bit 15: 8,	reg_MATNR_AlphaHP_LUT_1	    Matnr high-pass filter alpha LUT node 1
//Bit  7: 0,	reg_MATNR_AlphaHP_LUT_0	    Matnr high-pass filter alpha LUT node 0
#define NR2_MATNR_ALPHAHP_LUT1                     ((0x1774  << 2) + 0xd0100000)
//Bit 31:24,	reg_MATNR_AlphaHP_LUT_7	    Matnr high-pass filter alpha LUT node 7
//Bit 23:16,	reg_MATNR_AlphaHP_LUT_6	    Matnr high-pass filter alpha LUT node 6
//Bit 15: 8,	reg_MATNR_AlphaHP_LUT_5	    Matnr high-pass filter alpha LUT node 5
//Bit  7: 0,	reg_MATNR_AlphaHP_LUT_4	    Matnr high-pass filter alpha LUT node 4
#define NR2_MATNR_ALPHAHP_LUT2                     ((0x1775  << 2) + 0xd0100000)
//Bit 31:24,	reg_MATNR_AlphaHP_LUT_11	Matnr high-pass filter alpha LUT node 11
//Bit 23:16,	reg_MATNR_AlphaHP_LUT_10	Matnr high-pass filter alpha LUT node 10
//Bit 15: 8,	reg_MATNR_AlphaHP_LUT_9	    Matnr high-pass filter alpha LUT node 9
//Bit  7: 0,	reg_MATNR_AlphaHP_LUT_8	    Matnr high-pass filter alpha LUT node 8
#define NR2_MATNR_ALPHAHP_LUT3                     ((0x1776  << 2) + 0xd0100000)
//Bit 31:24,	reg_MATNR_AlphaHP_LUT_15	Matnr high-pass filter alpha LUT node 15
//Bit 23:16,	reg_MATNR_AlphaHP_LUT_14	Matnr high-pass filter alpha LUT node 14
//Bit 15: 8,	reg_MATNR_AlphaHP_LUT_13	Matnr high-pass filter alpha LUT node 13
//Bit  7: 0,	reg_MATNR_AlphaHP_LUT_12	Matnr high-pass filter alpha LUT node 12
#define NR2_MATNR_MTNB_BRT                         ((0x1777  << 2) + 0xd0100000)
//Bit 31:28,	reg_MATNR_mtnb_BRT_limt_hi	Motion adjustment based on Brightness high side Limit. (X16 to u8 scale)
//Bit 27:24,	reg_MATNR_mtnb_BRT_slop_hi	Motion adjustment based on Brightness high side slope. Normalized to 16 as 1
//Bit 23:16,	reg_MATNR_mtnb_BRT_thrd_hi	Motion adjustment based on Brightness high threshold.(u8 scale)
//Bit 15:12,	reg_MATNR_mtnb_BRT_limt_lo	Motion adjustment based on Brightness low side Limit. (X16 to u8 scale)
//Bit 11: 8,	reg_MATNR_mtnb_BRT_slop_lo	Motion adjustment based on Brightness low side slope. Normalized to 16 as 1
//Bit  7: 0,	reg_MATNR_mtnb_BRT_thrd_lo	Motion adjustment based on Brightness low threshold.(u8 scale)
#define NR2_CUE_MODE                               ((0x1778  << 2) + 0xd0100000)
//Bit 9,	Cue_enable_r	        Cue right half frame enable
//Bit 8,	Cue_enable_l            Cue left half frame enable 
//Bit 6:4,	reg_CUE_CON_RPLC_mode	U3, CUE pixel chroma replace mode;
//Bit 2:0,	reg_CUE_CHRM_FLT_mode	U3, CUE improvement filter mode,
#define NR2_CUE_CON_MOT_TH                         ((0x1779  << 2) + 0xd0100000)
//Bit 31:24,	reg_CUE_CON_Cmot_thrd2	U8,  Motion Detection threshold of up/down two rows,  Chroma channel in Chroma Up-sampling Error (CUE) Detection (tighter). 
//Bit 23:16,	reg_CUE_CON_Ymot_thrd2	U8,  Motion Detection threshold of up/mid/down three rows,  Luma channel in Chroma Up-sampling Error (CUE) Detection (tighter). 
//Bit 15: 8,	reg_CUE_CON_Cmot_thrd	U8,  Motion Detection threshold of up/down two rows, Chroma channel in Chroma Up-sampling Error (CUE) Detection.
//Bit  7: 0,	reg_CUE_CON_Ymot_thrd	U8,  Motion Detection threshold of up/mid/down three rows, Luma channel in Chroma Up-sampling Error (CUE) Detection. 
#define NR2_CUE_CON_DIF0                           ((0x177a  << 2) + 0xd0100000)
//Bit 15:8,	reg_CUE_CON_difP1_thrd	    U8,  P1 field Intra-Field top/below line chroma difference threshold, 
//Bit 7:0,	reg_CUE_CON_difCur_thrd	    U8,  Current Field/Frame Intra-Field up/down line chroma difference threshold, 
#define NR2_CUE_CON_DIF1                           ((0x177b  << 2) + 0xd0100000)
//Bit 19:16,	reg_CUE_CON_rate0	    U4,  The Krate to decide CUE by relationship between CUE_diflG and CUE_difEG 
//Bit 15: 8,	reg_CUE_CON_difEG_thrd	U8,  Theshold to the difference between current Field/Frame middle line to down line color channel(CUE_difEG). 
//Bit  7: 0,	reg_CUE_CON_diflG_thrd	U8,  Threshold to the difference between P1 field top line to current Field/Frame down line color channel (CUE_diflG).
#define NR2_CUE_CON_DIF2                           ((0x177c  << 2) + 0xd0100000)
//Bit 19:16,	reg_CUE_CON_rate1	    U4,  The Krate to decide CUE by relationship between CUE_difnC and CUE_difEC 
//Bit 15: 8,	reg_CUE_CON_difEC_thrd	U8,  Theshold to the difference between current Field/Frame middle line to up line color channel(CUE_difEC). 
//Bit  7: 0,	reg_CUE_CON_difnC_thrd	U8,  Threshold to the difference between P1 field bot line to current Field/Frame up line color channel (CUE_difnC). 
#define NR2_CUE_CON_DIF3                           ((0x177d  << 2) + 0xd0100000)
//Bit 19:16,	reg_CUE_CON_rate2	    U4,  The Krate to decide CUE by relationship between CUE_difP1 and CUE_difEP1 
//Bit 15: 8,	reg_CUE_CON_difEP1_thrd	U8,  Inter-Field top/below line to current field/frame middle line chroma difference (CUE_difEP1) threshold. 
//Bit  7: 0,	reg_CUE_CON_difP1_thrd2	U8,  P1 field Intra-Field top/below line chroma difference threshold (tighter), 
#define NR2_CUE_PRG_DIF                            ((0x177e  << 2) + 0xd0100000)
//Bit 20,	    reg_CUE_PRG_Enable	    Enable bit for progressive video CUE detection.If interlace input video, 
//Bit 19:16,	reg_CUE_PRG_rate	    U3,  The Krate to decide CUE by relationship between CUE_difCur and (CUE_difEC+CUE_difEG) 
//Bit 15: 8,	reg_CUE_PRG_difCEG_thrd	U8,  Current Frame Intra-Field up-mid and mid-down line chroma difference threshold for progressive video CUE detection, 
//Bit  7: 0,	reg_CUE_PRG_difCur_thrd	U8,  Current Frame Intra-Field up/down line chroma difference threshold, 
#define NR2_CONV_MODE                              ((0x177f  << 2) + 0xd0100000)
//Bit 3:2,	Conv_c444_mode	The format convert mode about 422 to 444 when data read out line buffer
//Bit 1:0,	Conv_c422_mode	the format convert mode about 444 to 422 when data write to line buffer 
//// NR2 REG DEFINE END ////
//// DET 3D REG DEFINE BEGIN ////
////  8'h80~8'h8f
#define DET3D_RO_SPLT_HB                           ((0x1780  << 2) + 0xd0100000)
//Bit 24,	    RO_Det3D_Split_HB_valid	    U1   horizontal LR split border detected valid signal for top half picture
//Bit 20:16,	RO_Det3D_Split_HB_pxnum	    U5   number of pixels included for the LR split position estimation for top half picture
//Bit  9: 0,	RO_Det3D_Split_HB_idxX4	    S10  X4: horizontal pixel shifts of LR split position to the (ColMax/2) for top half picture
#define DET3D_RO_SPLT_VL                           ((0x1781  << 2) + 0xd0100000)
//Bit 24,	    RO_Det3D_Split_VL_valid	    U1   horizontal LR split border detected valid signal for top half picture
//Bit 20:16,	RO_Det3D_Split_VL_pxnum	    U5   number of pixels included for the LR split position estimation for top half picture
//Bit  9: 0,	RO_Det3D_Split_VL_idxX4	    S10  X4: horizontal pixel shifts of LR split position to the (ColMax/2) for top half picture
#define DET3D_RO_SPLT_VR                           ((0x1782  << 2) + 0xd0100000)
//Bit 24   ,	RO_Det3D_Split_VR_valid	    U1   horizontal LR split border detected valid signal for top half picture
//Bit 20:16,	RO_Det3D_Split_VR_pxnum	    U5   number of pixels included for the LR split position estimation for top half picture
//Bit  9: 0,	RO_Det3D_Split_VR_idxX4	    S10  X4: horizontal pixel shifts of LR split position to the (ColMax/2) for top half picture
#define DET3D_RO_MAT_LUMA_LR                       ((0x1783  << 2) + 0xd0100000)
//Bit 15:0,	RO_Luma_LR_score	 S2*8  LUMA statistics left right decision score for each band (8bands vertically), 
//                               it can be -1/0/1:-1: most likely not LR symmetric 0: not sure 1: most likely LR symmetric
//Bit 7:0,	RO_Luma_LR_symtc	 U1*8  Luma statistics left right pure symmetric for each band (8bands vertically), 
//                               it can be 0/1: 0: not sure 1: most likely LR is pure symmetric
//Bit 4:0,	RO_Luma_LR_sum	     S5  Total score of 8x8 Luma statistics for LR like decision, 
//                               the larger this score, the more confidence that this is a LR 3D video. It is sum of  RO_Luma_LR_score[0~7]
#define DET3D_RO_MAT_LUMA_TB                       ((0x1784  << 2) + 0xd0100000)
//Bit 15:0,	RO_Luma_TB_score	 S2*8  LUMA statistics Top/Bottom decision score for each band (8bands Horizontally), 
//Bit 7:0,	RO_Luma_TB_symtc	 Luma statistics Top/Bottompure symmetric for each band (8bands Horizontally), 
//Bit 4:0,	RO_Luma_TB_sum	     Total score of 8x8 Luma statistics for TB like decision, 
#define DET3D_RO_MAT_CHRU_LR                       ((0x1785  << 2) + 0xd0100000)
//Bit 15:0,	RO_ChrU_LR_score	S2*8  LUMA statistics left right decision score for each band (8bands vertically), 
//Bit 7:0,	RO_ChrU_LR_symtc	CHRU statistics left right pure symmetric for each band (8bands vertically), 
//Bit 4:0,	RO_ChrU_LR_sum	    Total score of 8x8 ChrU statistics for LR like decision, 
#define DET3D_RO_MAT_CHRU_TB                       ((0x1786  << 2) + 0xd0100000)
//Bit 15:0,	RO_ChrU_TB_score	S2*8  CHRU statistics Top/Bottom decision score for each band (8bands Horizontally)
//Bit 7:0,	RO_ChrU_TB_symtc	CHRU statistics Top/Bottompure symmetric for each band (8bands Horizontally)
//Bit 4:0,	RO_ChrU_TB_sum	    Total score of 8x8 ChrU statistics for TB like decision
#define DET3D_RO_MAT_CHRV_LR                       ((0x1787  << 2) + 0xd0100000)
//Bit 15:0,	RO_ChrV_LR_score	S2*8  CHRUstatistics left right decision score for each band (8bands vertically)
//Bit 7:0,	RO_ChrV_LR_symtc	CHRV statistics left right pure symmetric for each band (8bands vertically)
//Bit 4:0,	RO_ChrV_LR_sum	    Total score of 8x8 ChrV statistics for LR like decision
#define DET3D_RO_MAT_CHRV_TB                       ((0x1788  << 2) + 0xd0100000)
//Bit 15:0,	RO_ChrV_TB_score	CHRV statistics Top/Bottom decision score for each band (8bands Horizontally)
//Bit 7:0,	RO_ChrV_TB_symtc	CHRV statistics Top/Bottompure symmetric for each band (8bands Horizontally)
//Bit 4:0,	RO_ChrV_TB_sum	    Total score of 8x8 ChrV statistics for TB like decision
#define DET3D_RO_MAT_HEDG_LR                       ((0x1789  << 2) + 0xd0100000)
//Bit 15:0,	RO_Hedg_LR_score	Horizontal Edge statistics left right decision score for each band (8bands vertically)
//Bit 7:0,	RO_Hedg_LR_symtc	Horizontal Edge statistics left right pure symmetric for each band (8bands vertically)
//Bit 4:0,	RO_Hedg_LR_sum	    Total score of 8x8 Hedg statistics for LR like decision
#define DET3D_RO_MAT_HEDG_TB                       ((0x178a  << 2) + 0xd0100000)
//Bit 15:0,	RO_Hedg_TB_score	Horizontal Edge statistics Top/Bottom decision score for each band (8bands Horizontally)
//Bit 7:0,	RO_Hedg_TB_symtc	Horizontal Edge statistics Top/Bottompure symmetric for each band (8bands Horizontally)
//Bit 4:0,	RO_Hedg_TB_sum	    Total score of 8x8 Hedg statistics for TB like decision
#define DET3D_RO_MAT_VEDG_LR                       ((0x178b  << 2) + 0xd0100000)
//Bit 15:0,	RO_Vedg_LR_score	Vertical Edge statistics left right decision score for each band (8bands vertically)
//Bit 7:0,	RO_Vedg_LR_symtc	Vertical Edge statistics left right pure symmetric for each band (8bands vertically)
//Bit 4:0,	RO_Vedg_LR_sum	    Total score of 8x8 Vedg statistics for LR like decision
#define DET3D_RO_MAT_VEDG_TB                       ((0x178c  << 2) + 0xd0100000)
//Bit 15:0,	RO_Vedg_TB_score	Vertical Edge statistics Top/Bottom decision score for each band (8bands Horizontally)
//Bit 7:0,	RO_Vedg_TB_symtc	Vertical Edge statistics Top/Bottompure symmetric for each band (8bands Horizontally)
//Bit 4:0,	RO_Vedg_TB_sum	    Total score of 8x8 Vedg statistics for TB like decision
#define DET3D_RO_MAT_MOTN_LR                       ((0x178d  << 2) + 0xd0100000)
//Bit 15:0,	RO_Motn_LR_score	Motion statistics left right decision score for each band (8bands vertically)
//Bit 7:0,	RO_Motn_LR_symtc	Motion statistics left right pure symmetric for each band (8bands vertically)
//Bit 4:0,	RO_Motn_LR_sum	    Total score of 8x8 Motion statistics for LR like decision
#define DET3D_RO_MAT_MOTN_TB                       ((0x178e  << 2) + 0xd0100000)
//Bit 15:0,	RO_Motn_TB_score	Motion statistics Top/Bottom decision score for each band (8bands Horizontally)
//Bit 7:0,	RO_Motn_TB_symtc	Motion statistics Top/Bottompure symmetric for each band (8bands Horizontally)
//Bit 4:0,	RO_Motn_TB_sum	    Total score of 8x8 Motion statistics for TB like decision
#define DET3D_RO_FRM_MOTN                          ((0x178f  << 2) + 0xd0100000)
//Bit 15:0,	RO_Det3D_Frame_Motion	U16  frame based motion value sum for still image decision in FW.
/// mat ram read enter addr
#define DET3D_RAMRD_ADDR_PORT                      ((0x179a  << 2) + 0xd0100000)
#define DET3D_RAMRD_DATA_PORT                      ((0x179b  << 2) + 0xd0100000)
#define NR2_CFR_PARA_CFG0                          ((0x179c  << 2) + 0xd0100000)
//Bit 8,	reg_CFR_CurDif_luma_mode	Current Field Top/Bot line Luma difference calculation mode
//Bit 7:6,	reg_MACFR_frm_phase	        U2  This will be a field based phase register that need to be set by FW phase to phase: 
//                                      this will be calculated based on dbdr_phase of the specific line of this frame. 
//                                      u1: dbdr_phase=1, center line is DB in current line;  dbdr_phase=2, center line is Dr in current line;
//Bit 5:4,	reg_CFR_CurDif_tran_mode	U2  Current Field Top/Bot line Luma/Chroma transition level calculation mode, 
//Bit 3:2,	reg_CFR_alpha_mode	        U2  Alpha selection mode for CFR block from curAlp and motAlp i.e. 0: motAlp; 1: (motAlp+curAlp)/2; 2: min(motAlp,curAlp); 3: max(motAlp,curAlp);
//Bit 1:0,	reg_CFR_Motion_Luma_mode	U2  LumaMotion Calculation mode for MA-CFR. 0: top/bot Lumma motion;   1: middle Luma Motion 2: top/bot + middle motion; 3: max(top/tot motion, middle motion)
#define NR2_CFR_PARA_CFG1                          ((0x179d  << 2) + 0xd0100000)
//Bit 23:16,	reg_CFR_alpha_gain	    gain to map muxed curAlp and motAlp to alpha that will be used for final blending.
//Bit 15: 8,	reg_CFR_Motion_ofst	    Offset to Motion to calculate the motAlp, e,g:motAlp= reg_CFR_Motion_ofst- Motion;This register can be seen as the level of motion that we consider it at moving.
//Bit  7: 0,	reg_CFR_CurDif_gain	    gain to CurDif to map to alpha, normalized to 32;
//// DET 3D REG DEFINE END ////
#define DI_NR_1_CTRL0                              ((0x1794  << 2) + 0xd0100000)
#define DI_NR_1_CTRL1                              ((0x1795  << 2) + 0xd0100000)
#define DI_NR_1_CTRL2                              ((0x1796  << 2) + 0xd0100000)
#define DI_NR_1_CTRL3                              ((0x1797  << 2) + 0xd0100000)
#define DI_CONTWR_X                                ((0x17a0  << 2) + 0xd0100000)
#define DI_CONTWR_Y                                ((0x17a1  << 2) + 0xd0100000)
#define DI_CONTWR_CTRL                             ((0x17a2  << 2) + 0xd0100000)
#define DI_CONTPRD_X                               ((0x17a3  << 2) + 0xd0100000)
#define DI_CONTPRD_Y                               ((0x17a4  << 2) + 0xd0100000)
#define DI_CONTP2RD_X                              ((0x17a5  << 2) + 0xd0100000)
#define DI_CONTP2RD_Y                              ((0x17a6  << 2) + 0xd0100000)
#define DI_CONTRD_CTRL                             ((0x17a7  << 2) + 0xd0100000)
#define DI_NRWR_X                                  ((0x17c0  << 2) + 0xd0100000)
#define DI_NRWR_Y                                  ((0x17c1  << 2) + 0xd0100000)
#define DI_NRWR_CTRL                               ((0x17c2  << 2) + 0xd0100000)
#define DI_MTNWR_X                                 ((0x17c3  << 2) + 0xd0100000)
#define DI_MTNWR_Y                                 ((0x17c4  << 2) + 0xd0100000)
#define DI_MTNWR_CTRL                              ((0x17c5  << 2) + 0xd0100000)
#define DI_DIWR_X                                  ((0x17c6  << 2) + 0xd0100000)
#define DI_DIWR_Y                                  ((0x17c7  << 2) + 0xd0100000)
#define DI_DIWR_CTRL                               ((0x17c8  << 2) + 0xd0100000)
//`define DI_MTNCRD_X               8'hc9
//`define DI_MTNCRD_Y               8'hca
#define DI_MTNPRD_X                                ((0x17cb  << 2) + 0xd0100000)
#define DI_MTNPRD_Y                                ((0x17cc  << 2) + 0xd0100000)
#define DI_MTNRD_CTRL                              ((0x17cd  << 2) + 0xd0100000)
#define DI_INP_GEN_REG                             ((0x17ce  << 2) + 0xd0100000)
#define DI_INP_CANVAS0                             ((0x17cf  << 2) + 0xd0100000)
#define DI_INP_LUMA_X0                             ((0x17d0  << 2) + 0xd0100000)
#define DI_INP_LUMA_Y0                             ((0x17d1  << 2) + 0xd0100000)
#define DI_INP_CHROMA_X0                           ((0x17d2  << 2) + 0xd0100000)
#define DI_INP_CHROMA_Y0                           ((0x17d3  << 2) + 0xd0100000)
#define DI_INP_RPT_LOOP                            ((0x17d4  << 2) + 0xd0100000)
#define DI_INP_LUMA0_RPT_PAT                       ((0x17d5  << 2) + 0xd0100000)
#define DI_INP_CHROMA0_RPT_PAT                     ((0x17d6  << 2) + 0xd0100000)
#define DI_INP_DUMMY_PIXEL                         ((0x17d7  << 2) + 0xd0100000)
#define DI_INP_LUMA_FIFO_SIZE                      ((0x17d8  << 2) + 0xd0100000)
#define DI_INP_RANGE_MAP_Y                         ((0x17ba  << 2) + 0xd0100000)
#define DI_INP_RANGE_MAP_CB                        ((0x17bb  << 2) + 0xd0100000)
#define DI_INP_RANGE_MAP_CR                        ((0x17bc  << 2) + 0xd0100000)
#define DI_INP_GEN_REG2                            ((0x1791  << 2) + 0xd0100000)
#define DI_INP_FMT_CTRL                            ((0x17d9  << 2) + 0xd0100000)
#define DI_INP_FMT_W                               ((0x17da  << 2) + 0xd0100000)
#define DI_MEM_GEN_REG                             ((0x17db  << 2) + 0xd0100000)
#define DI_MEM_CANVAS0                             ((0x17dc  << 2) + 0xd0100000)
#define DI_MEM_LUMA_X0                             ((0x17dd  << 2) + 0xd0100000)
#define DI_MEM_LUMA_Y0                             ((0x17de  << 2) + 0xd0100000)
#define DI_MEM_CHROMA_X0                           ((0x17df  << 2) + 0xd0100000)
#define DI_MEM_CHROMA_Y0                           ((0x17e0  << 2) + 0xd0100000)
#define DI_MEM_RPT_LOOP                            ((0x17e1  << 2) + 0xd0100000)
#define DI_MEM_LUMA0_RPT_PAT                       ((0x17e2  << 2) + 0xd0100000)
#define DI_MEM_CHROMA0_RPT_PAT                     ((0x17e3  << 2) + 0xd0100000)
#define DI_MEM_DUMMY_PIXEL                         ((0x17e4  << 2) + 0xd0100000)
#define DI_MEM_LUMA_FIFO_SIZE                      ((0x17e5  << 2) + 0xd0100000)
#define DI_MEM_RANGE_MAP_Y                         ((0x17bd  << 2) + 0xd0100000)
#define DI_MEM_RANGE_MAP_CB                        ((0x17be  << 2) + 0xd0100000)
#define DI_MEM_RANGE_MAP_CR                        ((0x17bf  << 2) + 0xd0100000)
#define DI_MEM_GEN_REG2                            ((0x1792  << 2) + 0xd0100000)
#define DI_MEM_FMT_CTRL                            ((0x17e6  << 2) + 0xd0100000)
#define DI_MEM_FMT_W                               ((0x17e7  << 2) + 0xd0100000)
#define DI_IF1_GEN_REG                             ((0x17e8  << 2) + 0xd0100000)
#define DI_IF1_CANVAS0                             ((0x17e9  << 2) + 0xd0100000)
#define DI_IF1_LUMA_X0                             ((0x17ea  << 2) + 0xd0100000)
#define DI_IF1_LUMA_Y0                             ((0x17eb  << 2) + 0xd0100000)
#define DI_IF1_CHROMA_X0                           ((0x17ec  << 2) + 0xd0100000)
#define DI_IF1_CHROMA_Y0                           ((0x17ed  << 2) + 0xd0100000)
#define DI_IF1_RPT_LOOP                            ((0x17ee  << 2) + 0xd0100000)
#define DI_IF1_LUMA0_RPT_PAT                       ((0x17ef  << 2) + 0xd0100000)
#define DI_IF1_CHROMA0_RPT_PAT                     ((0x17f0  << 2) + 0xd0100000)
#define DI_IF1_DUMMY_PIXEL                         ((0x17f1  << 2) + 0xd0100000)
#define DI_IF1_LUMA_FIFO_SIZE                      ((0x17f2  << 2) + 0xd0100000)
#define DI_IF1_RANGE_MAP_Y                         ((0x17fc  << 2) + 0xd0100000)
#define DI_IF1_RANGE_MAP_CB                        ((0x17fd  << 2) + 0xd0100000)
#define DI_IF1_RANGE_MAP_CR                        ((0x17fe  << 2) + 0xd0100000)
#define DI_IF1_GEN_REG2                            ((0x1790  << 2) + 0xd0100000)
#define DI_IF1_FMT_CTRL                            ((0x17f3  << 2) + 0xd0100000)
#define DI_IF1_FMT_W                               ((0x17f4  << 2) + 0xd0100000)
#define DI_CHAN2_GEN_REG                           ((0x17f5  << 2) + 0xd0100000)
#define DI_CHAN2_CANVAS0                           ((0x17f6  << 2) + 0xd0100000)
#define DI_CHAN2_LUMA_X0                           ((0x17f7  << 2) + 0xd0100000)
#define DI_CHAN2_LUMA_Y0                           ((0x17f8  << 2) + 0xd0100000)
#define DI_CHAN2_CHROMA_X0                         ((0x17f9  << 2) + 0xd0100000)
#define DI_CHAN2_CHROMA_Y0                         ((0x17fa  << 2) + 0xd0100000)
#define DI_CHAN2_RPT_LOOP                          ((0x17fb  << 2) + 0xd0100000)
#define DI_CHAN2_LUMA0_RPT_PAT                     ((0x17b0  << 2) + 0xd0100000)
#define DI_CHAN2_CHROMA0_RPT_PAT                   ((0x17b1  << 2) + 0xd0100000)
#define DI_CHAN2_DUMMY_PIXEL                       ((0x17b2  << 2) + 0xd0100000)
#define DI_CHAN2_LUMA_FIFO_SIZE                    ((0x17b3  << 2) + 0xd0100000)
#define DI_CHAN2_RANGE_MAP_Y                       ((0x17b4  << 2) + 0xd0100000)
#define DI_CHAN2_RANGE_MAP_CB                      ((0x17b5  << 2) + 0xd0100000)
#define DI_CHAN2_RANGE_MAP_CR                      ((0x17b6  << 2) + 0xd0100000)
#define DI_CHAN2_GEN_REG2                          ((0x17b7  << 2) + 0xd0100000)
#define DI_CHAN2_FMT_CTRL                          ((0x17b8  << 2) + 0xd0100000)
#define DI_CHAN2_FMT_W                             ((0x17b9  << 2) + 0xd0100000)
#define DI_CANVAS_URGENT0                          ((0x170a  << 2) + 0xd0100000)
#define DI_CANVAS_URGENT1                          ((0x170b  << 2) + 0xd0100000)
#define DI_CANVAS_URGENT2                          ((0x170e  << 2) + 0xd0100000)
//
// Closing file:  vregs.h
//
//`define  VENC_VCBUS_BASE              8'h1b
//
// Reading file:  venc_regs.h
//
//===========================================================================
// Video Interface Registers    0xa00 - 0xbff
//===========================================================================
// -----------------------------------------------
// CBUS_BASE:  VENC_VCBUS_BASE = 0x1b
// -----------------------------------------------
// bit 15:8 -- vfifo2vd_vd_sel
// bit 0 -- vfifo2vd_en
#define ENCP_VFIFO2VD_CTL                          ((0x1b58  << 2) + 0xd0100000)
// bit 12:0 -- vfifo2vd_pixel_start 
#define ENCP_VFIFO2VD_PIXEL_START                  ((0x1b59  << 2) + 0xd0100000)
// bit 12:00 -- vfifo2vd_pixel_end   
#define ENCP_VFIFO2VD_PIXEL_END                    ((0x1b5a  << 2) + 0xd0100000)
// bit 10:0 -- vfifo2vd_line_top_start 
#define ENCP_VFIFO2VD_LINE_TOP_START               ((0x1b5b  << 2) + 0xd0100000)
// bit 10:00 -- vfifo2vd_line_top_end   
#define ENCP_VFIFO2VD_LINE_TOP_END                 ((0x1b5c  << 2) + 0xd0100000)
// bit 10:00 -- vfifo2vd_line_bot_start 
#define ENCP_VFIFO2VD_LINE_BOT_START               ((0x1b5d  << 2) + 0xd0100000)
// bit 10:00 -- vfifo2vd_line_bot_end   
#define ENCP_VFIFO2VD_LINE_BOT_END                 ((0x1b5e  << 2) + 0xd0100000)
// Route the hsync and vsync signals round the chip. There are three
// sources and users of these signals: VIU, internal video encoder, and
// the pins on the chip. Some muxing is still being done in the VIU. It
// was not moved to the venc module so that the same exact VIU code could
// be used both in Twister and Twister2000.
// Bit 2: venc_sync_source (1=>pins, 0=>viu)
// Bit 1: viu_sync_source (1=>pins, 0=>venc)
// Bit 0: vpins_sync_source (1=>venc, 0=>viu)
#define VENC_SYNC_ROUTE                            ((0x1b60  << 2) + 0xd0100000)
#define VENC_VIDEO_EXSRC                           ((0x1b61  << 2) + 0xd0100000)
#define VENC_DVI_SETTING                           ((0x1b62  << 2) + 0xd0100000)
#define VENC_C656_CTRL                             ((0x1b63  << 2) + 0xd0100000)
#define VENC_UPSAMPLE_CTRL0                        ((0x1b64  << 2) + 0xd0100000)
#define VENC_UPSAMPLE_CTRL1                        ((0x1b65  << 2) + 0xd0100000)
#define VENC_UPSAMPLE_CTRL2                        ((0x1b66  << 2) + 0xd0100000)
// Invert control for tcon output
// bit[15:14] -- vsync, hsync, 
// bit[13:0] --  oev3, oev2, cpv2, cph3, cph2, cph1, oeh, vcom, stv2, stv1, cpv1, oev1, sth1, sth2
#define TCON_INVERT_CTL                            ((0x1b67  << 2) + 0xd0100000)
#define VENC_VIDEO_PROG_MODE                       ((0x1b68  << 2) + 0xd0100000)
//---- Venc pixel/line info
#define VENC_ENCI_LINE                             ((0x1b69  << 2) + 0xd0100000)
#define VENC_ENCI_PIXEL                            ((0x1b6a  << 2) + 0xd0100000)
#define VENC_ENCP_LINE                             ((0x1b6b  << 2) + 0xd0100000)
#define VENC_ENCP_PIXEL                            ((0x1b6c  << 2) + 0xd0100000)
//---- Status
#define VENC_STATA                                 ((0x1b6d  << 2) + 0xd0100000)
//---- Interrupt setting
#define VENC_INTCTRL                               ((0x1b6e  << 2) + 0xd0100000)
#define VENC_INTFLAG                               ((0x1b6f  << 2) + 0xd0100000)
//--------- Video test configuration
#define VENC_VIDEO_TST_EN                          ((0x1b70  << 2) + 0xd0100000)
#define VENC_VIDEO_TST_MDSEL                       ((0x1b71  << 2) + 0xd0100000)
#define VENC_VIDEO_TST_Y                           ((0x1b72  << 2) + 0xd0100000)
#define VENC_VIDEO_TST_CB                          ((0x1b73  << 2) + 0xd0100000)
#define VENC_VIDEO_TST_CR                          ((0x1b74  << 2) + 0xd0100000)
#define VENC_VIDEO_TST_CLRBAR_STRT                 ((0x1b75  << 2) + 0xd0100000)
#define VENC_VIDEO_TST_CLRBAR_WIDTH                ((0x1b76  << 2) + 0xd0100000)
#define VENC_VIDEO_TST_VDCNT_STSET                 ((0x1b77  << 2) + 0xd0100000)
//----- Video dac setting
#define VENC_VDAC_DACSEL0                          ((0x1b78  << 2) + 0xd0100000)
#define VENC_VDAC_DACSEL1                          ((0x1b79  << 2) + 0xd0100000)
#define VENC_VDAC_DACSEL2                          ((0x1b7a  << 2) + 0xd0100000)
#define VENC_VDAC_DACSEL3                          ((0x1b7b  << 2) + 0xd0100000)
#define VENC_VDAC_DACSEL4                          ((0x1b7c  << 2) + 0xd0100000)
#define VENC_VDAC_DACSEL5                          ((0x1b7d  << 2) + 0xd0100000)
#define VENC_VDAC_SETTING                          ((0x1b7e  << 2) + 0xd0100000)
#define VENC_VDAC_TST_VAL                          ((0x1b7f  << 2) + 0xd0100000)
#define VENC_VDAC_DAC0_GAINCTRL                    ((0x1bf0  << 2) + 0xd0100000)
#define VENC_VDAC_DAC0_OFFSET                      ((0x1bf1  << 2) + 0xd0100000)
#define VENC_VDAC_DAC1_GAINCTRL                    ((0x1bf2  << 2) + 0xd0100000)
#define VENC_VDAC_DAC1_OFFSET                      ((0x1bf3  << 2) + 0xd0100000)
#define VENC_VDAC_DAC2_GAINCTRL                    ((0x1bf4  << 2) + 0xd0100000)
#define VENC_VDAC_DAC2_OFFSET                      ((0x1bf5  << 2) + 0xd0100000)
#define VENC_VDAC_DAC3_GAINCTRL                    ((0x1bf6  << 2) + 0xd0100000)
#define VENC_VDAC_DAC3_OFFSET                      ((0x1bf7  << 2) + 0xd0100000)
#define VENC_VDAC_DAC4_GAINCTRL                    ((0x1bf8  << 2) + 0xd0100000)
#define VENC_VDAC_DAC4_OFFSET                      ((0x1bf9  << 2) + 0xd0100000)
#define VENC_VDAC_DAC5_GAINCTRL                    ((0x1bfa  << 2) + 0xd0100000)
#define VENC_VDAC_DAC5_OFFSET                      ((0x1bfb  << 2) + 0xd0100000)
#define VENC_VDAC_FIFO_CTRL                        ((0x1bfc  << 2) + 0xd0100000)
#define ENCL_TCON_INVERT_CTL                       ((0x1bfd  << 2) + 0xd0100000)
//
// Closing file:  venc_regs.h
//
//
// Reading file:  enc480p_regs.h
//
// synopsys translate_off
// synopsys translate_on
//===========================================================================
// Video Encoder 480p Registers    0xb80 - 0xbef
//===========================================================================
//-------- Video basic setting
#define ENCP_VIDEO_EN                              ((0x1b80  << 2) + 0xd0100000)
#define ENCP_VIDEO_SYNC_MODE                       ((0x1b81  << 2) + 0xd0100000)
#define ENCP_MACV_EN                               ((0x1b82  << 2) + 0xd0100000)
#define ENCP_VIDEO_Y_SCL                           ((0x1b83  << 2) + 0xd0100000)
#define ENCP_VIDEO_PB_SCL                          ((0x1b84  << 2) + 0xd0100000)
#define ENCP_VIDEO_PR_SCL                          ((0x1b85  << 2) + 0xd0100000)
#define ENCP_VIDEO_SYNC_SCL                        ((0x1b86  << 2) + 0xd0100000)
#define ENCP_VIDEO_MACV_SCL                        ((0x1b87  << 2) + 0xd0100000)
#define ENCP_VIDEO_Y_OFFST                         ((0x1b88  << 2) + 0xd0100000)
#define ENCP_VIDEO_PB_OFFST                        ((0x1b89  << 2) + 0xd0100000)
#define ENCP_VIDEO_PR_OFFST                        ((0x1b8a  << 2) + 0xd0100000)
#define ENCP_VIDEO_SYNC_OFFST                      ((0x1b8b  << 2) + 0xd0100000)
#define ENCP_VIDEO_MACV_OFFST                      ((0x1b8c  << 2) + 0xd0100000)
//----- Video mode
#define ENCP_VIDEO_MODE                            ((0x1b8d  << 2) + 0xd0100000)
#define ENCP_VIDEO_MODE_ADV                        ((0x1b8e  << 2) + 0xd0100000)
//--------------- Debug pins
#define ENCP_DBG_PX_RST                            ((0x1b90  << 2) + 0xd0100000)
#define ENCP_DBG_LN_RST                            ((0x1b91  << 2) + 0xd0100000)
#define ENCP_DBG_PX_INT                            ((0x1b92  << 2) + 0xd0100000)
#define ENCP_DBG_LN_INT                            ((0x1b93  << 2) + 0xd0100000)
//----------- Video Advanced setting
#define ENCP_VIDEO_YFP1_HTIME                      ((0x1b94  << 2) + 0xd0100000)
#define ENCP_VIDEO_YFP2_HTIME                      ((0x1b95  << 2) + 0xd0100000)
#define ENCP_VIDEO_YC_DLY                          ((0x1b96  << 2) + 0xd0100000)
#define ENCP_VIDEO_MAX_PXCNT                       ((0x1b97  << 2) + 0xd0100000)
#define ENCP_VIDEO_HSPULS_BEGIN                    ((0x1b98  << 2) + 0xd0100000)
#define ENCP_VIDEO_HSPULS_END                      ((0x1b99  << 2) + 0xd0100000)
#define ENCP_VIDEO_HSPULS_SWITCH                   ((0x1b9a  << 2) + 0xd0100000)
#define ENCP_VIDEO_VSPULS_BEGIN                    ((0x1b9b  << 2) + 0xd0100000)
#define ENCP_VIDEO_VSPULS_END                      ((0x1b9c  << 2) + 0xd0100000)
#define ENCP_VIDEO_VSPULS_BLINE                    ((0x1b9d  << 2) + 0xd0100000)
#define ENCP_VIDEO_VSPULS_ELINE                    ((0x1b9e  << 2) + 0xd0100000)
#define ENCP_VIDEO_EQPULS_BEGIN                    ((0x1b9f  << 2) + 0xd0100000)
#define ENCP_VIDEO_EQPULS_END                      ((0x1ba0  << 2) + 0xd0100000)
#define ENCP_VIDEO_EQPULS_BLINE                    ((0x1ba1  << 2) + 0xd0100000)
#define ENCP_VIDEO_EQPULS_ELINE                    ((0x1ba2  << 2) + 0xd0100000)
#define ENCP_VIDEO_HAVON_END                       ((0x1ba3  << 2) + 0xd0100000)
#define ENCP_VIDEO_HAVON_BEGIN                     ((0x1ba4  << 2) + 0xd0100000)
#define ENCP_VIDEO_VAVON_ELINE                     ((0x1baf  << 2) + 0xd0100000)
#define ENCP_VIDEO_VAVON_BLINE                     ((0x1ba6  << 2) + 0xd0100000)
#define ENCP_VIDEO_HSO_BEGIN                       ((0x1ba7  << 2) + 0xd0100000)
#define ENCP_VIDEO_HSO_END                         ((0x1ba8  << 2) + 0xd0100000)
#define ENCP_VIDEO_VSO_BEGIN                       ((0x1ba9  << 2) + 0xd0100000)
#define ENCP_VIDEO_VSO_END                         ((0x1baa  << 2) + 0xd0100000)
#define ENCP_VIDEO_VSO_BLINE                       ((0x1bab  << 2) + 0xd0100000)
#define ENCP_VIDEO_VSO_ELINE                       ((0x1bac  << 2) + 0xd0100000)
#define ENCP_VIDEO_SYNC_WAVE_CURVE                 ((0x1bad  << 2) + 0xd0100000)
#define ENCP_VIDEO_MAX_LNCNT                       ((0x1bae  << 2) + 0xd0100000)
#define ENCP_VIDEO_SY_VAL                          ((0x1bb0  << 2) + 0xd0100000)
#define ENCP_VIDEO_SY2_VAL                         ((0x1bb1  << 2) + 0xd0100000)
#define ENCP_VIDEO_BLANKY_VAL                      ((0x1bb2  << 2) + 0xd0100000)
#define ENCP_VIDEO_BLANKPB_VAL                     ((0x1bb3  << 2) + 0xd0100000)
#define ENCP_VIDEO_BLANKPR_VAL                     ((0x1bb4  << 2) + 0xd0100000)
#define ENCP_VIDEO_HOFFST                          ((0x1bb5  << 2) + 0xd0100000)
#define ENCP_VIDEO_VOFFST                          ((0x1bb6  << 2) + 0xd0100000)
#define ENCP_VIDEO_RGB_CTRL                        ((0x1bb7  << 2) + 0xd0100000)
#define ENCP_VIDEO_FILT_CTRL                       ((0x1bb8  << 2) + 0xd0100000)
#define ENCP_VIDEO_OFLD_VPEQ_OFST                  ((0x1bb9  << 2) + 0xd0100000)
#define ENCP_VIDEO_OFLD_VOAV_OFST                  ((0x1bba  << 2) + 0xd0100000)
#define ENCP_VIDEO_MATRIX_CB                       ((0x1bbb  << 2) + 0xd0100000)
#define ENCP_VIDEO_MATRIX_CR                       ((0x1bbc  << 2) + 0xd0100000)
#define ENCP_VIDEO_RGBIN_CTRL                      ((0x1bbd  << 2) + 0xd0100000)
//------------------Macrovision advanced setting
#define ENCP_MACV_BLANKY_VAL                       ((0x1bc0  << 2) + 0xd0100000)
#define ENCP_MACV_MAXY_VAL                         ((0x1bc1  << 2) + 0xd0100000)
#define ENCP_MACV_1ST_PSSYNC_STRT                  ((0x1bc2  << 2) + 0xd0100000)
#define ENCP_MACV_PSSYNC_STRT                      ((0x1bc3  << 2) + 0xd0100000)
#define ENCP_MACV_AGC_STRT                         ((0x1bc4  << 2) + 0xd0100000)
#define ENCP_MACV_AGC_END                          ((0x1bc5  << 2) + 0xd0100000)
#define ENCP_MACV_WAVE_END                         ((0x1bc6  << 2) + 0xd0100000)
#define ENCP_MACV_STRTLINE                         ((0x1bc7  << 2) + 0xd0100000)
#define ENCP_MACV_ENDLINE                          ((0x1bc8  << 2) + 0xd0100000)
#define ENCP_MACV_TS_CNT_MAX_L                     ((0x1bc9  << 2) + 0xd0100000)
#define ENCP_MACV_TS_CNT_MAX_H                     ((0x1bca  << 2) + 0xd0100000)
#define ENCP_MACV_TIME_DOWN                        ((0x1bcb  << 2) + 0xd0100000)
#define ENCP_MACV_TIME_LO                          ((0x1bcc  << 2) + 0xd0100000)
#define ENCP_MACV_TIME_UP                          ((0x1bcd  << 2) + 0xd0100000)
#define ENCP_MACV_TIME_RST                         ((0x1bce  << 2) + 0xd0100000)
//---------------- VBI control -------------------
#define ENCP_VBI_CTRL                              ((0x1bd0  << 2) + 0xd0100000)
#define ENCP_VBI_SETTING                           ((0x1bd1  << 2) + 0xd0100000)
#define ENCP_VBI_BEGIN                             ((0x1bd2  << 2) + 0xd0100000)
#define ENCP_VBI_WIDTH                             ((0x1bd3  << 2) + 0xd0100000)
#define ENCP_VBI_HVAL                              ((0x1bd4  << 2) + 0xd0100000)
#define ENCP_VBI_DATA0                             ((0x1bd5  << 2) + 0xd0100000)
#define ENCP_VBI_DATA1                             ((0x1bd6  << 2) + 0xd0100000)
//----------------C656 OUT Control------------- Grant
#define C656_HS_ST                                 ((0x1be0  << 2) + 0xd0100000)
#define C656_HS_ED                                 ((0x1be1  << 2) + 0xd0100000)
#define C656_VS_LNST_E                             ((0x1be2  << 2) + 0xd0100000)
#define C656_VS_LNST_O                             ((0x1be3  << 2) + 0xd0100000)
#define C656_VS_LNED_E                             ((0x1be4  << 2) + 0xd0100000)
#define C656_VS_LNED_O                             ((0x1be5  << 2) + 0xd0100000)
#define C656_FS_LNST                               ((0x1be6  << 2) + 0xd0100000)
#define C656_FS_LNED                               ((0x1be7  << 2) + 0xd0100000)
// synopsys translate_off
// synopsys translate_on
//
// Closing file:  enc480p_regs.h
//
//
// Reading file:  enci_regs.h
//
//===========================================================================
// Video Interface Registers    0xb00 - 0xb57
//===========================================================================
#define ENCI_VIDEO_MODE                            ((0x1b00  << 2) + 0xd0100000)
#define ENCI_VIDEO_MODE_ADV                        ((0x1b01  << 2) + 0xd0100000)
#define ENCI_VIDEO_FSC_ADJ                         ((0x1b02  << 2) + 0xd0100000)
#define ENCI_VIDEO_BRIGHT                          ((0x1b03  << 2) + 0xd0100000)
#define ENCI_VIDEO_CONT                            ((0x1b04  << 2) + 0xd0100000)
#define ENCI_VIDEO_SAT                             ((0x1b05  << 2) + 0xd0100000)
#define ENCI_VIDEO_HUE                             ((0x1b06  << 2) + 0xd0100000)
#define ENCI_VIDEO_SCH                             ((0x1b07  << 2) + 0xd0100000)
#define ENCI_SYNC_MODE                             ((0x1b08  << 2) + 0xd0100000)
#define ENCI_SYNC_CTRL                             ((0x1b09  << 2) + 0xd0100000)
#define ENCI_SYNC_HSO_BEGIN                        ((0x1b0a  << 2) + 0xd0100000)
#define ENCI_SYNC_HSO_END                          ((0x1b0b  << 2) + 0xd0100000)
#define ENCI_SYNC_VSO_EVN                          ((0x1b0c  << 2) + 0xd0100000)
#define ENCI_SYNC_VSO_ODD                          ((0x1b0d  << 2) + 0xd0100000)
#define ENCI_SYNC_VSO_EVNLN                        ((0x1b0e  << 2) + 0xd0100000)
#define ENCI_SYNC_VSO_ODDLN                        ((0x1b0f  << 2) + 0xd0100000)
#define ENCI_SYNC_HOFFST                           ((0x1b10  << 2) + 0xd0100000)
#define ENCI_SYNC_VOFFST                           ((0x1b11  << 2) + 0xd0100000)
#define ENCI_SYNC_ADJ                              ((0x1b12  << 2) + 0xd0100000)
#define ENCI_RGB_SETTING                           ((0x1b13  << 2) + 0xd0100000)
//`define	ENCI_CMPN_MATRIX_CB		8'h14
//`define	ENCI_CMPN_MATRIX_CR		8'h15
#define ENCI_DE_H_BEGIN                            ((0x1b16  << 2) + 0xd0100000)
#define ENCI_DE_H_END                              ((0x1b17  << 2) + 0xd0100000)
#define ENCI_DE_V_BEGIN_EVEN                       ((0x1b18  << 2) + 0xd0100000)
#define ENCI_DE_V_END_EVEN                         ((0x1b19  << 2) + 0xd0100000)
#define ENCI_DE_V_BEGIN_ODD                        ((0x1b1a  << 2) + 0xd0100000)
#define ENCI_DE_V_END_ODD                          ((0x1b1b  << 2) + 0xd0100000)
#define ENCI_VBI_SETTING                           ((0x1b20  << 2) + 0xd0100000)
#define ENCI_VBI_CCDT_EVN                          ((0x1b21  << 2) + 0xd0100000)
#define ENCI_VBI_CCDT_ODD                          ((0x1b22  << 2) + 0xd0100000)
#define ENCI_VBI_CC525_LN                          ((0x1b23  << 2) + 0xd0100000)
#define ENCI_VBI_CC625_LN                          ((0x1b24  << 2) + 0xd0100000)
#define ENCI_VBI_WSSDT                             ((0x1b25  << 2) + 0xd0100000)
#define ENCI_VBI_WSS_LN                            ((0x1b26  << 2) + 0xd0100000)
#define ENCI_VBI_CGMSDT_L                          ((0x1b27  << 2) + 0xd0100000)
#define ENCI_VBI_CGMSDT_H                          ((0x1b28  << 2) + 0xd0100000)
#define ENCI_VBI_CGMS_LN                           ((0x1b29  << 2) + 0xd0100000)
#define ENCI_VBI_TTX_HTIME                         ((0x1b2a  << 2) + 0xd0100000)
#define ENCI_VBI_TTX_LN                            ((0x1b2b  << 2) + 0xd0100000)
#define ENCI_VBI_TTXDT0                            ((0x1b2c  << 2) + 0xd0100000)
#define ENCI_VBI_TTXDT1                            ((0x1b2d  << 2) + 0xd0100000)
#define ENCI_VBI_TTXDT2                            ((0x1b2e  << 2) + 0xd0100000)
#define ENCI_VBI_TTXDT3                            ((0x1b2f  << 2) + 0xd0100000)
#define ENCI_MACV_N0                               ((0x1b30  << 2) + 0xd0100000)
#define ENCI_MACV_N1                               ((0x1b31  << 2) + 0xd0100000)
#define ENCI_MACV_N2                               ((0x1b32  << 2) + 0xd0100000)
#define ENCI_MACV_N3                               ((0x1b33  << 2) + 0xd0100000)
#define ENCI_MACV_N4                               ((0x1b34  << 2) + 0xd0100000)
#define ENCI_MACV_N5                               ((0x1b35  << 2) + 0xd0100000)
#define ENCI_MACV_N6                               ((0x1b36  << 2) + 0xd0100000)
#define ENCI_MACV_N7                               ((0x1b37  << 2) + 0xd0100000)
#define ENCI_MACV_N8                               ((0x1b38  << 2) + 0xd0100000)
#define ENCI_MACV_N9                               ((0x1b39  << 2) + 0xd0100000)
#define ENCI_MACV_N10                              ((0x1b3a  << 2) + 0xd0100000)
#define ENCI_MACV_N11                              ((0x1b3b  << 2) + 0xd0100000)
#define ENCI_MACV_N12                              ((0x1b3c  << 2) + 0xd0100000)
#define ENCI_MACV_N13                              ((0x1b3d  << 2) + 0xd0100000)
#define ENCI_MACV_N14                              ((0x1b3e  << 2) + 0xd0100000)
#define ENCI_MACV_N15                              ((0x1b3f  << 2) + 0xd0100000)
#define ENCI_MACV_N16                              ((0x1b40  << 2) + 0xd0100000)
#define ENCI_MACV_N17                              ((0x1b41  << 2) + 0xd0100000)
#define ENCI_MACV_N18                              ((0x1b42  << 2) + 0xd0100000)
#define ENCI_MACV_N19                              ((0x1b43  << 2) + 0xd0100000)
#define ENCI_MACV_N20                              ((0x1b44  << 2) + 0xd0100000)
#define ENCI_MACV_N21                              ((0x1b45  << 2) + 0xd0100000)
#define ENCI_MACV_N22                              ((0x1b46  << 2) + 0xd0100000)
//`define	ENCI_MACV_P_AGC			8'h47
#define ENCI_DBG_PX_RST                            ((0x1b48  << 2) + 0xd0100000)
#define ENCI_DBG_FLDLN_RST                         ((0x1b49  << 2) + 0xd0100000)
#define ENCI_DBG_PX_INT                            ((0x1b4a  << 2) + 0xd0100000)
#define ENCI_DBG_FLDLN_INT                         ((0x1b4b  << 2) + 0xd0100000)
#define ENCI_DBG_MAXPX                             ((0x1b4c  << 2) + 0xd0100000)
#define ENCI_DBG_MAXLN                             ((0x1b4d  << 2) + 0xd0100000)
#define ENCI_MACV_MAX_AMP                          ((0x1b50  << 2) + 0xd0100000)
#define ENCI_MACV_PULSE_LO                         ((0x1b51  << 2) + 0xd0100000)
#define ENCI_MACV_PULSE_HI                         ((0x1b52  << 2) + 0xd0100000)
#define ENCI_MACV_BKP_MAX                          ((0x1b53  << 2) + 0xd0100000)
#define ENCI_CFILT_CTRL                            ((0x1b54  << 2) + 0xd0100000)
#define ENCI_CFILT7                                ((0x1b55  << 2) + 0xd0100000)
#define ENCI_YC_DELAY                              ((0x1b56  << 2) + 0xd0100000)
#define ENCI_VIDEO_EN                              ((0x1b57  << 2) + 0xd0100000)
//
// Closing file:  enci_regs.h
//
//`define  VENC2_VCBUS_BASE             8'h1c
//
// Reading file:  venc2_regs.h
//
//===========================================================================
// Venc Registers (Cont.)    0xc00 - 0xcff (VENC registers 0xc00 - 0xcef; RDMA registers 0xcf0 - 0xcff)
//===========================================================================
// -----------------------------------------------
// CBUS_BASE:  VENC2_VCBUS_BASE = 0x1c
// -----------------------------------------------
// Program video control signals from ENCI core to DVI/HDMI interface
#define ENCI_DVI_HSO_BEGIN                         ((0x1c00  << 2) + 0xd0100000)
#define ENCI_DVI_HSO_END                           ((0x1c01  << 2) + 0xd0100000)
#define ENCI_DVI_VSO_BLINE_EVN                     ((0x1c02  << 2) + 0xd0100000)
#define ENCI_DVI_VSO_BLINE_ODD                     ((0x1c03  << 2) + 0xd0100000)
#define ENCI_DVI_VSO_ELINE_EVN                     ((0x1c04  << 2) + 0xd0100000)
#define ENCI_DVI_VSO_ELINE_ODD                     ((0x1c05  << 2) + 0xd0100000)
#define ENCI_DVI_VSO_BEGIN_EVN                     ((0x1c06  << 2) + 0xd0100000)
#define ENCI_DVI_VSO_BEGIN_ODD                     ((0x1c07  << 2) + 0xd0100000)
#define ENCI_DVI_VSO_END_EVN                       ((0x1c08  << 2) + 0xd0100000)
#define ENCI_DVI_VSO_END_ODD                       ((0x1c09  << 2) + 0xd0100000)
// Define cmpt and cvbs cb/cr delay after ENCI chroma filters
// Bit 15:12 RW, enci_cb_cvbs_dly_sel. 0=no delay; 1~6=delay by 1~6 clk; 7~15 reserved.
// Bit 11: 8 RW, enci_cr_cvbs_dly_sel. 0=no delay; 1~6=delay by 1~6 clk; 7~15 reserved.
// Bit  7: 4 RW, enci_cb_cmpt_dly_sel. 0=no delay; 1~6=delay by 1~6 clk; 7~15 reserved.
// Bit  3: 0 RW, enci_cr_cmpt_dly_sel. 0=no delay; 1~6=delay by 1~6 clk; 7~15 reserved.
#define ENCI_CFILT_CTRL2                           ((0x1c0a  << 2) + 0xd0100000)
#define ENCI_DACSEL_0                              ((0x1c0b  << 2) + 0xd0100000)
#define ENCI_DACSEL_1                              ((0x1c0c  << 2) + 0xd0100000)
#define ENCP_DACSEL_0                              ((0x1c0d  << 2) + 0xd0100000)
#define ENCP_DACSEL_1                              ((0x1c0e  << 2) + 0xd0100000)
#define ENCP_MAX_LINE_SWITCH_POINT                 ((0x1c0f  << 2) + 0xd0100000)
#define ENCI_TST_EN                                ((0x1c10  << 2) + 0xd0100000)
#define ENCI_TST_MDSEL                             ((0x1c11  << 2) + 0xd0100000)
#define ENCI_TST_Y                                 ((0x1c12  << 2) + 0xd0100000)
#define ENCI_TST_CB                                ((0x1c13  << 2) + 0xd0100000)
#define ENCI_TST_CR                                ((0x1c14  << 2) + 0xd0100000)
#define ENCI_TST_CLRBAR_STRT                       ((0x1c15  << 2) + 0xd0100000)
#define ENCI_TST_CLRBAR_WIDTH                      ((0x1c16  << 2) + 0xd0100000)
#define ENCI_TST_VDCNT_STSET                       ((0x1c17  << 2) + 0xd0100000)
// bit 15:8 -- vfifo2vd_vd_sel
// bit 7 -- vfifo2vd_drop
// bit 6:1 -- vfifo2vd_delay
// bit 0 -- vfifo2vd_en
#define ENCI_VFIFO2VD_CTL                          ((0x1c18  << 2) + 0xd0100000)
// bit 12:0 -- vfifo2vd_pixel_start 
#define ENCI_VFIFO2VD_PIXEL_START                  ((0x1c19  << 2) + 0xd0100000)
// bit 12:00 -- vfifo2vd_pixel_end   
#define ENCI_VFIFO2VD_PIXEL_END                    ((0x1c1a  << 2) + 0xd0100000)
// bit 10:0 -- vfifo2vd_line_top_start 
#define ENCI_VFIFO2VD_LINE_TOP_START               ((0x1c1b  << 2) + 0xd0100000)
// bit 10:00 -- vfifo2vd_line_top_end   
#define ENCI_VFIFO2VD_LINE_TOP_END                 ((0x1c1c  << 2) + 0xd0100000)
// bit 10:00 -- vfifo2vd_line_bot_start 
#define ENCI_VFIFO2VD_LINE_BOT_START               ((0x1c1d  << 2) + 0xd0100000)
// bit 10:00 -- vfifo2vd_line_bot_end   
#define ENCI_VFIFO2VD_LINE_BOT_END                 ((0x1c1e  << 2) + 0xd0100000)
#define ENCI_VFIFO2VD_CTL2                         ((0x1c1f  << 2) + 0xd0100000)
// bit 15:8 -- vfifo2vd_vd_sel
// bit 7 -- vfifo2vd_drop
// bit 6:1 -- vfifo2vd_delay
// bit 0 -- vfifo2vd_en
#define ENCT_VFIFO2VD_CTL                          ((0x1c20  << 2) + 0xd0100000)
// bit 12:0 -- vfifo2vd_pixel_start 
#define ENCT_VFIFO2VD_PIXEL_START                  ((0x1c21  << 2) + 0xd0100000)
// bit 12:00 -- vfifo2vd_pixel_end   
#define ENCT_VFIFO2VD_PIXEL_END                    ((0x1c22  << 2) + 0xd0100000)
// bit 10:0 -- vfifo2vd_line_top_start 
#define ENCT_VFIFO2VD_LINE_TOP_START               ((0x1c23  << 2) + 0xd0100000)
// bit 10:00 -- vfifo2vd_line_top_end   
#define ENCT_VFIFO2VD_LINE_TOP_END                 ((0x1c24  << 2) + 0xd0100000)
// bit 10:00 -- vfifo2vd_line_bot_start 
#define ENCT_VFIFO2VD_LINE_BOT_START               ((0x1c25  << 2) + 0xd0100000)
// bit 10:00 -- vfifo2vd_line_bot_end   
#define ENCT_VFIFO2VD_LINE_BOT_END                 ((0x1c26  << 2) + 0xd0100000)
#define ENCT_VFIFO2VD_CTL2                         ((0x1c27  << 2) + 0xd0100000)
#define ENCT_TST_EN                                ((0x1c28  << 2) + 0xd0100000)
#define ENCT_TST_MDSEL                             ((0x1c29  << 2) + 0xd0100000)
#define ENCT_TST_Y                                 ((0x1c2a  << 2) + 0xd0100000)
#define ENCT_TST_CB                                ((0x1c2b  << 2) + 0xd0100000)
#define ENCT_TST_CR                                ((0x1c2c  << 2) + 0xd0100000)
#define ENCT_TST_CLRBAR_STRT                       ((0x1c2d  << 2) + 0xd0100000)
#define ENCT_TST_CLRBAR_WIDTH                      ((0x1c2e  << 2) + 0xd0100000)
#define ENCT_TST_VDCNT_STSET                       ((0x1c2f  << 2) + 0xd0100000)
// Program video control signals from ENCP core to DVI/HDMI interface
#define ENCP_DVI_HSO_BEGIN                         ((0x1c30  << 2) + 0xd0100000)
#define ENCP_DVI_HSO_END                           ((0x1c31  << 2) + 0xd0100000)
#define ENCP_DVI_VSO_BLINE_EVN                     ((0x1c32  << 2) + 0xd0100000)
#define ENCP_DVI_VSO_BLINE_ODD                     ((0x1c33  << 2) + 0xd0100000)
#define ENCP_DVI_VSO_ELINE_EVN                     ((0x1c34  << 2) + 0xd0100000)
#define ENCP_DVI_VSO_ELINE_ODD                     ((0x1c35  << 2) + 0xd0100000)
#define ENCP_DVI_VSO_BEGIN_EVN                     ((0x1c36  << 2) + 0xd0100000)
#define ENCP_DVI_VSO_BEGIN_ODD                     ((0x1c37  << 2) + 0xd0100000)
#define ENCP_DVI_VSO_END_EVN                       ((0x1c38  << 2) + 0xd0100000)
#define ENCP_DVI_VSO_END_ODD                       ((0x1c39  << 2) + 0xd0100000)
#define ENCP_DE_H_BEGIN                            ((0x1c3a  << 2) + 0xd0100000)
#define ENCP_DE_H_END                              ((0x1c3b  << 2) + 0xd0100000)
#define ENCP_DE_V_BEGIN_EVEN                       ((0x1c3c  << 2) + 0xd0100000)
#define ENCP_DE_V_END_EVEN                         ((0x1c3d  << 2) + 0xd0100000)
#define ENCP_DE_V_BEGIN_ODD                        ((0x1c3e  << 2) + 0xd0100000)
#define ENCP_DE_V_END_ODD                          ((0x1c3f  << 2) + 0xd0100000)
// Bit 15:11 - sync length
// Bit 10:0 - sync start line
#define ENCI_SYNC_LINE_LENGTH                      ((0x1c40  << 2) + 0xd0100000)
// Bit 15 - sync_pulse_enable
// Bit 12:0 - sync start pixel
#define ENCI_SYNC_PIXEL_EN                         ((0x1c41  << 2) + 0xd0100000)
// Bit 15 - enci_sync_enable
// Bit 14 - encp_sync_enable
// Bit 13 - enct_sync_enable
// Bit 12 - short_fussy_sync
// Bit 11 - fussy_sync_enable
// Bit 10:0 - sync target line
#define ENCI_SYNC_TO_LINE_EN                       ((0x1c42  << 2) + 0xd0100000)
// Bit 12:0 - sync target pixel
#define ENCI_SYNC_TO_PIXEL                         ((0x1c43  << 2) + 0xd0100000)
// Bit 15:11 - sync length
// Bit 10:0 - sync start line
#define ENCP_SYNC_LINE_LENGTH                      ((0x1c44  << 2) + 0xd0100000)
// Bit 15 - sync_pulse_enable
// Bit 12:0 - sync start pixel
#define ENCP_SYNC_PIXEL_EN                         ((0x1c45  << 2) + 0xd0100000)
// Bit 15 - enci_sync_enable
// Bit 14 - encp_sync_enable
// Bit 13 - enct_sync_enable
// Bit 12 - short_fussy_sync
// Bit 11 - fussy_sync_enable
// Bit 10:0 - sync target line
#define ENCP_SYNC_TO_LINE_EN                       ((0x1c46  << 2) + 0xd0100000)
// Bit 12:0 - sync target pixel
#define ENCP_SYNC_TO_PIXEL                         ((0x1c47  << 2) + 0xd0100000)
// Bit 15:11 - sync length
// Bit 10:0 - sync start line
#define ENCT_SYNC_LINE_LENGTH                      ((0x1c48  << 2) + 0xd0100000)
// Bit 15 - sync_pulse_enable
// Bit 12:0 - sync start pixel
#define ENCT_SYNC_PIXEL_EN                         ((0x1c49  << 2) + 0xd0100000)
// Bit 15 - enci_sync_enable
// Bit 14 - encp_sync_enable
// Bit 13 - enct_sync_enable
// Bit 12 - short_fussy_sync
// Bit 11 - fussy_sync_enable
// Bit 10:0 - sync target line
#define ENCT_SYNC_TO_LINE_EN                       ((0x1c4a  << 2) + 0xd0100000)
// Bit 12:0 - sync target pixel
#define ENCT_SYNC_TO_PIXEL                         ((0x1c4b  << 2) + 0xd0100000)
// Bit 15:11 - sync length
// Bit 10:0 - sync start line
#define ENCL_SYNC_LINE_LENGTH                      ((0x1c4c  << 2) + 0xd0100000)
// Bit 15 - sync_pulse_enable
// Bit 12:0 - sync start pixel
#define ENCL_SYNC_PIXEL_EN                         ((0x1c4d  << 2) + 0xd0100000)
// Bit 15 - enci_sync_enable
// Bit 14 - encp_sync_enable
// Bit 13 - enct_sync_enable
// Bit 12 - short_fussy_sync
// Bit 11 - fussy_sync_enable
// Bit 10:0 - sync target line
#define ENCL_SYNC_TO_LINE_EN                       ((0x1c4e  << 2) + 0xd0100000)
// Bit 12:0 - sync target pixel
#define ENCL_SYNC_TO_PIXEL                         ((0x1c4f  << 2) + 0xd0100000)
// bit    3 cfg_encp_lcd_scaler_bypass. 1=Do not scale LCD input data;
//                                      0=Scale LCD input data to y [16*4,235*4], c [16*4,240*4].
// bit    2 cfg_encp_vadj_scaler_bypass. 1=Do not scale data to enc480p_vadj;
//                                       0=Scale enc480p_vadj input data to y [16*4,235*4], c [16*4,240*4].
// bit    1 cfg_vfifo2vd_out_scaler_bypass. 1=Do not scale vfifo2vd's output vdata;
//                                          0=Scale vfifo2vd's output vdata to y [16,235], c [16,240].
// bit    0 cfg_vfifo_din_full_range. 1=Data from viu fifo is full range [0,1023];
//                                    0=Data from viu fifo is y [16*4,235*4], c [16*4,240*4].
#define ENCP_VFIFO2VD_CTL2                         ((0x1c50  << 2) + 0xd0100000)
// bit 15:1 Reserved.
// bit    0 cfg_int_dvi_sel_rgb. Applicable for using on-chip hdmi tx module only. This bit controls correct bit-mapping from
//          Venc to hdmi_tx depending on whether YCbCr or RGB mode.
//                               1=Map data bit from Venc to hdmi_tx for RGB mode;
//                               0=Default. Map data bit from Venc to hdmi_tx for YCbCr mode.
#define VENC_DVI_SETTING_MORE                      ((0x1c51  << 2) + 0xd0100000)
#define VENC_VDAC_DAC4_FILT_CTRL0                  ((0x1c54  << 2) + 0xd0100000)
#define VENC_VDAC_DAC4_FILT_CTRL1                  ((0x1c55  << 2) + 0xd0100000)
#define VENC_VDAC_DAC5_FILT_CTRL0                  ((0x1c56  << 2) + 0xd0100000)
#define VENC_VDAC_DAC5_FILT_CTRL1                  ((0x1c57  << 2) + 0xd0100000)
//Bit 0   filter_en
#define VENC_VDAC_DAC0_FILT_CTRL0                  ((0x1c58  << 2) + 0xd0100000)
//dout = ((din + din_d2) * coef1 + (din_d1 * coef0) + 32) >> 6
//Bit 15:8, coef1,
//Bit 7:0, coef0, 
#define VENC_VDAC_DAC0_FILT_CTRL1                  ((0x1c59  << 2) + 0xd0100000)
//Bit 0   filter_en
#define VENC_VDAC_DAC1_FILT_CTRL0                  ((0x1c5a  << 2) + 0xd0100000)
//dout = ((din + din_d2) * coef1 + (din_d1 * coef0) + 32) >> 6
//Bit 15:8, coef1,
//Bit 7:0, coef0, 
#define VENC_VDAC_DAC1_FILT_CTRL1                  ((0x1c5b  << 2) + 0xd0100000)
//Bit 0   filter_en
#define VENC_VDAC_DAC2_FILT_CTRL0                  ((0x1c5c  << 2) + 0xd0100000)
//dout = ((din + din_d2) * coef1 + (din_d1 * coef0) + 32) >> 6
//Bit 15:8, coef1,
//Bit 7:0, coef0, 
#define VENC_VDAC_DAC2_FILT_CTRL1                  ((0x1c5d  << 2) + 0xd0100000)
//Bit 0   filter_en
#define VENC_VDAC_DAC3_FILT_CTRL0                  ((0x1c5e  << 2) + 0xd0100000)
//dout = ((din + din_d2) * coef1 + (din_d1 * coef0) + 32) >> 6
//Bit 15:8, coef1,
//Bit 7:0, coef0, 
#define VENC_VDAC_DAC3_FILT_CTRL1                  ((0x1c5f  << 2) + 0xd0100000)
//===========================================================================
// ENCT registers
#define ENCT_VIDEO_EN                              ((0x1c60  << 2) + 0xd0100000)
#define ENCT_VIDEO_Y_SCL                           ((0x1c61  << 2) + 0xd0100000)
#define ENCT_VIDEO_PB_SCL                          ((0x1c62  << 2) + 0xd0100000)
#define ENCT_VIDEO_PR_SCL                          ((0x1c63  << 2) + 0xd0100000)
#define ENCT_VIDEO_Y_OFFST                         ((0x1c64  << 2) + 0xd0100000)
#define ENCT_VIDEO_PB_OFFST                        ((0x1c65  << 2) + 0xd0100000)
#define ENCT_VIDEO_PR_OFFST                        ((0x1c66  << 2) + 0xd0100000)
//----- Video mode
#define ENCT_VIDEO_MODE                            ((0x1c67  << 2) + 0xd0100000)
#define ENCT_VIDEO_MODE_ADV                        ((0x1c68  << 2) + 0xd0100000)
//--------------- Debug pins
#define ENCT_DBG_PX_RST                            ((0x1c69  << 2) + 0xd0100000)
#define ENCT_DBG_LN_RST                            ((0x1c6a  << 2) + 0xd0100000)
#define ENCT_DBG_PX_INT                            ((0x1c6b  << 2) + 0xd0100000)
#define ENCT_DBG_LN_INT                            ((0x1c6c  << 2) + 0xd0100000)
//----------- Video Advanced setting
#define ENCT_VIDEO_YFP1_HTIME                      ((0x1c6d  << 2) + 0xd0100000)
#define ENCT_VIDEO_YFP2_HTIME                      ((0x1c6e  << 2) + 0xd0100000)
#define ENCT_VIDEO_YC_DLY                          ((0x1c6f  << 2) + 0xd0100000)
#define ENCT_VIDEO_MAX_PXCNT                       ((0x1c70  << 2) + 0xd0100000)
#define ENCT_VIDEO_HAVON_END                       ((0x1c71  << 2) + 0xd0100000)
#define ENCT_VIDEO_HAVON_BEGIN                     ((0x1c72  << 2) + 0xd0100000)
#define ENCT_VIDEO_VAVON_ELINE                     ((0x1c73  << 2) + 0xd0100000)
#define ENCT_VIDEO_VAVON_BLINE                     ((0x1c74  << 2) + 0xd0100000)
#define ENCT_VIDEO_HSO_BEGIN                       ((0x1c75  << 2) + 0xd0100000)
#define ENCT_VIDEO_HSO_END                         ((0x1c76  << 2) + 0xd0100000)
#define ENCT_VIDEO_VSO_BEGIN                       ((0x1c77  << 2) + 0xd0100000)
#define ENCT_VIDEO_VSO_END                         ((0x1c78  << 2) + 0xd0100000)
#define ENCT_VIDEO_VSO_BLINE                       ((0x1c79  << 2) + 0xd0100000)
#define ENCT_VIDEO_VSO_ELINE                       ((0x1c7a  << 2) + 0xd0100000)
#define ENCT_VIDEO_MAX_LNCNT                       ((0x1c7b  << 2) + 0xd0100000)
#define ENCT_VIDEO_BLANKY_VAL                      ((0x1c7c  << 2) + 0xd0100000)
#define ENCT_VIDEO_BLANKPB_VAL                     ((0x1c7d  << 2) + 0xd0100000)
#define ENCT_VIDEO_BLANKPR_VAL                     ((0x1c7e  << 2) + 0xd0100000)
#define ENCT_VIDEO_HOFFST                          ((0x1c7f  << 2) + 0xd0100000)
#define ENCT_VIDEO_VOFFST                          ((0x1c80  << 2) + 0xd0100000)
#define ENCT_VIDEO_RGB_CTRL                        ((0x1c81  << 2) + 0xd0100000)
#define ENCT_VIDEO_FILT_CTRL                       ((0x1c82  << 2) + 0xd0100000)
#define ENCT_VIDEO_OFLD_VPEQ_OFST                  ((0x1c83  << 2) + 0xd0100000)
#define ENCT_VIDEO_OFLD_VOAV_OFST                  ((0x1c84  << 2) + 0xd0100000)
#define ENCT_VIDEO_MATRIX_CB                       ((0x1c85  << 2) + 0xd0100000)
#define ENCT_VIDEO_MATRIX_CR                       ((0x1c86  << 2) + 0xd0100000)
#define ENCT_VIDEO_RGBIN_CTRL                      ((0x1c87  << 2) + 0xd0100000)
#define ENCT_MAX_LINE_SWITCH_POINT                 ((0x1c88  << 2) + 0xd0100000)
#define ENCT_DACSEL_0                              ((0x1c89  << 2) + 0xd0100000)
#define ENCT_DACSEL_1                              ((0x1c8a  << 2) + 0xd0100000)
//===========================================================================
// For ENCL
//===========================================================================
// bit 15:8 -- vfifo2vd_vd_sel
// bit 7 -- vfifo2vd_drop
// bit 6:1 -- vfifo2vd_delay
// bit 0 -- vfifo2vd_en
#define ENCL_VFIFO2VD_CTL                          ((0x1c90  << 2) + 0xd0100000)
// bit 12:0 -- vfifo2vd_pixel_start 
#define ENCL_VFIFO2VD_PIXEL_START                  ((0x1c91  << 2) + 0xd0100000)
// bit 12:00 -- vfifo2vd_pixel_end   
#define ENCL_VFIFO2VD_PIXEL_END                    ((0x1c92  << 2) + 0xd0100000)
// bit 10:0 -- vfifo2vd_line_top_start 
#define ENCL_VFIFO2VD_LINE_TOP_START               ((0x1c93  << 2) + 0xd0100000)
// bit 10:00 -- vfifo2vd_line_top_end   
#define ENCL_VFIFO2VD_LINE_TOP_END                 ((0x1c94  << 2) + 0xd0100000)
// bit 10:00 -- vfifo2vd_line_bot_start 
#define ENCL_VFIFO2VD_LINE_BOT_START               ((0x1c95  << 2) + 0xd0100000)
// bit 10:00 -- vfifo2vd_line_bot_end   
#define ENCL_VFIFO2VD_LINE_BOT_END                 ((0x1c96  << 2) + 0xd0100000)
#define ENCL_VFIFO2VD_CTL2                         ((0x1c97  << 2) + 0xd0100000)
#define ENCL_TST_EN                                ((0x1c98  << 2) + 0xd0100000)
#define ENCL_TST_MDSEL                             ((0x1c99  << 2) + 0xd0100000)
#define ENCL_TST_Y                                 ((0x1c9a  << 2) + 0xd0100000)
#define ENCL_TST_CB                                ((0x1c9b  << 2) + 0xd0100000)
#define ENCL_TST_CR                                ((0x1c9c  << 2) + 0xd0100000)
#define ENCL_TST_CLRBAR_STRT                       ((0x1c9d  << 2) + 0xd0100000)
#define ENCL_TST_CLRBAR_WIDTH                      ((0x1c9e  << 2) + 0xd0100000)
#define ENCL_TST_VDCNT_STSET                       ((0x1c9f  << 2) + 0xd0100000)
//===========================================================================
// ENCL registers
#define ENCL_VIDEO_EN                              ((0x1ca0  << 2) + 0xd0100000)
#define ENCL_VIDEO_Y_SCL                           ((0x1ca1  << 2) + 0xd0100000)
#define ENCL_VIDEO_PB_SCL                          ((0x1ca2  << 2) + 0xd0100000)
#define ENCL_VIDEO_PR_SCL                          ((0x1ca3  << 2) + 0xd0100000)
#define ENCL_VIDEO_Y_OFFST                         ((0x1ca4  << 2) + 0xd0100000)
#define ENCL_VIDEO_PB_OFFST                        ((0x1ca5  << 2) + 0xd0100000)
#define ENCL_VIDEO_PR_OFFST                        ((0x1ca6  << 2) + 0xd0100000)
//----- Video mode
#define ENCL_VIDEO_MODE                            ((0x1ca7  << 2) + 0xd0100000)
#define ENCL_VIDEO_MODE_ADV                        ((0x1ca8  << 2) + 0xd0100000)
//--------------- Debug pins
#define ENCL_DBG_PX_RST                            ((0x1ca9  << 2) + 0xd0100000)
#define ENCL_DBG_LN_RST                            ((0x1caa  << 2) + 0xd0100000)
#define ENCL_DBG_PX_INT                            ((0x1cab  << 2) + 0xd0100000)
#define ENCL_DBG_LN_INT                            ((0x1cac  << 2) + 0xd0100000)
//----------- Video Advanced setting
#define ENCL_VIDEO_YFP1_HTIME                      ((0x1cad  << 2) + 0xd0100000)
#define ENCL_VIDEO_YFP2_HTIME                      ((0x1cae  << 2) + 0xd0100000)
#define ENCL_VIDEO_YC_DLY                          ((0x1caf  << 2) + 0xd0100000)
#define ENCL_VIDEO_MAX_PXCNT                       ((0x1cb0  << 2) + 0xd0100000)
#define ENCL_VIDEO_HAVON_END                       ((0x1cb1  << 2) + 0xd0100000)
#define ENCL_VIDEO_HAVON_BEGIN                     ((0x1cb2  << 2) + 0xd0100000)
#define ENCL_VIDEO_VAVON_ELINE                     ((0x1cb3  << 2) + 0xd0100000)
#define ENCL_VIDEO_VAVON_BLINE                     ((0x1cb4  << 2) + 0xd0100000)
#define ENCL_VIDEO_HSO_BEGIN                       ((0x1cb5  << 2) + 0xd0100000)
#define ENCL_VIDEO_HSO_END                         ((0x1cb6  << 2) + 0xd0100000)
#define ENCL_VIDEO_VSO_BEGIN                       ((0x1cb7  << 2) + 0xd0100000)
#define ENCL_VIDEO_VSO_END                         ((0x1cb8  << 2) + 0xd0100000)
#define ENCL_VIDEO_VSO_BLINE                       ((0x1cb9  << 2) + 0xd0100000)
#define ENCL_VIDEO_VSO_ELINE                       ((0x1cba  << 2) + 0xd0100000)
#define ENCL_VIDEO_MAX_LNCNT                       ((0x1cbb  << 2) + 0xd0100000)
#define ENCL_VIDEO_BLANKY_VAL                      ((0x1cbc  << 2) + 0xd0100000)
#define ENCL_VIDEO_BLANKPB_VAL                     ((0x1cbd  << 2) + 0xd0100000)
#define ENCL_VIDEO_BLANKPR_VAL                     ((0x1cbe  << 2) + 0xd0100000)
#define ENCL_VIDEO_HOFFST                          ((0x1cbf  << 2) + 0xd0100000)
#define ENCL_VIDEO_VOFFST                          ((0x1cc0  << 2) + 0xd0100000)
#define ENCL_VIDEO_RGB_CTRL                        ((0x1cc1  << 2) + 0xd0100000)
#define ENCL_VIDEO_FILT_CTRL                       ((0x1cc2  << 2) + 0xd0100000)
#define ENCL_VIDEO_OFLD_VPEQ_OFST                  ((0x1cc3  << 2) + 0xd0100000)
#define ENCL_VIDEO_OFLD_VOAV_OFST                  ((0x1cc4  << 2) + 0xd0100000)
#define ENCL_VIDEO_MATRIX_CB                       ((0x1cc5  << 2) + 0xd0100000)
#define ENCL_VIDEO_MATRIX_CR                       ((0x1cc6  << 2) + 0xd0100000)
#define ENCL_VIDEO_RGBIN_CTRL                      ((0x1cc7  << 2) + 0xd0100000)
#define ENCL_MAX_LINE_SWITCH_POINT                 ((0x1cc8  << 2) + 0xd0100000)
#define ENCL_DACSEL_0                              ((0x1cc9  << 2) + 0xd0100000)
#define ENCL_DACSEL_1                              ((0x1cca  << 2) + 0xd0100000)
//===========================================================================
// RDMA Registers       0xcf0 - 0xcff
// Bit 31: 0 RW AHB start address for manual start DMA
#define RDMA_AHB_START_ADDR_MAN                    ((0x1cf0  << 2) + 0xd0100000)
// Bit 31: 0 RW AHB end address for manual start DMA
#define RDMA_AHB_END_ADDR_MAN                      ((0x1cf1  << 2) + 0xd0100000)
// Bit 31: 0 RW AHB start address for auto start source 1
#define RDMA_AHB_START_ADDR_1                      ((0x1cf2  << 2) + 0xd0100000)
// Bit 31: 0 RW AHB end address for auto start source 1
#define RDMA_AHB_END_ADDR_1                        ((0x1cf3  << 2) + 0xd0100000)
// Bit 31: 0 RW AHB start address for auto start source 2
#define RDMA_AHB_START_ADDR_2                      ((0x1cf4  << 2) + 0xd0100000)
// Bit 31: 0 RW AHB end address for auto start source 2
#define RDMA_AHB_END_ADDR_2                        ((0x1cf5  << 2) + 0xd0100000)
// Bit 31: 0 RW AHB start address for auto start source 3
#define RDMA_AHB_START_ADDR_3                      ((0x1cf6  << 2) + 0xd0100000)
// Bit 31: 0 RW AHB end address for auto start source 3
#define RDMA_AHB_END_ADDR_3                        ((0x1cf7  << 2) + 0xd0100000)
// Auto start DMA control:
// Bit 31:24 RW ctrl_enable_int_3. Interrupt inputs enable mask for source 3.
// Bit 23:16 RW ctrl_enable_int_2. Interrupt inputs enable mask for source 2.
// Bit 15: 8 RW ctrl_enable_int_1. Interrupt inputs enable mask for source 1.
// Bit     7 RW ctrl_cbus_write_3. Register read/write mode for auto-start 3. 1=Register write; 0=Register read.
// Bit     6 RW ctrl_cbus_write_3. Register read/write mode for auto-start 2. 1=Register write; 0=Register read.
// Bit     5 RW ctrl_cbus_write_3. Register read/write mode for auto-start 1. 1=Register write; 0=Register read.
// Bit     4 R  Rsrv.
// Bit     3 RW ctrl_cbus_addr_incr_3. 1=Incremental register access for auto-start 3; 0=Non-incremental (individual) register access.
// Bit     2 RW ctrl_cbus_addr_incr_2. 1=Incremental register access for auto-start 2; 0=Non-incremental (individual) register access.
// Bit     1 RW ctrl_cbus_addr_incr_1. 1=Incremental register access for auto-start 1; 0=Non-incremental (individual) register access.
// Bit     0 R  Rsrv.
#define RDMA_ACCESS_AUTO                           ((0x1cf8  << 2) + 0xd0100000)
// Manual start DMA control:
// Bit 31: 3 R  Rsrv.
// Bit     2 RW ctrl_cbus_write_man. Register read/write mode for manual-start. 1=Register write; 0=Register read.
// Bit     1 RW ctrl_cbus_addr_incr_man. 1=Incremental register access for manual-start; 0=Non-incremental (individual) register access.
// Bit     0 W  ctrl_start_man. Write 1 to this bit to manual-start DMA. This bit always read back 0.
#define RDMA_ACCESS_MAN                            ((0x1cf9  << 2) + 0xd0100000)
// RDMA general control:
// Bit 31:25 R  Rsrv.
// Bit    24 W  ctrl_clr_rdma_done_int. Write 1 to reset rdma_int level to 0. No need to clear this bit.
// Bit 23:19 R  Rsrv.
// Bit 18:13 R  Rsrv.
// Bit 12: 7 R  Rsrv.
// Bit     6 RW ctrl_ddr_urgent.
// Bit  5: 4 RW ctrl_ahb_wr_burst_size. 0=ABH write request burst size 16;
//                                      1=ABH write request burst size 24;
//                                      2=ABH write request burst size 32;
//                                      3=ABH write request burst size 48.
// Bit  3: 2 RW ctrl_ahb_rd_burst_size. 0=ABH read request burst size 16;
//                                      1=ABH read request burst size 24;
//                                      2=ABH read request burst size 32;
//                                      3=ABH read request burst size 48.
// Bit     1 RW ctrl_sw_reset. 1=Reset RDMA logics except register.
// Bit     0 RW ctrl_free_clk_enable. 0=Default, Enable clock gating. 1=No clock gating, enable free clock.
#define RDMA_CTRL                                  ((0x1cfa  << 2) + 0xd0100000)
// Read only.
// Bit 31:29 R  Rsrv.
// Bit    28 R  rdma_done_int.
// Bit 27:25 R  Rsrv.
// Bit 24:18 R  ahb_wrfifo_cnt. FIFO for buffering CBus read data to be sent to AHB
// Bit 17:11 R  ahb_rdfifo_cnt. FIFO for buffering data read from AHB.
// Bit 10: 8 R  ddr_req_st. =0 -- Idle; !=0 -- AHB interfacing ongoing.
// Bit  7: 4 R  curr_req. Latest requests that is being/been serviced. E.g. 0000=Idle; 0010=Latest serviced request is Req 1.
// Bit  3: 0 R  req_latch. Requests that are yet to be serviced. E.g. 0000=No request; 0001=Req 0 waiting; 1100=Req 2 and 3 waiting.
#define RDMA_STATUS                                ((0x1cfb  << 2) + 0xd0100000)
//
// Closing file:  venc2_regs.h
//
//`define VPP_VCBUS_BASE			     8'h1d
//
// Reading file:  vpp_regs.h
//
// synopsys translate_off
// synopsys translate_on
// -----------------------------------------------
// CBUS_BASE:  VPP_VCBUS_BASE = 0x1d
// -----------------------------------------------
//===========================================================================
// Video postprocesing Registers 
//===========================================================================
// dummy data used in the VPP preblend and scaler
// Bit 23:16    Y
// Bit 15:8     CB
// Bit 7:0      CR 
#define VPP_DUMMY_DATA                             ((0x1d00  << 2) + 0xd0100000)
//input line length used in VPP
#define VPP_LINE_IN_LENGTH                         ((0x1d01  << 2) + 0xd0100000)
//input Picture height used in VPP
#define VPP_PIC_IN_HEIGHT                          ((0x1d02  << 2) + 0xd0100000)
//Because there are many coefficients used in the vertical filter and horizontal filters,
//indirect access the coefficients of vertical filter and horizontal filter is used.
//For vertical filter, there are 33x4 coefficients 
//For horizontal filter, there are 33x4 coefficients
//Bit 15	index increment, if bit9 == 1  then (0: index increase 1, 1: index increase 2) else (index increase 2)	
//Bit 14	1: read coef through cbus enable, just for debug purpose in case when we wanna check the coef in ram in correct or not
//Bit 13    if true, vertical separated coef enable
//Bit 9     if true, use 9bit resolution coef, other use 8bit resolution coef
//Bit 8:7   type of index, 00: vertical coef, 01: vertical chroma coef: 10: horizontal coef, 11: resevered 
//Bit 6:0 	coef index
#define VPP_SCALE_COEF_IDX                         ((0x1d03  << 2) + 0xd0100000)
//coefficients for vertical filter and horizontal filter
#define VPP_SCALE_COEF                             ((0x1d04  << 2) + 0xd0100000)
//these following registers are the absolute line address pointer for output divided screen
//The output divided screen is shown in the following:
//
//  --------------------------   <------ line zero
//		. 
//		.
//		.		    region0        <---------- nonlinear region or nonscaling region	
//		.
//  ---------------------------  
//  ---------------------------  <------ region1_startp 
//		.
//		.           region1         <---------- nonlinear region
//		.
//		.
//  ---------------------------  
//  ---------------------------  <------ region2_startp
//		.
//		.           region2         <---------- linear region
//		.
//		.
//  ---------------------------  
//  ---------------------------  <------ region3_startp
//		.
//		.           region3         <---------- nonlinear region
//		.
//		.
//  ---------------------------  
//  ---------------------------  <------ region4_startp
//		.
//		.           region4         <---------- nonlinear region or nonoscaling region
//		.
//		.
//  ---------------------------  <------ region4_endp
//Bit 28:16 region1 startp
//Bit 12:0 region2 startp
#define VPP_VSC_REGION12_STARTP                    ((0x1d05  << 2) + 0xd0100000)
//Bit 28:16 region3 startp
//Bit 12:0 region4 startp
#define VPP_VSC_REGION34_STARTP                    ((0x1d06  << 2) + 0xd0100000)
#define VPP_VSC_REGION4_ENDP                       ((0x1d07  << 2) + 0xd0100000)
//vertical start phase step, (source/dest)*(2^24)
//Bit 27:24 integer part 
//Bit 23:0	fraction part
#define VPP_VSC_START_PHASE_STEP                   ((0x1d08  << 2) + 0xd0100000)
//vertical scaler region0 phase slope, Bit24 signed bit
#define VPP_VSC_REGION0_PHASE_SLOPE                ((0x1d09  << 2) + 0xd0100000)
//vertical scaler region1 phase slope, Bit24 signed bit
#define VPP_VSC_REGION1_PHASE_SLOPE                ((0x1d0a  << 2) + 0xd0100000)
//vertical scaler region3 phase slope, Bit24 signed bit
#define VPP_VSC_REGION3_PHASE_SLOPE                ((0x1d0b  << 2) + 0xd0100000)
//vertical scaler region4 phase slope, Bit24 signed bit
#define VPP_VSC_REGION4_PHASE_SLOPE                ((0x1d0c  << 2) + 0xd0100000)
//Bit 18:17     double line mode, input/output line width of vscaler becomes 2X, 
//           so only 2 line buffer in this case, use for 3D line by line interleave scaling
//           bit1 true, double the input width and half input height, bit0 true, change line buffer 2 lines instead of 4 lines
//Bit 16     0: progressive output, 1: interlace output
//Bit 15     vertical scaler output line0 in advance or not for bottom field
//Bit 14:13  vertical scaler initial repeat line0 number for bottom field
//Bit 11:8   vertical scaler initial receiving  number for bottom field   
//Bit 7      vertical scaler output line0 in advance or not for top field
//Bit 6:5    vertical scaler initial repeat line0 number for top field
//Bit 3:0    vertical scaler initial receiving  number for top field   
#define VPP_VSC_PHASE_CTRL                         ((0x1d0d  << 2) + 0xd0100000)
//Bit 31:16  vertical scaler field initial phase for bottom field
//Bit 15:0  vertical scaler field initial phase for top field
#define VPP_VSC_INI_PHASE                          ((0x1d0e  << 2) + 0xd0100000)
//Bit 28:16 region1 startp
//Bit 12:0 region2 startp
#define VPP_HSC_REGION12_STARTP                    ((0x1d10  << 2) + 0xd0100000)
//Bit 28:16 region3 startp
//Bit 12:0 region4 startp
#define VPP_HSC_REGION34_STARTP                    ((0x1d11  << 2) + 0xd0100000)
#define VPP_HSC_REGION4_ENDP                       ((0x1d12  << 2) + 0xd0100000)
//horizontal start phase step, (source/dest)*(2^24)
//Bit 27:24 integer part 
//Bit 23:0	fraction part
#define VPP_HSC_START_PHASE_STEP                   ((0x1d13  << 2) + 0xd0100000)
//horizontal scaler region0 phase slope, Bit24 signed bit
#define VPP_HSC_REGION0_PHASE_SLOPE                ((0x1d14  << 2) + 0xd0100000)
//horizontal scaler region1 phase slope, Bit24 signed bit
#define VPP_HSC_REGION1_PHASE_SLOPE                ((0x1d15  << 2) + 0xd0100000)
//horizontal scaler region3 phase slope, Bit24 signed bit
#define VPP_HSC_REGION3_PHASE_SLOPE                ((0x1d16  << 2) + 0xd0100000)
//horizontal scaler region4 phase slope, Bit24 signed bit
#define VPP_HSC_REGION4_PHASE_SLOPE                ((0x1d17  << 2) + 0xd0100000)
//Bit 22:21   horizontal scaler initial repeat pixel0 number0
//Bit 19:16   horizontal scaler initial receiving number0   
//Bit 15:0    horizontal scaler top field initial phase0
#define VPP_HSC_PHASE_CTRL                         ((0x1d18  << 2) + 0xd0100000)
// Bit 22 if true, divide VSC line length 2 as the HSC input length, othwise VSC length length is the same as the VSC line length,
//                 just for special usage, more flexibility
// Bit 21 if true, prevsc uses lin buffer, otherwise prevsc does not use line buffer, it should be same as prevsc_en
// Bit 20 prehsc_en
// Bit 19 prevsc_en
// Bit 18 vsc_en
// Bit 17 hsc_en
// Bit 16 scale_top_en
// Bit 15 video1 scale out enable
// Bit 12 if true, region0,region4 are nonlinear regions, otherwise they are not scaling regions, for horizontal scaler 
// Bit 10:8 horizontal scaler bank length
// Bit 5, vertical scaler phase field mode, if true, disable the opposite parity line output, more bandwith needed if output 1080i
// Bit 4 if true, region0,region4 are nonlinear regions, otherwise they are not scaling regions, for vertical scaler 
// Bit 2:0 vertical scaler bank length
#define VPP_SC_MISC                                ((0x1d19  << 2) + 0xd0100000)
// preblend video1 horizontal start and end
//Bit 28:16 start
//Bit 12:0 end
#define VPP_PREBLEND_VD1_H_START_END               ((0x1d1a  << 2) + 0xd0100000)
// preblend video1 vertical start and end
//Bit 28:16 start
//Bit 12:0 end
#define VPP_PREBLEND_VD1_V_START_END               ((0x1d1b  << 2) + 0xd0100000)
// postblend video1 horizontal start and end
//Bit 28:16 start
//Bit 12:0 end
#define VPP_POSTBLEND_VD1_H_START_END              ((0x1d1c  << 2) + 0xd0100000)
// postblend video1 vertical start and end
//Bit 28:16 start
//Bit 12:0 end
#define VPP_POSTBLEND_VD1_V_START_END              ((0x1d1d  << 2) + 0xd0100000)
// preblend/postblend video2 horizontal start and end
//Bit 28:16 start
//Bit 12:0 end
#define VPP_BLEND_VD2_H_START_END                  ((0x1d1e  << 2) + 0xd0100000)
// preblend/postblend video2 vertical start and end
//Bit 28:16 start
//Bit 12:0 end
#define VPP_BLEND_VD2_V_START_END                  ((0x1d1f  << 2) + 0xd0100000)
// preblend horizontal size
#define VPP_PREBLEND_H_SIZE                        ((0x1d20  << 2) + 0xd0100000)
// postblend horizontal size
#define VPP_POSTBLEND_H_SIZE                       ((0x1d21  << 2) + 0xd0100000)
//VPP hold lines
//Bit 29:24
//Bit 21:16
//Bit 15:8     preblend hold lines
//Bit 7:0      postblend hold lines
#define VPP_HOLD_LINES                             ((0x1d22  << 2) + 0xd0100000)
//Bit 25   if true, change screen to one color value for preblender
//Bit 24   if true, change screen to one color value for postblender
// Bit 23:16 one color Y
// Bit 15:8 one color Cb
// Bit  7:0 one color  Cr
#define VPP_BLEND_ONECOLOR_CTRL                    ((0x1d23  << 2) + 0xd0100000)
//Read Only, VPP preblend current_x, current_y
//Bit 28:16 current_x
//Bit 12:0 current_y
#define VPP_PREBLEND_CURRENT_XY                    ((0x1d24  << 2) + 0xd0100000)
//Read Only, VPP postblend current_x, current_y
//Bit 28:16 current_x
//Bit 12:0 current_y
#define VPP_POSTBLEND_CURRENT_XY                   ((0x1d25  << 2) + 0xd0100000)
// Bit 31  vd1_bgosd_exchange_en for preblend
// Bit 30  vd1_bgosd_exchange_en for postblend
// Bit 28   color management enable
// Bit 27,  if true, vd2 use viu2 output as the input, otherwise use normal vd2 from memory 
// Bit 26:18, vd2 alpha
// Bit 17, osd2 enable for preblend
// Bit 16, osd1 enable for preblend
// Bit 15, vd2 enable for preblend
// Bit 14, vd1 enable for preblend
// Bit 13, osd2 enable for postblend
// Bit 12, osd1 enable for postblend
// Bit 11, vd2 enable for postblend
// Bit 10, vd1 enable for postblend
// Bit 9,  if true, osd1 is alpha premultipiled 
// Bit 8,  if true, osd2 is alpha premultipiled 
// Bit 7,  postblend module enable
// Bit 6,  preblend module enable
// Bit 5,  if true, osd2 foreground compared with osd1 in preblend
// Bit 4,  if true, osd2 foreground compared with osd1 in postblend
// Bit 3,  
// Bit 2,  if true, disable resetting async fifo every vsync, otherwise every vsync
//			 the aync fifo will be reseted.
// Bit 1,	  
// Bit 0	if true, the output result of VPP is saturated
#define VPP_MISC                                   ((0x1d26  << 2) + 0xd0100000)
//Bit 31:20 ofifo line length minus 1
//Bit 19  if true invert input vs
//Bit 18  if true invert input hs
//Bit 17  force top/bottom field, enable
//Bit 16  force top/bottom field, 0: top, 1: bottom
//Bit 15  force one go_field, one pluse, write only
//Bit 14  force one go_line, one pluse, write only
//Bit 12:0 ofifo size (actually only bit 10:1 is valid), always even number
#define VPP_OFIFO_SIZE                             ((0x1d27  << 2) + 0xd0100000)
//Read only
//Bit 28:18 current scale out fifo counter
//Bit 17:13 current afifo counter
//Bit 12:0 current ofifo counter
#define VPP_FIFO_STATUS                            ((0x1d28  << 2) + 0xd0100000)
// Bit 5 SMOKE3 postblend enable only when postblend vd2 is not enable 
// Bit 4 SMOKE3 preblend enable only when preblend vd2 is not enable 
// Bit 3 SMOKE2 postblend enable only when postblend osd2 is not enable 
// Bit 2 SMOKE2 preblend enable only when preblend osd2 is not enable 
// Bit 1 SMOKE1 postblend enable only when postblend osd1 is not enable 
// Bit 0 SMOKE1 preblend enable only when preblend osd1 is not enable 
#define VPP_SMOKE_CTRL                             ((0x1d29  << 2) + 0xd0100000)
//smoke can be used only when that blending is disable and then be used as smoke function
//smoke1 for OSD1 chanel
//smoke2 for OSD2 chanel
//smoke3 for VD2 chanel
//31:24 Y
//23:16 Cb
//15:8 Cr
//7:0 Alpha
#define VPP_SMOKE1_VAL                             ((0x1d2a  << 2) + 0xd0100000)
#define VPP_SMOKE2_VAL                             ((0x1d2b  << 2) + 0xd0100000)
#define VPP_SMOKE3_VAL                             ((0x1d2c  << 2) + 0xd0100000)
//Bit 28:16 start
//Bit 12:0 end
#define VPP_SMOKE1_H_START_END                     ((0x1d2d  << 2) + 0xd0100000)
//Bit 28:16 start
//Bit 12:0 end
#define VPP_SMOKE1_V_START_END                     ((0x1d2e  << 2) + 0xd0100000)
//Bit 28:16 start
//Bit 12:0 end
#define VPP_SMOKE2_H_START_END                     ((0x1d2f  << 2) + 0xd0100000)
//Bit 28:16 start
//Bit 12:0 end
#define VPP_SMOKE2_V_START_END                     ((0x1d30  << 2) + 0xd0100000)
//Bit 28:16 start
//Bit 12:0 end
#define VPP_SMOKE3_H_START_END                     ((0x1d31  << 2) + 0xd0100000)
//Bit 28:16 start
//Bit 12:0 end
#define VPP_SMOKE3_V_START_END                     ((0x1d32  << 2) + 0xd0100000)
//Bit 27:16 scale out fifo line length minus 1
//Bit 12:0 scale out fifo size (actually only bit 11:1 is valid, 11:1, max 1024), always even number
#define VPP_SCO_FIFO_CTRL                          ((0x1d33  << 2) + 0xd0100000)
//for 3D quincunx sub-sampling and horizontal pixel by pixel 3D interleaving
//Bit 27:24, prehsc_mode, bit 3:2, prehsc odd line interp mode, bit 1:0, prehsc even line interp mode, 
//           each 2bit, 00: pix0+pix1/2, average, 01: pix1, 10: pix0
//Bit 23 horizontal scaler double pixel mode
//Bit 22:21   horizontal scaler initial repeat pixel0 number1
//Bit 19:16   horizontal scaler initial receiving number1   
//Bit 15:0    horizontal scaler top field initial phase1
#define VPP_HSC_PHASE_CTRL1                        ((0x1d34  << 2) + 0xd0100000)
//for 3D quincunx sub-sampling
//31:24  prehsc pattern, each patten 1 bit, from lsb -> msb
//22:20  prehsc pattern start
//18:16 prehsc pattern end
//15:8 hsc pattern, each patten 1 bit, from lsb -> msb
//6:4  hsc pattern start
//2:0  hsc pattern end
#define VPP_HSC_INI_PAT_CTRL                       ((0x1d35  << 2) + 0xd0100000)
//Bit 3			minus black level enable for vadj2
//Bit 2			Video adjustment enable for vadj2
//Bit 1			minus black level enable for vadj1
//Bit 0			Video adjustment enable for vadj1
#define VPP_VADJ_CTRL                              ((0x1d40  << 2) + 0xd0100000)
//Bit 16:8  brightness, signed value
//Bit 7:0	contrast, unsigned value, contrast from  0 <= contrast <2
#define VPP_VADJ1_Y                                ((0x1d41  << 2) + 0xd0100000)
//cb' = cb*ma + cr*mb
//cr' = cb*mc + cr*md
//all are bit 9:0, signed value, -2 < ma/mb/mc/md < 2
#define VPP_VADJ1_MA_MB                            ((0x1d42  << 2) + 0xd0100000)
#define VPP_VADJ1_MC_MD                            ((0x1d43  << 2) + 0xd0100000)
//Bit 16:8  brightness, signed value
//Bit 7:0	contrast, unsigned value, contrast from  0 <= contrast <2
#define VPP_VADJ2_Y                                ((0x1d44  << 2) + 0xd0100000)
//cb' = cb*ma + cr*mb
//cr' = cb*mc + cr*md
//all are bit 9:0, signed value, -2 < ma/mb/mc/md < 2
#define VPP_VADJ2_MA_MB                            ((0x1d45  << 2) + 0xd0100000)
#define VPP_VADJ2_MC_MD                            ((0x1d46  << 2) + 0xd0100000)
//Bit 2 horizontal chroma sharp/blur selection, 0:sharp, 1: blur  
//Bit 1 horizontal luma sharp/blur selection, 0:sharp, 1: blur  
//Bit 0 horizontal sharpness enable
#define VPP_HSHARP_CTRL                            ((0x1d50  << 2) + 0xd0100000)
//{1'b0,threhsold} < diff
//Bit 26:16  luma threshold0
//Bit 10:0   luma threshold1    
#define VPP_HSHARP_LUMA_THRESH01                   ((0x1d51  << 2) + 0xd0100000)
//
//Bit 26:16  luma threshold2
//Bit 10:0   luma threshold3    
#define VPP_HSHARP_LUMA_THRESH23                   ((0x1d52  << 2) + 0xd0100000)
//Bit 26:16  chroma threshold0
//Bit 10:0   chroma threshold1    
#define VPP_HSHARP_CHROMA_THRESH01                 ((0x1d53  << 2) + 0xd0100000)
//Bit 26:16  chroma threshold2
//Bit 10:0   chroma threshold3    
#define VPP_HSHARP_CHROMA_THRESH23                 ((0x1d54  << 2) + 0xd0100000)
//Bit 23:16 luma gain2
//Bit 15:8  luma gain1
//Bit 7:0   luma gain0
#define VPP_HSHARP_LUMA_GAIN                       ((0x1d55  << 2) + 0xd0100000)
//
//Bit 23:16 chroma gain2
//Bit 15:8  chroma gain1
//Bit 7:0   chroma gain0
#define VPP_HSHARP_CHROMA_GAIN                     ((0x1d56  << 2) + 0xd0100000)
//Read only 
//Bit 31, if it is true, it means this probe is valid in the last field/frame
//Bit 29:20 component 0
//Bit 19:10 component 1
//Bit 9:0 component 2
#define VPP_MATRIX_PROBE_COLOR                     ((0x1d5c  << 2) + 0xd0100000)
#define VPP_MATRIX_PROBE_COLOR1                    ((0x1dd7  << 2) + 0xd0100000)
//Bit 23:16 component 0
//Bit 15:8  component 1
//Bit 7:0 component 2
#define VPP_MATRIX_HL_COLOR                        ((0x1d5d  << 2) + 0xd0100000)
//28:16 probe x, postion
//12:0  probe y, position  
#define VPP_MATRIX_PROBE_POS                       ((0x1d5e  << 2) + 0xd0100000)
//Bit 16,  highlight_en
//Bit 15   probe_post, if true, probe pixel data after matrix, otherwise probe pixel data before matrix
//Bit 14:12 probe_sel, 000: select post matrix, 001: select vd1 matrix, 010: select vd2 matrix
//Bit 9:8  matrix coef idx selection, 00: select post matrix, 01: select vd1 matrix, 10: select vd2 matrix
//Bit 5    vd1 conversion matrix enable
//Bit 4    vd2 conversion matrix enable
//Bit 2    output y/cb/cr saturation enable, only for post matrix (y saturate to 16-235, cb/cr saturate to 16-240)
//Bit 1    input y/cb/cr saturation enable, only for post matrix (y saturate to 16-235, cb/cr saturate to 16-240)
//Bit 0    post conversion matrix enable
#define VPP_MATRIX_CTRL                            ((0x1d5f  << 2) + 0xd0100000)
//Bit 28:16 coef00
//Bit 12:0  coef01
#define VPP_MATRIX_COEF00_01                       ((0x1d60  << 2) + 0xd0100000)
//Bit 28:16 coef02 
//Bit 12:0  coef10 
#define VPP_MATRIX_COEF02_10                       ((0x1d61  << 2) + 0xd0100000)
//Bit 28:16 coef11
//Bit 12:0  coef12
#define VPP_MATRIX_COEF11_12                       ((0x1d62  << 2) + 0xd0100000)
//Bit 28:16 coef20
//Bit 12:0  coef21
#define VPP_MATRIX_COEF20_21                       ((0x1d63  << 2) + 0xd0100000)
#define VPP_MATRIX_COEF22                          ((0x1d64  << 2) + 0xd0100000)
//Bit 26:16 offset0
//Bit 10:0  offset1
#define VPP_MATRIX_OFFSET0_1                       ((0x1d65  << 2) + 0xd0100000)
//Bit 10:0  offset2
#define VPP_MATRIX_OFFSET2                         ((0x1d66  << 2) + 0xd0100000)
//Bit 26:16 pre_offset0
//Bit 10:0  pre_offset1
#define VPP_MATRIX_PRE_OFFSET0_1                   ((0x1d67  << 2) + 0xd0100000)
//Bit 10:0  pre_offset2
#define VPP_MATRIX_PRE_OFFSET2                     ((0x1d68  << 2) + 0xd0100000)
// dummy data used in the VPP postblend
// Bit 23:16    Y
// Bit 15:8     CB
// Bit 7:0      CR 
#define VPP_DUMMY_DATA1                            ((0x1d69  << 2) + 0xd0100000)
//Bit 31 gainoff module enable
//Bit 26:16 gain0, 1.10 unsigned data
//Bit 10:0  gain1, 1.10 unsigned dat
#define VPP_GAINOFF_CTRL0                          ((0x1d6a  << 2) + 0xd0100000)
//Bit 26:16 gain2, 1.10 unsigned data
//Bit 10:0, offset0, signed data
#define VPP_GAINOFF_CTRL1                          ((0x1d6b  << 2) + 0xd0100000)
//Bit 26:16, offset1, signed data
//Bit 10:0, offset2, signed data
#define VPP_GAINOFF_CTRL2                          ((0x1d6c  << 2) + 0xd0100000)
//Bit 26:16, pre_offset0, signed data 
//Bit 10:0, pre_offset1, signed data 
#define VPP_GAINOFF_CTRL3                          ((0x1d6d  << 2) + 0xd0100000)
//Bit 10:0, pre_offset2, signed data 
#define VPP_GAINOFF_CTRL4                          ((0x1d6e  << 2) + 0xd0100000)
//only two registers used in the color management, which are defined in the chroma_reg.h
//`define VPP_CHROMA_ADDR_PORT    8'h70
//`define VPP_CHROMA_DATA_PORT    8'h71
//
// Reading file:  chroma_reg.h
//
//**********************************************************************************
//* Copyright (c) 2008, AMLOGIC Inc.
//* All rights reserved
//**********************************************************************************
//* File :  chroma_reg.v
//* Author : Terrence Wang
//* Date : Dec 2008
//* Description :  
//*
//********************************************************************************** 
//* Modification History:
//* Date    Modified By         Reason
//**********************************************************************************
// synopsys translate_off
// synopsys translate_on
#define VPP_CHROMA_ADDR_PORT                       ((0x1d70  << 2) + 0xd0100000)
#define VPP_CHROMA_DATA_PORT                       ((0x1d71  << 2) + 0xd0100000)
//`define CHROMA_ADDR_PORT        8'h67
//`define CHROMA_DATA_PORT        8'h68

//  CHROMA_GAIN_REG_XX(00-07)
//  hue gain, sat gain function control
//  Bit 31      reg_sat_en                  enable sat adjustment in current region
//  Bit 27      reg_sat_increase            sat adjustment increase or decrease
//                                          1'b1: increase  1'b0: decrease
//  Bit 26:25   reg_sat_central_en          sat adjustment with central biggest or one side biggest
//                                          2'b01 central biggest   2'b00 one side biggest
//  Bit 24      reg_sat_shape               when sat adjustment one side biggest, define left or right
//                                          1'b1: left side biggest 1'b0 right side biggest  
//  Bit 23:16   reg_sat_gain                define the sat gain when sat adjustment
//                                          0x00-0xff
//  Bit 15      reg_hue_en                  enable hue adjustment in current region
//  Bit 11      reg_hue_clockwise           hue adjustment clockwise or anti-clockwise
//                                          1'b1: clockwise 1'b0: anti-clockwise
//  Bit 10:9    reg_hue_central_en          when hue adjustment, parabola curve or non-symmetry curve
//                                          1'b1: parabola curve    1'b0: non-symmetry curve
//  Bit 8       reg_hue_shape               when non-symmetry curve, define which side change more
//                                          1'b1: right side change more    1'b0: left side change more
//  Bit 7:0     reg_hue_gain                define the hue gain when hue adjustment
//                                          0x00-0x80, note: should be no bigger than 0x80

    #define CHROMA_GAIN_REG00       0x00


//  HUE_HUE_RANGE_REG_XX(00-07)
//  hue range select
//  Bit 31:24   no use now
//  Bit 23:16   reg_hue_shift_range         define the angle of target region
//                                          0x00-0xff,(0x100 means 120 degree though it can not be set)
//                                          must be greater or equal than 8'd8
//  Bit 15      reg_symmetry_en             this is used for create one symmetry region
//                                          the symmetry region hue_shift_start = reg_hue_hue_shift_start + reg_hue_shift_range<<5
//                                          the symmetry region hue_shift_range = reg_hue_shift_range
//                                          in symmetry region, all the sat and hue setting will be same with original region, 
//                                          except reg_hue_shape, reg_sat_shape, reg_hue_clockwise will be reversed
//  Bit 14:0    reg_hue_hue_shift_start     define the start angle of target region
//                                          0x6000 means 360 degree
//                                          only region 0 and 1 can exceed 360 degrees.

    #define HUE_HUE_RANGE_REG00     0x01


//  HUE_RANGE_INV_REG_XX
//  Calculation should be follow
//  HUE_RANGE_INV_REG0X[15:0] = ((1<<20)/HUE_HUE_RANGE_REG0X[23:16]+1)>>1
//  HUE_RANGE_INV_REG_XX is to used to save divider

    #define HUE_RANGE_INV_REG00     0x02



//  for belowing each low, high, low_slope, high_slope group:
//            a_____________b
//            /             \               a = low  + 2^low_slope
//           /               \              b = high - 2^high_slope
//          /                 \             low_slope <= 7; high_slope <= 7
//         /                   \            b >= a
//  ______/_____________________\________
//       low                    high
//
//
//  HUE_LUM_RANGE_REG_XX(00-07)
//  luma range selection for hue adjustment
//  Bit 31:24   reg_sat_lum_low             define the low level of luma value for sat adjustment
//                                          0x00-0xff
//  Bit 23:20   reg_hue_lum_high_slope      define the slope area below high level of luma value for hue adjustment
//                                          0x00-0x07
//  Bit 19:16   reg_hue_lum_low_slope       define the slope area above low  level of luma value for hue adjustment
//                                          0x00-0x07
//  Bit 15:8    reg_hue_lum_high            define the high level of luma value for hue adjustment
//                                          0x00-0xff
//  Bit 7:0     reg_hue_lum_low             define the low  level of luma value for hue adjustment
//                                          0x00-0xff

    #define HUE_LUM_RANGE_REG00     0x03

//  HUE_SAT_RANGE_REG_XX(00-07)
//  sat range selection for hue adjustment
//  Bit 31:24   reg_sat_lum_high            define the high level of luma value for sat adjustment
//                                          0x00-0xff
//  Bit 23:20   reg_hue_sat_high_slope      define the slope area below high level of sat value for hue adjustment
//                                          0x00-0x07
//  Bit 19:16   reg_hue_sat_low_slope       define the slope area above low  level of sat value for hue adjustment
//                                          0x00-0x07
//  Bit 15:8    reg_hue_sat_high            define the high level of sat value for hue adjustment
//                                          0x00-0xff
//  Bit 7:0     reg_hue_sat_low             define the low  level of sat value for hue adjustment
//                                          0x00-0xff

    #define HUE_SAT_RANGE_REG00     0x04

//  SAT_SAT_RANGE_REG_XX(00-07)
//  sat range selection for hue adjustment
//  Bit 31:28   reg_sat_lum_high_slope      define the slope area below high level of luma value for sat adjustment
//                                          0x00-0x07
//  Bit 27:24   reg_sat_lum_low_slope       define the slope area above low  level of luma value for sat adjustment
//                                          0x00-0x07
//  Bit 23:20   reg_sat_sat_high_slope      define the slope area below high level of sat value for sat adjustment
//                                          0x00-0x07
//  Bit 19:16   reg_sat_sat_low_slope       define the slope area above low  level of sat value for sat adjustment
//                                          0x00-0x07
//  Bit 15:8    reg_sat_sat_high            define the high level of sat value for sat adjustment
//                                          0x00-0xff
//  Bit 7:0     reg_sat_sat_low             define the low  level of sat value for sat adjustment
//                                          0x00-0xff

    #define SAT_SAT_RANGE_REG00     0x05


    #define CHROMA_GAIN_REG01       0x06
    #define HUE_HUE_RANGE_REG01     0x07
    #define HUE_RANGE_INV_REG01     0x08
    #define HUE_LUM_RANGE_REG01     0x09
    #define HUE_SAT_RANGE_REG01     0x0a
    #define SAT_SAT_RANGE_REG01     0x0b

    #define CHROMA_GAIN_REG02       0x0c
    #define HUE_HUE_RANGE_REG02     0x0d
    #define HUE_RANGE_INV_REG02     0x0e
    #define HUE_LUM_RANGE_REG02     0x0f
    #define HUE_SAT_RANGE_REG02     0x10
    #define SAT_SAT_RANGE_REG02     0x11


    #define CHROMA_GAIN_REG03       0x12
    #define HUE_HUE_RANGE_REG03     0x13
    #define HUE_RANGE_INV_REG03     0x14
    #define HUE_LUM_RANGE_REG03     0x15
    #define HUE_SAT_RANGE_REG03     0x16
    #define SAT_SAT_RANGE_REG03     0x17

    #define CHROMA_GAIN_REG04       0x18
    #define HUE_HUE_RANGE_REG04     0x19
    #define HUE_RANGE_INV_REG04     0x1a
    #define HUE_LUM_RANGE_REG04     0x1b
    #define HUE_SAT_RANGE_REG04     0x1c
    #define SAT_SAT_RANGE_REG04     0x1d

    #define CHROMA_GAIN_REG05       0x1e
    #define HUE_HUE_RANGE_REG05     0x1f
    #define HUE_RANGE_INV_REG05     0x20
    #define HUE_LUM_RANGE_REG05     0x21
    #define HUE_SAT_RANGE_REG05     0x22
    #define SAT_SAT_RANGE_REG05     0x23

    #define CHROMA_GAIN_REG06       0x24
    #define HUE_HUE_RANGE_REG06     0x25
    #define HUE_RANGE_INV_REG06     0x26
    #define HUE_LUM_RANGE_REG06     0x27
    #define HUE_SAT_RANGE_REG06     0x28
    #define SAT_SAT_RANGE_REG06     0x29

    #define CHROMA_GAIN_REG07       0x2a
    #define HUE_HUE_RANGE_REG07     0x2b
    #define HUE_RANGE_INV_REG07     0x2c
    #define HUE_LUM_RANGE_REG07     0x2d
    #define HUE_SAT_RANGE_REG07     0x2e
    #define SAT_SAT_RANGE_REG07     0x2f

//  REG_CHROMA_CONTROL
//  Bit 31      reg_chroma_en               enable color manage function
//                                          1'b1: enable    1'b0: bypass
//  Bit 6       sat_sel                     uv_max or u^2+v^2 selected as sat for reference
//                                          1'b1: uv_max(default)   1'b0: u^2+v^2
//  Bit 5       uv_adj_en                   final uv_adjust enable
//                                          1'b1: enable    1'b0: bypass
//  Bit 2       hue_en                      rgb to hue enable
//                                          1'b1: enable(default)   1'b0: bypass
//  Bit 1:0     csc_sel                     define input YUV with different color type
//                                          2'b00: 601(16-235)  2'b01: 709(16-235)
//                                          2'b10: 601(0-255)   2'b11: 709(0-255)
    #define REG_CHROMA_CONTROL      0x30   // default 32h'80000024
    #define REG_DEMO_CENTER_BAR     0x31   // default 32h'0
    #define REG_DEMO_HLIGHT_MODE    0x32   // default 32h'0
    #define REG_DEMO_OWR_DATA       0x33   // default 32h'0


////===========================================////
//// CM2 ADDR
////===========================================////

    #define SAT_BYYB_NODE_REG0          0x200   // default 32'h0
//Bit 31:24, sat_byyb_node3    the 4th node
//Bit 23:16, sat_byyb_node2    the 3th node
//Bit 15: 8, sat_byyb_node1    signed, the 2th node about saturation
//Bit  7: 0, sat_byyb_node0    signed, the 1th node about saturation
//gain offset along y coordinate,the gain normalized to 128 as "1"
    
	#define SAT_BYYB_NODE_REG1          0x201   // default 32'h0
//Bit 31:24, sat_byyb_node7     the 8th node
//Bit 23:16, sat_byyb_node6     the 7th node
//Bit 15: 8, sat_byyb_node5     signed, the 6th node about saturation
//Bit  7: 0, sat_byyb_node4     signed, the 5th node about saturation
//gain offset along y coordinate,the gain normalized to 128 as "1"

    #define SAT_BYYB_NODE_REG2          0x202   // default 32'h0
//Bit 31: 8, reserved
//Bit  7: 0, sat_byyb_node4     signed, the 5th node about saturation


    #define SAT_SRC_NODE_REG            0x203   // default 32'h0
//Bit 31:28, reserved 
//Bit 27:16, sat_src_node1  
//Bit 15:12, reserved 
//Bit 11: 0, sat_src_node0     usigned, threshold of input saturation for  first and second piece

    #define CM_ENH_SFT_MODE_REG         0x204   // default 32'h0
//Bit 31: 9, reserved
//Bit  8: 6, hue_lsft_mode        hue offset adjustments scale 
//Bit  5: 4, luma_lsft_mode       luma offset adjustments scale for reg_cm2_adj_luma_via_hue
//Bit  3: 2, sat_byy_rsft_mode    saturation gain adjustments scale for reg_cm2_adj_sat_via_y
//Bit  1: 0, sat_byhs_rsft_mode   saturation gain adjustments scale for reg_cm2_adj_sat_via_hs[:][:] 0:no scale up/down 1:dnscale by 2(-128,127)/2

    #define FRM_SIZE_REG                0x205   // default 32'h0
//Bit 31:29, reserved 
//Bit 28:16, reg_frm_height       the frame height size 
//Bit 15:13, reserved 
//Bit 12: 0, reg_frm_width        the frame width size 

    #define FITLER_CFG_REG              0x206   // default 32'h0
//Bit 31: 5, reserved 
//Bit  4: 4, inteleav_mod         horizontal interleave filter(zero-padding) for 3D considerations 0:using non-zero padding lpf 1:using zero-padding lpf
//Bit  3: 2, lpf_slt_uv           apply cm on lp portion or original video pixels options
//Bit  1: 0, lpf_slt_y            apply cm on lp portion or original video pixels options

    #define CM_GLOBAL_GAIN_REG          0x207   // default 32'h0
//Bit 31:28, reserved 
//Bit 27:16, cm2_global_sat     global saturation gain for general color adjustments(0~4095 <=> 0~8),512 normalized to "1"
//Bit 15:12, reserved 
//Bit 11: 0, cm2_global_hue     global hue offsets for general color adjustments(0~4095 <=> 0~360 degree) 

    #define CM_ENH_CTL_REG              0x208   // default 32'h0
//Bit  31:7, reserved
//Bit     6, hue_adj_en        cm2 hue adjustments
//Bit     5, sat_adj_en        cm2 saturation adjustments
//Bit     4, luma_adj_en       enable siganl for cm2 luma adjustments 
//Bit     3, reserved
//Bit     2, cm2_filt_en       apply cm on lp portion enable
//Bit     1, cm2_en            cm2 enable siganl
//Bit     0, cm1_en

    #define ROI_X_SCOPE_REG             0x209   // default 32'h0
//Bit 31:29, reserved 
//Bit 28:16, roi_x_end      ending col index of the region of interest
//Bit 15:13, reserved 
//Bit 12: 0, roi_x_beg      start col index of the region of interest
  
   #define ROI_Y_SCOPE_REG             0x20a   // default 32'h0
//Bit 31:29, reserved 
//Bit 28:16, roi_y_end      ending row index of the region of interest
//Bit 15:13, reserved 
//Bit 12: 0, roi_y_beg      start row index of the region of interest

    #define POI_XY_DIR_REG              0x20b   // default 32'h0
//Bit 31:29, reserved 
//Bit 28:16, poi_y_dir      ending row index of the region of interest
//Bit 15:13, reserved 
//Bit 12: 0, poi_x_dir      start row index of the region of interest

    #define COI_Y_SCOPE_REG             0x20c   // default 32'h0
//Bit 31:16, reserved 
//Bit 15: 8, coi_y_end       
//Bit  7: 0, coi_y_beg       

    #define COI_H_SCOPE_REG             0x20d   // default 32'h0
//Bit 31:28, reserved 
//Bit 27:16, coi_h_end 
//Bit 15:12, reserved 
//Bit 11: 0, coi_h_beg        lower bound of hue value for color of interest ,12 bits precision 

    #define COI_S_SCOPE_REG             0x20e   // default 32'h0
//Bit 31:28, reserved 
//Bit 27:16, coi_s_end        
//Bit 15:12, reserved 
//Bit 11: 0, coi_s_beg        lower bound of sat value for color of interest ,12 bits precision 
    #define IFO_MODE_REG                0x20f   // default 32'h0
//Bit 31:8, reserved 
//Bit  7:6, ifo_mode3 
//Bit  5:4, ifo_mode2 
//Bit  3:2, ifo_mode1 
//Bit  1:0, ifo_mode0 
    #define POI_RPL_MODE_REG            0x210   // default 32'h0
//Bit 31:4, reserved 
//Bit  3:0, poi_rpl_mode          enhance mode control of pixels inside and outside region of interest bit[3:2]control roi 
    #define DEMO_OWR_YHS_REG            0x211   // default 32'h0
//Bit 31: 0, demo_owr_yhs
 
    #define DEMO_POI_Y_REG              0x212   // default 32'h0
//Bit 31: 8, reserved 
//Bit  7: 0, luma_data_poi_r       only get locked higher 8bits
    #define DEMO_POI_H_REG              0x213   // default 32'h0
//Bit 31: 12, reserved 
//Bit 11: 0, hue_data_poi_r        only get locked higher 12bits
    #define DEMO_POI_S_REG              0x214   // default 32'h0
//Bit 31: 12, reserved 
//Bit 11: 0, sat_data_poi_r         only get locked higher 12bits
    //#define LUMA_BYH_LIMT_REG           0x215   // default 32'h0
    #define LUMA_ADJ_LIMT_REG           0x215   // default 32'h0
//Bit 31:24, reserved 
//Bit 23:16, luma_lmt_satslp         slope to do the luma adjustment degrade
//Bit 15:12, reserved 
//Bit 11:0, luma_lmt_satth           threshold to saturation
    #define SAT_ADJ_LIMT_REG            0x216   // default 32'h0
//Bit 31:24, reserved 
//Bit 23:16, sat_lmt_satslp        slope to do the adjustment degrade
//Bit 15:12, reserved 
//Bit 11:0, sat_lmt_satth          threshold to saturation
    #define HUE_ADJ_LIMT_REG            0x217   // default 32'h0
//Bit 31: 24, reserved 
//Bit 23: 16, hue_lmt_satslp        slope to do the adjustment degrade
//Bit 15: 12, reserved 
//Bit 11: 0,  hue_lmt_satth          threshold to saturation
    #define UVHS_OFST_REG               0x218   // default 32'h0
//Bit 31: 24, hs2uv_v_ofst 
//Bit 23: 16, hs2uv_u_ofst 
//Bit 15: 8,  uv2hs_v_ofst 
//Bit  7: 0,  uv2hs_u_ofst 
    #define HUE_CFG_PARA_REG            0x219   // default 32'h0
//Bit 31: 17, reserved 
//Bit     16, hue_protect_en 
//Bit 15: 13, cm2_hue_byhs_mode   
//Bit     12, cm2_hue_div_mode    
//Bit 11: 0, cm2_before_hue_ofst 
    #define DEMO_SPLT_CFG_REG           0x21a   // default 32'h0
//Bit 31: 22, reserved 
//Bit 21: 20, demo_split_mode  
//Bit 19: 16, demo_split_width        slope to do the adjustment degrade
//Bit 15: 13, reserved 
//Bit 12: 0,  demo_split_post           threshold to saturation
    #define DEMO_SPLT_YHS_REG           0x21b   // default 32'h0    
//Bit 31: 0,  demo_splt_yhs             threshold to saturation
    
    #define XVYCC_YSCP_REG              0x21c   // default 32'h0    
//Bit 31: 28, reserved 
//Bit 27: 16, xvycc_y_max 
//Bit 15: 12, reserved 
//Bit 11: 0, xvycc_y_min 
    #define XVYCC_USCP_REG              0x21d   // default 32'h0    
//Bit 31: 28, reserved 
//Bit 27: 16, xvycc_u_max 
//Bit 15: 12, reserved 
//Bit 11: 0, xvycc_u_min 
    #define XVYCC_VSCP_REG              0x21e   // default 32'h0    
//Bit 31: 28, reserved 
//Bit 27: 16, xvycc_v_max 
//Bit 15: 12, reserved 
//Bit 11: 0, xvycc_v_min 

////========= NODE 0 COEFFICIENT ==============////

    #define REG_CM2_ENH_COEFF0_H00      0x100   // default 32'H0
//Bit 31: 24, reg_cm2_adj_sat_via_hs_2  
//Bit 23: 16, reg_cm2_adj_sat_via_hs_1  
//Bit 15: 8,  reg_cm2_adj_sat_via_hs_0  
//Bit  7: 0, reg_cm2_adj_luma_via_h  
                                                  // [ 7: 0] : luma_byh_hx   / [15: 8] : sat_byhs_s0hx 
                                                  // [23:16] : sat_byhs_s0hx / [31:24] : sat_byhs_s2hx
    #define REG_CM2_ENH_COEFF1_H00      0x101   // default 32'H0
                                                  // [ 7: 0] : hue_byh_hx   / [15: 8] : hue_byy_y0hx 
                                                  // [23:16] : hue_byy_y1hx / [31:24] : hue_byy_y2hx
    #define REG_CM2_ENH_COEFF2_H00      0x102   // default 32'H0
                                                  // [ 7: 0] : hue_byy_y3hx / [15: 8] : hue_byy_y4hx 
                                                  // [23:16] : hue_bys_s0hx / [31:24] : hue_bys_s1hx
    #define REG_CM2_ENH_COEFF3_H00      0x103   // default 32'H0
                                                  // [ 7: 0] : hue_bys_s2hx / [15: 8] : hue_bys_s3hx 
                                                  // [23:16] : hue_bys_s4hx / [31:24] : hue_byya_y0hx
    #define REG_CM2_ENH_COEFF4_H00      0x104   // default 32'H0
                                                  // [ 7: 0] : hue_byya_y1hx / [15: 8] : hue_byya_y2hx 
                                                  // [23:16] : hue_byya_y3hx / [31:24] : hue_byya_y4hx

////========= NODE 1 COEFFICIENT ==============////

    #define REG_CM2_ENH_COEFF0_H01      0x108   // default 32'H0
                                                  // [ 7: 0] : luma_byh_hx   / [15: 8] : sat_byhs_s0hx 
                                                  // [23:16] : sat_byhs_s0hx / [31:24] : sat_byhs_s2hx
    #define REG_CM2_ENH_COEFF1_H01      0x109   // default 32'H0
                                                  // [ 7: 0] : hue_byh_hx   / [15: 8] : hue_byy_y0hx 
                                                  // [23:16] : hue_byy_y1hx / [31:24] : hue_byy_y2hx
    #define REG_CM2_ENH_COEFF2_H01      0x10a   // default 32'H0
                                                  // [ 7: 0] : hue_byy_y3hx / [15: 8] : hue_byy_y4hx 
                                                  // [23:16] : hue_bys_s0hx / [31:24] : hue_bys_s1hx
    #define REG_CM2_ENH_COEFF3_H01      0x10b   // default 32'H0
                                                  // [ 7: 0] : hue_bys_s2hx / [15: 8] : hue_bys_s3hx 
                                                  // [23:16] : hue_bys_s4hx / [31:24] : hue_byya_y0hx
    #define REG_CM2_ENH_COEFF4_H01      0x10c   // default 32'H0
                                                  // [ 7: 0] : hue_byya_y1hx / [15: 8] : hue_byya_y2hx 
                                                  // [23:16] : hue_byya_y3hx / [31:24] : hue_byya_y4hx

////========= NODE 2 COEFFICIENT ==============////

    #define REG_CM2_ENH_COEFF0_H02      0x110   // default 32'H0
                                                  // [ 7: 0] : luma_byh_hx   / [15: 8] : sat_byhs_s0hx 
                                                  // [23:16] : sat_byhs_s0hx / [31:24] : sat_byhs_s2hx
    #define REG_CM2_ENH_COEFF1_H02      0x111   // default 32'H0
                                                  // [ 7: 0] : hue_byh_hx   / [15: 8] : hue_byy_y0hx 
                                                  // [23:16] : hue_byy_y1hx / [31:24] : hue_byy_y2hx
    #define REG_CM2_ENH_COEFF2_H02      0x112   // default 32'H0
                                                  // [ 7: 0] : hue_byy_y3hx / [15: 8] : hue_byy_y4hx 
                                                  // [23:16] : hue_bys_s0hx / [31:24] : hue_bys_s1hx
    #define REG_CM2_ENH_COEFF3_H02      0x113   // default 32'H0
                                                  // [ 7: 0] : hue_bys_s2hx / [15: 8] : hue_bys_s3hx 
                                                  // [23:16] : hue_bys_s4hx / [31:24] : hue_byya_y0hx
    #define REG_CM2_ENH_COEFF4_H02      0x114   // default 32'H0
                                                  // [ 7: 0] : hue_byya_y1hx / [15: 8] : hue_byya_y2hx 
                                                  // [23:16] : hue_byya_y3hx / [31:24] : hue_byya_y4hx

////========= NODE 3 COEFFICIENT ==============////

    #define REG_CM2_ENH_COEFF0_H03      0x118   // default 32'H0
                                                  // [ 7: 0] : luma_byh_hx   / [15: 8] : sat_byhs_s0hx 
                                                  // [23:16] : sat_byhs_s0hx / [31:24] : sat_byhs_s2hx
    #define REG_CM2_ENH_COEFF1_H03      0x119   // default 32'H0
                                                  // [ 7: 0] : hue_byh_hx   / [15: 8] : hue_byy_y0hx 
                                                  // [23:16] : hue_byy_y1hx / [31:24] : hue_byy_y2hx
    #define REG_CM2_ENH_COEFF2_H03      0x11a   // default 32'H0
                                                  // [ 7: 0] : hue_byy_y3hx / [15: 8] : hue_byy_y4hx 
                                                  // [23:16] : hue_bys_s0hx / [31:24] : hue_bys_s1hx
    #define REG_CM2_ENH_COEFF3_H03      0x11b   // default 32'H0
                                                  // [ 7: 0] : hue_bys_s2hx / [15: 8] : hue_bys_s3hx 
                                                  // [23:16] : hue_bys_s4hx / [31:24] : hue_byya_y0hx
    #define REG_CM2_ENH_COEFF4_H03      0x11c   // default 32'H0
                                                  // [ 7: 0] : hue_byya_y1hx / [15: 8] : hue_byya_y2hx 
                                                  // [23:16] : hue_byya_y3hx / [31:24] : hue_byya_y4hx

////========= NODE 4 COEFFICIENT ==============////

    #define REG_CM2_ENH_COEFF0_H04      0x120   // default 32'H0
                                                  // [ 7: 0] : luma_byh_hx   / [15: 8] : sat_byhs_s0hx 
                                                  // [23:16] : sat_byhs_s0hx / [31:24] : sat_byhs_s2hx
    #define REG_CM2_ENH_COEFF1_H04      0x121   // default 32'H0
                                                  // [ 7: 0] : hue_byh_hx   / [15: 8] : hue_byy_y0hx 
                                                  // [23:16] : hue_byy_y1hx / [31:24] : hue_byy_y2hx
    #define REG_CM2_ENH_COEFF2_H04      0x122   // default 32'H0
                                                  // [ 7: 0] : hue_byy_y3hx / [15: 8] : hue_byy_y4hx 
                                                  // [23:16] : hue_bys_s0hx / [31:24] : hue_bys_s1hx
    #define REG_CM2_ENH_COEFF3_H04      0x123   // default 32'H0
                                                  // [ 7: 0] : hue_bys_s2hx / [15: 8] : hue_bys_s3hx 
                                                  // [23:16] : hue_bys_s4hx / [31:24] : hue_byya_y0hx
    #define REG_CM2_ENH_COEFF4_H04      0x124   // default 32'H0
                                                  // [ 7: 0] : hue_byya_y1hx / [15: 8] : hue_byya_y2hx 
                                                  // [23:16] : hue_byya_y3hx / [31:24] : hue_byya_y4hx

////========= NODE 5 COEFFICIENT ==============////

    #define REG_CM2_ENH_COEFF0_H05      0x128   // default 32'H0
                                                  // [ 7: 0] : luma_byh_hx   / [15: 8] : sat_byhs_s0hx 
                                                  // [23:16] : sat_byhs_s0hx / [31:24] : sat_byhs_s2hx
    #define REG_CM2_ENH_COEFF1_H05      0x129   // default 32'H0
                                                  // [ 7: 0] : hue_byh_hx   / [15: 8] : hue_byy_y0hx 
                                                  // [23:16] : hue_byy_y1hx / [31:24] : hue_byy_y2hx
    #define REG_CM2_ENH_COEFF2_H05      0x12a   // default 32'H0
                                                  // [ 7: 0] : hue_byy_y3hx / [15: 8] : hue_byy_y4hx 
                                                  // [23:16] : hue_bys_s0hx / [31:24] : hue_bys_s1hx
    #define REG_CM2_ENH_COEFF3_H05      0x12b   // default 32'H0
                                                  // [ 7: 0] : hue_bys_s2hx / [15: 8] : hue_bys_s3hx 
                                                  // [23:16] : hue_bys_s4hx / [31:24] : hue_byya_y0hx
    #define REG_CM2_ENH_COEFF4_H05      0x12c   // default 32'H0
                                                  // [ 7: 0] : hue_byya_y1hx / [15: 8] : hue_byya_y2hx 
                                                  // [23:16] : hue_byya_y3hx / [31:24] : hue_byya_y4hx

////========= NODE 6 COEFFICIENT ==============////

    #define REG_CM2_ENH_COEFF0_H06      0x130   // default 32'H0
                                                  // [ 7: 0] : luma_byh_hx   / [15: 8] : sat_byhs_s0hx 
                                                  // [23:16] : sat_byhs_s0hx / [31:24] : sat_byhs_s2hx
    #define REG_CM2_ENH_COEFF1_H06      0x131   // default 32'H0
                                                  // [ 7: 0] : hue_byh_hx   / [15: 8] : hue_byy_y0hx 
                                                  // [23:16] : hue_byy_y1hx / [31:24] : hue_byy_y2hx
    #define REG_CM2_ENH_COEFF2_H06      0x132   // default 32'H0
                                                  // [ 7: 0] : hue_byy_y3hx / [15: 8] : hue_byy_y4hx 
                                                  // [23:16] : hue_bys_s0hx / [31:24] : hue_bys_s1hx
    #define REG_CM2_ENH_COEFF3_H06      0x133   // default 32'H0
                                                  // [ 7: 0] : hue_bys_s2hx / [15: 8] : hue_bys_s3hx 
                                                  // [23:16] : hue_bys_s4hx / [31:24] : hue_byya_y0hx
    #define REG_CM2_ENH_COEFF4_H06      0x134   // default 32'H0
                                                  // [ 7: 0] : hue_byya_y1hx / [15: 8] : hue_byya_y2hx 
                                                  // [23:16] : hue_byya_y3hx / [31:24] : hue_byya_y4hx

////========= NODE 7 COEFFICIENT ==============////

    #define REG_CM2_ENH_COEFF0_H07      0x138   // default 32'H0
                                                  // [ 7: 0] : luma_byh_hx   / [15: 8] : sat_byhs_s0hx 
                                                  // [23:16] : sat_byhs_s0hx / [31:24] : sat_byhs_s2hx
    #define REG_CM2_ENH_COEFF1_H07      0x139   // default 32'H0
                                                  // [ 7: 0] : hue_byh_hx   / [15: 8] : hue_byy_y0hx 
                                                  // [23:16] : hue_byy_y1hx / [31:24] : hue_byy_y2hx
    #define REG_CM2_ENH_COEFF2_H07      0x13a   // default 32'H0
                                                  // [ 7: 0] : hue_byy_y3hx / [15: 8] : hue_byy_y4hx 
                                                  // [23:16] : hue_bys_s0hx / [31:24] : hue_bys_s1hx
    #define REG_CM2_ENH_COEFF3_H07      0x13b   // default 32'H0
                                                  // [ 7: 0] : hue_bys_s2hx / [15: 8] : hue_bys_s3hx 
                                                  // [23:16] : hue_bys_s4hx / [31:24] : hue_byya_y0hx
    #define REG_CM2_ENH_COEFF4_H07      0x13c   // default 32'H0
                                                  // [ 7: 0] : hue_byya_y1hx / [15: 8] : hue_byya_y2hx 
                                                  // [23:16] : hue_byya_y3hx / [31:24] : hue_byya_y4hx

////========= NODE 8 COEFFICIENT ==============////

    #define REG_CM2_ENH_COEFF0_H08      0x140   // default 32'H0
                                                  // [ 7: 0] : luma_byh_hx   / [15: 8] : sat_byhs_s0hx 
                                                  // [23:16] : sat_byhs_s0hx / [31:24] : sat_byhs_s2hx
    #define REG_CM2_ENH_COEFF1_H08      0x141   // default 32'H0
                                                  // [ 7: 0] : hue_byh_hx   / [15: 8] : hue_byy_y0hx 
                                                  // [23:16] : hue_byy_y1hx / [31:24] : hue_byy_y2hx
    #define REG_CM2_ENH_COEFF2_H08      0x142   // default 32'H0
                                                  // [ 7: 0] : hue_byy_y3hx / [15: 8] : hue_byy_y4hx 
                                                  // [23:16] : hue_bys_s0hx / [31:24] : hue_bys_s1hx
    #define REG_CM2_ENH_COEFF3_H08      0x143   // default 32'H0
                                                  // [ 7: 0] : hue_bys_s2hx / [15: 8] : hue_bys_s3hx 
                                                  // [23:16] : hue_bys_s4hx / [31:24] : hue_byya_y0hx
    #define REG_CM2_ENH_COEFF4_H08      0x144   // default 32'H0
                                                  // [ 7: 0] : hue_byya_y1hx / [15: 8] : hue_byya_y2hx 
                                                  // [23:16] : hue_byya_y3hx / [31:24] : hue_byya_y4hx

////========= NODE 9 COEFFICIENT ==============////

    #define REG_CM2_ENH_COEFF0_H09      0x148   // default 32'H0
                                                  // [ 7: 0] : luma_byh_hx   / [15: 8] : sat_byhs_s0hx 
                                                  // [23:16] : sat_byhs_s0hx / [31:24] : sat_byhs_s2hx
    #define REG_CM2_ENH_COEFF1_H09      0x149   // default 32'H0
                                                  // [ 7: 0] : hue_byh_hx   / [15: 8] : hue_byy_y0hx 
                                                  // [23:16] : hue_byy_y1hx / [31:24] : hue_byy_y2hx
    #define REG_CM2_ENH_COEFF2_H09      0x14a   // default 32'H0
                                                  // [ 7: 0] : hue_byy_y3hx / [15: 8] : hue_byy_y4hx 
                                                  // [23:16] : hue_bys_s0hx / [31:24] : hue_bys_s1hx
    #define REG_CM2_ENH_COEFF3_H09      0x14b   // default 32'H0
                                                  // [ 7: 0] : hue_bys_s2hx / [15: 8] : hue_bys_s3hx 
                                                  // [23:16] : hue_bys_s4hx / [31:24] : hue_byya_y0hx
    #define REG_CM2_ENH_COEFF4_H09      0x14c   // default 32'H0
                                                  // [ 7: 0] : hue_byya_y1hx / [15: 8] : hue_byya_y2hx 
                                                  // [23:16] : hue_byya_y3hx / [31:24] : hue_byya_y4hx

////========= NODE 10 COEFFICIENT ==============////

    #define REG_CM2_ENH_COEFF0_H10      0x150   // default 32'H0
                                                  // [ 7: 0] : luma_byh_hx   / [15: 8] : sat_byhs_s0hx 
                                                  // [23:16] : sat_byhs_s0hx / [31:24] : sat_byhs_s2hx
    #define REG_CM2_ENH_COEFF1_H10      0x151   // default 32'H0
                                                  // [ 7: 0] : hue_byh_hx   / [15: 8] : hue_byy_y0hx 
                                                  // [23:16] : hue_byy_y1hx / [31:24] : hue_byy_y2hx
    #define REG_CM2_ENH_COEFF2_H10      0x152   // default 32'H0
                                                  // [ 7: 0] : hue_byy_y3hx / [15: 8] : hue_byy_y4hx 
                                                  // [23:16] : hue_bys_s0hx / [31:24] : hue_bys_s1hx
    #define REG_CM2_ENH_COEFF3_H10      0x153   // default 32'H0
                                                  // [ 7: 0] : hue_bys_s2hx / [15: 8] : hue_bys_s3hx 
                                                  // [23:16] : hue_bys_s4hx / [31:24] : hue_byya_y0hx
    #define REG_CM2_ENH_COEFF4_H10      0x154   // default 32'H0
                                                  // [ 7: 0] : hue_byya_y1hx / [15: 8] : hue_byya_y2hx 
                                                  // [23:16] : hue_byya_y3hx / [31:24] : hue_byya_y4hx

////========= NODE 11 COEFFICIENT ==============////

    #define REG_CM2_ENH_COEFF0_H11      0x158   // default 32'H0
                                                  // [ 7: 0] : luma_byh_hx   / [15: 8] : sat_byhs_s0hx 
                                                  // [23:16] : sat_byhs_s0hx / [31:24] : sat_byhs_s2hx
    #define REG_CM2_ENH_COEFF1_H11      0x159   // default 32'H0
                                                  // [ 7: 0] : hue_byh_hx   / [15: 8] : hue_byy_y0hx 
                                                  // [23:16] : hue_byy_y1hx / [31:24] : hue_byy_y2hx
    #define REG_CM2_ENH_COEFF2_H11      0x15a   // default 32'H0
                                                  // [ 7: 0] : hue_byy_y3hx / [15: 8] : hue_byy_y4hx 
                                                  // [23:16] : hue_bys_s0hx / [31:24] : hue_bys_s1hx
    #define REG_CM2_ENH_COEFF3_H11      0x15b   // default 32'H0
                                                  // [ 7: 0] : hue_bys_s2hx / [15: 8] : hue_bys_s3hx 
                                                  // [23:16] : hue_bys_s4hx / [31:24] : hue_byya_y0hx
    #define REG_CM2_ENH_COEFF4_H11      0x15c   // default 32'H0
                                                  // [ 7: 0] : hue_byya_y1hx / [15: 8] : hue_byya_y2hx 
                                                  // [23:16] : hue_byya_y3hx / [31:24] : hue_byya_y4hx

////========= NODE 12 COEFFICIENT ==============////

    #define REG_CM2_ENH_COEFF0_H12      0x160   // default 32'H0
                                                  // [ 7: 0] : luma_byh_hx   / [15: 8] : sat_byhs_s0hx 
                                                  // [23:16] : sat_byhs_s0hx / [31:24] : sat_byhs_s2hx
    #define REG_CM2_ENH_COEFF1_H12      0x161   // default 32'H0
                                                  // [ 7: 0] : hue_byh_hx   / [15: 8] : hue_byy_y0hx 
                                                  // [23:16] : hue_byy_y1hx / [31:24] : hue_byy_y2hx
    #define REG_CM2_ENH_COEFF2_H12      0x162   // default 32'H0
                                                  // [ 7: 0] : hue_byy_y3hx / [15: 8] : hue_byy_y4hx 
                                                  // [23:16] : hue_bys_s0hx / [31:24] : hue_bys_s1hx
    #define REG_CM2_ENH_COEFF3_H12      0x163   // default 32'H0
                                                  // [ 7: 0] : hue_bys_s2hx / [15: 8] : hue_bys_s3hx 
                                                  // [23:16] : hue_bys_s4hx / [31:24] : hue_byya_y0hx
    #define REG_CM2_ENH_COEFF4_H12      0x164   // default 32'H0
                                                  // [ 7: 0] : hue_byya_y1hx / [15: 8] : hue_byya_y2hx 
                                                  // [23:16] : hue_byya_y3hx / [31:24] : hue_byya_y4hx

////========= NODE 13 COEFFICIENT ==============////

    #define REG_CM2_ENH_COEFF0_H13      0x168   // default 32'H0
                                                  // [ 7: 0] : luma_byh_hx   / [15: 8] : sat_byhs_s0hx 
                                                  // [23:16] : sat_byhs_s0hx / [31:24] : sat_byhs_s2hx
    #define REG_CM2_ENH_COEFF1_H13      0x169   // default 32'H0
                                                  // [ 7: 0] : hue_byh_hx   / [15: 8] : hue_byy_y0hx 
                                                  // [23:16] : hue_byy_y1hx / [31:24] : hue_byy_y2hx
    #define REG_CM2_ENH_COEFF2_H13      0x16a   // default 32'H0
                                                  // [ 7: 0] : hue_byy_y3hx / [15: 8] : hue_byy_y4hx 
                                                  // [23:16] : hue_bys_s0hx / [31:24] : hue_bys_s1hx
    #define REG_CM2_ENH_COEFF3_H13      0x16b   // default 32'H0
                                                  // [ 7: 0] : hue_bys_s2hx / [15: 8] : hue_bys_s3hx 
                                                  // [23:16] : hue_bys_s4hx / [31:24] : hue_byya_y0hx
    #define REG_CM2_ENH_COEFF4_H13      0x16c   // default 32'H0
                                                  // [ 7: 0] : hue_byya_y1hx / [15: 8] : hue_byya_y2hx 
                                                  // [23:16] : hue_byya_y3hx / [31:24] : hue_byya_y4hx


/* Constraints 
0)
  there are 16 regions totally. 8 regions are for hue adjustment, 8 regions are for sat adjustment.
  the hue range of the 16 regions can be set to overlap, but if overlap, the hue range(start and end) must be same.
  the 8 regions for hue adjustment should not overlap. if corresponding reg_hue_en_00 - 07 == 1
  the 8 regions for hue adjustment are defined by: (example are for region 0)
    a) hue:
        start: reg_hue_hue_shift_start_00[14:0]
        end:
        if reg_symmetry_en_00 == 0
        reg_hue_hue_shift_start_00[14:0] + (reg_hue_hue_shift_range_00[7:0]<<5)
        if reg_symmetry_en_00 == 1
        reg_hue_hue_shift_start_00[14:0] + (reg_hue_hue_shift_range_00[7:0]<<6)
    b) sat:
        start: reg_hue_sat_low_00 
        end:   reg_hue_sat_high_00  

  the 8 regions for sat adjustment should not overlap. if corresponding reg_sat_en_00 - 07 == 1
  the 8 regions for sat adjustment are defined by: (example are for region 0)
    a) hue: same as that for hue adjustment.
        start: reg_hue_hue_shift_start_00[14:0]
        end:
        if reg_symmetry_en_00 == 0
        reg_hue_hue_shift_start_00[14:0] + (reg_hue_hue_shift_range_00[7:0]<<5)
        if reg_symmetry_en_00 == 1
        reg_hue_hue_shift_start_00[14:0] + (reg_hue_hue_shift_range_00[7:0]<<6)
    b) sat:
        start: reg_sat_sat_low_00
        end:   reg_sat_sat_high_00  

1)
  reg_hue_hue_shift_range_00[7:0]:
  reg_hue_hue_shift_range_01[7:0]:
  reg_hue_hue_shift_range_02[7:0]:
  reg_hue_hue_shift_range_03[7:0]:
  reg_hue_hue_shift_range_04[7:0]:
  reg_hue_hue_shift_range_05[7:0]:
  reg_hue_hue_shift_range_06[7:0]:
  reg_hue_hue_shift_range_07[7:0]:
  must be greater or equal than 8'd8, so as reg_hue_range_inv_regxx can be represented by 0.0000_0000_xxxx_xxxx_xxxx_xxxx

2)
  all regions of 0-7 should meet below requirement. below is just an example for region 7.
  (reg_hue_lum_high_07 - reg_hue_lum_low_07) >= 
        (1<<reg_hue_lum_low_slope_07) + (1<<reg_hue_lum_high_slope_07)

  (reg_hue_sat_high_07 - reg_hue_sat_low_07) >=
        (1<<reg_hue_sat_low_slope_07) + (1<<reg_hue_sat_high_slope_07)

  (reg_sat_lum_high_07 - reg_sat_lum_low_07) >=
        (1<<reg_sat_lum_low_slope_07) + (1<<reg_sat_lum_high_slope_07)

  (reg_sat_sat_high_07 - reg_sat_sat_low_07) >=
        (1<<reg_sat_sat_low_slope_07) + (1<<reg_sat_sat_high_slope_07)

3)
  all of reg_hue_hue_shift_start_00[14:0] ~ 07[14:0] < 0x6000.
  only region 0 and 1 can exceed 360 degrees. ie:
    reg_hue_hue_shift_start_00 + (reg_hue_hue_shift_range_00<<5) can greater than 0x6000.
    reg_hue_hue_shift_start_01 + (reg_hue_hue_shift_range_01<<5) can greater than 0x6000.
  but below should be met:
    reg_hue_hue_shift_start_00 + (reg_hue_hue_shift_range_00<<5) < 0x8000. if reg_symmetry_en_00 == 0
    reg_hue_hue_shift_start_01 + (reg_hue_hue_shift_range_00<<5) < 0x8000. if reg_symmetry_en_00 == 0
    reg_hue_hue_shift_start_00 + (reg_hue_hue_shift_range_00<<6) < 0x8000. if reg_symmetry_en_00 == 1
    reg_hue_hue_shift_start_01 + (reg_hue_hue_shift_range_00<<6) < 0x8000. if reg_symmetry_en_00 == 1

  others could not exceed 360 degrees. ie:
    reg_hue_hue_shift_start_02(to 7) + (reg_hue_hue_shift_range_02 (to 7) <<5) < 0x6000. if reg_symmetry_en_02 (to 7) == 0.
    reg_hue_hue_shift_start_02(to 7) + (reg_hue_hue_shift_range_02 (to 7) <<6) < 0x6000. if reg_symmetry_en_02 (to 7) == 1.

4)
  reg_hue_gain_00[7:0] <= 0x80.
  reg_hue_gain_01[7:0] <= 0x80.
  reg_hue_gain_02[7:0] <= 0x80.
  reg_hue_gain_03[7:0] <= 0x80.
  reg_hue_gain_04[7:0] <= 0x80.
  reg_hue_gain_05[7:0] <= 0x80.
  reg_hue_gain_06[7:0] <= 0x80.
  reg_hue_gain_07[7:0] <= 0x80.

5)
  below registers can only have two setting: 00 and 01.
    reg_hue_central_en_00[1:0]  .. _07[1:0]
    reg_sat_central_en_00[1:0]  .. _07[1:0]

6)
  all reg_..._slope_00-07 should not be greater than 7, ie: maximum value is 7.
   for example: below is for region 0:
   reg_hue_lum_low_slope_00[3:0]  <= 7
   reg_hue_lum_high_slope_00[3:0] <= 7
   reg_hue_sat_low_slope_00[3:0]  <= 7
   reg_hue_sat_high_slope_00[3:0] <= 7
   reg_sat_lum_low_slope_00[3:0]  <= 7
   reg_sat_lum_high_slope_00[3:0] <= 7
   reg_sat_sat_low_slope_00[3:0]  <= 7
   reg_sat_sat_high_slope_00[3:0] <= 7
*/

// synopsys translate_off
// synopsys translate_on
//
// Closing file:  chroma_reg.h
//
//(hsvsharp), (blue), gainoff, mat_vd1,mat_vd2, mat_post, prebld, postbld,(hsharp),sco_ff, vadj1, vadj2, ofifo, (chroma1), clk0(free_clk) vpp_reg
//each item 2bits, for each 2bits, if bit 2*i+1 == 1, free clk, else if bit 2*i == 1 no clk, else auto gated clock 
//bit1 is not used, because I can not turn off vpp_reg clk because I can not turn on again 
//because the register itself canot be set again without clk
//Bit 31:0
#define VPP_GCLK_CTRL0                             ((0x1d72  << 2) + 0xd0100000)
//(front_lti), (front_cti), Chroma2_filter, Chroma2, (Ccoring), (blackext), dnlp
//Bit 13:0
#define VPP_GCLK_CTRL1                             ((0x1d73  << 2) + 0xd0100000)
//prehsc_clk, line_buf, prevsc, vsc, hsc_clk, clk0(free_clk)
//Bit 11:0
#define VPP_SC_GCLK_CTRL                           ((0x1d74  << 2) + 0xd0100000)
//Bit 17:9 VD1 alpha for preblend
//Bit 8:0 VD1 alpha for postblend
#define VPP_MISC1                                  ((0x1d76  << 2) + 0xd0100000)
//Bit 31:0 super scalar clock control 
#define VPP_SRSCL_GCLK_CTRL                        ((0x1d77  << 2) + 0xd0100000)
//Bit 31:0 OSD super scalar clock control 
#define VPP_OSDSR_GCLK_CTRL                        ((0x1d78  << 2) + 0xd0100000)
//Bit 31:0 vvycc clock control 
#define VPP_XVYCC_GCLK_CTRL                        ((0x1d79  << 2) + 0xd0100000)
//Bit 31:24     blackext_start
//Bit 23:16     blackext_slope1
//Bit 15:8      blackext_midpt
//Bit 7:0       blackext_slope2
#define VPP_BLACKEXT_CTRL                          ((0x1d80  << 2) + 0xd0100000)
//Bit 31:24     bottom of region03 output value
//Bit 23:16     bottom of region02 output value
//Bit 15:8      bottom of region01 output value
//Bit 7:0       bottom of region00 output value
#define VPP_DNLP_CTRL_00                           ((0x1d81  << 2) + 0xd0100000)
//Bit 31:24     bottom of region07 output value
//Bit 23:16     bottom of region06 output value
//Bit 15:8      bottom of region05 output value
//Bit 7:0       bottom of region04 output value
#define VPP_DNLP_CTRL_01                           ((0x1d82  << 2) + 0xd0100000)
//Bit 31:24     bottom of region11 output value
//Bit 23:16     bottom of region10 output value
//Bit 15:8      bottom of region09 output value
//Bit 7:0       bottom of region08 output value
#define VPP_DNLP_CTRL_02                           ((0x1d83  << 2) + 0xd0100000)
//Bit 31:24     bottom of region15 output value
//Bit 23:16     bottom of region14 output value
//Bit 15:8      bottom of region13 output value
//Bit 7:0       bottom of region12 output value
#define VPP_DNLP_CTRL_03                           ((0x1d84  << 2) + 0xd0100000)
//Bit 31:24     bottom of region19 output value
//Bit 23:16     bottom of region18 output value
//Bit 15:8      bottom of region17 output value
//Bit 7:0       bottom of region16 output value
#define VPP_DNLP_CTRL_04                           ((0x1d85  << 2) + 0xd0100000)
//Bit 31:24     bottom of region23 output value
//Bit 23:16     bottom of region22 output value
//Bit 15:8      bottom of region21 output value
//Bit 7:0       bottom of region20 output value
#define VPP_DNLP_CTRL_05                           ((0x1d86  << 2) + 0xd0100000)
//Bit 31:24     bottom of region27 output value
//Bit 23:16     bottom of region26 output value
//Bit 15:8      bottom of region25 output value
//Bit 7:0       bottom of region24 output value
#define VPP_DNLP_CTRL_06                           ((0x1d87  << 2) + 0xd0100000)
//Bit 31:24     bottom of region31 output value
//Bit 23:16     bottom of region30 output value
//Bit 15:8      bottom of region29 output value
//Bit 7:0       bottom of region28 output value
#define VPP_DNLP_CTRL_07                           ((0x1d88  << 2) + 0xd0100000)
//Bit 31:24     bottom of region35 output value
//Bit 23:16     bottom of region34 output value
//Bit 15:8      bottom of region33 output value
//Bit 7:0       bottom of region32 output value
#define VPP_DNLP_CTRL_08                           ((0x1d89  << 2) + 0xd0100000)
//Bit 31:24     bottom of region39 output value
//Bit 23:16     bottom of region38 output value
//Bit 15:8      bottom of region37 output value
//Bit 7:0       bottom of region36 output value
#define VPP_DNLP_CTRL_09                           ((0x1d8a  << 2) + 0xd0100000)
//Bit 31:24     bottom of region43 output value
//Bit 23:16     bottom of region42 output value
//Bit 15:8      bottom of region41 output value
//Bit 7:0       bottom of region40 output value
#define VPP_DNLP_CTRL_10                           ((0x1d8b  << 2) + 0xd0100000)
//Bit 31:24     bottom of region47 output value
//Bit 23:16     bottom of region46 output value
//Bit 15:8      bottom of region45 output value
//Bit 7:0       bottom of region44 output value
#define VPP_DNLP_CTRL_11                           ((0x1d8c  << 2) + 0xd0100000)
//Bit 31:24     bottom of region51 output value
//Bit 23:16     bottom of region50 output value
//Bit 15:8      bottom of region49 output value
//Bit 7:0       bottom of region48 output value
#define VPP_DNLP_CTRL_12                           ((0x1d8d  << 2) + 0xd0100000)
//Bit 31:24     bottom of region55 output value
//Bit 23:16     bottom of region54 output value
//Bit 15:8      bottom of region53 output value
//Bit 7:0       bottom of region52 output value
#define VPP_DNLP_CTRL_13                           ((0x1d8e  << 2) + 0xd0100000)
//Bit 31:24     bottom of region59 output value
//Bit 23:16     bottom of region58 output value
//Bit 15:8      bottom of region57 output value
//Bit 7:0       bottom of region56 output value
#define VPP_DNLP_CTRL_14                           ((0x1d8f  << 2) + 0xd0100000)
//Bit 31:24     bottom of region63 output value
//Bit 23:16     bottom of region62 output value
//Bit 15:8      bottom of region61 output value
//Bit 7:0       bottom of region60 output value
#define VPP_DNLP_CTRL_15                           ((0x1d90  << 2) + 0xd0100000)
//Bit 28        vlti_step
//Bit 27        vlti_step2
//Bit 26:25     hlti_step
//Bit 24:20     peaking_gain_h1
//Bit 19:15     peaking_gain_h2
//Bit 14:10     peaking_gain_h3
//Bit 9:5       peaking_gain_h4
//Bit 4:0       peaking_gain_h5
#define VPP_PEAKING_HGAIN                          ((0x1d91  << 2) + 0xd0100000)
//Bit 31        hsvsharp_buf_en
//Bit 30        hsvsharp_buf_c5line_mode
//Bit 29:25     peaking_gain_v1
//Bit 24:20     peaking_gain_v2
//Bit 19:15     peaking_gain_v3
//Bit 14:10     peaking_gain_v4
//Bit 9:5       peaking_gain_v5
//Bit 4:0       peaking_gain_v6
#define VPP_PEAKING_VGAIN                          ((0x1d92  << 2) + 0xd0100000)
//Bit 31:26     hpeaking_slope1
//Bit 25:20     hpeaking_slope2
//Bit 19:12     hpeaking_slope_th1
//Bit 11:6      vpeaking_slope1
//Bit 5:0       vpeaking_slope2
#define VPP_PEAKING_NLP_1                          ((0x1d93  << 2) + 0xd0100000)
//Bit 31:24     hpeaking_slope_th2
//Bit 23:16     hpeaking_nlp_coring_th
//Bit 15:8      hpeaking_nlp_pgain
//Bit 7:0       hpeaking_nlp_ngain
#define VPP_PEAKING_NLP_2                          ((0x1d94  << 2) + 0xd0100000)
//Bit 31:24     vpeaking_slope_th1
//Bit 23:18     speaking_slope1
//Bit 17:12     speaking_slope2
//Bit 11:4      speaking_slope_th1
//Bit 3:0       peaking_coring_gain
#define VPP_PEAKING_NLP_3                          ((0x1d95  << 2) + 0xd0100000)
//Bit 31:24     vpeaking_slope_th2
//Bit 23:16     vpeaking_nlp_coring_th
//Bit 15:8      vpeaking_nlp_pgain
//Bit 7:0       vpeaking_nlp_ngain
#define VPP_PEAKING_NLP_4                          ((0x1d96  << 2) + 0xd0100000)
//Bit 31:24     speaking_slope_th2
//Bit 23:16     speaking_nlp_coring_th
//Bit 15:8      speaking_nlp_pgain
//Bit 7:0       speaking_nlp_ngain
#define VPP_PEAKING_NLP_5                          ((0x1d97  << 2) + 0xd0100000)
//Bit 31:24     peaking_coring_th_l
//Bit 23:16     peaking_coring_th_h
//Bit 15:12     vlimit_high_coef
//Bit 11:8      vlimit_low_coef
//Bit 7:4       hlimit_high_coef
//Bit 3:0       hlimit_low_coef
#define VPP_SHARP_LIMIT                            ((0x1d98  << 2) + 0xd0100000)
//Bit 31:24     vlti_neg_gain
//Bit 23:16     vlti_pos_gain
//Bit 15:8      vlti_threshold
//Bit 7:0       vlti_blend_factor
#define VPP_VLTI_CTRL                              ((0x1d99  << 2) + 0xd0100000)
//Bit 31:24     hlti_neg_gain
//Bit 23:16     hlti_pos_gain
//Bit 15:8      hlti_threshold
//Bit 7:0       hlti_blend_factor
#define VPP_HLTI_CTRL                              ((0x1d9a  << 2) + 0xd0100000)
//Bit 30        cti_c444to422_en
//Bit 29:28     cti_vfilter_type
//Bit 27        cti_c422to444_en
//Bit 26:24     cti_step2
//Bit 23:21     cti_step
//Bit 20:16     cti_blend_factor
//Bit 15        cti_median_mode
//Bit 14:8      cti_threshold
//Bit 7:0       cti_gain
#define VPP_CTI_CTRL                               ((0x1d9b  << 2) + 0xd0100000)
//Bit 29        blue_stretch_cb_inc
//Bit 28        blue_stretch_cr_inc
//Bit 27        the MSB of blue_stretch_error_crp_inv[11:0]
//Bit 26        the MSB of blue_stretch_error_crn_inv[11:0]
//Bit 25        the MSB of blue_stretch_error_cbp_inv[11:0]
//Bit 24        the MSB of blue_stretch_error_cbn_inv[11:0]
//Bit 23:16     blue_stretch_gain
//Bit 15:8      blue_stretch_gain_cb4cr
//Bit 7:0       blue_stretch_luma_high
#define VPP_BLUE_STRETCH_1                         ((0x1d9c  << 2) + 0xd0100000)
//Bit 31:27     blue_stretch_error_crp
//Bit 26:16     the 11 LSB of blue_stretch_error_crp_inv[11:0]
//Bit 15:11     blue_stretch_error_crn
//Bit 10:0      the 11 LSB of blue_stretch_error_crn_inv[11:0]
#define VPP_BLUE_STRETCH_2                         ((0x1d9d  << 2) + 0xd0100000)
//Bit 31:27     blue_stretch_error_cbp
//Bit 26:16     the 11 LSB of blue_stretch_error_cbp_inv[11:0]
//Bit 15:11     blue_stretch_error_cbn
//Bit 10:0      the 11 LSB of blue_stretch_error_cbn_inv[11:0]
#define VPP_BLUE_STRETCH_3                         ((0x1d9e  << 2) + 0xd0100000)
//Bit 25:16 bypass_ccoring_ythd
//Bit 15:8, Chroma coring threshold
//Bit 3:0, Chroma coring slope
#define VPP_CCORING_CTRL                           ((0x1da0  << 2) + 0xd0100000)
//Bit 20 demo chroma coring enable
//Bit 19 demo black enxtension enable
//Bit 18 demo dynamic nonlinear luma processing enable
//Bit 17 demo hsvsharp enable
//Bit 16 demo bluestretch enable
//Bit 15:14, 2'b00: demo adjust on top, 2'b01: demo adjust on bottom, 2'b10: demo adjust on left, 2'b11: demo adjust on right
//Bit 4 chroma coring enable
//Bit 3 black enxtension enable
//Bit 2 dynamic nonlinear luma processing enable
//Bit 1 hsvsharp enable
//Bit 0 bluestretch enable
#define VPP_VE_ENABLE_CTRL                         ((0x1da1  << 2) + 0xd0100000)
//Bit 12:0, demo left or top screen width
#define VPP_VE_DEMO_LEFT_TOP_SCREEN_WIDTH          ((0x1da2  << 2) + 0xd0100000)
#define VPP_VE_DEMO_CENTER_BAR                     ((0x1da3  << 2) + 0xd0100000)
//28:16  ve_line_length
//12:0   ve_pic_height
#define VPP_VE_H_V_SIZE                            ((0x1da4  << 2) + 0xd0100000)
//28:16  psr_line_length
//12:0   psr_pic_height
#define VPP_PSR_H_V_SIZE                           ((0x1da5  << 2) + 0xd0100000)
//28:16  vppin_line_length
//12:0   vppin_pic_height
#define VPP_IN_H_V_SIZE                            ((0x1da6  << 2) + 0xd0100000)
//Bit 10   reset bit, high active
//Bit 9    0: measuring rising edge, 1: measuring falling edge
//Bit 8    if true, accumulate the counter number, otherwise not
//Bit 7:0  vsync_span, define how many vsync span need to measure 
#define VPP_VDO_MEAS_CTRL                          ((0x1da8  << 2) + 0xd0100000)
//Read only
//19:16  ind_meas_count_n, every number of sync_span vsyncs, this counter add 1
//15:0, high bit portion of counter
#define VPP_VDO_MEAS_VS_COUNT_HI                   ((0x1da9  << 2) + 0xd0100000)
//Read only
//31:0, low bit portion of counter
#define VPP_VDO_MEAS_VS_COUNT_LO                   ((0x1daa  << 2) + 0xd0100000)
//bit 11:9 vd2_sel,  001: select vd1_din, 010: select vd2_din, 011: select d2d3_l_din, 100: d2d3_r_din, otherwise no selection             
//bit 8:6 vd1_l_sel, 001: select vd1_din, 010: select vd2_din, 011: select d2d3_l_din, 100: d2d3_r_din, otherwise no selection
//bit 5:3 vd1_r_sel, 001: select vd1_din, 010: select vd2_din, 011: select d2d3_l_din, 100: d2d3_r_din, otherwise no selection
//note: the source vd1_l_sel selected cannot be used as the source of vd1_r_sel or vd2_sel
// vd1_r_sel is useful only vd1_interleave_mode is not 00. And the source vd1_r_sel used can not used for the vd2_sel any more.  
//bit 2:0 vd1_interleave_mode, 000: no interleave, 001: pixel interleaving, 010: line interleaving, 011: 2 pixel interleaving, 
// 100: 2 line interleaving
#define VPP_INPUT_CTRL                             ((0x1dab  << 2) + 0xd0100000)
//bit 25:24 cti_bpf_sel
//bit 20:16 cti_blend_factor_gama
//bit 12:8 cti_blend_factor_beta
//bit 4:0 cti_blend_factor_alpha
#define VPP_CTI_CTRL2                              ((0x1dac  << 2) + 0xd0100000)
#define VPP_PEAKING_SAT_THD1                       ((0x1dad  << 2) + 0xd0100000)
#define VPP_PEAKING_SAT_THD2                       ((0x1dae  << 2) + 0xd0100000)
#define VPP_PEAKING_SAT_THD3                       ((0x1daf  << 2) + 0xd0100000)
#define VPP_PEAKING_SAT_THD4                       ((0x1db0  << 2) + 0xd0100000)
#define VPP_PEAKING_SAT_THD5                       ((0x1db1  << 2) + 0xd0100000)
#define VPP_PEAKING_SAT_THD6                       ((0x1db2  << 2) + 0xd0100000)
#define VPP_PEAKING_SAT_THD7                       ((0x1db3  << 2) + 0xd0100000)
#define VPP_PEAKING_SAT_THD8                       ((0x1db4  << 2) + 0xd0100000)
#define VPP_PEAKING_SAT_THD9                       ((0x1db5  << 2) + 0xd0100000)
#define VPP_PEAKING_GAIN_ADD1                      ((0x1db6  << 2) + 0xd0100000)
#define VPP_PEAKING_GAIN_ADD2                      ((0x1db7  << 2) + 0xd0100000)
//bit 23:16 peaking_dnlp_gain, u5.3, DNLP effect
//bit 15:8  peaking_factor
//bit 5     peaking_dnlp_demo_en
//bit 4     peaking_dnlp_en
//bit 3:0   peaking_filter_sel
#define VPP_PEAKING_DNLP                           ((0x1db8  << 2) + 0xd0100000)
//bit 24    sharp_demo_win_en
//bit 23:12 sharp_demo_win_vend
//bit 11:0  sharp_demo_win_vstart
#define VPP_SHARP_DEMO_WIN_CTRL1                   ((0x1db9  << 2) + 0xd0100000)
//bit 23:12 sharp_demo_win_hend
//bit 11:0  sharp_demo_win_hstart
#define VPP_SHARP_DEMO_WIN_CTRL2                   ((0x1dba  << 2) + 0xd0100000)
//Bit 31:24     front_hlti_neg_gain
//Bit 23:16     front_hlti_pos_gain
//Bit 15:8      front_hlti_threshold
//Bit 7:0       front_hlti_blend_factor
#define VPP_FRONT_HLTI_CTRL                        ((0x1dbb  << 2) + 0xd0100000)
//Bit 31        front_enable, enable the front LTI&CTI before scaler
//Bit 26:24     front_cti_step2
//Bit 23:21     front_cti_step
//Bit 20:16     front_cti_blend_factor
//Bit 15        front_cti_median_mode
//Bit 14:8      front_cti_threshold
//Bit 7:0       front_cti_gain
#define VPP_FRONT_CTI_CTRL                         ((0x1dbc  << 2) + 0xd0100000)
//bit 29:28 front_hlti_step
//bit 25:24 front_cti_bpf_sel
//bit 20:16 front_cti_blend_factor_gama
//bit 12:8  front_cti_blend_factor_beta
//bit 4:0   front_cti_blend_factor_alpha
#define VPP_FRONT_CTI_CTRL2                        ((0x1dbd  << 2) + 0xd0100000)
//vertical scaler phase step
//Bit 27:0,  4.24 format
#define VPP_OSD_VSC_PHASE_STEP                     ((0x1dc0  << 2) + 0xd0100000)
//Bit 31:16, botttom vertical scaler initial phase
//Bit 15:0, top vertical scaler initial phase
#define VPP_OSD_VSC_INI_PHASE                      ((0x1dc1  << 2) + 0xd0100000)
//Bit 24    osd vertical Scaler enable
//Bit 23    osd_prog_interlace 0: current field is progressive, 1: current field is interlace
//Bit 22:21 osd_vsc_double_line_mode, bit1, double input width and half input height, bit0, change line buffer becomes 2 lines
//Bit 20    osd_vsc_phase0_always_en
//Bit 19    osd_vsc_nearest_en
//Bit 17:16 osd_vsc_bot_rpt_l0_num
//Bit 14:11 osd_vsc_bot_ini_rcv_num
//Bit 9:8   osd_vsc_top_rpt_l0_num
//Bit 6:3   osd_vsc_top_ini_rcv_num
//Bit 2:0   osd_vsc_bank_length 
#define VPP_OSD_VSC_CTRL0                          ((0x1dc2  << 2) + 0xd0100000)
//horizontal scaler phase step
//Bit 27:0,  4.24 format
#define VPP_OSD_HSC_PHASE_STEP                     ((0x1dc3  << 2) + 0xd0100000)
//Bit 31:16, horizontal scaler initial phase1
//Bit 15:0, horizontal scaler initial phase0
#define VPP_OSD_HSC_INI_PHASE                      ((0x1dc4  << 2) + 0xd0100000)
//Bit 22   osd horizontal scaler enable
//Bit 21   osd_hsc_double_pix_mode
//Bit 20   osd_hsc_phase0_always_en
//Bit 19   osd_hsc_nearest_en
//Bit 17:16 osd_hsc_rpt_p0_num1
//Bit 14:11 osd_hsc_ini_rcv_num1
//Bit 9:8   osd_hsc_rpt_p0_num0
//Bit 6:3   osd_hsc_ini_rcv_num0
//Bit 2:0   osd_hsc_bank_length
#define VPP_OSD_HSC_CTRL0                          ((0x1dc5  << 2) + 0xd0100000)
//for 3D quincunx sub-sampling
//bit 15:8 pattern, each patten 1 bit, from lsb -> msb
//bit 6:4  pattern start
//bit 2:0  pattern end
#define VPP_OSD_HSC_INI_PAT_CTRL                   ((0x1dc6  << 2) + 0xd0100000)
//bit 31:24, componet 0
//bit 23:16, component 1
//bit 15:8, component 2
//bit 7:0 component 3, alpha
#define VPP_OSD_SC_DUMMY_DATA                      ((0x1dc7  << 2) + 0xd0100000)
//Bit 14 osc_sc_din_osd1_alpha_mode, 1: (alpha >= 128) ? alpha -1: alpha,  0: (alpha >=1) ? alpha - 1: alpha.
//Bit 13 osc_sc_din_osd2_alpha_mode, 1: (alpha >= 128) ? alpha -1: alpha,  0: (alpha >=1) ? alpha - 1: alpha.
//Bit 12 osc_sc_dout_alpha_mode, 1: (alpha >= 128) ? alpha + 1: alpha, 0: (alpha >=1) ? alpha + 1: alpha.
//Bit 12 osc_sc_alpha_mode, 1: (alpha >= 128) ? alpha + 1: alpha, 0: (alpha >=1) ? alpha + 1: alpha.
//Bit 11:4 default alpha for vd1 or vd2 if they are selected as the source
//Bit 3 osd scaler path enable 
//Bit 1:0 osd_sc_sel, 00: select osd1 input, 01: select osd2 input, 10: select vd1 input, 11: select vd2 input after matrix
#define VPP_OSD_SC_CTRL0                           ((0x1dc8  << 2) + 0xd0100000)
//Bit 28:16 OSD scaler input width minus 1
//Bit 12:0 OSD scaler input height minus 1
#define VPP_OSD_SCI_WH_M1                          ((0x1dc9  << 2) + 0xd0100000)
//Bit 28:16 OSD scaler output horizontal start
//Bit 12:0 OSD scaler output horizontal end
#define VPP_OSD_SCO_H_START_END                    ((0x1dca  << 2) + 0xd0100000)
//Bit 28:16 OSD scaler output vertical start
//Bit 12:0 OSD scaler output vertical end
#define VPP_OSD_SCO_V_START_END                    ((0x1dcb  << 2) + 0xd0100000)
//Because there are many coefficients used in the vertical filter and horizontal filters,
//indirect access the coefficients of vertical filter and horizontal filter is used.
//For vertical filter, there are 33x4 coefficients 
//For horizontal filter, there are 33x4 coefficients
//Bit 15	index increment, if bit9 == 1  then (0: index increase 1, 1: index increase 2) else (index increase 2)	
//Bit 14	1: read coef through cbus enable, just for debug purpose in case when we wanna check the coef in ram in correct or not
//Bit 9     if true, use 9bit resolution coef, other use 8bit resolution coef
//Bit 8   type of index, 0: vertical coef,  1: horizontal coef
//Bit 6:0 	coef index
#define VPP_OSD_SCALE_COEF_IDX                     ((0x1dcc  << 2) + 0xd0100000)
//coefficients for vertical filter and horizontal filter
#define VPP_OSD_SCALE_COEF                         ((0x1dcd  << 2) + 0xd0100000)
//Bit 12:0 line number use to generate interrupt when line == this number
#define VPP_INT_LINE_NUM                           ((0x1dce  << 2) + 0xd0100000)
#define VPP_XVYCC_MISC                             ((0x1dcf  << 2) + 0xd0100000)
// new add lti/cti in 120924
//Bit  3: 0        //default== 0  reg_hlti_dn_flt_coe[0]
//Bit  7: 4        //default== 0  reg_hlti_dn_flt_coe[1]
//Bit 11: 8        //default== 0  reg_hlti_dn_flt_coe[2]
//Bit 15:12        //default== 2  reg_hlti_dn_flt_coe[3]
//Bit 19:16        //default== 4  reg_hlti_dn_flt_coe[4]
//Bit 22:20        //default== 3  reg_hlti_dn_flt_nrm  u3: 3~7
#define VPP_HLTI_DN_FLT                            ((0x1dd0  << 2) + 0xd0100000)
//Bit  7: 0        //default== 8  reg_hlti_bst_gain  u8, norm 16 as "1"
//Bit 15: 8        //default== 20 reg_hlti_bst_core  u8, norm 32 as "1"
//Bit 23:16        //default== 32 reg_hlti_oob_gain  u8, norm 32 as "1"
//Bit 28:24        //default== 0  reg_hlti_oob_core  u5                                  
#define VPP_HLTI_GAIN                              ((0x1dd1  << 2) + 0xd0100000)
//Bit  7: 0        //default== 2  reg_hlti_clp_ofst  u8, 
//Bit     8        //default== 0  reg_hlti_clp_mode  u1, 
//Bit 11: 9        //default== 1  reg_hlti_clp_wind  u3, 
//Bit 14:12        //default== 1  reg_hlti_bst_fltr  u3, 
//Bit    15        //default== 1  reg_hlti_enable    u1, 
#define VPP_HLTI_PARA                              ((0x1dd2  << 2) + 0xd0100000)
//Bit  3: 0        //default== 0  reg_hcti_dn_flt_coe[0]
//Bit  7: 4        //default== 0  reg_hcti_dn_flt_coe[1]
//Bit 11: 8        //default== 1  reg_hcti_dn_flt_coe[2]
//Bit 15:12        //default== 2  reg_hcti_dn_flt_coe[3]
//Bit 19:16        //default== 2  reg_hcti_dn_flt_coe[4]
//Bit 22:20        //default== 3  reg_hcti_dn_flt_nrm   u3: 3~7
#define VPP_HCTI_DN_FLT                            ((0x1dd3  << 2) + 0xd0100000)
//Bit 7: 0        //default== 48 reg_hcti_bst_gain  u8, norm 16 as "1"
//Bit15: 8        //default== 17 reg_hcti_bst_core  u8, norm 32 as "1"
//Bit23:16        //default== 16 reg_hcti_oob_gain  u8, norm 32 as "1"
//Bit28:24        //default==  0 reg_hcti_oob_core  u5
#define VPP_HCTI_GAIN                              ((0x1dd4  << 2) + 0xd0100000)
//Bit  7: 0        //default==  0 reg_hcti_clp_ofst  u8, 
//Bit     8        //default==  1 reg_hcti_clp_mode  u1, 
//Bit 11: 9        //default==  3 reg_hcti_clp_wind  u3, 
//Bit 14:12        //default==  6 reg_hcti_bst_fltr  u3, 
//Bit    15        //default==  1 reg_hcti_enable    u1, 
#define VPP_HCTI_PARA                              ((0x1dd5  << 2) + 0xd0100000)
//Bit  7: 0        //default== 48 reg_vcti_bst_gain  u8, normalize 16 as "1"
//Bit 15: 8        //default== 10 reg_vcti_bst_core  u8
//Bit 19:16        //default== 10 reg_vcti_clp_ofst  u4
//Bit    20        //default==  1 reg_vcti_clp_wind  u1, 0: wind 3, 1: wind5
#define VPP_VCTI_PARA                              ((0x1dd6  << 2) + 0xd0100000)
//`define VPP_MATRIX_PROBE_COLOR1 8'hd7  //defined before
//Bit 15          //default== 0, urgent_ctrl_en
//Bit 14          //default== 0, urgent_wr, if true for write buffer
//Bit 13          //default== 0, out_inv_en
//Bit 12          //default == 0, urgent_ini_value
//Bit 11:6        //default == 0, up_th  up threshold
//Bit 5:0         //default == 0, dn_th  dn threshold
#define VPP_OFIFO_URG_CTRL                         ((0x1dd8  << 2) + 0xd0100000)
// synopsys translate_off
// synopsys translate_on
//
// Closing file:  vpp_regs.h
//
//`define VIU2_VCBUS_BASE                8'h1e     
//
// Reading file:  v2regs.h
//
// synopsys translate_off
// synopsys translate_on
//===========================================================================
// Video Interface 2 Registers    0xe00 - 0xeff
//===========================================================================
// -----------------------------------------------
// CBUS_BASE:  VIU2_VCBUS_BASE = 0x1e
// -----------------------------------------------
#define VIU2_ADDR_START                            ((0x1e00  << 2) + 0xd0100000)
#define VIU2_ADDR_END                              ((0x1eff  << 2) + 0xd0100000)
//------------------------------------------------------------------------------
// VIU2 top-level registers
//------------------------------------------------------------------------------
// Bit  0 RW, osd1_reset
// Bit  1 RW, osd2_reset
// Bit  2 RW, vd1_reset
// Bit  3 RW, vd1_fmt_reset
// Bit  7 RW, vpp_reset
#define VIU2_SW_RESET                              ((0x1e01  << 2) + 0xd0100000)
//------------------------------------------------------------------------------
// OSD1 registers
//------------------------------------------------------------------------------
// Bit    31 Reserved
// Bit    30 RW, enable_free_clk: 1=use free-running clock to drive logics;
//                                0=use gated clock for low power.
// Bit    29 R, test_rd_dsr
// Bit    28 R, osd_done
// Bit 27:24 R, osd_blk_mode
// Bit 23:22 R, osd_blk_ptr
// Bit    21 R, osd_enable
//
// Bit 20:12 RW, global_alpha
// Bit    11 RW, test_rd_en
// Bit 10: 9 Reserved for control signals
// Bit  8: 5 RW, ctrl_mtch_y
// Bit     4 RW, ctrl_422to444
// Bit  3: 0 RW, osd_blk_enable. Bit 0 to enable block 0: 1=enable, 0=disable;
//                               Bit 1 to enable block 1, and so on.
#define VIU2_OSD1_CTRL_STAT                        ((0x1e10  << 2) + 0xd0100000)
// Bit 31:26 Reserved
// Bit 25:16 R, fifo_count
// Bit 15: 6 Reserved
// Bit  5: 4 RW, hold_fifo_lines[6:5]
// Bit     3 RW, rgb2yuv_full_range
// Bit     2 RW, alpha_9b_mode
// Bit     1 RW, reserved
// Bit     0 RW, color_expand_mode
#define VIU2_OSD1_CTRL_STAT2                       ((0x1e2d  << 2) + 0xd0100000)
// Bit 31: 9 Reserved
// Bit     8 RW, 0 = Write LUT, 1 = Read LUT
// Bit  7: 0 RW, lut_addr
#define VIU2_OSD1_COLOR_ADDR                       ((0x1e11  << 2) + 0xd0100000)
// Bit 31:24 RW, Y or R
// Bit 23:16 RW, Cb or G
// Bit 15: 8 RW, Cr or B
// Bit  7: 0 RW, Alpha
#define VIU2_OSD1_COLOR                            ((0x1e12  << 2) + 0xd0100000)
// Bit 31:24 RW, Y or R
// Bit 23:16 RW, Cb or G
// Bit 15: 8 RW, Cr or B
// Bit  7: 0 RW, Alpha
#define VIU2_OSD1_TCOLOR_AG0                       ((0x1e17  << 2) + 0xd0100000)
#define VIU2_OSD1_TCOLOR_AG1                       ((0x1e18  << 2) + 0xd0100000)
#define VIU2_OSD1_TCOLOR_AG2                       ((0x1e19  << 2) + 0xd0100000)
#define VIU2_OSD1_TCOLOR_AG3                       ((0x1e1a  << 2) + 0xd0100000)
// Bit 31:30 Reserved
// Bit    29 RW, y_rev: 0=normal read, 1=reverse read in Y direction
// Bit    28 RW, x_rev: 0=normal read, 1=reverse read in X direction
// Bit 27:24 Reserved
// Bit 23:16 RW, tbl_addr
// Bit    15 RW, little_endian: 0=big endian, 1=little endian
// Bit    14 RW, rpt_y
// Bit 13:12 RW, interp_ctrl. 0x=No interpolation; 10=Interpolate with previous
//                            pixel; 11=Interpolate with the average value
//                            between previous and next pixel.
// Bit 11: 8 RW, osd_blk_mode
// Bit     7 RW, rgb_en
// Bit     6 RW, tc_alpha_en
// Bit  5: 2 RW, color_matrix
// Bit     1 RW, interlace_en
// Bit     0 RW, interlace_sel_odd
#define VIU2_OSD1_BLK0_CFG_W0                      ((0x1e1b  << 2) + 0xd0100000)
#define VIU2_OSD1_BLK1_CFG_W0                      ((0x1e1f  << 2) + 0xd0100000)
#define VIU2_OSD1_BLK2_CFG_W0                      ((0x1e23  << 2) + 0xd0100000)
#define VIU2_OSD1_BLK3_CFG_W0                      ((0x1e27  << 2) + 0xd0100000)
// Bit 31:29 Reserved
// Bit 28:16 RW, x_end
// Bit 15:13 Reserved
// Bit 12: 0 RW, x_start
#define VIU2_OSD1_BLK0_CFG_W1                      ((0x1e1c  << 2) + 0xd0100000)
#define VIU2_OSD1_BLK1_CFG_W1                      ((0x1e20  << 2) + 0xd0100000)
#define VIU2_OSD1_BLK2_CFG_W1                      ((0x1e24  << 2) + 0xd0100000)
#define VIU2_OSD1_BLK3_CFG_W1                      ((0x1e28  << 2) + 0xd0100000)
// Bit 31:29 Reserved
// Bit 28:16 RW, y_end
// Bit 15:13 Reserved
// Bit 12: 0 RW, y_start
#define VIU2_OSD1_BLK0_CFG_W2                      ((0x1e1d  << 2) + 0xd0100000)
#define VIU2_OSD1_BLK1_CFG_W2                      ((0x1e21  << 2) + 0xd0100000)
#define VIU2_OSD1_BLK2_CFG_W2                      ((0x1e25  << 2) + 0xd0100000)
#define VIU2_OSD1_BLK3_CFG_W2                      ((0x1e29  << 2) + 0xd0100000)
// Bit 31:28 Reserved
// Bit 27:16 RW, h_end
// Bit 15:12 Reserved
// Bit 11: 0 RW, h_start
#define VIU2_OSD1_BLK0_CFG_W3                      ((0x1e1e  << 2) + 0xd0100000)
#define VIU2_OSD1_BLK1_CFG_W3                      ((0x1e22  << 2) + 0xd0100000)
#define VIU2_OSD1_BLK2_CFG_W3                      ((0x1e26  << 2) + 0xd0100000)
#define VIU2_OSD1_BLK3_CFG_W3                      ((0x1e2a  << 2) + 0xd0100000)
// Bit 31:28 Reserved
// Bit 27:16 RW, v_end
// Bit 15:12 Reserved
// Bit 11: 0 RW, v_start
#define VIU2_OSD1_BLK0_CFG_W4                      ((0x1e13  << 2) + 0xd0100000)
#define VIU2_OSD1_BLK1_CFG_W4                      ((0x1e14  << 2) + 0xd0100000)
#define VIU2_OSD1_BLK2_CFG_W4                      ((0x1e15  << 2) + 0xd0100000)
#define VIU2_OSD1_BLK3_CFG_W4                      ((0x1e16  << 2) + 0xd0100000)
// Bit    31 RW, burst_len_sel[2] of [2:0]
// Bit    30 RW, byte_swap: In addition to endian control, further define
//               whether to swap upper and lower byte within a 16-bit mem word.
//               0=No swap; 1=Swap data[15:0] to be {data[7:0], data[15:8]}
// Bit 29:22 R,  Reserved
// Bit 21:20 R,  fifo_st. 0=IDLE, 1=FILL, 2=ABORT 
// Bit    19 R,  fifo_overflow
//
// Bit 18:12 RW, fifo_depth_val, max value=64: set actual fifo depth to fifo_depth_val*8.
// Bit 11:10 RW, burst_len_sel[1:0] of [2:0]. 0=24(default), 1=32, 2=48, 3=64, 4=96, 5=128.
// Bit  9: 5 RW, hold_fifo_lines[4:0]
// Bit     4 RW, clear_err: one pulse to clear fifo_overflow
// Bit     3 RW, fifo_sync_rst
// Bit  2: 1 RW, endian
// Bit     0 RW, urgent
#define VIU2_OSD1_FIFO_CTRL_STAT                   ((0x1e2b  << 2) + 0xd0100000)
// Bit 31:24 R, Y or R
// Bit 23:16 R, Cb or G
// Bit 15: 8 R, Cr or B
// Bit  7: 0 R, Output Alpha[8:1]
#define VIU2_OSD1_TEST_RDDATA                      ((0x1e2c  << 2) + 0xd0100000)
// Bit    15 RW, prot_en: 1=Borrow PROT's FIFO storage, either for rotate or non-rotate.
// Bit 12: 0 RW, effective FIFO size when prot_en=1.
#define VIU2_OSD1_PROT_CTRL                        ((0x1e2e  << 2) + 0xd0100000)
//------------------------------------------------------------------------------
// OSD2 registers
//------------------------------------------------------------------------------
// Bit    31 Reserved
// Bit    30 RW, enable_free_clk: 1=use free-running clock to drive logics;
//                                0=use gated clock for low power.
// Bit    29 R, test_rd_dsr
// Bit    28 R, osd_done
// Bit 27:24 R, osd_blk_mode
// Bit 23:22 R, osd_blk_ptr
// Bit    21 R, osd_enable
//
// Bit 20:12 RW, global_alpha
// Bit    11 RW, test_rd_en
// Bit    10 RW, hl2_en
// Bit     9 RW, hl1_en
// Bit  8: 5 RW, ctrl_mtch_y
// Bit     4 RW, ctrl_422to444
// Bit  3: 0 RW, osd_blk_enable. Bit 0 to enable block 0: 1=enable, 0=disable;
//                               Bit 1 to enable block 1, and so on.
#define VIU2_OSD2_CTRL_STAT                        ((0x1e30  << 2) + 0xd0100000)
// Bit 31:26 Reserved
// Bit 25:16 R, fifo_count
// Bit 15: 6 Reserved
// Bit  5: 4 RW, hold_fifo_lines[6:5]
// Bit     3 RW, rgb2yuv_full_range
// Bit     2 RW, alpha_9b_mode
// Bit     1 RW, reserved
// Bit     0 RW, color_expand_mode
#define VIU2_OSD2_CTRL_STAT2                       ((0x1e4d  << 2) + 0xd0100000)
// Bit 31: 9 Reserved
// Bit     8 RW, 0 = Write LUT, 1 = Read LUT
// Bit  7: 0 RW, lut_addr
#define VIU2_OSD2_COLOR_ADDR                       ((0x1e31  << 2) + 0xd0100000)
// Bit 31:24 RW, Y or R
// Bit 23:16 RW, Cb or G
// Bit 15: 8 RW, Cr or B
// Bit  7: 0 RW, Alpha
#define VIU2_OSD2_COLOR                            ((0x1e32  << 2) + 0xd0100000)
// Bit 31:28 Reserved
// Bit 27:16 RW, hl[1-2]_h/v_start
// Bit 15:12 Reserved
// Bit 11: 0 RW, hl[1-2]_h/v_end
#define VIU2_OSD2_HL1_H_START_END                  ((0x1e33  << 2) + 0xd0100000)
#define VIU2_OSD2_HL1_V_START_END                  ((0x1e34  << 2) + 0xd0100000)
#define VIU2_OSD2_HL2_H_START_END                  ((0x1e35  << 2) + 0xd0100000)
#define VIU2_OSD2_HL2_V_START_END                  ((0x1e36  << 2) + 0xd0100000)
// Bit 31:24 RW, Y or R
// Bit 23:16 RW, Cb or G
// Bit 15: 8 RW, Cr or B
// Bit  7: 0 RW, Alpha
#define VIU2_OSD2_TCOLOR_AG0                       ((0x1e37  << 2) + 0xd0100000)
#define VIU2_OSD2_TCOLOR_AG1                       ((0x1e38  << 2) + 0xd0100000)
#define VIU2_OSD2_TCOLOR_AG2                       ((0x1e39  << 2) + 0xd0100000)
#define VIU2_OSD2_TCOLOR_AG3                       ((0x1e3a  << 2) + 0xd0100000)
// Bit 31:24 Reserved
// Bit 23:16 RW, tbl_addr
// Bit    15 RW, little_endian: 0=big endian, 1=little endian
// Bit    14 RW, rpt_y
// Bit 13:12 RW, interp_ctrl. 0x=No interpolation; 10=Interpolate with previous
//                            pixel; 11=Interpolate with the average value
//                            between previous and next pixel.
// Bit 11: 8 RW, osd_blk_mode
// Bit     7 RW, rgb_en
// Bit     6 RW, tc_alpha_en
// Bit  5: 2 RW, color_matrix
// Bit     1 RW, interlace_en
// Bit     0 RW, interlace_sel_odd
#define VIU2_OSD2_BLK0_CFG_W0                      ((0x1e3b  << 2) + 0xd0100000)
#define VIU2_OSD2_BLK1_CFG_W0                      ((0x1e3f  << 2) + 0xd0100000)
#define VIU2_OSD2_BLK2_CFG_W0                      ((0x1e43  << 2) + 0xd0100000)
#define VIU2_OSD2_BLK3_CFG_W0                      ((0x1e47  << 2) + 0xd0100000)
// Bit 31:29 Reserved
// Bit 28:16 RW, x_end
// Bit 15:13 Reserved
// Bit 12: 0 RW, x_start
#define VIU2_OSD2_BLK0_CFG_W1                      ((0x1e3c  << 2) + 0xd0100000)
#define VIU2_OSD2_BLK1_CFG_W1                      ((0x1e40  << 2) + 0xd0100000)
#define VIU2_OSD2_BLK2_CFG_W1                      ((0x1e44  << 2) + 0xd0100000)
#define VIU2_OSD2_BLK3_CFG_W1                      ((0x1e48  << 2) + 0xd0100000)
// Bit 31:29 Reserved
// Bit 28:16 RW, y_end
// Bit 15:13 Reserved
// Bit 12: 0 RW, y_start
#define VIU2_OSD2_BLK0_CFG_W2                      ((0x1e3d  << 2) + 0xd0100000)
#define VIU2_OSD2_BLK1_CFG_W2                      ((0x1e41  << 2) + 0xd0100000)
#define VIU2_OSD2_BLK2_CFG_W2                      ((0x1e45  << 2) + 0xd0100000)
#define VIU2_OSD2_BLK3_CFG_W2                      ((0x1e49  << 2) + 0xd0100000)
// Bit 31:28 Reserved
// Bit 27:16 RW, h_end
// Bit 15:12 Reserved
// Bit 11: 0 RW, h_start
#define VIU2_OSD2_BLK0_CFG_W3                      ((0x1e3e  << 2) + 0xd0100000)
#define VIU2_OSD2_BLK1_CFG_W3                      ((0x1e42  << 2) + 0xd0100000)
#define VIU2_OSD2_BLK2_CFG_W3                      ((0x1e46  << 2) + 0xd0100000)
#define VIU2_OSD2_BLK3_CFG_W3                      ((0x1e4a  << 2) + 0xd0100000)
// Bit 31:28 Reserved
// Bit 27:16 RW, v_end
// Bit 15:12 Reserved
// Bit 11: 0 RW, v_start
#define VIU2_OSD2_BLK0_CFG_W4                      ((0x1e64  << 2) + 0xd0100000)
#define VIU2_OSD2_BLK1_CFG_W4                      ((0x1e65  << 2) + 0xd0100000)
#define VIU2_OSD2_BLK2_CFG_W4                      ((0x1e66  << 2) + 0xd0100000)
#define VIU2_OSD2_BLK3_CFG_W4                      ((0x1e67  << 2) + 0xd0100000)
// Bit    31 RW, burst_len_sel[2] of [2:0]
// Bit    30 RW, byte_swap: In addition to endian control, further define
//               whether to swap upper and lower byte within a 16-bit mem word.
//               0=No swap; 1=Swap data[15:0] to be {data[7:0], data[15:8]}
// Bit 29:22 R,  Reserved
// Bit 21:20 R,  fifo_st. 0=IDLE, 1=FILL, 2=ABORT 
// Bit    19 R,  fifo_overflow
//
// Bit 18:12 RW, fifo_depth_val, max value=64: set actual fifo depth to fifo_depth_val*8.
// Bit 11:10 RW, burst_len_sel[1:0] of [2:0]. 0=24(default), 1=32, 2=48, 3=64, 4=96, 5=128.
// Bit  9: 5 RW, hold_fifo_lines[4:0]
// Bit     4 RW, clear_err: one pulse to clear fifo_overflow
// Bit     3 RW, fifo_sync_rst
// Bit  2: 1 RW, endian
// Bit     0 RW, urgent
#define VIU2_OSD2_FIFO_CTRL_STAT                   ((0x1e4b  << 2) + 0xd0100000)
// Bit 31:24 R, Y or R
// Bit 23:16 R, Cb or G
// Bit 15: 8 R, Cr or B
// Bit  7: 0 R, Output Alpha[8:1]
#define VIU2_OSD2_TEST_RDDATA                      ((0x1e4c  << 2) + 0xd0100000)
// Bit    15 RW, prot_en: 1=Borrow PROT's FIFO storage, either for rotate or non-rotate.
// Bit 12: 0 RW, effective FIFO size when prot_en=1.
#define VIU2_OSD2_PROT_CTRL                        ((0x1e4e  << 2) + 0xd0100000)
//------------------------------------------------------------------------------
// VD1 path
//------------------------------------------------------------------------------
#define VIU2_VD1_IF0_GEN_REG                       ((0x1e50  << 2) + 0xd0100000)
#define VIU2_VD1_IF0_CANVAS0                       ((0x1e51  << 2) + 0xd0100000)
#define VIU2_VD1_IF0_CANVAS1                       ((0x1e52  << 2) + 0xd0100000)
#define VIU2_VD1_IF0_LUMA_X0                       ((0x1e53  << 2) + 0xd0100000)
#define VIU2_VD1_IF0_LUMA_Y0                       ((0x1e54  << 2) + 0xd0100000)
#define VIU2_VD1_IF0_CHROMA_X0                     ((0x1e55  << 2) + 0xd0100000)
#define VIU2_VD1_IF0_CHROMA_Y0                     ((0x1e56  << 2) + 0xd0100000)
#define VIU2_VD1_IF0_LUMA_X1                       ((0x1e57  << 2) + 0xd0100000)
#define VIU2_VD1_IF0_LUMA_Y1                       ((0x1e58  << 2) + 0xd0100000)
#define VIU2_VD1_IF0_CHROMA_X1                     ((0x1e59  << 2) + 0xd0100000)
#define VIU2_VD1_IF0_CHROMA_Y1                     ((0x1e5a  << 2) + 0xd0100000)
#define VIU2_VD1_IF0_RPT_LOOP                      ((0x1e5b  << 2) + 0xd0100000)
#define VIU2_VD1_IF0_LUMA0_RPT_PAT                 ((0x1e5c  << 2) + 0xd0100000)
#define VIU2_VD1_IF0_CHROMA0_RPT_PAT               ((0x1e5d  << 2) + 0xd0100000)
#define VIU2_VD1_IF0_LUMA1_RPT_PAT                 ((0x1e5e  << 2) + 0xd0100000)
#define VIU2_VD1_IF0_CHROMA1_RPT_PAT               ((0x1e5f  << 2) + 0xd0100000)
#define VIU2_VD1_IF0_LUMA_PSEL                     ((0x1e60  << 2) + 0xd0100000)
#define VIU2_VD1_IF0_CHROMA_PSEL                   ((0x1e61  << 2) + 0xd0100000)
#define VIU2_VD1_IF0_DUMMY_PIXEL                   ((0x1e62  << 2) + 0xd0100000)
#define VIU2_VD1_IF0_LUMA_FIFO_SIZE                ((0x1e63  << 2) + 0xd0100000)
#define VIU2_VD1_IF0_RANGE_MAP_Y                   ((0x1e6a  << 2) + 0xd0100000)
#define VIU2_VD1_IF0_RANGE_MAP_CB                  ((0x1e6b  << 2) + 0xd0100000)
#define VIU2_VD1_IF0_RANGE_MAP_CR                  ((0x1e6c  << 2) + 0xd0100000)
#define VIU2_VD1_IF0_GEN_REG2                      ((0x1e6d  << 2) + 0xd0100000)
#define VIU2_VD1_IF0_PROT_CNTL                     ((0x1e6e  << 2) + 0xd0100000)
//Bit 31    it true, disable clock, otherwise enable clock
//Bit 30    soft rst bit
//Bit 28    if true, horizontal formatter use repeating to generete pixel, otherwise use bilinear interpolation
//Bit 27:24 horizontal formatter initial phase
//Bit 23    horizontal formatter repeat pixel 0 enable
//Bit 22:21 horizontal Y/C ratio, 00: 1:1, 01: 2:1, 10: 4:1
//Bit 20    horizontal formatter enable
//Bit 19    if true, always use phase0 while vertical formater, meaning always
//          repeat data, no interpolation
//Bit 18    if true, disable vertical formatter chroma repeat last line
//Bit 17    veritcal formatter dont need repeat line on phase0, 1: enable, 0: disable
//Bit 16    veritcal formatter repeat line 0 enable
//Bit 15:12 vertical formatter skip line num at the beginning
//Bit 11:8  vertical formatter initial phase
//Bit 7:1   vertical formatter phase step (3.4)  
//Bit 0     vertical formatter enable
#define VIU2_VD1_FMT_CTRL                          ((0x1e68  << 2) + 0xd0100000)
//Bit 27:16  horizontal formatter width
//Bit 11:0   vertical formatter width
#define VIU2_VD1_FMT_W                             ((0x1e69  << 2) + 0xd0100000)
// synopsys translate_off
// synopsys translate_on
//
// Closing file:  v2regs.h
//
//======================================================================
//   vpu  register.
//======================================================================
// -----------------------------------------------
// CBUS_BASE:  VPU_VCBUS_BASE = 0x27
// -----------------------------------------------
#define VPU_OSD1_MMC_CTRL                          ((0x2701  << 2) + 0xd0100000)
#define VPU_OSD2_MMC_CTRL                          ((0x2702  << 2) + 0xd0100000)
#define VPU_VD1_MMC_CTRL                           ((0x2703  << 2) + 0xd0100000)
#define VPU_VD2_MMC_CTRL                           ((0x2704  << 2) + 0xd0100000)
#define VPU_DI_IF1_MMC_CTRL                        ((0x2705  << 2) + 0xd0100000)
#define VPU_DI_MEM_MMC_CTRL                        ((0x2706  << 2) + 0xd0100000)
#define VPU_DI_INP_MMC_CTRL                        ((0x2707  << 2) + 0xd0100000)
#define VPU_DI_MTNRD_MMC_CTRL                      ((0x2708  << 2) + 0xd0100000)
#define VPU_DI_CHAN2_MMC_CTRL                      ((0x2709  << 2) + 0xd0100000)
#define VPU_DI_MTNWR_MMC_CTRL                      ((0x270a  << 2) + 0xd0100000)
#define VPU_DI_NRWR_MMC_CTRL                       ((0x270b  << 2) + 0xd0100000)
#define VPU_DI_DIWR_MMC_CTRL                       ((0x270c  << 2) + 0xd0100000)
#define VPU_VDIN0_MMC_CTRL                         ((0x270d  << 2) + 0xd0100000)
#define VPU_VDIN1_MMC_CTRL                         ((0x270e  << 2) + 0xd0100000)
#define VPU_BT656_MMC_CTRL                         ((0x270f  << 2) + 0xd0100000)
#define VPU_TVD3D_MMC_CTRL                         ((0x2710  << 2) + 0xd0100000)
#define VPU_TVDVBI_MMC_CTRL                        ((0x2711  << 2) + 0xd0100000)
//Read only
//`define     VPU_TVDVBI_VSLATCH_ADDR   8'h12
//Read only
//`define     VPU_TVDVBI_WRRSP_ADDR 8'h13
#define VPU_VDIN_PRE_ARB_CTRL                      ((0x2714  << 2) + 0xd0100000)
#define VPU_VDISP_PRE_ARB_CTRL                     ((0x2715  << 2) + 0xd0100000)
#define VPU_VPUARB2_PRE_ARB_CTRL                   ((0x2716  << 2) + 0xd0100000)
#define VPU_OSD3_MMC_CTRL                          ((0x2717  << 2) + 0xd0100000)
#define VPU_OSD4_MMC_CTRL                          ((0x2718  << 2) + 0xd0100000)
#define VPU_VD3_MMC_CTRL                           ((0x2719  << 2) + 0xd0100000)
// [31:11] Reserved.
// [10: 8] cntl_viu_vdin_sel_data. Select VIU to VDIN data path, must clear it first before changing the path selection:
//          3'b000=Disable VIU to VDIN path;
//          3'b001=Enable VIU of ENC_I domain to VDIN;
//          3'b010=Enable VIU of ENC_P domain to VDIN;
//          3'b100=Enable VIU of ENC_T domain to VDIN;
// [ 6: 4] cntl_viu_vdin_sel_clk. Select which clock to VDIN path, must clear it first before changing the clock:
//          3'b000=Disable VIU to VDIN clock;
//          3'b001=Select encI clock to VDIN;
//          3'b010=Select encP clock to VDIN;
//          3'b100=Select encT clock to VDIN;
// [ 3: 2] cntl_viu2_sel_venc. Select which one of the encI/P/T that VIU2 connects to:
//         0=No connection, 1=ENCI, 2=ENCP, 3=ENCT.
// [ 1: 0] cntl_viu1_sel_venc. Select which one of the encI/P/T that VIU1 connects to:
//         0=No connection, 1=ENCI, 2=ENCP, 3=ENCT.
#define VPU_VIU_VENC_MUX_CTRL                      ((0x271a  << 2) + 0xd0100000)
// [15:12] rd_rate. 0=A read every clk2; 1=A read every 2 clk2; ...; 15=A read every 16 clk2.
// [11: 8] wr_rate. 0=A write every clk1; 1=A write every 2 clk1; ...; 15=A write every 16 clk1.
// [ 7: 5] data_comp_map. Input data is CrYCb(BRG), map the output data to desired format:
//                          0=output CrYCb(BRG);
//                          1=output YCbCr(RGB);
//                          2=output YCrCb(RBG);
//                          3=output CbCrY(GBR);
//                          4=output CbYCr(GRB);
//                          5=output CrCbY(BGR);
//                          6,7=Rsrv.
// [    4] inv_dvi_clk. 1=Invert clock to external DVI, (clock invertion exists at internal HDMI).
// [    3] inv_vsync. 1=Invert Vsync polarity.
// [    2] inv_hsync. 1=Invert Hsync polarity.
// [ 1: 0] src_sel. 0=Disable output to HDMI; 1=Select VENC_I output to HDMI; 2=Select VENC_P output.
#define VPU_HDMI_SETTING                           ((0x271b  << 2) + 0xd0100000)
#define ENCI_INFO_READ                             ((0x271c  << 2) + 0xd0100000)
#define ENCP_INFO_READ                             ((0x271d  << 2) + 0xd0100000)
#define ENCT_INFO_READ                             ((0x271e  << 2) + 0xd0100000)
#define ENCL_INFO_READ                             ((0x271f  << 2) + 0xd0100000)
// Bit  0 RW, viu_rst_n
// Bit  1 RW, vdin_mmc_arb_rst_n
// Bit  2 RW, vdisp_mmc_arb_rst_n
// Bit  3 RW, vpuarb2_mmc_arb_rst_n
#define VPU_SW_RESET                               ((0x2720  << 2) + 0xd0100000)
//Bit 30     d2d3_depr_req_sel,  0:vdisp_pre_arb, 1: vpuarb2_pre_arb
//Bit 27:22  d2d3_depr_brst_num
//Bit 21:16  d2d3_depr_id
//Bit 14     d2d3_depw_req_sel, 0: vdin_pre_arb, 1: vdisp_pre_arb
//Bit 11:6   d2d3_depw_brst_num
//Bit 5:0    d2d3_depw_id
#define VPU_D2D3_MMC_CTRL                          ((0x2721  << 2) + 0xd0100000)
//Bit 30     mtn_contrd_req_pre,  0:disp1_arb, 1: vdin_pre_arb
//Bit 27:22  mtn_contrd_brst_num
//Bit 21:16  mtn_contrd_id
//Bit 14     mtn_contwr_req_pre, 0: vdisp1_arb, 1: vdin_pre_arb
//Bit 11:6   mtn_contwr_brst_num
//Bit 5:0    mtn_contwr_id
#define VPU_CONT_MMC_CTRL                          ((0x2722  << 2) + 0xd0100000)
// Bit  6 RW, gclk_mpeg_vpu_misc
// Bit  5 RW, gclk_mpeg_venc_l_top
// Bit  4 RW, gclk_mpeg_vencl_int
// Bit  3 RW, gclk_mpeg_vencp_int
// Bit  2 RW, gclk_mpeg_vi2_top
// Bit  1 RW, gclk_mpeg_vi_top
// Bit  0 RW, gclk_mpeg_venc_p_top
#define VPU_CLK_GATE                               ((0x2723  << 2) + 0xd0100000)
//Bit    12 RW, rdma_pre
//Bit 11: 6 RW, rdma_num
//Bit  5: 0 RW, rdma_id
#define VPU_RDMA_MMC_CTRL                          ((0x2724  << 2) + 0xd0100000)
#define VPU_MEM_PD_REG0                            ((0x2725  << 2) + 0xd0100000)
#define VPU_MEM_PD_REG1                            ((0x2726  << 2) + 0xd0100000)
// [   31] hdmi_data_ovr_en: 1=Enable overriding data input to HDMI TX with hdmi_data_ovr[29:0]. 0=No override. Default 0.
// [   30] Reserved.                                                                                            Default 0
// [29: 0] hdmi_data_ovr.                                                                                       Default 0.
#define VPU_HDMI_DATA_OVR                          ((0x2727  << 2) + 0xd0100000)
//Bit    15 RW, prot1_sel_osd4
//Bit    14 RW, prot1_sel_osd3
//Bit    13 RW, prot1_sel_osd2
//Bit    12 RW, prot1_sel_osd1
//Bit 11: 6 RW, prot1_brst_num
//Bit  5: 0 RW, prot1_id
#define VPU_PROT1_MMC_CTRL                         ((0x2728  << 2) + 0xd0100000)
//Bit    14 RW, prot2_sel_vd3
//Bit    13 RW, prot2_sel_vd2
//Bit    12 RW, prot2_sel_vd1
//Bit 11: 6 RW, prot2_brst_num
//Bit  5: 0 RW, prot2_id
#define VPU_PROT2_MMC_CTRL                         ((0x2729  << 2) + 0xd0100000)
//Bit    14 RW, prot3_sel_vd3
//Bit    13 RW, prot3_sel_vd2
//Bit    12 RW, prot3_sel_vd1
//Bit 11: 6 RW, prot3_brst_num
//Bit  5: 0 RW, prot3_id
#define VPU_PROT3_MMC_CTRL                         ((0x272a  << 2) + 0xd0100000)
//Bit 29:24 RW, s3_brst_num
//Bit 21:16 RW, s2_brst_num
//Bit 13: 8 RW, s1_brst_num
//Bit  5: 0 RW, s0_brst_num
#define VPU_ARB4_V1_MMC_CTRL                       ((0x272b  << 2) + 0xd0100000)
//Bit 29:24 RW, s3_brst_num
//Bit 21:16 RW, s2_brst_num
//Bit 13: 8 RW, s1_brst_num
//Bit  5: 0 RW, s0_brst_num
#define VPU_ARB4_V2_MMC_CTRL                       ((0x272c  << 2) + 0xd0100000)
//Bit 27:22 RW, mcvecwr_num
//Bit 21:16 RW, mcvecwr_id
//Bit 11:6  RW, mcvecrd_num
//Bit 5:0   RW, mcvecrd_id
#define VPU_MCVEC_MMC_CTRL                         ((0x272d  << 2) + 0xd0100000)
//Bit 27:22 RW, mcinfwr_num
//Bit 21:16 RW, mcinfwr_id
//Bit 11:6  RW, mcinfrd_num
//Bit 5:0   RW, mcinfrd_id
#define VPU_MCINF_MMC_CTRL                         ((0x272e  << 2) + 0xd0100000)
//Bit 31    reg_vpu_pwm_inv, 1: invert the pwm signal, active low
//Bit 30:29 reg_vpu_pwm_src_sel, 00: encl, enct, encp
//Bit 28:16 reg_vpu_pwm_v_end0 
//Bit 12:0  reg_vpu_pwm_v_start0 
#define VPU_VPU_PWM_V0                             ((0x2730  << 2) + 0xd0100000)
//Bit 28:16 reg_vpu_pwm_v_end1 
//Bit 12:0  reg_vpu_pwm_v_start1 
#define VPU_VPU_PWM_V1                             ((0x2731  << 2) + 0xd0100000)
//Bit 28:16 reg_vpu_pwm_v_end2 
//Bit 12:0  reg_vpu_pwm_v_start2 
#define VPU_VPU_PWM_V2                             ((0x2732  << 2) + 0xd0100000)
//Bit 28:16 reg_vpu_pwm_v_end3 
//Bit 12:0  reg_vpu_pwm_v_start3 
#define VPU_VPU_PWM_V3                             ((0x2733  << 2) + 0xd0100000)
//Bit 28:16 reg_vpu_pwm_h_end0 
//Bit 12:0  reg_vpu_pwm_h_start0 
#define VPU_VPU_PWM_H0                             ((0x2734  << 2) + 0xd0100000)
//Bit 28:16 reg_vpu_pwm_h_end1 
//Bit 12:0  reg_vpu_pwm_h_start1 
#define VPU_VPU_PWM_H1                             ((0x2735  << 2) + 0xd0100000)
//Bit 28:16 reg_vpu_pwm_h_end2 
//Bit 12:0  reg_vpu_pwm_h_start2 
#define VPU_VPU_PWM_H2                             ((0x2736  << 2) + 0xd0100000)
//Bit 28:16 reg_vpu_pwm_h_end3 
//Bit 12:0  reg_vpu_pwm_h_start3 
#define VPU_VPU_PWM_H3                             ((0x2737  << 2) + 0xd0100000)
//Bit 18   reg_vpu_3d_go_high_fld_pol: 0: go high at field 0, 1: go high at field 1
//Bit 17   reg_vpu_3d_sync_setting_vsync_latch
//Bit 16   reg_vpu_3d_sync_enable
//Bit 14:8 reg_vpu_3d_sync_v_end   
//Bit 6:0  reg_vpu_3d_sync_v_start 
#define VPU_VPU_3D_SYNC1                           ((0x2738  << 2) + 0xd0100000)
//Bit 28:16 reg_vpu_3d_sync_h_end   
//Bit 12:0  reg_vpu_3d_sync_h_start 
#define VPU_VPU_3D_SYNC2                           ((0x2739  << 2) + 0xd0100000)
//Bit 4    csi2_pre, 1: using vpu pre arbiter0, 0: using vpu pre arbiter2
//Bit 2:1  isp_in_sel, 01: select bt656, 10: select Mipi CSI2, otherwise select nothing  
//Bit 0,   if true, force vencl clk enable, otherwise, it might auto turn off by mipi DSI 
#define VPU_MISC_CTRL                              ((0x2740  << 2) + 0xd0100000)
#define VPU_ISP_GCLK_CTRL0                         ((0x2741  << 2) + 0xd0100000)
#define VPU_ISP_GCLK_CTRL1                         ((0x2742  << 2) + 0xd0100000)
#define VPU_HDMI_FMT_CTRL                          ((0x2743  << 2) + 0xd0100000)
#define VPU_VDIN_ASYNC_HOLD_CTRL                   ((0x2744  << 2) + 0xd0100000)
#define VPU_VDISP_ASYNC_HOLD_CTRL                  ((0x2745  << 2) + 0xd0100000)
#define VPU_VPUARB2_ASYNC_HOLD_CTRL                ((0x2746  << 2) + 0xd0100000)
//    vdin_urg_ctrl_o <=  vpp_off_urg_ctrl &  vpu_arb_urg_ctrl[0] |
//                        vdin0_lff_urg_ctrl & vpu_arb_urg_ctrl[1] | 
//                        vdin1_lff_urg_ctrl & vpu_arb_urg_ctrl[2];
//
//    vdisp_urg_ctrl_o <= vpp_off_urg_ctrl &  vpu_arb_urg_ctrl[3] |
//                        vdin0_lff_urg_ctrl & vpu_arb_urg_ctrl[4] | 
//                        vdin1_lff_urg_ctrl & vpu_arb_urg_ctrl[5];
//
//    vpuarb2_urg_ctrl_o <= vpp_off_urg_ctrl &  vpu_arb_urg_ctrl[6] |
//                          vdin0_lff_urg_ctrl & vpu_arb_urg_ctrl[7] | 
//                          vdin1_lff_urg_ctrl & vpu_arb_urg_ctrl[8];
#define VPU_ARB_URG_CTRL                           ((0x2747  << 2) + 0xd0100000)
// Picture Rotate (PROT) module 1 (for OSD) registers:
#define VPU_PROT1_CLK_GATE                         ((0x2750  << 2) + 0xd0100000)
#define VPU_PROT1_GEN_CNTL                         ((0x2751  << 2) + 0xd0100000)
#define VPU_PROT1_X_START_END                      ((0x2752  << 2) + 0xd0100000)
#define VPU_PROT1_Y_START_END                      ((0x2753  << 2) + 0xd0100000)
#define VPU_PROT1_Y_LEN_STEP                       ((0x2754  << 2) + 0xd0100000)
#define VPU_PROT1_RPT_LOOP                         ((0x2755  << 2) + 0xd0100000)
#define VPU_PROT1_RPT_PAT                          ((0x2756  << 2) + 0xd0100000)
#define VPU_PROT1_DDR                              ((0x2757  << 2) + 0xd0100000)
#define VPU_PROT1_RBUF_ROOM                        ((0x2758  << 2) + 0xd0100000)
#define VPU_PROT1_STAT_0                           ((0x2759  << 2) + 0xd0100000)
#define VPU_PROT1_STAT_1                           ((0x275a  << 2) + 0xd0100000)
#define VPU_PROT1_STAT_2                           ((0x275b  << 2) + 0xd0100000)
#define VPU_PROT1_REQ_ONOFF                        ((0x275c  << 2) + 0xd0100000)
// Picture Rotate (PROT) module 2 (for VD) registers:
#define VPU_PROT2_CLK_GATE                         ((0x2760  << 2) + 0xd0100000)
#define VPU_PROT2_GEN_CNTL                         ((0x2761  << 2) + 0xd0100000)
#define VPU_PROT2_X_START_END                      ((0x2762  << 2) + 0xd0100000)
#define VPU_PROT2_Y_START_END                      ((0x2763  << 2) + 0xd0100000)
#define VPU_PROT2_Y_LEN_STEP                       ((0x2764  << 2) + 0xd0100000)
#define VPU_PROT2_RPT_LOOP                         ((0x2765  << 2) + 0xd0100000)
#define VPU_PROT2_RPT_PAT                          ((0x2766  << 2) + 0xd0100000)
#define VPU_PROT2_DDR                              ((0x2767  << 2) + 0xd0100000)
#define VPU_PROT2_RBUF_ROOM                        ((0x2768  << 2) + 0xd0100000)
#define VPU_PROT2_STAT_0                           ((0x2769  << 2) + 0xd0100000)
#define VPU_PROT2_STAT_1                           ((0x276a  << 2) + 0xd0100000)
#define VPU_PROT2_STAT_2                           ((0x276b  << 2) + 0xd0100000)
#define VPU_PROT2_REQ_ONOFF                        ((0x276c  << 2) + 0xd0100000)
// Picture Rotate (PROT) module 3 (for VD) registers:
#define VPU_PROT3_CLK_GATE                         ((0x2770  << 2) + 0xd0100000)
#define VPU_PROT3_GEN_CNTL                         ((0x2771  << 2) + 0xd0100000)
#define VPU_PROT3_X_START_END                      ((0x2772  << 2) + 0xd0100000)
#define VPU_PROT3_Y_START_END                      ((0x2773  << 2) + 0xd0100000)
#define VPU_PROT3_Y_LEN_STEP                       ((0x2774  << 2) + 0xd0100000)
#define VPU_PROT3_RPT_LOOP                         ((0x2775  << 2) + 0xd0100000)
#define VPU_PROT3_RPT_PAT                          ((0x2776  << 2) + 0xd0100000)
#define VPU_PROT3_DDR                              ((0x2777  << 2) + 0xd0100000)
#define VPU_PROT3_RBUF_ROOM                        ((0x2778  << 2) + 0xd0100000)
#define VPU_PROT3_STAT_0                           ((0x2779  << 2) + 0xd0100000)
#define VPU_PROT3_STAT_1                           ((0x277a  << 2) + 0xd0100000)
#define VPU_PROT3_STAT_2                           ((0x277b  << 2) + 0xd0100000)
#define VPU_PROT3_REQ_ONOFF                        ((0x277c  << 2) + 0xd0100000)
//========================================================================
//  MIPI CSI2 Controller Adaptor    (16'h2a00 - 16'h2aff)
//
//========================================================================
//`define  CSI2_VCBUS_BASE            8'h2a
//`include "csi2_regs.h"
//======================================================================
// D2D3 registers 
//======================================================================
//`define     D2D3_VCBUS_BASE         8'h2b
//
// Reading file:  d2d3_regs.h
//
//===========================================================================
// D2D3 Registers    0x - 0x
//===========================================================================
// -----------------------------------------------
// CBUS_BASE:  D2D3_VCBUS_BASE = 0x2b
// -----------------------------------------------
//------------------------------------------------------------------------------
// D2D3 top-level registers
//------------------------------------------------------------------------------
// Bit 31    RW, rd_lock_en,     1 to allow update some read-only registers based on filed
// Bit 30    RW, sw_rst_nobuf,   1 to reset the whole d2d3 unit
// Bit 29:28 RW, clk_auto_dis,   [29] DBR clock disable
//                               [28] DPG clock disable
// Bit 27:16 RW, clk_ctrl,       [27:26] gated clock control for register unit 
//                               [25:24] gated clock control for DBR unit
//                               [23:22] gated clock control for LBDG unit
//                               [21:20] gated clock control for MBDG unit
//                               [19:18] gated clock control for CBDG unit
//                               [17:16] gated clock control for DBLD unit and SCD81 unit
// Bit 15:12 Reserved  
// Bit 11    RW, lo_chroma_sign, 0: negate the u/v component of DBR left channel video output, 1: bypass
// Bit 10    RW, ro_chroma_sign, 0: negate the u/v component of DBR right channel video output, 1: bypass
// Bit 9     RW, vi0_chroma_sign, 0: negate the u/v component of DPG video input, 1: bypass   
// Bit 8     RW, vi1_chroma_sign, 0: negate the u/v component of DBR video input, 1: bypass
// Bit 7:5   Reserved 
// Bit 4     RW, lg_en,          Enable the LBDG unit and LBDG clock        
// Bit 3     RW, mg_en,          Enable the MBDG unit and MBDG clock
// Bit 2     RW, cg_en,          Enable the CBDG unit and CBDG clock
// Bit 1     RW, dbr_en,         Enable the DBR unit and DBR clock
// Bit 0     RW, dpg_en,         Enable the DPG unit and clock except sub-unit CBDG, MBDG and LBDG
#define D2D3_GLB_CTRL                              ((0x2b00  << 2) + 0xd0100000)
// Indicate the input picture size in DPG unit
// Bit 31:16 RW, szx_vi_m1,      The horizontal size minus 1
// Bit 15:0  RW, szy_vi_m1,      The vertical size minus 1
#define D2D3_DPG_INPIC_SIZE                        ((0x2b01  << 2) + 0xd0100000)
// Indicate the output picture size in DBR unit
// Bit 31:16 RW, szx_vo_m1,      The horizontal size minus 1
// Bit 15:0  RW, szy_vo_m1,      The vertical size minus 1
#define D2D3_DBR_OUTPIC_SIZE                       ((0x2b02  << 2) + 0xd0100000)
// Indicate the rectangular window to generate the "depth" in DPG unit 
// Bit 31:16 RW, dg_win_x_start, Horizontal start position, count from 0
// Bit 15:0  RW, dg_win_x_end,   Horizontal end position, count from 0
#define D2D3_DGEN_WIN_HOR                          ((0x2b03  << 2) + 0xd0100000)
// Indicate the rectangular window to generate the "depth" in DPG unit 
// Bit 31:16 RW, dg_win_y_start, Vertical start position, count from 0
// Bit 15:0  RW, dg_win_y_end,   Vertical end position, count from 0
#define D2D3_DGEN_WIN_VER                          ((0x2b04  << 2) + 0xd0100000)
//------------------------------------------------------------------------------
// CBDG SCU18 SCD81 SCD81_PRE registers
// cg: color based depth generate module
// scu18: scale up module
// scd81: scale down module
// scd81_pre: scd81 pre-scale-down module
//------------------------------------------------------------------------------
// Indicate parameters of pre-scale-down unit
// Bit 31:16 RW, scd81_hphs_step, horizontal step
// Bit 15:0  RW, scd81_hphs_ini, horizontal initial phase
#define D2D3_PRE_SCD_H                             ((0x2b05  << 2) + 0xd0100000)
// Bit 31:16 RW, scu18_iniph,    initial phase in SCU18, 
//                               [23:16] indicate the horizontal phase offset from the first data of every line
//                               [31:24] indicate the vertical phase offset from the first line of every frame
// Bit 15:12 Reserved
// Bit 11    RW, scd81_predrop_en, 1 to enable scd81 pre-scale-down function
// Bit 10:9  RW, cg_csc_sel,     Color Space Conversion(CSC) matrix mode selector in CBDG 
//                               0: BT.601 (16-235/240)
//                               1: BT.709 (16-235/240)
//                               2: BT.601 (0-255)
//                               3: BT.709 (0-255)
// Bit 8     RW, scu18_rep_en,   1 to double each line of the SCU18 output 
// Bit 7:4   RW, scu18_factor,   up-scale factor in SCU18 on DBR input depth data 
//                               [7:6] for vertical, 0->1:1, 1->1:2, 2->1:4, 3->1:8
//                               [5:4] for horizontal, 0->1:1, 1->1:2, 2->1:4, 3->1:8
// Bit 3:0   RW, scd81_factor,   down-scale factor in SCD81 on DPG source video 
//                               [3:2] for vertical, 0->1:1, 1->2:1, 2->4:1, 3->8:1
//                               [1:0] for horizontal, 0->1:1, 1->2:1, 2->4:1, 3->8:1
#define D2D3_SCALER_CTRL                           ((0x2b06  << 2) + 0xd0100000)
// Bit 31:24 RW, cg_rpg_dth,     the down |r-g| threshold for sky detect 
// Bit 23:16 RW, cg_rpg_uth,     the up |r-g| threshold for sky detect 
// Bit 15:8  RW, cg_lum_dth,     the down Y threshold for sky detect  
// Bit 7:0   RW, cg_lum_uth,     the up Y threshold for sky detect  
#define D2D3_CG_THRESHOLD_1                        ((0x2b07  << 2) + 0xd0100000)
// Bit 31:24 RW, cg_rpb_dth,     the down |r-b| threshold for sky detect
// Bit 23:16 RW, cg_rpb_uth,     the up |r-b| threshold for sky detect
// Bit 15:8  RW, cg_bpg_dth,     the down |b-g| threshold for sky detect
// Bit 7:0   RW, cg_bpg_uth,     the up |b-g| threshold for sky detect 
#define D2D3_CG_THRESHOLD_2                        ((0x2b08  << 2) + 0xd0100000)
// Bit 31:24 RW, cg_vp_rel_k,    parameter to calculate vanish point reliability
// Bit 23:16 RW, cg_vp_y_thr,    the max limitation to calculate the vanish-point's vertical position
// Bit 15:8  RW, cg_meet_dval,   signed depth value in the sky-bitmap 
// Bit 7:0   RW, cg_unmt_dval,   signed depth value not in the sky-bitmap
#define D2D3_CG_PARAM_1                            ((0x2b09  << 2) + 0xd0100000)
// Bit 31:16 RW, cg_vpos_thr,    Maximal vertical limitation for sky-bit map when cg_vpos_en=1 and cg_vpos_adpt_en=0
// Bit 15:8  Reserved
// Bit 7     RW, cg_vpos_en,     1 to enable the max vertical limitation for sky-bitmap
// Bit 6     RW, cg_vpos_adpt_en, 1 to enable the adaptive max vertical limitation for sky-bitmap. 
//                               It is only valid when cg_vpos_en=1.
//                               The max vertical limitation is the previous field's vanish-point (vertical position) if cg_vpos_adpt_en=1. 
// Bit 5:4   RW, cg_lpf_bypass,  bypass of low pass filter 
//                               [5]:Vertical bypass, 1: bypass the vertical LPF on the CBDG depth
//                               [4]:Horizontal bypass, 1: bypass the horizontal LPF on the CBDG depth
// Bit 3:0   RW, cg_vp_rel_s,    parameter to calculate vanish point reliability
#define D2D3_CG_PARAM_2                            ((0x2b0a  << 2) + 0xd0100000)
// Indicate parameters of pre-scale-down unit
// Bit 31:16 RW, scd81_vphs_step, vertical step
// Bit 15:0  RW, scd81_vphs_ini, vertical initial phase
#define D2D3_PRE_SCD_V                             ((0x2b0b  << 2) + 0xd0100000)
//------------------------------------------------------------------------------
// D2P registers
// d2p: depth to parallax transform module
//------------------------------------------------------------------------------
// Bit 31:24 RW, d2p_brdwid,     Horizontal boundary width for parallax, the parallax value would be forced to 0 in boundary, 
//                               the d2p_brdwid should not 0 when D2P_WRAP is enabled
// Bit 23:22 Reserved
// Bit 21:20 RW, d2p_lomode,     line output mode, 
//                               0:whole line is left or right;  1:whole line is left or right;
//                               2:left/right pixel interleaved;  3:left/right half-line interleaved
// Bit 19    RW, d2p_neg,        1 to exchange the left and right parallax value
// Bit 18    Reserved 
// Bit 17    RW, d2p_wrap_en,    1 to enable D2P_WRAP unit
// Bit 16    RW, d2p_lar,        Indicate the first output for left or right, 0: left; 1: right
// Bit 15    RW, d2p_lr_switch,  enable left/right flag filed switch automatically, only valid when parallax output mode is field interleaved
// Bit 14    RW, d2p_1dtolr,     enable to generate 2 parallax data (left and right) from one depth
// Bit 13:12 RW, d2p_out_mode,   Parallax output mode 
//                               0:left/right pixel interleaved; 1:line or half line interleaved; 2:field interleaved
// Bit 11:8  RW, d2p_smode,      Shift mode,
//                               0: no shift; 1: enable left shift;
//                               2: enable right shift; 3: both left and right shift are enabled
// Bit 7:0   RW, d2p_offset,     depth offset, signed, 
#define D2D3_D2P_PARAM_1                           ((0x2b0c  << 2) + 0xd0100000)
// Bit 31:24 RW, d2p_pg0,        positive parallax gain when Parallax value < pt
// Bit 23:16 RW, d2p_pg1,        positive parallax gain when Parallax value >= pt
// Bit 15:8  RW, d2p_pt,         unsigned value used to separate the positive parallax range
// Bit 7:0   RW, d2p_plimit,     The limitation for positive parallax
#define D2D3_D2P_PARAM_2                           ((0x2b0d  << 2) + 0xd0100000)
// Bit 31:24 RW, d2p_ng0,        negative parallax gain when Parallax value > -nt
// Bit 23:16 RW, d2p_ng1,        negative parallax gain when Parallax value <= -nt
// Bit 15:8  RW, d2p_nt,         unsigned value used to separate the negative parallax range
// Bit 7:0   RW, d2p_nlimit,     The limitation for negative parallax
#define D2D3_D2P_PARAM_3                           ((0x2b0e  << 2) + 0xd0100000)
// Indicate step parameters of SCU18 unit
// Bit 31:17 Reserved
// Bit 16    RW, scu18_step_en,   step set enable in SCU18
// Bit 15:8  RW, scu18_hphs_step, horizontal step in SCU18
// Bit 7:0   RW, scu18_vphs_step, vertical step in SCU18
#define D2D3_SCU18_STEP                            ((0x2b0f  << 2) + 0xd0100000)
//------------------------------------------------------------------------------
// LBDG and DBLD registers
// lg: luma based depth generate module
// db: depth blending module
//------------------------------------------------------------------------------
// Bit 31:22 Reserved
// Bit 21:20 RW, db_lpf_bpcoeff, [21]:Vertical factor of low pass filter, 
//                               1: Vfactor = 0/0/64/0/0, 0: Vfactor = {db_vf_a,db_vf_b,db_vf_c,db_vf_b,db_vf_a}, see D2D3_CTRL_15
//                               [20]:Horizontal factor of low pass filter, 
//                               1: Hfactor = 0/0/64/0/0, 0: Hfactor = {db_hf_a,db_hf_b,db_hf_c,db_hf_b,db_hf_a}, see D2D3_CTRL_14
// Bit 19:18 RW, lg_lpf_bpcoeff, [19]:Vertical factor of low pass filter, 1: Vfactor = 0/64/0, 0: Vfactor = 20/24/20
//                               [18]:Horizontal factor of low pass filter, 1: Hfactor = 0/64/0, 0: Hfactor = 16/32/16
// Bit 17:16 RW, cg_lpf_bpcoeff, [17]:Vertical factor of low pass filter, 1: Vfactor = 0/64/0, 0: Vfactor = 20/24/20
//                               [16]:Horizontal factor of low pass filter, 1: Hfactor = 0/64/0, 0: Hfactor = 16/32/16
// Bit 15:10 Reserved
// Bit 9:8   RW, db_lpf_bypass,  [9] 1 to bypass the vertical LPF on the DBLD depth
//                               [8] 1 to bypass the horizontal LPF on the DBLD depth
// Bit 7:6   RW, lg_lpf_bypass,  [7] 1 to bypass the vertical LPF on the LBDG depth
//                               [6] 1 to bypass the horizontal LPF on the LBDG depth
// Bit 5:0   RW, lg_kc,          gain of CPL(v-u+256-y) to calculate the depth in LBDG
#define D2D3_DPF_LPF_CTRL                          ((0x2b10  << 2) + 0xd0100000)
//------------------------------------------------------------------------------
// DBLD registers
// db: depth blending module
//------------------------------------------------------------------------------
// Bit 31:24 RW, db_g2_cg,       gain of CBDG depth in DBLD
// Bit 23:16 RW, db_o2_cg,       offset of CBDG depth in DBLD
// Bit 15:8  RW, db_g1_cg,       gain of CBDG depth using for summary in DBLD
// Bit 7:0   RW, db_o1_cg,       offset of CBDG depth using for summary in DBLD
#define D2D3_DBLD_CG_PARAM                         ((0x2b11  << 2) + 0xd0100000)
// Bit 31:24 RW, db_g2_mg,       gain of MBDG depth in DBLD
// Bit 23:16 RW, db_o2_mg,       offset of MBDG depth in DBLD
// Bit 15:8  RW, db_g1_mg,       gain of MBDG depth using for summary in DBLD
// Bit 7:0   RW, db_o1_mg,       offset of MBDG depth using for summary in DBLD
#define D2D3_DBLD_MG_PARAM                         ((0x2b12  << 2) + 0xd0100000)
// Bit 31:24 RW, db_g2_lg,       gain of LBDG depth in DBLD
// Bit 23:16 RW, db_o2_lg,       offset of LBDG depth in DBLD
// Bit 15:8  RW, db_g1_lg,       gain of LBDG depth using for summary in DBLD
// Bit 7:0   RW, db_o1_lg,       offset of LBDG depth using for summary in DBLD
#define D2D3_DBLD_LG_PARAM                         ((0x2b13  << 2) + 0xd0100000)
// Bit 31:24 RW, db_factor,      unsigned gain of difference in DBLD
// Bit 23:16 RW, db_hf_a,        see register DPF_LPF_CTRL:db_lpf_bpcoeff, sign
// Bit 15:8  RW, db_hf_b,        see register DPF_LPF_CTRL:db_lpf_bpcoeff, sign
// Bit 7:0   RW, db_hf_c,        see register DPF_LPF_CTRL:db_lpf_bpcoeff, sign
#define D2D3_DBLD_LPF_HCOEFF                       ((0x2b14  << 2) + 0xd0100000)
// Bit 31:24 RW, db_owin_fill,   signed depth value outside the rectangular window defined in register DGEN_WIN_HOR and DGEN_WIN_VER
// Bit 23:16 RW, db_vf_a,        see register DPF_LPF_CTRL:db_lpf_bpcoeff, sign
// Bit 15:8  RW, db_vf_b,        see register DPF_LPF_CTRL:db_lpf_bpcoeff, sign
// Bit 7:0   RW, db_vf_c,        see register DPF_LPF_CTRL:db_lpf_bpcoeff, sign
#define D2D3_DBLD_LPF_VCOEFF                       ((0x2b15  << 2) + 0xd0100000)
// Bit 31:28 RW, hist_depth_idx,     
// Bit 27:26 Reserved   
// Bit 25    RW, mbdg_dep_neg,   1 to negate the output data of MBDG
// Bit 24    RW, lbdg_dep_neg,   1 to negate the output data of LBDG
// Bit 23:16 RW, db_f1_ctrl,     MUX1 selector
//                               [1:0] MUX1 path1 selector, 0:summary, 1:CBDG, 2:MBDG, 3:LBDG
//                               [3:2] MUX1 path2 selector, 0:summary, 1:CBDG, 2:MBDG, 3:LBDG
//                               [6:4] MUX1 out1 selector, 1:CBDG, 2:MBDG, 3:LBDG, 4:summary, 5:MUX1out0, others:summary
//                               [7] MUX1OUT0 selector, 0:MIN (MUX1PATH1,MUX1Path2), 1:MAX (MUX1Path1,MUX1Path2)
// Bit 15:8  RW, db_f2_ctrl,     MUX2 selector
//                               [1:0] MUX2 path1 selector, 0:MUX1OUT1, 1:CBDG, 2:MBDG, 3:LBDG
//                               [3:2] MUX2 path2 selector, 0:MUX1OUT1, 1:CBDG, 2:MBDG, 3:LBDG
//                               [6:4] MUX2 out1 selector, 1:CBDG, 2:MBDG, 3:LBDG, 4:summary, 5:MUX2out0, others:MUX2out0
//                               [7] MUX2OUT0 selector, 0:MIN (MUX2PATH1,MUX2Path2), 1:MAX (MUX2Path1,MUX2Path2)
// Bit 7:4   RW, db_fifo0_sel,   the source input of FIFO0
//                               0: no use; 1:from CBDG; 2:from MBDG; 3:from LBDG others:reserved
// Bit 3:0   RW, db_fifo1_sel,   the source input of FIFO1
//                               0: no use; 1:from CBDG; 2:from MBDG; 3:from LBDG 4: from FIFO0; others:reserved
#define D2D3_DBLD_PATH_CTRL                        ((0x2b16  << 2) + 0xd0100000)
// Indicate the input picture size in SCU18 unit
// Bit 31:16 RW, szy_scui,       The vertical size 
// Bit 15:0  RW, szx_scui,       The horizontal size 
#define D2D3_SCU18_INPIC_SIZE                      ((0x2b17  << 2) + 0xd0100000)
//------------------------------------------------------------------------------
// MBDG registers
// mg: model based depth generate module
//------------------------------------------------------------------------------
// Bit 31:18 Reserved
// Bit 17    RW, mg_vp_en,       mdg vanish point enable, not used
// Bit 16    RW, mg_sw_en,       1 to use the software forced parameter for the point D, U and C in MBDG
// Bit 15:8  RW, mg_owin_fill,   Signed depth value outside the rectangular window defined in register DGEN_WIN_HOR and DGEN_WIN_VER
// Bit 7     RW, mg_iir_en,      1 to enable the 2-taps IIR filter in MBDG
// Bit 6:0   RW, mg_iir,         [6]: 1 to bypass the 2-taps IIR filter in MBDG
//                               [5:0]:Unsigned coefficient of the 2-taps IIR filter in MBDG
//                               [6]:bypass, 1:bypass, 0:not bypass
#define D2D3_MBDG_CTRL                             ((0x2b18  << 2) + 0xd0100000)
// Bit 31:28 RW, mg_dtl_pxl_left, Max pixel number (1<< mg_dtl_pxl_left) using in the left window for activities in MBDG
// Bit 27:24 RW, mg_dtl_pxl_right, Max pixel number (1<< mg_dtl_pxl_right) using in the right window for activities in MBDG
// Bit 23:16 RW, mg_cx_sw,       Depth of point C in horizontal curve in MBDG for software forced
// Bit 15:8  RW, mg_ux_sw,       Depth of point U in horizontal curve in MBDG for software forced
// Bit 7:0   RW, mg_dx_sw,       Depth of point D in horizontal curve in MBDG for software forced
#define D2D3_MBDG_PARAM_0                          ((0x2b19  << 2) + 0xd0100000)
// Bit 31:28 RW, mg_dtl_pxl_up,  Max pixel number (1<< mg_dtl_pxl_up) using in the top window for activities in MBDG
// Bit 27:24 RW, mg_dtl_pxl_dn,  Max pixel number (1<< mg_dtl_pxl_dn) using in the bottom window for activities in MBDG
// Bit 23:16 RW, mg_cy_sw,       Depth of point C in vertical curve in MBDG for software forced       
// Bit 15:8  RW, mg_uy_sw,       Depth of point U in vertical curve in MBDG for software forced
// Bit 7:0   RW, mg_dy_sw,       Depth of point D in vertical curve in MBDG for software forced
#define D2D3_MBDG_PARAM_1                          ((0x2b1a  << 2) + 0xd0100000)
// Bit 31:24 RW, mg_dtl_ln_up,   Line number in the top window for activities in MBDG
// Bit 23:16 RW, mg_dtl_ln_dn,   Line number in the bottom window for activities in MBDG
// Bit 15:8  RW, mg_dtl_ln_left, Column number in the left window for activities in MBDG
// Bit 7:0   RW, mg_dtl_ln_right,Column number in the right window for activities in MBDG
#define D2D3_MBDG_PARAM_2                          ((0x2b1b  << 2) + 0xd0100000)
// Bit 31:24 RW, mg_y_max,       Software initial depth of point D and U in vertical curve
// Bit 23:16 RW, mg_y_min,       Software initial depth of point C in vertical curve
// Bit 15:8  RW, mg_x_max,       Software initial depth of point D and U in horizontal curve
// Bit 7:0   RW, mg_x_min,       Software initial depth of point C in horizontal curve
#define D2D3_MBDG_PARAM_3                          ((0x2b1c  << 2) + 0xd0100000)
// Bit 31:27 Reserved
// Bit 26    RW, mg_y_adapt_en,  1 to enable the adaptive mode for point U/D in vertical curve calculation
// Bit 25    RW, mg_xmm_adapt_en, 1 to enable the XMM adaptive mode for point U/D in horizontal curve calculation
// Bit 24    RW, mg_x_adapt_en,  1 to enable the adaptive mode for point U/D in horizontal curve calculation
// Bit 23:20 RW, mg_ytrans_1,    Shifter controller in vertical curve calculation, if mg_xtrans_1<0, right shift abs(mg_xtrans_1) bits, others left shift abs(mg_xtrans_1) bits
// Bit 19:16 RW, mg_xtrans_1,    Shifter controller in horizontal curve calculation, if mg_xtrans_1<0, right shift abs(mg_xtrans_1) bits, others left shift abs(mg_xtrans_1) bits
// Bit 15:8  RW, mg_yk_0,        The based activities value of the ACT for vertical curve
// Bit 7:0   RW, mg_xk_0,        The based activities value of the ACT for horizontal curve
#define D2D3_MBDG_PARAM_4                          ((0x2b1d  << 2) + 0xd0100000)
// Bit 31:24 RW, mg_ysu3,        Quantized value 3 in vertical curve adaptive calculation
// Bit 23:16 RW, mg_ysu2,        Quantized value 2 in vertical curve adaptive calculation
// Bit 15:8  RW, mg_ysu1,        Quantized value 1 in vertical curve adaptive calculation
// Bit 7:0   RW, mg_ysu0,        Quantized value 0 in vertical curve adaptive calculation
#define D2D3_MBDG_PARAM_5                          ((0x2b1e  << 2) + 0xd0100000)
// Bit 31:24 RW, mg_xsu3,        Quantized value 3 in horizontal curve adaptive calculation
// Bit 23:16 RW, mg_xsu2,        Quantized value 2 in horizontal curve adaptive calculation
// Bit 15:8  RW, mg_xsu1,        Quantized value 1 in horizontal curve adaptive calculation
// Bit 7:0   RW, mg_xsu0,        Quantized value 0 in horizontal curve adaptive calculation
#define D2D3_MBDG_PARAM_6                          ((0x2b1f  << 2) + 0xd0100000)
// Bit 31:16 Reserved 
// Bit 15:8  RW, mg_xsu4,        Quantized value 4 in horizontal curve adaptive calculation
// Bit 7:0   RW, mg_ysu4,        Quantized value 4 in vertical curve adaptive calculation
#define D2D3_MBDG_PARAM_7                          ((0x2b20  << 2) + 0xd0100000)
// Bit 31:28 RW, dbg_hscnt_sel   see DBG_STATUS_2
// Bit 27:25 Reserved 
// Bit 24    RW, dbg_dbr_en,     1 to enable debug mode in DBR
// Bit 23:16 RW, dbg_force_data, Forced data in debug mode
// Bit 15:12 RW, dbg_bld_ctrl,   debug controller for DBLD
//                               [12]:enable;  [13]: 0 for passive mode, 0 for handshake mode
//                               [15:14]: 0 for constant mode, 1 for step1 mode
// Bit 11:8  RW, dbg_mg_ctrl,    debug controller for MBDG
//                               [8]:enable;  [9]: 0 for passive mode, 0 for handshake mode
//                               [11:10]: 0 for constant mode, 1 for step1 mode
// Bit 7:4   RW, dbg_cg_ctrl,    debug controller for CBDG
//                               [4]:enable;  [5]: 0 for passive mode, 0 for handshake mode
//                               [7:6]: 0 for constant mode, 1 for step1 mode
// Bit 3:0   RW, dbg_lg_ctrl,    debug controller for LBDG
//                               [0]:enable;  [1]: 0 for passive mode, 0 for handshake mode
//                               [3:2]: 0 for constant mode, 1 for step1 mode
#define D2D3_DBG_CTRL                              ((0x2b23  << 2) + 0xd0100000)
//------------------------------------------------------------------------------
// DWMIF registers
//------------------------------------------------------------------------------
// Bit 31:18 Reserved 
// Bit 17    RW, dw_x_rev        0: Normal write data from left to right in horizontal
//                               1: Reversed write data from left to right in horizontal
// Bit 16    RW, dw_y_rev        0: Normal write data from top to bottom in horizontal
//                               1: Reversed write data from bottom to top in horizontal  
// Bit 15    RW, dw_done_clr     1 to clear register depw_done (DWMIF_STATUS)
// Bit 14    RW, dw_little_endian, 0: data is ordered in big-endian, 1: little endian
// Bit 13:12 RW, dw_pic_struct,  0:read every line, 1:reserved, 2:read even line, 3:read odd line
// Bit 11    RW, dw_urgent,      urgent index
// Bit 10    RW, dw_clr_wrrsp,   1:clear the write fifo counter
// Bit 9     RW, dw_canvas_wr,   canvas write initialization again
// Bit 8     RW, dw_req_en,      1 to enable write request
// Bit 7:0   RW, dw_canvas_index,Canvas index for the MSB of memory address for memory write
#define D2D3_DWMIF_CTRL                            ((0x2b24  << 2) + 0xd0100000)
// Bit 31    Reserved
// Bit 30:16 RW, dw_end_x,       Horizontal end position for memory write, count by BYTE
// Bit 15    Reserved
// Bit 14:0  RW, dw_start_x,     Horizontal start position for memory write, count by BYTE
#define D2D3_DWMIF_HPOS                            ((0x2b25  << 2) + 0xd0100000)
// Bit 31:29 Reserved
// Bit 28:16 RW, dw_end_y,       Vertical end position for memory write, count by BYTE
// Bit 15:13 Reserved
// Bit 12:0  RW, dw_start_y,     Vertical start position for memory write, count by BYTE
#define D2D3_DWMIF_VPOS                            ((0x2b26  << 2) + 0xd0100000)
// Bit 31:28 Reserved
// Bit 27:16 RW, dw_vsizem1,     Vertical size for memory write, equal the size minus 1
// Bit 15:12 Reserved
// Bit 11:0  RW, dw_hsizem1,     Horizontal size for memory write, equal the size minus 1
#define D2D3_DWMIF_SIZE                            ((0x2b27  << 2) + 0xd0100000)
//------------------------------------------------------------------------------
// DRMIF registers
//------------------------------------------------------------------------------
// Bit 31:18 Reserved
// Bit 17    RW, dr_y_rev,       0: Normal Read data from top to bottom in horizontal
//                               1: Reversed read data from bottom to top in horizontal
// Bit 16    RW, dr_x_rev,       0: Normal Read data from left to right in horizontal
//                               1: Reversed read data from right to left in horizontal
// Bit 15    RW, dr_clr_fifo_error, 1 to clear the overflow flag of the sticky FIFO
// Bit 14    RW, dr_little_endian, 0: data is ordered in big-endian; 1: little-endian
// Bit 13:12 RW, dr_pic_struct,  0: progressive;  1: Reserved;
//                               2: interlaced, even line;  3: interlaced, odd line
// Bit 11    RW, dr_urgent,      urgent index, no use in this system
// Bit 10:9  RW, dr_burst_size,  Burst read length for each request; 0=24,1=32,2=48,3=64
// Bit 8     RW, dr_req_en,      1 to enable read request
// Bit 7:0   RW, dr_canvas_index, Canvas index for the MSB of memory address for memory read
#define D2D3_DRMIF_CTRL                            ((0x2b28  << 2) + 0xd0100000)
// Bit 31    Reserved
// Bit 30:16 RW, dr_end_x,       Horizontal end position for memory read, count by BYTE
// Bit 15    Reserved
// Bit 14:0  RW, dr_start_x,     Horizontal start position for memory read, count by BYTE
#define D2D3_DRMIF_HPOS                            ((0x2b29  << 2) + 0xd0100000)
// Bit 31:29 Reserved
// Bit 28:16 RW, dr_end_y,       Vertical end position for memory read, count by BYTE
// Bit 15:13 Reserved
// Bit 12:0  RW, dr_start_y,     Vertical start position for memory read, count by BYTE
#define D2D3_DRMIF_VPOS                            ((0x2b2a  << 2) + 0xd0100000)
//------------------------------------------------------------------------------
// PDR registers
// ddd: parallax based render
//------------------------------------------------------------------------------
// Bit 31:8  Reserved
// Bit 7     RW, ddd_brdlpf_en,  1 to enable the smooth filter on the depth around the boundary
// Bit 6     RW, ddd_extn_black, 1 to enable the function to fill black colour when interpolated pixels is outside the picture in DBR
// Bit 5     RW, ddd_wrap_en,    Reserved
// Bit 4     RW, ddd_hhalf,      1 to indicate the left/right line length is a half of original line. 
// Bit 3:2   RW, ddd_out_mode,   Reserved
// Bit 1:0   RW, ddd_lomode,     wrap & pbr interleave mode:                                        
//                               2'b0x: whole line is left or right;                           
//                               2'b10: d2p_lar=1(D2P_PARAM_1), rlrlrlrl inteleave in one line,
//                                      d2p_lar=0(D2P_PARAM_1), lrlrlrlr inteleave in one line,      
//                               2'b11: d2p_lar=1(D2P_PARAM_1), rrrrrlllll, half line is right, another half is left,
//                                      d2p_lar=0(D2P_PARAM_1), lllllrrrrr, half line is left, another half is right,
#define D2D3_DBR_DDD_CTRL                          ((0x2b2c  << 2) + 0xd0100000)
// Bit 31:0  RW, ddd_dbg_ctrl,   no use
#define D2D3_DBR_DDD_DBG                           ((0x2b2d  << 2) + 0xd0100000)
//------------------------------------------------------------------------------
// LRDMX registers
//------------------------------------------------------------------------------
// Bit 31:9  Reserved
// Bit 8     RW, lr_merge,       1: all the left/right input go to the left channel output
// Bit 7:6   RW, lrd_ff0_sel,    FF0 source selector
//                               0:from left input; 1:from right input; 2:from FF0; 3:no used
// Bit 5:4   RW, lrd_ff1_sel,    FF1 source selector
//                               0:from left input; 1:from right input; 2:from FF0; 3:no used
// Bit 3:2   RW, lrd_lout_sel,   left channel DEMUX
//                               00: ff0  01:ff1   10: left input  11:right input
// Bit 1:0   RW, lrd_rout_sel,   right channel DEMUX
//                               00: ff1  01:ff0   10: left input  11:right input 
#define D2D3_DBR_LRDMX_CTRL                        ((0x2b2f  << 2) + 0xd0100000)
//------------------------------------------------------------------------------
// Read Only registers
//------------------------------------------------------------------------------
// Bit 31:24 RO, ro_cg_vprel,    vanish point's reliability in CBDG
// Bit 23:12 RO, ro_cg_vpx,      vanish point's X-Axis in CBDG
// Bit 11:0  RO, ro_cg_vpy,      vanish point's Y-Axis in CBDG
#define D2D3_CBDG_STATUS_1                         ((0x2b30  << 2) + 0xd0100000)
// Bit 31:24 RO, ro_mg_cx[7:0],  X-Axis of point C in horizontal curve in MBDG
// Bit 23:16 RO, ro_mg_ux,       Depth value of point U in horizontal curve in MBDG
// Bit 15:8  RO, ro_mg_dx,       Depth value of point D in horizontal curve in MBDG
// Bit 7:0   RO, ro_mg_minx,     Depth value of point C in horizontal curve in MBDG
#define D2D3_MBDG_STATUS_1                         ((0x2b31  << 2) + 0xd0100000)
// Bit 31:24 RO, ro_mg_cy[7:0],  X-Axis of point C in vertical curve in MBDG
// Bit 23:16 RO, ro_mg_uy,       Depth value of point U in vertical curve in MBDG
// Bit 15:8  RO, ro_mg_dy,       Depth value of point D in vertical curve in MBDG
// Bit 7:0   RO, ro_mg_miny,     Depth value of point C in vertical curve in MBDG
#define D2D3_MBDG_STATUS_2                         ((0x2b32  << 2) + 0xd0100000)
// Bit 31    RO, ro_wrap_status, 1 indicate the D2P_WRAP is busy to perform the initialization
// Bit 30:8  Reserved 
// Bit 7:4   RO, ro_mg_cy[11:8], X-Axis of point C in vertical curve in MBDG
// Bit 3:0   RO, ro_mg_cx[11:8], X-Axis of point C in horizontal curve in MBDG
#define D2D3_MBDG_STATUS_3                         ((0x2b33  << 2) + 0xd0100000)
// Bit 31:21 Reserved 
// Bit 20:0  RO, ro_mg_sum_u,    ACT(top): activities of the top part
#define D2D3_MBDG_STATUS_4                         ((0x2b34  << 2) + 0xd0100000)
// Bit 31:21 Reserved 
// Bit 20:0  RO, ro_mg_sum_d,    ACT(bottom): activities of the bottom part
#define D2D3_MBDG_STATUS_5                         ((0x2b35  << 2) + 0xd0100000)
// Bit 31:21 Reserved 
// Bit 20:0  RO, ro_mg_sum_l,    ACT(left): activities of the left part
#define D2D3_MBDG_STATUS_6                         ((0x2b36  << 2) + 0xd0100000)
// Bit 31:21 Reserved  
// Bit 20:0  RO, ro_mg_sum_r,    ACT(right): activities of the right part
#define D2D3_MBDG_STATUS_7                         ((0x2b37  << 2) + 0xd0100000)
// Bit 31:0 dbg_handshake_ro0,   handshake signal for debug, internal srdy and rrdy
#define D2D3_DBG_STATUS_1                          ((0x2b38  << 2) + 0xd0100000)
// Bit 31:0 dbg_hscnt,           dbg_hscnt_sel == 4'h0, output lg hscnt
//                               dbg_hscnt_sel == 4'h1, output cg hscnt
//                               dbg_hscnt_sel == 4'h2, output mg hscnt
//                               dbg_hscnt_sel == 4'h3, output bld hscnt
//                               dbg_hscnt_sel == other value, output 32'h0
#define D2D3_DBG_STATUS_2                          ((0x2b39  << 2) + 0xd0100000)
// Bit 31:0 RO, drmif_status,    drmif module internal status
#define D2D3_DRMIF_STATUS                          ((0x2b3a  << 2) + 0xd0100000)
// Bit 31:2 RO, Reserved
// Bit 1:0  RO, d2d3_status0,    [1]: depw_done, one field depth write to ddr has done
//                               [0]: dwmif_pending_ddr_wrrsp, 1 to indicate write response from ddr
#define D2D3_DWMIF_STATUS                          ((0x2b3b  << 2) + 0xd0100000)
// Bit 31:24 Reserved  
// Bit 23:0  RO, ro_meet_sum,    register sumxy_sum_dbg in CBDG
#define D2D3_CBDG_STATUS_2                         ((0x2b3c  << 2) + 0xd0100000)
// Bit 31:20 Reserved  
// Bit 19:0  RO, ro_hist_depth,  
#define D2D3_DBLD_STATUS                           ((0x2b3d  << 2) + 0xd0100000)
// Bit 31:0 Reserved  
#define D2D3_RESEV_STATUS1                         ((0x2b3e  << 2) + 0xd0100000)
// Bit 31:0  Reserved  
#define D2D3_RESEV_STATUS2                         ((0x2b3f  << 2) + 0xd0100000)
//
// Closing file:  d2d3_regs.h
//
//========================================================================
//  MIPI DSI Host Controller        (16'h2c00 - 16'h2cff)
//
//========================================================================
//`define  DSI_VCBUS_BASE             8'h2c
//`include "dsi_regs.h"
//========================================================================
//  ISP register    (16'h2d00 - 16'h2dff)
//========================================================================
//`define ISP_VCBUS_BASE                   8'h2d
//`include "isp_reg.h"
//========================================================================
//  VI_HIST_SPL register    (16'h2e00 - 16'h2eff)
//========================================================================
//`define VI_HIST_SPL_VCBUS_BASE                   8'h2e
//
// Reading file:  vi_hist_spl_reg.h
//
// synopsys translate_off
// synopsys translate_on
// ----------------------------
// VI_HIST_SPL 0x2e  
// ----------------------------
// -----------------------------------------------
// CBUS_BASE:  VI_HIST_SPL_VCBUS_BASE = 0x2e
// -----------------------------------------------
//BIT 14: 34bin only, 0&255 and other 32bins
//Bit 13:11 hist_din_sel, 00: from vdin0 dout,  1: from vdin1, 2: from nr dout, 3: di output, 4: vpp output, 5: vd1_din, 6: vd2_din, 7:osd1_dout
//Bit 10:8   hist_din_comp_mux, mux of [29:22], [19:12], [9:2] for hist detect
//Bit 7:5   hist_dnlp_low   the real pixels in each bins got by VI_DNLP_HISTXX should multiple with 2^(dnlp_low+3)
//Bit 3:2   hist_din_sel    the source used for hist statistics.  00: from matrix0 dout,  01: from vsc_dout, 10: from matrix1 dout, 11: form matrix1 din
//Bit 1     hist_win_en     1'b0: hist used for full picture; 1'b1: hist used for pixels within hist window
//Bit 0     hist_spl_en     1'b0: disable hist readback; 1'b1: enable hist readback
#define VI_HIST_CTRL                               ((0x2e00  << 2) + 0xd0100000)
//Bit 28:16 hist_hstart  horizontal start value to define hist window
//Bit 12:0  hist_hend    horizontal end value to define hist window
#define VI_HIST_H_START_END                        ((0x2e01  << 2) + 0xd0100000)
//Bit 28:16 hist_vstart  vertical start value to define hist window
//Bit 12:0  hist_vend    vertical end value to define hist window
#define VI_HIST_V_START_END                        ((0x2e02  << 2) + 0xd0100000)
//Bit 15:8  hist_max    maximum value 
//Bit 7:0   hist_min    minimum value 
//read only
#define VI_HIST_MAX_MIN                            ((0x2e03  << 2) + 0xd0100000)
//Bit 31:0  hist_spl_rd
//counts for the total luma value 
//read only
#define VI_HIST_SPL_VAL                            ((0x2e04  << 2) + 0xd0100000)
//Bit 21:0  hist_spl_pixel_count
//counts for the total calculated pixels
//read only
#define VI_HIST_SPL_PIX_CNT                        ((0x2e05  << 2) + 0xd0100000)
//Bit 31:0  hist_chroma_sum
//counts for the total chroma value 
//read only
#define VI_HIST_CHROMA_SUM                         ((0x2e06  << 2) + 0xd0100000)
//Bit 31:16 higher hist bin
//Bit 15:0  lower hist bin
//0-255 are splited to 64 bins evenly, and VI_DNLP_HISTXX
//are the statistic number of pixels that within each bin.
//VI_DNLP_HIST00[15:0]  counts for the first  bin
//VI_DNLP_HIST00[31:16] counts for the second bin
//VI_DNLP_HIST01[15:0]  counts for the third  bin
//VI_DNLP_HIST01[31:16] counts for the fourth bin
//etc...
//read only
#define VI_DNLP_HIST00                             ((0x2e07  << 2) + 0xd0100000)
#define VI_DNLP_HIST01                             ((0x2e08  << 2) + 0xd0100000)
#define VI_DNLP_HIST02                             ((0x2e09  << 2) + 0xd0100000)
#define VI_DNLP_HIST03                             ((0x2e0a  << 2) + 0xd0100000)
#define VI_DNLP_HIST04                             ((0x2e0b  << 2) + 0xd0100000)
#define VI_DNLP_HIST05                             ((0x2e0c  << 2) + 0xd0100000)
#define VI_DNLP_HIST06                             ((0x2e0d  << 2) + 0xd0100000)
#define VI_DNLP_HIST07                             ((0x2e0e  << 2) + 0xd0100000)
#define VI_DNLP_HIST08                             ((0x2e0f  << 2) + 0xd0100000)
#define VI_DNLP_HIST09                             ((0x2e10  << 2) + 0xd0100000)
#define VI_DNLP_HIST10                             ((0x2e11  << 2) + 0xd0100000)
#define VI_DNLP_HIST11                             ((0x2e12  << 2) + 0xd0100000)
#define VI_DNLP_HIST12                             ((0x2e13  << 2) + 0xd0100000)
#define VI_DNLP_HIST13                             ((0x2e14  << 2) + 0xd0100000)
#define VI_DNLP_HIST14                             ((0x2e15  << 2) + 0xd0100000)
#define VI_DNLP_HIST15                             ((0x2e16  << 2) + 0xd0100000)
#define VI_DNLP_HIST16                             ((0x2e17  << 2) + 0xd0100000)
#define VI_DNLP_HIST17                             ((0x2e18  << 2) + 0xd0100000)
#define VI_DNLP_HIST18                             ((0x2e19  << 2) + 0xd0100000)
#define VI_DNLP_HIST19                             ((0x2e1a  << 2) + 0xd0100000)
#define VI_DNLP_HIST20                             ((0x2e1b  << 2) + 0xd0100000)
#define VI_DNLP_HIST21                             ((0x2e1c  << 2) + 0xd0100000)
#define VI_DNLP_HIST22                             ((0x2e1d  << 2) + 0xd0100000)
#define VI_DNLP_HIST23                             ((0x2e1e  << 2) + 0xd0100000)
#define VI_DNLP_HIST24                             ((0x2e1f  << 2) + 0xd0100000)
#define VI_DNLP_HIST25                             ((0x2e20  << 2) + 0xd0100000)
#define VI_DNLP_HIST26                             ((0x2e21  << 2) + 0xd0100000)
#define VI_DNLP_HIST27                             ((0x2e22  << 2) + 0xd0100000)
#define VI_DNLP_HIST28                             ((0x2e23  << 2) + 0xd0100000)
#define VI_DNLP_HIST29                             ((0x2e24  << 2) + 0xd0100000)
#define VI_DNLP_HIST30                             ((0x2e25  << 2) + 0xd0100000)
#define VI_DNLP_HIST31                             ((0x2e26  << 2) + 0xd0100000)
#define VI_DNLP_HIST32                             ((0x2e27  << 2) + 0xd0100000)
//Bit 28:16 hist_pic_height  active input data window height
//Bit 12:0  hist_pic_width   active input data window width
#define VI_HIST_PIC_SIZE                           ((0x2e28  << 2) + 0xd0100000)
//Bit 15:8 hist_pix_white_value: >= this value will be white pixel
//Bit 7:0 hist_pix_black_value: <= this value will be black pixel
#define VI_HIST_BLACK_WHITE_VALUE                  ((0x2e29  << 2) + 0xd0100000)
#define VI_HIST_GCLK_CTRL                          ((0x2e2a  << 2) + 0xd0100000)
// synopsys translate_off
// synopsys translate_on
//
// Closing file:  vi_hist_spl_reg.h
//
//`define MCDI_VCBUS_BASE                8'h2f
//
// Reading file:  mcdi_regs.h
//
// synopsys translate_off
// synopsys translate_on
// -----------------------------------------------
// CBUS_BASE:  MCDI_VCBUS_BASE = 0x2f
// -----------------------------------------------
////=================================================================////
//// memc di core 0
////=================================================================////
#define MCDI_HV_SIZEIN                             ((0x2f00  << 2) + 0xd0100000)
//Bit 31:29, reserved  
//Bit 28:16, reg_mcdi_hsize               image horizontal size (number of cols)   default=1024 
//Bit 15:13, reserved                       
//Bit 12: 0, reg_mcdi_vsize               image vertical size   (number of rows)   default=1024
#define MCDI_HV_BLKSIZEIN                          ((0x2f01  << 2) + 0xd0100000)
//Bit    31, reg_mcdi_vrev					 default = 0
//Bit    30, reg_mcdi_hrev					 default = 0
//Bit 29:28, reserved
//Bit 27:16, reg_mcdi_blkhsize               image horizontal blk size (number of cols)   default=1024 
//Bit 15:13, reserved                       
//Bit 11: 0, reg_mcdi_blkvsize               image vertical blk size   (number of rows)   default=1024
#define MCDI_BLKTOTAL                              ((0x2f02  << 2) + 0xd0100000)
//Bit 31:24, reserved
//Bit 23: 0, reg_mcdi_blktotal
#define MCDI_MOTINEN                               ((0x2f03  << 2) + 0xd0100000)
//Bit 31: 2, reserved
//Bit     1, reg_mcdi_motionrefen.           enable motion refinement of MA, default = 1
//Bit     0, reg_mcdi_motionparadoxen.       enable motion paradox detection, default = 1
#define MCDI_CTRL_MODE                             ((0x2f04  << 2) + 0xd0100000)
//Bit 31:28, reserved 
//Bit 27:26, reg_mcdi_lmvlocken	             0:disable, 1: use max Lmv, 2: use no-zero Lmv, lmv lock enable mode, default = 2			
//Bit 25,    reg_mcdi_reldetrptchken         
//                                           0: unable; 1: enable, enable repeat pattern check (not repeat mv detection) in rel det part, default = 1
//Bit 24,    reg_mcdi_reldetgmvpd22chken     
//                                           0: unable; 1: enable, enable pull-down 22 mode check in gmv lock mode for rel det, default = 1
//Bit 23,    reg_mcdi_pd22chken
//                                           0: unable; 1: enable, enable pull-down 22 mode check (lock) function, default = 1      
//Bit 22,    reg_mcdi_reldetlpfen
//                                           0: unable; 1: enable, enable det value lpf, default = 1 
//Bit 21,    reg_mcdi_reldetlmvpd22chken
//                                           0: unable; 1: enable, enable pull-down 22 mode check in lmv lock mode for rel det, default = 1      
//Bit 20,    reg_mcdi_reldetlmvdifchken
//                                           0: unable; 1: enable, enable lmv dif check in lmv lock mode for rel det, default = 1  
//Bit 19,    reg_mcdi_reldetgmvdifchken
//                                           0: unable; 1: enable, enable lmv dif check in lmv lock mode for rel det, default = 1 
//Bit 18,    reg_mcdi_reldetpd22chken
//                                           0: unable; 1: enable, enable pull-down 22 mode check for rel det refinement, default = 1
//Bit 17,    reg_mcdi_reldetfrqchken
//                                           0: unable; 1: enable, enable mv frequency check in rel det, default = 1  
//Bit 16,    reg_mcdi_qmeen
//                                           0: unable; 1: enable, enable quarter motion estimation, defautl = 1  
//Bit 15,    reg_mcdi_refrptmven
//                                           0: unable; 1: enable, use repeat mv in refinement, default = 1 
//Bit 14,    reg_mcdi_refgmven
//                                           0: unable; 1: enable, use gmv in refinement, default = 1  
//Bit 13,    reg_mcdi_reflmven
//                                           0: unable; 1: enable, use lmvs in refinement, default = 1  
//Bit 12,    reg_mcdi_refnmven
//                                           0: unable; 1: enable, use neighoring mvs in refinement, default = 1  
//Bit 11,    reserved  
//Bit 10,    reg_mcdi_referrfrqchken		 
//                                           0: unable; 1: enable, enable mv frquency check while finding min err in ref, default = 1  
//Bit 9,     reg_mcdi_refen					 
//                                           0: unable; 1: enable, enable mv refinement, default = 1  
//Bit 8,     reg_mcdi_horlineen				 
//                                           0: unable; 1: enable,enable horizontal lines detection by sad map, default = 1  
//Bit 7,     reg_mcdi_highvertfrqdeten		 
//                                           0: unable; 1: enable, enable high vertical frequency pattern detection, default = 1  
//Bit 6,     reg_mcdi_gmvlocken				 
//                                           0: unable; 1: enable, enable gmv lock mode, default = 1
//Bit 5,     reg_mcdi_rptmven	             
//                                           0: unable; 1: enable, enable repeat pattern detection, default = 1  
//Bit 4,     reg_mcdi_gmven                  
//                                           0: unable; 1: enable, enable global motion estimation, default = 1   
//Bit 3,     reg_mcdi_lmven                  
//                                           0: unable; 1: enable, enable line mv estimation for hme, default = 1  
//Bit 2,     reg_mcdi_chkedgeen		         
//                                           0: unable; 1: enable, enable check edge function, default = 1
//Bit 1,     reg_mcdi_txtdeten			     
//                                           0: unable; 1: enable, enable texture detection, default = 1 
//Bit 0,     reg_mcdi_memcen                  
//                                           0: unable; 1: enable, enable of memc di, default = 1
#define MCDI_UNI_MVDST                             ((0x2f05  << 2) + 0xd0100000)
//Bit 31:20, reserved  
//Bit 19:17, reg_mcdi_unimvdstabsseg0                     segment0 for uni-mv abs, default = 1
//Bit 16:12, reg_mcdi_unimvdstabsseg1                     segment1 for uni-mv abs, default = 15
//Bit 11: 8, reg_mcdi_unimvdstabsdifgain0	          2/2, gain0 of uni-mv abs dif for segment0, normalized 2 to '1', default = 2 
//Bit  7: 5, reg_mcdi_unimvdstabsdifgain1                 2/2, gain1 of uni-mv abs dif for segment1, normalized 2 to '1', default = 2             
//Bit  4: 2, reg_mcdi_unimvdstabsdifgain2                 2/2, gain2 of uni-mv abs dif beyond segment1, normalized 2 to '1', default = 2              
//Bit  1: 0, reg_mcdi_unimvdstsgnshft		          shift for neighboring distance of uni-mv, default = 0
#define MCDI_BI_MVDST                              ((0x2f06  << 2) + 0xd0100000)
//Bit 31:20, reserved  
//Bit 19:17, reg_mcdi_bimvdstabsseg0                      segment0 for bi-mv abs, default = 1
//Bit 16:12, reg_mcdi_bimvdstabsseg1                      segment1 for bi-mv abs, default = 9
//Bit 11: 8, reg_mcdi_bimvdstabsdifgain0	          6/2, gain0 of bi-mv abs dif for segment0, normalized 2 to '1', default = 6
//Bit  7: 5, reg_mcdi_bimvdstabsdifgain1                  3/2, gain1 of bi-mvabs dif for segment1, normalized 2 to '1', default = 3          
//Bit  4: 2, reg_mcdi_bimvdstabsdifgain2                  2/2, gain2 of bi-mvabs dif beyond segment1, normalized 2 to '1', default = 2             
//Bit  1: 0, reg_mcdi_bimvdstsgnshft	                  shift for neighboring distance of bi-mv, default = 0
#define MCDI_SAD_GAIN                              ((0x2f07  << 2) + 0xd0100000)
//Bit 31:19, reserved  
//Bit 18:17, reg_mcdi_unisadcorepxlgain                   uni-sad core pixels gain, default = 3
//Bit 16,    reg_mcdi_unisadcorepxlnormen                 enable uni-sad core pixels normalization, default = 0 
//Bit 15:11, reserved
//Bit 10: 9, reg_mcdi_bisadcorepxlgain                    bi-sad core pixels gain, default = 3
//Bit  8,    reg_mcdi_bisadcorepxlnormen                  enable bi-sad core pixels normalization, default = 1 
//Bit  7: 3, reserved
//Bit  2: 1, reg_mcdi_biqsadcorepxlgain                   bi-qsad core pixels gain, default = 3
//Bit  0,    reg_mcdi_biqsadcorepxlnormen                 enable bi-qsad core pixels normalization, default = 1              
#define MCDI_TXT_THD                               ((0x2f08  << 2) + 0xd0100000)
//Bit 31:24, reserved
//Bit 23:16, reg_mcdi_txtminmaxdifthd,                    min max dif threshold (>=) for texture detection, default = 24
//Bit 15: 8, reg_mcdi_txtmeandifthd,                      mean dif threshold (<) for texture detection, default = 9
//Bit  7: 3, reserved
//Bit  2: 0, reg_mcdi_txtdetthd,                          texture detecting threshold, 0~4, default = 2
#define MCDI_FLT_MODESEL                           ((0x2f09  << 2) + 0xd0100000)
//Bit 31	 reserved
//Bit 30:28, reg_mcdi_flthorlineselmode                   mode for horizontal line detecting flat calculation, default = 1, same as below
//Bit 27	 reserved
//Bit 26:24, reg_mcdi_fltgmvselmode                       mode for gmv flat calculation, default = 4, same as below
//Bit 23,	 reserved
//Bit 22:20, reg_mcdi_fltsadselmode                       mode for sad flat calculation, default = 2, same as below
//Bit 19,	 reserved
//Bit 18:16, reg_mcdi_fltbadwselmode                      mode for badw flat calculation, default = 3, same as below
//Bit 15,	 reserved
//Bit 14:12, reg_mcdi_fltrptmvselmode                     mode for repeat mv flat calculation, default = 4, same as below
//Bit 11,	 reserved
//Bit 10: 8, reg_mcdi_fltbadrelselmode                    mode for bad rel flat calculation, default = 4, same as below
//Bit  7,	 reserved
//Bit  6: 4, reg_mcdi_fltcolcfdselmode                    mode for col cfd flat calculation, default = 2, same as below
//Bit  3,	 reserved
//Bit  2: 0, reg_mcdi_fltpd22chkselmode                   mode for pd22 check flat calculation, default = 2, # 0:cur dif h, 1: cur dif v, 2: pre dif h, 3: pre dif v, 4: cur flt, 5: pre flt, 6: cur+pre, 7: max all(cur,pre)
#define MCDI_CHK_EDGE_THD                          ((0x2f0a  << 2) + 0xd0100000)
//Bit 23:28, reserved.
//Bit 27:24, reg_mcdi_chkedgedifsadthd.                   thd (<=) for sad dif check, 0~8, default = 1
//Bit 23:16, reserved.
//Bit 15:12, reg_mcdi_chkedgemaxedgethd.                  max drt of edge, default = 15
//Bit 11: 8, reg_mcdi_chkedgeminedgethd.                  min drt of edge, default = 2
//Bit     7, reserved.
//Bit  6: 0, reg_mcdi_chkedgevdifthd.                     thd for vertical dif in check edge, default = 14
#define MCDI_CHK_EDGE_GAIN_OFFST                   ((0x2f0b  << 2) + 0xd0100000)
//Bit 31:24, reserved.
//Bit 23:20, reg_mcdi_chkedgedifthd1.                     thd1 for edge dif check (<=), default = 4
//Bit 19:16, reg_mcdi_chkedgedifthd0.                     thd0 for edge dif check (>=), default = 15
//Bit   :15, reserved.
//Bit 14:10, reg_mcdi_chkedgechklen.                      total check length for edge check, 1~24 (>0), default = 24
//Bit  9: 8, reg_mcdi_chkedgeedgesel.                     final edge select mode, 0: original start edge, 1: lpf start edge, 2: orignal start+end edge, 3: lpf start+end edge, default = 1
//Bit  7: 3, reg_mcdi_chkedgesaddstgain.                  distance gain for sad calc while getting edges, default = 4
//Bit     2, reg_mcdi_chkedgechkmode.                     edge used in check mode, 0: original edge, 1: lpf edge, defautl = 1
//Bit     1, reg_mcdi_chkedgestartedge.                   edge mode for start edge, 0: original edge, 1: lpf edge, defautl = 0
//Bit     0, reg_mcdi_chkedgeedgelpf.                     edge lpf mode, 0:[0,2,4,2,0], 1:[1,2,2,2,1], default = 0
#define MCDI_LMV_RT                                ((0x2f0c  << 2) + 0xd0100000)
//BIt 31:15, reserved
//Bit 14:12, reg_mcdi_lmvvalidmode                        valid mode for lmv calc., 100b: use char det, 010b: use flt, 001b: use hori flg
//Bit 11:10, reg_mcdi_lmvgainmvmode                       four modes of mv selection for lmv weight calucluation, default = 1
//                                                        0: cur(x-3), lst(x-1,x,x+1); 1: cur(x-4,x-3), lst(x,x+1); 2: cur(x-5,x-4,x-3), lst(x-1,x,x+1,x+2,x+3); 3: cur(x-6,x-5,x-4,x-3), lst(x-1,x,x+1,x+2);
//Bit  9,    reg_mcdi_lmvinitmode                         initial lmvs at first row of input field, 0: intial value = 0; 1: inital = 32 (invalid), default = 0
//Bit  8,    reserved
//Bit  7: 4, reg_mcdi_lmvrt0                              ratio of max mv, default = 5
//Bit  3: 0, reg_mcdi_lmvrt1                              ratio of second max mv, default = 5
#define MCDI_LMV_GAINTHD                           ((0x2f0d  << 2) + 0xd0100000)
//Bit 31:24, reg_mcdi_lmvvxmaxgain                        max gain of lmv weight, default = 96
//Bit 23,    reserved
//Bit 22:20, reg_mcdi_lmvdifthd0                          dif threshold 0 (<) for small lmv, default = 1
//Bit 19:17, reg_mcdi_lmvdifthd1                          dif threshold 1 (<) for median lmv, default = 2
//Bit 16:14, reg_mcdi_lmvdifthd2                          dif threshold 2 (<) for large lmv, default = 3
//Bit 13: 8, reg_mcdi_lmvnumlmt                           least/limit number of (total number - max0), default = 20
//Bit  7: 0, reg_mcdi_lmvfltthd                           flt cnt thd (<) for lmv, default = 9
#define MCDI_RPTMV_THD0                            ((0x2f0e  << 2) + 0xd0100000)
//Bit 31:25, reg_mcdi_rptmvslpthd2			  slope thd (>=) between i and i+3/i-3 (i+4/i-4), default = 64
//Bit 24:20, reg_mcdi_rptmvslpthd1                        slope thd (>=) between i and i+2/i-2, default = 4
//Bit 19:10, reg_mcdi_rptmvampthd2                        amplitude thd (>=) between max and min, when count cycles, default = 300
//Bit  9: 0, reg_mcdi_rptmvampthd1                        amplitude thd (>=) between average of max and min, default = 400
#define MCDI_RPTMV_THD1                            ((0x2f0f  << 2) + 0xd0100000)
//Bit 31:28, reserved
//Bit 27:25, reg_mcdi_rptmvcyccntthd                      thd (>=) of total cycles count, default = 2
//Bit 24:21, reg_mcdi_rptmvcycdifthd                      dif thd (<) of cycles length, default = 3
//Bit 20:18, reg_mcdi_rptmvcycvldthd                      thd (>) of valid cycles number, default = 1
//Bit 17:15, reg_mcdi_rptmvhalfcycminthd                  min length thd (>=) of half cycle, default = 2
//Bit 14:11, reg_mcdi_rptmvhalfcycdifthd                  neighboring half cycle length dif thd (<), default = 5
//Bit 10: 8, reg_mcdi_rptmvminmaxcntthd                   least number of valid max and min, default = 2
//Bit  7: 5, reg_mcdi_rptmvcycminthd                      min length thd (>=) of cycles, default = 2
//Bit  4: 0, reg_mcdi_rptmvcycmaxthd                      max length thd (<) of cycles, default = 17
#define MCDI_RPTMV_THD2                            ((0x2f10  << 2) + 0xd0100000)
//Bit 31:24, reserved
//Bit 23:16, reg_mcdi_rptmvhdifthd0                       higher hdif thd (>=) (vertical edge) for rpt detection, default = 8
//Bit 15: 8, reg_mcdi_rptmvhdifthd1                       hdif thd (>=) (slope edge) for rpt detection, default = 4
//Bit  7: 0, reg_mcdi_rptmvvdifthd                        vdif thd (>=) (slope edge) for rpt detection, default = 1
#define MCDI_RPTMV_SAD                             ((0x2f11  << 2) + 0xd0100000)
//Bit 31:26, reserved
//Bit 25:16, reg_mcdi_rptmvsaddifthdgain                  7x3x(16/16), gain for sad dif thd in rpt mv detection, 0~672, normalized 16 as '1', default = 336
//Bit 15:10, reserved
//Bit  9: 0, reg_mcdi_rptmvsaddifthdoffst                 offset for sad dif thd in rpt mv detection, -512~511, default = 16
#define MCDI_RPTMV_FLG                             ((0x2f12  << 2) + 0xd0100000)
//Bit 31:18,  reserved                                    
//Bit 17:16,  reg_mcdi_rptmvmode                          select mode of mvs for repeat motion estimation, 0: hmv, 1: qmv/2, 2 or 3: qmv/4, default = 2
//Bit 15: 8,  reg_mcdi_rptmvflgcntthd                     thd (>=) of min count number for rptmv of whole field, for rptmv estimation, default = 64
//Bit  7: 5,  reserved
//Bit  4: 0,  reg_mcdi_rptmvflgcntrt                      4/32, ratio for repeat mv flag count, normalized 32 as '1', set 31 to 32, 
#define MCDI_RPTMV_GAIN                            ((0x2f13  << 2) + 0xd0100000)
//Bit 31:24, reg_mcdi_rptmvlftgain                        up repeat mv gain for hme, default = 96
//Bit 23:16, reg_mcdi_rptmvuplftgain                      up left repeat mv gain for hme, default = 32
//Bit 15: 8, reg_mcdi_rptmvupgain                         up repeat mv gain for hme, default = 64
//Bit  7: 0, reg_mcdi_rptmvuprightgain                    up right repeat mv gain for hme, default = 32
#define MCDI_GMV_RT                                ((0x2f14  << 2) + 0xd0100000)
//Bit 31,    reserved
//Bit 30:24, reg_mcdi_gmvmtnrt0                           ratio 0 for motion senario, set 127 to 128, normalized 128 as '1', default =32
//Bit 23,    reserved
//Bit 22:16, reg_mcdi_gmvmtnrt1                           ratio 1 for motion senario, set 127 to 128, normalized 128 as '1', default = 56
//Bit 15,    reserved
//Bit 14: 8, reg_mcdi_gmvstlrt0                           ratio 0 for still senario, set 127 to 128, normalized 128 as '1', default = 56
//Bit  7,    reserved
//Bit  6: 0, reg_mcdi_gmvstlrt1                           ratio 1 for still senario, set 127 to 128, normalized 128 as '1', default = 80
#define MCDI_GMV_GAIN                              ((0x2f15  << 2) + 0xd0100000)
//Bit 31:25, reg_mcdi_gmvzeromvlockrt0                    ratio 0 for locking zero mv, set 127 to 128, normalized 128 as '1', default = 100
//Bit 24:18, reg_mcdi_gmvzeromvlockrt1                    ratio 1 for locking zero mv, set 127 to 128, normalized 128 as '1', default = 112
//Bit 17:16, reg_mcdi_gmvvalidmode                        valid mode for gmv calc., 10b: use flt, 01b: use hori flg, default = 3
//Bit 15: 8, reg_mcdi_gmvvxgain                           gmv's vx gain when gmv locked for hme, default = 0
//Bit  7: 0, reg_mcdi_gmvfltthd                           flat thd (<) for gmv calc. default = 3
#define MCDI_HOR_SADOFST                           ((0x2f16  << 2) + 0xd0100000)
//Bit 31:25, reserved
//Bit 24:16, reg_mcdi_horsaddifthdgain                    21*1/8, gain/divisor for sad dif threshold in hor line detection, normalized 8 as '1', default = 21
//Bit 15: 8, reg_mcdi_horsaddifthdoffst                   offset for sad dif threshold in hor line detection, -128~127, default = 0
//Bit  7: 0, reg_mcdi_horvdifthd                          threshold (>=) of vertical dif of next block for horizontal line detection, default = 24
#define MCDI_REF_MV_NUM                            ((0x2f17  << 2) + 0xd0100000)
//Bit 31: 2, reserved
//Bit  1: 0, reg_mcdi_refmcmode.         motion compensated mode used in refinement, 0: pre, 1: next, 2: (pre+next)/2, default = 0
#define MCDI_REF_BADW_THD_GAIN                     ((0x2f18  << 2) + 0xd0100000)
//Bit 31:28, reserved 
//Bit 27:24, reg_mcdi_refbadwcnt2gain.   gain for badwv count num==3, default = 6
//Bit 23:20, reg_mcdi_refbadwcnt1gain.   gain for badwv count num==2, default = 3
//Bit 19:16, reg_mcdi_refbadwcnt0gain.   gain for badwv count num==1, default = 1
//Bit 15:12, reg_mcdi_refbadwthd3.       threshold 3 for detect badweave with largest average luma, default = 4
//Bit 11: 8, reg_mcdi_refbadwthd2.       threshold 2 for detect badweave with third smallest average luma, default = 3
//Bit  7: 4, reg_mcdi_refbadwthd1.       threshold 1 for detect badweave with second smallest average luma, default = 2
//Bit  3: 0, reg_mcdi_refbadwthd0.       threshold 0 for detect badweave with smallest average luma, default = 1
#define MCDI_REF_BADW_SUM_GAIN                     ((0x2f19  << 2) + 0xd0100000)
//Bit 31:13, reserved
//Bit 12: 8, reg_mcdi_refbadwsumgain0.   sum gain for r channel, 0~16, default = 8
//Bit  7: 5, reserved
//Bit     4, reg_mcdi_refbadwcalcmode.   mode for badw calculation, 0:sum, 1:max, default = 0
//Bit  3: 0, reserved
#define MCDI_REF_BS_THD_GAIN                       ((0x2f1a  << 2) + 0xd0100000)
//Bit 31:28, reg_mcdi_refbsudgain1.      up & down block stregth gain1, normalized to 8 as '1', default = 2
//Bit 27:24, reg_mcdi_refbsudgain0.      up & down block stregth gain0, normalized to 8 as '1', default = 4
//Bit 23:19, reserved
//Bit 18:16, reg_mcdi_refbslftgain.      left block strength gain, default = 0
//Bit 15:13, reserved
//Bit 12: 8, reg_mcdi_refbsthd1.         threshold 1 for detect block stregth in refinment, default = 16
//Bit  7: 5, reserved
//Bit  4: 0, reg_mcdi_refbsthd0.         threshold 0 for detect block stregth in refinment, default = 8
#define MCDI_REF_ERR_GAIN0                         ((0x2f1b  << 2) + 0xd0100000)
//Bit    31, reserved
//Bit 30:24, reg_mcdi_referrnbrdstgain.            neighoring mv distances gain for err calc. in ref, normalized to 8 as '1', default = 48
//Bit 23:20, reserved
//Bit 19:16, reg_mcdi_referrbsgain.                bs gain for err calc. in ref, normalized to 8 as '1', default = 4
//Bit    15, reserved
//Bit 14: 8, reg_mcdi_referrbadwgain.              badw gain for err calc. in ref, normalized to 8 as '1', default = 64
//Bit  7: 4, reserved
//Bit  3: 0, reg_mcdi_referrsadgain.               sad gain for err calc. in ref, normalized to 8 as '1', default = 4
#define MCDI_REF_ERR_GAIN1                         ((0x2f1c  << 2) + 0xd0100000)
//Bit 31:20, reserved
//Bit 19:16, reg_mcdi_referrchkedgegain.           check edge gain for err calc. in ref, normalized to 8 as '1', default = 4
//Bit 15:12, reserved
//Bit 11: 8, reg_mcdi_referrlmvgain.               (locked) lmv gain for err calc. in ref, normalized to 8 as '1', default = 0
//Bit  7: 4, reserved
//Bit  3: 0, reg_mcdi_referrgmvgain.               (locked) gmv gain for err calc. in ref, normalized to 8 as '1', default = 0
#define MCDI_REF_ERR_FRQ_CHK                       ((0x2f1d  << 2) + 0xd0100000)
//Bit 31:28, reserved
//Bit 27:24, reg_mcdi_referrfrqgain.               gain for mv frquency, normalized to 4 as '1', default = 10
//Bit 23:21, reserved
//Bit 20:16, reg_mcdi_referrfrqmax.                max gain for mv frquency check, default = 31
//Bit    15, reserved
//Bit 14:12, reg_mcdi_ref_errfrqmvdifthd2.         mv dif threshold 2 (<) for mv frquency check, default = 3
//Bit    11, reserved
//Bit 10: 8, reg_mcdi_ref_errfrqmvdifthd1.         mv dif threshold 1 (<) for mv frquency check, default = 2
//Bit     7, reserved
//Bit  6: 4, reg_mcdi_ref_errfrqmvdifthd0.         mv dif threshold 0 (<) for mv frquency check, default = 1
//Bit  3: 0, reserved
#define MCDI_QME_LPF_MSK                           ((0x2f1e  << 2) + 0xd0100000)
//Bit 31:28, reserved
//Bit 27:24, reg_mcdi_qmechkedgelpfmsk0.           lpf mask0 for chk edge in qme, 0~8, msk1 = (8-msk0), normalized to 8 as '1', default = 7
//Bit 23:20, reserved
//Bit 19:16, reg_mcdi_qmebslpfmsk0.                lpf mask0 for bs in qme, 0~8, msk1 = (8-msk0), normalized to 8 as '1', default = 7
//Bit 15:12, reserved
//Bit 11: 8, reg_mcdi_qmebadwlpfmsk0.              lpf mask0 for badw in qme, 0~8, msk1 = (8-msk0), normalized to 8 as '1', default = 7
//Bit  7: 4, reserved
//Bit  3: 0, reg_mcdi_qmesadlpfmsk0.               lpf mask0 for sad in qme, 0~8, msk1 = (8-msk0), normalized to 8 as '1', default = 7
#define MCDI_REL_DIF_THD_02                        ((0x2f1f  << 2) + 0xd0100000)
//Bit 31:24, reserved.
//Bit 23:16, reg_mcdi_reldifthd2.                  thd (<) for (hdif+vdif), default = 9
//Bit 15: 8, reg_mcdi_reldifthd1.                  thd (<) for (vdif), default = 5
//Bit  7: 0, reg_mcdi_reldifthd0.                  thd (>=) for (hdif-vdif), default = 48
#define MCDI_REL_DIF_THD_34                        ((0x2f20  << 2) + 0xd0100000)
//Bit 31:16, reserved.
//Bit 15: 8, reg_mcdi_reldifthd4.                  thd (<) for (hdif), default = 255
//Bit  7: 0, reg_mcdi_reldifthd3.                  thd (>=) for (vdif-hdif), default = 48
#define MCDI_REL_BADW_GAIN_OFFST_01                ((0x2f21  << 2) + 0xd0100000)
//Bit 31:24, reg_mcdi_relbadwoffst1.               offset for badw adj, for flat block, -128~127, default = 0
//Bit 23:16, reg_mcdi_relbadwgain1.                gain for badw adj, for flat block, default = 128
//Bit 15: 8, reg_mcdi_relbadwoffst0.               offset for badw adj, for vertical block, -128~127, default = 0
//Bit  7: 0, reg_mcdi_relbadwgain0.                gain for badw adj, for vertical block, default = 160
#define MCDI_REL_BADW_GAIN_OFFST_23                ((0x2f22  << 2) + 0xd0100000)
//Bit 31:24, reg_mcdi_relbadwoffst3.               offset for badw adj, for other block, -128~127, default = 0
//Bit 23:16, reg_mcdi_relbadwgain3.                gain for badw adj, for other block, default = 48
//Bit 15: 8, reg_mcdi_relbadwoffst2.               offset for badw adj, for horizontal block, -128~127, default = 0
//Bit  7: 0, reg_mcdi_relbadwgain2.                gain for badw adj, for horizontal block, default = 48
#define MCDI_REL_BADW_THD_GAIN_OFFST               ((0x2f23  << 2) + 0xd0100000)
//Bit 31:23, reserved.
//Bit 22:16, reg_mcdi_relbadwoffst.                offset for badw thd adj, -64~63, default = 0
//Bit 15: 8, reserved.
//Bit  7: 0, reg_mcdi_relbadwthdgain.              gain0 for badw thd adj, normalized to 16 as '1', default = 16
#define MCDI_REL_BADW_THD_MIN_MAX                  ((0x2f24  << 2) + 0xd0100000)
//Bit 31:18, reserved.
//Bit 17: 8, reg_mcdi_relbadwthdmax.               max for badw thd adj, default = 256
//Bit  7: 0, reg_mcdi_relbadwthdmin.               min for badw thd adj, default = 16
#define MCDI_REL_SAD_GAIN_OFFST_01                 ((0x2f25  << 2) + 0xd0100000)
//Bit 31:24, reg_mcdi_relsadoffst1.                offset for sad adj, for flat block, -128~127, default = 0
//Bit 23:20, reserved.
//Bit 19:16, reg_mcdi_relsadgain1.                 gain for sad adj, for flat block, normalized to 8 as '1', default = 8
//Bit 15: 8, reg_mcdi_relsadoffst0.                offset for sad adj, for vertical block, -128~127, default = 0
//Bit  7: 4, reserved.
//Bit  3: 0, reg_mcdi_relsadgain0.                 gain for sad adj, for vertical block, normalized to 8 as '1', default = 6
#define MCDI_REL_SAD_GAIN_OFFST_23                 ((0x2f26  << 2) + 0xd0100000)
//Bit 31:24, reg_mcdi_relsadoffst3.                offset for sad adj, for other block, -128~127, default = 0
//Bit 23:20, reserved.
//Bit 19:16, reg_mcdi_relsadgain3.                 gain for sad adj, for other block, normalized to 8 as '1', default = 8
//Bit 15: 8, reg_mcdi_relsadoffst2.                offset for sad adj, for horizontal block, -128~127, default = 0
//Bit  7: 4, reserved.
//Bit  3: 0, reg_mcdi_relsadgain2.                 gain for sad adj, for horizontal block, normalized to 8 as '1', default = 12
#define MCDI_REL_SAD_THD_GAIN_OFFST                ((0x2f27  << 2) + 0xd0100000)
//Bit 31:24, reserved.
//Bit 23:16, reg_mcdi_relsadoffst.                 offset for sad thd adj, -128~127, default = 0
//Bit 15:10, reserved.
//Bit  9: 0, reg_mcdi_relsadthdgain.               gain for sad thd adj, 21*2/16, normalized to 16 as '1', default = 42
#define MCDI_REL_SAD_THD_MIN_MAX                   ((0x2f28  << 2) + 0xd0100000)
//Bit 31:27, reserved.
//Bit 26:16, reg_mcdi_relsadthdmax.                max for sad thd adj, 21*32, default = 672
//Bit 15: 9, reserved.
//Bit  8: 0, reg_mcdi_relsadthdmin.                min for sad thd adj, 21*2, default = 42
#define MCDI_REL_DET_GAIN_00                       ((0x2f29  << 2) + 0xd0100000)
//Bit 31:21, reserved.
//Bit 20:16, reg_mcdi_reldetbsgain0.               gain0 (gmv locked) for bs, for det. calc. normalized to 16 as '1', default = 8
//Bit 15:14, reserved.
//Bit 13: 8, reg_mcdi_reldetbadwgain0.             gain0 (gmv locked) for badw, for det. calc. normalized to 16 as '1', default = 12
//Bit  7: 5, reserved.
//Bit  4: 0, reg_mcdi_reldetsadgain0.              gain0 (gmv locked) for qsad, for det. calc. normalized to 16 as '1', default = 8
#define MCDI_REL_DET_GAIN_01                       ((0x2f2a  << 2) + 0xd0100000)
//Bit 31:14, reserved.
//Bit 12: 8, reg_mcdi_reldetchkedgegain0.          gain0 (gmv locked) for chk_edge, for det. calc. normalized to 16 as '1', default = 2
//Bit     7, reserved.
//Bit  6: 0, reg_mcdi_reldetnbrdstgain0.           gain0 (gmv locked) for neighoring dist, for det. calc. normalized to 16 as '1', default = 24
#define MCDI_REL_DET_GAIN_10                       ((0x2f2b  << 2) + 0xd0100000)
//Bit 31:21, reserved.
//Bit 20:16, reg_mcdi_reldetbsgain1.               gain1 (lmv locked) for bs, for det. calc. normalized to 16 as '1', default = 0
//Bit 15:14, reserved.
//Bit 13: 8, reg_mcdi_reldetbadwgain1.             gain1 (lmv locked) for badw, for det. calc. normalized to 16 as '1', default = 8
//Bit  7: 5, reserved.
//Bit  4: 0, reg_mcdi_reldetsadgain1.              gain1 (lmv locked) for qsad, for det. calc. normalized to 16 as '1', default = 8
#define MCDI_REL_DET_GAIN_11                       ((0x2f2c  << 2) + 0xd0100000)
//Bit 31:14, reserved.
//Bit 12: 8, reg_mcdi_reldetchkedgegain1.          gain1 (lmv locked) for chk_edge, for det. calc. normalized to 16 as '1', default = 0
//Bit     7, reserved.
//Bit  6: 0, reg_mcdi_reldetnbrdstgain1.           gain1 (lmv locked) for neighoring dist, for det. calc. normalized to 16 as '1', default = 24
#define MCDI_REL_DET_GAIN_20                       ((0x2f2d  << 2) + 0xd0100000)
//Bit 31:21, reserved.
//Bit 20:16, reg_mcdi_reldetbsgain2.               gain2 (no locked) for bs, for det. calc. normalized to 16 as '1', default = 12
//Bit 15:14, reserved.
//Bit 13: 8, reg_mcdi_reldetbadwgain2.             gain2 (no locked) for badw, for det. calc. normalized to 16 as '1', default = 32
//Bit  7: 5, reserved.
//Bit  4: 0, reg_mcdi_reldetsadgain2.              gain2 (no locked) for qsad, for det. calc. normalized to 16 as '1', default = 16
#define MCDI_REL_DET_GAIN_21                       ((0x2f2e  << 2) + 0xd0100000)
//Bit 31:26, reserved
//Bit 25:16, reg_mcdi_reldetoffst.                 offset for rel calculation, for det. calc. -512~511,  default = 0
//Bit 15:14, reserved.
//Bit 12: 8, reg_mcdi_reldetchkedgegain2.          gain2 (no locked) for chk_edge, for det. calc. normalized to 16 as '1', default = 10
//Bit     7, reserved.
//Bit  6: 0, reg_mcdi_reldetnbrdstgain2.           gain2 (no locked) for neighoring dist, for det. calc. normalized to 16 as '1', default = 32
#define MCDI_REL_DET_GMV_DIF_CHK                   ((0x2f2f  << 2) + 0xd0100000)
//Bit 31:24, reserved.
//Bit 23:16, reg_mcdi_reldetgmvfltthd.             flat thd (>=) for gmv lock decision, default = 0
//Bit    15, reserved.
//Bit 14:12, reg_mcdi_reldetgmvdifthd.             dif thd (>=) for current mv different from gmv for gmv dif check, actually used in Lmv lock check, default = 3
//Bit    11, reserved.
//Bit 10: 8, reg_mcdi_reldetgmvdifmin.             min mv dif for gmv dif check, default = 1, note: dif between reg_mcdi_rel_det_gmv_dif_max and reg_mcdi_rel_det_gmv_dif_min should be; 0,1,3,7, not work for others 
//Bit  7: 4, reg_mcdi_reldetgmvdifmax.             max mv dif for gmv dif check, default = 4
//Bit  3: 1, reserved
//Bit     0, reg_mcdi_reldetgmvdifmvmode.          mv mode used for gmv dif check, 0: use refmv, 1: use qmv, default = 0
#define MCDI_REL_DET_LMV_DIF_CHK                   ((0x2f30  << 2) + 0xd0100000)
//Bit 31:24, reserved.
//Bit 23:16, reg_mcdi_reldetlmvfltthd.             flat thd (>=) for lmv lock decision, default = 12
//Bit 15:14, reserved.
//Bit 13:12, reg_mcdi_reldetlmvlockchkmode.        lmv lock check mode, 0:cur Lmv, 1: cur & (last | next), 2: last & cur & next Lmv, default = 1
//Bit    11, reserved.
//Bit 10: 8, reg_mcdi_reldetlmvdifmin.             min mv dif for lmv dif check, default = 1, note: dif between reg_mcdi_rel_det_lmv_dif_max and reg_mcdi_rel_det_lmv_dif_min should be; 0,1,3,7, not work for others 
//Bit  7: 4, reg_mcdi_reldetlmvdifmax.             max mv dif for lmv dif check, default = 4
//Bit  3: 1, reserved
//Bit     0, reg_mcdi_reldetlmvdifmvmode.          mv mode used for lmv dif check, 0: use refmv, 1: use qmv, default = 0
#define MCDI_REL_DET_FRQ_CHK                       ((0x2f31  << 2) + 0xd0100000)
//Bit 31:12, reserved.
//Bit 11: 8, reg_mcdi_reldetfrqgain.               gain for frequency check, normalized to 4 as '1', default = 10
//Bit  7: 5, reserved
//Bit  4: 0, reg_mcdi_reldetfrqmax.                max value for frequency check, default = 31
#define MCDI_REL_DET_PD22_CHK                      ((0x2f32  << 2) + 0xd0100000)
//Bit 31:18, reserved.
//Bit 17: 8, reg_mcdi_reldetpd22chkoffst.          offset for pd22 check happened, default = 512
//Bit  7: 5, reserved
//Bit  4: 0, reg_mcdi_reldetpd22chkgain.           gain for pd22 check happened, normalized to 8 as '1', default = 12
#define MCDI_REL_DET_RPT_CHK_ROW                   ((0x2f33  << 2) + 0xd0100000)
//Bit 31:27, reserved
//Bit 26:16, reg_mcdi_reldetrptchkendrow.          end row (<) number for repeat check, default = 2047
//Bit 15:11, reserved
//Bit 10: 0, reg_mcdi_reldetrptchkstartrow.        start row (>=) number for repeat check, default = 0
#define MCDI_REL_DET_RPT_CHK_GAIN_QMV              ((0x2f34  << 2) + 0xd0100000)
//Bit 31:30, reserved
//Bit 29:24, reg_mcdi_reldetrptchkqmvmax.          max thd (<) of abs qmv for repeat check, default = 15, note that quarter mv's range is -63~63
//Bit 23:22, reserved
//Bit 21:16, reg_mcdi_reldetrptchkqmvmin.          min thd (>=) of abs qmv for repeat check, default = 10, note that quarter mv's range is -63~63
//Bit    15, reserved/
//Bit 14: 4, reg_mcdi_reldetrptchkoffst.           offset for repeat check, default = 512
//Bit  3: 0, reg_mcdi_reldetrptchkgain.            gain for repeat check, normalized to 8 as '1', default = 4
#define MCDI_REL_DET_RPT_CHK_THD_0                 ((0x2f35  << 2) + 0xd0100000)
//Bit 31:24, reserved
//Bit 23:16, reg_mcdi_reldetrptchkzerosadthd.      zero sad thd (<) for repeat check, default = 255
//Bit 15:14, reserved.
//Bit 13: 8, reg_mcdi_reldetrptchkzerobadwthd.     zero badw thd (>=) for repeat check, default = 16
//Bit  7: 4, reserved
//Bit  3: 0, reg_mcdi_reldetrptchkfrqdifthd.       frequency dif thd (<) for repeat check, 0~10, default = 5
#define MCDI_REL_DET_RPT_CHK_THD_1                 ((0x2f36  << 2) + 0xd0100000)
//Bit 31:16, reserved
//Bit 15: 8, reg_mcdi_reldetrptchkvdifthd.         vertical dif thd (<) for repeat check, default = 16
//Bit  7: 0, reg_mcdi_reldetrptchkhdifthd.         horizontal dif thd (>=) for repeat check, default = 16
#define MCDI_REL_DET_LPF_DIF_THD                   ((0x2f37  << 2) + 0xd0100000)
//Bit 31:24, reg_mcdi_reldetlpfdifthd3.            hdif thd (<) for lpf selection of horizontal block, default = 9
//Bit 23:16, reg_mcdi_reldetlpfdifthd2.            vdif-hdif thd (>=) for lpf selection of horizontal block, default = 48
//Bit 15: 8, reg_mcdi_reldetlpfdifthd1.            vdif thd (<) for lpf selection of vertical block, default = 9
//Bit  7: 0, reg_mcdi_reldetlpfdifthd0.            hdif-vdif thd (>=) for lpf selection of vertical block, default = 48
#define MCDI_REL_DET_LPF_MSK_00_03                 ((0x2f38  << 2) + 0xd0100000)
//Bit 31:29, reserved
//Bit 28:24, reg_mcdi_reldetlpfmsk03.              det lpf mask03 for gmv/lmv locked mode, 0~16, default = 1
//Bit 23:21, reserved
//Bit 20:16, reg_mcdi_reldetlpfmsk02.              det lpf mask02 for gmv/lmv locked mode, 0~16, default = 1
//Bit 15:13, reserved
//Bit 12: 8, reg_mcdi_reldetlpfmsk01.              det lpf mask01 for gmv/lmv locked mode, 0~16, default = 5
//Bit  7: 5, reserved
//Bit  4: 0, reg_mcdi_reldetlpfmsk00.              det lpf mask00 for gmv/lmv locked mode, 0~16, default = 8
#define MCDI_REL_DET_LPF_MSK_04_12                 ((0x2f39  << 2) + 0xd0100000)
//Bit 31:29, reserved
//Bit 28:24, reg_mcdi_reldetlpfmsk12.              det lpf mask12 for vertical blocks, 0~16, default = 0
//Bit 23:21, reserved
//Bit 20:16, reg_mcdi_reldetlpfmsk11.              det lpf mask11 for vertical blocks, 0~16, default = 0
//Bit 15:13, reserved
//Bit 12: 8, reg_mcdi_reldetlpfmsk10.              det lpf mask10 for vertical blocks, 0~16, default = 16
//Bit  7: 5, reserved
//Bit  4: 0, reg_mcdi_reldetlpfmsk04.              det lpf mask04 for gmv/lmv locked mode, 0~16, default = 1
#define MCDI_REL_DET_LPF_MSK_13_21                 ((0x2f3a  << 2) + 0xd0100000)
//Bit 31:29, reserved
//Bit 28:24, reg_mcdi_reldetlpfmsk21.              det lpf mask21 for horizontal blocks, 0~16, default = 6
//Bit 23:21, reserved
//Bit 20:16, reg_mcdi_reldetlpfmsk20.              det lpf mask20 for horizontal blocks, 0~16, default = 8
//Bit 15:13, reserved
//Bit 12: 8, reg_mcdi_reldetlpfmsk14.              det lpf mask14 for vertical blocks, 0~16, default = 0
//Bit  7: 5, reserved
//Bit  4: 0, reg_mcdi_reldetlpfmsk13.              det lpf mask13 for vertical blocks, 0~16, default = 0
#define MCDI_REL_DET_LPF_MSK_22_30                 ((0x2f3b  << 2) + 0xd0100000)
//Bit 31:29, reserved
//Bit 28:24, reg_mcdi_reldetlpfmsk30.              det lpf mask30 for other blocks, 0~16, default = 16
//Bit 23:21, reserved
//Bit 20:16, reg_mcdi_reldetlpfmsk24.              det lpf mask24 for horizontal blocks, 0~16, default = 1
//Bit 15:13, reserved
//Bit 12: 8, reg_mcdi_reldetlpfmsk23.              det lpf mask23 for horizontal blocks, 0~16, default = 0
//Bit  7: 5, reserved
//Bit  4: 0, reg_mcdi_reldetlpfmsk22.              det lpf mask22 for horizontal blocks, 0~16, default = 1
#define MCDI_REL_DET_LPF_MSK_31_34                 ((0x2f3c  << 2) + 0xd0100000)
//Bit 31:29, reserved
//Bit 28:24, reg_mcdi_reldetlpfmsk34.              det lpf mask34 for other blocks, 0~16, default = 0
//Bit 23:21, reserved
//Bit 20:16, reg_mcdi_reldetlpfmsk33.              det lpf mask33 for other blocks, 0~16, default = 0
//Bit 15:13, reserved
//Bit 12: 8, reg_mcdi_reldetlpfmsk32.              det lpf mask32 for other blocks, 0~16, default = 0
//Bit  7: 5, reserved
//Bit  4: 0, reg_mcdi_reldetlpfmsk31.              det lpf mask31 for other blocks, 0~16, default = 0
//Note: there are four group lpf masks from addr 37~3b, each group sum equal to 16.
#define MCDI_REL_DET_MIN                           ((0x2f3d  << 2) + 0xd0100000)
//Bit 31: 7, reserved
//Bit  6: 0, reg_mcdi_reldetmin.                   min of detected value, default = 16
#define MCDI_REL_DET_LUT_0_3                       ((0x2f3e  << 2) + 0xd0100000)
//Bit 31:24, reg_mcdi_reldetmaplut3.               default = 8
//Bit 23:16, reg_mcdi_reldetmaplut2.               default = 4
//Bit 15: 8, reg_mcdi_reldetmaplut1.               default = 2
//Bit  7: 0, reg_mcdi_reldetmaplut0.               default = 0
#define MCDI_REL_DET_LUT_4_7                       ((0x2f3f  << 2) + 0xd0100000)
//Bit 31:24, reg_mcdi_reldetmaplut7.               default = 64
//Bit 23:16, reg_mcdi_reldetmaplut6.               default = 48
//Bit 15: 8, reg_mcdi_reldetmaplut5.               default = 32
//Bit  7: 0, reg_mcdi_reldetmaplut4.               default = 16
#define MCDI_REL_DET_LUT_8_11                      ((0x2f40  << 2) + 0xd0100000)
//Bit 31:24, reg_mcdi_reldetmaplut11.              default = 160
//Bit 23:16, reg_mcdi_reldetmaplut10.              default = 128
//Bit 15: 8, reg_mcdi_reldetmaplut9.               default = 96
//Bit  7: 0, reg_mcdi_reldetmaplut8.               default = 80
#define MCDI_REL_DET_LUT_12_15                     ((0x2f41  << 2) + 0xd0100000)
//Bit 31:24, reg_mcdi_reldetmaplut15.              default = 255
//Bit 23:16, reg_mcdi_reldetmaplut14.              default = 240
//Bit 15: 8, reg_mcdi_reldetmaplut13.              default = 224
//Bit  7: 0, reg_mcdi_reldetmaplut12.              default = 192
#define MCDI_REL_DET_COL_CFD_THD                   ((0x2f42  << 2) + 0xd0100000)
//Bit 31:24, reg_mcdi_reldetcolcfdfltthd.          thd for flat smaller than (<) of column cofidence, default = 5
//Bit 23:16, reg_mcdi_reldetcolcfdthd1.            thd for rel larger than (>=) in rel calc. mode col confidence without gmv locking, default = 160
//Bit 15: 8, reg_mcdi_reldetcolcfdthd0.            thd for rel larger than (>=) in rel calc. mode col confidence when gmv locked, default = 100
//Bit  7: 2, reg_mcdi_reldetcolcfdbadwthd.         thd for badw larger than (>=) in qbadw calc. mode of column cofidence, default = 16
//Bit     1, reserved
//Bit     0, reg_mcdi_reldetcolcfdcalcmode.        calc. mode for column cofidence, 0: use rel, 1: use qbadw, default = 0
#define MCDI_REL_DET_COL_CFD_AVG_LUMA              ((0x2f43  << 2) + 0xd0100000)
//Bit 31:24, reg_mcdi_reldetcolcfdavgmin1.         avg luma min1 (>=) for column cofidence, valid between 16~235, default = 235
//Bit 23:16, reg_mcdi_reldetcolcfdavgmax1.         avg luma max1 (<)  for column cofidence, valid between 16~235, default = 235
//Bit 15: 8, reg_mcdi_reldetcolcfdavgmin0.         avg luma min0 (>=) for column cofidence, valid between 16~235, default = 16
//Bit  7: 0, reg_mcdi_reldetcolcfdavgmax0.         avg luma max0 (<)  for column cofidence, valid between 16~235, default = 21
#define MCDI_REL_DET_BAD_THD_0                     ((0x2f44  << 2) + 0xd0100000)
//Bit 31:16, reserved
//Bit 15: 8, reg_mcdi_reldetbadsadthd.             thd (>=) for bad sad, default = 120 (480/4)
//Bit  7: 6, reserved
//Bit  5: 0, reg_mcdi_reldetbadbadwthd.            thd (>=) for bad badw, 0~42, default = 12
#define MCDI_REL_DET_BAD_THD_1                     ((0x2f45  << 2) + 0xd0100000)
//Bit 31:24, reserved
//Bit 23:16, reg_mcdi_reldetbadrelfltthd.          thd (>=) of flat for bad rel detection, default = 4
//Bit 15: 8, reg_mcdi_reldetbadrelthd1.            thd (>=) for bad rel without gmv/lmv locked, default = 160
//Bit  7: 0, reg_mcdi_reldetbadrelthd0.            thd (>=) for bad rel with gmv/lmv locked, default = 120
#define MCDI_PD22_CHK_THD                          ((0x2f46  << 2) + 0xd0100000)
//Bit 31:25, reserved
//Bit 24:16, reg_mcdi_pd22chksaddifthd.            sad dif thd (>=) for (pd22chksad - qsad) for pd22 check, default = 64
//Bit 15:14, reserved
//Bit 13: 8, reg_mcdi_pd22chkqmvthd.               thd (>=) of abs qmv for pd22 check, default = 2
//Bit  7: 0, reg_mcdi_pd22chkfltthd.               thd (>=) of flat for pd22 check, default = 4
#define MCDI_PD22_CHK_GAIN_OFFST_0                 ((0x2f47  << 2) + 0xd0100000)
//Bit 31:24, reg_mcdi_pd22chkedgeoffst0.           offset0 of pd22chkedge from right film22 phase, -128~127, default = 0
//Bit 23:21, reserved
//Bit 20:16, reg_mcdi_pd22chkedgegain0.            gain0 of pd22chkedge from right film22 phase, normalized to 16 as '1', default = 16
//Bit 15:12, reserved
//Bit 11: 8, reg_mcdi_pd22chkbadwoffst0.           offset0 of pd22chkbadw from right film22 phase, -8~7, default = 0
//Bit  7: 5, reserved
//Bit  4: 0, reg_mcdi_pd22chkbadwgain0.            gain0 of pd22chkbadw from right film22 phase, normalized to 16 as '1', default = 8
#define MCDI_PD22_CHK_GAIN_OFFST_1                 ((0x2f48  << 2) + 0xd0100000)
//Bit 31:24, reg_mcdi_pd22chkedgeoffst1.           offset1 of pd22chkedge from right film22 phase, -128~127, default = 0
//Bit 23:21, reserved
//Bit 20:16, reg_mcdi_pd22chkedgegain1.            gain1 of pd22chkedge from right film22 phase, normalized to 16 as '1', default = 16
//Bit 15:12, reserved
//Bit 11: 8, reg_mcdi_pd22chkbadwoffst1.           offset1 of pd22chkbadw from right film22 phase, -8~7, default = 0
//Bit  7: 5, reserved
//Bit  4: 0, reg_mcdi_pd22chkbadwgain1.            gain1 of pd22chkbadw from right film22 phase, normalized to 16 as '1', default = 12
#define MCDI_LMV_LOCK_CNT_THD_GAIN                 ((0x2f49  << 2) + 0xd0100000)
//Bit 31:20, reserved
//Bit 19:16, reg_mcdi_lmvlockcntmax.               max lmv lock count number, default = 6
//Bit 15:12, reg_mcdi_lmvlockcntoffst.             offset for lmv lock count, -8~7, default =  0
//Bit 11: 8, reg_mcdi_lmvlockcntgain.              gain for lmv lock count, normalized 8 as '1', 15 is set to 16, default = 8
//Bit  7: 5, reserved
//Bit  4: 0, reg_mcdi_lmvlockcntthd.               lmv count thd (>=) before be locked, 1~31, default = 4 
#define MCDI_LMV_LOCK_ABS_DIF_THD                  ((0x2f4a  << 2) + 0xd0100000)
//Bit 31:27, reserved
//Bit 26:24, reg_mcdi_lmvlockdifthd2.              lmv dif thd for third part, before locked, default = 1
//Bit    23, reserved
//Bit 22:20, reg_mcdi_lmvlockdifthd1.              lmv dif thd for second part, before locked, default = 1
//Bit    19, reserved
//Bit 18:16, reg_mcdi_lmvlockdifthd0.              lmv dif thd for first part, before locked, default = 1
//Bit 15:13, reserved
//Bit 12: 8, reg_mcdi_lmvlockabsmax.               max abs (<) of lmv to be locked, default = 24 
//Bit  7: 5, reserved
//Bit  4: 0, reg_mcdi_lmvlockabsmin.               min abs (>=) of lmv to be locked, default = 1 
#define MCDI_LMV_LOCK_ROW                          ((0x2f4b  << 2) + 0xd0100000)
//Bit 31:27, reserved
//Bit 26:16, reg_mcdi_lmvlockendrow.               end row (<) for lmv lock, default = 2047
//Bit 15:11, reserved
//Bit 10: 0, reg_mcdi_lmvlockstartrow.             start row (>=) for lmv lock, default = 0
#define MCDI_LMV_LOCK_RT_MODE                      ((0x2f4c  << 2) + 0xd0100000)
//Bit 31:27, reserved
//Bit 26:24, reg_mcdi_lmvlockextmode.              extend lines for lmv lock check, check how many lines for lmv locking, default = 2
//Bit 23:16, reg_mcdi_lmvlockfltcntrt.             ratio of flt cnt for lock check, normalized 256 as '1', 255 is set to 256, default = 32
//Bit 15: 8, reg_mcdi_lmvlocklmvcntrt1.            ratio when use non-zero lmv for lock check, normalized 256 as '1', 255 is set to 256, default = 48
//Bit  7: 0, reg_mcdi_lmvlocklmvcntrt0.            ratio when use max lmv for lock check, normalized 256 as '1', 255 is set to 256, default = 106
#define MCDI_GMV_LOCK_CNT_THD_GAIN                 ((0x2f4d  << 2) + 0xd0100000)
//Bit 31:20, reserved
//Bit 19:16, reg_mcdi_gmvlockcntmax.               max gmv lock count number, default = 6
//Bit 15:12, reg_mcdi_gmvlockcntoffst.             offset for gmv lock count, -8~7, default =  0
//Bit 11: 8, reg_mcdi_gmvlockcntgain.              gain for gmv lock count, normalized 8 as '1', 15 is set to 16, default = 8
//Bit  7: 5, reserved
//Bit  4: 0, reg_mcdi_gmvlockcntthd.               gmv count thd (>=) before be locked, 1~31, default = 4 
#define MCDI_GMV_LOCK_ABS_DIF_THD                  ((0x2f4e  << 2) + 0xd0100000)
//Bit 31:27, reserved
//Bit 26:24, reg_mcdi_gmvlockdifthd2.              gmv dif thd for third part, before locked, default = 3
//Bit    23, reserved
//Bit 22:20, reg_mcdi_gmvlockdifthd1.              gmv dif thd for second part, before locked, default = 2
//Bit    19, reserved
//Bit 18:16, reg_mcdi_gmvlockdifthd0.              gmv dif thd for first part, before locked, default = 1
//Bit 15:13, reserved
//Bit 12: 8, reg_mcdi_gmvlockabsmax.               max abs of gmv to be locked, default = 15 
//Bit  7: 5, reserved
//Bit  4: 0, reg_mcdi_gmvlockabsmin.               min abs of gmv to be locked, default = 1 
#define MCDI_HIGH_VERT_FRQ_DIF_THD                 ((0x2f4f  << 2) + 0xd0100000)
//Bit 31: 0, reg_mcdi_highvertfrqfldavgdifthd.     high_vert_frq field average luma dif thd (>=), 3*Blk_Width*Blk_Height, set by software, default = 103680
#define MCDI_HIGH_VERT_FRQ_DIF_DIF_THD             ((0x2f50  << 2) + 0xd0100000)
//Bit 31: 0, reg_mcdi_highvertfrqfldavgdifdifthd.  high_vert_frq field average luma dif's dif thd (<), 3*Blk_Width*Blk_Height, set by software, default = 103680
#define MCDI_HIGH_VERT_FRQ_RT_GAIN                 ((0x2f51  << 2) + 0xd0100000)
//Bit 31:20, reserved
//Bit 19:16, reg_mcdi_highvertfrqcntthd.           high_vert_frq count thd (>=) before locked, 1~31, default = 4
//Bit 15: 8, reg_mcdi_highvertfrqbadsadrt.         ratio for high_vert_frq bad sad count, normalized 256 as '1', 255 is set to 256, default = 24
//Bit  7: 0, reg_mcdi_highvertfrqbadbadwrt.        ratio for high_vert_frq badw count, normalized 256 as '1', 255 is set to 256, default = 130
#define MCDI_MOTION_PARADOX_THD                    ((0x2f52  << 2) + 0xd0100000)
//Bit 31:29, reserved
//Bit 28:24, reg_mcdi_motionparadoxcntthd.         motion paradox count thd (>=) before locked, 1~31, default = 4
//Bit 23:22, reserved
//Bit 21:16, reg_mcdi_motionparadoxgmvthd.         abs gmv thd (<) of motion paradox, 0~32, note that 32 means invalid gmv, be careful, default = 32 
//Bit 15: 0, reserved
#define MCDI_MOTION_PARADOX_RT                     ((0x2f53  << 2) + 0xd0100000)
//Bit 31:24, reserved
//Bit 23:16, reg_mcdi_motionparadoxbadsadrt.       ratio for field bad sad count of motion paradox, normalized 256 as '1', 255 is set to 256, default = 24
//Bit 15: 8, reg_mcdi_motionparadoxbadrelrt.       ratio for field bad reliabilty count of motion paradox, normalized 256 as '1', 255 is set to 256, default = 120
//Bit  7: 0, reg_mcdi_motionparadoxmtnrt.          ratio for field motion count of motion paradox, normalized 256 as '1', 255 is set to 256, default = 218
#define MCDI_MOTION_REF_THD                        ((0x2f54  << 2) + 0xd0100000)
//Bit 31:24, reserved
//Bit 23:20, reg_mcdi_motionrefoffst.              motion ref additive offset, default = 15
//Bit 19:16, reg_mcdi_motionrefgain.               motion ref gain, normalized 8 as '1', default = 8
//Bit 15:13, reserved
//Bit 12: 8, reg_mcdi_motionrefrptmvthd.           abs thd (>=) of rpt mv (0~31, 32 means invalid) for motion ref, default = 1
//Bit  7: 2, reg_mcdi_motionrefqmvthd.             min thd (>=) of abs qmv for motion ref, note that quarter mv's range is -63~63, default = 2
//Bit  1: 0, reg_mcdi_motionreflpfmode.            Mv and (8 x repeat flg) 's lpf mode of motion refinement, 0: no lpf, 1: [1 2 1], 2: [1 2 2 2 1], default = 1
#define MCDI_REL_COL_REF_RT                        ((0x2f55  << 2) + 0xd0100000)
//Bit 31: 8, reserved
//Bit  7: 0, reg_mcdi_relcolrefrt.                 ratio for column cofidence level against column number, for refinement, default = 135
#define MCDI_PD22_CHK_THD_RT                       ((0x2f56  << 2) + 0xd0100000)
//Bit 31:27, reserved
//Bit 26:16, reg_mcdi_pd22chkfltcntrt.             ratio for flat count of field pulldown 22 check, normalized 2048 as '1', 2047 is set to 2048, default = 1
//Bit 15: 8, reg_mcdi_pd22chkcntrt.                ratio of pulldown 22 check count, normalized 256 as '1', 255 is set to 256, default = 100
//Bit  7: 5, reserved
//Bit  4: 0, reg_mcdi_pd22chkcntthd.               thd (>=) for pd22 count before locked, 1~31, default = 4
#define MCDI_CHAR_DET_DIF_THD                      ((0x2f57  << 2) + 0xd0100000)
//Bit 31:24, reserved
//Bit 23:16, reg_mcdi_chardetminmaxdifthd.         thd (>=) for dif between min and max value, default = 64
//Bit 15: 8, reg_mcdi_chardetmaxdifthd.            thd (<) for dif between max value, default = 17
//Bit  7: 0, reg_mcdi_chardetmindifthd.            thd (<) for dif between min value, default = 17
#define MCDI_CHAR_DET_CNT_THD                      ((0x2f58  << 2) + 0xd0100000)
//Bit 31:21, reserved
//Bit 20:16, reg_mcdi_chardettotcntthd.            thd (>=) for total count, 0~21, default = 18
//Bit 15:13, reserved
//Bit 12: 8, reg_mcdi_chardetmaxcntthd.            thd (>=) for max count, 0~21, default = 1
//Bit  7: 5, reserved
//Bit  4: 0, reg_mcdi_chardetmincntthd.            thd (>=) for min count, 0~21, default = 1
#define MCDI_FIELD_MV                              ((0x2f60  << 2) + 0xd0100000)
//Bit 31:24, reg_mcdi_pd22chkcnt                   
//Bit 23:16, reg_mcdi_fieldgmvcnt
//Bit    15, reg_mcdi_pd22chkflg
//Bit    14, reg_mcdi_fieldgmvlock
//Bit 13: 8, reg_mcdi_fieldrptmv.    	           last field rpt mv 
//Bit  7: 6, reserved
//Bit  5: 0, reg_mcdi_fieldgmv.                    last field gmv 
#define MCDI_FIELD_HVF_PRDX_CNT                    ((0x2f61  << 2) + 0xd0100000)
//Bit 31:24, reg_mcdi_motionparadoxcnt.
//Bit 23:17, reserved
//Bit    16, reg_mcdi_motionparadoxflg.
//Bit 15: 8, reg_mcdi_highvertfrqcnt.    
//Bit  7: 4, reserved	          
//Bit  3: 2, reg_mcdi_highvertfrqphase.
//Bit     1, reserved
//Bit     0, reg_mcdi_highvertfrqflg.              
#define MCDI_FIELD_LUMA_AVG_SUM_0                  ((0x2f62  << 2) + 0xd0100000)
//Bit 31: 0, reg_mcdi_fld_luma_avg_sum0.           
#define MCDI_FIELD_LUMA_AVG_SUM_1                  ((0x2f63  << 2) + 0xd0100000)
//Bit 31: 0, reg_mcdi_fld_luma_avg_sum1.
#define MCDI_YCBCR_BLEND_CRTL                      ((0x2f64  << 2) + 0xd0100000)
//Bit 31:16, reserved
//Bit 15: 8, reg_mcdi_ycbcrblendgain.              ycbcr blending gain for cbcr in ycbcr. default = 0
//Bit  7: 2, reserved.
//Bit  1: 0, reg_mcdi_ycbcrblendmode.              0:y+cmb(cb,cr), 1:med(r,g,b), 2:max(r,g,b), default = 2              
#define MCDI_MCVECWR_CANVAS_SIZE                   ((0x2f65  << 2) + 0xd0100000)
#define MCDI_MCVECRD_CANVAS_SIZE                   ((0x2f66  << 2) + 0xd0100000)
#define MCDI_MCINFOWR_CANVAS_SIZE                  ((0x2f67  << 2) + 0xd0100000)
#define MCDI_MCINFORD_CANVAS_SIZE                  ((0x2f68  << 2) + 0xd0100000)
#define MCDI_MCVECWR_X                             ((0x2f92  << 2) + 0xd0100000)
#define MCDI_MCVECWR_Y                             ((0x2f93  << 2) + 0xd0100000)
#define MCDI_MCVECWR_CTRL                          ((0x2f94  << 2) + 0xd0100000)
#define MCDI_MCVECRD_X                             ((0x2f95  << 2) + 0xd0100000)
#define MCDI_MCVECRD_Y                             ((0x2f96  << 2) + 0xd0100000)
#define MCDI_MCVECRD_CTRL                          ((0x2f97  << 2) + 0xd0100000)
#define MCDI_MCINFOWR_X                            ((0x2f98  << 2) + 0xd0100000)
#define MCDI_MCINFOWR_Y                            ((0x2f99  << 2) + 0xd0100000)
#define MCDI_MCINFOWR_CTRL                         ((0x2f9a  << 2) + 0xd0100000)
#define MCDI_MCINFORD_X                            ((0x2f9b  << 2) + 0xd0100000)
#define MCDI_MCINFORD_Y                            ((0x2f9c  << 2) + 0xd0100000)
#define MCDI_MCINFORD_CTRL                         ((0x2f9d  << 2) + 0xd0100000)
// ================================================================== MC registers ========================================================================================================
#define MCDI_MC_CRTL                               ((0x2f70  << 2) + 0xd0100000)
//Bit 31: 9, reserved
//Bit     8, reg_mcdi_mcpreflg.                    flag to use previous field for MC, 0:forward field, 1: previous field, default = 1 
//Bit     7, reg_mcdi_mcrelrefbycolcfden.          enable rel refinement by column cofidence in mc blending, default = 1
//Bit  6: 5, reg_mcdi_mclpfen.                     enable mc pixles/rel lpf, 0:disable, 1: lpf rel, 2: lpf mc pxls, 3: lpf both rel and mc pxls, default = 0
//Bit  4: 2, reg_mcdi_mcdebugmode.                 enable mc debug mode, 0:disable, 1: split left/right, 2: split top/bottom, 3: debug mv, 4: debug rel, default = 0
//Bit  1: 0, reg_mcdi_mcen.                        mcdi enable mode, 0:disable, 1: blend with ma, 2: full mc, default = 1
#define MCDI_MC_LPF_MSK_0                          ((0x2f71  << 2) + 0xd0100000)
//Bit 31:21, reserved
//Bit 20:16, reg_mcdi_mclpfmsk02.                  mc lpf coef. 2 for pixel 0 of current block, normalized 16 as '1', default = 0
//Bit 15:13, reserved
//Bit 12: 8, reg_mcdi_mclpfmsk01.                  mc lpf coef. 1 for pixel 0 of current block, normalized 16 as '1', default = 9
//Bit  7: 5, reserved
//Bit  4: 0, reg_mcdi_mclpfmsk00.                  mc lpf coef. 0 for pixel 0 of current block, normalized 16 as '1', default = 7
#define MCDI_MC_LPF_MSK_1                          ((0x2f72  << 2) + 0xd0100000)
//Bit 31:21, reserved
//Bit 20:16, reg_mcdi_mclpfmsk12.                  mc lpf coef. 2 for pixel 1 of current block, 0~16, normalized 16 as '1', default = 0
//Bit 15:13, reserved
//Bit 12: 8, reg_mcdi_mclpfmsk11.                  mc lpf coef. 1 for pixel 1 of current block, 0~16, normalized 16 as '1', default = 11
//Bit  7: 5, reserved
//Bit  4: 0, reg_mcdi_mclpfmsk10.                  mc lpf coef. 0 for pixel 1 of current block, 0~16, normalized 16 as '1', default = 5
#define MCDI_MC_LPF_MSK_2                          ((0x2f73  << 2) + 0xd0100000)
//Bit 31:21, reserved
//Bit 20:16, reg_mcdi_mclpfmsk22.                  mc lpf coef. 2 for pixel 2 of current block, 0~16, normalized 16 as '1', default = 1
//Bit 15:13, reserved
//Bit 12: 8, reg_mcdi_mclpfmsk21.                  mc lpf coef. 1 for pixel 2 of current block, 0~16, normalized 16 as '1', default = 14
//Bit  7: 5, reserved
//Bit  4: 0, reg_mcdi_mclpfmsk20.                  mc lpf coef. 0 for pixel 2 of current block, 0~16, normalized 16 as '1', default = 1
#define MCDI_MC_LPF_MSK_3                          ((0x2f74  << 2) + 0xd0100000)
//Bit 31:21, reserved
//Bit 20:16, reg_mcdi_mclpfmsk32.                  mc lpf coef. 2 for pixel 3 of current block, 0~16, normalized 16 as '1', default = 5
//Bit 15:13, reserved
//Bit 12: 8, reg_mcdi_mclpfmsk31.                  mc lpf coef. 1 for pixel 3 of current block, 0~16, normalized 16 as '1', default = 11
//Bit  7: 5, reserved
//Bit  4: 0, reg_mcdi_mclpfmsk30.                  mc lpf coef. 0 for pixel 3 of current block, 0~16, normalized 16 as '1', default = 0
#define MCDI_MC_LPF_MSK_4                          ((0x2f75  << 2) + 0xd0100000)
//Bit 31:21, reserved
//Bit 20:16, reg_mcdi_mclpfmsk42.                  mc lpf coef. 2 for pixel 4 of current block, 0~16, normalized 16 as '1', default = 7
//Bit 15:13, reserved
//Bit 12: 8, reg_mcdi_mclpfmsk41.                  mc lpf coef. 1 for pixel 4 of current block, 0~16, normalized 16 as '1', default = 9
//Bit  7: 5, reserved
//Bit  4: 0, reg_mcdi_mclpfmsk40.                  mc lpf coef. 0 for pixel 4 of current block, 0~16, normalized 16 as '1', default = 0
#define MCDI_MC_REL_GAIN_OFFST_0                   ((0x2f76  << 2) + 0xd0100000)
//Bit 31:26, reserved
//Bit    25, reg_mcdi_mcmotionparadoxflg.          flag of motion paradox, initial with 0 and read from software, default = 0
//Bit    24, reg_mcdi_mchighvertfrqflg.            flag of high vert frq, initial with 0 and read from software, default = 0
//Bit 23:16, reg_mcdi_mcmotionparadoxoffst.        offset (rel + offset) for rel (MC blending coef.) refinement if motion paradox detected before MC blending before MC blending, default = 128
//Bit 15:12, reserved
//Bit 11: 8, reg_mcdi_mcmotionparadoxgain.         gain for rel (MC blending coef.) refinement if motion paradox detected before MC blending, normalized 8 as '1', set 15 to 16, default = 8
//Bit  7: 4, reg_mcdi_mchighvertfrqoffst.          minus offset (alpha - offset) for motion (MA blending coef.) refinement if high vertical frequency detected before MA blending, default = 15
//Bit  3: 0, reg_mcdi_mchighvertfrqgain.           gain for motion (MA blending coef.) refinement if high vertical frequency detected before MA blending, normalized 8 as '1', set 15 to 16, default = 8
#define MCDI_MC_REL_GAIN_OFFST_1                   ((0x2f77  << 2) + 0xd0100000)
//Bit 31:24, reg_mcdi_mcoutofboundrayoffst.        offset (rel + offset) for rel (MC blending coef.) refinement if MC pointed out of boundray before MC blending before MC blending, default = 255
//Bit 23:20, reserved
//Bit 19:16, reg_mcdi_mcoutofboundraygain.         gain for rel (MC blending coef.) refinement if MC pointed out of boundray before MC blending, normalized 8 as '1', set 15 to 16, default = 8
//Bit 15: 8, reg_mcdi_mcrelrefbycolcfdoffst.       offset (rel + offset) for rel (MC blending coef.) refinement if motion paradox detected before MC blending before MC blending, default = 255
//Bit  7: 4, reserved.
//Bit  3: 0, reg_mcdi_mcrelrefbycolcfdgain.        gain for rel (MC blending coef.) refinement if column cofidence failed before MC blending, normalized 8 as '1', set 15 to 16, default = 8
#define MCDI_MC_COL_CFD_0                          ((0x2f78  << 2) + 0xd0100000)
//Bit 31: 0, mcdi_mc_col_cfd_0.                    column cofidence value 0 read from software. initial = 0
#define MCDI_MC_COL_CFD_1                          ((0x2f79  << 2) + 0xd0100000)
//Bit 31: 0, mcdi_mc_col_cfd_1.                    column cofidence value 1 read from software. initial = 0
#define MCDI_MC_COL_CFD_2                          ((0x2f7a  << 2) + 0xd0100000)
//Bit 31: 0, mcdi_mc_col_cfd_2.                    column cofidence value 2 read from software. initial = 0
#define MCDI_MC_COL_CFD_3                          ((0x2f7b  << 2) + 0xd0100000)
//Bit 31: 0, mcdi_mc_col_cfd_3.                    column cofidence value 3 read from software. initial = 0
#define MCDI_MC_COL_CFD_4                          ((0x2f7c  << 2) + 0xd0100000)
//Bit 31: 0, mcdi_mc_col_cfd_4.                    column cofidence value 4 read from software. initial = 0
#define MCDI_MC_COL_CFD_5                          ((0x2f7d  << 2) + 0xd0100000)
//Bit 31: 0, mcdi_mc_col_cfd_5.                    column cofidence value 5 read from software. initial = 0
#define MCDI_MC_COL_CFD_6                          ((0x2f7e  << 2) + 0xd0100000)
//Bit 31: 0, mcdi_mc_col_cfd_6.                    column cofidence value 6 read from software. initial = 0
#define MCDI_MC_COL_CFD_7                          ((0x2f7f  << 2) + 0xd0100000)
//Bit 31: 0, mcdi_mc_col_cfd_7.                    column cofidence value 7 read from software. initial = 0
#define MCDI_MC_COL_CFD_8                          ((0x2f80  << 2) + 0xd0100000)
//Bit 31: 0, mcdi_mc_col_cfd_8.                    column cofidence value 8 read from software. initial = 0
#define MCDI_MC_COL_CFD_9                          ((0x2f81  << 2) + 0xd0100000)
//Bit 31: 0, mcdi_mc_col_cfd_9.                    column cofidence value 9 read from software. initial = 0
#define MCDI_MC_COL_CFD_10                         ((0x2f82  << 2) + 0xd0100000)
//Bit 31: 0, mcdi_mc_col_cfd_10.                   column cofidence value 10 read from software. initial = 0
#define MCDI_MC_COL_CFD_11                         ((0x2f83  << 2) + 0xd0100000)
//Bit 31: 0, mcdi_mc_col_cfd_11.                   column cofidence value 11 read from software. initial = 0
#define MCDI_MC_COL_CFD_12                         ((0x2f84  << 2) + 0xd0100000)
//Bit 31: 0, mcdi_mc_col_cfd_12.                   column cofidence value 12 read from software. initial = 0
#define MCDI_MC_COL_CFD_13                         ((0x2f85  << 2) + 0xd0100000)
//Bit 31: 0, mcdi_mc_col_cfd_13.                   column cofidence value 13 read from software. initial = 0
#define MCDI_MC_COL_CFD_14                         ((0x2f86  << 2) + 0xd0100000)
//Bit 31: 0, mcdi_mc_col_cfd_14.                   column cofidence value 14 read from software. initial = 0
#define MCDI_MC_COL_CFD_15                         ((0x2f87  << 2) + 0xd0100000)
//Bit 31: 0, mcdi_mc_col_cfd_15.                   column cofidence value 15 read from software. initial = 0
#define MCDI_MC_COL_CFD_16                         ((0x2f88  << 2) + 0xd0100000)
//Bit 31: 0, mcdi_mc_col_cfd_16.                   column cofidence value 16 read from software. initial = 0
#define MCDI_MC_COL_CFD_17                         ((0x2f89  << 2) + 0xd0100000)
//Bit 31: 0, mcdi_mc_col_cfd_17.                   column cofidence value 17 read from software. initial = 0
#define MCDI_MC_COL_CFD_18                         ((0x2f8a  << 2) + 0xd0100000)
//Bit 31: 0, mcdi_mc_col_cfd_18.                   column cofidence value 18 read from software. initial = 0
#define MCDI_MC_COL_CFD_19                         ((0x2f8b  << 2) + 0xd0100000)
//Bit 31: 0, mcdi_mc_col_cfd_19.                   column cofidence value 19 read from software. initial = 0
#define MCDI_MC_COL_CFD_20                         ((0x2f8c  << 2) + 0xd0100000)
//Bit 31: 0, mcdi_mc_col_cfd_20.                   column cofidence value 20 read from software. initial = 0
#define MCDI_MC_COL_CFD_21                         ((0x2f8d  << 2) + 0xd0100000)
//Bit 31: 0, mcdi_mc_col_cfd_21.                   column cofidence value 21 read from software. initial = 0
#define MCDI_MC_COL_CFD_22                         ((0x2f8e  << 2) + 0xd0100000)
//Bit 31: 0, mcdi_mc_col_cfd_22.                   column cofidence value 22 read from software. initial = 0
#define MCDI_MC_COL_CFD_23                         ((0x2f8f  << 2) + 0xd0100000)
//Bit 31: 0, mcdi_mc_col_cfd_23.                   column cofidence value 23 read from software. initial = 0
#define MCDI_MC_COL_CFD_24                         ((0x2f90  << 2) + 0xd0100000)
//Bit 31: 0, mcdi_mc_col_cfd_24.                   column cofidence value 24 read from software. initial = 0
#define MCDI_MC_COL_CFD_25                         ((0x2f91  << 2) + 0xd0100000)
//Bit 31: 0, mcdi_mc_col_cfd_25.                   column cofidence value 25 read from software. initial = 0
// ===================================================================================== PRE RO Registers ==========================================================================================
#define MCDI_RO_FLD_LUMA_AVG_SUM                   ((0x2fa0  << 2) + 0xd0100000)
//Bit 31: 0, ro_mcdi_fldlumaavgsum.                block's luma avg sum of current filed (block based). initial = 0
#define MCDI_RO_GMV_VLD_CNT                        ((0x2fa1  << 2) + 0xd0100000)
//Bit 31: 0, ro_mcdi_gmvvldcnt.                    valid gmv's count of pre one filed (block based). initial = 0
#define MCDI_RO_RPT_FLG_CNT                        ((0x2fa2  << 2) + 0xd0100000)
//Bit 31: 0, ro_mcdi_rptflgcnt.                    repeat mv's count of pre one filed (block based). initial = 0
#define MCDI_RO_FLD_BAD_SAD_CNT                    ((0x2fa3  << 2) + 0xd0100000)
//Bit 31: 0, ro_mcdi_fldbadsadcnt.                 bad sad count of whole pre one field (block based). initial = 0
#define MCDI_RO_FLD_BAD_BADW_CNT                   ((0x2fa4  << 2) + 0xd0100000)
//Bit 31: 0, ro_mcdi_fldbadbadwcnt.                bad badw count of whole pre one field (block based). initial = 0
#define MCDI_RO_FLD_BAD_REL_CNT                    ((0x2fa5  << 2) + 0xd0100000)
//Bit 31: 0, ro_mcdi_fldbadrelcnt.                 bad rel count of whole pre one field (block based). initial = 0
#define MCDI_RO_FLD_MTN_CNT                        ((0x2fa6  << 2) + 0xd0100000)
//Bit 31: 0, ro_mcdi_fldmtncnt.                    motion count of whole pre one field (pixel based). initial = 0
#define MCDI_RO_FLD_VLD_CNT                        ((0x2fa7  << 2) + 0xd0100000)
//Bit 31: 0, ro_mcdi_fldvldcnt.                    valid motion count of whole pre one field (pixel based). initial = 0
#define MCDI_RO_FLD_PD_22_PRE_CNT                  ((0x2fa8  << 2) + 0xd0100000)
//Bit 31: 0, ro_mcdi_fldpd22precnt.                prevoius pd22 check count of whole pre one field (block based). initial = 0
#define MCDI_RO_FLD_PD_22_FOR_CNT                  ((0x2fa9  << 2) + 0xd0100000)
//Bit 31: 0, ro_mcdi_fldpd22forcnt.                forward pd22 check count of whole pre one field (block based). initial = 0
#define MCDI_RO_FLD_PD_22_FLT_CNT                  ((0x2faa  << 2) + 0xd0100000)
//Bit 31: 0, ro_mcdi_fldpd22fltcnt.                flat count (for pd22 check) of whole pre one field (block based). initial = 0
#define MCDI_RO_HIGH_VERT_FRQ_FLG                  ((0x2fab  << 2) + 0xd0100000)
//Bit 31:16, reserved.
//Bit 15: 8, ro_mcdi_highvertfrqcnt.               high vertical frequency count till prevoius one field. initial = 0
//Bit  7: 3, reserved.
//Bit  2: 1, ro_mcdi_highvertfrqphase.             high vertical frequency phase of prevoius one field. initial = 2
//Bit     0, ro_mcdi_highvertfrqflg.               high vertical frequency flag of prevoius one field. initial = 0
#define MCDI_RO_GMV_LOCK_FLG                       ((0x2fac  << 2) + 0xd0100000)
//Bit 31:16, reserved.
//Bit 15: 8, ro_mcdi_gmvlckcnt.                    global mv lock count till prevoius one field. initial = 0
//Bit  7: 2, ro_mcdi_gmv.                          global mv of prevoius one field. -31~31, initial = 32 (invalid value)
//Bit     1, ro_mcdi_zerogmvlckflg.                zero global mv lock flag of prevoius one field. initial = 0
//Bit     0, ro_mcdi_gmvlckflg.                    global mv lock flag of prevoius one field. initial = 0
#define MCDI_RO_RPT_MV                             ((0x2fad  << 2) + 0xd0100000)
//Bit 5: 0, ro_mcdi_rptmv.                         repeate mv of prevoius one field. -31~31, initial = 32 (invalid value)
#define MCDI_RO_MOTION_PARADOX_FLG                 ((0x2fae  << 2) + 0xd0100000)
//Bit 31:16, reserved.
//Bit 15: 8, ro_mcdi_motionparadoxcnt.             motion paradox count till prevoius one field. initial = 0
//Bit  7: 1, reserved. 
//Bit     0, ro_mcdi_motionparadoxflg.             motion paradox flag of prevoius one field. initial = 0
#define MCDI_RO_PD_22_FLG                          ((0x2faf  << 2) + 0xd0100000)
//Bit 31:16, reserved.
//Bit 15: 8, ro_mcdi_pd22cnt.                      pull down 22 count till prevoius one field. initial = 0
//Bit  7: 1, reserved. 
//Bit     0, ro_mcdi_pd22flg.                      pull down 22 flag of prevoius one field. initial = 0
#define MCDI_RO_COL_CFD_0                          ((0x2fb0  << 2) + 0xd0100000)
//Bit 31: 0, ro_mcdi_col_cfd_0.                    column cofidence value 0. initial = 0
#define MCDI_RO_COL_CFD_1                          ((0x2fb1  << 2) + 0xd0100000)
//Bit 31: 0, ro_mcdi_col_cfd_1.                    column cofidence value 1. initial = 0
#define MCDI_RO_COL_CFD_2                          ((0x2fb2  << 2) + 0xd0100000)
//Bit 31: 0, ro_mcdi_col_cfd_2.                    column cofidence value 2. initial = 0
#define MCDI_RO_COL_CFD_3                          ((0x2fb3  << 2) + 0xd0100000)
//Bit 31: 0, ro_mcdi_col_cfd_3.                    column cofidence value 3. initial = 0
#define MCDI_RO_COL_CFD_4                          ((0x2fb4  << 2) + 0xd0100000)
//Bit 31: 0, ro_mcdi_col_cfd_4.                    column cofidence value 4. initial = 0
#define MCDI_RO_COL_CFD_5                          ((0x2fb5  << 2) + 0xd0100000)
//Bit 31: 0, ro_mcdi_col_cfd_5.                    column cofidence value 5. initial = 0
#define MCDI_RO_COL_CFD_6                          ((0x2fb6  << 2) + 0xd0100000)
//Bit 31: 0, ro_mcdi_col_cfd_6.                    column cofidence value 6. initial = 0
#define MCDI_RO_COL_CFD_7                          ((0x2fb7  << 2) + 0xd0100000)
//Bit 31: 0, ro_mcdi_col_cfd_7.                    column cofidence value 7. initial = 0
#define MCDI_RO_COL_CFD_8                          ((0x2fb8  << 2) + 0xd0100000)
//Bit 31: 0, ro_mcdi_col_cfd_8.                    column cofidence value 8. initial = 0
#define MCDI_RO_COL_CFD_9                          ((0x2fb9  << 2) + 0xd0100000)
//Bit 31: 0, ro_mcdi_col_cfd_9.                    column cofidence value 9. initial = 0
#define MCDI_RO_COL_CFD_10                         ((0x2fba  << 2) + 0xd0100000)
//Bit 31: 0, ro_mcdi_col_cfd_10.                   column cofidence value 10. initial = 0
#define MCDI_RO_COL_CFD_11                         ((0x2fbb  << 2) + 0xd0100000)
//Bit 31: 0, ro_mcdi_col_cfd_11.                   column cofidence value 11. initial = 0
#define MCDI_RO_COL_CFD_12                         ((0x2fbc  << 2) + 0xd0100000)
//Bit 31: 0, ro_mcdi_col_cfd_12.                   column cofidence value 12. initial = 0
#define MCDI_RO_COL_CFD_13                         ((0x2fbd  << 2) + 0xd0100000)
//Bit 31: 0, ro_mcdi_col_cfd_13.                   column cofidence value 13. initial = 0
#define MCDI_RO_COL_CFD_14                         ((0x2fbe  << 2) + 0xd0100000)
//Bit 31: 0, ro_mcdi_col_cfd_14.                   column cofidence value 14. initial = 0
#define MCDI_RO_COL_CFD_15                         ((0x2fbf  << 2) + 0xd0100000)
//Bit 31: 0, ro_mcdi_col_cfd_15.                   column cofidence value 15. initial = 0
#define MCDI_RO_COL_CFD_16                         ((0x2fc0  << 2) + 0xd0100000)
//Bit 31: 0, ro_mcdi_col_cfd_16.                   column cofidence value 16. initial = 0
#define MCDI_RO_COL_CFD_17                         ((0x2fc1  << 2) + 0xd0100000)
//Bit 31: 0, ro_mcdi_col_cfd_17.                   column cofidence value 17. initial = 0
#define MCDI_RO_COL_CFD_18                         ((0x2fc2  << 2) + 0xd0100000)
//Bit 31: 0, ro_mcdi_col_cfd_18.                   column cofidence value 18. initial = 0
#define MCDI_RO_COL_CFD_19                         ((0x2fc3  << 2) + 0xd0100000)
//Bit 31: 0, ro_mcdi_col_cfd_19.                   column cofidence value 19. initial = 0
#define MCDI_RO_COL_CFD_20                         ((0x2fc4  << 2) + 0xd0100000)
//Bit 31: 0, ro_mcdi_col_cfd_20.                   column cofidence value 20. initial = 0
#define MCDI_RO_COL_CFD_21                         ((0x2fc5  << 2) + 0xd0100000)
//Bit 31: 0, ro_mcdi_col_cfd_21.                   column cofidence value 21. initial = 0
#define MCDI_RO_COL_CFD_22                         ((0x2fc6  << 2) + 0xd0100000)
//Bit 31: 0, ro_mcdi_col_cfd_22.                   column cofidence value 22. initial = 0
#define MCDI_RO_COL_CFD_23                         ((0x2fc7  << 2) + 0xd0100000)
//Bit 31: 0, ro_mcdi_col_cfd_23.                   column cofidence value 23. initial = 0
#define MCDI_RO_COL_CFD_24                         ((0x2fc8  << 2) + 0xd0100000)
//Bit 31: 0, ro_mcdi_col_cfd_24.                   column cofidence value 24. initial = 0
#define MCDI_RO_COL_CFD_25                         ((0x2fc9  << 2) + 0xd0100000)
//Bit 31: 0, ro_mcdi_col_cfd_25.                   column cofidence value 25. initial = 0
// add space 8'hd0-8'hef
//
// Reading file:  dipd_regs.h
//
// synopsys translate_off
// synopsys translate_on
// using 8'he0-8'hef
#define DIPD_COMB_CTRL0                            ((0x2fd0  << 2) + 0xd0100000)
//Bit 31:0,								reg_pd_comb_ctrl0
#define DIPD_COMB_CTRL1                            ((0x2fd1  << 2) + 0xd0100000)
//Bit 31:0,								reg_pd_comb_ctrl1
#define DIPD_COMB_CTRL2                            ((0x2fd2  << 2) + 0xd0100000)
//Bit 31:0,								reg_pd_comb_ctrl2
#define DIPD_COMB_CTRL3                            ((0x2fd3  << 2) + 0xd0100000)
//Bit 31:0,								reg_pd_comb_ctrl3
#define DIPD_COMB_CTRL4                            ((0x2fd4  << 2) + 0xd0100000)
//Bit 31:0,								reg_pd_comb_ctrl4
#define DIPD_COMB_CTRL5                            ((0x2fd5  << 2) + 0xd0100000)
//Bit 31:0,								reg_pd_comb_ctrl5
#define DIPD_RO_COMB_0                             ((0x2fd6  << 2) + 0xd0100000)
//Bit 31:0,								ro_pd_comb_0
#define DIPD_RO_COMB_1                             ((0x2fd7  << 2) + 0xd0100000)
//Bit 31:0,								ro_pd_comb_1
#define DIPD_RO_COMB_2                             ((0x2fd8  << 2) + 0xd0100000)
//Bit 31:0,								ro_pd_comb_2
#define DIPD_RO_COMB_3                             ((0x2fd9  << 2) + 0xd0100000)
//Bit 31:0,								ro_pd_comb_3
#define DIPD_RO_COMB_4                             ((0x2fda  << 2) + 0xd0100000)
//Bit 31:0,								ro_pd_comb_4
#define DIPD_RO_COMB_5                             ((0x2fdb  << 2) + 0xd0100000)
//Bit 31:0,								ro_pd_comb_5
#define DIPD_RO_COMB_6                             ((0x2fdc  << 2) + 0xd0100000)
//Bit 31:0,								ro_pd_comb_6
#define DIPD_RO_COMB_7                             ((0x2fdd  << 2) + 0xd0100000)
//Bit 31:0,								ro_pd_comb_7
#define DIPD_RO_COMB_8                             ((0x2fde  << 2) + 0xd0100000)
//Bit 31:0,								ro_pd_comb_8
#define DIPD_RO_COMB_9                             ((0x2fdf  << 2) + 0xd0100000)
//Bit 31:0,								ro_pd_comb_9
#define DIPD_RO_COMB_10                            ((0x2fe0  << 2) + 0xd0100000)
//Bit 31:0,								ro_pd_comb_10
#define DIPD_RO_COMB_11                            ((0x2fe1  << 2) + 0xd0100000)
//Bit 31:0,								ro_pd_comb_11
#define DIPD_RO_COMB_12                            ((0x2fe2  << 2) + 0xd0100000)
//Bit 31:0,								ro_pd_comb_12
#define DIPD_RO_COMB_13                            ((0x2fe3  << 2) + 0xd0100000)
//Bit 31:0,								ro_pd_comb_13
#define DIPD_RO_COMB_14                            ((0x2fe4  << 2) + 0xd0100000)
//Bit 31:0,								ro_pd_comb_14
#define DIPD_RO_COMB_15                            ((0x2fe5  << 2) + 0xd0100000)
//Bit 31:0,								ro_pd_comb_15
#define DIPD_RO_COMB_16                            ((0x2fe6  << 2) + 0xd0100000)
//Bit 31:0,								ro_pd_comb_16
#define DIPD_RO_COMB_17                            ((0x2fe7  << 2) + 0xd0100000)
//Bit 31:0,								ro_pd_comb_17
#define DIPD_RO_COMB_18                            ((0x2fe8  << 2) + 0xd0100000)
//Bit 31:0,								ro_pd_comb_18
#define DIPD_RO_COMB_19                            ((0x2fe9  << 2) + 0xd0100000)
//Bit 31:0,								ro_pd_comb_19
#define DIPD_RO_COMB_20                            ((0x2fea  << 2) + 0xd0100000)
//Bit 31:0,								ro_pd_comb_20
// synopsys translate_off
// synopsys translate_on
//
// Closing file:  dipd_regs.h
//
// addr space 8'hf0-8'hff 
//
// Reading file:  nr3_regs.h
//
// synopsys translate_off
// synopsys translate_on
// -----------------------------------------------
// CBUS_BASE:  VPPB_VCBUS_BASE = 0xfe
// -----------------------------------------------
// using 8'hf0-8'hff
#define NR3_MODE                                   ((0xfef0  << 2) + 0xd0100000)
//Bit    5,   reg_3dnr_nr3_vtxt_mode         ;
//Bit    4,   reg_3dnr_nr3_cbyy_ignor_coop   ; // u1: ignore coop condition for cbyy motion decision
//Bit    3,   reg_3dnr_nr3_ybyc_ignor_cnoop  ; // u1: ignore cnoop condition for ybyc motion decision
//Bit  2:0,   reg_3dnr_nr3_suremot_txt_mode  ; // u3: 0: cur, 1:p2; 2: (cur+p2)/2; 3/up: min(cur,p2)
#define NR3_COOP_PARA                              ((0xfef1  << 2) + 0xd0100000)
//Bit 21:20,   reg_3dnr_nr3_coop_mode         ; // u2  0 original pixel 1: [1 2 1]/4 lpf; 2: [1 2 2 2 1]/8; 3: 3x3 lpf
//Bit 19:16,   reg_3dnr_nr3_coop_ratio        ; // u4  cur and p2 color oop decision ratio:  (avg1<(MAX(sat0,sat2)*ratio/8 + ofst));	
//Bit 15:8,    reg_3dnr_nr3_coop_ofset        ; // s8  cur and p2 color oop decision ofst:  (avg1<(MAX(sat0,sat2)*ratio/8 + ofst));	
//Bit  7:0,    reg_3dnr_nr3_coop_sat_thrd     ; // u8  cur and p2 color oop decision min(sat0,sat1) threshold;		
#define NR3_CNOOP_GAIN                             ((0xfef2  << 2) + 0xd0100000)
//Bit 23:20,   reg_3dnr_nr3_cnoop_ratio0      ; // u4   cur and p2 color noop decision ratio0:  (avg1<(MAX(sat0,sat2)*ratio0/8 + ofst0));		
//Bit 19:16,   reg_3dnr_nr3_cnoop_ratio1      ; // u4	cur and p2 color noop decision ratio1:  (dif1<(MIN(sat0,sat2)*ratio1/8 + ofst1));
//Bit 15:8,    reg_3dnr_nr3_cnoop_ofset0      ; // s8	cur and p2 color noop decision ofset0:  (avg1<(MAX(sat0,sat2)*ratio0/8 + ofst0));
//Bit  7:0,    reg_3dnr_nr3_cnoop_ofset1      ; // s8   cur and p2 color noop decision ofset1:  (dif1<(MIN(sat0,sat2)*ratio1/8 + ofst1));
#define NR3_YMOT_PARA                              ((0xfef3  << 2) + 0xd0100000)
//Bit    19,   reg_3dnr_nr3_ymot_only_en      ; // u1: enable signal for ignor chroma motion: (ytxt &coop)
//Bit    18,   reg_3dnr_nr3_ymot_only_cmtmode ; // u1: 0: cmot=ymot; 1: cmot = MIN(ymot, cmot)
//Bit 17:16,   reg_3dnr_nr3_ymot_only_txtmode ; // u2: 0, min(txt0,txt2); 1, max(txt0,txt2);2, (txt0+txt2)/2; 3: sat(txt0, txt2)
//Bit 15:8,    reg_3dnr_nr3_ymot_only_txtthrd ; // u8: threshold to luma texture to decide use ymot only
//Bit  7:0,    reg_3dnr_nr3_ymot_only_motthrd ; // u8: threshold to luma motion to decide use ymot only
#define NR3_CMOT_PARA                              ((0xfef4  << 2) + 0xd0100000)
//Bit    19,   reg_3dnr_nr3_cmot_only_en      ; // u1: enable signal for ignor luma motion: (ctxt &cnoop)
//Bit    18,   reg_3dnr_nr3_cmot_only_ymtmode ; // u1: 0: ymot=cmot+ymot/4; 1: ymot = MIN(ymot, cmot)
//Bit 17:16,   reg_3dnr_nr3_cmot_only_txtmode ; // u2: 0, min(txt0,txt2); 1, max(txt0,txt2);2, (txt0+txt2)/2; 3: sat(txt0, txt2)
//Bit 15:8,    reg_3dnr_nr3_cmot_only_txtthrd ; // u8: threshold to chroma texture to decide use cmot only
//Bit  7:0,    reg_3dnr_nr3_cmot_only_motthrd ; // u8: threshold to chroma motion to decide use cmot only
#define NR3_SUREMOT_YGAIN                          ((0xfef5  << 2) + 0xd0100000)
//Bit 31:24,   reg_3dnr_nr3_suremot_dec_yrate ; // u8: (norm 16)lpfMot>(dec_rate*txt +ofst) then force lpfMot*frc_gain+frc_ofset
//Bit 23:16,   reg_3dnr_nr3_suremot_dec_yofst ; // u8: lpfMot>(dec_rate*txt +ofst) then force lpfMot*frc_gain+frc_ofset
//Bit 15:8,    reg_3dnr_nr3_suremot_frc_ygain ; // u8: (norm 8)lpfMot>(dec_rate*txt +ofst) then force lpfMot*frc_gain+frc_ofset
//Bit  7:0,    reg_3dnr_nr3_suremot_frc_yofst ; // u8: lpfMot>(dec_rate*txt +ofst) then force lpfMot*frc_gain+frc_ofset
#define NR3_SUREMOT_CGAIN                          ((0xfef6  << 2) + 0xd0100000)
//Bit 31:24,   reg_3dnr_nr3_suremot_dec_crate ; // u8: (norm 16)lpfMot>(dec_rate*txt +ofst) then force lpfMot*frc_gain+frc_ofset
//Bit 23:16,   reg_3dnr_nr3_suremot_dec_cofst ; // u8: lpfMot>(dec_rate*txt +ofst) then force lpfMot*frc_gain+frc_ofset
//Bit 15:8,    reg_3dnr_nr3_suremot_frc_cgain ; // u8: (norm 8)lpfMot>(dec_rate*txt +ofst) then force lpfMot*frc_gain+frc_ofset
//Bit  7:0,    reg_3dnr_nr3_suremot_frc_cofst ; // u8: lpfMot>(dec_rate*txt +ofst) then force lpfMot*frc_gain+frc_ofset
// synopsys translate_off
// synopsys translate_on
//
// Closing file:  nr3_regs.h
//
// synopsys translate_off
// synopsys translate_on
//
// Closing file:  mcdi_regs.h
//
//  VPU_VLOCK register    (16'h3000 - 16'h30ff)
//========================================================================
//`define VPU_VLOCK_VCBUS_BASE                   8'h30
//
// Reading file:  vpu_vlock_reg.h
//
// synopsys translate_off
// synopsys translate_on
// ----------------------------
// VPU_VLOCK 0x30  
// ----------------------------
// -----------------------------------------------
// CBUS_BASE:  VPU_VLOCK_VCBUS_BASE = 0x30
// -----------------------------------------------
#define VPU_VLOCK_CTRL                             ((0x3000  << 2) + 0xd0100000)
#define VPU_VLOCK_MISC_CTRL                        ((0x3001  << 2) + 0xd0100000)
#define VPU_VLOCK_LOOP0_ACCUM_LMT                  ((0x3002  << 2) + 0xd0100000)
#define VPU_VLOCK_LOOP0_CTRL0                      ((0x3003  << 2) + 0xd0100000)
#define VPU_VLOCK_LOOP1_CTRL0                      ((0x3004  << 2) + 0xd0100000)
#define VPU_VLOCK_LOOP1_IMISSYNC_MAX               ((0x3005  << 2) + 0xd0100000)
#define VPU_VLOCK_LOOP1_IMISSYNC_MIN               ((0x3006  << 2) + 0xd0100000)
#define VPU_VLOCK_OVWRITE_ACCUM0                   ((0x3007  << 2) + 0xd0100000)
#define VPU_VLOCK_OVWRITE_ACCUM1                   ((0x3008  << 2) + 0xd0100000)
#define VPU_VLOCK_OUTPUT0_CAPT_LMT                 ((0x3009  << 2) + 0xd0100000)
#define VPU_VLOCK_OUTPUT0_PLL_LMT                  ((0x300a  << 2) + 0xd0100000)
#define VPU_VLOCK_OUTPUT1_CAPT_LMT                 ((0x300b  << 2) + 0xd0100000)
#define VPU_VLOCK_OUTPUT1_PLL_LMT                  ((0x300c  << 2) + 0xd0100000)
#define VPU_VLOCK_LOOP1_PHSDIF_TGT                 ((0x300d  << 2) + 0xd0100000)
#define VPU_VLOCK_RO_LOOP0_ACCUM                   ((0x300e  << 2) + 0xd0100000)
#define VPU_VLOCK_RO_LOOP1_ACCUM                   ((0x300f  << 2) + 0xd0100000)
#define VPU_VLOCK_OROW_OCOL_MAX                    ((0x3010  << 2) + 0xd0100000)
#define VPU_VLOCK_RO_VS_I_DIST                     ((0x3011  << 2) + 0xd0100000)
#define VPU_VLOCK_RO_VS_O_DIST                     ((0x3012  << 2) + 0xd0100000)
#define VPU_VLOCK_RO_LINE_PIX_ADJ                  ((0x3013  << 2) + 0xd0100000)
#define VPU_VLOCK_RO_OUTPUT_00_01                  ((0x3014  << 2) + 0xd0100000)
#define VPU_VLOCK_RO_OUTPUT_10_11                  ((0x3015  << 2) + 0xd0100000)
#define VPU_VLOCK_MX4096                           ((0x3016  << 2) + 0xd0100000)
#define VPU_VLOCK_STBDET_WIN0_WIN1                 ((0x3017  << 2) + 0xd0100000)
#define VPU_VLOCK_STBDET_CLP                       ((0x3018  << 2) + 0xd0100000)
#define VPU_VLOCK_STBDET_ABS_WIN0                  ((0x3019  << 2) + 0xd0100000)
#define VPU_VLOCK_STBDET_ABS_WIN1                  ((0x301a  << 2) + 0xd0100000)
#define VPU_VLOCK_STBDET_SGN_WIN0                  ((0x301b  << 2) + 0xd0100000)
#define VPU_VLOCK_STBDET_SGN_WIN1                  ((0x301c  << 2) + 0xd0100000)
#define VPU_VLOCK_ADJ_EN_SYNC_CTRL                 ((0x301d  << 2) + 0xd0100000)
#define VPU_VLOCK_GCLK_EN                          ((0x301e  << 2) + 0xd0100000)
#define VPU_VLOCK_LOOP1_ACCUM_LMT                  ((0x301f  << 2) + 0xd0100000)
#define VPU_VLOCK_RO_M_INT_FRAC                    ((0x3020  << 2) + 0xd0100000)
// synopsys translate_off
// synopsys translate_on
//
// Closing file:  vpu_vlock_reg.h
//
//`define VPPB_VCBUS_BASE                8'h31 
//
// Reading file:  srscl_reg.h
//
// synopsys translate_off
// synopsys translate_on
// -----------------------------------------------
// CBUS_BASE:  VPPB_VCBUS_BASE = 0x31
// -----------------------------------------------
////=================================================================////
//// super scaler core 0
////=================================================================////
#define SRSCL0_HV_SIZEIN                           ((0x3100  << 2) + 0xd0100000)
//Bit 31:29, reserved  
//Bit 28:16, reg_srscl0_hsize               image horizontal size (number of cols)   default=1024 
//Bit 15:13, reserved                       
//Bit 12: 0, reg_srscl0_vsize               image vertical size   (number of rows)   default=1024
#define SRSCL0_CTRL_MODE                           ((0x3101  << 2) + 0xd0100000)
//Bit 31:15, reserved     
//Bit 14,    reg_srscl0_horz_outphs          phase for super-scalar output under xVx1H ration: 0: 0 phase, 1: 1/2 phase     default = 0
//Bit 13,    reg_srscl0_cmpmux_aft           u1: 0 no swap anf for YUV->YUV; 1, swapped and for GBR-RGB; default = 0
//Bit 12,    reg_srscl0_cmpmux_bef           u1: 0 no swap anf for YUV->YUV; 1, swapped and for RGB->GBR; default = 0
//Bit 11,    reg_srscl0_bic_norm             normalization of bicubical: 0: 128|128; 1: 64|64  default = 0
//Bit 10,    reg_srscl0_3dint_mode           option for line-by-line 3D cases     default = 0
//Bit 9,     reg_srscl0_3dint_hadj_cub       option for using cubic interpolation for horizontal adjacent pixels     default = 0
//Bit 8,     reg_srscl0_vert_outphs          phase for super-scalar output under 1Vx2H ration: 0: 0 phase, 1: 1/2 phase     default = 0
//Bit 7,     reg_srscl0_cuse_bic_od          outside demo window chroma use bicubical interpolation    default = 0
//Bit 6,     reg_srscl0_yuse_bic_od          outside demo window chroma use bicubical interpolation    default = 0
//Bit 5,     reg_srscl0_cuse_bic             inside demo window luma use bicubical interpolation 
//                                           0: demo window us SR scalar for chroma channel;  
//                                           1: demo window use Bi-cubic scalar for chroma channel        default = 0
//Bit 4,     reg_srscl0_yuse_bic             inside demo window luma use bicubical interpolation 
//                                           0: demo window us SR scalar for luma channel;  
//                                           1: demo window use Bi-cubic scalar for luma channel        default = 0
//Bit 3,     reg_srscl0_use_3lrln            Options to extend 3 lines low-resolution data to 5-lines for SR scalar, (for core_0):
//                                           0: normal working mode, using 5 lines 
//                                           1: extend effective 3 lines to 5 lines; (will be used in line-by-line 3D contents)         default = 
//Bit 2,     reg_srscl0_vert_ratio           Vertical scalar ratio of Super Scalar core_0;
//                                           0: 1x scale; 1: 2x scale;    default = 
//Bit 1,     reg_srscl0_hori_ratio           Horizontal scalar ratio of Super Scalar core_0;
//                                           0: 1x scale; 1: 2x scale;    default = 
//Bit 0,     reg_srscl0_enable               Enable of Super Scalar core_0: 
//                                           0: disable (bypass) 1: enable    default = 
#define SRSCL0_YBIC_HCOEF                          ((0x3102  << 2) + 0xd0100000)
//Bit 31:24, reg_srscl0_y_bic_hcoef3         Horizontal bi-cubic filter of 0.5 phase of luma channel (for core_0)
//                                          Filter will be normalized to 128 as ‘1’; default=-8                         
//Bit 23:16, reg_srscl0_y_bic_hcoef2         the same as above; default=72                         
//Bit 15: 8, reg_srscl0_y_bic_hcoef1         the same as above; default=72                         
//Bit  7: 0, reg_srscl0_y_bic_hcoef0         the same as above; default=-8
#define SRSCL0_CBIC_HCOEF                          ((0x3103  << 2) + 0xd0100000)
//Bit 31:24, reg_srscl0_c_bic_hcoef3         Horizontal bi-cubic filter of 0.5 phase of chroma channel (for core_0)
//                                           Filter will be normalized to 128 as ‘1’; default=-8                         
//Bit 23:16, reg_srscl0_c_bic_hcoef2         the same as above; default=72                         
//Bit 15: 8, reg_srscl0_c_bic_hcoef1         the same as above; default=72                         
//Bit  7: 0, reg_srscl0_c_bic_hcoef0         the same as above; default=-8
#define SRSCL0_YBIC_VCOEF                          ((0x3104  << 2) + 0xd0100000)
//Bit 31:24, reg_srscl0_y_bic_vcoef3         Vertical bi-cubic filter of 0.5 phase of luma channel (for core_0)
//                                           Filter will be normalized to 128 as ‘1’; default=-8                         
//Bit 23:16, reg_srscl0_y_bic_vcoef2         the same as above; default=72                         
//Bit 15: 8, reg_srscl0_y_bic_vcoef1         the same as above; default=72                         
//Bit  7: 0, reg_srscl0_y_bic_vcoef0         the same as above; default=-8
#define SRSCL0_CBIC_VCOEF                          ((0x3105  << 2) + 0xd0100000)
//Bit 31:24, reg_srscl0_c_bic_vcoef3         Vertical bi-cubic filter of 0.5 phase of chroma channel (for core_0)
//                                           Filter will be normalized to 128 as ‘1’; default=-8                         
//Bit 23:16, reg_srscl0_c_bic_vcoef2         the same as above; default=72                         
//Bit 15: 8, reg_srscl0_c_bic_vcoef1         the same as above; default=72                         
//Bit  7: 0, reg_srscl0_c_bic_vcoef0         the same as above; default=-8
#define SRSCL0_VAR_PARA                            ((0x3106  << 2) + 0xd0100000)
//Bit 31:26, reserved  
//Bit 25:24, reg_srscl0_var_adja_rs          Horizontal/vertical adjacent pixel noise normalized variance value right shift bits.  default= 2   
//Bit 23:16, reg_srscl0_var_adja             Horizontal/vertical adjacent pixel noise normalized variance value. 
//                                           Var2 = (2^(11+rs))/gain; default= 68
//Bit 15:10, reserved  
//Bit  9: 8, reg_srscl0_var_diag_rs          Diagonal pixel noise normalized variance value right shift bits. default= 3    
//Bit  7: 0, reg_srscl0_var_diag             Diagonal pixel noise normalized variance value. Var2 = (2^(11+rs))/gain; default= 68
#define SRSCL0_CONST_PARA                          ((0x3107  << 2) + 0xd0100000)
//Bit 31:16, reserved  
//Bit 15: 8, reg_srscl0_c_adja               Constant for d_adja calculation from wk_nrm; Normalize 128 as “1” default= 32     
//Bit  7: 0, reg_srscl0_c_diag               Constant for d_diag calculation from wk_nrm; Normalize 128 as “1” default= 32
#define SRSCL0_RKE_EXTWIN                          ((0x3108  << 2) + 0xd0100000)
//Bit 31:23, reserved  
//Bit 22:20, reg_srscl0_rke_extwin         Window size for Rke horizontal extension: Win_size = 2x+1 scope: 0~5;  default= 4
//Bit 19:16, reg_srscl0_rke_coring         Coring to Rke default= 10
//Bit 15:13, reserved  
//Bit 12: 8, reg_srscl0_rke_extwin_core    Coring to Rks before local window maximum value calculation     default= 10 
//Bit  7: 0, reg_srscl0_rke_extwin_rate    Rate to blender strength (gamma), gamma is used to blend local maximum Rke and current Rke; the rate is normalized to 16 as “1”  default= 12
#define SRSCL0_UK_GRAD2DDIAG_TH_RATE               ((0x3109  << 2) + 0xd0100000)
//reg_srscl0_uk_grad2ddiag (0 1 5 6)  Wk_nrm to d_diag mapping curve parameter for UK calculation:         
//Bit 31:24, reg_srscl0_uk_grad2ddiag_rate1 rate1, d_diag level trasition rate 2nd towards 3rd piece;   default = 20;
//Bit 23:16, reg_srscl0_uk_grad2ddiag_rate0 rate0, d_diag level trasition rate 2nd towards 1st piece;   default = 80;
//Bit 15: 8, reg_srscl0_uk_grad2ddiag_th1   th1, threshold to (c+wk_nrm) for second/3rd piece;   default = 60;
//Bit  7: 0, reg_srscl0_uk_grad2ddiag_th0   th0, threshold to (c+wk_nrm) for first/second piece;   default = 25;
#define SRSCL0_UK_GRAD2DDIAG_LIMIT                 ((0x310a  << 2) + 0xd0100000)
//reg_srscl0_uk_grad2ddiag (2 3 4)            
//Bit 31:24, reserved 
//Bit 23:16, reg_srscl0_uk_grad2ddiag_lv2   lev2, d_diag level limit for 3rd piece;   default = 128;
//Bit 15: 8, reg_srscl0_uk_grad2ddiag_lv1   lev1, d_diag level limit for 2nd piece;   default = 128;
//Bit  7: 0, reg_srscl0_uk_grad2ddiag_lv0   lev0, d_diag level limit for 1st piece;   default = 128;
#define SRSCL0_UK_GRAD2DADJA_TH_RATE               ((0x310b  << 2) + 0xd0100000)
//reg_srscl0_uk_grad2adja (0 1 5 6)  Wk_nrm to d_adja mapping curve parameter for UK calculation:         
//Bit 31:24, reg_srscl0_uk_grad2dadja_rate1 rate1, d_adja level trasition rate 2nd towards 3rd piece;   default = 20;
//Bit 23:16, reg_srscl0_uk_grad2dadja_rate0 rate0, d_adja level trasition rate 2nd towards 1st piece;   default = 80;
//Bit 15: 8, reg_srscl0_uk_grad2dadja_th1   th1, threshold to (c+wk_nrm) for second/3rd piece;   default = 60;
//Bit  7: 0, reg_srscl0_uk_grad2dadja_th0   th0, threshold to (c+wk_nrm) for first/second piece;   default = 25;
#define SRSCL0_UK_GRAD2DADJA_LIMIT                 ((0x310c  << 2) + 0xd0100000)
//reg_srscl0_uk_grad2dadja (2 3 4)            
//Bit 31:24, reserved    
//Bit 23:16, reg_srscl0_uk_grad2dadja_lv2   lev2, d_adja level limit for 3rd piece;   default = 128;
//Bit 15: 8, reg_srscl0_uk_grad2dadja_lv1   lev1, d_adja level limit for 2nd piece;   default = 128;
//Bit  7: 0, reg_srscl0_uk_grad2dadja_lv0   lev0, d_adja level limit for 1st piece;   default = 128;
#define SRSCL0_UK_BST_GAIN                         ((0x310d  << 2) + 0xd0100000)
//Bit 31:24, reg_srscl0_bst_cgain           Gain to Uk_diag, normalized to 32 as “1”  default = 122;
//Bit 23:16, reg_srscl0_bst_ygain           Gain to Uk_adja, normalized to 32 as “1”  default = 122;
//Bit 15: 8, reg_srscl0_uk_adja_gain        Boost gain to delta component of SR scalar refine for luma channel. It is applied to tDiv.
//                                          Normalized to 128 as “1”  default = 58;
//Bit  7: 0, reg_srscl0_uk_diag_gain        Boost gain to delta component of SR scalar refine for chroma channel. It is applied to tDiv.
//                                          Normalized to 128 as “1”  default = 80;
#define SRSCL0_HVBLEND_TH                          ((0x310e  << 2) + 0xd0100000)
//Bit 31:29, reserved 
//Bit 28:24, reg_srscl0_hvblend_th3         Rate threshold to decide HV protection blend rate, default = 8;
//Bit 23:21, reserved 
//Bit 20:16, reg_srscl0_hvblend_th2         the same as above;  default = 8;
//Bit 15:13, reserved 
//Bit 12: 8, reg_srscl0_hvblend_th1         the same as above;  default = 4;
//Bit  7: 5, reserved 
//Bit  4: 0, reg_srscl0_hvblend_th0         the same as above;  default = 4;
#define SRSCL0_DEMO_WIND_TB                        ((0x310f  << 2) + 0xd0100000)
//Bit 31:29, reserved 
//Bit 28:16, reg_srscl0_demo_wind_top       Demo mode window vertical top boundary range;  default = 8191;
//Bit 15:13, reserved 
//Bit 12: 0, reg_srscl0_demo_wind_bot       Demo mode window vertical bottom boundary range;  default = 0;
#define SRSCL0_DEMO_WIND_LR                        ((0x3110  << 2) + 0xd0100000)
//Bit 31:29, reserved 
//Bit 28:16, reg_srscl0_demo_wind_right     Demo mode window vertical right boundary range;  default = 8191;
//Bit 15:13, reserved 
//Bit 12: 0, reg_srscl0_demo_wind_left      Demo mode window vertical left boundary range;  default = 0;
#define SRSCL0_INT_BLANK_NUM                       ((0x3111  << 2) + 0xd0100000)
//Bit 31:21, reserved  
//Bit    20, reg_srscl0_rst_syn_en          for syn same control reg to rst_n posedge. default=0;  
//Bit 19:16, reg_srscl0_inbuf_hsk_stuff     default=2
//Bit 15: 8, reg_srscl0_int_vbk_num         interpolation vertical   blank num   default=24
//Bit  7: 0, reg_srscl0_int_hbk_num         interpolation horizontal blank num   default=8
#define SRSCL0_YBIC_HCOEF0                         ((0x3112  << 2) + 0xd0100000)
//Bit 31:24, reg_srscl0_y_bic_hcoef03         Horizontal bi-cubic filter of 0.5 phase of luma channel (for core_0)
//                                           Filter will be normalized to 128 as ‘1’; default=0                         
//Bit 23:16, reg_srscl0_y_bic_hcoef02         the same as above; default=0                         
//Bit 15: 8, reg_srscl0_y_bic_hcoef01         the same as above; default=128                        
//Bit  7: 0, reg_srscl0_y_bic_hcoef00         the same as above; default=0
#define SRSCL0_CBIC_HCOEF0                         ((0x3113  << 2) + 0xd0100000)
//Bit 31:24, reg_srscl0_c_bic_hcoef03         Horizontal bi-cubic filter of 0.5 phase of chroma channel (for core_0)
//                                            Filter will be normalized to 128 as ‘1’; default=0                         
//Bit 23:16, reg_srscl0_c_bic_hcoef02         the same as above; default=0                         
//Bit 15: 8, reg_srscl0_c_bic_hcoef01         the same as above; default=128                         
//Bit  7: 0, reg_srscl0_c_bic_hcoef00         the same as above; default=0
#define SRSCL0_YBIC_VCOEF0                         ((0x3114  << 2) + 0xd0100000)
//Bit 31:24, reg_srscl0_y_bic_vcoef03         Vertical bi-cubic filter of 0.5 phase of luma channel (for core_0)
//                                            Filter will be normalized to 128 as ‘1’; default=0                         
//Bit 23:16, reg_srscl0_y_bic_vcoef02         the same as above; default=0                         
//Bit 15: 8, reg_srscl0_y_bic_vcoef01         the same as above; default=128                         
//Bit  7: 0, reg_srscl0_y_bic_vcoef00         the same as above; default=0
#define SRSCL0_CBIC_VCOEF0                         ((0x3115  << 2) + 0xd0100000)
//Bit 31:24, reg_srscl0_c_bic_vcoef03         Vertical bi-cubic filter of 0.5 phase of chroma channel (for core_0)
//                                            Filter will be normalized to 128 as ‘1’; default=0                         
//Bit 23:16, reg_srscl0_c_bic_vcoef02         the same as above; default=0                         
//Bit 15: 8, reg_srscl0_c_bic_vcoef01         the same as above; default=128                         
//Bit  7: 0, reg_srscl0_c_bic_vcoef00         the same as above; default=0
////=================================================================////
//// super scaler core 1
////=================================================================////
#define SRSCL1_HV_SIZEIN                           ((0x3118  << 2) + 0xd0100000)
//Bit 31:29, reserved  
//Bit 28:16, reg_srscl1_hsize               image horizontal size (number of cols)   default=2048 
//Bit 15:13, reserved                       
//Bit 12: 0, reg_srscl1_vsize               image vertical size   (number of rows)   default=2048
#define SRSCL1_CTRL_MODE                           ((0x3119  << 2) + 0xd0100000)
//Bit 31:15, reserved     
//Bit 14,    reg_srscl1_horz_outphs          phase for super-scalar output under xVx1H ration: 0: 0 phase, 1: 1/2 phase     default = 0
//Bit 13,    reg_srscl1_cmpmux_aft           u1: 0 no swap anf for YUV->YUV; 1, swapped and for GBR-RGB; default = 0
//Bit 12,    reg_srscl1_cmpmux_bef           u1: 0 no swap anf for YUV->YUV; 1, swapped and for RGB->GBR; default = 0
//Bit 11,    reg_srscl1_bic_norm             normalization of bicubical: 0: 128|128; 1: 64|64  default = 0
//Bit 10,    reg_srscl1_3dint_mode           option for line-by-line 3D cases     default = 0
//Bit 9,     reg_srscl1_3dint_hadj_cub       option for using cubic interpolation for horizontal adjacent pixels     default = 0
//Bit 8,     reg_srscl1_vert_outphs          phase for super-scalar output under 1Vx2H ration: 0: 0 phase, 1: 1/2 phase     default = 0
//Bit 7,     reg_srscl1_cuse_bic_od          outside demo window chroma use bicubical interpolation    default = 0
//Bit 6,     reg_srscl1_yuse_bic_od          outside demo window chroma use bicubical interpolation    default = 0
//Bit 5,     reg_srscl1_cuse_bic             inside demo window luma use bicubical interpolation 
//                                           0: demo window us SR scalar for chroma channel;  
//                                           1: demo window use Bi-cubic scalar for chroma channel        default = 0
//Bit 4,     reg_srscl1_yuse_bic             inside demo window luma use bicubical interpolation 
//                                           0: demo window us SR scalar for luma channel;  
//                                           1: demo window use Bi-cubic scalar for luma channel        default = 0
//Bit 3,     reg_srscl1_use_3lrln            Options to extend 3 lines low-resolution data to 5-lines for SR scalar, (for core_0):
//                                           0: normal working mode, using 5 lines 
//                                           1: extend effective 3 lines to 5 lines; (will be used in line-by-line 3D contents)         default = 
//Bit 2,     reg_srscl1_vert_ratio           Vertical scalar ratio of Super Scalar core_0;
//                                           0: 1x scale; 1: 2x scale;    default = 
//Bit 1,     reg_srscl1_hori_ratio           Horizontal scalar ratio of Super Scalar core_0;
//                                           0: 1x scale; 1: 2x scale;    default = 
//Bit 0,     reg_srscl1_enable               Enable of Super Scalar core_0: 
//                                           0: disable (bypass) 1: enable    default = 
#define SRSCL1_YBIC_HCOEF                          ((0x311a  << 2) + 0xd0100000)
//Bit 31:24, reg_srscl1_y_bic_hcoef3         Horizontal bi-cubic filter of 0.5 phase of luma channel (for core_0)
//                                           Filter will be normalized to 128 as ‘1’; default=-8                         
//Bit 23:16, reg_srscl1_y_bic_hcoef2         the same as above; default=72                         
//Bit 15: 8, reg_srscl1_y_bic_hcoef1         the same as above; default=72                         
//Bit  7: 0, reg_srscl1_y_bic_hcoef0         the same as above; default=-8
#define SRSCL1_CBIC_HCOEF                          ((0x311b  << 2) + 0xd0100000)
//Bit 31:24, reg_srscl1_c_bic_hcoef3         Horizontal bi-cubic filter of 0.5 phase of chroma channel (for core_0)
//                                           Filter will be normalized to 128 as ‘1’; default=-8                         
//Bit 23:16, reg_srscl1_c_bic_hcoef2         the same as above; default=72                         
//Bit 15: 8, reg_srscl1_c_bic_hcoef1         the same as above; default=72                         
//Bit  7: 0, reg_srscl1_c_bic_hcoef0         the same as above; default=-8
#define SRSCL1_YBIC_VCOEF                          ((0x311c  << 2) + 0xd0100000)
//Bit 31:24, reg_srscl1_y_bic_vcoef3         Vertical bi-cubic filter of 0.5 phase of luma channel (for core_0)
//                                           Filter will be normalized to 128 as ‘1’; default=-8                         
//Bit 23:16, reg_srscl1_y_bic_vcoef2         the same as above; default=72                         
//Bit 15: 8, reg_srscl1_y_bic_vcoef1         the same as above; default=72                         
//Bit  7: 0, reg_srscl1_y_bic_vcoef0         the same as above; default=-8
#define SRSCL1_CBIC_VCOEF                          ((0x311d  << 2) + 0xd0100000)
//Bit 31:24, reg_srscl1_c_bic_vcoef3         Vertical bi-cubic filter of 0.5 phase of chroma channel (for core_0)
//                                           Filter will be normalized to 128 as ‘1’; default=-8                         
//Bit 23:16, reg_srscl1_c_bic_vcoef2         the same as above; default=72                         
//Bit 15: 8, reg_srscl1_c_bic_vcoef1         the same as above; default=72                         
//Bit  7: 0, reg_srscl1_c_bic_vcoef0         the same as above; default=-8
#define SRSCL1_VAR_PARA                            ((0x311e  << 2) + 0xd0100000)
//Bit 31:26, reserved  
//Bit 25:24, reg_srscl1_var_adja_rs          Horizontal/vertical adjacent pixel noise normalized variance value right shift bits.  default= 2   
//Bit 23:16, reg_srscl1_var_adja             Horizontal/vertical adjacent pixel noise normalized variance value. 
//                                           Var2 = (2^(11+rs))/gain; default= 68
//Bit 15:10, reserved  
//Bit  9: 8, reg_srscl1_var_diag_rs          Diagonal pixel noise normalized variance value right shift bits. default= 3    
//Bit  7: 0, reg_srscl1_var_diag             Diagonal pixel noise normalized variance value. Var2 = (2^(11+rs))/gain; default= 68
#define SRSCL1_CONST_PARA                          ((0x311f  << 2) + 0xd0100000)
//Bit 31:16, reserved  
//Bit 15: 8, reg_srscl1_c_adja               Constant for d_adja calculation from wk_nrm; Normalize 128 as “1” default= 32     
//Bit  7: 0, reg_srscl1_c_diag               Constant for d_diag calculation from wk_nrm; Normalize 128 as “1” default= 32
#define SRSCL1_RKE_EXTWIN                          ((0x3120  << 2) + 0xd0100000)
//Bit 31:23, reserved  
//Bit 22:20, reg_srscl1_rke_extwin         Window size for Rke horizontal extension: Win_size = 2x+1 scope: 0~5;  default= 4
//Bit 19:16, reg_srscl1_rke_coring         Coring to Rke default= 10
//Bit 15:13, reserved  
//Bit 12: 8, reg_srscl1_rke_extwin_core    Coring to Rks before local window maximum value calculation     default= 10 
//Bit  7: 0, reg_srscl1_rke_extwin_rate    Rate to blender strength (gamma), gamma is used to blend local maximum Rke and current Rke; the rate is normalized to 16 as “1”  default= 12
#define SRSCL1_UK_GRAD2DDIAG_TH_RATE               ((0x3121  << 2) + 0xd0100000)
//reg_srscl1_uk_grad2ddiag (0 1 5 6)  Wk_nrm to d_diag mapping curve parameter for UK calculation:         
//Bit 31:24, reg_srscl1_uk_grad2ddiag_rate1 rate1, d_diag level trasition rate 2nd towards 3rd piece;   default = 20;
//Bit 23:16, reg_srscl1_uk_grad2ddiag_rate0 rate0, d_diag level trasition rate 2nd towards 1st piece;   default = 80;
//Bit 15: 8, reg_srscl1_uk_grad2ddiag_th1   th1, threshold to (c+wk_nrm) for second/3rd piece;   default = 60;
//Bit  7: 0, reg_srscl1_uk_grad2ddiag_th0   th0, threshold to (c+wk_nrm) for first/second piece;   default = 25;
#define SRSCL1_UK_GRAD2DDIAG_LIMIT                 ((0x3122  << 2) + 0xd0100000)
//reg_srscl1_uk_grad2ddiag (2 3 4)            
//Bit 31:24, reserved 
//Bit 23:16, reg_srscl1_uk_grad2ddiag_lv2   lev2, d_diag level limit for 3rd piece;   default = 128;
//Bit 15: 8, reg_srscl1_uk_grad2ddiag_lv1   lev1, d_diag level limit for 2nd piece;   default = 128;
//Bit  7: 0, reg_srscl1_uk_grad2ddiag_lv0   lev0, d_diag level limit for 1st piece;   default = 128;
#define SRSCL1_UK_GRAD2DADJA_TH_RATE               ((0x3123  << 2) + 0xd0100000)
//reg_srscl1_uk_grad2adja (0 1 5 6)  Wk_nrm to d_adja mapping curve parameter for UK calculation:         
//Bit 31:24, reg_srscl1_uk_grad2dadja_rate1 rate1, d_adja level trasition rate 2nd towards 3rd piece;   default = 20;
//Bit 23:16, reg_srscl1_uk_grad2dadja_rate0 rate0, d_adja level trasition rate 2nd towards 1st piece;   default = 80;
//Bit 15: 8, reg_srscl1_uk_grad2dadja_th1   th1, threshold to (c+wk_nrm) for second/3rd piece;   default = 60;
//Bit  7: 0, reg_srscl1_uk_grad2dadja_th0   th0, threshold to (c+wk_nrm) for first/second piece;   default = 25;
#define SRSCL1_UK_GRAD2DADJA_LIMIT                 ((0x3124  << 2) + 0xd0100000)
//reg_srscl1_uk_grad2dadja (2 3 4)            
//Bit 31:24, reserved    
//Bit 23:16, reg_srscl1_uk_grad2dadja_lv2   lev2, d_adja level limit for 3rd piece;   default = 128;
//Bit 15: 8, reg_srscl1_uk_grad2dadja_lv1   lev1, d_adja level limit for 2nd piece;   default = 128;
//Bit  7: 0, reg_srscl1_uk_grad2dadja_lv0   lev0, d_adja level limit for 1st piece;   default = 128;
#define SRSCL1_UK_BST_GAIN                         ((0x3125  << 2) + 0xd0100000)
//Bit 31:24, reg_srscl1_bst_cgain           Gain to Uk_diag, normalized to 32 as “1”  default = 122;
//Bit 23:16, reg_srscl1_bst_ygain           Gain to Uk_adja, normalized to 32 as “1”  default = 122;
//Bit 15: 8, reg_srscl1_uk_adja_gain        Boost gain to delta component of SR scalar refine for luma channel. It is applied to tDiv.
//                                          Normalized to 128 as “1”  default = 58;
//Bit  7: 0, reg_srscl1_uk_diag_gain        Boost gain to delta component of SR scalar refine for chroma channel. It is applied to tDiv.
//                                          Normalized to 128 as “1”  default = 80;
#define SRSCL1_HVBLEND_TH                          ((0x3126  << 2) + 0xd0100000)
//Bit 31:29, reserved 
//Bit 28:24, reg_srscl1_hvblend_th3         Rate threshold to decide HV protection blend rate, default = 8;
//Bit 23:21, reserved 
//Bit 20:16, reg_srscl1_hvblend_th2         the same as above;  default = 8;
//Bit 15:13, reserved 
//Bit 12: 8, reg_srscl1_hvblend_th1         the same as above;  default = 4;
//Bit  7: 5, reserved 
//Bit  4: 0, reg_srscl1_hvblend_th0         the same as above;  default = 4;
#define SRSCL1_DEMO_WIND_TB                        ((0x3127  << 2) + 0xd0100000)
//Bit 31:29, reserved 
//Bit 28:16, reg_srscl1_demo_wind_top       Demo mode window vertical top boundary range;  default = 8191;
//Bit 15:13, reserved 
//Bit 12: 0, reg_srscl1_demo_wind_bot       Demo mode window vertical bottom boundary range;  default = 0;
#define SRSCL1_DEMO_WIND_LR                        ((0x3128  << 2) + 0xd0100000)
//Bit 31:29, reserved 
//Bit 28:16, reg_srscl1_demo_wind_right     Demo mode window vertical right boundary range;  default = 8191;
//Bit 15:13, reserved 
//Bit 12: 0, reg_srscl1_demo_wind_left      Demo mode window vertical left boundary range;  default = 0;
#define SRSCL1_INT_BLANK_NUM                       ((0x3129  << 2) + 0xd0100000)
//Bit 31:21, reserved  
//Bit    20, reg_srscl1_rst_syn_en          for syn same control reg to rst_n posedge. default=0;
//Bit 19:16, reg_srscl1_inbuf_hsk_stuff     default=2
//Bit 15: 8, reg_srscl1_int_vbk_num         interpolation vertical   blank num   default=24
//Bit  7: 0, reg_srscl1_int_hbk_num         interpolation horizontal blank num   default=8
#define SRSCL_FRM_END_STAT                         ((0x312a  << 2) + 0xd0100000)
//Bit 31: 1, reserved  
//Bit     0, reg_frm_end_stat               frame end status   default=0
#define SRSCL1_YBIC_HCOEF0                         ((0x312b  << 2) + 0xd0100000)
//Bit 31:24, reg_srscl1_y_bic_hcoef03         Horizontal bi-cubic filter of 0.5 phase of luma channel (for core_0)
//                                            Filter will be normalized to 128 as ‘1’; default=0                         
//Bit 23:16, reg_srscl1_y_bic_hcoef02         the same as above; default=0                         
//Bit 15: 8, reg_srscl1_y_bic_hcoef01         the same as above; default=128                        
//Bit  7: 0, reg_srscl1_y_bic_hcoef00         the same as above; default=0
#define SRSCL1_CBIC_HCOEF0                         ((0x312c  << 2) + 0xd0100000)
//Bit 31:24, reg_srscl1_c_bic_hcoef03         Horizontal bi-cubic filter of 0.5 phase of chroma channel (for core_0)
//                                            Filter will be normalized to 128 as ‘1’; default=0                         
//Bit 23:16, reg_srscl1_c_bic_hcoef02         the same as above; default=0                         
//Bit 15: 8, reg_srscl1_c_bic_hcoef01         the same as above; default=128                         
//Bit  7: 0, reg_srscl1_c_bic_hcoef00         the same as above; default=0
#define SRSCL1_YBIC_VCOEF0                         ((0x312d  << 2) + 0xd0100000)
//Bit 31:24, reg_srscl1_y_bic_vcoef03         Vertical bi-cubic filter of 0.5 phase of luma channel (for core_0)
//                                            Filter will be normalized to 128 as ‘1’; default=0                         
//Bit 23:16, reg_srscl1_y_bic_vcoef02         the same as above; default=0                         
//Bit 15: 8, reg_srscl1_y_bic_vcoef01         the same as above; default=128                         
//Bit  7: 0, reg_srscl1_y_bic_vcoef00         the same as above; default=0
#define SRSCL1_CBIC_VCOEF0                         ((0x312e  << 2) + 0xd0100000)
//Bit 31:24, reg_srscl1_c_bic_vcoef03         Vertical bi-cubic filter of 0.5 phase of chroma channel (for core_0)
//                                            Filter will be normalized to 128 as ‘1’; default=0                         
//Bit 23:16, reg_srscl1_c_bic_vcoef02         the same as above; default=0                         
//Bit 15: 8, reg_srscl1_c_bic_vcoef01         the same as above; default=128                         
//Bit  7: 0, reg_srscl1_c_bic_vcoef00         the same as above; default=0
////=================================================================////
//// super scaler core 1
////=================================================================////
#define OSDSR_HV_SIZEIN                            ((0x3130  << 2) + 0xd0100000)
//Bit 31:29, reserved  
//Bit 28:16, reg_srscl1_hsize               image horizontal size (number of cols)   default=2048 
//Bit 15:13, reserved                       
//Bit 12: 0, reg_srscl1_vsize               image vertical size   (number of rows)   default=2048
#define OSDSR_CTRL_MODE                            ((0x3131  << 2) + 0xd0100000)
//Bit 31:16, reserved     
//Bit 15,    reg_srscl1_cmpmux_aft           u1: 0 no swap anf for YUV->YUV; 1, swapped and for GBR-RGB; default = 0
//Bit 14,    reg_srscl1_cmpmux_bef           u1: 0 no swap anf for YUV->YUV; 1, swapped and for RGB->GBR; default = 0
//Bit 13,    reg_srscl1_bic_norm             normalization of bicubical: 0: 128|128; 1: 64|64  default = 0
//Bit 12,    reg_srscl1_3dint_mode           option for line-by-line 3D cases     default = 0
//Bit 11,    reg_srscl1_3dint_hadj_cub       option for using cubic interpolation for horizontal adjacent pixels     default = 0
//Bit 10,    reg_srscl1_3dint_phase          phase for super-scalar output under 1Vx2H ration: 0: 0 phase, 1: 1/2 phase     default = 0
//Bit 9,     reg_srscl1_cuse_bic_od          outside demo window chroma use bicubical interpolation    default = 0
//Bit 8,     reg_srscl1_yuse_bic_od          outside demo window luma use bicubical interpolation    default = 0
//Bit 7,     reg_srscl1_ause_bic_od          outside demo window alpha use bicubical interpolation    default = 0
//Bit 6,     reg_srscl1_cuse_bic             inside demo window luma use bicubical interpolation 
//                                           0: demo window us SR scalar for chroma channel;  
//                                           1: demo window use Bi-cubic scalar for chroma channel        default = 0
//Bit 5,     reg_srscl1_yuse_bic             inside demo window luma use bicubical interpolation 
//                                           0: demo window us SR scalar for luma channel;  
//                                           1: demo window use Bi-cubic scalar for luma channel        default = 0
//Bit 4,     reg_srscl1_ause_bic             inside demo window alpha use bicubical interpolation 
//                                           0: demo window us SR scalar for alpha channel;  
//                                           1: demo window use Bi-cubic scalar for alpha channel        default = 0
//Bit 3,     reg_srscl1_use_3lrln            Options to extend 3 lines low-resolution data to 5-lines for SR scalar, (for core_0):
//                                           0: normal working mode, using 5 lines 
//                                           1: extend effective 3 lines to 5 lines; (will be used in line-by-line 3D contents)         default = 
//Bit 2,     reg_srscl1_vert_ratio           Vertical scalar ratio of Super Scalar core_0;
//                                           0: 1x scale; 1: 2x scale;    default = 
//Bit 1,     reg_srscl1_hori_ratio           Horizontal scalar ratio of Super Scalar core_0;
//                                           0: 1x scale; 1: 2x scale;    default = 
//Bit 0,     reg_srscl1_enable               Enable of Super Scalar core_0: 
//                                           0: disable (bypass) 1: enable    default = 
#define OSDSR_ABIC_HCOEF                           ((0x3132  << 2) + 0xd0100000)
//Bit 31:24, reg_srscl1_a_bic_hcoef3         Horizontal bi-cubic filter of 0.5 phase of alpha channel (for core_0)
//                                           Filter will be normalized to 128 as ‘1’; default=-8                         
//Bit 23:16, reg_srscl1_a_bic_hcoef2         the same as above; default=72                         
//Bit 15: 8, reg_srscl1_a_bic_hcoef1         the same as above; default=72                         
//Bit  7: 0, reg_srscl1_a_bic_hcoef0         the same as above; default=-8
#define OSDSR_YBIC_HCOEF                           ((0x3133  << 2) + 0xd0100000)
//Bit 31:24, reg_srscl1_y_bic_hcoef3         Horizontal bi-cubic filter of 0.5 phase of luma channel (for core_0)
//                                           Filter will be normalized to 128 as ‘1’; default=-8                         
//Bit 23:16, reg_srscl1_y_bic_hcoef2         the same as above; default=72                         
//Bit 15: 8, reg_srscl1_y_bic_hcoef1         the same as above; default=72                         
//Bit  7: 0, reg_srscl1_y_bic_hcoef0         the same as above; default=-8
#define OSDSR_CBIC_HCOEF                           ((0x3134  << 2) + 0xd0100000)
//Bit 31:24, reg_srscl1_c_bic_hcoef3         Horizontal bi-cubic filter of 0.5 phase of chroma channel (for core_0)
//                                           Filter will be normalized to 128 as ‘1’; default=-8                         
//Bit 23:16, reg_srscl1_c_bic_hcoef2         the same as above; default=72                         
//Bit 15: 8, reg_srscl1_c_bic_hcoef1         the same as above; default=72                         
//Bit  7: 0, reg_srscl1_c_bic_hcoef0         the same as above; default=-8
#define OSDSR_ABIC_VCOEF                           ((0x3135  << 2) + 0xd0100000)
//Bit 31:24, reg_srscl1_a_bic_vcoef3         Vertical bi-cubic filter of 0.5 phase of alpha channel (for core_0)
//                                           Filter will be normalized to 128 as ‘1’; default=-8                         
//Bit 23:16, reg_srscl1_a_bic_vcoef2         the same as above; default=72                         
//Bit 15: 8, reg_srscl1_a_bic_vcoef1         the same as above; default=72                         
//Bit  7: 0, reg_srscl1_a_bic_vcoef0         the same as above; default=-8
#define OSDSR_YBIC_VCOEF                           ((0x3136  << 2) + 0xd0100000)
//Bit 31:24, reg_srscl1_y_bic_vcoef3         Vertical bi-cubic filter of 0.5 phase of luma channel (for core_0)
//                                           Filter will be normalized to 128 as ‘1’; default=-8                         
//Bit 23:16, reg_srscl1_y_bic_vcoef2         the same as above; default=72                         
//Bit 15: 8, reg_srscl1_y_bic_vcoef1         the same as above; default=72                         
//Bit  7: 0, reg_srscl1_y_bic_vcoef0         the same as above; default=-8
#define OSDSR_CBIC_VCOEF                           ((0x3137  << 2) + 0xd0100000)
//Bit 31:24, reg_srscl1_c_bic_vcoef3         Vertical bi-cubic filter of 0.5 phase of chroma channel (for core_0)
//                                           Filter will be normalized to 128 as ‘1’; default=-8                         
//Bit 23:16, reg_srscl1_c_bic_vcoef2         the same as above; default=72                         
//Bit 15: 8, reg_srscl1_c_bic_vcoef1         the same as above; default=72                         
//Bit  7: 0, reg_srscl1_c_bic_vcoef0         the same as above; default=-8
#define OSDSR_VAR_PARA                             ((0x3138  << 2) + 0xd0100000)
//Bit 31:26, reserved  
//Bit 25:24, reg_srscl1_var_adja_rs          Horizontal/vertical adjacent pixel noise normalized variance value right shift bits.  default= 2   
//Bit 23:16, reg_srscl1_var_adja             Horizontal/vertical adjacent pixel noise normalized variance value. 
//                                           Var2 = (2^(11+rs))/gain; default= 68
//Bit 15:10, reserved  
//Bit  9: 8, reg_srscl1_var_diag_rs          Diagonal pixel noise normalized variance value right shift bits. default= 3    
//Bit  7: 0, reg_srscl1_var_diag             Diagonal pixel noise normalized variance value. Var2 = (2^(11+rs))/gain; default= 68
#define OSDSR_CONST_PARA                           ((0x3139  << 2) + 0xd0100000)
//Bit 31:16, reserved  
//Bit 15: 8, reg_srscl1_c_adja               Constant for d_adja calculation from wk_nrm; Normalize 128 as “1” default= 32     
//Bit  7: 0, reg_srscl1_c_diag               Constant for d_diag calculation from wk_nrm; Normalize 128 as “1” default= 32
#define OSDSR_RKE_EXTWIN                           ((0x313a  << 2) + 0xd0100000)
//Bit 31:23, reserved  
//Bit 22:20, reg_srscl1_rke_extwin         Window size for Rke horizontal extension: Win_size = 2x+1 scope: 0~5;  default= 4
//Bit 19:16, reg_srscl1_rke_coring         Coring to Rke default= 10
//Bit 15:13, reserved  
//Bit 12: 8, reg_srscl1_rke_extwin_core    Coring to Rks before local window maximum value calculation     default= 10 
//Bit  7: 0, reg_srscl1_rke_extwin_rate    Rate to blender strength (gamma), gamma is used to blend local maximum Rke and current Rke; the rate is normalized to 16 as “1”  default= 12
#define OSDSR_UK_GRAD2DDIAG_TH_RATE                ((0x313b  << 2) + 0xd0100000)
//reg_srscl1_uk_grad2ddiag (0 1 5 6)  Wk_nrm to d_diag mapping curve parameter for UK calculation:         
//Bit 31:24, reg_srscl1_uk_grad2ddiag_rate1 rate1, d_diag level trasition rate 2nd towards 3rd piece;   default = 20;
//Bit 23:16, reg_srscl1_uk_grad2ddiag_rate0 rate0, d_diag level trasition rate 2nd towards 1st piece;   default = 80;
//Bit 15: 8, reg_srscl1_uk_grad2ddiag_th1   th1, threshold to (c+wk_nrm) for second/3rd piece;   default = 60;
//Bit  7: 0, reg_srscl1_uk_grad2ddiag_th0   th0, threshold to (c+wk_nrm) for first/second piece;   default = 25;
#define OSDSR_UK_GRAD2DDIAG_LIMIT                  ((0x313c  << 2) + 0xd0100000)
//reg_srscl1_uk_grad2ddiag (2 3 4)            
//Bit 31:24, reserved 
//Bit 23:16, reg_srscl1_uk_grad2ddiag_lv2   lev2, d_diag level limit for 3rd piece;   default = 128;
//Bit 15: 8, reg_srscl1_uk_grad2ddiag_lv1   lev1, d_diag level limit for 2nd piece;   default = 128;
//Bit  7: 0, reg_srscl1_uk_grad2ddiag_lv0   lev0, d_diag level limit for 1st piece;   default = 128;
#define OSDSR_UK_GRAD2DADJA_TH_RATE                ((0x313d  << 2) + 0xd0100000)
//reg_srscl1_uk_grad2adja (0 1 5 6)  Wk_nrm to d_adja mapping curve parameter for UK calculation:         
//Bit 31:24, reg_srscl1_uk_grad2dadja_rate1 rate1, d_adja level trasition rate 2nd towards 3rd piece;   default = 20;
//Bit 23:16, reg_srscl1_uk_grad2dadja_rate0 rate0, d_adja level trasition rate 2nd towards 1st piece;   default = 80;
//Bit 15: 8, reg_srscl1_uk_grad2dadja_th1   th1, threshold to (c+wk_nrm) for second/3rd piece;   default = 60;
//Bit  7: 0, reg_srscl1_uk_grad2dadja_th0   th0, threshold to (c+wk_nrm) for first/second piece;   default = 25;
#define OSDSR_UK_GRAD2DADJA_LIMIT                  ((0x313e  << 2) + 0xd0100000)
//reg_srscl1_uk_grad2dadja (2 3 4)            
//Bit 31:24, reserved    
//Bit 23:16, reg_srscl1_uk_grad2dadja_lv2   lev2, d_adja level limit for 3rd piece;   default = 128;
//Bit 15: 8, reg_srscl1_uk_grad2dadja_lv1   lev1, d_adja level limit for 2nd piece;   default = 128;
//Bit  7: 0, reg_srscl1_uk_grad2dadja_lv0   lev0, d_adja level limit for 1st piece;   default = 128;
#define OSDSR_UK_BST_GAIN                          ((0x313f  << 2) + 0xd0100000)
//Bit 31:24, reg_srscl1_bst_cgain           Gain to Uk_diag, normalized to 32 as “1”  default = 122;
//Bit 23:16, reg_srscl1_bst_ygain           Gain to Uk_adja, normalized to 32 as “1”  default = 122;
//Bit 15: 8, reg_srscl1_uk_adja_gain        Boost gain to delta component of SR scalar refine for luma channel. It is applied to tDiv.
//                                          Normalized to 128 as “1”  default = 58;
//Bit  7: 0, reg_srscl1_uk_diag_gain        Boost gain to delta component of SR scalar refine for chroma channel. It is applied to tDiv.
//                                          Normalized to 128 as “1”  default = 80;
#define OSDSR_HVBLEND_TH                           ((0x3140  << 2) + 0xd0100000)
//Bit 31:29, reserved 
//Bit 28:24, reg_srscl1_hvblend_th3         Rate threshold to decide HV protection blend rate, default = 8;
//Bit 23:21, reserved 
//Bit 20:16, reg_srscl1_hvblend_th2         the same as above;  default = 8;
//Bit 15:13, reserved 
//Bit 12: 8, reg_srscl1_hvblend_th1         the same as above;  default = 4;
//Bit  7: 5, reserved 
//Bit  4: 0, reg_srscl1_hvblend_th0         the same as above;  default = 4;
#define OSDSR_DEMO_WIND_TB                         ((0x3141  << 2) + 0xd0100000)
//Bit 31:29, reserved 
//Bit 28:16, reg_srscl1_demo_wind_top       Demo mode window vertical top boundary range;  default = 8191;
//Bit 15:13, reserved 
//Bit 12: 0, reg_srscl1_demo_wind_bot       Demo mode window vertical bottom boundary range;  default = 0;
#define OSDSR_DEMO_WIND_LR                         ((0x3142  << 2) + 0xd0100000)
//Bit 31:29, reserved 
//Bit 28:16, reg_srscl1_demo_wind_right     Demo mode window vertical right boundary range;  default = 8191;
//Bit 15:13, reserved 
//Bit 12: 0, reg_srscl1_demo_wind_left      Demo mode window vertical left boundary range;  default = 0;
#define OSDSR_INT_BLANK_NUM                        ((0x3143  << 2) + 0xd0100000)
//Bit 31:21, reserved  
//Bit    20, reg_srscl1_rst_syn_en          for syn same control reg to rst_n posedge. default=0;
//Bit 19:16, reg_srscl1_inbuf_hsk_stuff     default=2
//Bit 15: 8, reg_srscl1_int_vbk_num         interpolation vertical   blank num   default=24
//Bit  7: 0, reg_srscl1_int_hbk_num         interpolation horizontal blank num   default=8
#define OSDSR_FRM_END_STAT                         ((0x3144  << 2) + 0xd0100000)
//Bit 31: 1, reserved  
//Bit     0, reg_frm_end_stat               frame end status   default=0
#define OSDSR_ABIC_HCOEF0                          ((0x3145  << 2) + 0xd0100000)
//Bit 31:24, reg_srscl1_a_bic_hcoef03         Horizontal bi-cubic filter of 0.5 phase of luma channel (for core_0)
//                                            Filter will be normalized to 128 as ‘1’; default=0                         
//Bit 23:16, reg_srscl1_a_bic_hcoef02         the same as above; default=0                         
//Bit 15: 8, reg_srscl1_a_bic_hcoef01         the same as above; default=128                        
//Bit  7: 0, reg_srscl1_a_bic_hcoef00         the same as above; default=0
#define OSDSR_YBIC_HCOEF0                          ((0x3146  << 2) + 0xd0100000)
//Bit 31:24, reg_srscl1_y_bic_hcoef03         Horizontal bi-cubic filter of 0.5 phase of luma channel (for core_0)
//                                            Filter will be normalized to 128 as ‘1’; default=0                         
//Bit 23:16, reg_srscl1_y_bic_hcoef02         the same as above; default=0                         
//Bit 15: 8, reg_srscl1_y_bic_hcoef01         the same as above; default=128                        
//Bit  7: 0, reg_srscl1_y_bic_hcoef00         the same as above; default=0
#define OSDSR_CBIC_HCOEF0                          ((0x3147  << 2) + 0xd0100000)
//Bit 31:24, reg_srscl1_c_bic_hcoef03         Horizontal bi-cubic filter of 0.5 phase of chroma channel (for core_0)
//                                            Filter will be normalized to 128 as ‘1’; default=0                         
//Bit 23:16, reg_srscl1_c_bic_hcoef02         the same as above; default=0                         
//Bit 15: 8, reg_srscl1_c_bic_hcoef01         the same as above; default=128                         
//Bit  7: 0, reg_srscl1_c_bic_hcoef00         the same as above; default=0
#define OSDSR_ABIC_VCOEF0                          ((0x3148  << 2) + 0xd0100000)
//Bit 31:24, reg_srscl1_a_bic_vcoef03         Vertical bi-cubic filter of 0.5 phase of luma channel (for core_0)
//                                            Filter will be normalized to 128 as ‘1’; default=0                         
//Bit 23:16, reg_srscl1_a_bic_vcoef02         the same as above; default=0                         
//Bit 15: 8, reg_srscl1_a_bic_vcoef01         the same as above; default=128                         
//Bit  7: 0, reg_srscl1_a_bic_vcoef00         the same as above; default=0
#define OSDSR_YBIC_VCOEF0                          ((0x3149  << 2) + 0xd0100000)
//Bit 31:24, reg_srscl1_y_bic_vcoef03         Vertical bi-cubic filter of 0.5 phase of luma channel (for core_0)
//                                            Filter will be normalized to 128 as ‘1’; default=0                         
//Bit 23:16, reg_srscl1_y_bic_vcoef02         the same as above; default=0                         
//Bit 15: 8, reg_srscl1_y_bic_vcoef01         the same as above; default=128                         
//Bit  7: 0, reg_srscl1_y_bic_vcoef00         the same as above; default=0
#define OSDSR_CBIC_VCOEF0                          ((0x314a  << 2) + 0xd0100000)
//Bit 31:24, reg_srscl1_c_bic_vcoef03         Vertical bi-cubic filter of 0.5 phase of chroma channel (for core_0)
//                                            Filter will be normalized to 128 as ‘1’; default=0                         
//Bit 23:16, reg_srscl1_c_bic_vcoef02         the same as above; default=0                         
//Bit 15: 8, reg_srscl1_c_bic_vcoef01         the same as above; default=128                         
//Bit  7: 0, reg_srscl1_c_bic_vcoef00         the same as above; default=0
//
// Reading file:  xvycc_regs.h
//
// synopsys translate_off
// synopsys translate_on
//    `define XVYCC_VCBUS_BASE	   8'hfe
#define XVYCC_INV_LUT_Y_ADDR_PORT                  ((0x3158  << 2) + 0xd0100000)
//Bit 31:7, reserved  
//Bit  6:0,  xvycc_inv_lut_y_addr;
#define XVYCC_INV_LUT_Y_DATA_PORT                  ((0x3159  << 2) + 0xd0100000)
//Bit 31:12, reserved  
//Bit  11:0, xvycc_inv_lut_y_data;
#define XVYCC_INV_LUT_U_ADDR_PORT                  ((0x315a  << 2) + 0xd0100000)
//Bit 31:6, reserved  
//Bit  5:0,  xvycc_inv_lut_u_addr;
#define XVYCC_INV_LUT_U_DATA_PORT                  ((0x315b  << 2) + 0xd0100000)
//Bit 31:12, reserved  
//Bit  11:0, xvycc_inv_lut_u_data;
#define XVYCC_INV_LUT_V_ADDR_PORT                  ((0x315c  << 2) + 0xd0100000)
//Bit 31:6, reserved  
//Bit  5:0,  xvycc_inv_lut_v_addr;
#define XVYCC_INV_LUT_V_DATA_PORT                  ((0x315d  << 2) + 0xd0100000)
//Bit 31:12, reserved  
//Bit  11:0, xvycc_inv_lut_v_data;
#define XVYCC_LUT_R_ADDR_PORT                      ((0x315e  << 2) + 0xd0100000)
//Bit 31:7, reserved  
//Bit  6:0,  xvycc_lut_r_addr;
#define XVYCC_LUT_R_DATA_PORT                      ((0x315f  << 2) + 0xd0100000)
//Bit 31:10, reserved  
//Bit  9:0,  xvycc_lut_r_data;
#define XVYCC_LUT_G_ADDR_PORT                      ((0x3160  << 2) + 0xd0100000)
//Bit 31:7, reserved  
//Bit  6:0,  xvycc_lut_g_addr;
#define XVYCC_LUT_G_DATA_PORT                      ((0x3161  << 2) + 0xd0100000)
//Bit 31:10, reserved  
//Bit  9:0,  xvycc_lut_g_data;
#define XVYCC_LUT_B_ADDR_PORT                      ((0x3162  << 2) + 0xd0100000)
//Bit 31:7, reserved  
//Bit  6:0,  xvycc_lut_b_addr;
#define XVYCC_LUT_B_DATA_PORT                      ((0x3163  << 2) + 0xd0100000)
//Bit 31:10, reserved  
//Bit  9:0,  xvycc_lut_b_data;
#define XVYCC_INV_LUT_CTL                          ((0x3164  << 2) + 0xd0100000)
//Bit 31:15, reserved  
//Bit 14:12, reg_xvycc_cmpr_invlut_enable    enable for xvycc compression inverse-lut [2] for Y, [1] for U, [0] for V default=0
//Bit 11:10, reg_xvycc_cmpr_invlut_vscl_1   v LUT input scale for positive portion   default=0
//Bit  9: 8, reg_xvycc_cmpr_invlut_vscl_0   v LUT input scale for negative portion   default=0
//Bit  7: 6, reg_xvycc_cmpr_invlut_uscl_1   u LUT input scale for positive portion   default=0
//Bit  5: 4, reg_xvycc_cmpr_invlut_uscl_0   u LUT input scale for negative portion   default=0
//Bit  3: 2, reg_xvycc_cmpr_invlut_yscl_1   y LUT input scale for positive portion   default=0
//Bit  1: 0, reg_xvycc_cmpr_invlut_yscl_0   y LUT input scale for negative portion   default=0
#define XVYCC_LUT_CTL                              ((0x3165  << 2) + 0xd0100000)
//Bit 31: 7, reserved  
//Bit  6: 4, reg_xvycc_lut_enable  LUT enable [6] for R, [5] for G, [4] for B  default=0
//Bit  3: 2, reg_xvycc_lut_scl_1   LUT input scale for positive portion   default=0
//Bit  1: 0, reg_xvycc_lut_scl_0   LUT input scale for negative portion   default=0
#define XVYCC_VADJ1_CURV_0                         ((0x3166  << 2) + 0xd0100000)
//Bit 31:24, vadj1_softcon_curv0_ci                         default=0
//Bit 23:12, vadj1_softcon_curv0_b                          default=0
//Bit 11: 0, vadj1_softcon_curv0_a                          default=0
#define XVYCC_VADJ1_CURV_1                         ((0x3167  << 2) + 0xd0100000)
//Bit 31:13, reserved
//Bit 12: 4, vadj1_softcon_curv0_g                          default=0
//Bit     3, reserved
//Bit  2: 0, vadj1_softcon_curv0_cs                         default=0
#define XVYCC_VADJ1_CURV_2                         ((0x3168  << 2) + 0xd0100000)
//Bit 31:24, vadj1_softcon_curv1_ci                         default=0
//Bit 23:12, vadj1_softcon_curv1_b                          default=0
//Bit 11: 0, vadj1_softcon_curv1_a                          default=0
#define XVYCC_VADJ1_CURV_3                         ((0x3169  << 2) + 0xd0100000)
//Bit 31:13, reserved
//Bit 12: 4, vadj1_softcon_curv1_g                          default=0
//Bit     3, reserved
//Bit  2: 0, vadj1_softcon_curv1_cs                         default=0
#define XVYCC_VADJ2_CURV_0                         ((0x316a  << 2) + 0xd0100000)
//Bit 31:24, vadj2_softcon_curv0_ci                         default=0
//Bit 23:12, vadj2_softcon_curv0_b                          default=0
//Bit 11: 0, vadj2_softcon_curv0_a                          default=0
#define XVYCC_VADJ2_CURV_1                         ((0x316b  << 2) + 0xd0100000)
//Bit 31:13, reserved
//Bit 12: 4, vadj2_softcon_curv0_g                          default=0
//Bit     3, reserved
//Bit  2: 0, vadj2_softcon_curv0_cs                         default=0
#define XVYCC_VADJ2_CURV_2                         ((0x316c  << 2) + 0xd0100000)
//Bit 31:24, vadj2_softcon_curv1_ci                         default=0
//Bit 23:12, vadj2_softcon_curv1_b                          default=0
//Bit 11: 0, vadj2_softcon_curv1_a                          default=0
#define XVYCC_VADJ2_CURV_3                         ((0x316d  << 2) + 0xd0100000)
//Bit 31:13, reserved
//Bit 12: 4, vadj2_softcon_curv1_g                          default=0
//Bit     3, reserved
//Bit  2: 0, vadj2_softcon_curv1_cs                         default=0
#define XVYCC_VD1_RGB_CTRST                        ((0x3170  << 2) + 0xd0100000)
//Bit 31:28, reserved    
//Bit 27:16, reg_vd1_rgb_ctrst        u12, contrast in rgb.      default=1024
//Bit 15:14, reserved  
//Bit 13: 4, reg_vd1_rgb_ctrst_blklvl u10, contrast blacklevel   default=64 
//Bit  3: 2, reserved  
//Bit     1, reg_vd1_rgbbst_en         u1, enable rgbbst         default=0 
//Bit     0, reg_vd1_rgb_ctrst_prt     u1, enable signal to protect saturation in rgb.  default=1 
#define XVYCC_VD1_RGB_BRGHT                        ((0x3171  << 2) + 0xd0100000)
//Bit 31:16, reserved
//Bit 15: 4, reg_vd1_rgb_brght        s12, brightness level in rgb domain                              default=0 
//Bit  3: 2, reserved
//Bit     1, reg_vd1_rgb_brght_prt     u1, enalbe signal to protect saturation in rgb                  default=1
//Bit     0, reg_vd1_rgbbst_dlut_x2    u1, enable signal to do x2 to the dlut cells before subtracting default=0
#define XVYCC_VD1_RGB_DLUT_0_3                     ((0x3172  << 2) + 0xd0100000)
//Bit 31:24, reg_vd1_rgbbst_dlut0      u8,   default = 255
//Bit 23:16, reg_vd1_rgbbst_dlut1      u8,   default = 205
//Bit 15: 8, reg_vd1_rgbbst_dlut2      u8,   default = 171
//Bit  7: 0, reg_vd1_rgbbst_dlut3      u8,   default = 147 
#define XVYCC_VD1_RGB_DLUT_4_7                     ((0x3173  << 2) + 0xd0100000)
//Bit 31:24, reg_vd1_rgbbst_dlut4      u8,   default = 128
//Bit 23:16, reg_vd1_rgbbst_dlut5      u8,   default = 113
//Bit 15: 8, reg_vd1_rgbbst_dlut6      u8,   default = 102
//Bit  7: 0, reg_vd1_rgbbst_dlut7      u8,   default = 93 
#define XVYCC_VD1_RGB_DLUT_8_11                    ((0x3174  << 2) + 0xd0100000)
//Bit 31:24, reg_vd1_rgbbst_dlut8      u8,   default = 85
//Bit 23:16, reg_vd1_rgbbst_dlut9      u8,   default = 78
//Bit 15: 8, reg_vd1_rgbbst_dlut10     u8,   default = 73
//Bit  7: 0, reg_vd1_rgbbst_dlut11     u8,   default = 68 
#define XVYCC_POST_RGB_CTRST                       ((0x3175  << 2) + 0xd0100000)
//Bit 31:28, reserved    
//Bit 27:16, reg_post_rgb_ctrst        u12, contrast in rgb.      default=1024
//Bit 15:14, reserved  
//Bit 13: 4, reg_post_rgb_ctrst_blklvl u10, contrast blacklevel   default=64 
//Bit  3: 2, reserved 
//Bit     1, reg_post_rgbbst_en         u1, enable rgbbst         default=0 
//Bit     0, reg_post_rgb_ctrst_prt     u1, enable signal to protect saturation in rgb.  default=1 
#define XVYCC_POST_RGB_BRGHT                       ((0x3176  << 2) + 0xd0100000)
//Bit 31:16, reserved
//Bit 15: 4, reg_post_rgb_brght        s12, brightness level in rgb domain                              default=0 
//Bit  3: 2, reserved
//Bit     1, reg_post_rgb_brght_prt     u1, enalbe signal to protect saturation in rgb                  default=1
//Bit     0, reg_post_rgbbst_dlut_x2    u1, enable signal to do x2 to the dlut cells before subtracting default=0
#define XVYCC_POST_RGB_DLUT_0_3                    ((0x3177  << 2) + 0xd0100000)
//Bit 31:24, reg_post_rgbbst_dlut0      u8,   default = 255
//Bit 23:16, reg_post_rgbbst_dlut1      u8,   default = 205
//Bit 15: 8, reg_post_rgbbst_dlut2      u8,   default = 171
//Bit  7: 0, reg_post_rgbbst_dlut3      u8,   default = 147 
#define XVYCC_POST_RGB_DLUT_4_7                    ((0x3178  << 2) + 0xd0100000)
//Bit 31:24, reg_post_rgbbst_dlut4      u8,   default = 128
//Bit 23:16, reg_post_rgbbst_dlut5      u8,   default = 113
//Bit 15: 8, reg_post_rgbbst_dlut6      u8,   default = 102
//Bit  7: 0, reg_post_rgbbst_dlut7      u8,   default = 93 
#define XVYCC_POST_RGB_DLUT_8_11                   ((0x3179  << 2) + 0xd0100000)
//Bit 31:24, reg_post_rgbbst_dlut8      u8,   default = 85
//Bit 23:16, reg_post_rgbbst_dlut9      u8,   default = 78
//Bit 15: 8, reg_post_rgbbst_dlut10     u8,   default = 73
//Bit  7: 0, reg_post_rgbbst_dlut11     u8,   default = 68 
// synopsys translate_off
// synopsys translate_on
//
// Closing file:  xvycc_regs.h
//
//////////////////////////////////////////////////////////////////////////////////////////////////////
//  index + data
/////////////////////////////////////////////////////////////////////////////////////////////////////
//// // note there are some space in the header
//// 
//// 
//// //////////////////////////////////////////////////////////////////////////////////////////////////////
//// // read-only registers
//// //////////////////////////////////////////////////////////////////////////////////////////////////////
//// 
// synopsys translate_off
// synopsys translate_on
//
// Closing file:  srscl_reg.h
//
//
// Reading file:  sharp_regs.h
//
// synopsys translate_off
// synopsys translate_on
#define SHARP_HVSIZE                               ((0x3180  << 2) + 0xd0100000)
//Bit 31:29,        reserved                           
//Bit 28:16,        reg_pknr_hsize                                                                                                              . unsigned  , default = 1920
//Bit 15:13,        reserved                           
//Bit 12: 0,        reg_pknr_vsize                                                                                                              . unsigned  , default = 1080
#define SHARP_HVBLANK_NUM                          ((0x3181  << 2) + 0xd0100000)
//Bit 31:16,        reserved                           
//Bit 15: 8,        reg_pknr_hblank_num                                                                                                         . unsigned  , default = 20   
//Bit  7: 0,        reg_pknr_vblank_num                                                                                                         . unsigned  , default = 60   
#define NR_GAUSSIAN_MODE                           ((0x3182  << 2) + 0xd0100000)
//Bit 31: 5,        reserved                           
//Bit  4,            reg_nr_gau_ymode                            : 0 3x3 filter; 1: 5x5 filter                                                   . unsigned  , default = 1   
//Bit  3: 1,        reserved                           
//Bit  0,            reg_nr_gau_cmode                            : 0 3x3 filter; 1: 5x5 filter                                                   . unsigned  , default = 1   
#define PK_HVCON_LPF_MODE                          ((0x3183  << 2) + 0xd0100000)
//Bit 31:30,        reserved                           
//Bit 29:28,        reg_pk_hconhpf_mode                         : 0: no vertical filter;1:[1 2 1]'/4 filter; 2/3: [1 2 2 2 1]'/8 filter         . unsigned  , default = 2   
//Bit 27:26,        reserved                           
//Bit 25:24,        reg_pk_hconbpf_mode                         : 0: no vertical filter;1:[1 2 1]'/4 filter; 2/3: [1 2 2 2 1]'/8 filter         . unsigned  , default = 2   
//Bit 23:22,        reserved                           
//Bit 21:20,        reg_pk_hconlbpf_mode                        : 0: no vertical filter;1:[1 2 1]'/4 filter; 2/3: [1 2 2 2 1]'/8 filter         . unsigned  , default = 2   
//Bit 19:18,        reserved                           
//Bit 17:16,        reg_pk_hconllbpf_mode                       : 0: no vertical filter;1:[1 2 1]'/4 filter; 2/3: [1 2 2 2 1]'/8 filter         . unsigned  , default = 2   
//Bit 15:14,        reserved                           
//Bit 13:12,        reg_pk_vconhpf_mode                         : 0: no horizontal filter;1:[1 2 1]/4 filter; 2: [1 2 2 2 1]/8 filter; 3: [1 2 3 4 3 2 1]/16 filter. unsigned  , default = 2   
//Bit 11:10,        reserved                           
//Bit  9: 8,        reg_pk_vconbpf_mode                         : 0: no horizontal filter;1:[1 2 1]/4 filter; 2: [1 2 2 2 1]/8 filter; 3: [1 2 3 4 3 2 1]/16 filter. unsigned  , default = 2   
//Bit  7: 6,        reserved                           
//Bit  5: 4,        reg_pk_vconlbpf_mode                        : 0: no horizontal filter;1:[1 2 1]/4 filter; 2: [1 2 2 2 1]/8 filter; 3: [1 2 3 4 3 2 1]/16 filter. unsigned  , default = 2   
//Bit  3: 2,        reserved                           
//Bit  1: 0,        reg_pk_vconllbpf_mode                       : 0: no horizontal filter;1:[1 2 1]/4 filter; 2: [1 2 2 2 1]/8 filter; 3: [1 2 3 4 3 2 1]/16 filter. unsigned  , default = 2   
#define PK_CON_BLEND_GAIN                          ((0x3184  << 2) + 0xd0100000)
//Bit 31:28,        reg_pk_hpcon_hpgain                         : 8 as normalized 1                                                             . unsigned  , default = 4   
//Bit 27:24,        reg_pk_hpcon_bpgain                         : 8 as normalized 1                                                             . unsigned  , default = 4   
//Bit 23:20,        reg_pk_hpcon_lbpgain                        : 8 as normalized 1                                                             . unsigned  , default = 0   
//Bit 19:16,        reg_pk_hpcon_llbpgain                       : 8 as normalized 1                                                             . unsigned  , default = 0   
//Bit 15:12,        reg_pk_bpcon_hpgain                         : 8 as normalized 1                                                             . unsigned  , default = 0   
//Bit 11: 8,        reg_pk_bpcon_bpgain                         : 8 as normalized 1                                                             . unsigned  , default = 2   
//Bit  7: 4,        reg_pk_bpcon_lbpgain                        : 8 as normalized 1                                                             . unsigned  , default = 6   
//Bit  3: 0,        reg_pk_bpcon_llbpgain                       : 8 as normalized 1                                                             . unsigned  , default = 0   
#define PK_CON_2CIRHPGAIN_TH_RATE                  ((0x3185  << 2) + 0xd0100000)
//Bit 31:24,        reg_pk_cirhpcon2gain0                       : threshold0 of curve to map hpcon to hpgain for circle hp filter (all 8 direction same). 0~255.. unsigned  , default = 25  
//Bit 23:16,        reg_pk_cirhpcon2gain1                       : threshold1 of curve to map hpcon to hpgain for circle hp filter (all 8 direction same). 0~255.. unsigned  , default = 60  
//Bit 15: 8,        reg_pk_cirhpcon2gain5                       : rate0 (for hpcon<th0) of curve to map hpcon to hpgain for circle hp filter (all 8 direction same). 0~255.. unsigned  , default = 80  
//Bit  7: 0,        reg_pk_cirhpcon2gain6                       : rate1 (for hpcon>th1) of curve to map hpcon to hpgain for circle hp filter (all 8 direction same). 0~255.. unsigned  , default = 20  
#define PK_CON_2CIRHPGAIN_LIMIT                    ((0x3186  << 2) + 0xd0100000)
//Bit 31:24,        reg_pk_cirhpcon2gain2                       : level limit(for hpcon<th0) of curve to map hpcon to hpgain for circle hp filter (all 8 direction same). 0~255.. unsigned  , default = 96  
//Bit 23:16,        reg_pk_cirhpcon2gain3                       : level limit(for th0<hpcon<th1) of curve to map hpcon to hpgain for circle hp filter (all 8 direction same). 0~255.. unsigned  , default = 96  
//Bit 15: 8,        reg_pk_cirhpcon2gain4                       : level limit(for hpcon>th1) of curve to map hpcon to hpgain for circle hp filter (all 8 direction same). 0~255.. unsigned  , default = 5   
//Bit  7: 0,        reserved                           
#define PK_CON_2CIRBPGAIN_TH_RATE                  ((0x3187  << 2) + 0xd0100000)
//Bit 31:24,        reg_pk_cirbpcon2gain0                       : threshold0 of curve to map bpcon to bpgain for circle bp filter (all 8 direction same). 0~255.. unsigned  , default = 20  
//Bit 23:16,        reg_pk_cirbpcon2gain1                       : threshold1 of curve to map bpcon to bpgain for circle bp filter (all 8 direction same).. unsigned  , default = 50  
//Bit 15: 8,        reg_pk_cirbpcon2gain5                       : rate0 (for bpcon<th0) of curve to map bpcon to bpgain for circle bp filter (all 8 direction same). 0~255.. unsigned  , default = 50  
//Bit  7: 0,        reg_pk_cirbpcon2gain6                       : rate1 (for bpcon>th1) of curve to map bpcon to bpgain for circle bp filter (all 8 direction same). 0~255.. unsigned  , default = 25  
#define PK_CON_2CIRBPGAIN_LIMIT                    ((0x3188  << 2) + 0xd0100000)
//Bit 31:24,        reg_pk_cirbpcon2gain2                       : level limit(for bpcon<th0) of curve to map bpcon to bpgain for circle bp filter (all 8 direction same). 0~255.. unsigned  , default = 40  
//Bit 23:16,        reg_pk_cirbpcon2gain3                       : level limit(for th0<bpcon<th1) of curve to map bpcon to bpgain for circle bp filter (all 8 direction same). 0~255.. unsigned  , default = 40  
//Bit 15: 8,        reg_pk_cirbpcon2gain4                       : level limit(for bpcon>th1) of curve to map bpcon to bpgain for circle bp filter (all 8 direction same). 0~255.. unsigned  , default = 5   
//Bit  7: 0,        reserved                           
#define PK_CON_2DRTHPGAIN_TH_RATE                  ((0x3189  << 2) + 0xd0100000)
//Bit 31:24,        reg_pk_drthpcon2gain0                       : threshold0 of curve to map hpcon to hpgain for directional hp filter (best direction). 0~255.. unsigned  , default = 25  
//Bit 23:16,        reg_pk_drthpcon2gain1                       : threshold1 of curve to map hpcon to hpgain for directional hp filter (best direction). 0~255.. unsigned  , default = 60  
//Bit 15: 8,        reg_pk_drthpcon2gain5                       : rate0 (for hpcon<th0) of curve to map hpcon to hpgain for directional hp filter (best direction). 0~255.. unsigned  , default = 80  
//Bit  7: 0,        reg_pk_drthpcon2gain6                       : rate1 (for hpcon>th1) of curve to map hpcon to hpgain for directional hp filter (best direction). 0~255.. unsigned  , default = 20  
#define PK_CON_2DRTHPGAIN_LIMIT                    ((0x318a  << 2) + 0xd0100000)
//Bit 31:24,        reg_pk_drthpcon2gain2                       : level limit(for hpcon<th0) of curve to map hpcon to hpgain for directional hp filter (best direction).. unsigned  , default = 90  
//Bit 23:16,        reg_pk_drthpcon2gain3                       : level limit(for th0<hpcon<th1) of curve to map hpcon to hpgain for directional hp filter (best direction). 0~255.. unsigned  , default = 96  
//Bit 15: 8,        reg_pk_drthpcon2gain4                       : level limit(for hpcon>th1) of curve to map hpcon to hpgain for directional hp filter (best direction). 0~255.. unsigned  , default = 5   
//Bit  7: 0,        reserved                           
#define PK_CON_2DRTBPGAIN_TH_RATE                  ((0x318b  << 2) + 0xd0100000)
//Bit 31:24,        reg_pk_drtbpcon2gain0                       : threshold0 of curve to map bpcon to bpgain for directional bp filter (best direction). 0~255.. unsigned  , default = 20  
//Bit 23:16,        reg_pk_drtbpcon2gain1                       : threshold1 of curve to map bpcon to bpgain for directional bp filter (best direction). 0~255.. unsigned  , default = 50  
//Bit 15: 8,        reg_pk_drtbpcon2gain5                       : rate0 (for bpcon<th0) of curve to map bpcon to bpgain for directional bp filter (best direction). 0~255.. unsigned  , default = 50  
//Bit  7: 0,        reg_pk_drtbpcon2gain6                       : rate1 (for bpcon>th1) of curve to map bpcon to bpgain for directional bp filter (best direction). 0~255.. unsigned  , default = 25  
#define PK_CON_2DRTBPGAIN_LIMIT                    ((0x318c  << 2) + 0xd0100000)
//Bit 31:24,        reg_pk_drtbpcon2gain2                       : level limit(for bpcon<th0) of curve to map bpcon to bpgain for directional bp filter (best direction). 0~255.. unsigned  , default = 40  
//Bit 23:16,        reg_pk_drtbpcon2gain3                       : level limit(for th0<bpcon<th1) of curve to map bpcon to bpgain for directional bp filter (best direction). 0~255.. unsigned  , default = 40  
//Bit 15: 8,        reg_pk_drtbpcon2gain4                       : level limit(for bpcon>th1) of curve to map bpcon to bpgain for directional bp filter (best direction). 0~255.. unsigned  , default = 5   
//Bit  7: 0,        reserved                           
#define PK_CIRFB_LPF_MODE                          ((0x318d  << 2) + 0xd0100000)
//Bit 31:30,        reserved                           
//Bit 29:28,        reg_cirhp_horz_mode                         : no horz filter on HP; 1: [1 2 1]/4; 2/3: [1 2 2 2 1]/8                        . unsigned  , default = 1   
//Bit 27:26,        reserved                           
//Bit 25:24,        reg_cirhp_vert_mode                         : no vert filter on HP; 1: [1 2 1]/4; 2/3: [1 2 2 2 1]/8                        . unsigned  , default = 1   
//Bit 23:22,        reserved                           
//Bit 21:20,        reg_cirhp_diag_mode                         : filter on HP; 1: [1 2 1]/4;                                                   . unsigned  , default = 1   
//Bit 19:14,        reserved                           
//Bit 13:12,        reg_cirbp_horz_mode                         : no horz filter on BP; 1: [1 2 1]/4; 2/3: [1 2 2 2 1]/8                        . unsigned  , default = 1   
//Bit 11:10,        reserved                           
//Bit  9: 8,        reg_cirbp_vert_mode                         : no vert filter on BP; 1: [1 2 1]/4; 2/3: [1 2 2 2 1]/8                        . unsigned  , default = 1   
//Bit  7: 6,        reserved                           
//Bit  5: 4,        reg_cirbp_diag_mode                         : filter on BP; 1: [1 2 1]/4;                                                   . unsigned  , default = 1   
//Bit  3: 0,        reserved                           
#define PK_DRTFB_LPF_MODE                          ((0x318e  << 2) + 0xd0100000)
//Bit 31:30,        reserved                           
//Bit 29:28,        reg_drthp_horz_mode                         : no horz filter on HP; 1: [1 2 1]/4; 2/3: [1 2 2 2 1]/8  2                     . unsigned  , default = 1   
//Bit 27:26,        reserved                           
//Bit 25:24,        reg_drthp_vert_mode                         : no vert filter on HP; 1: [1 2 1]/4; 2/3: [1 2 2 2 1]/8  2                     . unsigned  , default = 1   
//Bit 23:22,        reserved                           
//Bit 21:20,        reg_drthp_diag_mode                         : filter on HP; 1: [1 2 1]/4;                             1                     . unsigned  , default = 1   
//Bit 19:14,        reserved                           
//Bit 13:12,        reg_drtbp_horz_mode                         : no horz filter on BP; 1: [1 2 1]/4; 2/3: [1 2 2 2 1]/8  2                     . unsigned  , default = 1   
//Bit 11:10,        reserved                           
//Bit  9: 8,        reg_drtbp_vert_mode                         : no vert filter on BP; 1: [1 2 1]/4; 2/3: [1 2 2 2 1]/8  2                     . unsigned  , default = 1   
//Bit  7: 6,        reserved                           
//Bit  5: 4,        reg_drtbp_diag_mode                         : filter on BP; 1: [1 2 1]/4;                             1                     . unsigned  , default = 1   
//Bit  3: 0,        reserved                           
#define PK_CIRFB_HP_CORING                         ((0x318f  << 2) + 0xd0100000)
//Bit 31:22,        reserved                           
//Bit 21:16,        reg_cirhp_horz_core                         : coring of HP for Horz                                                         . unsigned  , default = 4   
//Bit 15:14,        reserved                           
//Bit 13: 8,        reg_cirhp_vert_core                         : coring of HP for Vert                                                         . unsigned  , default = 4   
//Bit  7: 6,        reserved                           
//Bit  5: 0,        reg_cirhp_diag_core                         : coring of HP for Diag                                                         . unsigned  , default = 4   
#define PK_CIRFB_BP_CORING                         ((0x3190  << 2) + 0xd0100000)
//Bit 31:22,        reserved                           
//Bit 21:16,        reg_cirbp_horz_core                         : coring of HP for Horz                                                         . unsigned  , default = 4   
//Bit 15:14,        reserved                           
//Bit 13: 8,        reg_cirbp_vert_core                         : coring of HP for Vert                                                         . unsigned  , default = 4   
//Bit  7: 6,        reserved                           
//Bit  5: 0,        reg_cirbp_diag_core                         : coring of HP for Diag                                                         . unsigned  , default = 4   
#define PK_DRTFB_HP_CORING                         ((0x3191  << 2) + 0xd0100000)
//Bit 31:22,        reserved                           
//Bit 21:16,        reg_drthp_horz_core                         : coring of HP for Horz                                                         . unsigned  , default = 4   
//Bit 15:14,        reserved                           
//Bit 13: 8,        reg_drthp_vert_core                         : coring of HP for Vert                                                         . unsigned  , default = 4   
//Bit  7: 6,        reserved                           
//Bit  5: 0,        reg_drthp_diag_core                         : coring of HP for Diag                                                         . unsigned  , default = 4   
#define PK_DRTFB_BP_CORING                         ((0x3192  << 2) + 0xd0100000)
//Bit 31:22,        reserved                           
//Bit 21:16,        reg_drtbp_horz_core                         : coring of HP for Horz                                                         . unsigned  , default = 4   
//Bit 15:14,        reserved                           
//Bit 13: 8,        reg_drtbp_vert_core                         : coring of HP for Vert                                                         . unsigned  , default = 4   
//Bit  7: 6,        reserved                           
//Bit  5: 0,        reg_drtbp_diag_core                         : coring of HP for Diag                                                         . unsigned  , default = 4   
#define PK_CIRFB_BLEND_GAIN                        ((0x3193  << 2) + 0xd0100000)
//Bit 31:28,        reg_hp_cir_hgain                            : normalized 8 as '1'                                                           . unsigned  , default = 8   
//Bit 27:24,        reg_hp_cir_vgain                            : normalized 8 as '1'                                                           . unsigned  , default = 8   
//Bit 23:20,        reg_hp_cir_dgain                            : normalized 8 as '1'                                                           . unsigned  , default = 8   
//Bit 19:16,        reserved                           
//Bit 15:12,        reg_bp_cir_hgain                            : normalized 8 as '1'                                                           . unsigned  , default = 8   
//Bit 11: 8,        reg_bp_cir_vgain                            : normalized 8 as '1'                                                           . unsigned  , default = 8   
//Bit  7: 4,        reg_bp_cir_dgain                            : normalized 8 as '1'                                                           . unsigned  , default = 8   
//Bit  3: 0,        reserved                           
#define NR_ALPY_SSD_GAIN_OFST                      ((0x3194  << 2) + 0xd0100000)
//Bit 31:16,        reserved                           
//Bit 15: 8,        reg_nr_alp0_ssd_gain                        : gain to max ssd normalized 16 as '1'                                          . unsigned  , default = 16  
//Bit  7: 6,        reserved                           
//Bit  5: 0,        reg_nr_alp0_ssd_ofst                        : offset to ssd before dividing to min_err                                      . signed    , default = -2  
#define NR_ALP0Y_ERR2CURV_TH_RATE                  ((0x3195  << 2) + 0xd0100000)
//Bit 31:24,        reg_nr_alp0_minerr_ypar0                    : threshold0 of curve to map mierr to alp0 for luma channel, this will be set value of flat region mierr that no need blur. 0~255.. unsigned  , default = 10  
//Bit 23:16,        reg_nr_alp0_minerr_ypar1                    : threshold1 of curve to map mierr to alp0 for luma channel,this will be set value of texture region mierr that can not blur.. unsigned  , default = 25  
//Bit 15: 8,        reg_nr_alp0_minerr_ypar5                    : rate0 (for mierr<th0) of curve to map mierr to alp0 for luma channel. the larger of the value, the deep of the slope. 0~255.. unsigned  , default = 80  
//Bit  7: 0,        reg_nr_alp0_minerr_ypar6                    : rate1 (for mierr>th1) of curve to map mierr to alp0 for luma channel. the larger of the value, the deep of the slope. 0~255.. unsigned  , default = 64  
#define NR_ALP0Y_ERR2CURV_LIMIT                    ((0x3196  << 2) + 0xd0100000)
//Bit 31:24,        reg_nr_alp0_minerr_ypar2                    : level limit(for mierr<th0) of curve to map mierr to alp0 for luma channel, this will be set to alp0 that we can do for flat region. 0~255.. unsigned  , default = 63  
//Bit 23:16,        reg_nr_alp0_minerr_ypar3                    : level limit(for th0<mierr<th1) of curve to map mierr to alp0 for luma channel, this will be set to alp0 that we can do for misc region. 0~255.. unsigned  , default = 0   
//Bit 15: 8,        reg_nr_alp0_minerr_ypar4                    : level limit(for mierr>th1) of curve to map mierr to alp0 for luma channel, this will be set to alp0 that we can do for texture region. 0~255.. unsigned  , default = 63  
//Bit  7: 0,        reserved                           
#define NR_ALP0C_ERR2CURV_TH_RATE                  ((0x3197  << 2) + 0xd0100000)
//Bit 31:24,        reg_nr_alp0_minerr_cpar0                    : threshold0 of curve to map mierr to alp0 for chroma channel, this will be set value of flat region mierr that no need blur.. unsigned  , default = 10  
//Bit 23:16,        reg_nr_alp0_minerr_cpar1                    : threshold1 of curve to map mierr to alp0 for chroma channel,this will be set value of texture region mierr that can not blur.. unsigned  , default = 25  
//Bit 15: 8,        reg_nr_alp0_minerr_cpar5                    : rate0 (for mierr<th0) of curve to map mierr to alp0 for chroma channel. the larger of the value, the deep of the slope. 0~255.. unsigned  , default = 80  
//Bit  7: 0,        reg_nr_alp0_minerr_cpar6                    : rate1 (for mierr>th1) of curve to map mierr to alp0 for chroma channel. the larger of the value, the deep of the slope. 0~255.. unsigned  , default = 64  
#define NR_ALP0C_ERR2CURV_LIMIT                    ((0x3198  << 2) + 0xd0100000)
//Bit 31:24,        reg_nr_alp0_minerr_cpar2                    : level limit(for mierr<th0) of curve to map mierr to alp0 for chroma channel, this will be set to alp0 that we can do for flat region. 0~255.. unsigned  , default = 63  
//Bit 23:16,        reg_nr_alp0_minerr_cpar3                    : level limit(for th0<mierr<th1) of curve to map mierr to alp0 for chroma channel, this will be set to alp0 that we can do for misc region. 0~255.. unsigned  , default = 0   
//Bit 15: 8,        reg_nr_alp0_minerr_cpar4                    : level limit(for mierr>th1) of curve to map mierr to alp0 for chroma channel, this will be set to alp0 that we can do for texture region. 0~255.. unsigned  , default = 63  
//Bit  7: 0,        reserved                           
#define NR_ALP0_MIN_MAX                            ((0x3199  << 2) + 0xd0100000)
//Bit 31:30,        reserved                           
//Bit 29:24,        reg_nr_alp0_ymin                            : normalized to 64 as '1'                                                       . unsigned  , default = 2   
//Bit 23:22,        reserved                           
//Bit 21:16,        reg_nr_alp0_ymax                            : normalized to 64 as '1'                                                       . unsigned  , default = 63  
//Bit 15:14,        reserved                           
//Bit 13: 8,        reg_nr_alp0_cmin                            : normalized to 64 as '1'                                                       . unsigned  , default = 2   
//Bit  7: 6,        reserved                           
//Bit  5: 0,        reg_nr_alp0_cmax                            : normalized to 64 as '1'                                                       . unsigned  , default = 63  
#define NR_ALP1_MIERR_CORING                       ((0x319a  << 2) + 0xd0100000)
//Bit 31:17,        reserved                           
//Bit 16,            reg_nr_alp1_maxerr_mode                     : 0 max err; 1: xerr                                                            . unsigned  , default = 0   
//Bit 15:14,        reserved                           
//Bit 13: 8,        reg_nr_alp1_core_rate                       : normalized 64 as "1"                                                          . unsigned  , default = 0   
//Bit  7: 6,        reserved                           
//Bit  5: 0,        reg_nr_alp1_core_ofst                       : normalized 64 as "1"                                                          . signed    , default = 3   
#define NR_ALP1_ERR2CURV_TH_RATE                   ((0x319b  << 2) + 0xd0100000)
//Bit 31:24,        reg_nr_alp1_minerr_par0                     : threshold0 of curve to map mierr to alp1 for luma/chroma channel, this will be set value of flat region mierr that no need directional NR. 0~255.. unsigned  , default = 0   
//Bit 23:16,        reg_nr_alp1_minerr_par1                     : threshold1 of curve to map mierr to alp1 for luma/chroma  channel,this will be set value of texture region mierr that can not do directional NR. 0~255.. unsigned  , default = 24  
//Bit 15: 8,        reg_nr_alp1_minerr_par5                     : rate0 (for mierr<th0) of curve to map mierr to alp1 for luma/chroma  channel. the larger of the value, the deep of the slope.. unsigned  , default = 0   
//Bit  7: 0,        reg_nr_alp1_minerr_par6                     : rate1 (for mierr>th1) of curve to map mierr to alp1 for luma/chroma  channel. the larger of the value, the deep of the slope. 0~255. unsigned  , default = 20  
#define NR_ALP1_ERR2CURV_LIMIT                     ((0x319c  << 2) + 0xd0100000)
//Bit 31:24,        reg_nr_alp1_minerr_par2                     : level limit(for mierr<th0) of curve to map mierr to alp1 for luma/chroma  channel, this will be set to alp1 that we can do for flat region. 0~255.. unsigned  , default = 0   
//Bit 23:16,        reg_nr_alp1_minerr_par3                     : level limit(for th0<mierr<th1) of curve to map mierr to alp1 for luma/chroma  channel, this will be set to alp1 that we can do for misc region. 0~255.. unsigned  , default = 16  
//Bit 15: 8,        reg_nr_alp1_minerr_par4                     : level limit(for mierr>th1) of curve to map mierr to alp1 for luma/chroma  channel, this will be set to alp1 that we can do for texture region. 0~255.255 before. unsigned  , default = 63  
//Bit  7: 0,        reserved                           
#define NR_ALP1_MIN_MAX                            ((0x319d  << 2) + 0xd0100000)
//Bit 31:30,        reserved                           
//Bit 29:24,        reg_nr_alp1_ymin                            : normalized to 64 as '1'                                                       . unsigned  , default = 0   
//Bit 23:22,        reserved                           
//Bit 21:16,        reg_nr_alp1_ymax                            : normalized to 64 as '1'                                                       . unsigned  , default = 63  
//Bit 15:14,        reserved                           
//Bit 13: 8,        reg_nr_alp1_cmin                            : normalized to 64 as '1'                                                       . unsigned  , default = 0   
//Bit  7: 6,        reserved                           
//Bit  5: 0,        reg_nr_alp1_cmax                            : normalized to 64 as '1'                                                       . unsigned  , default = 63  
#define PK_ALP2_MIERR_CORING                       ((0x319e  << 2) + 0xd0100000)
//Bit 31:17,        reserved                           
//Bit 16,            reg_pk_alp2_maxerr_mode                     : 0 max err; 1: xerr                                                            . unsigned  , default = 1   
//Bit 15:14,        reserved                           
//Bit 13: 8,        reg_pk_alp2_core_rate                       : normalized 64 as "1"                                                          . unsigned  , default = 13  
//Bit  7: 6,        reserved                           
//Bit  5: 0,        reg_pk_alp2_core_ofst                       : normalized 64 as "1"                                                          . signed    , default = 1   
#define PK_ALP2_ERR2CURV_TH_RATE                   ((0x319f  << 2) + 0xd0100000)
//Bit 31:24,        reg_pk_alp2_minerr_par0                     : threshold0 of curve to map mierr to alp2 for luma channel, this will be set value of flat region mierr that no need peaking.. unsigned  , default = 0   
//Bit 23:16,        reg_pk_alp2_minerr_par1                     : threshold1 of curve to map mierr to alp2 for luma  channel,this will be set value of texture region mierr that can not do peaking. 0~255.. unsigned  , default = 24  
//Bit 15: 8,        reg_pk_alp2_minerr_par5                     : rate0 (for mierr<th0) of curve to map mierr to alp2 for luma  channel. the larger of the value, the deep of the slope. 0~255.. unsigned  , default = 0   
//Bit  7: 0,        reg_pk_alp2_minerr_par6                     : rate1 (for mierr>th1) of curve to map mierr to alp2 for luma  channel. the larger of the value, the deep of the slope. 0~255.. unsigned  , default = 20  
#define PK_ALP2_ERR2CURV_LIMIT                     ((0x31a0  << 2) + 0xd0100000)
//Bit 31:24,        reg_pk_alp2_minerr_par2                     : level limit(for mierr<th0) of curve to map mierr to alp2 for luma  channel, this will be set to alp2 that we can do for flat region. 0~255.. unsigned  , default = 0   
//Bit 23:16,        reg_pk_alp2_minerr_par3                     : level limit(for th0<mierr<th1) of curve to map mierr to alp2 for luma  channel, this will be set to alp2 that we can do for misc region. 0~255.. unsigned  , default = 16  
//Bit 15: 8,        reg_pk_alp2_minerr_par4                     : level limit(for mierr>th1) of curve to map mierr to alp2 for luma  channel, this will be set to alp2 that we can do for texture region. 0~255. default = 63;. unsigned  , default = 255 
//Bit  7: 0,        reserved                           
#define PK_ALP2_MIN_MAX                            ((0x31a1  << 2) + 0xd0100000)
//Bit 31:14,        reserved                           
//Bit 13: 8,        reg_pk_alp2_min                             : normalized to 64 as '1'                                                       . unsigned  , default = 0   
//Bit  7: 6,        reserved                           
//Bit  5: 0,        reg_pk_alp2_max                             : normalized to 64 as '1'                                                       . unsigned  , default = 63  
#define PK_FINALGAIN_HP_BP                         ((0x31a2  << 2) + 0xd0100000)
//Bit 31:16,        reserved                           
//Bit 15: 8,        reg_hp_final_gain                           : gain to highpass boost result (including directional/circle blending), normalized 32 as '1', 0~255. 1.25 * 32. unsigned  , default = 40  
//Bit  7: 0,        reg_bp_final_gain                           : gain to bandpass boost result (including directional/circle blending), normalized 32 as '1', 0~255. 1.25 * 32. unsigned  , default = 30  
#define PK_OS_HORZ_CORE_GAIN                       ((0x31a3  << 2) + 0xd0100000)
//Bit 31:24,        reg_pk_os_hsidecore                         : side coring (not to current pixel) to adaptive overshoot margin in horizontal direction. the larger of this value, the less overshoot admitted 0~255;. unsigned  , default = 8   
//Bit 23:16,        reg_pk_os_hsidegain                         : side gain (not to current pixel) to adaptive overshoot margin in horizontal direction. normalized to 32 as '1'. 0~255;. unsigned  , default = 20  
//Bit 15: 8,        reg_pk_os_hmidcore                          : midd coring (to current pixel) to adaptive overshoot margin in horizontal direction. the larger of this value, the less overshoot admitted 0~255;. unsigned  , default = 2   
//Bit  7: 0,        reg_pk_os_hmidgain                          : midd gain (to current pixel) to adaptive overshoot margin in horizontal direction. normalized to 32 as '1'. 0~255;. unsigned  , default = 20  
#define PK_OS_VERT_CORE_GAIN                       ((0x31a4  << 2) + 0xd0100000)
//Bit 31:24,        reg_pk_os_vsidecore                         : side coring (not to current pixel) to adaptive overshoot margin in vertical direction. the larger of this value, the less overshoot admitted 0~255;. unsigned  , default = 8   
//Bit 23:16,        reg_pk_os_vsidegain                         : side gain (not to current pixel) to adaptive overshoot margin in vertical direction. normalized to 32 as '1'. 0~255;. unsigned  , default = 20  
//Bit 15: 8,        reg_pk_os_vmidcore                          : midd coring (to current pixel) to adaptive overshoot margin in vertical direction. the larger of this value, the less overshoot admitted 0~255;. unsigned  , default = 2   
//Bit  7: 0,        reg_pk_os_vmidgain                          : midd gain (to current pixel) to adaptive overshoot margin in vertical direction. normalized to 32 as '1'. 0~255;. unsigned  , default = 20  
#define PK_OS_ADPT_MISC                            ((0x31a5  << 2) + 0xd0100000)
//Bit 31:24,        reg_pk_os_minerr_core                       : coring to minerr for adaptive overshoot margin. the larger of this value, the less overshoot admitted 0~255;. unsigned  , default = 40  
//Bit 23:16,        reg_pk_os_minerr_gain                       : gain to minerr based adaptive overshoot margin. normalized to 64 as '1'. 0~255;. unsigned  , default = 6   
//Bit 15: 8,        reg_pk_os_adpt_max                          : maximum limit adaptive overshoot margin (4x). 0~255;                          . unsigned  , default = 200 
//Bit  7: 0,        reg_pk_os_adpt_min                          : minimun limit adaptive overshoot margin (1x). 0~255;                          . unsigned  , default = 20  
#define PK_OS_STATIC                               ((0x31a6  << 2) + 0xd0100000)
//Bit 31:30,        reserved                           
//Bit 29:28,        reg_pk_osh_mode                             : 0~3: (2x+1) window in H direction                                             . unsigned  , default = 2   
//Bit 27:26,        reserved                           
//Bit 25:24,        reg_pk_osv_mode                             : 0~3: (2x+1) window in V direction                                             . unsigned  , default = 2   
//Bit 23:22,        reserved                           
//Bit 21:12,        reg_pk_os_down                              : static negative overshoot margin. 0~1023;                                     . unsigned  , default = 200 
//Bit 11:10,        reserved                           
//Bit  9: 0,        reg_pk_os_up                                : static positive overshoot margin. 0~1023;                                     . unsigned  , default = 200 
#define PK_NR_ENABLE                               ((0x31a7  << 2) + 0xd0100000)
//Bit 31: 4,        reserved                           
//Bit  3: 2,        reg_3d_mode                                 , 0: no 3D; 1: L/R; 2: T/B; 3: horizontal interleaved, dft = 0                                             //. unsigned  , default = 0   
//Bit  1,            reg_pk_en                                                                                                                   . unsigned  , default = 1   
//Bit  0,            reg_nr_en                                                                                                                   . unsigned  , default = 1   
#define PK_DRT_SAD_MISC                            ((0x31a8  << 2) + 0xd0100000)
//Bit 31:24,        reg_pk_sad_ver_gain                         : gain to sad[4], 16 normalized to "1";                                         . unsigned  , default = 24  
//Bit 23:16,        reg_pk_sad_hor_gain                         : gain to sad[0], 16 normalized to "1";                                         . unsigned  , default = 24  
//Bit 15:11,        reserved                           
//Bit 10: 9,        reg_pk_bias_diag                            : bias towards diag                                                             . unsigned  , default = 0   
//Bit  8,            reg_pk_debug_edge                           : show color for edge                                                           . unsigned  , default = 0   
//Bit  7: 5,        reserved                           
//Bit  4: 0,        reg_pk_drt_force                            : force direction of drt peaking filter, h2b: 0:hp drt force, 1: bp drt force; 2: bp+hp drt force, 3: no force;. unsigned  , default = 24  
#define NR_TI_DNLP_BLEND                           ((0x31a9  << 2) + 0xd0100000)
//Bit 31:11,        reserved                           
//Bit 10: 8,        reg_dnlp_input_mode                         : dnlp input options. 0: org_y; 1: gau_y; 2: gauadp_y; 3: edgadplpf_y; 4: nr_y;5: lti_y; 6: pk_y (before os);7: pk_y (after os). unsigned  , default = 4   
//Bit  7: 4,        reserved                           
//Bit  3: 2,        reg_nr_cti_blend_mode                       : blend mode of nr and lti result: 0: nr; 1:cti; 2: (nr+cti)/2; 3:cti + dlt_nr  . unsigned  , default = 1   
//Bit  1: 0,        reg_nr_lti_blend_mode                       : blend mode of nr and lti result: 0: nr; 1:lti; 2: (nr+lti)/2; 3:lti + dlt_nr  . unsigned  , default = 1   
////////////////////////////////////////////////////////////////////////////////
// new ti regsters from here
////////////////////////////////////////////////////////////////////////////////
#define LTI_DIR_CORE_ALPHA                         ((0x31aa  << 2) + 0xd0100000)
//Bit 31:30,        reserved                           
//Bit 29:24,        reg_adp_lti_dir_alp_core_ofst               : ofst to min_err, alpha = (min_err - (max_err-min_err)*rate + ofst)/max_err*64;    dft=10. unsigned  , default = 10  
//Bit 23:20,        reserved                           
//Bit 19:16,        reg_adp_lti_dir_alp_core_rate               : ofset to min_err, alpha = (min_err - (max_err-min_err)*rate + ofst)/max_err*64;   dft=0/32. unsigned  , default = 0   
//Bit 15:14,        reserved                           
//Bit 13: 8,        reg_adp_lti_dir_alpmin                      : min value of alpha, alpha = (min_err+x +ofst)/max_err*64; dft=10              . unsigned  , default = 0   
//Bit  7: 6,        reserved                           
//Bit  5: 0,        reg_adp_lti_dir_alpmax                      : max value of alpha, alpha = (min_err+x +ofst)/max_err*64; dft=63              . unsigned  , default = 63  
#define CTI_DIR_ALPHA                              ((0x31ab  << 2) + 0xd0100000)
//Bit 31:30,        reserved                           
//Bit 29:24,        reg_adp_cti_dir_alp_core_ofst               : ofst to min_err, alpha = (min_err - (max_err-min_err)*rate + ofst)/max_err*64;    dft=10. unsigned  , default = 5   
//Bit 23:20,        reserved                           
//Bit 19:16,        reg_adp_cti_dir_alp_core_rate               : ofset to min_err, alpha = (min_err - (max_err-min_err)*rate + ofst)/max_err*64;   dft=0/32. unsigned  , default = 0   
//Bit 15:14,        reserved                           
//Bit 13: 8,        reg_adp_cti_dir_alpmin                      : min value of alpha, alpha = (min_err +x+ofst)/max_err*64;  dft=10             . unsigned  , default = 0   
//Bit  7: 6,        reserved                           
//Bit  5: 0,        reg_adp_cti_dir_alpmax                      : max value of alpha, alpha = (min_err +x+ofst)/max_err*64;  dft=63             . unsigned  , default = 63  
#define LTI_CTI_DF_GAIN                            ((0x31ac  << 2) + 0xd0100000)
//Bit 31:30,        reserved                           
//Bit 29:24,        reg_adp_lti_hdf_gain                        : 8 normalized to "1";  default = 16                                            . unsigned  , default = 16  
//Bit 23:22,        reserved                           
//Bit 21:16,        reg_adp_lti_vdf_gain                        : 8 normalized to "1";  default = 12                                            . unsigned  , default = 12  
//Bit 15:14,        reserved                           
//Bit 13: 8,        reg_adp_cti_hdf_gain                        : 8 normalized to "1";  default = 16                                            . unsigned  , default = 16  
//Bit  7: 6,        reserved                           
//Bit  5: 0,        reg_adp_cti_vdf_gain                        : 8 normalized to "1";  default = 12                                            . unsigned  , default = 12  
#define LTI_CTI_DIR_AC_DBG                         ((0x31ad  << 2) + 0xd0100000)
//Bit 31,            reserved                           
//Bit 30,            reg_adp_lti_dir_lpf                         : 0: no lpf; 1: [1 2 2 2 1]/8 lpf                                               . unsigned  , default = 1   
//Bit 29,            reserved                           
//Bit 28,            reg_adp_lti_dir_difmode                     : 0: y_dif; 1: y_dif + (u_dif+v_dif)/2;                                         . unsigned  , default = 0   
//Bit 27,            reserved                           
//Bit 26,            reg_adp_cti_dir_lpf                         : 0: no lpf; 1: [1 2 2 2 1]/8 lpf  dft=1                                        . unsigned  , default = 1   
//Bit 25:24,        reg_adp_cti_dir_difmode                     : 0: (u_dif+v_dif); 1: y_dif/2 + (u_dif+v_dif)*3/4; 2: y_dif + (u_dif+v_dif)/2; 3: y_dif*2 (not recomended). unsigned  , default = 0   
//Bit 23:22,        reg_adp_hvlti_dcblend_mode                  : 0: hlti_dc; 1:vlti_dc; 2: avg  3; blend on alpha                              . unsigned  , default = 3   
//Bit 21:20,        reg_adp_hvcti_dcblend_mode                  : 0: hcti_dc; 1:vcti_dc; 2: avg  3; blend on alpha                              . unsigned  , default = 3   
//Bit 19:18,        reg_adp_hvlti_acblend_mode                  : hlti_ac; 1:vlti_ac; 2: add  3;:adaptive to alpha                              . unsigned  , default = 3   
//Bit 17:16,        reg_adp_hvcti_acblend_mode                  : hcti_ac; 1:vcti_ac; 2: add  3;: adaptive to alpha                             . unsigned  , default = 3   
//Bit 15,            reserved                           
//Bit 14:12,        reg_adp_hlti_debug                          , for hlti debug, default = 0                                                   . unsigned  , default = 0   
//Bit 11,            reserved                           
//Bit 10: 8,        reg_adp_vlti_debug                          , for vlti debug, default = 0                                                   . unsigned  , default = 0   
//Bit  7,            reserved                           
//Bit  6: 4,        reg_adp_hcti_debug                          , for hcti debug, default = 0                                                   . unsigned  , default = 0   
//Bit  3,            reserved                           
//Bit  2: 0,        reg_adp_vcti_debug                          , for vcti debug, default = 0                                                   . unsigned  , default = 0   
#define HCTI_FLT_CLP_DC                            ((0x31ae  << 2) + 0xd0100000)
//Bit 31:29,        reserved                           
//Bit 28,            reg_adp_hcti_en                             , 0: no cti, 1: new cti, default = 1                                            . unsigned  , default = 1   
//Bit 27:26,        reg_adp_hcti_vdn_flt                        , 0: no lpf; 1:[0,2,4,2,0],  2 : [1 2 2 2 1]/8  3:[1 0 2 0 1]/4, default = 3    . unsigned  , default = 3   
//Bit 25:24,        reg_adp_hcti_hdn_flt                        , 0: no lpf; 1:[0, 0, 0, 4, 8, 4, 0, 0, 0], 2:[0, 0, 2, 4, 4, 4, 2, 0, 0], 3: [1, 2, 2, 2, 2, 2, 2, 2, 1], default = 2. unsigned  , default = 2   
//Bit 23:22,        reg_adp_hcti_ddn_flt                        , 0: no lpf; 1:[0,2,4,2,0],  2 : [1 2 2 2 1]/8 3:[1 0 2 0 1]/4, default = 3     . unsigned  , default = 3   
//Bit 21:20,        reg_adp_hcti_lpf0_flt                       , 0:no filter; 1:sigma=0.75, 2: sigma = 1.0, 3: sigma = 1.5, default = 2        . unsigned  , default = 2   
//Bit 19:18,        reg_adp_hcti_lpf1_flt                       , 0:no filter; 1:sigma= 2.0, 2: sigma = 3.0, 3: sigma = 4.0, default = 2        . unsigned  , default = 2   
//Bit 17:16,        reg_adp_hcti_lpf2_flt                       , 0:no filter; 1:sigma=5.0,  2: sigma = 9.0, 3: sigma = 13.0, default = 2       . unsigned  , default = 2   
//Bit 15:12,        reg_adp_hcti_hard_clp_win                   , window size, 0~8, default = 7                                                 . unsigned  , default = 7   
//Bit 11: 8,        reg_adp_hcti_hard_win_min                   , window size, 0~8, default = 3                                                 . unsigned  , default = 3   
//Bit  7: 5,        reserved                           
//Bit  4,            reg_adp_hcti_clp_mode                       , 0: hard clip, 1: adaptive clip, default = 1                                   . unsigned  , default = 1   
//Bit  3,            reserved                           
//Bit  2: 0,        reg_adp_hcti_dc_mode                        , 0:dn, 1:lpf0, 2:lpf1, 3:lpf2, 4: lpf3: 5: vdn result; 6/7:org, default = 0    . unsigned  , default = 0   
#define HCTI_BST_GAIN                              ((0x31af  << 2) + 0xd0100000)
//Bit 31:24,        reg_adp_hcti_bst_gain0                      : gain of the bandpass 0 (lpf1-lpf2)- LBP, default = 80                         . unsigned  , default = 80  
//Bit 23:16,        reg_adp_hcti_bst_gain1                      : gain of the bandpass 1 (lpf0-lpf1)- BP, default = 96                          . unsigned  , default = 96  
//Bit 15: 8,        reg_adp_hcti_bst_gain2                      : gain of the bandpass 2 (hdn-lpf0)-  HP, default = 64                          . unsigned  , default = 64  
//Bit  7: 0,        reg_adp_hcti_bst_gain3                      : gain of the unsharp band (yuvin-hdn) - US, default = 16                       . unsigned  , default = 16  
#define HCTI_BST_CORE                              ((0x31b0  << 2) + 0xd0100000)
//Bit 31:24,        reg_adp_hcti_bst_core0                      : core of the bandpass 0 (lpf1-lpf2)- LBP, default = 0                          . unsigned  , default = 0   
//Bit 23:16,        reg_adp_hcti_bst_core1                      : core of the bandpass 1 (lpf0-lpf1)- BP, default = 0                           . unsigned  , default = 0   
//Bit 15: 8,        reg_adp_hcti_bst_core2                      : core of the bandpass 2 (hdn-lpf0)-  HP, default = 0                           . unsigned  , default = 0   
//Bit  7: 0,        reg_adp_hcti_bst_core3                      : core of the unsharp band (yuvin-hdn) - US, default = 0                        . unsigned  , default = 0   
#define HCTI_CON_2_GAIN_0                          ((0x31b1  << 2) + 0xd0100000)
//Bit 31:29,        reg_adp_hcti_con_mode                       : con mode 0:[0, 0,-1, 1, 0, 0, 0]+[0, 0, 0, 1,-1, 0, 0], 1: [0, 0,-1, 0, 1, 0, 0], 2: [0,-1, 0, 0, 0, 1, 0], 3:[-1, 0, 0, 0, 0, 0, 1], 4: .... default = 2. unsigned  , default = 2   
//Bit 28:26,        reg_adp_hcti_dx_mode                        : dx mode 0: [-1 1 0]; 1~7: [-1 (2x+1)"0" 1], default = 3                       . unsigned  , default = 3   
//Bit 25:24,        reg_adp_hcti_con_lpf                        : lpf mode of the con: 0: [1 2 1]/4; 1:[1 2 2 2 1]/8, default = 1               . unsigned  , default = 1   
//Bit 23:16,        reg_adp_hcti_con_2_gain0                    , default = 25                                                                  . unsigned  , default = 25  
//Bit 15: 8,        reg_adp_hcti_con_2_gain1                    , default = 60                                                                  . unsigned  , default = 60  
//Bit  7: 0,        reg_adp_hcti_con_2_gain2                    0;, default = 0                                                                 . unsigned  , default = 0   
#define HCTI_CON_2_GAIN_1                          ((0x31b2  << 2) + 0xd0100000)
//Bit 31:24,        reg_adp_hcti_con_2_gain3                    96;, default = 96                                                               . unsigned  , default = 96  
//Bit 23:16,        reg_adp_hcti_con_2_gain4                    5;, default = 5                                                                 . unsigned  , default = 5   
//Bit 15: 8,        reg_adp_hcti_con_2_gain5                    80;, default = 80                                                               . unsigned  , default = 80  
//Bit  7: 0,        reg_adp_hcti_con_2_gain6                    20;, default = 20                                                               . unsigned  , default = 20  
#define HCTI_OS_MARGIN                             ((0x31b3  << 2) + 0xd0100000)
//Bit 31: 8,        reserved                           
//Bit  7: 0,        reg_adp_hcti_os_margin                      : margin for hcti overshoot, default = 0                                        . unsigned  , default = 0   
#define HLTI_FLT_CLP_DC                            ((0x31b4  << 2) + 0xd0100000)
//Bit 31:29,        reserved                           
//Bit 28,            reg_adp_hlti_en                             , 0: no cti, 1: new cti, default = 1                                            . unsigned  , default = 1   
//Bit 27:26,        reg_adp_hlti_vdn_flt                        , 0: no lpf; 1:[0,2,4,2,0],   2 : [1 2 2 2 1]/8 3:[1 0 2 0 1]/4, default = 2    . unsigned  , default = 2   
//Bit 25:24,        reg_adp_hlti_hdn_flt                        , 0: no lpf; 1:[0, 0, 0, 4, 8, 4, 0, 0, 0], 2:[0, 0, 2, 4, 4, 4, 2, 0, 0], 3: [1, 2, 2, 2, 2, 2, 2, 2, 1], default = 2. unsigned  , default = 2   
//Bit 23:22,        reg_adp_hlti_ddn_flt                        , 0: no lpf; 1:[0,2,4,2,0],   2 : [1 2 2 2 1]/8 3:[1 0 2 0 1]/4, default = 2    . unsigned  , default = 2   
//Bit 21:20,        reg_adp_hlti_lpf0_flt                       , 0:no filter; 1:sigma=0.75, 2: sigma = 1.0, 3: sigma = 1.5, default = 2        . unsigned  , default = 2   
//Bit 19:18,        reg_adp_hlti_lpf1_flt                       , 0:no filter; 1:sigma= 2.0, 2: sigma = 3.0, 3: sigma = 4.0, default = 2        . unsigned  , default = 2   
//Bit 17:16,        reg_adp_hlti_lpf2_flt                       , 0:no filter; 1:sigma=5.0,  2: sigma = 9.0, 3: sigma = 13.0, default = 2       . unsigned  , default = 2   
//Bit 15:12,        reg_adp_hlti_hard_clp_win                   , window size, 0~8, default = 2                                                 . unsigned  , default = 2   
//Bit 11: 8,        reg_adp_hlti_hard_win_min                   , window size, 0~8, default = 1                                                 . unsigned  , default = 1   
//Bit  7: 5,        reserved                           
//Bit  4,            reg_adp_hlti_clp_mode                       , 0: hard clip, 1: adaptive clip, default = 0                                   . unsigned  , default = 0   
//Bit  3,            reserved                           
//Bit  2: 0,        reg_adp_hlti_dc_mode                        , 0:dn, 1:lpf0, 2:lpf1, 3:lpf2, 4: lpf3: 5: vdn result; 6/7:org, default = 4    . unsigned  , default = 4   
#define HLTI_BST_GAIN                              ((0x31b5  << 2) + 0xd0100000)
//Bit 31:24,        reg_adp_hlti_bst_gain0                      : gain of the bandpass 0 (lpf1-lpf2)- LBP, default = 40                         . unsigned  , default = 40  
//Bit 23:16,        reg_adp_hlti_bst_gain1                      : gain of the bandpass 1 (lpf0-lpf1)- BP, default = 48                          . unsigned  , default = 48  
//Bit 15: 8,        reg_adp_hlti_bst_gain2                      : gain of the bandpass 2 (hdn-lpf0)-  HP, default = 32                          . unsigned  , default = 32  
//Bit  7: 0,        reg_adp_hlti_bst_gain3                      : gain of the unsharp band (yuvin-hdn) - US, default = 16                       . unsigned  , default = 16  
#define HLTI_BST_CORE                              ((0x31b6  << 2) + 0xd0100000)
//Bit 31:24,        reg_adp_hlti_bst_core0                      : core of the bandpass 0 (lpf1-lpf2)- LBP, default = 5                          . unsigned  , default = 5   
//Bit 23:16,        reg_adp_hlti_bst_core1                      : core of the bandpass 1 (lpf0-lpf1)- BP, default = 5                           . unsigned  , default = 5   
//Bit 15: 8,        reg_adp_hlti_bst_core2                      : core of the bandpass 2 (hdn-lpf0)-  HP, default = 5                           . unsigned  , default = 5   
//Bit  7: 0,        reg_adp_hlti_bst_core3                      : core of the unsharp band (yuvin-hdn) - US, default = 3                        . unsigned  , default = 3   
#define HLTI_CON_2_GAIN_0                          ((0x31b7  << 2) + 0xd0100000)
//Bit 31:29,        reg_adp_hlti_con_mode                       : con mode 0:[0, 0,-1, 1, 0, 0, 0]+[0, 0, 0, 1,-1, 0, 0], 1: [0, 0,-1, 0, 1, 0, 0], 2: [0,-1, 0, 0, 0, 1, 0], 3:[-1, 0, 0, 0, 0, 0, 1], 4: ....., default = 2. unsigned  , default = 2   
//Bit 28:26,        reg_adp_hlti_dx_mode                        : dx mode 0: [-1 1 0]; 1~7: [-1 (2x+1)"0" 1], default = 3                       . unsigned  , default = 3   
//Bit 25:24,        reg_adp_hlti_con_lpf                        : lpf mode of the con: 0: [1 2 1]/4; 1:[1 2 2 2 1]/8, default = 1               . unsigned  , default = 1   
//Bit 23:16,        reg_adp_hlti_con_2_gain0                    25;, default = 25                                                               . unsigned  , default = 25  
//Bit 15: 8,        reg_adp_hlti_con_2_gain1                    60;, default = 60                                                               . unsigned  , default = 60  
//Bit  7: 0,        reg_adp_hlti_con_2_gain2                    0;, default = 90                                                                . unsigned  , default = 90  
#define HLTI_CON_2_GAIN_1                          ((0x31b8  << 2) + 0xd0100000)
//Bit 31:24,        reg_adp_hlti_con_2_gain3                    96;, default = 96                                                               . unsigned  , default = 96  
//Bit 23:16,        reg_adp_hlti_con_2_gain4                    5;, default = 95                                                                . unsigned  , default = 95  
//Bit 15: 8,        reg_adp_hlti_con_2_gain5                    80;, default = 80                                                               . unsigned  , default = 80  
//Bit  7: 0,        reg_adp_hlti_con_2_gain6                    20;, default = 20                                                               . unsigned  , default = 20  
#define HLTI_OS_MARGIN                             ((0x31b9  << 2) + 0xd0100000)
//Bit 31: 8,        reserved                           
//Bit  7: 0,        reg_adp_hlti_os_margin                      : margin for hlti overshoot, default = 0                                        . unsigned  , default = 0   
#define VLTI_FLT_CON_CLP                           ((0x31ba  << 2) + 0xd0100000)
//Bit 31:15,        reserved                           
//Bit 14,            reg_adp_vlti_en                             : enable bit of vlti, default = 1                                               . unsigned  , default = 1   
//Bit 13:12,        reg_adp_vlti_hxn_flt                        : 0: no dn; 1: [1 2 1]/4;  2 : [1 2 2 2 1]/8 3:[1 0 2 0 1]/4, default = 3       . unsigned  , default = 3   
//Bit 11:10,        reg_adp_vlti_dxn_flt                        : 0: no dn; 1: [1 2 1]/4;  2 : [1 2 2 2 1]/8 3:[1 0 2 0 1]/4, default = 3       . unsigned  , default = 3   
//Bit  9: 8,        reg_adp_vlti_han_flt                        : 0: no dn; 1: [1 2 1]/4;  2 : [1 2 2 2 1]/8 3:[1 0 2 0 1]/4, default = 3       . unsigned  , default = 3   
//Bit  7: 6,        reg_adp_vlti_dan_flt                        : 0: no dn; 1: [1 2 1]/4;  2 : [1 2 2 2 1]/8 3:[1 0 2 0 1]/4, default = 3       . unsigned  , default = 3   
//Bit  5: 4,        reg_adp_vlti_dx_mode                        : 0:[-1 1] 1:[-1 0 -1]; 2/3: [-1 0 0 0 -1], default = 2                         . unsigned  , default = 2   
//Bit  3,            reserved                           
//Bit  2,            reg_adp_vlti_con_lpf                        : lpf mode of the con: 0: [1 2 1]/4; 1:[1 2 2 2 1]/8, default = 1               . unsigned  , default = 1   
//Bit  1,            reserved                           
//Bit  0,            reg_adp_vlti_hard_clp_win                   : window size; 0: 1x3 window; 1: 1x5 window, default = 1                        . unsigned  , default = 1   
#define VLTI_BST_GAIN                              ((0x31bb  << 2) + 0xd0100000)
//Bit 31:24,        reserved                           
//Bit 23:16,        reg_adp_vlti_bst_gain0                      : gain to boost filter [-1 2 -1];, default = 32                                 . unsigned  , default = 32  
//Bit 15: 8,        reg_adp_vlti_bst_gain1                      : gain to boost filter [-1 0 2 0 -1];, default = 32                             . unsigned  , default = 32  
//Bit  7: 0,        reg_adp_vlti_bst_gain2                      : gain to boost filter usf, default = 32                                        . unsigned  , default = 32  
#define VLTI_BST_CORE                              ((0x31bc  << 2) + 0xd0100000)
//Bit 31:24,        reserved                           
//Bit 23:16,        reg_adp_vlti_bst_core0                      : coring to boost filter [-1 2 -1];, default = 5                                . unsigned  , default = 5   
//Bit 15: 8,        reg_adp_vlti_bst_core1                      : coring to boost filter [-1 0 2 0 -1];, default = 5                            . unsigned  , default = 5   
//Bit  7: 0,        reg_adp_vlti_bst_core2                      : coring to boost filter usf, default = 3                                       . unsigned  , default = 3   
#define VLTI_CON_2_GAIN_0                          ((0x31bd  << 2) + 0xd0100000)
//Bit 31:24,        reg_adp_vlti_con_2_gain0                    25;, default = 25                                                               . unsigned  , default = 25  
//Bit 23:16,        reg_adp_vlti_con_2_gain1                    60;, default = 69                                                               . unsigned  , default = 60  
//Bit 15: 8,        reg_adp_vlti_con_2_gain2                    0;, default = 90                                                                . unsigned  , default = 90  
//Bit  7: 0,        reg_adp_vlti_con_2_gain3                    96;, default = 96                                                               . unsigned  , default = 96  
#define VLTI_CON_2_GAIN_1                          ((0x31be  << 2) + 0xd0100000)
//Bit 31:24,        reg_adp_vlti_con_2_gain4                    5;, default = 95                                                                . unsigned  , default = 95  
//Bit 23:16,        reg_adp_vlti_con_2_gain5                    80;, default = 80                                                               . unsigned  , default = 80  
//Bit 15: 8,        reg_adp_vlti_con_2_gain6                    20;, default = 20                                                               . unsigned  , default = 20  
//Bit  7: 0,        reg_adp_vlti_os_margin                      : margin for vlti overshoot, default = 0                                        . unsigned  , default = 0   
#define VCTI_FLT_CON_CLP                           ((0x31bf  << 2) + 0xd0100000)
//Bit 31:15,        reserved                           
//Bit 14,            reg_adp_vcti_en                             : enable bit of vlti, default = 1                                               . unsigned  , default = 1   
//Bit 13:12,        reg_adp_vcti_hxn_flt                        : 0: no dn; 1: [1 2 1]/4;  2 : [1 2 2 2 1]/8 3:[1 0 2 0 1]/4, default = 3       . unsigned  , default = 3   
//Bit 11:10,        reg_adp_vcti_dxn_flt                        : 0: no dn; 1: [1 2 1]/4;  2 : [1 2 2 2 1]/8 3:[1 0 2 0 1]/4, default = 3       . unsigned  , default = 3   
//Bit  9: 8,        reg_adp_vcti_han_flt                        : 0: no dn; 1: [1 2 1]/4;  2 : [1 2 2 2 1]/8 3:[1 0 2 0 1]/4, default = 3       . unsigned  , default = 3   
//Bit  7: 6,        reg_adp_vcti_dan_flt                        : 0: no dn; 1: [1 2 1]/4;  2 : [1 2 2 2 1]/8 3:[1 0 2 0 1]/4, default = 3       . unsigned  , default = 3   
//Bit  5: 4,        reg_adp_vcti_dx_mode                        : 0:[-1 1] 1:[-1 0 -1]; 2/3: [-1 0 0 0 -1], default = 2                         . unsigned  , default = 2   
//Bit  3,            reserved                           
//Bit  2,            reg_adp_vcti_con_lpf                        : lpf mode of the con: 0: [1 2 1]/4; 1:[1 2 2 2 1]/8, default = 1               . unsigned  , default = 1   
//Bit  1,            reserved                           
//Bit  0,            reg_adp_vcti_hard_clp_win                   : window size; 0: 1x3 window; 1: 1x5 window, default = 1                        . unsigned  , default = 1   
#define VCTI_BST_GAIN                              ((0x31c0  << 2) + 0xd0100000)
//Bit 31:24,        reserved                           
//Bit 23:16,        reg_adp_vcti_bst_gain0                      : gain to boost filter [-1 2 -1];, default = 0                                  . unsigned  , default = 0   
//Bit 15: 8,        reg_adp_vcti_bst_gain1                      : gain to boost filter [-1 0 2 0 -1];, default = 0                              . unsigned  , default = 0   
//Bit  7: 0,        reg_adp_vcti_bst_gain2                      : gain to boost filter usf, default = 0                                         . unsigned  , default = 0   
#define VCTI_BST_CORE                              ((0x31c1  << 2) + 0xd0100000)
//Bit 31:24,        reserved                           
//Bit 23:16,        reg_adp_vcti_bst_core0                      : coring to boost filter [-1 2 -1];, default = 0                                . unsigned  , default = 0   
//Bit 15: 8,        reg_adp_vcti_bst_core1                      : coring to boost filter [-1 0 2 0 -1];, default = 0                            . unsigned  , default = 0   
//Bit  7: 0,        reg_adp_vcti_bst_core2                      : coring to boost filter usf, default = 0                                       . unsigned  , default = 0   
#define VCTI_CON_2_GAIN_0                          ((0x31c2  << 2) + 0xd0100000)
//Bit 31:24,        reg_adp_vcti_con_2_gain0                    25;, default = 25                                                               . unsigned  , default = 25  
//Bit 23:16,        reg_adp_vcti_con_2_gain1                    60;, default = 60                                                               . unsigned  , default = 60  
//Bit 15: 8,        reg_adp_vcti_con_2_gain2                    0;, default = 90                                                                . unsigned  , default = 90  
//Bit  7: 0,        reg_adp_vcti_con_2_gain3                    96;, default = 96                                                               . unsigned  , default = 96  
#define VCTI_CON_2_GAIN_1                          ((0x31c3  << 2) + 0xd0100000)
//Bit 31:24,        reg_adp_vcti_con_2_gain4                    5;, default = 95                                                                . unsigned  , default = 95  
//Bit 23:16,        reg_adp_vcti_con_2_gain5                    80;, default = 80                                                               . unsigned  , default = 80  
//Bit 15: 8,        reg_adp_vcti_con_2_gain6                    20;, default = 20                                                               . unsigned  , default = 20  
//Bit  7: 0,        reg_adp_vcti_os_margin                      : margin for vcti overshoot, default = 0                                        . unsigned  , default = 0   
#define SHARP_3DLIMIT                              ((0x31c4  << 2) + 0xd0100000)
//Bit 31:29,        reserved                           
//Bit 28:16,        reg_3d_mid_width                            ,width of left part of 3d input, dft = half size of input width  default = 0    . unsigned  , default = 960 
//Bit 15:13,        reserved                           
//Bit 12: 0,        reg_3d_mid_height                           ,height of left part of 3d input, dft = half size of input height  default = 0  . unsigned  , default = 540 
#define DNLP_EN                                    ((0x31c5  << 2) + 0xd0100000)
//Bit 31: 1,        reserved                           
//Bit  0,            reg_dnlp_en                                                                                                                 . unsigned  , default = 1   
#define DNLP_00                                    ((0x31c6  << 2) + 0xd0100000)
//Bit 31: 0,        reg_dnlp_ygrid0                             : dnlp00                                                                        . unsigned  , default = 32'h08060402
#define DNLP_01                                    ((0x31c7  << 2) + 0xd0100000)
//Bit 31: 0,        reg_dnlp_ygrid1                             : dnlp01                                                                        . unsigned  , default = 32'h100e0c0a
#define DNLP_02                                    ((0x31c8  << 2) + 0xd0100000)
//Bit 31: 0,        reg_dnlp_ygrid2                             : dnlp02                                                                        . unsigned  , default = 32'h1a171412
#define DNLP_03                                    ((0x31c9  << 2) + 0xd0100000)
//Bit 31: 0,        reg_dnlp_ygrid3                             : dnlp03                                                                        . unsigned  , default = 32'h2824201d
#define DNLP_04                                    ((0x31ca  << 2) + 0xd0100000)
//Bit 31: 0,        reg_dnlp_ygrid4                             : dnlp04                                                                        . unsigned  , default = 32'h3834302c
#define DNLP_05                                    ((0x31cb  << 2) + 0xd0100000)
//Bit 31: 0,        reg_dnlp_ygrid5                             : dnlp05                                                                        . unsigned  , default = 32'h4b45403c
#define DNLP_06                                    ((0x31cc  << 2) + 0xd0100000)
//Bit 31: 0,        reg_dnlp_ygrid6                             : dnlp06                                                                        . unsigned  , default = 32'h605b5550
#define DNLP_07                                    ((0x31cd  << 2) + 0xd0100000)
//Bit 31: 0,        reg_dnlp_ygrid7                             : dnlp07                                                                        . unsigned  , default = 32'h80787068
#define DNLP_08                                    ((0x31ce  << 2) + 0xd0100000)
//Bit 31: 0,        reg_dnlp_ygrid8                             : dnlp08                                                                        . unsigned  , default = 32'ha0989088
#define DNLP_09                                    ((0x31cf  << 2) + 0xd0100000)
//Bit 31: 0,        reg_dnlp_ygrid9                             : dnlp09                                                                        . unsigned  , default = 32'hb8b2aca6
#define DNLP_10                                    ((0x31d0  << 2) + 0xd0100000)
//Bit 31: 0,        reg_dnlp_ygrid10                            : dnlp10                                                                        . unsigned  , default = 32'hc8c4c0bc
#define DNLP_11                                    ((0x31d1  << 2) + 0xd0100000)
//Bit 31: 0,        reg_dnlp_ygrid11                            : dnlp11                                                                        . unsigned  , default = 32'hd4d2cecb
#define DNLP_12                                    ((0x31d2  << 2) + 0xd0100000)
//Bit 31: 0,        reg_dnlp_ygrid12                            : dnlp12                                                                        . unsigned  , default = 32'hdad8d7d6
#define DNLP_13                                    ((0x31d3  << 2) + 0xd0100000)
//Bit 31: 0,        reg_dnlp_ygrid13                            : dnlp13                                                                        . unsigned  , default = 32'he2e0dedc
#define DNLP_14                                    ((0x31d4  << 2) + 0xd0100000)
//Bit 31: 0,        reg_dnlp_ygrid14                            : dnlp14                                                                        . unsigned  , default = 32'hf0ece8e4
#define DNLP_15                                    ((0x31d5  << 2) + 0xd0100000)
//Bit 31: 0,        reg_dnlp_ygrid15                            : dnlp15                                                                        . unsigned  , default = 32'hfffcf8f4
#define DEMO_CRTL                                  ((0x31d6  << 2) + 0xd0100000)
//Bit 31:19,        reserved                           
//Bit 18:17,        demo_disp_position                                                                                                          . unsigned  , default = 2   
//Bit 16,            demo_hsvsharp_enable                                                                                                        . unsigned  , default = 0   
//Bit 15:13,        reserved                           
//Bit 12: 0,        demo_left_top_screen_width                  :                                                                               . unsigned  , default = 360 
// synopsys translate_off
// synopsys translate_on
//
// Closing file:  sharp_regs.h
//
// synopsys translate_off
// synopsys translate_on
//
// Closing file:  ./vcbus_regs.h
//

#include "no_enct.h"

#endif // REGISTER_H

