#!/bin/sh
# This is the script to check and instal ubuntu system.
# written:	carywu@amlogic.com 
# Update:		2014-8-18
# Version:	1.0
#
#
#########################
# === global config === #
#########################
WORKDIR=`dirname $(readlink -f $0)`

LOGFILE="$WORKDIR/install.log"

DOWNLOAD_URL="http://openlinux.amlogic.com:8000/deploy"

OS_MACHINE=`uname -m`

#########################
#   === function ===    #
#########################



check_root()
{
	if [ "$(id -u)" != "0" ]; then
	echo "
>_>	!! This script must be run as root !!!
>_>	USAGE: please use command: sudo su - change to account root if your account is sudo user
>_>	or use command: su - root change to account root if it's not a sudo user
>_>	Script will exit, you need run it again" 1>&2
	exit 1
	fi
}

check_OS()
{
	if [ "$OS_MACHINE" = "x86_64" ]; then
	echo "OK~~~your OS is 64bit...script will keep going"
	else
	echo "
>_>	Sorry, Please use 64bit Ubuntu 12.04 only !!
>_>	WHY?
>_>	64bit version is need,I dont wanna use 32bit OS
>_>	I will exit, sorry~~ "
	exit 1
	fi
}

change_sourcelist()
{
	echo "Going to check your OS version....."
	OS_NUMBER=`cat /etc/lsb-release  |grep RELEASE |awk -F "=" '{print $2}'`
	if [ "$OS_NUMBER" != "12.04" ]; then
	echo "
>_>	Sorry, Please use Ubuntu 12.04 64bit version only !!
>_>	WHY?
>_>	Because I suggest we can have the same version,Sorry!! :-) "
	exit 1
	fi

}
	
install_software()
{
	echo "We are going to do apt-get update..... please wait......"
	add-apt-repository -y ppa:rayanayar/cryptsetup
	apt-get update
	echo "############################################################"
	echo "#####       going to install samba,nfs,vim             #####"
	echo "############################################################"
	apt-get install -y automake make perl gcc g++ 
	apt-get install -y nfs-kernel-server vim autofs
	apt-get install -y gcc-4.4 g++-4.4 gcc-4.4-multilib 
	apt-get install -y cryptsetup cryptsetup-bin libcryptsetup-dev uuid-dev libdevmapper-dev libpopt-dev
}
config_software()
{
	

	echo "############################################################"
	echo "#####       going to install gnutools, arm gcc         #####"
	echo "############################################################"
	if [ -f /usr/bin/wget ];then
	if [ -d /opt/CodeSourcery ];then
	echo "ERROR 1: 
Hello, there is folder CodeSourcery under /opt, System will not download files from $DOWNLOAD_URL
if you still need download it, please download from $DOWNLOAD_URL/CodeSourcery.tar.gz" >> $LOGFILE
	else
	wget --continue $DOWNLOAD_URL/CodeSourcery.tar.gz -P /tmp/
	tar -zxvf /tmp/CodeSourcery.tar.gz -C /opt
	fi

	if [ -d /opt/gcc-linaro-aarch64-linux-gnu-4.9-2014.09_linux ];then
	echo "ERROR 1: 
Hello,System will not download files from $DOWNLOAD_URL
if you still need download it, please download from $DOWNLOAD_URL/gcc-linaro-aarch64-linux-gnu-4.9-2014.09_linux.tar" >> $LOGFILE
	else
	wget --continue $DOWNLOAD_URL/gcc-linaro-aarch64-linux-gnu-4.9-2014.09_linux.tar -P /tmp/
	tar -xvf /tmp/gcc-linaro-aarch64-linux-gnu-4.9-2014.09_linux.tar -C /opt
	fi

	if [ -d /opt/gcc-linaro-aarch64-none-elf-4.8-2013.11_linux ];then
	echo "ERROR 1: 
Hello,System will not download files from $DOWNLOAD_URL
if you still need download it, please download from $DOWNLOAD_URL/gcc-linaro-aarch64-none-elf-4.8-2013.11_linux.tar" >> $LOGFILE
	else
	wget --continue $DOWNLOAD_URL/gcc-linaro-aarch64-none-elf-4.8-2013.11_linux.tar -P /tmp/
	tar -xvf /tmp/gcc-linaro-aarch64-none-elf-4.8-2013.11_linux.tar -C /opt
	fi

	if [ -d /opt/gcc-linaro-arm-linux-gnueabihf ];then
	echo "
ERROR 2: 
Hello, there is folder gcc-linaro-arm-linux-gnueabihf under /opt, System will not download files from $DOWNLOAD_URL
if you still need download it, please download from $DOWNLOAD_URL/gcc-linaro-arm-linux-gnueabihf.tar.gz" >> $LOGFILE
	else
	wget --continue $DOWNLOAD_URL/gcc-linaro-arm-linux-gnueabihf.tar.gz -P /tmp/
	tar -zxvf /tmp/gcc-linaro-arm-linux-gnueabihf.tar.gz -C /opt
	fi
	if [ -d /opt/gnutools ];then
	echo "
ERROR 3: 
Hello, there is folder gcc-linaro-arm-linux-gnueabihf under /opt, System will not download files from $DOWNLOAD_URL
if you still need download it, please download from $DOWNLOAD_URL/gcc-linaro-arm-linux-gnueabihf.tar.gz" >> $LOGFILE
	else

	wget --continue $DOWNLOAD_URL/gnutools.tar.gz -P /tmp
	tar -zxvf /tmp/gnutools.tar.gz -C /opt
	fi
	if [ -d /opt/arc-4.8-amlogic-20130924-r2 ];then
	echo "
ERROR 4: 
Hello, there is folder arc-4.8-amlogic-20130904-r2 under /opt, System will not download files from $DOWNLOAD_URL
if you still need download it, please download from $DOWNLOAD_URL/arc-4.8-amlogic-20130904-r2.tar.gz" >> $LOGFILE
	else
	wget --continue $DOWNLOAD_URL/arc-4.8-amlogic-20130904-r2.tar.gz -P /tmp
	tar -zxvf /tmp/arc-4.8-amlogic-20130904-r2.tar.gz -C /opt
	fi
	if [ ! -f /etc/profile.d/TOOLSENV.sh ];then
	wget $DOWNLOAD_URL/TOOLSENV.sh -P /etc/profile.d
	fi

	wget $DOWNLOAD_URL/repo -P /usr/bin
	
	chmod +x /usr/bin/repo
	chmod +x /etc/profile.d/*.sh

	else
        echo "I can't fint wget --continue command, script need this tool to download tools, please use apt-get install wget --continue firstly"
	exit
	fi

}

install_java()
{
	echo "############################################################"
	echo "#####       going to install sun-java6 and library     #####"
	echo "############################################################"
	apt-get install -y python-software-properties
	add-apt-repository -y ppa:sun-java-community-team/sun-java6
	apt-get update
	### install sun-java6
	apt-get install -y unixodbc java-common 
	### install the library
	   apt-get install -y git-core gnupg flex bison gperf build-essential \
  	   zip curl libc6-dev libncurses5-dev:i386 x11proto-core-dev \
  	   libx11-dev:i386 libreadline6-dev:i386 libgl1-mesa-dev:i386 \
  	   g++-multilib mingw32 tofrodos python-markdown libxml2-utils xsltproc zlib1g-dev:i386
	
	   ln -s /usr/lib/i386-linux-gnu/mesa/libGL.so.1 /usr/lib/i386-linux-gnu/libGL.so
	   rm /usr/bin/gcc 
	   ln -s /usr/bin/gcc-4.4 /usr/bin/gcc
	   rm /usr/bin/g++
	   ln -s /usr/bin/g++-4.4 /usr/bin/g++

	## Going to download sun-java6 26 version...
	echo "I am going to download sun java version 26 to /tmp..."
	wget --continue http://openlinux.amlogic.com:8000/deploy/java/sun-java6-bin_6.26-2lucid1_amd64.deb -P /tmp/
	wget --continue http://openlinux.amlogic.com:8000/deploy/java/sun-java6-jdk_6.26-2lucid1_amd64.deb -P /tmp/
	wget --continue http://openlinux.amlogic.com:8000/deploy/java/sun-java6-jre_6.26-2lucid1_all.deb -P /tmp/

	if [ -f /tmp/sun-java6-bin_6.26-2lucid1_amd64.deb ]; then
	   dpkg -i /tmp/sun-java6-*
	else
	echo "Sorry, not find sun java software"
	fi
	apt-get -f install

}

install_x_desktop()
{
	echo "############################################################"
	echo "#####       going to install ubuntu desktop software   #####"
	echo "############################################################"

	apt-get install -y ubuntu-desktop

}

timing()
{
	echo  "\aJust please wait for 30 seconds....\r"

	for i in $(seq 30|tac);do
           echo -n "${i}."
           sleep 1
	done

}

###TODO####
### NOT START BY NOW ####
check_software()
{
	if [ ! -f /tmp/software.list ]
	then
	wget --continue http://openlinux.amlogic.com:8000/deploy/software.list -P /tmp
	fi

	SOFTLIST=/tmp/software.list
	SOFT=`cat $SOFTLIST`
	for soft in $SOFT
	do
	apt-get install -y $soft 
	done
}

reboot_machine()
{
	echo "############################################################"
	echo "#####       going to reboot machine		     #####"
	echo "############################################################"

	echo "I will reboot machine after 30s... you can type ctrl+c to cancel it..."
	timing
	shutdown -r now
}

echo "
####################################################################################################
# writer: cary.wu@amlogic.com
# Owner:  Amlogic IT group
# Date:	  2012-10-11
#
# README:
# This is a simple script help setup the Android build environment automatically..after done
# your ubuntu will have the same tools and library as Amlogic servers...
# This script will only support Ubuntu 12.04 OS and no other choose now..please make sure
# your OS version is 12.04 Ubuntu 64bit, Thank you!
# 
# script will download tools and save them to /opt directory...
# script will create new shell script to /etc/profile.d/ directory...
# 
#
# !!ATTENTION!!
# please make sure you have root permission, script need root permission and do some system 
# change...
# Please dont use this script on a running important server, although it will not delete any data
# but I dont suggest you use it..
#
# USAGE:
# very simple! just use "sh deploy_ubuntu_12.04.sh" or "./deploy_ubuntu_12.04.sh" YEAH!!
#
###################################################################################################
 "

while read -p "Please type yes if you will go ahead[yes|no]:  " ANSWER
do
  if [ -z $ANSWER ];then
  continue
  fi
  
  case $ANSWER in 
  yes|YES|y)
	check_root
	check_OS
	change_sourcelist
	install_software
	config_software
	install_x_desktop
	install_java
	check_software
	reboot_machine
   ;;
  no|NO|n)
     echo "I will quit...Thank you!!"
      break;;
  *)
      continue
      ;;
  esac

done
